c     as of june 22, 1987 this file contains
c     bound, ebdreg, gvec, pbound, blddfl, blddfu, bldrhs, prml,
c     prmlct, svdiv, evalbd, bndwsp
c
      subroutine bound(a,b,ldab,m,n,irstrt,icstrt,dimreg,
     +                 evala,evalb,edlmax,gvcond,pqnorm,ecase,
     +                 sdlmax, difl, difu, qnorm, pnorm, scase, 
     +                 work, info)
c
c     implicit none
c
c**** debug space
      common /debug2/ idbg(20), outunit
      integer idbg, outunit
c
c**** formal parameter declarations
      integer ldab,m,n,irstrt,icstrt,dimreg,info,ecase,scase
      complex*16 a(ldab,*), b(ldab,*), evala(*),evalb(*)
      complex*16 work(*)
      real*8 gvcond(*), edlmax, sdlmax, qnorm, pnorm, pqnorm
      real*8 difl, difu
c
c********************************************************************
c
c     compute error bounds for selected eigenvalues of general pencil
c     and error bounds for left and right reducing subspaces
c
c     this version requires all selected eigenvalues be simple
c     input pencil a - lambda b must be in guptri form
c
c     theorems and corollaries referred to below appear in:
c     'accurate solutions of ill-posed problems in control theory'
c     proc. of the 25th ieee conference on decision and control,
c     athens, greece, december 10-12, 1986, pp 558-563
c     by j. demmel and b. kagstrom
c
c     see also:
c     j. demmel and b. kagstrom, 'computing stable eigendecompositions
c        of matrix pencils', linear algebra and its applications,
c        vol 88/89, 1987, pp 139-185
c
c     inputs
c
c       a(ldab,n), b(ldab,n) - complex*16 - input pencil in 
c                                           guptri form
c
c       lda - integer - leading dimension of a and b
c
c       m,n - integer - row, column dimensions of a and b
c
c       irstrt, icstrt - integer - starting row and column of selected 
c                        part of pencil for which eigenvalue bounds 
c                        are desired. reducing subspace bounds will be
c                        supplied for right reducing subspace spanned
c                        by leading icstrt-1 components and for left
c                        reducing subspace spanned by leading icstrt-1
c                        components.
c                        note: set icstrt=n+1 to make right reducing
c                                  subspace whole space
c                              set irstrt=m+1 to make left reducing
c                                  subspace whole space
c
c       dimreg - integer - number of selected eigenvalues;
c         if dimreg.eq.0 only subspace perturbation bounds will be
c         computed
c        (note - one can select a subset of the regular part only;
c         this gives generally different bounds for common eigenvalues
c         from a different selected subset; see paper above for 
c         discussion)
c
c     outputs
c
c       evala(dimreg), evalb(dimreg) - complex*16 - 
c          normalized selected eigenvalues;
c          evala(i)/evalb(i) is i-th eigenvalue and
c          abs(evala(i))**2 + abs(evalb(i))**2 = 1
c
c       edlmax - real*8 - maximum frobenius norm of perturbation for 
c                which eigenvalue perturbation bounds hold. 
c                if no maximum norm then edlmax=-1.
c
c       gvcond(dimreg) - real*8 - condition numbers; suppose the pencil
c         is perturbed by amount delta .le. edlmax (if edlmax=-1. then
c         delta arbitrary) such that the conditions of theorem 5 or 
c         corollary 1 hold (edlmax=-1. implies these conditions always
c         hold). then if c/s is a perturbed eigenvalue such that
c         abs(c)**2 + abs(s)**2 = 1, then for some i
c         abs(c*evalb(i)-s*evala(i)) .le. delta * gvcond(i)
c
c       pqnorm - real*8 - overall condition number; under same 
c         conditions as for gvcond, if areg - lambda breg is regular 
c         part of unperturbed pencil in guptri form, then
c         sigma-min(c*breg - s*areg) .le. delta * pqnorm
c         (sigma-min is the smallest singular value)
c
c       ecase - integer - which of 5 cases for eigenvalue bounds 
c               the pencil falls depending on input dimensions;
c               the first four cases are for dimreg.gt.0, in which
c               case the description gives:
c                  (part of KCF to above, left of selected part) and
c                  (part of KCF to below, right of selected part) 
c          ecase=1 - (right singular and/or regular part) and
c                    (left singular and/or regular part)
c          ecase=2 - (right singular and/or regular part) and (nothing)
c          ecase=3 - (nothing) and (left singular and/or regular part)
c          ecase=4 - (nothing) and (nothing)
c          ecase=5 - dimreg.eq.0 (no eigenvalue bounds)
c
c       sdlmax - real*8 - maximum frobenius norm of perturbation for 
c                which reducing subspace perturbation bounds hold
c                (if scase=4 (see below) sdlmax=-1. to indicate that
c                 this bound does not apply)
c
c       difl, difu - real*8 - difl and difu functions (used to
c                    compute sdlmax, see paper for details)
c                    (if scase=4 (see below), both set to 0)
c
c       qnorm, pnorm, - real*8 - norms of left and right projectors
c                       (used in reducing subspace bounds)
c                       (if scase=4 (see below), both set to 1)
c
c       scase - integer - which of 4 cases for reducing subspace
c               bounds the pencil falls depending on input dimensions:
c          scase=1 - both left and right subspaces nontrivial
c          scase=2 - left space trivial (0) and right space nontrivial
c          scase=3 - left space nontrivial and right space trivial
c                   (whole space)
c          scase=4 - both spaces trivial (either 0 or whole space)
c
c       the reducing subspace bounds may be calculated from 
c          scase, sdlmax, pnorm and qnorm as follows:
c          let delta be the distance in the frobenius norm from a
c          perturbed pencil with the same structure as a - lambda b
c          to a - lambda b (see the above paper by demmel and
c          kagstrom for more details). if delta.lt.sdlmax then the
c          following bounds apply, where relerr=delta/sdlmax :
c
c          upper bound on angular perturbation in left reducing subspace
c            if scase=1 (theorem 4, case 1 in paper)
c              atan(relerr/(pnorm-relerr*sqrt(pnorm**2-1)))
c            if scase=2
c              0 (since left subspace trivial)
c            if scase=3
c              atan(relerr/(1-relerr))
c            if scase=4
c              0 (since left subspace trivial)
c
c          upper bound on angular perturbation in right reducing subspace
c            if scase=1 (theorem 4, case 1 in paper)
c              atan(relerr/(qnorm-relerr*sqrt(qnorm**2-1)))
c            if scase=2
c              atan(relerr/(1-relerr))
c            if scase=3
c              0 (since right subspace trivial)
c            if scase=4
c              0 (since right subspace trivial)
c
c          lower bound on angular perturbation in left reducing subspace
c            if scase=1 (theorem 4, case 2 in paper)
c              atan(1/(sqrt(2*min(irstrt-1,m-irstrt+1))*pnorm +
c                   sqrt(pnorm**2-1)))
c            if scase=2 this bound does not apply
c            if scase=3 this bound does not apply
c            if scase=4 this bound does not apply
c
c          lower bound on angular perturbation in right reducing subspace
c            if scase=1 (theorem 4, case 2 in paper)
c              atan(1/(sqrt(2*min(icstrt-1,n-icstrt+1))*qnorm +
c                   sqrt(qnorm**2-1)))
c            if scase=2 this bound does not apply
c            if scase=3 this bound does not apply
c            if scase=4 this bound does not apply
c
c         (note: given scase, sdlmax, pnorm, qnorm, m, n, icstrt, irstrt
c          and delta (the frobenius norm of a perturbation), subroutine
c          evalbd will compute the above upper and lower subspace bounds)
c
c       info - integer - 0 if normal return
c                        1 if svd error in difu calculation in pbound
c                        2 if difu=0 in pbound
c                        3 if svd error in difl calculation in pbound
c                        4 if difl=0 in pbound
c                        5 if multiple eigenvalues
c                        6 if inconsistent input dimensions
c
c     workspace
c       work(*) - complex*16 - exact amount is complicated function of 
c                 input dimensions and depends on ecase, and computed
c                 as follows:
c
c                    irend=irstrt+dimreg-1; icend=icstrt+dimreg-1;
c       if ecase=1 - m11=irstrt-1; m21=m-m11; n11=icstrt-1; n21=n-n11;
c                    m12=irend-irstrt+1; m22=m-irend; 
c                    n12=icend-icstrt+1; n22=n-icend;
c                    workspace = max( (2*n21*m11*(n11*n21+m11*m21+
c                                     2*n21*m11+2)+n11*n21+m11*m21) ,
c                                     (2*((m21*n11+1)*(n11*n21+
c                                     m11*m21+1)-1)) ,
c                                     (2*n22*m12*(n12*n22+m12*m22+
c                                     2*n22*m12+2)+n12*n22+m12*m22) ,
c                                     (2*((m22*n12+1)*(n12*n22+
c                                     m12*m22+1)-1)) )
c       if ecase=2 or ecase=5 - 
c                    m11=irstrt-1; m21=m-m11; n11=icstrt-1; n21=n-n11;
c                    workspace = max( (2*n21*m11*(n11*n21+m11*m21+
c                                    2*n21*m11+2)+n11*n21+m11*m21) ,
c                                    (2*((m21*n11+1)*(n11*n21+
c                                    m11*m21+1)-1)) )
c       if ecase=3 - m11=irend; m21=m-m11; n11=icend; n21=n-icend;
c                    workspace = max( (2*n21*m11*(n11*n21+m11*m21+
c                                    2*n21*m11+2)+n11*n21+m11*m21) ,
c                                    (2*((m21*n11+1)*(n11*n21+
c                                    m11*m21+1)-1)) )
c       if ecase=4 - workspace = n*n
c
c       the following simple expression bounds the workspace also, but
c          may occasionally be much too large (especially if ecase=4):
c            workspace .le. 2*m*n* (n*n + m*m + 2*n + m + 2) + n*n + m*m
c*********************************************************************
c
c**** this version dated 16 june 1987
c     authors: jim demmel and bo kagstrom
c    
c     addresses:
c             jim demmel, courant institute, 251 mercer str, 
c                 new york, new york 10012, usa
c                 electronic address: demmel at nyu.edu or
c                                     na.demmel at score.stanford.edu
c              bo kagstrom, institute of information processing,
c                 university of umea, s-90187 umea, sweden
c                 electronic address: bokg at seumdc51.bitnet or
c                                     na.kagstrom at score.stanford.edu
c
c**** bound uses the following functions and subroutines
c        pbound, ebdreg, cmatpr (debug only), gvec, dznrm2 (blas),
c        blddfu, blddfl, bldrhs, prml, prmlct, svdiv, zsvdc (linpack)
c 
c**** internal variables
      integer irend,icend,idummy,i
      real*8 rdummy, difu1, difu2, difl1, difl2, pnorm1, pnorm2
      real*8 qnorm1, qnorm2, pdelta1, pdelta2, delta
c
c     test input dimensions for consistency
      info = 0
      if (irstrt.gt.icstrt .or. irstrt.le.0 .or.
     +    n-icstrt-dimreg.gt.m-irstrt-dimreg .or.
     +    n-icstrt-dimreg+1.lt.0 .or. dimreg.lt.0) then
c       inconsistent input dimensions
        info = 6
        return
      endif
      icend = icstrt+dimreg-1
      irend = irstrt+dimreg-1
      delta = 0.
c
      if (dimreg.gt.0) then
c       there are eigenvalue bounds to compute
c
c       ecase 1 - in addition to selected regular part KCF has
c       (right singular part and/or regular part) and
c       (left singular part and/or regular part)   
        if (icstrt.ne.1 .and. irend.ne.m) then
          ecase = 1
          if (irstrt.eq.1) then
            scase = 2
          else
            scase = 1
          endif
c         see corollary 1 for explanation of bounds
          call pbound(a,b,ldab,m,n,irstrt-1,icstrt-1,
     +                delta,difl1,difu1,qnorm1,pnorm1, pdelta1,
     +                rdummy,rdummy,rdummy,rdummy,idummy,work,info)
          if (info.ne.0) return
          call pbound(a(irstrt,icstrt),b(irstrt,icstrt),ldab,
     +                m-irstrt+1,n-icstrt+1,irend-irstrt+1,
     +                icend-icstrt+1,
     +                delta,difl2,difu2,qnorm2,pnorm2,pdelta2,
     +                rdummy,rdummy,rdummy,rdummy,idummy,work,info)
          if (info.ne.0) return
          edlmax = min (pdelta1, pdelta2/(sqrt(2.)*qnorm1))
          pqnorm = 2.*pnorm2*qnorm1
c
          sdlmax = pdelta1
          pnorm = pnorm1
          qnorm = qnorm1
          difl = difl1
          difu = difu1
        endif
c
c       ecase 2 - in addition to selected regular part KCF has
c                (right singular part and/or regular part) and
c                (nothing)
        if (icstrt.ne.1 .and. irend.eq.m) then
          ecase=2
          if (irstrt.eq.1) then
            scase = 2
          else
            scase = 1
          endif
c         see part 1 of theorem 5 for explanation of bounds
          call pbound(a,b,ldab,m,n,irstrt-1,icstrt-1,delta,difl1,
     +                difu1,qnorm1,pnorm1,pdelta1,rdummy,rdummy,
     +                rdummy,rdummy,idummy,work,info)
          if (info.ne.0) return
          edlmax= pdelta1
          pqnorm=1.
          if (idummy.eq.1) pqnorm=sqrt(2.)*qnorm1
c
          sdlmax = pdelta1
          pnorm = pnorm1
          qnorm = qnorm1
          difl = difl1
          difu = difu1
        endif
c
c       ecase 3 - in addition to selected regular part KCF has
c                (nothing) and
c                (left singular part  and/or regular part)
        if (icstrt.eq.1 .and. irend.ne.m) then
          ecase = 3
          scase = 4
c         see part 2 of theorem 5 for explanation of bounds
          call pbound(a,b,ldab,m,n,irend,icend,
     +                delta,difl2,difu2,qnorm2,pnorm2,pdelta2,
     +                rdummy,rdummy,rdummy,rdummy,idummy,work,info)
          if (info.ne.0) return
          edlmax = pdelta2
          pqnorm = 1.
          if (idummy.eq.1) pqnorm = sqrt(2.)*pnorm2
          difl = 0.
          difu = 0.
          pnorm = 1.
          qnorm = 1.
          sdlmax = -1.
        endif
c
c       ecase 4 - pencil regular and entire spectrum selected
        if (icstrt.eq.1 .and. irend.eq.m) then
          ecase=4
          edlmax=-1.
          pqnorm=1.
c
          scase = 4
          difl = 0.
          difu = 0.
          pnorm = 1.
          qnorm = 1.
          sdlmax = -1.
        endif
c
        call ebdreg(a,b,ldab,irstrt,icstrt,dimreg,
     +              gvcond,evala,evalb,work,info)
        if (info.ne.0) then
          info = 5
          return
        endif
        if (pqnorm.ne.1.) then
          do 1 i=1,dimreg
            gvcond(i)=gvcond(i)*pqnorm
1         continue
        endif
c
      else
c       dimreg.eq.0, so only compute subspace bounds
        ecase = 5
        call pbound(a,b,ldab,m,n,irstrt-1,icstrt-1,
     +              delta,difl,difu,qnorm,pnorm,sdlmax,
     +              rdummy,rdummy,rdummy,rdummy,scase,work,info)
      endif
c
      if (idbg(20).ne.0) then
        write(outunit,100) ldab,m,n,irstrt,icstrt,dimreg,ecase,scase
100     format(' bound - ldab,m,n,irstrt,icstrt,dimreg,ecase,scase=',
     +         /,8i5)
        if (ecase.ne.5) then
          write(outunit,101) edlmax,pqnorm
101       format(' edlmax,pqnorm=',2d15.6,/,' gvcond=')
          write(outunit,102) (gvcond(i),i=1,dimreg)
102       format(5d15.6)
          call cmatpr(work,dimreg,dimreg,dimreg,'gvec')
        endif
        if (scase.ne.4) write(outunit,103) sdlmax,pnorm,qnorm
103     format(' sdlmax,pnorm,qnorm=',3d15.6)
      endif
      return
      end        
c
c
      subroutine ebdreg(a,b,ldab,irstrt,icstrt,dimreg,
     +                  gvcond,evala,evalb,work,info)
c     implicit none
c**** formal parameter declarations
      integer ldab, dimreg, irstrt, icstrt, info
      complex*16 a(ldab,*), b(ldab,*), work(*), evala(*), evalb(*)
      real*8 gvcond(*)
c     
c*****************************************************************
c
c     compute error bounds for eigenvalues of a regular pencil
c     requires all simple eigenvalues
c
c     inputs:
c       a(ldab,*), b(ldab,*) - complex*16 - contain pencil
c       irstrt, icstrt - integer - starting row and column locations
c                        of pencil within a and b
c       dimreg - integer - dimension of regular pencil
c 
c     outputs:
c       evala(dimreg), evalb(dimreg) - complex*16 - normalized 
c                        eigenvalues:
c                        evala(i)/evalb(i) is i-th eigenvalue and
c                        abs(evala(i))**2 + abs(evalb(i))**2 =1
c       gvcond(dimreg) - real*8 - gvcond(i) is condition number of 
c                 i-th eigenvalue where if the pencil is perturbed by 
c                 frobenius norm delta and the perturbed eigenvalue 
c                 is c/s where
c                 abs(c)**2 + abs(s)**2 = 1 then for some i
c                 abs(c*evalb(i) - s*evala(i)) .le. delta * gvcond(i)
c       info - integer - returns 0 (normal) if no multiple eigenvalues, 
c                  else nonzero
c
c     workspace:
c       work(dimreg**2) - complex*16 - work space
c
c***********************************************************************
c
c**** this version dated 16 june 1987
c     authors: jim demmel and bo kagstrom
c
c**** ebdreg uses the following functions and subroutines:
c      gvec
c
c**** internal variables
c
      real*8 scl
      integer i
c
c     compute eigenvectors
      call gvec(a( irstrt , icstrt ),
     +     b( irstrt , icstrt ), ldab,
     +     dimreg , work, dimreg, gvcond, info)
c
c     compute normalized eigenpairs
      do 555 i=1,dimreg
        scl=sqrt(abs(a(irstrt-1+i,icstrt-1+i))**2+
     +           abs(b(irstrt-1+i,icstrt-1+i))**2)
        evala(i) = a(irstrt-1+i,icstrt-1+i)/scl
        evalb(i) = b(irstrt-1+i,icstrt-1+i)/scl
        if (info.eq.0) gvcond(i)= dimreg * gvcond(i) / scl
555   continue
c
      return
      end
c
c
      subroutine gvec(a,b,ldab,n,vec,ldvec,gvcond,info)
c
c     implicit none
c**** debug space
      common /debug2/ idbg(20),outunit
      integer idbg,outunit
      logical ldebug
c**** formal parameter declarations
      integer ldab, n, ldvec, info
      complex*16 a(ldab,*), b(ldab,n), vec(ldvec,*)
      real*8 gvcond(*)
c
c********************************************************************
c
c     compute the left and right eigenvectors of the upper triangular
c     regular pencil a - lambda b
c     compute condition numbers of eigenvalues
c
c     inputs
c       a(ldab,n),b(ldab,n) - complex*16 - n by n matrices
c       ldab - integer - leading dimension of a, b
c       n - integer - dimension of a, b
c       ldvec - integer - leading dimension of vec
c
c       idbg(10) - if idbg(10) ne 0, print debug output
c
c     outputs
c       vec(ldvec,n) - complex*16 -  matrix containing eigenvectors
c             vec(1:i,i) contains the right eigenvector of the i-th
c               eigenvalue, normalized so vec(i,i)=1. the other
c               components of the eigenvector are zero
c             vec(i:n,i) contains the left eigenvector of the i-th
c               eigenvalue, normalized so vec(i,i)=1. the other 
c               components of the eigenvector are zero
c       gvcond(n) - real*8 - array of condition numbers of eigenvalues.
c                if right eigenvectors scaled by diagonal matrix d
c                to have unit norm, scale left eigenvectors by d**-1.
c                then condition number is norm of left eigenvector.
c       info - integer - 0 if pencil regular without multiple eigenvalues
c              nonzero index of a multiple or 0/0 eigenvalue otherwise

c***********************************************************************
c
c**** this version dated 16 june 1987
c     authors: jim demmel and bo kagstrom
c
c**** gvec uses the following external function:
c     dznrm2 (blas)
      real*8 dznrm2
c**** internal variables
      integer nm1, i, im1, im2, j, jp1, k, ip1, ip2, jm1
      complex*16 alpha, beta, diag, cmul, csum
      real*8 ca, cb, dmax, dmin, d 
c
      ldebug=(idbg(10).ne.0)
      info=0
      nm1=n-1
      if (ldebug) write(outunit,99)
99    format(' entering gvec')
      do 1 i=1,n
c
        if (ldebug) write(outunit,100) i
100     format(' i=',i4)
        vec(i,i)=1.
c
c       compute alpha, beta so that zz = beta*a - alpha*b is a
c       singular matrix whose left and right null spaces are the
c       left and right eigenspaces we seek
        ca=abs(a(i,i))
        cb=abs(b(i,i))
        dmax=max(ca,cb)
        if (ldebug) write(outunit,101) a(i,i),b(i,i),ca,cb,dmax
101     format(' a(i,i)=',2d20.5,/,' b(i,i)=',2d20.5,/,' ca=',d20.5,/,
     +  ' cb=',d20.5,/,' dmax=',d20.5)
        if (dmax.eq.0.0) then
c         singular pencil
          info=i
          return
        endif 
        dmin=min(ca,cb)
        d=dmax*sqrt(1+(dmin/dmax)**2)
        alpha = a(i,i)/d
        beta = b(i,i)/d
        if (ldebug) write(outunit,102) dmin,d,alpha,beta
102     format(' dmin=',d20.5,/,' d=',d20.5,/,' alpha=',2d20.5,/,
     +  ' beta=',2d20.5)
c
c       compute right eigenvector
        if (i.ne.1) then
c
c         solve zz(1:i-1,1:i-1) * x = -zz(1:i-1,i) for
c         x = vec(1:i-1,i)
          diag=beta*a(i-1,i-1) - alpha*b(i-1,i-1)
          im1=i-1
          if (ldebug) write(outunit,103) im1,i,diag
103       format(' i,j,diag=',2i4,2d20.5)
          if (abs(diag).eq.0.0) then
c           multiple eigenvalue
            info=i-1
            return
          endif
          vec(i-1,i)=-(beta*a(i-1,i)-alpha*b(i-1,i))/diag
          if (i.ne.2) then
            im1=i-1
            im2=i-2
            do 2 j=im2,1,-1
              diag=beta*a(j,j)-alpha*b(j,j)
              if (ldebug) write(outunit,103) j,i,diag
              if (abs(diag).eq.0.0) then
c               multiple eigenvalue
                info=j
                return
              endif
              csum=-(beta*a(j,i)-alpha*b(j,i))
              jp1=j+1
              do 3 k=jp1,im1
                cmul=beta*a(j,k)-alpha*b(j,k)
                csum=csum-cmul*vec(k,i)
3             continue
              vec(j,i)=csum/diag
2           continue
          endif
        endif
c
c       compute left eigenvector
        if (i.ne.n) then
c         solve xt * zz(i+1:n,i+1:n) = -zz(i,i+1:n) for
c         x = vec(i+1:n,i)
          diag=beta*a(i+1,i+1)-alpha*b(i+1,i+1)
          ip1=i+1
          if (ldebug) write(outunit,103) i,ip1,diag
          if (abs(diag).eq.0.0) then
c           multiple eigenvalue
            info=i
            return
          endif
          vec(i+1,i)=-(beta*a(i,i+1)-alpha*b(i,i+1))/diag
          if (i.ne.nm1) then
            ip1=i+1
            ip2=i+2
            do 4 j=ip2,n
              diag=beta*a(j,j)-alpha*b(j,j)
              if (ldebug) write(outunit,103) i,j,diag
              if (abs(diag).eq.0.0) then
c               multiple eigenvalue
                info=i
                return
              endif
              csum=-(beta*a(i,j)-alpha*b(i,j))
              jm1=j-1
              do 5 k=ip1,jm1
                cmul=beta*a(k,j)-alpha*b(k,j)
                csum=csum-cmul*vec(k,i)
5             continue
              vec(j,i)=csum/diag
4           continue
          endif
        endif
1     continue
c
c     compute condition numbers
      do 6 i=1,n
        gvcond(i)=dznrm2(i,vec(1,i),1)*dznrm2(n-i+1,vec(i,i),1)
6     continue
      return
      end
c
      subroutine pbound(a,b,ldab,m,n,rowred,colred,delta,difl,difu,
     +    qnorm,pnorm,pdelta,lbndup,rbndup,lbndlw,rbndlw,scase,work,
     +    ierr)
c
c     implicit none
c
c**** formal parameter declarations
      integer ldab,m,n,rowred,colred,ierr,scase
      complex*16 a(ldab,*),b(ldab,*),work(*)
      real*8 delta,difl,difu,qnorm,pnorm,pdelta,lbndup,rbndup
      real*8 lbndlw, rbndlw
c
c*******************************************************************
c
c     compute perturbation bounds for reducing subspaces of
c     singular pencil a - lambda b
c     assume a - lambda b has been reduced to generalized upper
c     triangular form by guptri
c     need rowred .le. colred and n-colred .le. m-rowred
c       as implied by generalized upper triangular form
c
c     there are 4 cases, depending on dimension:
c
c      case 1: 0 .lt. rowred and 0 .lt. n-colred so that
c        both left and right reducing subspaces nontrivial
c
c      case 2: if rowred=0 and 0 .lt. colred .lt. n then left reducing
c        subspace 0 but right one nontrivial and bounds exist for it
c
c      case 3: if colred=n and 0 .lt. rowred .lt. m then right reducing
c        subspace is entire space but left one nontrivial with bounds
c
c      case 4: if ( (rowred=0 and colred=0) or
c                   (rowred=0 and colred=n) or
c                   (rowred=m and colred=n) ) then
c              both left and right subspaces trivial
c
c     inputs:
c
c       a(ldab,n),b(ldab,n) - complex*16 - m by n matrices
c
c       ldab - integer - leading dimension of a and b
c
c       m,n - integer - dimensions of a and b
c
c       rowred,colred - integer - number of rows and columns in 
c             (1,1) position of a,b.  dimensions of desired left 
c             and right reducing subspaces
c
c       delta - real*8 - distance of perturbed pencil from a - lambda b 
c
c       idbg(9) - integer - if idbg(9) ne 0, print debug output
c
c     outputs: (described in more detail in 
c       'accurate solutions of ill-posed problems in control theory'
c       25th conference on decision and control, 
c       j. demmel and b. kagstrom
c
c       difl - real*8 - difl function (in case 4, difl=0)
c
c       difu - real*8 - difu function (in case 4, difu=0)
c
c       qnorm - real*8 - right projector norm ( sqrt(r0**2+1) )
c                        (in case 4, qnorm=1.)
c
c       pnorm - real*8 - left projector norm ( sqrt(l0**2+1) )
c                        (in case 4, prnorm=1.)
c
c       pdelta - real*8 - radius of ball around a - lambda b within 
c                which perturbation bounds hold (in case 4, pdelta=-1.
c                to show pdelta does not apply). if delta.ge.pdelta, 
c                the following bounds are set to -1. the following
c                outputs are given in terms of relerr = delta/pdelta
c
c       lbndup - real*8 - upper bound on angular perturbation in left 
c                reducing subspace (case 1 of theorem 4 of above paper)
c                 in case 1: 
c                  lbndup=atan(relerr/(pnorm-relerr*sqrt(pnorm**2-1)))
c                 in case 2:
c                  lbndup=0
c                 in case 3:
c                  lbndup=atan(relerr/(1-relerr))
c                 in case 4: 
c                  lbndup=0
c
c       rbndup - real*8 - upper bound on angular perturbation in right 
c                reducing subspace (case 1 of theorem 4)
c                 in case 1:
c                  rbndup=atan(relerr/(qnorm-relerr*sqrt(qnorm**2-1)))
c                 in case 2:
c                  rbndup=atan(relerr/(1-relerr))
c                 in case 3:
c                  rbndup=0
c                 in case 4: 
c                  rbndup=0
c
c       lbndlw - real*8 - lower bound on angular perturbation in left 
c                reducing subspace (case 2 of theorem 4)
c                 in case 1:
c                  lbndlw=atan(1/(sqrt(2*min(rowred,m-rowred))*pnorm +
c                         sqrt(pnorm**2-1)))
c                 in case 2: lbndlw=-1 since this bound does not apply
c                 in case 3: lbndlw=-1 since this bound does not apply
c                 in case 4: lbndlw=-1 since this bound does not apply
c
c       rbndlw - real*8 - lower bound on angular perturbation in right
c                reducing subspace (case 2 of theorem 4)
c                 in case 1:
c                  rbndlw=atan(1/(sqrt(2*min(colred,n-colred))*qnorm +
c                         sqrt(qnorm**2-1)))
c                 in case 2: rbndlw=-1 since this bound does not apply
c                 in case 3: rbndlw=-1 since this bound does not apply
c                 in case 4: rbndlw=-1 since this bound does not apply
c
c       scase - integer - 1, 2, 3 or 4 as described above
c
c       ierr - integer - error flag
c              0 means no error (normal return)
c              1 means error in svd of difu
c              2 means difu = 0
c              3 means error in svd of difl
c              4 means difl = 0
c              5 means bad rowred or colred
c
c     work space
c       work - complex*16 - array of length at least
c              max ( rowdfu*coldfu+coldfu**2+2*coldfu+rowdfu ,
c                    rowdfl*coldfl+2*coldfl+rowdfl )
c            where
c              rowdfu=coldfl=colred*(n-colred)+rowred*(m-rowred)
c              coldfu=2*(n-colred)*rowred
c              rowdfl=2*(m-rowred)*colred
c
c*********************************************************************
c
c**** this version dated 16 june 1987
c     authors: jim demmel, courant institute, 251 mercer str, new york,  
c                 new york, 10012
c                 electronic address: demmel at nyu.edu
c              bo kagstrom, institute of information processing,
c                 university of umea, s-90187 umea, sweden
c                 electronic address: bokg at seumdc51.bitnet
c
c**** pbound uses the following subroutines and functions
c     dznrm2, blddfu, blddfl, bldrhs, prml, prmlct, svdiv, zsvdc
c
c**** internal variables
c
      complex*16 dummy
      integer rowdfu,coldfu,sstrt,wstrt,estrt,rowdfl,coldfl,vstrt
      integer isub, i, j, info, len
      real*8 r0, l0, relerr, dznrm2
c
      ierr=0
      if ((rowred.gt.colred).or.((n-colred).gt.(m-rowred))) then
c       inconsistent dimensions
        ierr = 5
      elseif ((0.lt.rowred) .and. (0.lt.n-colred)) then
c       case 1
        scase = 1
c       compute difu
c       build transposed difu matrix starting at work(1)
c       rowdfu = number of rows in difut
        rowdfu=colred*(n-colred)+rowred*(m-rowred)
c       coldfu = number of columns in difut
        coldfu=2*(n-colred)*rowred
c
        call blddfu(work,rowdfu,a,b,ldab,m,n,rowred,colred)
c
c       setup workspace for svd
c       store left singular vectors u over difu starting at work(1)
        sstrt=1+rowdfu*coldfu
c       store singular values starting at work(sstrt)
        wstrt=sstrt+coldfu
c       store work array needed for svd starting at work(wstrt)
        estrt=wstrt+rowdfu
c       store e array needed for svd starting at work(estrt)
        vstrt=estrt+coldfu
c       store right singular vectors v starting at work(vstrt)
c
c       compute svd
        call zsvdc(work(1),rowdfu,rowdfu,coldfu,work(sstrt),
     +    work(estrt),work(1),rowdfu,work(vstrt),coldfu,work(wstrt),
     +    21,info)
c
        if (info.eq.0) goto 10
          ierr=1
          return
10      continue
c
c       extract difu
        difu=dreal(work(sstrt-1+coldfu))
c
        if (difu.gt.0.) goto 20
          ierr=2
          return
20      continue
c
c       compute pnorm, qnorm
c       build rhs = (-col a12, -col b12) starting at work(wstrt)
        call bldrhs(work(wstrt),a,b,ldab,m,n,rowred,colred)
c
c       solve underdetermined least squares problem
c       premultiply rhs by v* storing result at work(estrt)
        call prmlct(work(vstrt),coldfu,coldfu,coldfu,
     +              work(wstrt),work(estrt))
c
c       premultiply by inverted singular values
        call svdiv(work(estrt),coldfu,work(sstrt))
c
c       premultiply by u storing result at work(wstrt)
        call prml(work,rowdfu,rowdfu,coldfu,work(estrt),work(wstrt))
c
        len=colred*(n-colred)
c       compute r0 = norm of leading len components
        r0=dznrm2(len,work(wstrt),1)
c
c       compute l0 = norm of remaining components
        len=rowred*(m-rowred)
        l0=dznrm2(len,work(wstrt+len),1)
c       compute pnorm, qnorm from l0, r0
        pnorm=sqrt(1+l0**2)
        qnorm=sqrt(1+r0**2)
c
c       compute difl
c       build difl matrix starting at work(1)
c       rowdfl = number of rows in difl
        rowdfl=2*colred*(m-rowred)
c       coldfl=number of columns in difl
        coldfl=rowred*(m-rowred)+colred*(n-colred)
        call blddfl(work,rowdfl,a,b,ldab,m,n,rowred,colred)
c
c       setup workspace for svd
c       do not compute any singular vectors
        sstrt=1+rowdfl*coldfl
c       store singular values starting at work(sstrt)
        wstrt=sstrt+coldfl
c       store work array needed by svd starting at work(wstrt)
        estrt=wstrt+rowdfl
c       store e array needed by svd starting at work(estrt)
c
        call zsvdc(work(1),rowdfl,rowdfl,coldfl,work(sstrt),
     +             work(estrt),dummy,1,dummy,1,work(wstrt),0,info)
c
        if (info.eq.0) goto 30
          ierr=3
          return
30      continue
c
c       extract difl
        difl=dreal(work(sstrt-1+coldfl))
        if (difl.gt.0.) goto 40
          ierr=4
          return
40      continue
c       compute perturbation bounds
        pdelta=min(difl,difu)/(sqrt(pnorm**2+qnorm**2)+
     +         2.*max(pnorm,qnorm))
        relerr=delta/pdelta
        lbndup=-1.
        rbndup=-1.
        lbndlw=-1.
        rbndlw=-1.
        if (relerr.ge.1.) goto 50
          lbndup=atan(relerr/(pnorm-relerr*sqrt(pnorm**2-1.)))
          rbndup=atan(relerr/(qnorm-relerr*sqrt(qnorm**2-1.)))
          lbndlw=atan(1./(sqrt(2.*min(rowred,m-rowred))*pnorm+
     +           sqrt(pnorm**2-1.)))
          rbndlw=atan(1./(sqrt(2.*min(colred,n-colred))*qnorm+
     +           sqrt(qnorm**2-1.)))
50      continue
      elseif (rowred.eq.0.and.colred.gt.0.and.colred.lt.n) then
c       case 2
        scase = 2
c       compute difl
c       build difl matrix ( (a**t b**t)**t ) starting at work(1)
        isub = 0
        do 100 j=colred+1, n
          do 101 i=1, m
            isub = isub +1
            work(isub) = a(i,j)
101       continue
          do 102 i=1,m
            isub = isub +1
            work(isub) = b(i,j)
102       continue
100     continue
c       compute singular values
        sstrt=1+isub
        estrt=sstrt + n-colred
        wstrt=estrt + n-colred
        call zsvdc(work,2*m,2*m,n-colred,work(sstrt),work(estrt),
     +             dummy,1,dummy,1,work(wstrt),0,info)
        if (info.ne.0) then
          ierr=3
          return
        endif
c       extract difl
        difl = abs(work(sstrt+n-colred-1))
        difu=difl
        if (difl.eq.0.) then
           ierr=4
           return
        endif
        pdelta=difl
        relerr=delta/pdelta
        pnorm = 1.
        qnorm = 1.
        lbndlw = -1.
        rbndlw = -1.
        lbndup = -1.
        rbndup = -1.
        if (relerr.lt.1.) then
          lbndup = 0.
          rbndup = atan(relerr/(1.-relerr))
        endif
      elseif (colred.eq.n.and.rowred.gt.0.and.rowred.lt.m) then
c       case 3
        scase = 3
c       compute difu
c       build difu matrix (a,b) starting at work(1)
        isub = 0
        do 104 j=1,n
          do 105 i=1,rowred
            isub = isub +1
            work(isub) = a(i,j)
105       continue
104     continue
        do 106 j=1,n
          do 107 i=1,rowred
            isub = isub +1
            work(isub) = b(i,j)
107       continue
106     continue
c       compute singular values
        sstrt=isub+1
        estrt=sstrt+rowred+1
        wstrt=estrt+2*n
        call zsvdc(work,rowred,rowred,2*n,work(sstrt),work(estrt),
     +             dummy,1,dummy,1,work(wstrt),0,info)
        if (info.ne.0) then
          ierr = 1
          return
        endif
c       extract difu
        difu=abs(work(sstrt+rowred-1))
        difl = difu
        if (difu.eq.0.0) then
          ierr = 2
          return
        endif
        pdelta = difu
        relerr = delta/pdelta
        pnorm = 1.
        qnorm = 1.
        lbndup = -1.
        rbndup = -1.
        lbndlw = -1.
        rbndlw = -1.
        if ( relerr.lt.1.0) then
          rbndup = 0.
          lbndup = atan(relerr/(1.-relerr))
        endif
      else
c       both left and right subspace trivial
        scase = 4
        lbndup = 0.
        rbndup = 0.
        lbndlw = -1.
        rbndlw = -1.        
        difl = 0.
        difu = 0.
        pdelta = -1.
        pnorm = 1.
        qnorm = 1.
      endif
      return
      end
c
c
      subroutine blddfl(work,wrow,a,b,ldab,m,n,rowred,colred)
c     implicit none
c**** formal parameter declarations
      integer ldab, m, n, rowred, colred, wrow
      complex*16 work(wrow,*),a(ldab,*),b(ldab,*)
c
c***************************************************************
c
c     build difl matrix in work
c     in matlab notation
c
c     difl matrix = < <a11' .*. eye(m-rowred) , -eye(colred) .*. a22 >;
c                     <b11' .*. eye(m-rowred) , -eye(colred) .*. b22 >>
c
c     where a11 = a(1:rowred , 1:colred) 
c           a22 = a(rowred+1 : m , colred+1 : n)
c           b11 = b(1:rowred , 1:colred)
c           b22 = b(rowred+1 : m , colred+1 : n)
c
c***************************************************************
c
c**** this version dated 16 june 1987
c     authors: jim demmel and bo kagstrom
c
c**** internal variables
      integer wcol,rstrta,rstrtb,cstrt,cnt,i,j
      integer row12,col1,col2,mmrwrd,nmclrd
c
c     nmclrd = number of columns in (1,2), (2,2) blocks of a, b
      nmclrd = n-colred
c     mmrwrd = number of rows in (2,1), (2,2) blocks of a, b
      mmrwrd = m-rowred
c     row12 = numbers of rows in each subblock of difl matrix
      row12 = colred*mmrwrd
c     col1 = number of columns in (1,1), (2,1) blocks of difl
      col1 = rowred*mmrwrd
c     col2 = number of columns in (1,2), (2,2) blocks of difl
      col2 = colred*nmclrd
c     wcol = total number of columns in difl
      wcol = col1+col2
c
c     zero out difl
      do 10 j=1,wcol
        do 11 i=1,wrow
          work(i,j)=0.
11      continue
10    continue
c
c     fill in (1,1), (2,1) blocks of difl
      rstrta=0
      rstrtb=row12
      cstrt=0
      do 1 j=1,colred
        do 2 i=1,rowred
          do 3 cnt=1,mmrwrd
            work(cnt+rstrta,cnt+cstrt)=a(i,j)
            work(cnt+rstrtb,cnt+cstrt)=b(i,j)
3         continue
          cstrt=cstrt+mmrwrd
2       continue
        cstrt=0
        rstrta=rstrta+mmrwrd
        rstrtb=rstrta+row12
1     continue
c
c     fill in (1,2), (2,2) blocks of difl
      rstrta=0
      cstrt=col1
      do 4 cnt=1,colred
        rstrtb=rstrta+row12
        do 5 j=1,nmclrd
          do 6 i=1,mmrwrd
            work(rstrta+i,cstrt+j)=-a(i+rowred,j+colred)
            work(rstrtb+i,cstrt+j)=-b(i+rowred,j+colred)
6         continue
5       continue
        rstrta=rstrta+mmrwrd
        cstrt=cstrt+nmclrd
4     continue
      return
      end
c
c
      subroutine blddfu(work,wrow,a,b,ldab,m,n,rowred,colred)
c     implicit none
c**** formal parameter declarations
      integer ldab, m, n, rowred, colred, wrow
      complex*16 work(wrow,*),a(ldab,*),b(ldab,*)
c*********************************************************************
c
c     build conjugate transpose difu matrix in work
c     in matlab notation
c
c     (difu matrix)' =
c
c       < < eye(n-colred) .*. a11' , eye(n-colred) .*. b11' >;
c         < -conj(a22) .*. eye(rowred) , -conj(b22) .*. eye(rowred) >>
c
c     where a11 = a(1:rowred , 1:colred) 
c           a22 = a(rowred+1 : m , colred+1 : n)
c           b11 = b(1:rowred , 1:colred)
c           b22 = b(rowred+1 : m , colred+1 : n)
c
c*********************************************************************
c
c**** this version dated 16 june 1987
c     authors: jim demmel and bo kagstrom
c
c**** internal variables
c
      integer wcol,cstrta,cstrtb,rstrt,cnt,i,j
      integer mmrwrd,nmclrd,rwrdp1,clrdp1
      integer row1, row2, col12
c
c     nmclrd = number of columns in (1,2), (2,2) entries of a, b
      nmclrd=n-colred
c     col12 = number of columns in each subblock of difuct matrix
      col12=rowred*nmclrd
c     mmrwrd = number of rows in (2,1), (2,2) entries of a, b
      mmrwrd = m-rowred
c     row1 = number of rows in (1,1), (2,1) sublocks of difu
      row1 = colred*nmclrd
c     row2 = number of rows in (1,2), (2,2) subblocks of difu
      row2 = rowred*mmrwrd
c     wcol = total number of columns in difu matrix
      wcol = 2*col12
c     initialize difu to zero
      do 1 j=1,wcol
        do 2 i=1,wrow
          work(i,j)=0.
2       continue
1     continue
c
c     fill in (1,1), (1,2) positions of difu
      cstrta=0
      rstrt=0
      do 3 cnt=1,nmclrd
        cstrtb=cstrta+col12
          do 4 j=1,colred
            do 5 i=1,rowred
              work(rstrt+j,cstrta+i)=conjg(a(i,j))
              work(rstrt+j,cstrtb+i)=conjg(b(i,j))
5           continue
4         continue
        cstrta=cstrta+rowred
        rstrt=rstrt+colred
3     continue
c
c     fill in (2,1), (2,2) positions of difuct
      rwrdp1=rowred+1
      clrdp1=colred+1
      cstrta=0
      cstrtb=col12
      rstrt=row1
      do 6 j=clrdp1,n
        do 7 i=rwrdp1,m
          do 8 cnt=1,rowred
            work(cnt+rstrt,cnt+cstrta)=-conjg(a(i,j))
            work(cnt+rstrt,cnt+cstrtb)=-conjg(b(i,j))
8         continue
          rstrt=rstrt+rowred
7       continue
        rstrt=row1
        cstrta=cstrta+rowred
        cstrtb=cstrta+col12
6     continue
      return
      end
c
c
      subroutine bldrhs(work,a,b,ldab,m,n,rowred,colred)
c     implicit none
c**** formal parameter declarations
      integer ldab, m, n, rowred, colred
      complex*16 work(*), a(ldab,*), b(ldab,*)
c
c*********************************************************************
c
c     extract a12 = (1,2) block of a and b12 = (1,2) block of b
c     and store columnwise in work=(-col a12, -col b12)
c
c*********************************************************************
c
c**** this version dated 16 june 1987
c     authors: jim demmel and bo kagstrom
c
c**** internal variables
      integer clrdp1, j, i, loc
c
      clrdp1=colred+1
      loc=0
      do 1 j=clrdp1,n
        do 2 i=1,rowred
          loc=loc+1
          work(loc)=-a(i,j)
2       continue
1     continue
      do 3 j=clrdp1,n
        do 4 i=1,rowred
          loc=loc+1
          work(loc)=-b(i,j)
4       continue
3     continue
      return
      end
c
c
      subroutine prml(u,ldu,m,n,rhs,prod)
c     implicit none
      integer ldu, m, n
      complex*16 u(ldu,n),rhs(n),prod(m)
c
c*********************************************************************
c     compute prod = u * rhs
c
c**** this version dated 16 june 1987
c     authors: jim demmel and bo kagstrom
c
      integer i, j
c
      do 1 j=1,m
        prod(j)=rhs(1)*u(j,1)
1     continue
      if (n.eq.1) return
      do 2 i=2,n
        call zaxpy(m,rhs(i),u(1,i),1,prod,1)
2     continue
      return
      end
c
c
      subroutine prmlct(u,ldu,m,n,rhs,prod)
c     implicit none
      integer ldu, m, n
      complex*16 u(ldu,n),rhs(m),prod(n),zdotc
c
c*********************************************************************
c     compute prod = (conjugate transpose u) * rhs
c
c**** this version dated 16 june 1987
c     authors: jim demmel and bo kagstrom
c
      integer j
c
      do 1 j=1,n
        prod(j)=zdotc(m,u(1,j),1,rhs,1)
1     continue
      return
      end
c
c
      subroutine svdiv(z,n,s)
c     implicit none
      integer n
      complex*16 z(n),s(n)
c
c*********************************************************************
c     divide one array by another
c
c**** this version dated 16 june 1987
c     authors: jim demmel and bo kagstrom
c
      integer j
c
      do 1 j=1,n
        z(j)=z(j)/s(j)
1     continue
      return
      end
c
      subroutine evalbd(delta, sdlmax, qnorm, pnorm, scase,
     +                  m, n, irstrt, icstrt, 
     +                  lbndup, rbndup, lbndlw, rbndlw)
c
c     implicit none
c**** formal parameter declarations
c
      real*8 delta, sdlmax, qnorm, pnorm
      real*8 lbndup, rbndup, lbndlw, rbndlw
      integer scase, m, n, irstrt, icstrt
c
c******************************************************************
c
c     evaluate reducing subspace angular perturbation bounds computed
c     by subroutine bound for a perturbation of frobenius
c     norm delta. see documentation to subroutine bound for more details.
c
c     inputs:
c
c       sdlmax, qnorm, pnorm and scase are computed by bound. 
c       m, n, irstrt and icstrt are dimensions also input to bound
c       in order to compute sdlmax, qnorm, pnorm and scase.
c
c     outputs:
c
c       lbndup - real*8 - upper bound on angular perturbation in 
c                         left reducing subspace 
c                         (0 if space trivial and -1 if inapplicable)
c
c       rbndup - real*8 - upper bound on angular perturbation in
c                         right reducing subspace 
c                         (0 if space trivial and -1 if inapplicable)
c
c       lbndlw - real*8 - lower bound on angular perturbation in
c                         left reducing subspace (-1 if inapplicable)
c
c       rbndlw - real*8 - lower bound on angular perturbation in
c                         right reducing subspace (-1 if inapplicable)
c
c************************************************************************
c
c**** this version dated 16 june 87
c     authors: jim demmel and bo kagstrom
c
c**** internal variables
      real*8 relerr
c
      if (scase .ne. 4) relerr = delta/sdlmax
      if (scase.eq.1) then
        lbndup = atan(relerr/(pnorm-relerr*sqrt(pnorm**2-1.)))
        rbndup = atan(relerr/(qnorm-relerr*sqrt(qnorm**2-1.)))
        lbndlw = atan(1./(sqrt(2.*min(irstrt-1,m-irstrt+1))*pnorm +
     +           sqrt(pnorm**2-1.)))
        rbndlw = atan(1./(sqrt(2.*min(icstrt-1,n-icstrt+1))*qnorm +
     +           sqrt(qnorm**2-1.)))
      elseif (scase.eq.2) then
        lbndup = 0.
        rbndup = atan(relerr/(1.-relerr))
        lbndlw = -1.
        rbndlw = -1.
      elseif (scase.eq.3) then
        lbndup = atan(relerr/(1.-relerr))
        rbndup = 0.
        lbndlw = -1.
        rbndlw = -1.
      elseif (scase.eq.4) then
        lbndup = 0.
        rbndup = 0.
        lbndlw = -1.
        rbndlw = -1.
      endif
      return
      end
c
      subroutine bndwsp(m,n,irstrt,icstrt,dimreg,ecase,space,info)
c
c     implicit none
c
c**** debug space
      common /debug2/ idbg(20), outunit
      integer idbg, outunit
c
c**** formal parameter declarations
      integer m,n,irstrt,icstrt,dimreg,info,ecase,space
c
c********************************************************************
c
c     compute work space needed by subroutine bound
c
c     inputs
c
c       m,n - integer - row, column dimensions of a and b
c
c       irstrt, icstrt - integer - starting row and column of selected 
c                        part of pencil for which eigenvalue bounds 
c                        are desired. reducing subspace bounds will be
c                        supplied for right reducing subspace spanned
c                        by leading icstrt-1 components and for left
c                        reducing subspace spanned by leading icstrt-1
c                        components.
c                        note: set icstrt=n+1 to make right reducing
c                                  subspace whole space
c                              set irstrt=m+1 to make left reducing
c                                  subspace whole space
c
c       dimreg - integer - number of selected eigenvalues;
c         if dimreg.eq.0 only subspace perturbation bounds will be
c         computed
c        (note - one can select a subset of the regular part only;
c         this gives generally different bounds for common eigenvalues
c         from a different selected subset; see paper above for 
c         discussion)
c
c     outputs
c
c       ecase - integer - which of 5 cases for eigenvalue bounds 
c               the pencil falls depending on input dimensions;
c               the first four cases are for dimreg.gt.0, in which
c               case the description gives:
c                  (part of KCF to above, left of selected part) and
c                  (part of KCF to below, right of selected part) 
c          ecase=1 - (right singular and/or regular part) and
c                    (left singular and/or regular part)
c          ecase=2 - (right singular and/or regular part) and (nothing)
c          ecase=3 - (nothing) and (left singular and/or regular part)
c          ecase=4 - (nothing) and (nothing)
c          ecase=5 - dimreg.eq.0 (no eigenvalue bounds)
c
c       space - integer - amount of workspace (double precision complex
c                         words) needed by subroutine bound
c       (the following simple expression bounds the workspace also, but
c          may occasionally be much too large (especially if ecase=4):
c            workspace .le. 2*m*n* (n*n + m*m + 2*n + m + 2) + n*n + m*m)
c
c       info - integer - 0 if normal return
c                        1 if inconsistent input dimensions
c
c*************************************************************************
c
c**** this version dated 22 june 1987
c     authors: jim demmel, courant institute, 251 mercer str, 
c                 new york, new york, 10012
c                 electronic address: demmel at nyu.edu
c              bo kagstrom, institute of information processing,
c                 university of umea, s-90187 umea, sweden
c                 electronic address: bokg at seumdc51.bitnet 
c
c**** internal variables
      integer irend,icend,m11,m21,m12,m22,n11,n12,n21,n22
c
c     test input dimensions for consistency
      info = 0
      icend = icstrt+dimreg-1
      irend = irstrt+dimreg-1
      if (irstrt.gt.icstrt .or. irstrt.le.0 .or.
     +    n-icstrt-dimreg.gt.m-irstrt-dimreg .or.
     +    n-icstrt-dimreg+1.lt.0 .or. dimreg.lt.0) then
c       inconsistent input dimensions
        info = 1
      else
        if (dimreg.gt.0) then
c         there are eigenvalue bounds to compute
c
c         ecase 1 - in addition to selected regular part KCF has
c         (right singular part and/or regular part) and
c         (left singular part and/or regular part)   
          if (icstrt.ne.1 .and. irend.ne.m) then
            ecase = 1
          endif
c
c         ecase 2 - in addition to selected regular part KCF has
c                  (right singular part and/or regular part) and
c                  (nothing)
          if (icstrt.ne.1 .and. irend.eq.m) then
            ecase=2
          endif
c
c         ecase 3 - in addition to selected regular part KCF has
c                  (nothing) and
c                  (left singular part  and/or regular part)
          if (icstrt.eq.1 .and. irend.ne.m) then
            ecase = 3
          endif
c
c         ecase 4 - pencil regular and entire spectrum selected
          if (icstrt.eq.1 .and. irend.eq.m) then
            ecase=4
          endif
c
        else
c         dimreg.eq.0, so only compute subspace bounds
          ecase = 5
        endif
c
        if (ecase .eq. 1) then
          m11=irstrt-1
          m21=m-m11
          n11=icstrt-1
          n21=n-n11
          m12=irend-irstrt+1
          m22=m-irend
          n12=icend-icstrt+1 
          n22=n-icend
          space = max( (2*n21*m11*(n11*n21+m11*m21+
     +                  2*n21*m11+2)+n11*n21+m11*m21) ,
     +                  (2*((m21*n11+1)*(n11*n21+
     +                  m11*m21+1)-1)) ,
     +                  (2*n22*m12*(n12*n22+m12*m22+
     +                  2*n22*m12+2)+n12*n22+m12*m22) ,
     +                  (2*((m22*n12+1)*(n12*n22+
     +                  m12*m22+1)-1)) )
        elseif (ecase .eq. 2 .or. ecase .eq. 5) then
          m11=irstrt-1
          m21=m-m11
          n11=icstrt-1
          n21=n-n11
          space = max( (2*n21*m11*(n11*n21+m11*m21+
     +                 2*n21*m11+2)+n11*n21+m11*m21) ,
     +                 (2*((m21*n11+1)*(n11*n21+
     +                 m11*m21+1)-1)) )
        elseif (ecase .eq. 3) then
          m11=irend
          m21=m-m11
          n11=icend
          n21=n-icend
          space = max( (2*n21*m11*(n11*n21+m11*m21+
     +                 2*n21*m11+2)+n11*n21+m11*m21) ,
     +                 (2*((m21*n11+1)*(n11*n21+
     +                 m11*m21+1)-1)) )
        elseif (ecase .eq. 4) then
          space = n*n
        endif
      endif
c
      if (idbg(19).ne.0) then
        write(outunit,100) m,n,irstrt,icstrt,dimreg,ecase,
     +  space,info
100     format(' bndwsp - m,n,irstrt,icstrt,dimreg'
     +         ',ecase,space,info=',/,8i5)
      endif
      return
      end        
