
c   on this file june 7, 1987: cmatml, cmatmr
c
      subroutine cmatml(a,lda,rowa,cola,b,ldb,rowb,c,ldc,work,job)
c
c     implicit none
      integer       lda,rowa,cola,ldb,rowb,ldc,job
      complex*16    a(lda,lda),b(ldb,ldb),c(ldc,ldc),work(*)
      complex*16    zdotu,zdotc
c
c***********************************************************************
c
c     cmatml performs  a complex (left) matrix multiplication  b * a,
c     or b' * a (' = transpose ,conjugate) where a is rowa * cola,
c     b is rowb * rowa. the result is stored in c or overwritten in a.
c     note the extra restrictions on dimensions of b when job = 3 or 4.
c
c     on entry
c         
c         a         complex(lda,cola), where lda>=rowa.
c
c         lda       integer
c                   lda is the leading dimension of the array a.
c                    
c         rowa      integer
c                   rowa is the number of rows of a, which is also
c                   the number of columns of b.
c         cola      integer
c                   cola is the number of columns of a, which is also
c                   the number columns of the resulting matrix.
c
c         b         complex(ldb,rowa), ldb>=rowb.
c                   
c         ldb       integer
c                   ldb is the leading dimension of the array b.
c                                           
c         rowb      integer
c                   rowb is the number of rows of the array, which
c                   is also the number of rows of the resulting matrix.
c
c         ldc       integer
c                   ldc is the leading dimension of the array c
c
c         work      complex(rowa)
c                   work is a scratch array.
c
c         job       integer
c                   job controls the matrix multiplication, and has
c                   the following meaning
c                   job=1       a = b * a
c                   job=2       c = b * a
c                   job=3       a = b' * a
c                   job=4       c = b' * a
c
c    on return
c
c         c         complex(ldc,cola), where ldc>=rowb.
c                   c is the matrix product of a and b. if rowa (=colb)
c                   = rowb then it is possible to call cmatml with c 
c                   equals to a, and the result is overwritten in a.
c
c*********************************************************************
c
c         this version dated june 7, 1987
c         authors: jim demmel and bo kagstrom
c
c*****    internal variables
c
      integer       i,j
c
c*****    cmatml uses the following functions and subroutines
c
c         blas      zcopy, zdotc, zdotu
c
c*****    determine what is to be computed via nested if-then -else's
c
      do 20 j = 1, cola
          do 10 i = 1, rowb
            if     (job .eq. 1) then
               work(i) = zdotu(rowa,b(i,1),ldb,a(1,j),1)
            elseif (job .eq. 2) then
               c(i,j) = zdotu(rowa,b(i,1),ldb,a(1,j),1)
            elseif (job .eq. 3) then
               work(i) = zdotc(rowa,b(1,i),1,a(1,j),1)
            else
c                  (job .eq. 4)
               c(i,j) = zdotc(rowa,b(1,i),1,a(1,j),1)
            endif
   10     continue
          if (job .eq. 1 .or. job .eq. 3) then
             call zcopy(rowa,work,1,a(1,j),1)
          endif
   20 continue
      return
      end


      subroutine cmatmr(a,lda,rowa,cola,b,ldb,colb,c,ldc,work,job)
c
c     implicit none
      integer       lda,rowa,cola,ldb,colb,ldc,job
      complex*16    a(lda,lda),b(ldb,ldb),c(ldc,ldc),work(*)
      complex*16    zdotu,zdotc
c
c***********************************************************************
c
c     cmatmr performs  a complex (right) matrix multiplication  a * b,
c     or a * b' ,(' = transpose ,conjugate), where a is rowa * cola,
c     b is cola * colb. the result is stored in c or overwritten in a.
c     note the extra restrictions in dimension of b when job = 3 or 4.
c
c     on entry
c         
c         a         complex(lda,cola), where lda>=rowa.
c
c         lda       integer
c                   lda is the leading dimension of the array a.
c                    
c         rowa      integer
c                   rowa is the number of rows of a, which is also
c                   the number of rows in the resulting matrix.
c         cola      integer
c                   cola is the number of columns of a, which is also
c                   the number of rows of b.
c
c         b         complex(ldb,colb), ldb>=cola.
c                   
c         ldb       integer
c                   ldb is the leading dimension of the array b.
c                                           
c         colb      integer
c                   colb is the number of columns  of b, which is
c                   also the number of columns of the resulting matrix
c
c         ldc       integer
c                   ldc is the leading dimension of the array c
c
c         work      complex(cola)
c                   work is a scratch array.
c
c         job       integer
c                   job controls the matrix multiplication, and has
c                   the following meaning
c                   job=1       a = a * b
c                   job=2       c = a * b 
c                   job=3       a = a * b'
c                   job=4       c = a * b'
c
c    on return
c
c         c         complex(ldc,colb), where ldc>=rowa.
c                   c is the matrix product of a and b. if cola(=rowb)
c                   = colb then it is possible to call cmatmr with c 
c                   equals to a, and the result is overwritten in a.
c
c*********************************************************************
c
c         this version dated june 7, 1987
c         authors: jim demmel and bo kagstrom 
c
c*****    internal variables
c
      integer       i,j
c
c*****    cmatmr uses the following functions and subroutines
c
c         blas      zcopy, zdotc, zdotu
c
c*****    determine what is to be computed via nested if-then -else's
c
      do 20 i = 1, rowa
          do 10 j = 1, colb
            if     (job .eq. 1) then
               work(j) = zdotu(cola,a(i,1),lda,b(1,j),1)
            else if (job .eq. 2) then
               c(i,j) = zdotu(cola,a(i,1),lda,b(1,j),1)
            else if (job .eq. 3) then
               work(j) = zdotc(cola,b(j,1),ldb,a(i,1),lda)
            else
c                  (job .eq. 4)
               c(i,j) = zdotc(cola,b(j,1),ldb,a(i,1),lda)
            end if
   10     continue
          if (job .eq. 1 .or. job .eq. 3) then
             call zcopy(cola,work,1,a(i,1),lda)
          end if
   20 continue
      return
      end

