c     On this file March 1990: zgschurm, edist
c
      program zgschurm
c     implicit none
c**** debug space
c     the common-block declarations assume that the dimension of the
c     input matrix pencil a - lambda b is not larger than 30.
c     the debug space is used for producing debug outputs (optional,
c     see below)
c
      integer abdim, wdim, abdim6
c     abdim6 = abdim + 6
      parameter ( abdim = 30, wdim = 20000, abdim6 = 36)
      common /debug1/ acopy(abdim, abdim),bcopy(abdim, abdim), 
     *                atest(abdim, abdim), btest(abdim, abdim), swap
      common /debug2/ idbg(20), outunit
      complex*16 acopy, bcopy, atest, btest
      integer idbg, outunit
      logical swap
c***** This version of zgschurm computes pairs of reducing
c      subspaces associated with different subspaces of a
c      (generalized) state space system. Further, it collects statistics
c      for random examples
c
c      Revision: 900323 (this version goes with final versions of
c                        guptri and bounds)
c
c*+*+*+
c      The program starts by asking for input and output
c      files (infile and outfile) where
c      infile        contains A and B of dimension M by N and
c                    debug and control inputs (see below)
c      outfile       contains output from the program
c      Then it asks for a textstring identifying the run (.le. 80 chars)
c*+*+*+
c
c***** debug flags     (20i1)
c      idbg(1) ne 0  - turn on debug output for kcfmain
c      idbg(2) ne 0  - turn on debug output for guptri
c      idbg(3) ne 0  - turn on debug output for krnstr
c      idbg(4) ne 0  - turn on debug output for rzstr
c      idbg(5) ne 0  - turn on debug output for listr
c      idbg(6) ne 0  - turn on debug output for rcsvdc
c      idbg(7) ne 0  - turn on debug output for reordr
c      idbg(8) ne 0  - turn on debug output for exchng
c      idbg(9) ne 0  - turn on debug output for pbound (no debug)
c      idbg(10) ne 0 - turn on debug output for gvec
c+*+   idbg(11) ne 0 - turn on debug output for pertb1     860729
c      idbg(12) ne 0 - turn on debug output for qz
c      idbg(19) ne 0 - turn on debug output for bndwsp
c      idbg(20) ne 0 - turn on debug output for bound
c
c***** control inputs    (2i1,i4,i1)
c      izero ne 0   - zero out nonzero singular values during reduction
c      itrpose ne 0 - transpose input matrices a and b
c      job (4th digit) ne 0 - pre, postmultiply a by random nonsingular
c                             matrices p, q, called wanta in output
c      job (3rd digit) ne 0 - pre, postmultiple a by random nonsingular
c                             matrices p, q, called wantb in output
c      job (2nd digit) ne 0 - add random noise of size machep to a, b,
c                             called pertur in output
c      job (1st digit) ne 0 - print block structured input a, b, and 
c                             final input a,b if different, 
c                             called prints in output
c      exprin  ne 0 - print outs for each example and statistics
c              eq 0 - only print outs of statistics
c*+*+*+  860731
c      epsu         (2d10.0)  user specified uncertainty in the input
c                             A and B (used for deleting small singular
c                             values)
c      gap                    gap between small singular values
c      epsper       (d10.0)   size of perturbation to A and B on input
c                             (only used if job (2nd digit ne 0)
c      numex        (3i5)     number of values of epsbnd's
c      numtst                 number of times we shall add noise of
c                             size epsbnd(iper) to A and B
c      jobper                 structure of the perturbations added
c                             to A and B
c      epsbnd(numex) (5d10.0) size of perturbation that we add to A and B
c*+*+*+
c      Statistics are collected from numex*numtst random examples.
c      Starting from a nongeneric pencil and a rule(epsu,gap) for 
c      choosing a particular set of reducing subspaces we add random noise
c      to get perturbed pencils as input for GUPTRI
c
c
      complex*16 a(abdim,abdim),b(abdim,abdim), 
     *        work(wdim), pp(abdim,abdim), qq(abdim,abdim)
      complex*16 zat, zbt, aorig(abdim,abdim), borig(abdim,abdim),
     *           aprim(abdim,abdim), bprim(abdim,abdim),
     *           ppper(abdim,abdim), 
     *           qqper(abdim,abdim) 
      complex*16 aortr(abdim,abdim),bortr(abdim,abdim)
      integer rtre, rtce, zrre, zrce, fnre, fnce, inre, ince
      integer pstruc(4), struc(abdim), space
      integer nsumrz,rsumrz,nsumli,rsumli
      integer djordz,djordi,dimreg
c 06/16/87
      integer rowb, colb, rowe, cole
c
      integer kstr(4,abdim6), step, allreg, krstrt, kcstrt, icase
      integer three, ithree, ecase
      integer ndim, rindx(abdim6), ftest, colrs, rowrs, pcolrs, prowrs
      integer sstrt,estrt,wstrt,ninfo
      integer fout, fin, folhp, fcrhp
      external fout, fin, folhp, fcrhp, ftest, ftestp
      logical zero, ldebug
      logical trpose, pbndok, nostat
c*+*+ demmel, 7/3/86
      logical ebndok
c*+*+
      complex*16 evala(abdim),evalb(abdim)
c*+*+
      complex*16 evalap(abdim),evalbp(abdim)
c*+*+
      real*8 lbndup, lbndlw, gvcond(abdim), anormf, bnormf,
     *     lbdupp, rbdupp, relerr, rbndup, rbndlw
      real*8 scl, epsu, gap 
      real*8 epsper, epsbnd(20), delmax
c*+*+*+ 860731
      integer numex, jobper, numtst, iper, itst, exprin
      character*80 infile, outfile, ident
c***  data for statistics /rev 870526 and 870626
      integer statrs(6,12), stateg(3,12,10), stateg1(2,12,10)
      integer sdstqt(7,12), sdstqe(7,12)
      integer srqtup(6,12), slqtup(6,12)
      integer srqtlw(6,12), slqtlw(6,12), segqt(6,12,10)     
      integer segqt1(6,12,10), badeig
      real*8 rqtup, lqtup, rqtlw, lqtlw, egqt
c
c     variables for min, average and max computations /870526
      real*8 maxrda, maxrdb
      real*8 minqt, avrqt, maxqt
      real*8 minqe, avrqe, maxqe
      real*8 minrup, avrrup, maxrup
      real*8 minlup, avrlup, maxlup
      real*8 minrlw, avrrlw, maxrlw
      real*8 minllw, avrllw, maxllw
      real*8 minegq(10), avregq(10), maxegq(10)
      real*8 minegq1(10), avregq1(10), maxegq1(10)
c     end of new variables for statistics/ 870526 and 870626
      logical infnt, infntp
c*+*+*+
      complex*16 dum, dummy
      integer i, izero, itrpos, job, lda, ldb, m, n, ldab
      integer ldqq, ierr, info, len, k, jjj, ieig, j, ldpp
      real*8 cpp, cqq, difa, difb, adife, bdife, anore, bnore
      real*8 dsvd, adsvd, bdsvd
      real*8 rdifa, rdifb, radife, rbdife, difu, difl
      real*8 pqnorm, qnorm, pnorm
      real*8 pdelta, dist, dstqt, dstqe, dstpu
      real*8 dsvdp, adsvdp, bdsvdp
      real*8 distup
      real*8 thetal, thetar, ebnd, edif
      real*8 cond, cnorm, cdife
c**** generate a singular matrix pencil
c
c      data lda/20/, ldb/20/, ldpp/20/, ldqq/20/, ldab/20/
      lda = abdim
      ldb = abdim
      ldpp = abdim
      ldqq = abdim
      ldab = abdim
c
c*+*+*+ 860731
      write(*,*) 'Give infile and outfile:'
      read(*,7034) infile
      read(*,7034) outfile                 
 7034 format(A)
c
      write(*,*) 'Identify this testrun:'
      read (*,7034) ident
      open(5, file = infile, status = 'old')
      outunit = 6
      open(6, file = outfile, status = 'new')
      write(6,7035) 'Testrun identification: ',ident
 7035 format(A,A//)
c*+*+*+
c
c     read in matrix dimensions and matrices a and b
	  read(5,6543) m,n
	  do 7010 i = 1, m
		 read(5, *) (a(i,j), j = 1, n)
7010  continue
	  do 7015 i = 1, m
		 read(5,*) (b(i,j), j = 1,n)
7015  continue
6543  format(2i5)
c
c     copy a and b to acopy and bcopy, respectively
c
      call cmcopy(b,ldb,m,n,bcopy)
	  call cmcopy(a,lda,m,n,acopy)
c
      call cmatpr(a,lda,m,n,'final version of a input')
      call cmatpr(b,lda,m,n,'final version of b input')
c     read in debug controls
      read(5,1235) (idbg(i),i=1,20)
1235  format(20i1)
      write (6,1236) (j,j=1,20), (idbg(j),j=1,20)
1236  format(' debug controls -',/,1x,20i3,/,1x,20i3)
c*+*+*+
c     read in job controls
      read(5,1234) izero,itrpos,job, exprin
1234  format(2i1,i4,i1)
c
c     read epsu (relative error in input matrices) and gap
c     (for nullity testing)
      read(5, 202) epsu, gap
  202 format(2d10.0)
      write(6, 203) 'input: epsu=', epsu, 'gap=', gap
  203 format(t5,a,d15.5)
      read (5,204) epsper
  204 format(d10.0)      
c*+*+*+
      read(5,205) numex, numtst, jobper
  205 format(3i5)
c*+*+*+
      if (numex .gt. 0) read(5,206) ( epsbnd(i), i= 1, numex)
  206 format (5d10.0)
c
        write(6,207) ' epsper =', epsper, '  numex =', numex,
     *               ' numtst=', numtst, ' jobper =', jobper
  207   format(t5, a, d15.5, 3 (a, i5))
        if (numex .gt. 0) then
          write(6,207)  ' epsbnd ='
          write(6,208) ( epsbnd(i), i= 1, numex)
  208     format(t5, 5d12.3)
        endif
c*+*+*+ start (trpose never used in this code!)
      trpose=.false.
      if (itrpos.ne.0) trpose=.true.
      zero=.false.
      if (izero.ne.0) zero=.true.
      write(6,201) 'zero=', zero
201   format(t5,a,l1)
c
      nostat = .true.
      if (exprin .eq. 0) nostat = .false.
      write(6,201) 'nostat=', nostat
c*+*+*+ end
c     copy a and b to aorig and borig for later perturbing
c     aorig and borig should never be changed!!!!!
      call cmcopy(a, ldab, m, n, aorig)
      call cmcopy(b, ldab, m, n, borig)
      anormf = cnorm(a, ldab, m, n, 0, work)
      bnormf = cnorm(b, ldab, m, n, 0, work)
c
      write(6, 350) 'epsper=', epsper
      write(6, 350) 'norm(a,e)=', anormf, 'norm(b,e)=', bnormf
 350  format(t5,a,d12.5,tr5,a,d12.5,tr5,d12.5)
c
  200 format(t5,a,d12.6)

      write(6, 100) 'start guptri'
c
c**** 6/16/87
c
      call guptri(a ,b , ldab, m, n,  epsu, gap, zero,
     *            pp, ldpp, qq, ldqq, adsvd, bdsvd,
     *            rtre, rtce, zrre, zrce, fnre, fnce, inre, ince,
     *            pstruc, struc, work, kstr, info)
c
c***  6/18/87
      if (info .ne. 0) then
        write (6,2000) 'after first guptri, info=', info
      endif
      dsvd = sqrt ( (anormf*adsvd)**2 + (bnormf*bdsvd)**2 )
c
c**** 6/16/87
c     compute step by searching through kstr 
      three = 0
      do 61687 ithree = 1, 20
        if ( three .eq. 3) go to 61688
        if( kstr(1, ithree) .eq. -1) then
          three = three + 1
        endif
61687 continue
c
      if ( three .lt. 3) then
        write(*,*) 'ERROR in kstr (computing step in driver)'
        stop
      endif
c
61688 continue
      step = ithree - 1
c***  end of computing step
c
c**** 6/15/87
c     compute ome structure infortmation (not parameters to guptri any more)
      nsumrz = zrce
      rsumrz = zrre
      nsumli = n - fnce
      rsumli = m - fnre
      djordz = zrre - rtre
      djordi = inre - fnre
      dimreg = fnre - zrre
      ndim = 0
c
c*+*+     added 06/16/87 
c**** reorder the eigenvalues according to the user specified
c     integer function ftest
c     set debug flag for guptri so we can compare with old version of
c     driver
      ldebug = idbg(2)
      allreg = dimreg + djordz + djordi
      rowb = rsumrz - djordz + 1
      colb = nsumrz - djordz + 1
      rowe = rowb + allreg - 1
      cole = colb + allreg - 1
      if (ldebug) then
         write(outunit, 2005) 'eigenvalues before reordering'
         do 70 i = rowb, rowe
           j = colb + i - rowb
           if (abs(b(i ,j)) .eq. 0. ) then
               write(outunit, 2005) 'infinite eigenvalue',a(i,j), b(i,j)
 2005          format(t5,a,4d15.5)
           else
               write(outunit, 2005) 'eigenvalue=', a(i,j)/b(i,j)
           endif
   70    continue
      endif
      if (allreg .ge. 1) then
         call reordr(a, b, ldab, m, n, rowb, colb, rowe, cole,
     *                ftest, ndim, rindx, pp, ldpp, qq, ldqq)
c
        if (idbg(2) .gt. 1) then
            call cmatpr(qq,ldqq,n,n,'qq after reordr')
            call cmatpr(pp,ldpp,m,m,'pp after reordr')
        endif
      endif
c
      if (ldebug) then
         write(outunit, 2005) 'eigenvalues after reorder and'
         write(outunit, 2005) 'computed eigenvalues'
         do 75 i = rowb, rowe
           j = colb + i - rowb
           if (abs(b(i ,j)) .eq. 0. ) then
               write(outunit, 2005) 'infinite eigenvalue',a(i,j), b(i,j)
           else
               write(outunit, 2005) 'eigenvalue=', a(i,j)/b(i,j)
           endif
   75    continue
       endif
c
c+*+ end add reorder*
c     save transformed original a and b in aprim, bprim,aortr,bortr
c
      call cmcopy(a, ldab, m, n, aprim)
      call cmcopy(b, ldab, m, n, bprim)
c
      call cmcopy(a, ldab, m, n, aortr)
      call cmcopy(b, ldab, m, n, bortr)
c
c     compute aprim = pp * aprim * qq**H and
c             bprim = pp * bprim * qq**H
      call cmatml(aprim,ldab,m,n,pp,ldpp,m,aprim,ldab,work,1)
      call cmatmr(aprim,ldab,m,n,qq,ldqq,n,aprim,ldab,work,3)
      call cmatml(bprim,ldab,m,n,pp,ldpp,m,bprim,ldab,work,1)
      call cmatmr(bprim,ldab,m,n,qq,ldqq,n,bprim,ldab,work,3)
        if (idbg(1) .ge. 2) then
          call cmatpr(aprim,ldab,m,n,'final aprim')
          call cmatpr(bprim,ldab,m,n,'final bprim')
        endif
        write(6, 100) 'results from guptri and reorder'
  100   format (t5, a, i4)
c
c****   6/15/87
        write(6,7357) 'rtce=',rtce,'zrce=',zrce,'fnce=',fnce,
     +                'ince=',ince,'rtre=',rtre,'zrre=',zrre,
     +                'fnre=',fnre,'inre=',inre
        write (6,7355) (pstruc(j),j=1,4)
        if (pstruc(4).gt.0) write (6,7356)(struc(j),j=1,pstruc(4))
 7355   format('pstruc = ',4i4,/,'struc =')
 7356   format(15i4)
 7357   format(4(3x,a,i4),/,4(3x,a,i4))
        write (6,123) nsumrz,rsumrz,djordz,nsumli,rsumli,djordi,
     *                dimreg, ndim
 123    format('nsumrz=',i5,/,'rsumrz=',i5,/,'djordz=',i5,/,
     *         'nsumli=',i5,/,'rsumli=',i5,/,'djordi=',i5,/,
     *         'dimreg=',i5,/,'ndim=  ',i5)
        write(6,200) 'Relative perturbation in a= ', adsvd
        write(6,200) 'Relative perturbation in b= ', bdsvd
        write(6,200) 'Frobeniusnorm of deleted singular vaules=',
     *                dsvd
        write(6, 100) 'kstr, step=',step
        do 10 i = 1, 2
           write(6, 300) (kstr(i,j), j = 1, step)
   10   continue
  300   format(t5, 20i3)
        if(idbg(1).ge.1)call cmatpr(a,lda,m,n,'Transformed matrix A')
        if(idbg(1).ge.1)call cmatpr(b,ldb,m,n,'Transformed matrix B')
        if (idbg(1).ge.2) call cmatpr(pp, ldpp, m, m, 'PP')
        if (idbg(1).ge.2) call cmatpr(qq, ldqq, n, n, 'QQ')
        cpp=cond(pp,ldpp,m,m,work)
        write(6, 105) 'cond(PP)=', cpp
  105   format(t5, a, d12.6)
        cqq=cond(qq,ldqq,n,n,work)
        write(6, 105) 'cond(QQ)=', cqq
c
      call cmcopy(acopy, ldab, m, n, atest)
      call cmcopy(bcopy, ldab, m, n, btest)
      call cmatml(atest,lda,m,n,pp,ldpp,m,atest,lda,work,3)
      call cmatmr(atest,lda,m,n,qq,ldqq,n,atest,lda,work,1)
       if(idbg(1).ge.2) call cmatpr(atest,lda,m,n,'pp'' * a * qq')
      call cmatml(btest,ldb,m,n,pp,ldpp,m,btest,ldb,work,3)
      call cmatmr(btest,ldb,m,n,qq,ldqq,n,btest,ldb,work,1)
       if(idbg(1).ge.2) call cmatpr(btest,ldb,m,n,'pp'' * b * qq')
      difa=0
      difb=0
      do 20 i=1,m
        do 30 j=1,n
          difa = difa+abs(a(i,j)-atest(i,j))
          difb = difb+abs(b(i,j)-btest(i,j))
  30    continue
  20  continue
c
      adife = cdife(a,atest,ldab,m,n)
      bdife = cdife(b,btest,ldab,m,n)
      anore = cnorm(a,ldab,m,n,0,work)
      bnore = cnorm(b,ldab,m,n,0,work)
c
      rdifa = difa
      if (anore .gt. 0.) rdifa = difa / anore
      rdifb = difb
      if (bnore .gt. 0.) rdifb = difb / bnore
      radife = adife
      if (anore .gt. 0.) radife = adife / anore
      rbdife = bdife
      if (bnore .gt. 0.) rbdife = bdife / bnore
      maxrda = radife
      maxrdb = rbdife
c
        write(6,105) 'abs(a-acopy)=',difa,'relative dif.=',rdifa
        write(6,105) 'abs(b-bcopy)=',difb,'relative dif.=',rdifb
        write(6,105) 'fro(a-pp" * acopy * qq)=', adife
        write (6,105) 'relative fro for a-part=', radife
        write (6,105) 'fro(b-pp" * bcopy * qq)=', bdife
        write (6,105) 'relative fro for b-part=', rbdife
c
c**** compute error bounds for reducing subspaces
c     containing right singular part and eigenvalues
c     specified by ftest
c     
c     skip if right or left reducing subspace is zero or full dimensional
c     colrs = dimension of right reducing subspace
c     rowrs = dimension of left reducing subspace
c     allreg = dimension of the whole regular part 06/16/87
      colrs = nsumrz - djordz + ndim
      rowrs = rsumrz - djordz + ndim 
      len = allreg - ndim
c
      write(6, 2000) 'colrs=', colrs, 'rowrs=', rowrs, 'len=', len
 2000 format(t5,a,i5)
c
c**** 6/22/87, compute workspace, stop if insufficient
      call bndwsp(m,n,rowrs+1,colrs+1,len,ecase,space,info)
      write(6,2000) ' bndwsp'
      write(6,2000) 'ecase=',ecase,'space=',space,'info=',info
      if (info.eq.1 .or. space.gt.wdim) stop
c
c**** 6/21/87 stop if no tests desired
      if (numtst .eq. 0) stop
c
c     deleted singular values cannot be  less than epsu*(norma+normb)
      dsvd = max(dsvd, epsu*( anormf + bnormf ))
c
c*** 06/16/87 new version of bounds
c     compute difl, difu, qnorm,pnorm, etc and eigenvalue bounds
      call bound(a, b, ldab, m ,n, rowrs+1, colrs+1, len,
     *           evala, evalb, delmax, gvcond, pqnorm, ecase,
     *           pdelta, difl, difu, qnorm, pnorm, icase,
     *           work, ierr)
c
      write(6, 2000) ' icase= ', icase, ' ecase= ', ecase,
     +               ' ierr= ', ierr
      write(6,203) 'delmax=',delmax,'pdelta=',pdelta,'difl=',difl,
     +             'difu=',difu,'qnorm=',qnorm,'pnorm=',pnorm,
     +             'pqnorm=',pqnorm,'dsvd=',dsvd
c
c***   6/18/87 bounds for trivial spaces handled by bound, icase
c      pbndok = colrs .gt. 0 .and. rowrs .lt. m
       pbndok = .true.
c
      if (pbndok) then
c****    evaluate space - bounds
         call evalbd( dsvd, pdelta, qnorm, pnorm, icase, m, n,
     *                rowrs+1, colrs+1, lbndup, rbndup, lbndlw, rbndlw)
c
        write(6,106) difl,difu,qnorm,pnorm,dsvd,pdelta,lbndup,rbndup,
     +               lbndlw,rbndlw,ierr
106     format(/,' results from pbound',/,' difl=  ',d20.5,
     +   /,' difu=  ',d20.5,/,' qnorm= ',d20.5,/,' pnorm= ',d20.5,
     +   /,' delta= ',d20.5,
     +   /,' pdelta=',d20.5,/,' lbndup=',d20.5,/,' rbndup=',d20.5,
     +   /,' lbndlw=',d20.5,/,' rbndlw=',d20.5,/,' ierr=  ',i3)
      endif
c
c**** compute error bounds for remaining eigenvalues
c     only if there are any (allreg.gt.ndim) and
c     no left (Kronecker) indices
c     ( rsumli .eq. nsumli )
c     note: the case with no right (Kronecker) indices
c     and a regular part can be handled by transposing the
c     output from guptri (!!??)
c     note: includes perturbation theory for regular pencils
c     ( rsumli .eq. nsumli  .and. rsumrz .eq. nsumrz)
c
c      allreg = dimreg + djordz + djordi 
c      len = allreg - ndim
c*+*+
c      ebndok = allreg .gt. ndim .and. rsumli .eq.nsumli
       ebndok = len .gt. 0
c**** changed by demmel, 6/30/86
      if ( ebndok ) then
c
         krstrt = rsumrz - djordz + ndim + 1
         kcstrt = nsumrz - djordz + ndim + 1
         info = ierr
         if (info .eq. 0) then
c         no multiple eigenvalues
          write(6, 184) 'eigenvalue bounds'
  184     format(t5,a,2d23.15)
              write(6, 105) 'delmax(capital delta for eigenv)= ',
     *                      delmax
          do 183 i = 1, len
c
            zat=  evala(i)
            zbt = evalb(i)
            if (abs(zbt) .eq. 0.) then
               write(6, 184) 'infinite eigenvalue'
            else
               write(6,184) 'eigenvalue= ', zat / zbt
            endif
            write(6,108) zat, zbt, gvcond(i)
  108       format(' aii=',2d13.5,' bii=',2d13.5,' k=',d13.5)
  183     continue
        else
c         there are multiple eigenvalues
          write(6,184) 'multiple eigenvalues'
c         061387 changed
          ebndok = .false.
          do 185 i=1,len
            zat=evala(i)
            zbt=evalb(i)
            if (abs(zbt).eq.0.) then
              write(6,184) 'infinite eigenvalue'
            else
              write(6,184) 'eigenvalue=',zat/zbt
            endif
185       continue
        endif
c
      endif
c          for doing perturbation theory for eigenvalues
c
c***** compute GUPTRI forms for perturbed pencils
c
c      prepare for statistics
       do 8020 i = 1, 12
          do 8010  j = 1, 7
            sdstqt(j,i) = 0
            sdstqe(j,i) = 0
 8010     continue
          do 8012  j = 1, 3
            do 8011 k = 1, 10
              stateg(j,i,k) = 0
              if ( j .le. 2) stateg1(j,i,k) = 0
 8011       continue
 8012     continue
          do 8015 j = 1, 6
            statrs(j,i) = 0
            srqtup(j,i) = 0
            slqtup(j,i) = 0
            srqtlw(j,i) = 0
            slqtlw(j,i) = 0
            do 8013 k = 1, 10
               segqt(j,i,k) = 0
               segqt1(j,i,k) = 0
 8013       continue
 8015     continue
 8020 continue
c       write(6,*) 'statrs before 7000'
c       write(6,9500) ((statrs(i,j), j=1,11), i=1,6)
c
      badeig = 0
      ninfo = 0
      if ( numex. gt. 0 .and. numtst .gt. 0) then 
      do 7000 iper = 1, numex
c
       do 6900 itst = 1, numtst
c        perturb a and b ( copies in acopy, and bcopy)
c*+*+*+ start change 860729
         call pertb1( aorig, borig, a, b, ldab, m, n, epsbnd(iper),
     *                work,jobper,nostat)
c*+*+*+ end
         anormf = cnorm(a, ldab, m, n, 0, work)
         bnormf = cnorm(b, ldab, m, n, 0, work)
c**** compute the Kronecker structure
c

         if (nostat) then
           write(6, 100) 'start guptri for  perturbed pair no.'
           write(6, 100) 'iper= ', iper, 'itst= ', itst
         endif
c
c**** 6/16/87
         call guptri(a ,b , ldab, m, n, epsu, gap, zero,
     *               ppper, ldpp, qqper, ldqq,
     *               adsvdp, bdsvdp,
     *               rtre, rtce, zrre, zrce, fnre, fnce, inre, ince,
     *               pstruc, struc, work, kstr, info)
c
c****    6/18/87
c         if (info.ne.0) write(6,2000) 'after guptri, info=',info
         if (info.ne.0) then
           ninfo = ninfo +1
           write(6,2000) 'after guptri, info=',info
c          goto next perturbed pair
           goto 6900
         endif
         dsvdp = sqrt ( (anormf*adsvdp)**2 + (bnormf*bdsvdp)**2 )
c
c
c**** 6/16/87
c     compute step by searching through kstr 
      three = 0
      do 61689 ithree = 1, 20
        if ( three .eq. 3) go to 61690
        if( kstr(1, ithree) .eq. -1) then
          three = three + 1
        endif
61689 continue
c
      if ( three .lt. 3) then
        write(*,*) 'ERROR in kstr (computing step in driver)'
        stop
      endif
c
61690 continue
      step = ithree - 1
c***  end of computing step
c
c
c**** 6/15/87
c     compute these (not parameters to guptri any more)
      nsumrz = zrce
      rsumrz = zrre
      nsumli = n - fnce
      rsumli = m - fnre
      djordz = zrre - rtre
      djordi = inre - fnre
      dimreg = fnre - zrre
      ndim = 0
c
c*+*+     added 06/16/87 
c**** reorder the eigenvalues according to the user specified
c     integer function ftest
c
      allreg = dimreg + djordz + djordi
      rowb = rsumrz - djordz + 1
      colb = nsumrz - djordz + 1
      rowe = rowb + allreg - 1
      cole = colb + allreg - 1
      if (ldebug) then
         write(outunit, 2005) 'eigenvalues before reordering'
         do 770 i = rowb, rowe
           j = colb + i - rowb
           if (abs(b(i ,j)) .eq. 0. ) then
               write(outunit, 2005) 'infinite eigenvalue',a(i,j), b(i,j)
           else
               write(outunit, 2005) 'eigenvalue=', a(i,j)/b(i,j)
           endif
  770    continue
      endif
      if (allreg .ge. 1) then
         call reordr(a, b, ldab, m, n, rowb, colb, rowe, cole,
     *                ftest, ndim, rindx, ppper, ldpp, qqper, ldqq)
c
        if (idbg(2) .gt. 1) then
            call cmatpr(qqper,ldqq,n,n,'qqper after reordr')
            call cmatpr(ppper,ldpp,m,m,'ppper after reordr')
        endif
      endif
c
      if (ldebug) then
         write(outunit, 2005) 'eigenvalues after reorder and'
         write(outunit, 2005) 'computed eigenvalues'
         do 775 i = rowb, rowe
           j = colb + i - rowb
           if (abs(b(i ,j)) .eq. 0. ) then
               write(outunit, 2005) 'infinite eigenvalue',a(i,j), b(i,j)
           else
               write(outunit, 2005) 'eigenvalue=', a(i,j)/b(i,j)
           endif
  775    continue
       endif
c
c+*+ end add reorder*
c
         if (nostat) then
           write(6, 100) 'results from guptri and reorder, iper= ', 
     *                    iper
c
c****      6/15/87
           write(6,7357) 'rtce=',rtce,'zrce=',zrce,'fnce=',fnce,
     +                   'ince=',ince,'rtre=',rtre,'zrre=',zrre,
     +                   'fnre=',fnre,'inre=',inre
           write (6,7355) (pstruc(j),j=1,4)
           if (pstruc(4).gt.0) write (6,7356)(struc(j),j=1,pstruc(4))
c
           write (6,123) nsumrz,rsumrz,djordz,nsumli,rsumli,djordi,
     *                   dimreg, ndim
           write(6,200) 'Relative perturbation in a= ', adsvdp
           write(6,200) 'Relative perturbation in b= ', bdsvdp
           write(6,200) 'Frobeniusnorm of deleted singular values=',
     *                  dsvdp
           write(6, 100) 'kstr, step=',step
           do 710 i = 1, 2
              write(6, 300) (kstr(i,j), j = 1, step)
  710      continue
           if (idbg(1).ge.1) 
     *        call cmatpr(a,lda,m,n,'Transformed matrix A')
           if (idbg(1).ge.1) 
     *        call cmatpr(b,ldb,m,n,'Transformed matrix B')
           if(idbg(1).ge.2) call cmatpr(ppper, ldpp, m, m, 'PPper')
           if(idbg(1).ge.2) call cmatpr(qqper, ldqq, n, n, 'QQper')
           cpp=cond(ppper,ldpp,m,m,work)
           write(6, 105) 'cond(PPper)=', cpp
           cqq=cond(qqper,ldqq,n,n,work)
           write(6, 105) 'cond(QQper)=', cqq
         endif  
c
         call cmcopy(acopy, ldab, m, n, atest)
         call cmcopy(bcopy, ldab, m, n, btest)
         call cmatml(atest,lda,m,n,ppper,ldpp,m,atest,lda,work,3)
         call cmatmr(atest,lda,m,n,qqper,ldqq,n,atest,lda,work,1)
         if (idbg(1).ge.2)
     *      call cmatpr(atest,lda,m,n,'ppper'' * aper * qqper')
         call cmatml(btest,ldb,m,n,ppper,ldpp,m,btest,ldb,work,3)
         call cmatmr(btest,ldb,m,n,qqper,ldqq,n,btest,ldb,work,1)
         if (idbg(1).ge.2) 
     *       call cmatpr(btest,ldb,m,n,'pperp'' * bper * qqper')
         difa=0
         difb=0
         do 720 i=1,m
           do 730 j=1,n
              difa=difa+abs(a(i,j)-atest(i,j))
              difb=difb+abs(b(i,j)-btest(i,j))
  730      continue
  720    continue
c
         adife = cdife(a,atest,ldab,m,n)
         bdife = cdife(b,btest,ldab,m,n)
         anore = cnorm(a,ldab,m,n,0,work)
         bnore = cnorm(b,ldab,m,n,0,work)
c
         rdifa = difa
         radife = adife
         if (anore .gt. 0.) then
           rdifa = difa / anore
           radife = adife / anore
         endif
         rbdife = bdife
         rdifb = difb
         if (bnore .gt. 0.) then
           rbdife = bdife / bnore
           rdifb = difb / bnore
         endif
c
c       collect maximum values of radife, rbdife
         maxrda = max(maxrda, radife)
         maxrdb = max(maxrdb, rbdife)
c
         if (nostat) then
          write(6,105)'abs(a-acopy)=',difa,'relative dif.=',rdifa
          write(6,105)'abs(b-bcopy)=',difb,'relative dif.=',rdifb
          write(6,105)'fro(a-pp" * acopy * qq)=', adife
          write (6,105)'relative fro for a-part=', radife
          write (6,105) 'fro(b-pp" * bcopy * qq)=', bdife
          write (6,105) 'relative fro for b-part=', rbdife
         endif
c
c
c        compute the dimensions of perturbed reducing subspaces
         pcolrs = nsumrz - djordz + ndim
         prowrs = rsumrz - djordz + ndim
c
c*+*+
c        save eigenvalues for later use
         do 223 jjj=pcolrs+1,n
           evalap(jjj-pcolrs)=a(jjj-pcolrs+prowrs,jjj)
           evalbp(jjj-pcolrs)=b(jjj-pcolrs+prowrs,jjj)
223      continue
c        compute the distance between the matrix pairs on
c        the (nongeneric) surface
c
c        compute a = ppper * a * qqper**H and
c                b = ppper * b * qqper**H
         call cmatml(a,ldab,m,n,ppper,ldpp,m,a,ldab,work,1)
         call cmatmr(a,ldab,m,n,qqper,ldqq,n,a,ldab,work,3)
         call cmatml(b,ldab,m,n,ppper,ldpp,m,b,ldab,work,1)
         call cmatmr(b,ldab,m,n,qqper,ldqq,n,b,ldab,work,3)
         if (idbg(1) .ge. 2) then
           call cmatpr(a,ldab,m,n,'final aprimprim')
           call cmatpr(b,ldab,m,n,'final bprimprim')
         endif
c
c        compute dist = distance between pencils on manifold
         dist = sqrt( cdife(aprim, a, ldab, m, n) ** 2 +
     *                cdife(bprim, b, ldab, m, n) ** 2 )
         dstqt = dist/epsbnd(iper)
c870526         seps1 = 1.0 / sqrt(epsbnd(iper))
c         seps2 = 1.0 / (epsbnd(iper) ** 0.75)
         if (dstqt .le. 1.0) then
           sdstqt(1,iper) = sdstqt(1,iper) + 1
         elseif (dstqt .le. 10.0) then 
           sdstqt(2,iper) = sdstqt(2,iper) + 1
         elseif (dstqt .le. 100.0) then 
           sdstqt(3,iper) = sdstqt(3,iper) + 1
         elseif (dstqt .le. 1000.0) then 
           sdstqt(4,iper) = sdstqt(4,iper) + 1
         elseif (dstqt .le. 10000.0) then
           sdstqt(5,iper) = sdstqt(5,iper) + 1
         elseif (dstqt .le. 100000.0) then
           sdstqt(6,iper) = sdstqt(6,iper) + 1
         else 
           sdstqt(7,iper) = sdstqt(7,iper) + 1
         endif
c
         if (iper .eq. 1 .and. itst .eq. 1 ) then
              minqt = dstqt
              avrqt = dstqt
              maxqt = dstqt
         else
              minqt = min(minqt,dstqt)
              avrqt = avrqt + dstqt
              maxqt = max(maxqt,dstqt)
         endif
c
c        compute the true distance between perturbed and unperturbed
c        input pencils
         dstpu = sqrt( cdife(acopy, aorig, ldab, m, n)**2
     *               + cdife(bcopy, borig, ldab, m, n)**2 )
         if (dstpu.eq.0.) dstpu = 1.
         dstqe = dist / dstpu
         if (dstqe .le. 1.0) then
           sdstqe(1,iper) = sdstqe(1,iper) + 1
         elseif (dstqe .le. 10.0) then 
           sdstqe(2,iper) = sdstqe(2,iper) + 1
         elseif (dstqe .le. 100.0) then 
           sdstqe(3,iper) = sdstqe(3,iper) + 1
         elseif (dstqe .le. 1000.0) then 
           sdstqe(4,iper) = sdstqe(4,iper) + 1
         elseif (dstqe .le. 10000.0) then
           sdstqe(5,iper) = sdstqe(5,iper) + 1
         elseif (dstqe .le. 100000.0) then
           sdstqe(6,iper) = sdstqe(6,iper) + 1
         else 
           sdstqe(7,iper) = sdstqe(7,iper) + 1
         endif
c
         if (iper .eq. 1 .and. itst .eq. 1 ) then
              minqe = dstqe
              avrqe = dstqe
              maxqe = dstqe
         else
              minqe = min(minqe,dstqe)
              avrqe = avrqe + dstqe
              maxqe = max(maxqe,dstqe)
         endif
c
cc        compute distup = upper bound on dist from triangle ineq
         distup = sqrt(dsvd**2 + dsvdp**2 + 
     +                 m*n*epsbnd(iper)**2/72.)
         if (nostat) then
           write(6, 789) 'perturbation results for iper= ',iper,
     +                   '  itst= ', itst,'  epsbnd =',epsbnd(iper)
789        format(//,t5,a,i3,a,i3,a,d15.5)
           write(6, 105) 'dist =', dist, 'distup =',distup
           write(6, 100) 'pcolrs =', pcolrs, 'prowrs =', prowrs
         endif
c****    compute angles between reducing subspaces of unperturbed
c        and perturbed pencils
c
         if (pcolrs .eq. colrs .and. prowrs .eq. rowrs .and. pbndok)
     *   then
c
c        the perturbed reducing subspaces of same (nontrivial)
c        dimensions as unperturbed reducing subspaces
              if (nostat) write(6,105) 'pdelta =', pdelta
c*+*+
              if (dist .ge. pdelta .and. pdelta .ne. -1.) then
c
c                perturbation theory does not work 
                 if (nostat) then
                   write(6, 207) 'perturbation theory does not work '
                 endif
                 statrs(1,iper) = statrs(1,iper) + 1
c       write(6,*) 'Row 1'
c       write(6,9500) ((statrs(i,j), j=1,11), i=1,6)
               else
c                compute new upper bounds on angles
c
                 relerr = dist / pdelta
                 if (icase .eq. 1 ) then
                   lbdupp = atan( relerr/( pnorm - relerr *
     *                      sqrt( pnorm**2 - 1.0)))
                   rbdupp = atan( relerr/( qnorm - relerr *
     *                      sqrt( qnorm**2 - 1.0)))
c
c                  multiply pp(1:m,rowrs+1:m)**h * ppper(1:m, 1:rowrs)
c                  giving a m-rowrs by rowrs matrix in work
                   call cmatml( ppper, ldpp, m, rowrs, pp(1, rowrs+1),
     *                         ldpp , m-rowrs, work(1), ldpp, dum, 4)
c
c                  compute angle between left reducing subspaces
                   thetal = asin( cnorm(work,ldpp, m-rowrs, rowrs, 2,
     *                            work(ldpp*ldpp+1)))
c
c                  multiply qq(1:n,colrs+1:n)**h * qqper(1:n, 1:colrs)
c                  giving a n-colrs by colrs matrix in work
                   call cmatml( qqper, ldqq, n, colrs, qq(1, colrs+1),
     *                          ldqq , n-colrs, work(1), ldqq, dum, 4)
c
c                  compute angle between right reducing subspaces
                   thetar = asin( cnorm(work,ldqq, n-colrs, colrs, 2,
     *                            work(ldqq*ldqq+1)))
c
                 elseif ( icase .eq. 2) then
                   lbdupp = 0.
                   thetal = 0.
                   rbdupp = atan( relerr/(1.-relerr))
c                  multiply qq(1:n,colrs+1:n)**h * qqper(1:n, 1:colrs)
c                  giving a n-colrs by colrs matrix in work
                   call cmatml( qqper, ldqq, n, colrs, qq(1, colrs+1),
     *                          ldqq , n-colrs, work(1), ldqq, dum, 4)
c
c                  compute angle between right reducing subspaces
                   thetar = asin( cnorm(work,ldqq, n-colrs, colrs, 2,
     *                            work(ldqq*ldqq+1)))
c
                 elseif (icase .eq. 3) then
                   rbdupp = 0.
                   thetar = 0.
                   lbdupp = atan ( relerr/(1.-relerr))
c                  multiply pp(1:m,rowrs+1:m)**h * ppper(1:m, 1:rowrs)
c                  giving a m-rowrs by rowrs matrix in work
                   call cmatml( ppper, ldpp, m, rowrs, pp(1, rowrs+1),
     *                         ldpp , m-rowrs, work(1), ldpp, dum, 4)
c
c                  compute angle between left reducing subspaces
                   thetal = asin( cnorm(work,ldpp, m-rowrs, rowrs, 2,
     *                            work(ldpp*ldpp+1)))
c
c***             6/18/87 fix, add icase=4
                 elseif (icase .eq. 4) then
                   rbdupp = 0.
                   lbdupp = 0.
                   thetar = 0.
                   thetal = 0.
                 endif
c
c                test perturbation theorem
                 if ( rbdupp .ge. thetar .and. lbdupp .ge. thetal)
     *           then
c                  case 1 of theorem holds
                   if (nostat) then
                     write(6,207) 'case 1 of theorem holds'
                   endif
                   statrs(2,iper) = statrs(2,iper) + 1
c      write(6,*) 'Row 2'
c      write(6,9500) ((statrs(i,j), j+1,11), 1=1,6)
                   rqtup = 1.
                   if ( thetar .ne. 0.) rqtup = rbdupp / thetar
                   lqtup = 1.
                   if ( thetal .ne. 0.) lqtup = lbdupp / thetal
                   if (1 . le. rqtup .and. rqtup .le. 10.0) then
                     srqtup(1,iper) = srqtup(1,iper) + 1
                   elseif (rqtup .le. 100.0) then
                     srqtup(2,iper) = srqtup(2,iper) + 1
                   elseif (rqtup .le. 1000.0) then
                     srqtup(3,iper) = srqtup(3,iper) + 1
                   elseif (rqtup .le. 10000.0) then
                     srqtup(4,iper) = srqtup(4,iper) + 1
                   elseif (rqtup .le. 100000.0) then
                     srqtup(5,iper) = srqtup(5,iper) + 1
                   else
                     srqtup(6,iper) = srqtup(6,iper) + 1
                   endif
c
                   if( iper .eq. 1 .and. itst .eq. 1 ) then
                        minrup = rqtup
                        avrrup = rqtup
                        maxrup = rqtup
                   else
                        minrup = min(minrup, rqtup)
                        avrrup = avrrup + rqtup
                        maxrup = max(maxrup, rqtup)
                   endif
c
c
                   if (1 .le. lqtup .and. lqtup .le. 10.0) then
                     slqtup(1,iper) = slqtup(1,iper) + 1
                   elseif (lqtup .le. 100.0) then
                     slqtup(2,iper) = slqtup(2,iper) + 1
                   elseif (lqtup .le. 1000.0) then
                     slqtup(3,iper) = slqtup(3,iper) + 1
                   elseif (lqtup .le. 10000.0) then
                     slqtup(4,iper) = slqtup(4,iper) + 1
                   elseif (lqtup .le. 100000.0) then
                     slqtup(5,iper) = slqtup(5,iper) + 1
                   else
                     slqtup(6,iper) = slqtup(6,iper) + 1
                   endif
c
                   if( iper .eq. 1 .and. itst .eq. 1 ) then
                        minlup = lqtup
                        avrlup = lqtup
                        maxlup = lqtup
                   else
                        minlup = min(minlup, lqtup)
                        avrlup = avrlup + lqtup
                        maxlup = max(maxlup, lqtup)
                   endif
c****            6/19/87
                 elseif ((rbndlw .le. thetar .and. rbndlw.ne.-1.)
     +           .or. (lbndlw .le. thetal .and. lbndlw.ne.-1.))
     +           then
c                  case 2 of theorem holds
                   if (nostat) then
                     write(6,207)'case 2 of theorem holds'
                   endif
                   statrs(3,iper) = statrs(3,iper) + 1
c       write(6,*) 'Row 3'
c       write(6,9500) ((statrs(i,j), j=1,11), i=1,6)
                   rqtlw = thetar / rbndlw
                   lqtlw = thetal / lbndlw
                   if (1 .le. rqtlw .and. rqtlw .le. 10.0) then
                     srqtlw(1,iper) = srqtlw(1,iper) + 1
                   elseif (rqtlw .le. 100.0) then
                     srqtlw(2,iper) = srqtlw(2,iper) + 1
                   elseif (rqtlw .le. 1000.0) then
                     srqtlw(3,iper) = srqtlw(3,iper) + 1
                   elseif (rqtlw .le. 10000.0) then
                     srqtlw(4,iper) = srqtlw(4,iper) + 1
                   elseif (rqtlw .le. 100000.0) then
                     srqtlw(5,iper) = srqtlw(5,iper) + 1
                   else
                     srqtlw(6,iper) = srqtlw(6,iper) + 1
                   endif
c
                   if ( iper .eq. 1 .and. itst .eq. 1 ) then
                        minrlw = rqtlw
                        avrrlw = rqtlw
                        maxrlw = rqtlw
                   else
                        minrlw = min(minrlw, rqtlw)
                        avrrlw = avrrlw + rqtlw
                        maxrlw = max(maxrlw, rqtlw)
                   endif
c
                   if (1 .le. lqtlw .and. lqtlw .le. 10.0) then
                     slqtlw(1,iper) = slqtlw(1,iper) + 1
                   elseif (lqtlw .le. 100.0) then
                     slqtlw(2,iper) = slqtlw(2,iper) + 1
                   elseif (lqtlw .le. 1000.0) then
                     slqtlw(3,iper) = slqtlw(3,iper) + 1
                   elseif (lqtlw .le. 10000.0) then
                     slqtlw(4,iper) = slqtlw(4,iper) + 1
                   elseif (lqtlw .le. 100000.0) then
                     slqtlw(5,iper) = slqtlw(5,iper) + 1
                   else
                     slqtlw(6,iper) = slqtlw(6,iper) + 1
                   endif
c
                   if ( iper .eq. 1 .and. itst .eq. 1 ) then
                        minllw = lqtlw
                        avrllw = lqtlw
                        maxllw = lqtlw
                   else
                        minllw = min(minllw, lqtlw)
                        avrllw = avrrlw + lqtlw
                        maxllw = max(maxllw, lqtlw)
                   endif
c
                 else
c                  theorem false !!!!!!!!! ?
                   if (nostat) then
                     write(6, 207) ' theorem false !!??'
                   endif
                   statrs(4,iper) = statrs(4,iper) + 1
c       write(6,*) 'Row 4'
c       write(6,9500) ((statrs(i,j), j=1,11), i=1,6)
                 endif
                   if (nostat) then
                     write(6,105) 'rbndlw =', rbndlw
                     write(6,105)  'lbndlw =', lbndlw
                     write(6,105) 'rbdupp =', rbdupp
                     write(6,105)  'lbdupp =', lbdupp
                     write(6, 105) 'thetar=', thetar
                     write(6,105) 'thetal =', thetal
                   endif
c                 close perturbation theory applies
                endif
         else
c***             this case now taken case of above
c                 if (pcolrs .eq. n .and. prowrs .eq. m) then
c                    if (nostat) then
c                      write(6,*) ' Reducing subspaces span the',
c     *                ' full space (completely controllable)'
c                    endif
c                    statrs(5,iper) = statrs(5,iper) + 1
c       write(6,*) 'Row 5'
c       write(6,9500) ((statrs(i,j), j=1,11), i=1,6)
c                  else
                    if (nostat) then
                      write(6,*) ' Different sizes of perturbed and',
     *                ' unperturbed reducing subspaces',
     *                ' colrs, rowrs = ', colrs, rowrs,
     *                ' pcolrs, prowrs= ', pcolrs, prowrs
                    endif
                    statrs(6,iper) = statrs(6,iper) + 1
c       write(6,*) 'Row 6'
c       write(6,9500) ((statrs(i,j), j=1,11), i=1,6)
c                  endif
c        close perturbation theory
         endif
c
c****    6/25/87 new eigenvalue perturbation theory for multiple 
c        eigenvalues
         if (len.gt.0 .and. pcolrs.eq.colrs .and. prowrs.eq.rowrs
     +       .and. len .eq. dimreg+djordz+djordi-ndim) then
           write(6,225) 'new eigenbound test for iper=', iper
c
c          the same ebnd for all eigenvalues (see IEEE CDC paper)
           ebnd = dist * pqnorm
           sstrt = abdim**2 +1
           estrt = sstrt + abdim +1
           wstrt = estrt + abdim +1
           if (idbg(1).gt.1) write(6,*) 'sstrt,estrt,wstrt,len=',
     +                                   sstrt,estrt,wstrt,len
           do 226 ieig = 1,len
             zat = evalap(ieig)
             zbt = evalbp(ieig)
             scl=sqrt(abs(zat)**2 + abs(zbt)**2)
             zat = zat/scl
             zbt = zbt/scl
             write(6,100) 'compare eigenvalues ',ieig
             if (abs(evalb(ieig)).eq.0.0) then
               write(6,184) 'unperturbed eigenvalue = infinity'
             else
               write(6,184) 'unperturbed eigenvalue = ', 
     +                    evala(ieig)/evalb(ieig)
             endif
             if (abs(zbt).eq.0.0) then
               write(6,184) '  perturbed eigenvalue = infinity'
             else
               write(6,184) '  perturbed eigenvalue = ', 
     +                      zat/zbt
             endif
c            compute smallest singular value of zat*breg-zbt*areg,
c            where areg - lambda breg is selected regular part of
c            unperturbed pencil             
             call edist(work,abdim,len,aortr(prowrs+1,pcolrs+1),abdim,
     +                  bortr(prowrs+1,pcolrs+1),abdim,zat,zbt)
             if (idbg(1).gt.1) then
               call cmatpr(work,abdim,len,len,'input to svd')
               call cmatpr(aortr(prowrs+1,pcolrs+1),abdim,len,len,
     +                     'regular part of original a')
               call cmatpr(bortr(prowrs+1,pcolrs+1),abdim,len,len,
     +                     'regular part of original b')
             endif
             call zsvdc(work,abdim,len,len,work(sstrt),work(estrt),
     +                  dummy,abdim,dummy,abdim,work(wstrt),0,info)
             if (info .ne. 0) then
c              svd did not converge
               write(6,*) 'nonconvergent svd of edist - info,ieig =',
     +                       info,ieig
               call cmatpr(work(sstrt),1,1,len,'singular values')
               call cmatpr(work(estrt),1,1,len,
     +                     'superdiagonals, should be 0')
             else
               if (idbg(1).gt.1) then
                 write(6,*) 'zat=',zat
                 write(6,*) 'zbt=',zbt
                 call cmatpr(work(sstrt),1,1,len,'singular values')
                 call cmatpr(work(estrt),1,1,len,
     +                       'superdiagonals, should be 0')
               endif
               edif = real(work(sstrt+len-1))
c****          06/26/87 collects statistics for new eigenvalue bounds
c
               if (ebnd .ge. edif) then
                 write(6,224) 'eigenbound holds with ebnd=',ebnd,
     +                        ' edif=',edif
                 stateg1(1,iper,ieig) = stateg1(1,iper,ieig) + 1 
                 if ( edif .ne. 0.0 ) then
                    egqt = ebnd / edif
                 else
c                   06/27/87
c                   in theory the eigenvalues can be perturbed by dist 
c                   egqt = ebnd / dist = pqnorm
                    egqt = pqnorm
                 endif
                 if ( 1.0 .le. egqt .and. egqt .le. 10.0) then
                   segqt1(1,iper,ieig) = segqt1(1,iper,ieig) + 1
                 elseif (egqt .le. 100.0) then
                   segqt1(2,iper,ieig) = segqt1(2,iper,ieig) + 1
                 elseif (egqt .le. 1000.0) then
                   segqt1(3,iper,ieig) = segqt1(3,iper,ieig) + 1
                 elseif (egqt .le. 10000.0) then
                   segqt1(4,iper,ieig) = segqt1(4,iper,ieig) + 1
                 elseif (egqt .le. 100000.0) then
                   segqt1(5,iper,ieig) = segqt1(5,iper,ieig) + 1
                 else
                   segqt1(6,iper,ieig) = segqt1(6,iper,ieig) + 1
                 endif
c
                   if( iper .eq. 1 .and. itst .eq. 1 ) then
                        minegq1(ieig) = egqt
                        avregq1(ieig) = egqt
                        maxegq1(ieig) = egqt
                   else
                        minegq1(ieig) = min(minegq1(ieig), egqt)
                        avregq1(ieig) = avregq1(ieig) + egqt
                        maxegq1(ieig) = max(maxegq1(ieig), egqt)
                   endif
c
               else
                 write(6,224) 'eigenbound false with ebnd=',ebnd,
     +                        ' edif=',edif
                 stateg1(2,iper,ieig) = stateg1(2,iper,ieig) + 1 
               endif
c            end of perturbation theory for eigenvalue no. ieig
             endif
c          treat the next eigenvalue
 226       continue
c        end of new perturbation theory for all eigenvalues
         endif
c****    end of revision for statistics 06/26/87
c*+*+
c        perturbation theory for eigenvalues
c        test eigenvalue bounds if
c          we computed them for the unperturbed pencil (ebndok) and
c          the perturbed reducing subspaces are of the same dimension
c            as the unperturbed ones 
c            (pcolrs.eq.colrs.and.prowrs.eq.rowrs) and
c          the perturbed pencil has no right Kronecker indices
c            (nsumli .eq. rsumli)
c        assume the eigenvalues are in the right order for comparison
c         if (ebndok .and. pcolrs.eq.colrs .and. prowrs.eq.rowrs
c     +       .and. nsumli.eq.rsumli) then
c         if number of eigenvalues outside reducing subspace both .gt. 0
c         and the same for perturbed and unperturbed pencils
         if ( dist .gt. delmax .and. delmax .ge. 0) then
            badeig = badeig + 1
            write(6,105) 'eigenvalue theory does not apply'
c           NOTE: this will screw up the statistics as it is now!!
         endif
         if (ebndok .and. pcolrs.eq.colrs .and. prowrs.eq.rowrs
     +       .and. len .eq. dimreg+djordz+djordi-ndim) then
           if (nostat) then
             write(6,225) 'test eigenbounds for iper= ',iper
225          format(//,a,i3)
           endif
           do 222 ieig=1,len
             zat = evalap(ieig)
             zbt = evalbp(ieig)
             scl=sqrt(abs(zat)**2 + abs(zbt)**2)
             zat = zat/scl
             zbt = zbt/scl
             ebnd = dist * gvcond(ieig)
             edif = abs(zat*evalb(ieig)-zbt*evala(ieig))
             if (nostat) then
               write(6,100) 'compare eigenvalues ',ieig
               if (abs(evalb(ieig)).eq.0.0) then
                 write(6,184) 'unperturbed eigenvalue = infinity'
               else
                 write(6,184) 'unperturbed eigenvalue = ', 
     +                      evala(ieig)/evalb(ieig)
               endif
               if (abs(zbt).eq.0.0) then
                 write(6,184) '  perturbed eigenvalue = infinity'
               else
                 write(6,184) '  perturbed eigenvalue = ', 
     +                        zat/zbt
               endif
c            close if (nostat)
             endif
c
             infnt = .false.
             if (abs(evalb(ieig)) .eq. 0.0) infnt = .true.
             infntp = .false.
             if( abs(zbt) .eq. 0.0) infntp = .true.
c            06/18/87 perturbation theory works fine with simple
c            infinite eigenvalues too
c             if (ebnd.ge.edif .and. (.not. infnt) .and.
c     *           (.not. infntp)) then
c
              if (ebnd .ge. edif) then
                 if (nostat) then
                   write(6,224) 'eigenbound holds with ebnd=',ebnd,
     +                          ' edif=',edif
224                format(t5,a,d15.5,a,d15.5)
                 endif
                 stateg(1,iper,ieig) = stateg(1,iper,ieig) + 1 
                 if ( edif .ne. 0.0 ) then
                    egqt = ebnd / edif
                 else
c                   06/27/87 same reason as for new bounds (see above)
                    egqt = gvcond(ieig)
                 endif
                 if ( 1.0 .le. egqt .and. egqt .le. 10.0) then
                   segqt(1,iper,ieig) = segqt(1,iper,ieig) + 1
                 elseif (egqt .le. 100.0) then
                   segqt(2,iper,ieig) = segqt(2,iper,ieig) + 1
                 elseif (egqt .le. 1000.0) then
                   segqt(3,iper,ieig) = segqt(3,iper,ieig) + 1
                 elseif (egqt .le. 10000.0) then
                   segqt(4,iper,ieig) = segqt(4,iper,ieig) + 1
                 elseif (egqt .le. 100000.0) then
                   segqt(5,iper,ieig) = segqt(5,iper,ieig) + 1
                 else
                   segqt(6,iper,ieig) = segqt(6,iper,ieig) + 1
                 endif
c
                   if( iper .eq. 1 .and. itst .eq. 1 ) then
                        minegq(ieig) = egqt
                        avregq(ieig) = egqt
                        maxegq(ieig) = egqt
                   else
                        minegq(ieig) = min(minegq(ieig), egqt)
                        avregq(ieig) = avregq(ieig) + egqt
                        maxegq(ieig) = max(maxegq(ieig), egqt)
                   endif
c
             else
                 if (nostat) then
                   write(6,224) 'eigenbound false with ebnd=',ebnd,
     +                          ' edif=',edif
                 endif
                 stateg(2,iper,ieig) = stateg(2,iper,ieig) + 1 
             endif
222      continue
         else
c           no perturbation theory for eigenvalues 
c           we have no theory for len eigenvalues, 6/13/87
            stateg(3,iper,1) = stateg(3,iper,1) + len 
         endif
c*+*+
c       next itst   (1,.. ,numtst)
 6900  continue
c*+*+   next iper   (1,..., numper)
c       collect statistics
        do 6910 j = 1, 3
           do 6909 k = 1, 10 
             stateg(j,11,k) = stateg(j,11,k) + stateg(j,iper,k)
             if ( j .le. 2) then
               stateg1(j,11,k) = stateg1(j,11,k) + stateg1(j,iper,k)
             endif
 6909      continue
 6910   continue
        do 6920 j = 1, 7
           sdstqe(j,11) = sdstqe(j,11) + sdstqe(j,iper)
           sdstqt(j,11) = sdstqt(j,11) + sdstqt(j,iper)
 6920   continue
        do 6930 j = 1, 6
           statrs(j,11) = statrs(j,11) + statrs(j,iper)
           srqtup(j,11) = srqtup(j,11) + srqtup(j,iper)
           slqtup(j,11) = slqtup(j,11) + slqtup(j,iper)
           srqtlw(j,11) = srqtlw(j,11) + srqtlw(j,iper)
           srqtlw(j,11) = srqtlw(j,11) + srqtlw(j,iper)
           do 6925 k = 1, 10
             segqt(j,11,k) = segqt(j,11,k) + segqt(j,iper,k)
             segqt1(j,11,k) = segqt1(j,11,k) + segqt1(j,iper,k)
 6925      continue
 6930   continue
c
c       write(6,*) 'statrs for iper =', iper
c       write(6,9500) ((statrs(i,j), j=1,11), i=1,6)
 7000 continue
c
c       compute procentages
        do 7910 j = 1, 3
           do 7909 k = 1, 10 
             stateg(j,12,k) = nint( 100. *
     *                   float(stateg(j,11,k))/(numex * numtst))
             if ( j .le. 2) then
               stateg1(j,12,k) = nint( 100. *
     *                   float(stateg1(j,11,k))/(numex * numtst))
             endif
 7909      continue
 7910   continue
        do 7920 j = 1, 7
           sdstqe(j,12) = nint( 100. *
     *                   float(sdstqe(j,11))/(numex*numtst))
           sdstqt(j,12) = nint( 100. *
     *                   float(sdstqt(j,11))/(numex*numtst))
 7920   continue
c
        do 7930 j = 1, 6
           statrs(j,12) = nint( 100. *
     *                   float(statrs(j,11))/(numex*numtst))
           if (statrs(2,11) .gt. 0) then
             srqtup(j,12) = nint( 100. *
     *                   float(srqtup(j,11))/ statrs(2,11))
             slqtup(j,12) = nint( 100. *
     *                   float(slqtup(j,11)) / statrs(2,11))
           endif
           if (statrs(3,11) .gt. 0) then
             srqtlw(j,12) = nint( 100. *
     *                   float(srqtlw(j,11)) / statrs(3,11))
             srqtlw(j,12) = nint( 100. *
     *                   float(srqtlw(j,11)) / statrs(3,11))
           endif
           do 7925 k = 1, 10
             if (stateg(1,11,k) .gt. 0)segqt(j,12,k) = nint(100.*
     *                   float(segqt(j,11,k))/stateg(1,11,k))
             if (stateg1(1,11,k) .gt. 0)segqt1(j,12,k) = nint(100.*
     *                   float(segqt1(j,11,k))/stateg1(1,11,k))
 7925      continue
 7930   continue
cc
c     print statistics
c 
      write(6,*) '  Summary of statistics:'
      write(6,*) '  ====================='
      write(6,*)
      write(6,*) '  Number of bad svds and qzs = ninfo = ', ninfo
      write(6,*) '  Number of inapplicable eigenbounds = badeig = '
     *           , badeig
      write(6,*)
      write(6,*) '  Distance between pencils on the surface'
      write(6,*) '  divided by the true distance between perturbed'
      write(6,*) '  and unperturbed input pencils'
         write(6,9500) ((sdstqe(i,j), j= 1,12), i = 1,7)
         write(6,*) '  min = ', minqe
         write(6,*) '  average = ', avrqe/(numex * numtst)
         write(6,*) '  max = ', maxqe
c
      write(6,*)
      write(6,*) '  Distance between pencils on the surface'
      write(6,*) '  divided by the size of the perturbation (epsbnd)'
         write(6,9500) ((sdstqt(i,j), j= 1,12), i = 1,7)
         write(6,*) '  min = ', minqt
         write(6,*) '  average = ', avrqt/(numex * numtst)
         write(6,*) '  max = ', maxqt
c
      write(6,*) '  Reducing subspaces:'
       write(6,*) '  Different cases:'
        write(6,9500) ((statrs(i,j), j = 1,12), i = 1,6)
 9500   format (t5,12i4/)
c
       write(6,*) '  Case 1: right upper bounds'
           if (statrs(2,11) .gt. 0) then
                avrrup = avrrup / statrs(2,11)
                avrlup = avrlup / statrs(2,11)
           endif
         write(6,9500) ((srqtup(i,j), j = 1,12), i = 1,6)
         write(6,*) '  min = ', minrup
         write(6,*) '  average = ', avrrup
         write(6,*) '  max = ', maxrup
c
       write(6,*) '  Case 1: left upper bounds'
         write(6,9500) ((slqtup(i,j), j = 1,12), i = 1,6)
         write(6,*) '  min = ', minlup
         write(6,*) '  average = ', avrlup
         write(6,*) '  max = ', maxlup
c
       write(6,*) '  Case 2: right lower bounds'
           if (statrs(3,11) .gt. 0) then
                avrrlw = avrrlw / statrs(3,11)
                avrllw = avrllw / statrs(3,11)
           endif
         write(6,9500) ((srqtlw(i,j), j= 1,12), i = 1,6)
         write(6,*) '  min = ', minrlw
         write(6,*) '  average = ', avrrlw
         write(6,*) '  max = ', maxrlw
c
       write(6,*) '  Case 2: left lower bounds'
         write(6,9500) ((slqtlw(i,j), j= 1,12), i = 1,6)
         write(6,*) '  min = ', minllw
         write(6,*) '  average = ', avrllw
         write(6,*) '  max = ', maxllw
c
      write(6,*) '  Eigenvalues:',' number of them=', len
       if (len .gt. 0) then
         write(6,*) '  Different cases (Gerschgorin type bounds):'
          do 9110 k = 1, len
            write(6,9505) '  Eigv. no. ', k
 9505       format(a,i3)
            write(6,9500) ((stateg(i,j,k), j = 1,12), i = 1,3)
 9110     continue
         write(6,*) '  Eigenvalue bounds (upper)'
          do 9115 k = 1, len
            write(6,9505) '  Eigv. no. ', k
           write(6,9500)((segqt(i,j,k), j=1,12), i = 1,6)
           write(6,*) '  min = ', minegq(k)
           if (stateg(1,11,k) .gt. 0) then
                avregq(k) = avregq(k) / stateg(1,11,k)
           endif
           write(6,*) '  average = ', avregq(k)
           write(6,*) '  max = ', maxegq(k)
 9115     continue
c
c        print outs for new statistics
         write(6,*) '  Different cases( new bounds from LAA87):'
          do 9210 k = 1, len
            write(6,9505) '  Eigv. no. ', k
            write(6,9500) ((stateg1(i,j,k), j = 1,12), i = 1,2)
 9210     continue
         write(6,*) '  Eigenvalue bounds (upper)'
          do 9215 k = 1, len
            write(6,9505) '  Eigv. no. ', k
           write(6,9500)((segqt1(i,j,k), j=1,12), i = 1,6)
           write(6,*) '  min = ', minegq1(k)
           if (stateg1(1,11,k) .gt. 0) then
                avregq1(k) = avregq1(k) / stateg1(1,11,k)
           endif
           write(6,*) '  average = ', avregq1(k)
           write(6,*) '  max = ', maxegq1(k)
9215     continue
c        end of prints for new statistics 06/26/87
       endif
c
       write(6,*) 'Maximum values of radife, rbdife', maxrda, maxrdb
c      end of statistics
       endif
      end
c
      subroutine edist(work, ldw, len, a, lda, b, ldb, c, s)
c     implicit none
      integer ldw, lda, ldb, len
      complex*16 work(ldw,len), a(lda,len), b(ldb,len), c,s
c
      integer i,j
c 
c     compute work = c*b - s*a
c
      do 1 i=1,len
        do 2 j=1,len
          work(i,j) = c*b(i,j) - s*a(i,j)
 2      continue
 1    continue
      return
      end
