c    On this file june 13, 1987:
c    listr, ppcj
      subroutine listr (opt, a, b, ldab, m, n, rowb, rowe,
     *                  colb, cole, first, zero, epsua, epsub, gap,
     *                  pp, ldpp, qq, ldqq, kstr, kfirst, step,
     *                  adlsvd, bdlsvd,
     *                  work, x, sx, ex, q, arow, brow, w, qraux, y,
     *                  qty, info)
c
c     implicit none
c**** debug space
c     the common-block declarations assume that the dimension of the
c     input matrix pencil a - lambda b is not larger than abdim.
c     the debug space is used for producing debug outputs (optional,
c     see below)
c
      integer abdim
      parameter (abdim = 30)
      common /debug1/ acopy(abdim,abdim),bcopy(abdim,abdim),
     *                atest(abdim,abdim),btest(abdim,abdim),swap
      common /debug2/ idbg(20), outunit
      complex*16 acopy, bcopy, atest, btest
      logical swap 
      integer idbg, outunit
c
c**** formal parameter declarations
      character*(*) opt
      integer ldab, m, n, rowb, rowe, colb, cole, ldpp, ldqq,
     *        kstr(4,*), step, kfirst, info
      logical first, zero
      real*8 adlsvd, bdlsvd, epsua, epsub, gap
      complex*16 a(ldab,*), b(ldab,*),pp(ldpp,*), qq(ldqq,*),
     *           work(*)
c
c**** work space
c
        complex*16   x(m,n), sx(*), ex(*), q(m,m), 
     *               arow(*), brow(*), w(m,m), qraux(*), y(*),
     *               qty(*)
c
c*******************************************************************
c
c     listr computes the kronecker left (row) structure and
c     the jordan structure of the infinite-eigenvalue of a singular
c     pencil a-lambda*b. for details concerning the listr-kernel see 
c     the following papers:
c     
c        b.kagstrom, rgsvd - an algorithm for computing the kronecker
c             structure and reducing subspaces of singular a - lambda b
c             pencils, siam j.sci.stat.comput., vol. 7, 1986, pp 185-211
c
c        j.demmel and b.kagstrom, stably computing the kronecker 
c             structure and reducing subspaces of singular pencils
c             a - lambda b for uncertain data, in large scale eigenvalue
c             problems (cullum, willoughby eds), north holland, 1986,
c             pp 283-323.
c
c
c     formal parameters
c
c     on entry
c
c        opt*(*) character, if opt = 'cind' listr computes indices
c                           if opt = 'rind' already computed indices
c                           are reused in the reduction
c
c        a(ldab,*) complex*16, input matrix a of order m by n
c
c        b(ldab,*) complex*16, input matrix b of order m by n
c
c        ldab      integer, leading dimension of a and b
c
c        m         integer, current row dimension of a and b
c
c        n         integer, current column dimension of and b
c
c        rowb      integer, first row of the subpencil
c
c        rowe      integer, last row of the subpencil
c
c        colb      integer, first column of the subpencil
c
c        cole      integer, last column of the subpencil
c
c        first     logical, first should be 'true' if first call to 
c                  listr, else 'false'
c
c        zero      logical, if 'true', zero out small singular values
c                  so returned pencil really has structure described
c                  in kstr (see below), else returned pencil is a
c                  true equivalence transformation of input pencil
c                  (no singular values are deleted)
c
c        epsua     real*8, threshold for deleting singular values of a
c                  (used when compressing rows of a)
c
c        epsub     real*8, threshold for deleting singular values of b
c                  (used when compressing rows of b)
c
c        gap       real*8, should be at least 1 and nominally 1000.
c                  used by subroutine rcsvdc to make rank decisions
c                  by searching for adjacent singular values whose
c                  ratio exceeds gap.
c
c        ldpp      integer, leading dimension of pp
c
c        ldqq      integer, leading dimension of qq
c
c        kfirst    integer, index to the first location in kstr
c                  where structure-index information is stored
c                  from this reduction (see below)
c
c     on exit
c
c        pp(ldpp,*)complex*16, left unitary transformation matrix 
c                  pp of order m by m
c
c        qq(ldqq,*)complex*16, right unitary transformation matrix
c                  qq of order n by n
c
c        a(ldab,*) transformed matrix a (pp**h * a * qq)
c
c        b(ldab,*) transformed matrix b (pp**h * b * qq)
c
c        kstr(4,*) integer, stores information concerning left 
c                  kronecker indices and the jordan structure of
c                  the infinite eigenvalue.
c                  kstr(1,kfirst-1+j) - kstr(2,kfirst-1+j) =
c                  number of l(j-1)**t blocks (left indices of
c                  degree j-1).
c                  kstr(2,kfirst-1+j) - kstr(1,kfirst+j) = 
c                  number of jordan blocks of the infinite
c                  eigenvalue of dimension j.
c                  index j goes from 1 to step (see below)
c                  note: rows 3 and 4 of kstr are not used inside 
c                  listr.
c
c        step      integer,  the number of deflation-steps in this
c                  reduction
c
c        adlsvd    real*8, root sum of squares of deleted singular
c                  values of a (independent of the input zero)
c
c        bdlsvd    real*8, root sum of squares of deleted singular
c                  values of b (independent of the input zero)
c
c        info      integer, zero if normal return,
c                           1 if svd does not converge
c
c        on exit form listr a and b will be in block upper triangular form:
c
c
c                 a = ( a11   *  )        b = ( b11    *  )
c                     (  0   ali )            (  0    bli )
c
c       the block structure of the pencil ali - lambda*bli describes 
c       the kronecker row (left) structure and the jordan structure 
c       of the infinite eigenvalue. if ni and ri denote the dimension of
c       the diagonal blocks in ali and bli (see example below),
c       then they have the following interpretation:
c
c         ni - ri = the number of l(i-1)**t -blocks of order i by i-1
c         ri - ni+1 = the number of j(inf)-blocks of order i by i
c
c       note that if a - lambda*b is a regular pencil then ni=ri.
c       the listr reduction stops when an ni.eq.0 or ni.ne.0 but ri.eq.0. 
c       then b11 will have full row rank. a11 - lambda*b11 might
c       still be a singular pencil (can have right (column) indices). 
c       an example illustrates the two cases (see papers for details):
c       case 1 - n4.eq.0:
c
c               ( a11 a12 a13 ) n3           (  0  b12 b13 ) n3
c         ali = (  0  a22 a23 ) n2     bli = (  0   0  b23 ) n2
c               (  0   0  a33 ) n1           (  0   0   0  ) n1
c                  r3  r2  r1                   r3  r2  r1
c
c        case 2 - n4.ne.0 and r4.eq.0:
c
c                ( a11 a12 a13 ) n4          ( b11  b12 b13 ) n4
c          ali = ( a21 a22 a23 ) n3    bli = (  0   b22 b23 ) n3
c                (  0  a32 a33 ) n2          (  0   0   b33 ) n2
c                (  0   0  a43 ) n1          (  0   0    0  ) n1
c                   r3  r2  r1                   r3  r2  r1
c
c        the ni by ri subdiagonal blocks ai+1i of ali are in the form
c        (rii)
c        ( 0 ), where rii is ri by ri, nonsingular and upper triangular.
c
c        if kfirst = 1 on input then case 2 above cause the following
c        output for step and kstr:
c          step = 4
c          kstr(1,1) = n1    kstr(2,1) = r1
c          kstr(1,2) = n2    kstr(2,2) = r2
c          kstr(1,3) = n3    kstr(2,3) = r3
c          kstr(1,4) = n4    kstr(2,4) = 0
c
c        note that on output (ali,bli) or (a11,b11) can be nonexistent
c        in the block upper triangular form (a,b). (ali,bli) does not 
c        exist if n1=r1=0. (a11,b11) does not exist if the input pencil
c        a -lambda*b has no right (column) singular structure and no
c        finite eigenvalues.
c
c
c***     work space including size (all variables complex*16)
c        work(*)           max(m,n)
c        x(m,*)            m by n
c        sx(*)             min(m,n) + 1
c        ex(*)             n
c        q(m,*)            m by m
c        arow(*)           max(m,n)
c        brow(*)           max(m,n)
c        w(m,*)            m by m
c        qraux(*)          max(m,n)
c        y(*)              max(m,n)
c        qty(*)            max(m,n)
c
c*****************************************************************
c
c****    this version dated june 16, 1987
c        authors: jim demmel, bo kagstrom
c
c****    listr uses the following functions and subroutines
c        kcfpack - cmatml, cmatmr, cmatpr, cmcopy, ppcj,
c                  rcsvdc, upddel
c        linpack - zqrdc, zqrsl
c
c****    internal variables
c
        logical ldebug
        integer mrow, ncol, i, j, sn1, sr1, rep, rowsn1, colsr1, xrow
     *          , xcol, job, ldx, ldq, n1, rnull, ldw, cnull, r1
     *          , rowbm1, colbm1, idummy, ikstr, mxrc, k, iii, jjj
c
        real*8 del, difa, difb
c
        complex*16 dummy
c
c**** set leading dimensions of x, q, w
        ldx = m
        ldq = m
        ldw = m
c       set debug switch
        ldebug = idbg(5) .ne. 0
c****   compute the order of the pencil in action (mrow * ncol)
        mrow = rowe - rowb + 1
        ncol = cole - colb + 1
c
c*+*+*+ accumulate deleted singular values in adlsvd and bdlsvd
        adlsvd = 0.0
        bdlsvd = 0.0
c
      if (ldebug) then
         write (outunit,1000) 'epsua=', epsua
         write (outunit,1000) 'epsub=', epsub
      endif
c
c
c**** set rep depending on what option
c
      if ( opt .eq. 'cind' ) then
c         perhaps not enough !!
          rep = rowe * cole
      else
c         the number of deflation steps
c          rep = step - kfirst + 1
c*****      Changes made 1986-06-17
         rep = step
      endif
c***  6/18/87
      if (ldebug) write(outunit,2000) 'kfirst=',kfirst,
     +            'step=',step,'rep=',rep
      sn1 = 0
      sr1 = 0
      step = 0
c**** while rep > 0 do
   30 continue
      if (ldebug) write(outunit,2000) 'rep at top of loop=',rep
      if (rep .eq. 0) go to 500
c     jump when while - loop satisfied
c
c     while - clause
        step = step + 1
        if (ldebug) then
           write( outunit, 2000 ) 'Results from step = ', step
 2000      format( t5, a, i3/)
           write(outunit,2005) opt
 2005      format(t5,a)
        endif
c
c**** set n1 and r1 if we are reusing kstr
c
      if ( opt .eq. 'rind' ) then
         ikstr = kfirst + step - 1
         n1 = kstr(1, ikstr)
         r1 = kstr(2, ikstr)
         rnull = n1 -r1
      endif
c
c**** step 1 - compress rows of b (gives n1 = dimension of the
c              row nullspace)
c* 1.1
c      rows, rowb:rowe-sn1
c      cols, colb:cole-sr1
c------------------------------
        rowsn1 = rowe - sn1
        colsr1 = cole - sr1
c
        rowbm1 = rowb - 1
        colbm1 = colb - 1
        xrow = mrow - sn1
        xcol = ncol - sr1
c****   6/18/87 fix 
        if (opt .eq. 'rind') cnull = n1 - (xrow - xcol)
c****
        do 40 i = 1, xrow
           do 35 j = 1, xcol
              x(i, j) = b(rowbm1 + i, colbm1 + j)
   35      continue
   40   continue
        job = 1000
      if (ldebug) then
        write(outunit,5000) 'rowsn1=',rowsn1,'colsr1=',colsr1,
     *                      'xrow=',xrow
        write(outunit,5000) 'xcol=',xcol,'rowb=',rowb,'rowe=',rowe
        write(outunit,5000) 'colb=',colb,'cole=',cole,'sr1=',sr1,
     *                      'sn1=',sn1
        if ( opt .eq. 'rind') then
           write(outunit,5000) 'cnull=',cnull,'rnull=',rnull
           write(outunit,5000) 'n1=',n1,'r1=',r1
        endif
      endif
c       put m*n in info before calling (why ? 870608)
        info = m*n
        call rcsvdc (x, ldx, xrow, xcol, sx, ex, q, ldq, dummy, 1, opt,
     *               epsub, gap, cnull, n1, del, work, job, info )
c
c
        call upddel(bdlsvd, del)
c
      if (ldebug) then
        write(outunit,1000) 'bdlsvd=', bdlsvd, 'del=', del
        mxrc = min0( xrow, xcol)
        call cmatpr( sx, 1, 1, mxrc,
     *               'singular values - row compress b')
        call cmatpr( ex, 1, 1, mxrc,'sub diagonal - should be zero')
        write (outunit, 1005) 'info=', info, '(rownullity) n1=', n1
 1005   format(t5, a, i3/ )
      endif
c
        if (info .ne. 0 ) then
c***    6/18/87
          if (ldebug) write(outunit,2007) info
 2007     format('listr - after first call to rcsvdc, info =',i4)
          info = 1
          return
        endif
c     
c       if n1=0, we are done
        if (n1 .eq. 0) then
           r1=0
           goto 450
        end if
c
c* 1.2 - apply left transformation q to a and b (the full matrices)
c        cols in a and b: colb:n
c        rows in a:  rowb:rowe-sn1 ( xrow row's)
c        rows in b:  rowb:rowe-sn1
c-----------------------------------
        do 70 i = colb, n
           do 50 j = 1, xrow
              arow(j) = 0.d0
              brow(j) = 0.d0
              do 45 k = 1, xrow
                 arow(j) = arow(j) + a(rowbm1 + k, i) * conjg(q(k,j))
                 brow(j) = brow(j) + b(rowbm1 + k, i) * conjg(q(k,j))
   45         continue
   50      continue
           do 60 j = 1, xrow
                 a(rowbm1 + j, i) = arow(j)
                 b(rowbm1 + j, i) = brow(j)
   60      continue
   70   continue
c
c*         zero part of b
c          rows, rowe-sn1-n1+1:rowe-sn1
c          cols, colb:cole-sr1
c----------------------------------------
        if (zero) then
          do 80 i = rowe - sn1 - n1 + 1, rowe - sn1
             do 75 j = colb, cole - sr1
                b(i, j) = 0.d0
   75        continue
   80     continue
        endif
c
c**** Step 2 - row compress part of A ( gives n1 - r1 =
c              dimension of the common nullspace)
c
c* 2.1
c       rows, rowe-sn1-n1+1:rowe-sn1
c       cols, colb:cole-sr1
c-----------------------------------
        xrow = n1
        xcol = ncol - sr1
        do 90 i = 1, xrow
           do 85 j = 1, xcol
              x(i, j) = a( rowsn1 - n1 + i, colbm1 + j)
   85      continue
   90   continue
c
        job = 1000
        info = m*n
c****   6/18/87 fix
        if (opt .eq. 'rind') cnull = xcol - r1
c
        call rcsvdc ( x, ldx, xrow, xcol, sx, ex, w, ldw, dummy, 1, opt,
     *                epsua, gap, cnull, rnull, del, work, job, info )
c
c
        if ( opt .eq. 'cind' ) r1 = n1 - rnull
c
c       if r1 = 0 then we are done ! zero part in a and update qq
c
      if (ldebug) then
        write (outunit, 1005) 'info=', info, 'rnull=', rnull,
     *                  'n1=', n1,'r1=', r1
c
        mxrc = min0( xrow, xcol)
        call cmatpr( sx, 1, 1, mxrc,
     *               'singular values - row compress a')
        call cmatpr( ex, 1, 1, mxrc,'sub diagonal - should be zero')
      endif
c
        if (info .ne. 0) then
c****   6/18/87
          if (ldebug) write(outunit,2008) info
 2008     format('listr - after second call to rcsvdc, info= ',i4)
          info = 1
          return
        endif
c
       call upddel(adlsvd, del)
c
c
       if (r1 .eq. 0) goto 3500
c
c* 2.2
c      update left transformation q
c                rows, 1:mrow-sn1 (xrow)
c                cols, xrow-n1+1:xrow
c___________________________________________________________________
c
       xrow = mrow - sn1
       do 110 i = 1, xrow
          do 100 j = 1, n1
             arow(j) = 0.d0
             do 95 k = 1, n1
                arow(j) = arow(j) + q(i, xrow - n1 + k) * w(k, j)
   95        continue
  100     continue
c
          do 105 j = 1, n1
             q(i, xrow - n1 + j) = arow(j)
  105     continue
  110   continue
c
 1000      format(t5, a, d13.5)
        if (idbg(5) .gt. 1) then
          call cmatpr(q,ldq,mrow-sn1,mrow-sn1,'q after step 2.2')
          call cmatpr(a,ldab,m,n,'a before step 2.2')
          call cmatpr(b,ldab,m,n,'b before step 2.2')
        endif
c       
c****   now a and b ....with w too
c           rows, rowe-sn1-n1+1:rowe-sn1
c           cols, colb:n
c
c       note that we do not make use of that some of the elements
c       in b are zero
c
        do 120 i = colb,n
           do 114 j = 1, n1
              arow(j) = 0.d0
              brow(j) = 0.d0
              do 112 k = 1, n1
                 arow(j) = arow(j) + a(rowsn1-n1+k,i) * conjg(w(k,j))
                 brow(j) = brow(j) + b(rowsn1-n1+k,i) * conjg(w(k,j))
  112         continue
  114      continue
           do 116 j = 1, n1
              a(rowsn1-n1+j,i) = arow(j)
              b(rowsn1-n1+j,i) = brow(j)
  116      continue
  120   continue
        if (idbg(5) .gt. 1) then
          call cmatpr(a,ldab,m,n,'a after step 2.2')
          call cmatpr(b,ldab,m,n,'b after step 2.2')
        endif
c      
c*        zero part of a
c         rows, rowe-sn1-(n1-r1)+1:rowe-sn1
c         cols, colb:cole-sr1
c--------------------------------------------
c
 3500  continue
       if (zero) then
         if (ldebug) then
             write(outunit, 4005) 'loop indices in 130',
     *                       rowsn1 - (n1 - r1) + 1,rowsn1
             write(outunit, 4005) 'loop indices in 125', colb, colsr1
 4005       format(t5, a, 2i5)
         endif 
         do 130 i = rowsn1 - (n1 - r1) + 1,rowsn1
            do 125 j = colb, colsr1
               a(i,j) = 0.d0
  125       continue
  130    continue
       endif
       if (r1 .eq. 0) go to 350
c
c**** Step 3 - Triangularize A by a rq-decomposition ( using qr)
c
c* 3.1
c         rows, rowb:rowe-sn1-(n1-r1)
c         cols, colb:cole-sr1
c---------------------------------------------
c
          xrow = mrow - sn1 - (n1 - r1)
          xcol = ncol - sr1
c         move a(trans,conjg) with permuted columns (n,n-1,...1)
c
          do 140 i = 1, xcol
             do 135 j = 1, xrow
                 x(i, j) = conjg( a(rowsn1 - (n1-r1)+1-j, colbm1 + i))
  135        continue
  140     continue
          job = 0
         if (idbg(5) .gt. 1) then
          call cmatpr(x,ldx,xcol,xrow,'part of a before qr-decomp')
         endif
          call zqrdc( x, ldx, xcol, xrow, qraux, idummy, dummy, job)
c
c****     move the upper triangular part to a
c
          if (ldebug) then
             write(outunit, 5000) 'xrow=', xrow, 'xcol=', xcol
             write(outunit, 5000) 'rowb=',rowb, 'colb=', colb
c             call cmatpr(x,ldx,xcol,xrow,'x after call to zqrdc')
             write(outunit, 1010) 'a(rowb,colb)', a(rowb,colb)
1010         format(t5, a, 2d15.5)
          endif
          call ppcj( x, ldx, 1, xcol, 1, xrow, a(rowb, colb), ldab)
c
c         zero elements in a to make it upper triangular!
c             rows, rowe-sn1-(n1-r1)-(xcol-2):rowe-sn1-(n1-r1)
c             cols, colb:cole-sr1-1

          do 150 i = colb, cole - sr1 -1
             do 148 j = i-colb+( rowsn1-(n1-r1)-xcol+2),rowsn1-(n1-r1)
                a(j, i) = 0.d0
  148        continue
  150    continue
         if (idbg(5) .gt. 1) then
           call cmatpr(a,ldab,m,n,'A after triangularization')
         endif
c
c* 3.2
c         apply v (xcol*xcol)to remaining rows of a
c              rows, 1:rowb-1
c              cols, colb:cole-sr1
c
c-----------------------------------------------------
c
         do 170 j = 1, rowb - 1

            do 160 i = 1, xcol
               y(i) = conjg(a( j, colbm1 + i))
  160       continue
            job = 01000
            call zqrsl(x, ldx, xcol, xrow, qraux, y, dummy, qty,
     *                 dummy, dummy, dummy, job, info)
            do 165 i = 1, xcol
               a(j, colsr1-i+1) = conjg( qty(i))
  165       continue
  170    continue
         if (idbg(5) .gt. 1) then
            call cmatpr(a, ldab, m, n,
     *              ' A after triangularization - step 3.1')
         endif
c
c        apply v to b from right (xcol*xcol)
c            rows, 1:rowe-sn1-n1
c            cols, colb:cole-sr1
c----------------------------------------------------------
c
         do 185 j = 1, rowe - sn1 - n1
            do 180 i = 1, xcol
               y(i) = conjg(b(j, colbm1 + i))
  180       continue
            job = 01000
            call zqrsl(x, ldx, xcol, xrow, qraux, y, dummy, qty,
     *                 dummy, dummy, dummy, job, info)
            do 175 i = 1, xcol
               b(j, colsr1 - i + 1) = conjg(qty(i))
  175       continue
  185    continue
         if (idbg(5) .gt. 1) then
            call cmatpr(b, ldab, m, n,
     *              ' B after triangularization - step 3.1')
         endif
c
c****    update right transformation matrix qq ( n*n )
c        rows, 1:n
c        cols, colb:cole-sr1
c-----------------------------------------------------
c
         do 200 j = 1, n
            do 195 i = 1, xcol
               y(i) = conjg(qq(j ,colbm1 + i))
  195       continue
            job = 01000
            call zqrsl(x, ldx, xcol, xrow, qraux, y, dummy, qty,
     *                 dummy, dummy, dummy, job, info)
            do 198 i = 1, xcol
               qq(j, colsr1 - i + 1) = conjg(qty(i))
  198       continue
  200    continue
         if ( idbg(5) .gt. 1) then
           call cmatpr(qq,ldqq,n,n,'qq after updating')
         endif
  350    continue
c
c****    update left transformation matrix pp ( m*m )
c        rows, 1:m
c        cols, rowb:rowe-sn1
c-----------------------------------------------------
c
         xrow = mrow - sn1
         if (first) then
            do 210 i = 1, m
               do 205 j = 1, m
                  pp(i, j) = q(i, j)
  205          continue
  210       continue
        else
            do 240 i = 1, m
               do 230 j = 1, xrow
                  arow(j) = 0.d0
                  do 220 k = 1, xrow
                     arow(j) = arow(j) + pp(i, rowbm1 + k) * q(k, j)
  220             continue
  230          continue
               do 235 j = 1, xrow
                  pp(i, rowbm1 + j) = arow(j)
  235          continue
  240       continue
         endif
c       
c****    update indices
c
         sn1 = sn1 + n1
         sr1 = sr1 + r1
       if (ldebug) then
        write(outunit,5000) 'rowsn1=',rowsn1,'colsr1=',colsr1,
     *                      'xrow=',xrow
        write(outunit,5000) 'xrow=',xrow,'rowb=',rowb,'rowe=',rowe
        write(outunit,5000) 'colb=',colb,'cole=',cole,'sr1=',sr1,
     *                      'sn1=',sn1
       endif
c*       monitoring of the r1 and n1 in kstr
c
  450    continue
       if (ldebug) then
         if (swap) then
           call cmcopy(bcopy,20,m,n,atest)
           call cmcopy(acopy,20,m,n,btest)
         else
           call cmcopy(acopy,20,m,n,atest)
           call cmcopy(bcopy,20,m,n,btest)
         end if
         call cmatml(atest,20,m,n,pp,ldpp,m,atest,20,work,3)
         call cmatmr(atest,20,m,n,qq,ldqq,n,atest,20,work,1)
         call cmatml(btest,20,m,n,pp,ldpp,m,btest,20,work,3)
         call cmatmr(btest,20,m,n,qq,ldqq,n,btest,20,work,1)
         difa=0
         difb=0
         do 1234 iii=1,m
           do 5678 jjj=1,n
             difa=difa+abs(atest(iii,jjj)-a(iii,jjj))
             difb=difb+abs(btest(iii,jjj)-b(iii,jjj))
 5678      continue
 1234    continue
         write(outunit,201) 'difa=',difa
 201     format(t5,a,d13.6/)
         call cmatpr(atest,20,m,n,'atest')
         write(outunit,201) 'difb=',difb
         call cmatpr(btest,20,m,n,'btest')
        endif
c
c****    compute rep depending on what option is used
c
         if ( opt .eq. 'cind') then
            kstr(1, kfirst - 1 + step) = n1
            kstr(2, kfirst - 1 + step) = r1
c*****      changed 1986-06-17
c            rep = n1 * r1 * (mrow - sr1) * (ncol - sn1)
            rep = n1 * r1 * (ncol - sr1) * (mrow - sn1)
         else
            rep =rep - 1
         endif
         if (ldebug) then
           write(outunit,5000) 'sn1=',sn1,'sr1=',sr1,'rep=',rep
 5000      format(t5,a,i4/)
         endif
         first = .false.
         go to 30
c
c**** end of while clause
  500 continue
c
      return
      end
c
        subroutine ppcj(from,ldfrom,rowb,rowe,colb,cole,to,ldto)
c
c       take from(rowb:rowe, colb:cole), reverse the columns, reverse
c       the rows, take its conjugate transpose, and store in
c       to(1:cole-colb+1, 1:rowe-rowb+1)
        complex*16 from(ldfrom,*), to(ldto,*)
        integer rowb,rowe,colb,cole,rsum,csum
        rsum=rowe+1
        csum=cole+1
        nrow=rowe-rowb+1
        ncol=cole-colb+1
        do 1 i=1,ncol
          do 2 j=1,nrow
            to(i,j)=conjg(from(rsum-j,csum-i))
2         continue
1       continue
        return
        end
