
c   in this file june 12 1987:
c   cmatg1, pertb1, cmcopy, cdife, cnorm, cond, cmatpr, matblk1
c
c   routines here are only for debug and test, but called by guptri
c
      subroutine    cmatg1(a,lda,b,ldb,m,n,acopy,bcopy,work,job,
     *                    epsper, trpose, binfile)
c     implicit none
c**
      common /debug2/ idbg(20), outunit
      integer idbg, outunit
c
      integer       lda,ldb,m,n,job, mtemp
      real*8        epsper 
      complex*16    a(lda,lda),b(ldb,ldb),acopy(lda,lda),
     *              work(*),bcopy(ldb,ldb)
      character*80 binfile
c
c******************************************************************
c
c     this routine reads input pencil from a binary file
c     created by bpenc1.for or bpenc2.for
c     revised:    870612
c
c******************************************************************
      integer i, j, seed
      logical wanta, wantb, pertur, prints, trpose
      real*8  nea, neb, cnorm
      data seed/1234/
c
c note: if lda or ldb>= 20, then the dimensions of p and qinv have
c       to be changed
c
c
c*****    determine what is to be computed
c         only prints, pertur and trpose are used  ****
      wanta = job / 1000 .ne. 0
      wantb = mod(job,1000) / 100 .ne. 0
      pertur = mod(job,100) / 10 .ne. 0
      prints = mod(job,10 ) .ne. 0
      write( outunit, 400) 'trpose=', trpose
      write (outunit, 400) 'pertur=', pertur
      write (outunit, 400) 'prints=', prints
  400 format(t5, a, l1)
c
c     read acopy and bcopy from binary file
c
      open(15, file = binfile, form='unformatted', status='old')
      read(15) m, n
      read(15) ((acopy(i,j), j = 1, n), i = 1, m)
      read(15) ((bcopy(i,j), j = 1, n), i = 1, m)
      close(15, status ='keep')
c
c
      if (trpose) then
        do 750 i=1,m
          do 751 j=1,n
            a(j,i)=acopy(i,j)
            b(j,i)=bcopy(i,j)
751       continue
750     continue
        mtemp = m
        m = n
        n = mtemp
      else
        do 752 i=1,m
          do 753 j=1,n
            a(i,j)=acopy(i,j)
            b(i,j)=bcopy(i,j)
753       continue
752     continue
      endif
c
      if (pertur) then
c
      nea = cnorm(a,lda,m,n,0,work) * epsper
      neb = cnorm(b,ldb,m,n,0,work) * epsper
c     add perturbations to a and b
          do 50 i = 1, m
              do 50 j = 1, n
                  a(i,j) = a(i,j) + ( -0.5 +rand(seed)) * nea
                  b(i,j) = b(i,j) + ( -0.5 + rand(seed)) * neb
   50     continue
	  
	  endif
c
c     compute norm(a,e) and norm(b,e)
c
      nea = cnorm(a,lda,m,n,0,work)
      neb = cnorm(b,ldb,m,n,0,work)
      write(outunit,350) 'epsper=', epsper
      write(outunit,350) 'norm(a,e)=', nea, 'norm(b,e)=', neb
  350 format(t5,a,d12.5,tr5,a,d12.5,tr5,a,d12.5)
c
c     copy a and b to acopy and bcopy, respectively
c
      call cmcopy(a,lda,m,n,acopy)
      call cmcopy(b,ldb,m,n,bcopy)
c
      if (prints) then
        call cmatpr(a,lda,m,n,'final version of a input')
        call cmatpr(b,lda,m,n,'final version of b input')
      endif
      return
c
      end
c
      subroutine pertb1(aorig, borig, a, b, ldab,m ,n , epsbnd,
     +                  work, job, nostat)
c     implicit none
c***  debug space
      integer abdim
      parameter (abdim = 30)
      common /debug1/ acopy(abdim,abdim),bcopy(abdim,abdim), 
     +                 atest(abdim, abdim), btest(abdim,abdim), swap
      common /debug2/ idbg(20), outunit
      complex*16 acopy, bcopy, atest, btest
      integer idbg, outunit
      logical swap
c**** formal parameter declarations
      integer ldab, m, n, job
      complex*16   aorig(ldab,*), borig(ldab,*), a(ldab,*), 
     *             b(ldab,*), work(*)
      real*8 epsbnd
      logical nostat
c
c**** add random noise of relative size epsbnd to aorig and borig
c     and store in a and b 
c     job cotrols the structure of the perturbations
c     job = 1 add random perturbations to a and b
c     job = 2 add random perturbations to a
c             add random perturbations to the last n-m columns of b
c     job = 3 add general random perturbations to a only
c
c     if (idbg(11) .ne. 0 ) print out perturbed a and b
c
      real*8 nea, neb, cnorm
      integer i, j, seed, colb
      data seed/1234/
c
      nea = cnorm(aorig, ldab, m, n, 0, work) *epsbnd
      neb = cnorm(borig, ldab, m, n, 0, work) *epsbnd
c     add perturbations to a
          do 50 i = 1, m
              do 50 j = 1, n
                  a(i,j) = aorig(i,j) + (-0.5 + rand(seed)) * nea
   50     continue
           
c      add perturbations to b in columns colb to n
       if (job .eq. 1) then
          colb = 1
       elseif (job .eq. 2) then
          colb = n - m + 1
       else
c         job .eq. 3
          colb = n + 1
       endif
       if (job .eq. 1 .or. job .eq. 2) then
          if ( colb .ge. 1) then
             do 70 i = 1, m
                do 60 j = colb, n
                   b(i,j) = borig(i,j) + ( -0.5 + rand(seed)) * neb
   60           continue
                if (job .eq. 2) then
                   do 65 j = 1, colb - 1
                      b(i,j) = borig(i,j)
   65             continue
                endif
   70        continue
          else
            write(outunit,300) 'wrong dimensions! m,n=', m,n
          endif
       else
           call cmcopy(borig, ldab, m, n, b) 
       endif
c     compute  and norm(a,e),norm(b,e)
c
      if (nostat) then
        nea = cnorm(a,ldab,m,n,0,work)
        neb = cnorm(b,ldab,m,n,0,work)
        write(outunit,350) 'epsbnd=', epsbnd
        write(outunit,350) 'norm(aper,e)=', nea, 'norm(bper,e)=', neb
      endif
c
c     copy a and b to acopy and bcopy, respectively
c
      call cmcopy(a,ldab,m,n,acopy)
      call cmcopy(b,ldab,m,n,bcopy)
c
      if (idbg(11) .gt. 0) then
           call cmatpr(a,ldab,m,n,' perturbed a for input to guptri')
           call cmatpr(b,ldab,m,n,' perturbed b for input to guptri')
      endif
      return
c
  100 format(2i4)
  300 format(t5,a,2i5)
  350 format(t5,a,d12.5,tr5,a,d12.5,tr5,a,d12.5)
      end
c
      subroutine    cmcopy(a,lda,m,n,acopy)
c     implicit none
      integer       lda,m,n
      complex*16    a(lda,1),acopy(lda,1)
c
c***  the routine cmcopy copies matrix a to acopy
c
      integer       i,j
c
      do 10 i = 1, m
          do 10 j =1, n
              acopy(i,j) = a(i,j)
   10 continue
c
      return
      end
c
      real*8 function cdife(a,b,ldab,m,n)
c     implicit none
      integer  ldab, m, n
      complex*16 a(ldab,*), b(ldab,*), z
c
c**** the routine computes the frobenius norm of the
c     difference between a and b
c
      integer i,j
      real*8 sum
c
      sum=0.0
      do 10 i = 1, m
         do 5 j = 1, n
            z=a(i,j)-b(i,j)
            sum=sum+dreal(z)**2 + dimag(z)**2
    5    continue
   10 continue
      cdife = sqrt(sum)
      return
      end
c
      real*8 function cnorm(a,lda,m,n,job,work)
c
c     implicit none
c
      common /debug2/ idbg(20), outunit
      integer idbg, outunit
c
      integer       lda,m,n,job
      complex*16    a(lda,1),work(1)
c
      integer       joba, info, ss, se, sx, sw, i, j
      complex*16    u,v
c
      if (job .eq. 2) then
c         compute the 2-norm
c         allocate space for s(min(m+1,n)),e(n) and x(lda,n) 
          ss = 1
          se = ss + min(m+1,n)
          sx = se + n
          sw = sx + lda*n
          call cmcopy(a,lda,m,n,work(sx))
          joba = 00
          call zsvdc(work(sx),lda,m,n,work(ss),work(se),
     *               u,1,v,1,work(sw),joba,info)
          if (info .ne. 0) then
             write(outunit,100) 
     +            'csvdc did not converge, called from cnorm'
  100        format(t5,a/)
             call cmatpr(work(ss),1,1,n,
     *                     'singular values - main diagonal')
             call cmatpr(work(se),1,1,n,
     *                     'sub-diagonal - should be zero')
          else
c                  = s(1)
             cnorm = work(ss)
          endif
c              ( info .eq. 2)
      else
c         (job .eq. 0), compute the frobenius norm
          cnorm = 0.0
          do 20 i = 1,m
             do 20 j = 1,n
                  cnorm = cnorm + conjg(a(i,j)) * a(i,j)
   20     continue
          cnorm = sqrt(cnorm)
      endif
c         ( job .eq. 2)
      return
      end
c

      real*8 function cond(a,lda,m,n,work)
c  
c     implicit none
c
      common /debug2/ idbg(20), outunit
      integer idbg, outunit
c
      integer       lda,m,n
      complex*16    a(lda,1),work(1)
c
      integer       joba, info, nn, ss, se, sx, sw
      complex*16    u, v
c
c         allocate space for s(min(m+1,n)),e(n) and x(lda,n) 
          ss = 1
          se = ss + min(m+1,n)
          sx = se + n
          sw = sx + lda*n
          call cmcopy(a,lda,m,n,work(sx))
          joba = 00
          call zsvdc(work(sx),lda,m,n,work(ss),work(se),
     *               u,1,v,1,work(sw),joba,info)
c
          if (info .ne. 0) then
             write(outunit,100) 
     +             'csvdc did not converge, called from cond'
  100        format(t5,a/)
             call cmatpr(work(ss),1,1,n,
     *                    'singular values - main diagonal')
             call cmatpr(work(se),1,1,n,
     *                    'sub-diagonal - should be zero')
          else
             nn = min(m,n)
             if (work(nn) .eq. (0.,0.)) then
                   cond = 0.0
                   write(outunit,100) 
     +                   'cond = the matrix is singular'
             else
                   cond = dreal(work(ss)/work(nn))
c                                       s(1)/s(nn))
             endif
          endif
          return
          end


      subroutine cmatpr(a,lda,m,n,text)
c     implicit none
c
      common /debug2/ idbg(20), outunit
      integer idbg, outunit
c
      integer       lda,m,n, k
      complex*16    a(lda,*)
      character*(*) text
c
      write(outunit, 300) 'lda=',lda, 'm=', m, 'n=', n
  300 format(3(5x,a,i3))
      write(outunit,100)text
  100 format(t5,a)
      write(outunit,200) ('-',k=1,70)
  200 format(t5,70a)
c
      if (lda .eq. 1) then
          call matblk1(a,lda,1,1,1,n)
      else
          call matblk1(a,lda,1,m,1,n)
      endif
      return
      end
c
      subroutine matblk1(a,lda,rf,rs,kf,ks)
c     implicit none
c
      common /debug2/ idbg(20), outunit
      integer idbg, outunit
c
      integer lda, rf, rs, kf, ks
      real*8 a(2,lda,*)
c
      integer tpr,blk,ifirst,bl,ilast,i,j,k,l
      real*8 aim
c
c     tpr is the number of elements per output-row
c
c     is a real or complex ? yes if aim = 0.d0
      aim = 0.d0
      do 20 i = rf, rs
       do 10 j = kf, ks
          if (a(2,i,j) .ne. 0.0d0) aim = 1.
   10  continue
   20 continue 
      tpr = 3
      blk = (ks - kf) / tpr + 1
      ifirst = kf
      do 40 bl = 1, blk
         if (bl .ne. blk) then
            ilast = ifirst + tpr - 1
         else
            ilast = ks
         endif
         do 30 k = rf, rs
             if ( aim .eq. 0.d0) then
c               a is real
                write(outunit,50) (a(1,k,i), i=ifirst, ilast)
             else
c                a is complex 
               do 25 l = 1, 2
                  write(outunit,50) (a(l,k,i), i=ifirst, ilast)
   25          continue
               write(outunit,60)
             endif
   30    continue
         ifirst = ifirst +tpr
      write(outunit,60)
   40 continue
      return
c
   50 format(t3,3d24.17)
   60 format(/)
      end
