c     File zqz.for contains: zqz, rcopy, icopy, ricopy,
c                            zqzhs1, zqzvl1
c     Date: 12 june, 1987
c
      subroutine zqz(a, b, ldab, dimreg, rowb, colb, q, ldq,
     *               ph, ldp, ierr, work)
c
c     implicit none
c
c**** debug space
      common/debug2/ idbg(20), outunit
      integer idbg, outunit
      logical ldebug
c
c**** formal parameter declarations
      integer ldab, dimreg, rowb, colb, ldq, ldp, ierr
      complex*16 a(ldab,*), b(ldab,*), q(ldq,*), ph(ldp,*)
      complex*16 work(*)
c
c*********************************************************************
c
c     this routine reduces the remaining regular part (corresponding to
c     the nonzero and finite eigenvalues) to upper
c     triangular form by using the qz algorithm.
c     this routine is necessary since there is no complex*16
c     version of the qz-routine in eispack or linpack.
c
c     on entry
c
c     a       complex*16(ldab,*), where ldab >= dimreg
c
c     b       complex*16(ldab,*)
c
c     ldab    integer
c             leading dimension of the arrays a and b
c
c     dimreg  integer
c             dimension of the remaining regular part
c
c     rowb    integer
c             first row in a and b of remaining regular part
c
c     colb    integer
c             first column in a and b of remaining regular part
c
c     ldq     integer
c             leading dimension of the array q
c
c     ldp     integer
c             leading dimension of the array p
c
c     work    complex*16(2*dimreg*dimreg+4 + 3*dimreg)
c             scratch array
c
c     idbg(12) integer
c             if nonzero, turn on debug output
c
c     on exit
c
c     a       changed, contains the upper triangular a-part of the
c             qz-decomposition
c
c     b       changed, contains the upper triangular b-part of the
c             qz-decomposition
c
c     q       complex*16(ldq,*), where ldq >= dimreg
c             right transformation matrix
c
c     ph      complex*16(ldp,*), where ldp >= dimreg
c             conjugate transpose of the left transformation matrix
c
c     ierr    integer
c             error messages from qz-algorithm
c             zero for normal return
c             nonzero if eigenvalue has not converged in 50 iterations
c             (for more details see routine zqzvl1)
c
c*********************************************************************
c
c     this version dated june 10, 1987
c     authors: jim demmel and bo kagstrom
c
c**** zqz uses the following functions and subroutines
c
c     cmatpr, icopy, rcopy, ricopy, zqzhs1, zqzvl1
c
c**** internal variables
c
      integer dimsqr, strtar, strtai, strtbr, strtbi
      integer j
      integer alfarb, alfaib, betab
c
      ldebug = idbg(12) .ne. 0
c
c**** reduce the pencil a(rowb:rowb+dimreg-1,colb:colb+dimreg-1)
c       - lambda b(rowb:rowb+dimreg-1,colb:colb+dimreg-1)
c     to upper triangular form with the qz algorithm
c     copy a, b to separate arrays for real and imaginary parts in
c     preparation for using zqzhs1, zqzvl1
c
      dimsqr = dimreg * dimreg / 2 + 1
      strtar = 1
      strtai = strtar + dimsqr
      strtbr = strtai + dimsqr
      strtbi = strtbr + dimsqr
      alfarb = strtbi + dimsqr
      alfaib = alfarb + dimreg
      betab = alfaib + dimreg
      call rcopy(a(rowb,colb), ldab, dimreg, work(strtar))
      call icopy(a(rowb,colb), ldab, dimreg, work(strtai))
      call rcopy(b(rowb,colb), ldab, dimreg, work(strtbr))
      call icopy(b(rowb,colb), ldab, dimreg, work(strtbi))
c
      if (ldebug) then
        write(outunit,100) 'entering qz'
        write(outunit,100) 'ldab=',ldab,'dimreg=',dimreg,
     +                     'rowb=',rowb,'colb=',colb,
     +                     'ldq=',ldq,'ldp=',ldp,
     +                     'dimsrq=',dimsqr,'strtar=',strtar,
     +                     'strtai=',strtai,'strtbr=',strtbr,
     +                     'strtbi=',strtbi,'alfarb=',alfarb,
     +                     'alfaib=',alfaib,'betab=',betab
100     format(3x,a,1x,i4)
        write(outunit,100) 'areal'
        write(outunit,101) (work(strtar-1+j),j=1,dimsqr)
        write(outunit,100) 'aimag'
        write(outunit,101) (work(strtai-1+j),j=1,dimsqr)
        write(outunit,100) 'breal'
        write(outunit,101) (work(strtbr-1+j),j=1,dimsqr)
        write(outunit,100) 'bimag'
        write(outunit,101) (work(strtbi-1+j),j=1,dimsqr)
101     format(3d23.16)
      endif
      call zqzhs1(dimreg, dimreg, work(strtar),work(strtai),
     *            work(strtbr),work(strtbi),
     *              .true., q, ldq, .true., ph, ldp )
c
      if (ldebug) then
        write(outunit,100) 'after zqzhs1'
        write(outunit,100) 'areal'
        write(outunit,101) (work(strtar-1+j),j=1,dimsqr)
        write(outunit,100) 'aimag'
        write(outunit,101) (work(strtai-1+j),j=1,dimsqr)
        write(outunit,100) 'breal'
        write(outunit,101) (work(strtbr-1+j),j=1,dimsqr)
        write(outunit,100) 'bimag'
        write(outunit,101) (work(strtbi-1+j),j=1,dimsqr)
        call cmatpr(q,ldq,dimreg,dimreg,'q after zqzhs1')
        call cmatpr(ph,ldp,dimreg,dimreg,'ph after zqzhs1')
      endif     
c
      call zqzvl1(dimreg, dimreg, work(strtar),work(strtai),
     *            work(strtbr),work(strtbi),
     *              0.0d0, work(alfarb), work(alfaib), work(betab),
     *              .true., q, ldq, .true., ph, ldp, ierr)
c
      if (ldebug) then
        write(outunit,100) 'after zqzvl1, ierr=',ierr
        write(outunit,100) 'areal'
        write(outunit,101) (work(strtar-1+j),j=1,dimsqr)
        write(outunit,100) 'aimag'
        write(outunit,101) (work(strtai-1+j),j=1,dimsqr)
        write(outunit,100) 'breal'
        write(outunit,101) (work(strtbr-1+j),j=1,dimsqr)
        write(outunit,100) 'bimag'
        write(outunit,101) (work(strtbi-1+j),j=1,dimsqr)
        write(outunit,100) 'alfarb'
        write(outunit,101) (work(alfarb-1+j),j=1,dimreg)
        write(outunit,100) 'alfaib'
        write(outunit,101) (work(alfaib-1+j),j=1,dimreg)
        write(outunit,100) 'betab'
        write(outunit,101) (work(betab-1+j),j=1,dimreg)
        call cmatpr(q,ldq,dimreg,dimreg,'q after zqzvl1')
        call cmatpr(ph,ldp,dimreg,dimreg,'ph after zqzvl1')
      endif     
c
c        if (idbg(2) .gt. 1) then
c            call cmatpr(q,ldq,dimreg,dimreg,'q from qz')
c            call cmatpr(ph,ldp,dimreg,dimreg,'ph from qz')
c        endif
        if (ierr.ne.0) return
c
c     copy the real and imaginary parts of the qz-decomposition
c     to a and b, respectively
c                                                          
      call ricopy(a(rowb,colb), ldab, dimreg, work(strtar),
     *            work(strtai))
      call ricopy(b(rowb,colb), ldab, dimreg, work(strtbr),
     *            work(strtbi))
c
      if (ldebug) then
        call cmatpr(a(rowb,colb),ldab,dimreg,dimreg,'a after qz')
        call cmatpr(b(rowb,colb),ldab,dimreg,dimreg,'b after qz')
      endif
      return
      end

      subroutine rcopy(a, lda, dimreg, acopy)
c     implicit none
c
c**** formal parameter declarations
      integer lda, dimreg
      complex*16 a(lda,*)
      real*8 acopy(*)
c
c***  copy the real parts of a to the real vector acopy
c
c     this version dated june 10, 1987
c     authors: jim demmel and bo kagstrom
c     
c***  internal variables
      integer i, j
c
      do 20 i = 1, dimreg
         do 10 j = 1, dimreg
              acopy(i + (j - 1) * dimreg) = dreal(a(i,j))
   10    continue
   20 continue
      return
      end 
 
      subroutine icopy(a, lda, dimreg, acopy)
c     implicit none
c**** formal parameter declarations
      integer lda, dimreg
      complex*16 a(lda,*)
      real*8 acopy(*)
c
c***  copy the imaginary parts of a to the real vector acopy
c
c     this version dated june 10, 1987
c     authors: jim demmel and bo kagstrom
c     
c***  internal variables
c     
      integer i, j
      do 20 i = 1, dimreg
         do 10 j = 1, dimreg
              acopy(i + (j - 1) * dimreg) = dimag(a(i,j))
   10    continue
   20 continue
      return
      end 

      subroutine ricopy(a, lda, dimreg, arcopy, aicopy)
c     implicit none
c
c**** formal parameter declarations
      integer lda, dimreg
      complex*16 a(lda,*)
      real*8 arcopy(*), aicopy(*)
c
c***  copy arcopy and aicopy to the real and imaginary parts of a,
c     respectively
c
c     this version dated june 10, 1987
c     authors: jim demmel and bo kagstrom
c     
c***  internal variables
c     
      integer i, j
      do 20 i = 1, dimreg
         do 10 j = 1, dimreg
              a(i,j) = dcmplx(arcopy(i + (j - 1) * dimreg),
     *                        aicopy(i + (j - 1) * dimreg))
   10    continue
   20 continue
      return
      end 

c
c     ------------------------------------------------------------------
c
      subroutine zqzhs1(nm,n,ar,ai,br,bi,matz,z,ldz,matzl,zl,ldzl)
c
c
c     modified by demmel,6/23/86 to compute left, right transformations
c     in complex arithmetic
c  
      integer i,j,k,l,n,k1,lb,l1,nm,nk1,nm1
      real*8 ar(nm,n),ai(nm,n),br(nm,n),bi(nm,n)
      complex*16 z(ldz,*),zl(ldzl,*)
      complex*16 zu,tz,zll,zll1
      real*8 r,s,t,ti,u1,u2,xi,xr,yi,yr,rho,u1i
      logical matz,matzl
c
c     this subroutine is a complex analogue of the first step of the
c     qz algorithm for solving generalized matrix eigenvalue problems,
c     siam j. numer. anal. 10, 241-256(1973) by moler and stewart.
c
c     this subroutine accepts a pair of complex general matrices and
c     reduces one of them to upper hessenberg form with real (and non-
c     negative) subdiagonal elements and the other to upper triangular
c     form using unitary transformations.  it is usually followed by
c     cqzval  and possibly  cqzvec.
c
c     on input-
c
c        nm must be set to the row dimension of two-dimensional
c          array parameters as declared in the calling program
c          dimension statement,
c
c        n is the order of the matrices,
c
c        a=(ar,ai) contains a complex general matrix,
c
c        b=(br,bi) contains a complex general matrix,
c
c        matz should be set to .true. if the right hand transformations
c          are to be accumulated for later use in computing
c          eigenvectors, and to .false. otherwise.
c
c        matzl same as matz for left hand transformations
c
c     on output-
c
c        a has been reduced to upper hessenberg form.  the elements
c          below the first subdiagonal have been set to zero, and the
c          subdiagonal elements have been made real (and non-negative),
c
c        b has been reduced to upper triangular form.  the elements
c          below the main diagonal have been set to zero,
c
c        z contains the product of the right hand
c          transformations if matz has been set to .true.
c          otherwise, z is not referenced.
c
c        zl same as z for left transformations
c
c     questions and comments should be directed to b. s. garbow,
c     applied mathematics division, argonne national laboratory
c
c     ------------------------------------------------------------------
c
c     ********** initialize z **********
      if (.not. matz) go to 10
c
      do 3 i = 1, n
c
         do 2 j = 1, n
            z(i,j) = dcmplx(0.0d0,0.0d0)
    2    continue
c
         z(i,i) = dcmplx(1.0d0,0.0d0)
    3 continue
c
c     ********** initialize zl **********
      if (matzl) then
        do 300 i=1,n
          do 200 j=1,n
            zl(i,j)=0.
200       continue
          zl(i,i)=1.
300     continue
      endif
c
c     ********** reduce b to upper triangular form with
c                temporarily real diagonal elements **********
   10 if (n .le. 1) go to 170
      nm1 = n - 1
c
      do 100 l = 1, nm1
         l1 = l + 1
         s = 0.0
c
         do 20 i = l, n
            s = s + abs(br(i,l)) + abs(bi(i,l))
   20    continue
c
         if (s .eq. 0.0) go to 100
         rho = 0.0
c
         do 25 i = l, n
            br(i,l) = br(i,l) / s
            bi(i,l) = bi(i,l) / s
            rho = rho + br(i,l)**2 + bi(i,l)**2
   25    continue
c
         r = sqrt(rho)
         xr = abs(dcmplx(br(l,l),bi(l,l)))
         if (xr .eq. 0.0) go to 27
         rho = rho + xr * r
         u1 = -br(l,l) / xr
         u1i = -bi(l,l) / xr
         yr = r / xr + 1.0
         br(l,l) = yr * br(l,l)
         bi(l,l) = yr * bi(l,l)
         go to 28
c
   27    br(l,l) = r
         u1 = -1.0
         u1i = 0.0
c
   28    do 50 j = l1, n
            t = 0.0
            ti = 0.0
c
            do 30 i = l, n
               t = t + br(i,l) * br(i,j) + bi(i,l) * bi(i,j)
               ti = ti + br(i,l) * bi(i,j) - bi(i,l) * br(i,j)
   30       continue
c
            t = t / rho
            ti = ti / rho
c
            do 40 i = l, n
               br(i,j) = br(i,j) - t * br(i,l) + ti * bi(i,l)
               bi(i,j) = bi(i,j) - t * bi(i,l) - ti * br(i,l)
   40       continue
c
            xi = u1 * bi(l,j) - u1i * br(l,j)
            br(l,j) = u1 * br(l,j) + u1i * bi(l,j)
            bi(l,j) = xi
   50    continue
c
         do 80 j = 1, n
            t = 0.0
            ti = 0.0
c
            do 60 i = l, n
               t = t + br(i,l) * ar(i,j) + bi(i,l) * ai(i,j)
               ti = ti + br(i,l) * ai(i,j) - bi(i,l) * ar(i,j)
   60       continue
c
            t = t / rho
            ti = ti / rho
c
            do 70 i = l, n
               ar(i,j) = ar(i,j) - t * br(i,l) + ti * bi(i,l)
               ai(i,j) = ai(i,j) - t * bi(i,l) - ti * br(i,l)
   70       continue
c
            xi = u1 * ai(l,j) - u1i * ar(l,j)
            ar(l,j) = u1 * ar(l,j) + u1i * ai(l,j)
            ai(l,j) = xi
c
c        update zl
         if (matzl) then
           t=0.
           ti=0.
           do 600 i=l,n
             t= t + br(i,l)*dreal(zl(i,j)) + bi(i,l)*dimag(zl(i,j))
             ti=ti+ br(i,l)*dimag(zl(i,j))- bi(i,l)*dreal(zl(i,j))
600        continue
           tz=dcmplx(t/rho,ti/rho)
           do 700 i=l,n
             zl(i,j)=zl(i,j)-tz*dcmplx(br(i,l),bi(i,l))
700        continue
           zl(l,j)=zl(l,j)*dcmplx(u1,-u1i)
         endif
80       continue
c
         br(l,l) = r * s
         bi(l,l) = 0.0
c
         do 90 i = l1, n
            br(i,l) = 0.0
            bi(i,l) = 0.0
   90    continue
c
  100 continue
c     ********** reduce a to upper hessenberg form with real subdiagonal
c                elements, while keeping b triangular **********
      do 160 k = 1, nm1
         k1 = k + 1
c     ********** set bottom element in k-th column of a real **********
         if (ai(n,k) .eq. 0.0) go to 105
         r = abs(dcmplx(ar(n,k),ai(n,k)))
         u1 = ar(n,k) / r
         u1i = ai(n,k) / r
         ar(n,k) = r
         ai(n,k) = 0.0
c
         do 103 j = k1, n
            xi = u1 * ai(n,j) - u1i * ar(n,j)
            ar(n,j) = u1 * ar(n,j) + u1i * ai(n,j)
            ai(n,j) = xi
  103    continue
c
c        update zl
         if (matzl) then
           do 1030 j=1,n
             zl(n,j)=zl(n,j)*dcmplx(u1,-u1i)
1030       continue
         endif
c
         xi = u1 * bi(n,n) - u1i * br(n,n)
         br(n,n) = u1 * br(n,n) + u1i * bi(n,n)
         bi(n,n) = xi
  105    if (k .eq. nm1) go to 170
         nk1 = nm1 - k
c     ********** for l=n-1 step -1 until k+1 do -- **********
         do 150 lb = 1, nk1
            l = n - lb
            l1 = l + 1
c     ********** zero a(l+1,k) **********
            s = abs(ar(l,k)) + abs(ai(l,k)) + ar(l1,k)
            if (s .eq. 0.0) go to 150
            u1 = ar(l,k) / s
            u1i = ai(l,k) / s
            u2 = ar(l1,k) / s
            r = sqrt(u1*u1+u1i*u1i+u2*u2)
            u1 = u1 / r
            u1i = u1i / r
            u2 = u2 / r
            ar(l,k) = r * s
            ai(l,k) = 0.0
            ar(l1,k) = 0.0
c
            do 110 j = k1, n
               xr = ar(l,j)
               xi = ai(l,j)
               yr = ar(l1,j)
               yi = ai(l1,j)
               ar(l,j) = u1 * xr + u1i * xi + u2 * yr
               ai(l,j) = u1 * xi - u1i * xr + u2 * yi
               ar(l1,j) = u1 * yr - u1i * yi - u2 * xr
               ai(l1,j) = u1 * yi + u1i * yr - u2 * xi
  110       continue
c
c           update zl
            if (matzl) then
              zu=dcmplx(u1,-u1i)
              do 1100 j=1,n
                zll=zl(l,j)
                zll1=zl(l1,j)
                zl(l,j)= zu*zll+u2*zll1
                zl(l1,j)=conjg(zu)*zll1-u2*zll
1100          continue
            endif
c
            xr = br(l,l)
            br(l,l) = u1 * xr
            bi(l,l) = -u1i * xr
            br(l1,l) = -u2 * xr
c
            do 120 j = l1, n
               xr = br(l,j)
               xi = bi(l,j)
               yr = br(l1,j)
               yi = bi(l1,j)
               br(l,j) = u1 * xr + u1i * xi + u2 * yr
               bi(l,j) = u1 * xi - u1i * xr + u2 * yi
               br(l1,j) = u1 * yr - u1i * yi - u2 * xr
               bi(l1,j) = u1 * yi + u1i * yr - u2 * xi
  120       continue
c     ********** zero b(l+1,l) **********
            s = abs(br(l1,l1)) + abs(bi(l1,l1)) + abs(br(l1,l))
            if (s .eq. 0.0) go to 150
            u1 = br(l1,l1) / s
            u1i = bi(l1,l1) / s
            u2 = br(l1,l) / s
            r = sqrt(u1*u1+u1i*u1i+u2*u2)
            u1 = u1 / r
            u1i = u1i / r
            u2 = u2 / r
            br(l1,l1) = r * s
            bi(l1,l1) = 0.0
            br(l1,l) = 0.0
c
            do 130 i = 1, l
               xr = br(i,l1)
               xi = bi(i,l1)
               yr = br(i,l)
               yi = bi(i,l)
               br(i,l1) = u1 * xr + u1i * xi + u2 * yr
               bi(i,l1) = u1 * xi - u1i * xr + u2 * yi
               br(i,l) = u1 * yr - u1i * yi - u2 * xr
               bi(i,l) = u1 * yi + u1i * yr - u2 * xi
  130       continue
c
            do 140 i = 1, n
               xr = ar(i,l1)
               xi = ai(i,l1)
               yr = ar(i,l)
               yi = ai(i,l)
               ar(i,l1) = u1 * xr + u1i * xi + u2 * yr
               ai(i,l1) = u1 * xi - u1i * xr + u2 * yi
               ar(i,l) = u1 * yr - u1i * yi - u2 * xr
               ai(i,l) = u1 * yi + u1i * yr - u2 * xi
  140       continue
c
            if (.not. matz) go to 150
c
            zu=dcmplx(u1,-u1i)
            do 145 i = 1, n
              zll1=z(i,l1)
              zll=z(i,l)
              z(i,l1)=zu*zll1+u2*zll
              z(i,l)= conjg(zu)*zll-u2*zll1
  145       continue
c
  150    continue
c
  160 continue
c
  170 return
c     ********** last card of zqzhes **********
      end
c
c     ------------------------------------------------------------------
c
      subroutine zqzvl1(nm,n,ar,ai,br,bi,eps1,alfr,alfi,beta,
     x              matz,z,ldz,matzl,zl,ldzl,ierr)
c
c     modified by demmel, 6/23/86 to compute left and right 
c     transformations using complex arithmetic
c
      integer i,j,k,l,n,en,k1,k2,ll,l1,na,nm,its,km1,lm1,
     x        enm2,ierr,lor1,enorn
      real*8 ar(nm,n),ai(nm,n),br(nm,n),bi(nm,n),alfr(n),alfi(n),
     x       beta(n)
      complex*16 z(ldz,*),zl(ldzl,*)
      complex*16 zu,zll,zll1
      real*8 r,s,a1,a2,ep,sh,u1,u2,xi,xr,yi,yr,ani,a1i,a33,a34,a43,a44,
     x       bni,b11,b33,b44,shi,u1i,a33i,a34i,a43i,a44i,b33i,b44i,
     x       epsa,epsb,eps1,anorm,bnorm,b3344,b3344i
      integer max0
      logical matz,matzl
      complex*16 z3
c
c
c
c
c
c     this subroutine is a complex analogue of steps 2 and 3 of the
c     qz algorithm for solving generalized matrix eigenvalue problems,
c     siam j. numer. anal. 10, 241-256(1973) by moler and stewart,
c     as modified in technical note nasa tn e-7305(1973) by ward.
c
c     this subroutine accepts a pair of complex matrices, one of them
c     in upper hessenberg form and the other in upper triangular form,
c     the hessenberg matrix must further have real subdiagonal elements.
c     it reduces the hessenberg matrix to triangular form using
c     unitary transformations while maintaining the triangular form
c     of the other matrix and further making its diagonal elements
c     real and non-negative.  it then returns quantities whose ratios
c     give the generalized eigenvalues.  it is usually preceded by
c     cqzhes  and possibly followed by  cqzvec.
c
c     on input-
c
c        nm must be set to the row dimension of two-dimensional
c          array parameters as declared in the calling program
c          dimension statement,
c
c        n is the order of the matrices,
c
c        a=(ar,ai) contains a complex upper hessenberg matrix
c          with real subdiagonal elements,
c
c        b=(br,bi) contains a complex upper triangular matrix,
c
c        eps1 is a tolerance used to determine negligible elements.
c          eps1 = 0.0 (or negative) may be input, in which case an
c          element will be neglected only if it is less than roundoff
c          error times the norm of its matrix.  if the input eps1 is
c          positive, then an element will be considered negligible
c          if it is less than eps1 times the norm of its matrix.  a
c          positive value of eps1 may result in faster execution,
c          but less accurate results,
c
c        matz should be set to .true. if the right hand transformations
c          are to be accumulated for later use in computing
c          eigenvectors, and to .false. otherwise,
c
c        z=(zr,zi) contains, if matz has been set to .true., the
c          transformation matrix produced in the reduction
c          by  cqzhes, if performed, or else the identity matrix.
c          if matz has been set to .false., z is not referenced.
c
c     on output-
c
c        a has been reduced to upper triangular form.  the elements
c          below the main diagonal have been set to zero,
c
c        b is still in upper triangular form, although its elements
c          have been altered.  in particular, its diagonal has been set
c          real and non-negative.  the location br(n,1) is used to
c          store eps1 times the norm of b for later use by  cqzvec,
c
c        alfr and alfi contain the real and imaginary parts of the
c          diagonal elements of the triangularized a matrix,
c
c        beta contains the real non-negative diagonal elements of the
c          corresponding b.  the generalized eigenvalues are then
c          the ratios ((alfr+i*alfi)/beta),
c
c        z contains the product of the right hand transformations
c          (for both steps) if matz has been set to .true.,
c
c        ierr is set to
c          zero       for normal return,
c          j          if ar(j,j-1) has not become
c                     zero after 50 iterations.
c
c     questions and comments should be directed to b. s. garbow,
c     applied mathematics division, argonne national laboratory
c
c     ------------------------------------------------------------------
c
      ierr = 0
c     ********** compute epsa,epsb **********
      anorm = 0.0
      bnorm = 0.0
c
      do 30 i = 1, n
         ani = 0.0
         if (i .ne. 1) ani = abs(ar(i,i-1))
         bni = 0.0
c
         do 20 j = i, n
            ani = ani + abs(ar(i,j)) + abs(ai(i,j))
            bni = bni + abs(br(i,j)) + abs(bi(i,j))
   20    continue
c
         if (ani .gt. anorm) anorm = ani
         if (bni .gt. bnorm) bnorm = bni
   30 continue
c
      if (anorm .eq. 0.0) anorm = 1.0
      if (bnorm .eq. 0.0) bnorm = 1.0
      ep = eps1
      if (ep .gt. 0.0) go to 50
c     ********** compute roundoff level if eps1 is zero **********
      ep = 1.0d0
   40 ep = ep / 2.0d0
      if (1.0d0 + ep .gt. 1.0d0) go to 40
   50 epsa = ep * anorm
      epsb = ep * bnorm
c     ********** reduce a to triangular form, while
c                keeping b triangular **********
      lor1 = 1
      enorn = n
      en = n
c     ********** begin qz step **********
   60 if (en .eq. 0) go to 1001
      if (.not. matz) enorn = en
      its = 0
      na = en - 1
      enm2 = na - 1
c     ********** check for convergence or reducibility.
c                for l=en step -1 until 1 do -- **********
   70 do 80 ll = 1, en
         lm1 = en - ll
         l = lm1 + 1
         if (l .eq. 1) go to 95
         if (abs(ar(l,lm1)) .le. epsa) go to 90
   80 continue
c
   90 ar(l,lm1) = 0.0
c     ********** set diagonal element at top of b real **********
   95 b11 = abs(dcmplx(br(l,l),bi(l,l)))
      if (b11     .eq. 0.0) go to 98
      u1 = br(l,l) / b11
      u1i = bi(l,l) / b11
c
      do 97 j = l, enorn
         xi = u1 * ai(l,j) - u1i * ar(l,j)
         ar(l,j) = u1 * ar(l,j) + u1i * ai(l,j)
         ai(l,j) = xi
         xi = u1 * bi(l,j) - u1i * br(l,j)
         br(l,j) = u1 * br(l,j) + u1i * bi(l,j)
         bi(l,j) = xi
   97 continue
c
c     update zl
      if (matzl) then
        do 970 j=1,n
          zl(l,j)=zl(l,j)*dcmplx(u1,-u1i)
970     continue
      endif
c
      bi(l,l) = 0.0
   98 if (l .ne. en) go to 100
c     ********** 1-by-1 block isolated **********
      alfr(en) = ar(en,en)
      alfi(en) = ai(en,en)
      beta(en) = b11
      en = na
      go to 60
c     ********** check for small top of b **********
  100 l1 = l + 1
      if (b11 .gt. epsb) go to 120
      br(l,l) = 0.0
      s = abs(ar(l,l)) + abs(ai(l,l)) + abs(ar(l1,l))
      u1 = ar(l,l) / s
      u1i = ai(l,l) / s
      u2 = ar(l1,l) / s
      r = sqrt(u1*u1+u1i*u1i+u2*u2)
      u1 = u1 / r
      u1i = u1i / r
      u2 = u2 / r
      ar(l,l) = r * s
      ai(l,l) = 0.0
c
      do 110 j = l1, enorn
         xr = ar(l,j)
         xi = ai(l,j)
         yr = ar(l1,j)
         yi = ai(l1,j)
         ar(l,j) = u1 * xr + u1i * xi + u2 * yr
         ai(l,j) = u1 * xi - u1i * xr + u2 * yi
         ar(l1,j) = u1 * yr - u1i * yi - u2 * xr
         ai(l1,j) = u1 * yi + u1i * yr - u2 * xi
         xr = br(l,j)
         xi = bi(l,j)
         yr = br(l1,j)
         yi = bi(l1,j)
         br(l1,j) = u1 * yr - u1i * yi - u2 * xr
         br(l,j) = u1 * xr + u1i * xi + u2 * yr
         bi(l,j) = u1 * xi - u1i * xr + u2 * yi
         bi(l1,j) = u1 * yi + u1i * yr - u2 * xi
  110 continue
c
c     update zl
      if (matzl) then
        zu=dcmplx(u1,-u1i)
        do 1110 j=1,n
          zll=zl(l,j)
          zll1=zl(l1,j)
          zl(l,j)=zll*zu+zll1*u2
          zl(l1,j)=zll1*conjg(zu)-zll*u2
1110    continue
      endif
c
      lm1 = l
      l = l1
      go to 90
c     ********** iteration strategy **********
  120 if (its .eq. 50) go to 1000
      if (its .eq. 10) go to 135
c     ********** determine shift **********
      b33 = br(na,na)
      b33i = bi(na,na)
      if (abs(dcmplx(b33,b33i)) .ge. epsb) go to 122
      b33 = epsb
      b33i = 0.0
  122 b44 = br(en,en)
      b44i = bi(en,en)
      if (abs(dcmplx(b44,b44i)) .ge. epsb) go to 124
      b44 = epsb
      b44i = 0.0
  124 b3344 = b33 * b44 - b33i * b44i
      b3344i = b33 * b44i + b33i * b44
      a33 = ar(na,na) * b44 - ai(na,na) * b44i
      a33i = ar(na,na) * b44i + ai(na,na) * b44
      a34 = ar(na,en) * b33 - ai(na,en) * b33i
     x    - ar(na,na) * br(na,en) + ai(na,na) * bi(na,en)
      a34i = ar(na,en) * b33i + ai(na,en) * b33
     x     - ar(na,na) * bi(na,en) - ai(na,na) * br(na,en)
      a43 = ar(en,na) * b44
      a43i = ar(en,na) * b44i
      a44 = ar(en,en) * b33 - ai(en,en) * b33i - ar(en,na) * br(na,en)
      a44i = ar(en,en) * b33i + ai(en,en) * b33 - ar(en,na) * bi(na,en)
      sh = a44
      shi = a44i
      xr = a34 * a43 - a34i * a43i
      xi = a34 * a43i + a34i * a43
      if (xr .eq. 0.0 .and. xi .eq. 0.0) go to 140
      yr = (a33 - sh) / 2.0
      yi = (a33i - shi) / 2.0
      z3 = sqrt(dcmplx(yr**2-yi**2+xr,2.0*yr*yi+xi))
      u1 = dreal(z3)
      u1i = dimag(z3)
      if (yr * u1 + yi * u1i .ge. 0.0) go to 125
      u1 = -u1
      u1i = -u1i
  125 z3 = (dcmplx(sh,shi) - dcmplx(xr,xi) / dcmplx(yr+u1,yi+u1i))
     x   / dcmplx(b3344,b3344i)
      sh = dreal(z3)
      shi = dimag(z3)
      go to 140
c     ********** ad hoc shift **********
  135 sh = ar(en,na) + ar(na,enm2)
      shi = 0.0
c     ********** determine zeroth column of a **********
  140 a1 = ar(l,l) / b11 - sh
      a1i = ai(l,l) / b11 - shi
      a2 = ar(l1,l) / b11
      its = its + 1
      if (.not. matz) lor1 = l
c     ********** main loop **********
      do 260 k = l, na
         k1 = k + 1
         k2 = k + 2
         km1 = max0(k-1,l)
c     ********** zero a(k+1,k-1) **********
         if (k .eq. l) go to 170
         a1 = ar(k,km1)
         a1i = ai(k,km1)
         a2 = ar(k1,km1)
  170    s = abs(a1) + abs(a1i) + abs(a2)
         u1 = a1 / s
         u1i = a1i / s
         u2 = a2 / s
         r = sqrt(u1*u1+u1i*u1i+u2*u2)
         u1 = u1 / r
         u1i = u1i / r
         u2 = u2 / r
c
         do 180 j = km1, enorn
            xr = ar(k,j)
            xi = ai(k,j)
            yr = ar(k1,j)
            yi = ai(k1,j)
            ar(k,j) = u1 * xr + u1i * xi + u2 * yr
            ai(k,j) = u1 * xi - u1i * xr + u2 * yi
            ar(k1,j) = u1 * yr - u1i * yi - u2 * xr
            ai(k1,j) = u1 * yi + u1i * yr - u2 * xi
            xr = br(k,j)
            xi = bi(k,j)
            yr = br(k1,j)
            yi = bi(k1,j)
            br(k,j) = u1 * xr + u1i * xi + u2 * yr
            bi(k,j) = u1 * xi - u1i * xr + u2 * yi
            br(k1,j) = u1 * yr - u1i * yi - u2 * xr
            bi(k1,j) = u1 * yi + u1i * yr - u2 * xi
  180    continue
c
c        update zl
         if (matzl) then
           zu=dcmplx(u1,-u1i)
           do 1800 j=1,n
             zll=zl(k,j)
             zll1=zl(k1,j)
             zl(k,j)=zu*zll+u2*zll1
             zl(k1,j)=conjg(zu)*zll1-u2*zll
1800       continue
         endif
c
         if (k .eq. l) go to 240
         ai(k,km1) = 0.0
         ar(k1,km1) = 0.0
         ai(k1,km1) = 0.0
c     ********** zero b(k+1,k) **********
  240    s = abs(br(k1,k1)) + abs(bi(k1,k1)) + abs(br(k1,k))
         u1 = br(k1,k1) / s
         u1i = bi(k1,k1) / s
         u2 = br(k1,k) / s
         r = sqrt(u1*u1+u1i*u1i+u2*u2)
         u1 = u1 / r
         u1i = u1i / r
         u2 = u2 / r
         if (k .eq. na) go to 245
         xr = ar(k2,k1)
         ar(k2,k1) = u1 * xr
         ai(k2,k1) = -u1i * xr
         ar(k2,k) = -u2 * xr
c
  245    do 250 i = lor1, k1
            xr = ar(i,k1)
            xi = ai(i,k1)
            yr = ar(i,k)
            yi = ai(i,k)
            ar(i,k1) = u1 * xr + u1i * xi + u2 * yr
            ai(i,k1) = u1 * xi - u1i * xr + u2 * yi
            ar(i,k) = u1 * yr - u1i * yi - u2 * xr
            ai(i,k) = u1 * yi + u1i * yr - u2 * xi
            xr = br(i,k1)
            xi = bi(i,k1)
            yr = br(i,k)
            yi = bi(i,k)
            br(i,k1) = u1 * xr + u1i * xi + u2 * yr
            bi(i,k1) = u1 * xi - u1i * xr + u2 * yi
            br(i,k) = u1 * yr - u1i * yi - u2 * xr
            bi(i,k) = u1 * yi + u1i * yr - u2 * xi
  250    continue
c
         bi(k1,k1) = 0.0
         br(k1,k) = 0.0
         bi(k1,k) = 0.0
         if (.not. matz) go to 260
c
         zu=dcmplx(u1,-u1i)
         do 255 i = 1, n
           zll=z(i,k)
           zll1=z(i,k1)
           z(i,k)=conjg(zu)*zll-u2*zll1
           z(i,k1)=zu*zll1+u2*zll
  255    continue
c
  260 continue
c     ********** set last a subdiagonal real and end qz step **********
      if (ai(en,na) .eq. 0.0) go to 70
      r = abs(dcmplx(ar(en,na),ai(en,na)))
      u1 = ar(en,na) / r
      u1i = ai(en,na) / r
      ar(en,na) = r
      ai(en,na) = 0.0
c
      do 270 j = en, enorn
         xi = u1 * ai(en,j) - u1i * ar(en,j)
         ar(en,j) = u1 * ar(en,j) + u1i * ai(en,j)
         ai(en,j) = xi
         xi = u1 * bi(en,j) - u1i * br(en,j)
         br(en,j) = u1 * br(en,j) + u1i * bi(en,j)
         bi(en,j) = xi
  270 continue
c
c     update zl
      if (matzl) then
        zu=dcmplx(u1,-u1i)
        do 2700 j=1,n
          zl(en,j)=zu*zl(en,j)
2700    continue
      endif
c
      go to 70
c     ********** set error -- bottom subdiagonal element has not
c                become negligible after 50 iterations **********
 1000 ierr = en
c     ********** save epsb for use by cqzvec **********
 1001 if (n .gt. 1) br(n,1) = 0.
c     if (n .gt. 1) br(n,1) = epsb
      return
c     ********** last card of zqzval **********
      end

