
      subroutine rcsvdc(x, ldx, m, n, s, e, u, ldu, v, ldv,
     *                  opt, epsu, gap, cnull, rnull, del,
     *                  work, job, info)
c
c     implicit none
c**** debug space
      common /debug2/ idbg(20), outunit
      integer idbg, outunit
c
c**** formal parameter declarations
      integer ldx,m,n,ldu,ldv,cnull,rnull,job,info
      real*8 epsu, gap, del
      complex*16 x(ldx,n),s(m),e(m),u(ldu,1),v(ldv,n),work(n)
      character*(*) opt
c
c*********************************************************************
c
c     rcsvdc computes the singular value decomposition (svd)
c     of a m by n matrix x, and its numerical column and row
c     nullities, respectively. the diagonal elements s(i) are
c     the singular values. the user controls the ordering and 
c     the placing of the singular values. 
c     the columns of the unitary matrices u and v correspond
c     to the left and right singular vectors, respectively.
c
c     on entry
c
c         x         complex(ldx,n), where ldx>=m.
c
c         ldx       integer
c                   ldx is the leading dimension of the array x.
c
c         m         integer
c                   m is the number of rows of x.
c
c         n         integer
c                   n is the number of columns of x.            
c
c         ldu       integer
c                   ldu is the leading dimension of the array u.
c
c         ldv       integer
c                   ldv is the leading dimension of the array v.
c
c         work      complex(n)
c                   work is a scratch array.
c
c         job       integer
c                   job controls the computations to be done. it has
c                   the decimal expansion abcd with the following
c                   meaning                   
c                      a=0    do not compute the left singular vectors.
c                      a=1    return the m left singular vextors in u.
c                      a=2    return the first min(m,n) left singular
c                             vectors in u.
c                      b=0    do not compute the right singular vectors.
c                      b=1    return the right singular vectors in v.
c                      c=0    singular values are ordered in decreasing
c                             order.
c                      c=1    singular values are ordered in increasing
c                             order.
c                      d=0    diagonal of singular values starts in
c                             position (1,1).
c                      d=1    diagonal of singular values ends in
c                             position (m,n).
c
c     on return
c
c         s         complex(mm), where mm=min(m+1,n).     ??????
c                   the first min(m,n) entries of s contain the 
c                   singular values of x.      
c                                
c         e         complex(m)
c                   e contains the subdiagonal from computing
c                   the svd. should ordinarily be zeros.
c
c         u         complex(ldu,k), where ldu>=m.
c                   if joba=1 then k=m, if joba=2 then k=min(m,n).
c                   u contains the matrix of left singular
c                   vectors of x.
c                   u is not referenced if joba=0. if m<=n or if
c                   joba=2, then u may be identified with x in the
c                   subroutine call.
c
c         v         complex(ldv,n), where ldv>=n.
c                   v contains the matrix of right singular
c                   vectors of x.
c                   v is not referenced if jobb=0. if n<=m,
c                   then v may be identified with x in the 
c                   subroutine call.
c
c         cnull     integer
c                   cnull contains the numerical column nullity of x.
c
c         rnull     integer
c                   rnull contains the numerical row nullity of x.
c
c         del       real*8
c                   del contains the squareroot of the sum of the
c                   squares of the singular values interpreted as zeros.
c
c         info      integer
c                   info tells the user what has been done.
c                   info=0, all the singular values and
c                   vectors are correct. if info .ne.o, then
c                   cnull, rnull and del contain no meaningful
c                   information. for more details see the
c                   linpack routine csvdc.
c
c********************************************************************
c
c         this version dated june 13, 1987
c         authors: jim demmel and bo kagstrom 
c
c*****    rcsvdc uses the following functions and subroutines
c
c         linpack    zsvdc
c         blas       zswap
c
c*****    internal variables
c
c
c***  if idbg(6) .eq. 0 then debug output is switched off
c     on input info contains the product of the row and
c     column dimensions of the original a and b
c
      integer       jobu, ncu, jobx, nsvd, i, j, n1, mn, mpn, k
      logical       wantu, wantv, incr, posmn, ldebug
      real*8        t1, t2
      complex*16    cell
c
c     save m*n (=info) in mpn
      mpn = info
c
c*****    determine what is to be computed
      ldebug = idbg(6) .ne. 0
      jobu = job/1000
      wantu = jobu .ne. 0
c
c     ncu is the number of columns in u
      ncu = m
      if (jobu .eq. 2) ncu = min0(m,n)
      wantv = mod(job,1000)/100 .ne. 0
      incr = mod(job,100)/10 .ne. 0
      posmn = mod(job,10) .ne. 0
c
c*****    compute the svd of x
c     singular values in decraesing order
c
      jobx = job/100
      call zsvdc(x,ldx,m,n,s,e,u,ldu,v,ldv,work,jobx,info)
c**** 6/18/87
c      if( info .ne. 0)return
       if (info .ne. 0) then
         if (ldebug) write(outunit,101) info
 101     format('rcsvdc - after zsvd, info= ',i4)
         return
       endif
c
c*****    compute the column and row nullities of x
c         n1 = number of singular values interpreted as zeros
c
c         we seek n1 so that
c             s(nsvd-n1) >= t2 > t1 >= s(nsvd-n1+1 )
c         if this relation does not hold n1 is decreased by one
c         until we have a gap t2/t1 (=gap) between the singular
c         values we interpret as zeros and the others.
c*****    works only if singular values in increasing order
c
      t1 = epsu
      t2 = gap * t1
      if (ldebug) then
           write(outunit,100) 't1= ', t1, 't2= ', t2
  100      format(t5,a,d12.5,tr5,a,d12.5)
      endif
c

      nsvd = min0(m,n)
c
c**** shall we compute cnull and rnull or not?
c
      if (opt .eq. 'cind') then
c
c**** note that if only one singular value then we interpret it
c     as zero if it is less than t2
         if (nsvd .eq. 1) then
            n1 = 0
            if ( abs(s(1)) .le. t2 ) n1 = 1
         else
c
            do 20 i = nsvd, 1 , -1
               if (abs(s(i)) .ge. t1) go to 25
   20       continue
            n1 = nsvd
            go to 35
   25       continue
            if ( i .ge. 1) then
               if (abs(s(i)) .gt. t2) go to 30
               i = i - 1
               go to 25
            endif
   30       continue
            n1 = nsvd - i
         endif
   35    continue
c
         if ( m .ge. n ) then
            cnull = n1
            rnull = (m - n) + n1
         else
            cnull = (n - m) + n1
            rnull = n1
         endif
       else
c
c        cnull and rnull are alreday known from earlier computations
         if ( m.ge. n) then
             n1 = cnull
         else
             n1 = cnull - (n -m)
         endif
       endif
       del = 0.
       do 40 i = nsvd, (nsvd - n1 + 1), -1
c*     accumulate square root of sum of squares
           call upddel(del, abs(s(i)))
   40  continue
c
      if (incr) then
c
c      reorder the singular values (and  the corresponding vectors)
c      into increasing order
c
        do 50 i = 1, nsvd/2
           j = nsvd - i + 1
           if (wantu)
     *       call zswap(m,u(1,i),1,u(1,j),1)
           if (wantv)
     *       call zswap(n,v(1,i),1,v(1,j),1)
           cell = s(i)
           s(i) = s(j)
           s(j) = cell
   50   continue
      endif
c**       incr
      if (posmn) then
c
c      move the columns of u and v, such that the diagonal of
c      singular values (of u'*x*v where '=transpose conjugate)
c      ends at position (m,n)
c
        if ( (jobu .eq. 1) .and.  (m .gt. n)) then
c
c         move the last m-n columns of u to the first positions in u,
c         and adjust the remaining col's accordingly.
c         (remember the case when a=2, ncu= number of col's of u)
c
          mn = m - n
          do 70 k = 1, mn
              do 70 i = 1, m
                 cell = u(i,ncu)
                  do 60 j = ncu, 2, -1
                     u(i,j) = u(i,j-1)
   60         continue
              u(i,1) = cell
   70     continue
        endif
c**         (jobu = 1)
        if (wantv .and. (m .lt. n)) then
c
c         move the last n-m columns of v to the first positions in v
c         and adjust the remaining columns accordingly.
c         (n= the of col's of v)
c
          mn = n - m
          do 90 k = 1, mn
             do 90 i = 1, n
                cell = v(i,n)
                do 80 j = n, 2, -1
                   v(i,j) = v(i,j-1)
   80        continue
             v(i,1) = cell
   90     continue
        endif
c**         wantv
      endif
c**       posmn
c
      return
      end



