c     In this file June 13, 1987: reordr, exchng, cgiv, zcsrot
c     
c
      subroutine reordr (a, b, ldab, m, n, rowb, colb, rowe, cole,
     *                   ftest, ndim, ind, pp, ldpp, qq, ldqq)
c
c     implicit none
c***  debug space
      common /debug2/ idbg(20), outunit
      integer idbg, outunit
c 
      integer ldab, m, n, rowb, colb, rowe, cole, ftest
      integer ndim, ind(*), ldpp, ldqq
      complex*16 a(ldab,*), b(ldab,*), pp(ldpp,*), qq(ldqq,*)
c
c***********************************************************************
c     given that the specified regular part of a - lambda*b is in
c     upper triangular form reordr reorders the 1 by 1 diagonal blocks
c     (the generalized eigenvalues) by constructing
c     equivalence transformations (pairs of left and right givens
c     transformations). the givens transformations that perform the
c     reordering are accumulated in the left and right transformation
c     matrices pp and qq, respectively. normally pp and qq result
c     from previous reductions or are initialized to the identity 
c     matrix before the call.
c
c     after the reordering the eigenvalues specified by the function
c     ftest (provided by the user) appear at the top north-west corner
c     of the specified regular part of a - lambda*b.
c     if ndim is the number of eigenvalues in the spectrum specified
c     by ftest then the rowb+ndim-1 first columns of pp, and the 
c     colb+ndim-1 first columns of qq, respectively, 
c     span a pair of reducing subspaces corresponding to this 
c     part of the spectrum of a - lambda*b. for algorithmic details of
c     the reordering of eigenvalues see p. van dooren: algorithm 590:
c     dsubsp and exchng, fortran routines for computing deflating 
c     subspaces with specified spectrum, acm toms, vol.4, 1982,
c     pp 376-382
c 
c     if idb(7) .eq. 0 then debug output is switched off
c
c**** formal parameters
c 
c    on entry
c
c     a(ldab,*) complex*16, input matrix a in upper triangular form
c
c     b(ldab,*) complex*16, input matrix b in upper triangular form
c
c     ldab    integer, leading dimension of a and b
c
c     m       integer, current row dimension of a and b
c
c     n       integer, current column dimension of a and b
c
c     rowb    integer, first row of the regular part of a-lambda*b
c
c     colb    integer, first column of the regular part of a-lambda*b
c
c     rowe    integer, last row of the regular part of a-lambda*b
c
c     cole    integer, last column of the regular part of a-lambda*b
c
c     ftest(alpha, beta)  integer function describing the spectrum
c             of the deflating subspace to be computed. if alpha/beta
c             is in that spectrum then ftest = 1, otherwise ftest = -1.
c
c     ldpp    integer, leading dimension of pp
c
c     ldqq    integer, leading dimension of qq
c
c    on exit
c
c     ndim    integer, the dimension of the computed pair of
c             deflating subspace
c
c     ind(*)  integer array, working array of dimension at least
c             min(rowe-rowb+1)
c
c     pp(ldpp,*) complex*16, array, the unitary right hand transformation
c             matrix of order m by m.
c             accumulates all right hand givens transformations.
c
c     qq(ldqq,*) complex*16, the unitary left hand transformation
c             matrix of order n by n.
c             accumulates all left hand givens transformations.
c
c     a(ldab,*) in upper tringular form with reordered diagonal
c               elements
c
c     b(ldab,*) in upper triangular form with reordered diagonal
c               elements
c     note: the reordered eigenvalues are a(i,i)/b(i,i) (see also above)
c
cc************************************************************************
c
c**** this version dated 14 june, 1987
c     authors: jim demmel and bo kagstrom
c
c**** reordr uses the following functions and subroutines
c     cmatpr, exchng
c     ftest (user written)
c
c**** internal variables
      integer dimr, i, k, j, inside, rfirst, kfirst, jj, nswap
      integer indk, ii
      logical ldebug
c
c     set debug flag
      ldebug = idbg(7) .ne. 0
c
      if (ldebug) then
         write(outunit, 2005) 'eigenvalues before reordering'
         do 770 i = rowb, rowe
           j = colb + i - rowb
           if (abs(b(i ,j)) .eq. 0. ) then
               write(outunit, 2005) 'infinite eigenvalue',a(i,j), b(i,j)
 2005          format(t5,a,4d15.5)
           else
               write(outunit, 2005) 'eigenvalue=', a(i,j)/b(i,j)
           endif
  770    continue
      endif
c***
c
      dimr = rowe - rowb +1
      if (ldebug) then
           write(outunit, 500) 'dimr=', dimr
  500      format(t5,a,i3)
      endif
c
      if( dimr .ge. 2) then
c**** search through the eigenvalues and note down in ind(*) which
c     eigenvalues are in the spectrum determined by ftest
c
      ndim = 0
      dimr = 0
      do 10 i = rowb, rowe
         dimr = dimr + 1
         inside = ftest( a(i, colb + dimr - 1), b(i, colb + dimr - 1))
         if ( inside .eq. 1 ) ndim = ndim + 1
         ind(dimr) = inside
   10 continue
      if (ldebug) then
          write(outunit, 700) 'ind(*) before reordering',
     *                  (ind(i), i = 1, dimr)
  700     format(t5,a,20i3)
      endif
c
c**** reorder the blocks (eigenvalues) such that those that belong
c     to the specified spectrum appear first at the top north-west corner
c     of the specified regular part of a-lambda*b
c
      do 100 i = 1, dimr
         if ( ind(i) .lt. 0) then
c
c           search for the first block to be moved ( first ind(k)
c           that is positive)
            do 60 k = i + 1, dimr
                 if ( ind(k) .gt. 0) go to 70
   60       continue
c           no more blocks to test or to move, go to exit
            go to 110
         else
c           continue the search
            go to 100
         endif
c
c        make k-i interchanges so that block k appear before block i
   70    continue
         nswap = k - i
         if (ldebug) write(outunit, 500) 'nswap=',nswap
         indk = ind(k)
         do 80 j =1, nswap
              jj = k - j
              rfirst = rowb + i - 1 + nswap - j
              kfirst = colb + i - 1 + nswap - j
              call exchng(a, b, ldab, m, n, rfirst, kfirst,
     *                    pp, ldpp, qq, ldqq)
              ind(jj + 1) = ind(jj)
   80    continue
         ind(i) = indk
         if (ldebug) then
              write(outunit, 700) 'ind(*) after do 80',
     *                      (ind(ii),ii=1,dimr)
         endif
c
c     continue to search for eigenvalues that should be reordered
  100 continue
c
c     exit
  110 continue
      if (ldebug) then
           write(outunit, 700) 'final ind(*) from reorder',
     *                   (ind(ii),ii=1,dimr)
      endif
c
c     end of if ( dimr .ge. 2)
      endif
c
      if (idbg(2) .gt. 1) then
            call cmatpr(qq,ldqq,n,n,'qq after reordr')
            call cmatpr(pp,ldpp,m,m,'pp after reordr')
      endif
c
      if (ldebug) then
         write(outunit, 2005) ' eigenvalues at exit from reordr'
         do 75 i = rowb, rowe
           j = colb + i - rowb
           if (abs(b(i ,j)) .eq. 0. ) then
               write(outunit, 2005) 'infinite eigenvalue',a(i,j), b(i,j)
           else
               write(outunit, 2005) 'eigenvalue=', a(i,j)/b(i,j)
           endif
   75    continue
       endif
c
      return
      end
 
      subroutine exchng(a, b, ldab, m, n, rowb, colb,
     *                  pp, ldpp, qq, ldqq)
c
c     implicit none
c***  debug space
      common /debug2/ idbg(20), outunit
      integer idbg, outunit
c
      integer ldab, m, n, rowb, colb, ldpp, ldqq
      complex*16 a(ldab,*), b(ldab,*), pp(ldpp,*), qq(ldqq,*)
c
c***********************************************************************
c     given that the regular part of a - lambda*b is on upper
c     triangular form exchng computes a unitary equivalence
c     transformation that exchanges the 1 by 1 diagonal blocks
c     at positions (rowb, colb) and (rowb+1, colb+1), respectively,
c     along with their generalized eigenvalues.
c     the givens rotations that perform the exchange are
c     accumulated in the left and right transformation matrices
c     pp and qq, respectively.
c
c     if idbg(8) .eq. 0 then debug output is switched off
c
c     formal parameters
c     
c    on entry
c
c     a(ldab,*) complex*16, input matrix a in upper triangular form
c
c     b(ldab,*) complex*16, input matrix b in upper triangular form
c
c     ldab    integer, leading dimension of a and b 
c
c     m       integer, current row dimension of a and b
c
c     n       integer, current column dimension of a and b
c
c     rowb    integer, first row of the regular part of a-lambda*b
c
c     colb    integer, forst column of the regular part of a-lambda*b
c
c     ldpp    integer, leading dimension of pp
c
c     ldqq    integer, leading dimension of qq
c
c    on exit
c
c     pp(ldpp,*) complex*16, the unitary right hand transformation
c             of order m by m
c
c     qq(ldqq,*) complex*16, the unitary left hand transformation
c             of order n by n
c
c     a(ldab,*)  in upper triangular form with two diagonal elements
c             exchanged
c
c     b(ldab,*)  in upper trinagular form with two diagonal elements
c             exchanged
cc
c************************************************************************
c
c**** this version dated june 14, 1986
c     authors: jim demmel and bo kagstrom
c
c**** exchng uses the following functions and subroutines
c     cgiv, cmatpr, zcsrot
c
c**** internal variables
      logical altb, ldebug
      integer rbp1, cbp1
      real*8    maxab1
      complex*16 sa1, sb1, f, g, s, c, ctemp
c
      ldebug = idbg(8) .ne. 0
c
      rbp1 = rowb + 1
      cbp1 = colb + 1
      if (ldebug) then
        write (outunit, 2000) 'results from exchng: rowb, colb', 
     *                        rowb, colb
 2000   format( t5, a, 2i3)
        write(outunit, 2000) 'eigenvalues before exchange'
        write(outunit, 2000) 'rbp1,cbp1=', rbp1, cbp1
        if (abs(b(rowb,colb)) .gt. 0.) then
              ctemp = a(rowb,colb)/b(rowb,colb)
              write(outunit, 3000) ctemp
        else
              write(outunit, 3000) a(rowb,colb), b(rowb,colb)
        endif
        if (abs(b(rbp1,cbp1)) .gt. 0.) then
             write(outunit, 3000) a(rbp1,cbp1), b(rbp1,cbp1)
             ctemp = a(rbp1,cbp1)/b(rbp1,cbp1)
             write(outunit, 3000) ctemp
        else
             write(outunit, 3000) a(rbp1,cbp1), b(rbp1,cbp1)
        endif
 3000   format( t5,d15.5)
c     end of output for debugging
      endif
      maxab1 = max(abs(a(rbp1, cbp1)), abs(b(rbp1, cbp1)))
      altb = .true.
      if (abs(a(rbp1, cbp1)) .ge. maxab1) altb = .false.
      if (ldebug) then
           write(outunit, 310)  'maxab1=', maxab1
  310      format(t5, a, d15.5)
           write(outunit,305) 'altb=', altb
  305      format(t5,a,l1)
      endif
      sa1 = a(rbp1, cbp1) / maxab1
      sb1 = b(rbp1, cbp1) / maxab1
      f = sa1 * b(rowb, colb) - sb1 * a(rowb, colb)
      g = sa1 * b(rowb, cbp1) - sb1 * a(rowb, cbp1)
c
c**** construct the right hand transformation (affects the columns
c     colb and colb + 1 of a, b and qq)
      call cgiv(f, g, c, s)
      call zcsrot(rbp1, a(1, colb), 1, a(1, cbp1),1, conjg(s), -c)
      call zcsrot(rbp1, b(1, colb), 1, b(1, cbp1),1, conjg(s), -c)
      call zcsrot(n, qq(1, colb), 1, qq(1, cbp1), 1, conjg(s), -c)
      if (ldebug) then
           call cmatpr( a,ldab,m,n, ' A after right transf.')
           call cmatpr( b,ldab,m,n, ' B after right transf.')
      endif
c
c**** construct the left hand transformation (affects the rows
c     rowb and rowb + 1 of a, b, and pp(conjg,trans))
      if (altb) then
         call cgiv(b(rowb, colb), b(rbp1, colb), c, s)
      else
         call cgiv(a(rowb, colb), a(rbp1, colb), c, s)
      endif
      call zcsrot(n-colb+1, a(rowb,colb), ldab, a(rbp1, colb),
     *           ldab, c, s)
      call zcsrot(n-colb+1, b(rowb,colb), ldab, b(rbp1, colb),
     *           ldab, c, s)
      call zcsrot(m, pp(1, rowb), 1, pp(1, rbp1), 1, c, conjg(s))
      if (ldebug) then
           call cmatpr( a,ldab,m,n, ' A after left transf.')
           call cmatpr( b,ldab,m,n, ' B after left transf.')
      endif
c
      a(rbp1, colb) = (0.d0, 0.d0)
      b(rbp1, colb) = (0.d0, 0.d0)
      if (ldebug) then
           write (outunit, 2000) 'eigenvalues after exchange'
           if (abs(b(rowb,colb)) .gt. 0.) then
              write(outunit, 3000) a(rowb,colb)/b(rowb,colb)
           else
              write(outunit, 3000) a(rowb,colb), b(rowb,colb)
           endif
           if (abs(b(rbp1,cbp1)) .gt. 0.) then
              write(outunit, 3000) a(rbp1,cbp1)/b(rbp1,cbp1)
           else
              write(outunit, 3000) a(rbp1,cbp1), b(rbp1,cbp1)
           endif
           call cmatpr( a,ldab,m,n, 'Final A after one exchange')
           call cmatpr( b,ldab,m,n, 'Final B after one exchange')
c     end of outputs for debugging
      endif
      return
      end

      subroutine cgiv( a, b, c, s)
c
c     implicit none
c***  debug space
      common /debug2/ idbg(20), outunit
      integer idbg, outunit
c***  formal parameter declarations
      complex*16 a, b, s , c
c
c**** cgiv constructs a complex givens transformation
c
c                c      s
c        g =                  c*c + s*conjg(s) = 1
c            -conjg(s)  c
c
c     which zeros the second entry of the 2-vector (a,b)**t:
c               a   aprim
c           g * b =   0   
c
c     cgiv leaves the arguments a and b unchanged,
c     (aprim is computed but no returned in this version).
c     note that the resulting c could have been chosen real
c     (but not for our application since we interchange c and s
c      when applying the the transformation in an equivalence
c      transformation)
c
c     if idbg(8) .eq. 0 then debug output is  withed off
c
c**** this version dated june, 1986
c
c**** internal variables
c
      real*8 sigma, delta, absa 
      complex*16  aprim, alfa
      logical ldebug
      ldebug = idbg(8) .ne. 0
c
      absa = abs(a)
      if ( absa .eq. 0) then
         c = 0.d0
         s = (1.d0, 0.d0)
         aprim = b
      else
         sigma = absa + abs(b)
         delta = sigma*sqrt(abs(a/sigma)**2 + abs(b/sigma)**2)
         alfa = a / absa
         c = absa /delta
         s = alfa * conjg(b) / delta
         aprim = alfa * delta
      endif
      if (ldebug) then
          write(outunit, 100) 'cos=', c, 'sin=', s
  100     format (t5, a, 2d12.5)
          write(outunit, 100) 'cos-sin-identity', 
     +                        c*conjg(c)+s*conjg(s)
      endif
      return
      end

      subroutine  zcsrot (n,cx,incx,cy,incy,c,s)
c
c     implicit none
      complex*16 cx(*), cy(*), c, s
      integer incx,incy,n
c
c**** zcsrot
c     applies a givens transformation where cos (c) and sin (s)
c     are complex as well as the vectors cx and cy.
c     the transformation is computed by cgiv.
c     note that c can be chosen real. however since we
c     will be able to interchange the values of c and s when
c     calling zcsrot we have to declare c as complex too.
c 
c     zcsrot is a modification of csrot
c     deal with complex sin (s) and cos (c)
c
c**** this version dated june, 1986
c
      integer i, ix, iy
      complex*16 ctemp
c
      if(n.le.0)return
      if(incx.eq.1.and.incy.eq.1)go to 20
c
c       code for unequal increments or equal increments not equal
c         to 1
c
      ix = 1
      iy = 1
      if(incx.lt.0)ix = (-n+1)*incx + 1
      if(incy.lt.0)iy = (-n+1)*incy + 1
      do 10 i = 1,n
        ctemp = c*cx(ix) + s*cy(iy)
        cy(iy) = conjg(c)*cy(iy) - conjg(s)*cx(ix)
        cx(ix) = ctemp
        ix = ix + incx
        iy = iy + incy
   10 continue
      return
c
c       code for both increments equal to 1
c
   20 continue
      do 30 i = 1,n
        ctemp = c*cx(i) + s*cy(i)
        cy(i) = conjg(c)*cy(i) - conjg(s)*cx(i)
        cx(i) = ctemp
   30 continue
      return
      end


