      subroutine rzstr (opt, a, b, ldab, m, n, rowb, rowe,
     *                  colb, cole, first, zero, epsua, epsub, gap,
     *                  pp, ldpp, qq, ldqq, kstr, kfirst, step,
     *                  adlsvd, bdlsvd,
     *                  work, x, sx, ex, q, arow, brow, w, qraux, y,
     *                  qty, info)
c
c     implicit none
c**** debug space
c     the common-block declarations assume that the dimension of the
c     input matrix pencil a - lambda b is not larger than abdim.
c     the debug space is used for producing debug outputs (optional,
c     see below)
c
      integer abdim
      parameter (abdim = 30)
      common /debug1/ acopy(abdim,abdim),bcopy(abdim,abdim),
     *              atest(abdim,abdim), btest(abdim,abdim), swap
      common /debug2/ idbg(20), outunit
      complex*16 acopy,bcopy,atest,btest
      logical swap
      integer idbg, outunit
c
c**** formal parameter declarations
      character*(*) opt
      integer ldab, m, n, rowb, rowe, colb, cole, ldpp, ldqq,
     *        kstr(4,*), step, kfirst, info
      logical first, zero
      real*8 adlsvd, bdlsvd, epsua, epsub, gap
      complex*16 a(ldab,*), b(ldab,*), pp(ldpp,*), qq(ldqq,*),
     *        work(*)
c
c****    workspace 
c
        complex*16   x(m,*), sx(*), ex(*), q(n,*), 
     *           arow(*), brow(*), w(n,*), qraux(*),
     *           y(*), qty(*)
c
c*******************************************************************
c
c     rzstr computes the kronecker right (column) structure and
c     the jordan structure of the zero-eigenvalue of a singular
c     pencil a-lambda*b.for details concerning the listr-kernel see 
c     the following papers:
c     
c        b.kagstrom, rgsvd - an algorithm for computing the kronecker
c             structure and reducing subspaces of singular a - lambda b
c             pencils, siam j.sci.stat.comput., vol. 7, 1986, pp 185-211
c
c        j.demmel and b.kagstrom, stably computing the kronecker 
c             structure and reducing subspaces of singular pencils
c             a - lambda b for uncertain data, in large scale eigenvalue
c             problems (cullum, willoughby eds), north holland, 1986,
c             pp 283-323.
c
c
c     formal parameters
c
c     on entry
c
c        opt*(*) character, if opt = 'cind' rzstr computes indices
c                           if opt = 'rind' already computed indices
c                           are reused in the reduction
c
c        a(ldab,*) complex*16, input matrix a of order m by n
c
c        b(ldab,*) complex*16, input matrix b of order m by n
c
c        ldab      integer, leading dimension of a and b
c
c        m         integer, current row dimension of a and b
c
c        n         integer, current column dimension of and b
c
c        rowb      integer, first row of the subpencil
c
c        rowe      integer, last row of the subpencil
c
c        colb      integer, first column of the subpencil
c
c        cole      integer, last column of the subpencil
c
c        first     logical, first should be 'true' if first call to 
c                  rzstr, else 'false'
c
c        zero      logical, if 'true', zero out small singular values
c                  so returned pencil really has structure described
c                  in kstr (see below), else returned pencil is a
c                  true equivalence transformation of input pencil
c                  (no singular values are deleted)
c
c        epsua     real*8, threshold for deleting singular values of a
c                  (used when compressing columns of a)
c
c        epsub     real*8, threshold for deleting singular values of b
c                  (used when compressing columns of b)
c
c        gap       real*8, should be at least 1 and nominally 1000.
c                  used by subroutine rcsvdc to make rank decisions
c                  by searching for adjacent singular values whose
c                  ratio exceeds gap.
c
c        ldpp      integer, leading dimension of pp
c
c        ldqq      integer, leading dimension of qq
c
c        kfirst    integer, index to the first location in kstr
c                  where structure-index information is stored
c                  from this reduction (see below)
c
c     on exit
c
c        pp(ldpp,*)complex*16, left unitary transformation matrix 
c                  pp of order m by m
c
c        qq(ldqq,*)complex*16, right unitary transformation matrix
c                  qq of order n by n
c
c        a(ldab,*) transformed matrix a (pp**h * a * pp)
c
c        b(ldab,*) transformed matrix b (pp**h * b * pp)
c
c        kstr(4,*) integer, stores information concerning right 
c                  kronecker indices and the jordan structure of
c                  the zero eigenvalue.
c                  kstr(1,kfirst-1+j) - kstr(2,kfirst-1+j) =
c                  number of l(j-1) blocks (right indices of
c                  degree j-1).
c                  kstr(2,kfirst-1+j) - kstr(1,kfirst+j) = 
c                  number of jordan blocks of the zero
c                  eigenvalue of dimension j.
c                  index j goes from 1 to step (see below)
c                  note: rows 3 and 4 of kstr are not used inside 
c                  rzstr.
c
c        step      integer,  the number of deflation-steps in this
c                  reduction
c
c        adlsvd    real*8, root sum of squares of deleted singular
c                  values of a (independent of the input zero)
c
c        bdlsvd    real*8, root sum of squares of deleted singular
c                  values of b (independent of the input zero)
c
c        info      integer, zero if normal return,
c                           1 if svd does not converge
c
c        on exit from rzstr a and b will be in block upper triangular form:
c
c
c              a = ( arz   *  )        b = ( brz    *  )
c                  (  0   a22 )            (  0    b22 )
c
c        the block structure of arz - lambda*brz describes the 
c        kronecker column (right) structure and the jordan structure 
c        of the zero eigenvalue. if ni and ri denote the dimension of
c        the diagonal blocks in arz and brz (see example below), then 
c        they have the following interpretation:
c
c          ni - ri = the number of l(i-1) -blocks of order (i-1) by i
c          ri - ni+1 = the number of j(0)-blocks of order i by i
c
c        note that if a - lambda*b is a regular pencil then ni=ri.
c        the rzstr reduction stops when an ni.eq.0 or ni.ne.0 but ri.eq.0. 
c        then a22 will have full column rank. a22 - lambda*b22 might
c        still be a singular pencil (can have row (left) indices). 
c        an example illustrates the two cases (see papers for details):
c        case 1 - n4.eq.0:
c
c                ( 0  a12 a13 ) r1           ( b11 b12 b13 ) r1
c          arz = ( 0   0  a23 ) r2     brz = (  0  b22 b23 ) r2
c                ( 0   0   0  ) r3           (  0   0  b33 ) r3
c                  n1  n2  n3                   n1  n2  n3
c
c        case 2 - n4.ne.0 and r4.eq.0:
c
c                ( 0  a12 a13 a14 ) r1        ( b11 b12 b13 b14 ) r1
c          arz = ( 0   0  a23 a24 ) r2  brz = (  0  b22 b23 b24 ) r2
c                ( 0   0   0  a34 ) r3        (  0   0  b33 b34 ) r3
c                  n1  n2  n3  n4                n1  n2  n3  n4
c
c       the ri by ni diagonal blocks bii of brz are in the form
c       ( 0 rii), where rii is ri by ri, nonsingular and upper
c       triangular.
c
c       if kfirst = 1 on input then case 2 above cause the following
c       output for step and kstr:
c         step = 4
c         kstr(1,1) = n1   kstr(2,1) = r1
c         kstr(1,2) = n2   kstr(2,2) = r2
c         kstr(1,3) = n3   kstr(2,3) = r3
c         kstr(1,4) = n4   kstr(2,4) = 0
c
c       note that on output (arz,brz) or (a22,b22) can be nonexistent
c       in the block upper triangular form (a,b). (arz,brz) does not 
c       exist if n1=r1=0. (a22,b22) does not exist if the input pencil
c       a -lambda*b has no left (row) singular structure, no
c       infinite eigenvalue and no nonzero eigenvalues.
c
c***     work space including size (all variables complex*16)
c        work(*)           max(m,n)
c        x(m,*)            m by n
c        sx(*)             min(m,n) + 1
c        ex(*)             n
c        q(n,*)            n by n
c        arow(*)           max(m,n)
c        brow(*)           max(m,n)
c        w(n,*)            n by n
c        qraux(*)          max(m,n)
c        y(*)              max(m,n)
c        qty(*)            max(m,n)
c
c*****************************************************************
c
c****    this version dated june 16, 1987
c        authors: jim demmel and bo kagstrom
c
c****    rzstr uses the following functions and subroutines
c        kcfpack  - cmatml, cmatmr, cmatpr, cmcopy, rcsvdc, upddel 
c        linpack  - zqrdc, zqrsl
c
c****    internal variables
c
        logical ldebug
        integer mrow, ncol, i, j, sn1, sr1, rep, rowsr1, colsn1, xrow
     *          , xcol, job, ldx, ldq, n1, rnull, ldw, cnull, r1,
     *          colsnb, jend, idummy, ikstr, mxrc, k, iii, jjj
c
        real*8 del, difa, difb
c
        complex*16 dummy
c
c****   set leading dimensions of x, q, and w
c
        ldx = m
        ldq = n
        ldw = n
c       set debug switch
        ldebug= (idbg(4).ne.0)
c****   compute the order of the pencil in action (mrow * ncol)
c
        mrow = rowe - rowb + 1
        ncol = cole - colb + 1
c
c*+*+*  accumulate deleted singular values in adlsvd, bdlsvd 
        adlsvd = 0.0
        bdlsvd = 0.0
c
      if (ldebug) write (outunit,1001) 'epsua=', epsua
      if (ldebug) write (outunit,1001) 'epsub=', epsub
1001  format(t5,a,d13.6)
c
c
c**** set rep depending on what option
c
      if ( opt .eq. 'cind' ) then
c         perhaps not enough !!
          rep = rowe * cole
      else
          rep = step - kfirst + 1
      endif
c***  6/18/87
      if (ldebug) write(outunit,2000) 'kfirst=',kfirst,
     +            'step=',step,'rep=',rep
c
      sn1 = 0
      sr1 = 0
      step = 0
c**** while rep > 0 do
   30 continue
      if (ldebug) write(outunit,2000) 'rep at top of loop=',rep
      if (rep .eq. 0) go to 500
c     jump when while - loop satisfied
c
c     while - clause
        step = step + 1
        if (ldebug) write(outunit,2000) 'Results from step = ', step
 2000   format( t5, a, i3/)
        if (ldebug) write(outunit,2005) opt
 2005   format(t5,a)
c
c**** set n1 and r1 if we are reusing kstr
c
      if ( opt .eq. 'rind' ) then
         ikstr = kfirst + step - 1
         n1 = kstr(1, ikstr)
         r1 = kstr(2, ikstr)
         cnull = n1 -r1
      endif
c
c**** step 1 - compress columns of a (gives n1 = dimension of the
c              column nullspace)
c* 1.1
c      rows, rowb+sr1:rowe
c      cols, colb+sn1:cole
c
        rowsr1 = rowb + sr1 - 1
        colsn1 = colb + sn1 - 1
        xrow = mrow - sr1
        xcol = ncol - sn1
        do 40 i = 1, xrow
           do 35 j = 1, xcol
              x(i, j) = a(rowsr1 + i, colsn1 + j)
   35      continue
   40   continue
        if ( xrow .ge. xcol ) then
           job = 0110
        else
           job = 0111
        endif
        if (ldebug) then
          write(outunit,5000) 'rowsr1=',rowsr1,'colsn1=',colsn1,
     +                        'xrow=',xrow
          write(outunit,5000) 'xcol=',xcol,'rowb=',rowb,'rowe=',rowe
          write(outunit,5000) 'colb=',colb,'cole=',cole,'sr1=',sr1,
     +                        'sn1=',sn1
        endif
c
c       put m*n in info before calling
        if (idbg(4) .gt. 2) then
          call cmatpr(x ,ldx, xrow, xcol,'a-input rcsvdc')
        endif
        info = m*n
        call rcsvdc (x, ldx, xrow, xcol, sx, ex, dummy, 1, q, ldq, opt,
     *               epsua, gap, n1, rnull, del, work, job, info )
c
c
         call upddel(adlsvd, del)
c
        mxrc = min0( xrow, xcol)
        if (ldebug) call cmatpr( sx, 1, 1, mxrc,
     *               'singular values - column compress a')
       if (idbg(4) .gt. 1 .or. (info .ne. 0 .and. ldebug) ) then
         call cmatpr( ex, 1, 1, mxrc,'sub diagonal - should be zero')
         call cmatpr(q, ldq, xcol, xcol,
     *               'step1.1: right singular vectors of A')
       endif
        if (ldebug) write (outunit,1005) 'info=', info, 'n1=', n1
 1005   format(t5, a, i3/ )
c
         if (info .ne. 0) then
c****      6/18/87
           if (ldebug) write(outunit,2007) info
 2007      format('rzstr - after first call to rcsvdc, info= ',i4)
           info = 1
           return
         endif
c
c       if n1=0, we are done
        if (n1 .eq. 0) then
           r1=0
           goto 450
        end if
c
c* 1.2 - apply right transformation q to a and b (the full matrices)
c        rows in a and b: 1:rowe
c        columns in a: colb+sn1:cole ( xcol col's)
c        columns in b: colb+sn1:cole
c
        do 70 i = 1, rowe
           do 50 j = 1, xcol
              arow(j) = 0.d0
              brow(j) = 0.d0
              do 45 k = 1, xcol
                 arow(j) = arow(j) + a(i, colsn1 + k) * q(k, j)
                 brow(j) = brow(j) + b(i, colsn1 + k) * q(k, j)
   45         continue
   50      continue
           do 60 j = 1, xcol
                 a(i, colsn1 + j) = arow(j)
                 b(i, colsn1 + j) = brow(j)
   60      continue
   70   continue
c
c*         zero part of a
c          rows, rowb+sr1:rowe
c          cols, colb+sn1:colb+sn1+n1-1
c
        if (zero) then
          do 80 i = rowb + sr1, rowe
             do 75 j = colb + sn1, colsn1 + n1
                a(i, j) = 0.d0
   75        continue
   80     continue
        endif
c
c**** Step 2 - column compress part of B ( gives n1 - r1 =
c              dimension of the common nullspace)
c
c* 2.1
c       rows, rowb+sr1:rowe
c       cols, colb+sn1:colb+sn1+n1-1
c
        xrow = mrow - sr1
        xcol = n1
        do 90 i = 1, xrow
           do 85 j = 1, xcol
              x(i, j) = b( rowsr1 + i, colsn1 + j)
   85      continue
   90   continue

        if (xrow .ge. xcol) then
           job = 0110
        else
           job = 0111
        endif
        if (idbg(4) .gt. 2) then
          call cmatpr(x ,ldx, xrow, xcol,'b-input rcsvdc')
        endif
        info = m*n
        call rcsvdc ( x, ldx, xrow, xcol, sx, ex, dummy, 1, w, ldw,
     *           opt, epsub, gap, cnull, rnull, del, work, job, info )
c
        if ( opt .eq. 'cind' ) r1 = n1 - cnull
c
c       if r1 = 0 then we are done ! Zero part in b and then update qq
c
c
        if (ldebug) write(outunit,1005) 'info=', info, 'cnull=', cnull,
     *                  'n1=', n1,'r1=', r1
c
        mxrc = min0( xrow, xcol)
        if (ldebug) call cmatpr( sx, 1, 1, mxrc,
     *               'singular values - column compress b')
       if (idbg(4) .gt. 1 .or. (info .ne. 0 .and. ldebug) ) then
         call cmatpr( ex, 1, 1, mxrc,'sub diagonal - should be zero')
         call cmatpr ( w, ldw, xcol, xcol,
     *                'step 2.1: right singular vectors of b')
       endif
c     
       call upddel(bdlsvd, del)
c
        if (info .ne. 0) then
c****     6/18/87
          if (ldebug) write(outunit,2008) info
 2008     format('rzstr - after second call to rcsvdc, info= ',i4)
          info = 1
          return
        endif
c
       if (r1 .eq. 0) goto 3500
c
c* 2.2
c      update q  rows, 1:ncol-sn1
c                cols, 1:n1
c         a, b   rows, 1:rowe
c                cols, colb+sn1:colb+sn1+n1-1
c
c      note that we do not make use of that some of the elements in a
c      are zero
c      first q
       xcol = ncol - sn1
       do 110 i = 1, xcol
          do 100 j = 1, n1
             arow(j) = 0.d0
             do 95 k = 1, n1
                arow(j) = arow(j) + q(i, k) * w(k, j)
   95        continue
  100     continue
c
          do 105 j = 1, n1
             q(i, j) = arow(j)
  105     continue
  110   continue
c
        if (idbg(4) .gt. 2) then
           call cmatpr(q, ldq, xcol, xcol,
     *                'updated q after second column compress')
        endif
c        
c       now a and b ....
        do 120 i = 1, rowe
           do 114 j = 1, n1
              arow(j) = 0.d0
              brow(j) = 0.d0
              do 112 k = 1, n1
                 arow(j) = arow(j) + a(i, colsn1 + k) * w(k, j)
                 brow(j) = brow(j) + b(i, colsn1 + k) * w(k, j)
  112         continue
  114      continue
           do 116 j = 1, n1
              a(i, colsn1 + j) = arow(j)
              b(i, colsn1 + j) = brow(j)
  116      continue
  120   continue
c
c*        zero part of b
c         rows, rowb+sr1:rowe
c         cols, colb+sn1:colb+sn1+(n1-r1)-1
c
 3500  continue
       if (zero) then
         do 130 i = rowb + sr1, rowe
            do 125 j = 1, n1 - r1
               b(i, colsn1 + j) = 0.d0
  125       continue
  130    continue
       endif
c
       if (r1 .eq. 0 )go to 350 
c
c**** Step 3 - Triangularize b ( using qr)
c
c* 3.1
c         rows, rowb+sr1:rowe
c         cols, colb+sn1+(n1-r1):cole
c
          xrow = mrow - sr1
          xcol = ncol - sn1 - (n1 - r1)
          colsnb = colsn1 + (n1-r1)
          do 140 i = 1, xrow
             do 135 j = 1, xcol
                x(i, j) = b( rowsr1 + i, colsnb + j)
  135        continue
  140     continue
          job = 0
          call zqrdc( x, ldx, xrow, xcol, qraux, idummy, dummy, job)
c
c         move the upper triangular part to b
c
          do 150 i = 1, xrow
             do 145 j = i, xcol
                b(rowsr1 + i, colsnb + j) = x(i, j)
  145        continue
             jend = min0(xcol, i - 1)
             do 148 j = 1, jend
                b(rowsr1 + i, colsnb + j) = 0.d0
  148        continue
  150    continue
c
c* 3.2
c        apply v(conj,trans) to remaining cols of b
c        from the left (xrow*xrow)
c        rows, rowb+sr1:rowe
c        cols, cole+1:n
c
         do 170 j = cole+1, n
            do 160 i = 1, xrow
               y(i) = b(rowsr1 + i, j)
  160       continue
            job = 01000
            call zqrsl(x, ldx, xrow, xcol, qraux, y, dummy, qty,
     *                 dummy, dummy, dummy, job, info)
            do 165 i = 1, xrow
               b(rowsr1 + i, j) = qty(i)
  165       continue
  170    continue
c        if (ldebug) call cmatpr(b, ldab, m, n,
c    *              'B after triangularization - step 3.1')
c
c        apply v(conj,trans) to a from the left (xrow*xrow)
c        rows, rowb+sr1:rowe
c        cols, colb+sn1+n1:n
c
         do 185 j = colb + sn1 + n1, n
            do 180 i = 1, xrow
               y(i) = a(rowsr1 + i, j)
  180       continue
            job = 01000
            call zqrsl(x, ldx, xrow, xcol, qraux, y, dummy, qty,
     *                 dummy, dummy, dummy, job, info)
            do 175 i = 1, xrow
               a(rowsr1 + i, j) = qty(i)
  175       continue
  185    continue
c        if (ldebug) call cmatpr(a,ldab,m,n,'A after step 3.2')
c
c****    update left transformation matrix pp ( m*m )
c        rows, 1:m
c        cols, rowb+sr1:rowe
c
         do 200 i = 1, m
            do 190 j = 1, xrow
               y(j) = conjg( pp(i, rowsr1+j) )
  190       continue
            job = 01000
            call zqrsl( x, ldx, xrow, xcol, qraux, y, dummy, qty,
     *                 dummy, dummy, dummy, job, info)
            do 195 j = 1, xrow
               pp(i, rowsr1 + j) = conjg( qty(j) )
  195       continue
  200    continue
c        
         if (idbg(4) .gt. 1) then
            call cmatpr(pp, ldpp, m, m,
     *                  'step 3.2: pp after updating with w from qr')
         endif
  350    continue
c
c****    update right transformation matrix qq (n*n)
c        rows, 1:n
c        cols, colb+sn1:cole
c
         xcol = ncol - sn1
         if (first) then
            do 210 i = 1, n
               do 205 j = 1, n
                  qq(i, j) = q(i, j)
  205          continue
  210       continue
        else
            do 240 i = 1, n
               do 230 j = 1, xcol
                  arow(j) = 0.d0
                  do 220 k = 1, xcol
                     arow(j) = arow(j) + qq(i, colsn1 + k) * q(k, j)
  220             continue
  230          continue
               do 235 j = 1, xcol
                  qq(i, colsn1 + j) = arow(j)
  235          continue
  240       continue
         endif
         if (idbg(4) .gt. 2) then
            call cmatpr(qq,ldqq, m, m, 'updated qq')
         endif
c        
c****    update indices
c
         sn1 = sn1 + n1
         sr1 = sr1 + r1
      if (ldebug) then
        write(outunit,5000) 'rowsr1=',rowsr1,'colsn1=',colsn1,
     +                      'xrow=',xrow
        write(outunit,5000) 'xcol=',xcol,'rowb=',rowb,'rowe=',rowe
        write(outunit,5000) 'colb=',colb,'cole=',cole,'sr1=',sr1,
     +                      'sn1=',sn1
      endif
c*       monitoring of the r1 and n1 in kstr
c
  450    continue
c****    added 060787 to match zlistr
       if (ldebug) then
         if (swap) then
           call cmcopy(bcopy,20,m,n,atest)
           call cmcopy(acopy,20,m,n,btest)
         else
           call cmcopy(acopy,20,m,n,atest)
           call cmcopy(bcopy,20,m,n,btest)
         end if
         call cmatml(atest,20,m,n,pp,ldpp,m,atest,20,work,3)
         call cmatmr(atest,20,m,n,qq,ldqq,n,atest,20,work,1)
         call cmatml(btest,20,m,n,pp,ldpp,m,btest,20,work,3)
         call cmatmr(btest,20,m,n,qq,ldqq,n,btest,20,work,1)
         difa=0
         difb=0
         do 1234 iii=1,m
           do 5678 jjj=1,n
             difa=difa+abs(atest(iii,jjj)-a(iii,jjj))
             difb=difb+abs(btest(iii,jjj)-b(iii,jjj))
 5678      continue
 1234    continue
         write(outunit,201) 'difa=',difa
 201     format(t5,a,d13.6/)
c        call cmatpr(atest,20,m,n,'atest')
         write(outunit,201) 'difb=',difb
c        call cmatpr(btest,20,m,n,'btest')
       endif
c
c****    compute rep depending on what option is used
c
         if ( opt .eq. 'cind') then
            kstr(1, step) = n1
            kstr(2, step) = r1
            rep = n1 * r1 * (mrow - sr1) * (ncol - sn1)
         else
            rep =rep - 1
         endif
         if (ldebug) write(outunit,5000) 'sn1=',sn1,'sr1=',sr1,
     +                                   'rep=',rep
 5000    format(t5,a,i4/)
         first = .false.
         go to 30
c
c**** end of while clause
  500 continue
c
      return
      end
c     last line of zrstr


