      subroutine mexfunction(nlhs, plhs, nrhs, prhs)

	  implicit none 
      integer plhs(*), prhs(*)
      integer nlhs, nrhs

      integer mxcreatefull, mxgetpr

C
C This subroutine acts like a gateway to the clguptri
C fortran routine. It is supposed to be called by a
C Matlab routine where all error checking of parameters
C have already been done.
C The routine is designed to work also on systems that i
C do not support the "%val" function. This however leads
C to a very brut force handling of problems with matching 
C real and complax data as well implies a fixed mximum
C size of the input matrices.
C It should be investigated if there in practice is motivated
C not to use the %val function (which the would enable dynamic
C memory allocation).
C

C     Input parameters corresponding to integers in fortran guptri
      integer m, n, wsize
      double precision dm, dn, dwsize

C     Input parameters corresponding to doubles in fortran guptri
	  double precision epsu, gap

C     Input parameters corresponding to logicals in fortran guptri
      logical zero
      double precision dzero

C     Output parameters corresponding to integers in fortran guptri
      integer info 
      double precision dinfo

C     Local variables 
	  integer kstrcols

      call mxCopyPtrToReal8(mxGetPr(prhs(3)),dm,1)
      m = int(dm)
      call mxCopyPtrToReal8(mxGetPr(prhs(4)),dn,1)
      n = int(dn)
      call mxCopyPtrToReal8(mxGetPr(prhs(9)),dwsize,1)
      wsize = int(dwsize)

      call mxCopyPtrToReal8(mxGetPr(prhs(5)),epsu,1)
      call mxCopyPtrToReal8(mxGetPr(prhs(6)),gap,1)
      call mxCopyPtrToReal8(mxGetPr(prhs(7)),dzero,1)
      zero = (abs(dzero) .gt. 0)

	  plhs(1) = mxcreatefull(2*m*m,1,0)
	  plhs(2) = mxcreatefull(2*n*n,1,0)

	  kstrcols = max(m,n) + 6
	  plhs(3) = mxcreatefull(4,kstrcols,0)

      call mguptri(%val(mxGetPr(prhs(1))), %val(mxGetPr(prhs(2))),
     $   m, n, epsu, gap, zero, %val(mxGetPr(prhs(8))), wsize, 
     $   %val(mxGetPr(plhs(1))), %val(mxGetPr(plhs(2))), 
     $   %val(mxGetPr(plhs(3))), info  )

      dinfo = dble(info)
 	  plhs(4) = mxcreatefull(1,1,0)
	  call mxCopyReal8ToPtr(dinfo,mxGetPr(plhs(4)),1)

      call convertkstr(%val(mxGetPr(plhs(3))),%val(mxGetPr(plhs(3))),
     $                %val(mxGetPr(prhs(8))), kstrcols)

      end 
