C ** Correction report.
C ** Correction 1. 07/10/93: Added line to set M = NCLIN + NCNLN.
C ** Correction 2. 07/10/93: Replaced M with MM = MAX( M, 1 ) in
C    call to CNAMES.
C ** Correction 3. 08/10/93: Finite-difference gradients allowed
C    if required. Nick Gould
C ** Correction 4. 09/10/93: Correction of the declarations. Ph. Toint.
C ** Correction 5. 21/02/94: Replaced sized declarations of arrays
C    with declarations using parameters.
C ** Correction 6. 21/02/94: Added 4 machine-dependent lines for
C    Watcom Fortran installations.  All these lines begin with CWFC.
C ** Correction 7. 31/05/94: Replaced UNIX machine-dependent OPEN
C    statements for OUTSDIF.d with generic UNIX OPEN statements.
C ** Correction 8. 18/01/98: added 1 line to account for group scalings
C ** Correction 9. 18/01/98: modified 1 line to account for group scalings
C ** Correction 10. 18/01/98: modified 1 line to account for group scalings
C ** Correction 11. 18/01/98: added 1 line to account for group scalings
C ** Correction 12. 18/01/98: added 1 line to account for group scalings
C ** Correction 13. 04/03/98: Added 3 lines to reorder EQUATN entries.
C ** End of Correction report.
C  THIS VERSION: Wed Mar 04 10:35:00 EST 1998
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*     File npoptma.f
*
*     Driver for running NPOPT Version 5.3.1 on CUTE problems.
*
*     February 1998. Philip E. Gill
*     Derived from npsolma.f written by Peihuang Chen, May 1993.
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C
      PROGRAM          NPPMA
C
C  Set up parameters, variables and arrays required by constrained
C  tools.
C
      INTEGER          NMAX  , MMAX
CTOY  PARAMETER      ( NMAX =  55, MMAX =  51 )
CMED  PARAMETER      ( NMAX = 105, MMAX = 101 )
CBIG  PARAMETER      ( NMAX = 505, MMAX = 501 )
      CHARACTER * 10   PNAME , VNAME( NMAX ), CNAME( MMAX )
CS    REAL             X     ( NMAX  ), BL    ( NMAX   ),
CD    DOUBLE PRECISION X     ( NMAX  ), BL    ( NMAX   ),
     *                 BU    ( NMAX  ), V     ( MMAX   ),
     *                 CL    ( MMAX  ), CU    ( MMAX   )
      LOGICAL          EQUATN( MMAX  ), LINEAR( MMAX   )
CSALF CHARACTER * 64   PRBDAT
CUNIX CHARACTER * 64   PRBDAT
CVMS  CHARACTER * 64   PRBDAT
CWFC  CHARACTER * 64   PRBDAT
      INTEGER          INPUT , IOUT
CSALF PARAMETER      ( INPUT = 55, IOUT = 6 )
CUNIX PARAMETER      ( INPUT = 55, IOUT = 6 )
CVMS  PARAMETER      ( INPUT = 55, IOUT = 6 )
CWFC  PARAMETER      ( INPUT = 55, IOUT = 6 )
C
C  Set up parameters, variables and arrays required by NPOPT.
C
*  =====================================================================
*  Set the declared array dimensions for NPOPT
*
*  LDA    = the declared leading dimension of  A.
*  LDCJ   = the declared leading dimension of  CJAC.
*  LDR    = the declared leading dimension of  R.
*  MAXBND = maximum no. of variables + linear & nonlinear constrnts.
*  LIWORK = the length of the integer work array.
*  LWORK  = the length of the double precision work array.
*
*  =====================================================================
      INTEGER          LDA, LDCJ, LDR, LIWORK, LWORK, MAXBND

      PARAMETER      ( LDA = MMAX , LDCJ = MMAX, LDR = NMAX,
     *                 MAXBND = NMAX + MMAX )
C
C  Real/double precision workspace
C
CBIG  PARAMETER       ( LWORK    =  300000 )
CMED  PARAMETER       ( LWORK    =   30000 )
CTOY  PARAMETER       ( LWORK    =    2000 )
C
C  Integer workspace
C
CBIG  PARAMETER       ( LIWORK   =  300000 )
CMED  PARAMETER       ( LIWORK   =   30000 )
CTOY  PARAMETER       ( LIWORK   =    2000 )
C
      INTEGER          N, NCLIN, NCNLN, INFORM, ITER
      INTEGER          IWORK( LIWORK ), ISTATE( MAXBND )
CS    REAL             F
CD    DOUBLE PRECISION F
CS    REAL             G( NMAX ), R( LDR, NMAX )
CD    DOUBLE PRECISION G( NMAX ), R( LDR, NMAX )
CS    REAL             A( LDA, NMAX ), C( MMAX ), CJAC( LDCJ, NMAX )
CD    DOUBLE PRECISION A( LDA, NMAX ), C( MMAX ), CJAC( LDCJ, NMAX )
CS    REAL             BLOWER( MAXBND ), BUPPER( MAXBND ),
CD    DOUBLE PRECISION BLOWER( MAXBND ), BUPPER( MAXBND ),
     *                 CLAMDA( MAXBND )
CS    REAL             WORK( LWORK )
CD    DOUBLE PRECISION WORK( LWORK )
      EXTERNAL         OBJFUN, CONFUN
C
C  Local variable declarations.
C
      LOGICAL          DEBUG
C ** Correction 1. 07/10/93: added M  to integer declarations.
C ** Correction 2. 07/10/93: added MM to integer declarations.
      INTEGER          IOPTNS, IPRINT, I, M, MM
      REAL             TIME, TIMSET, TIMSOL, TIMTOT, DUM, CPUTIM
      EXTERNAL         CPUTIM
C ** Correction 3. 08/10/93: Set up common block to ensure that
C                            finite-difference gradients allowed
      LOGICAL          FDGRAD
      COMMON / FDG   / FDGRAD
C
C     DEBUG = .TRUE.
      DEBUG = .FALSE.
C
C  Build data input file name.
C
CSALF PRBDAT = 'OUTSDIF.DAT'
CUNIX PRBDAT = 'OUTSDIF.d'
CVMS  PRBDAT = 'OUTSDIF.DAT'
CWFC  PRBDAT = 'OUTSDIF.DAT'
C
C  Open the relevant file.
C
CSALF OPEN ( INPUT, FILE = PRBDAT, FORM = 'FORMATTED' )
C ** Correction 7. 31/05/94: Replaced UNIX machine-dependent OPEN
C    statements for OUTSDIF.d with generic UNIX OPEN statements.
CUNIX OPEN ( INPUT, FILE = PRBDAT, FORM = 'FORMATTED',
CUNIX*       STATUS = 'OLD' )
CUNIX REWIND INPUT
C ** End of Correction 7.
CVMS  OPEN ( INPUT, FILE = PRBDAT, FORM = 'FORMATTED' ,
CVMS *       STATUS = 'UNKNOWN', CARRIAGECONTROL = 'LIST' )
CWFC  OPEN ( INPUT, FILE = PRBDAT, FORM = 'FORMATTED' )
C
C  Set up the data structures necessary to hold the problem functions.
C
      TIME = CPUTIM( DUM )
C
C  IPRINT = the unit number for writing the output file.
C
      IPRINT = 15
      ISUMM  = 6
C
C     ------------------------------------------------------------------
C     First,  npInit MUST be called to initialize optional parameters 
C     to their default values.
C     ------------------------------------------------------------------
      CALL NPINIT( IPRINT, ISUMM, IWORK, LIWORK, WORK, LWORK )
C
C     IOPTNS = the unit number for reading the options file.
C     Open and then read the options file.
C
      IOPTNS = 4
      OPEN ( UNIT=IOPTNS, FILE='NPOPT.SPC', STATUS='UNKNOWN' )
      CALL NPSPEC( IOPTNS, INFORM, IWORK, LIWORK, WORK, LWORK )
C
      LVLDER = IWORK( 71)
      IF (LVLDER .LT. 0) LVLDER = 3
C ** Correction 3. 08/10/93: Ensure that finite-difference
C    gradients are used if requested
      FDGRAD = LVLDER .EQ. 0
      IF ( INFORM .NE. 0 .AND. IOUT .GT. 0 ) THEN
         WRITE ( IOUT, 3000 ) INFORM
         IF ( INFORM .EQ. 1 ) THEN
            WRITE ( IOUT, 3001 )
         ELSE IF ( INFORM .EQ. 2 ) THEN
            WRITE ( IOUT, 3002 )
         ELSE IF ( INFORM .EQ. 3 ) THEN
            WRITE ( IOUT, 3003 )
         ELSE IF ( INFORM .EQ. 4 ) THEN
            WRITE ( IOUT, 3004 )
         END IF
         STOP
      END IF
C
      CALL NPSSE ( INPUT , IOUT  , NMAX  , MMAX  , MAXBND,
     *             N     , NCLIN , NCNLN , X     , BL    , BU    ,
     *             EQUATN, LINEAR, V     , CL    , CU    ,
     *             BLOWER, BUPPER, CLAMDA, LDA   , A     ,
     *             LDCJ  , CJAC )
C
C  Get the problem name and write some debug messages.
C
C ** Correction 1. 07/10/93: added line to set M = NCLIN + NCNLN.
      M = NCLIN + NCNLN
C ** Correction 2. 07/10/93: replaced M with MM = MAX( M, 1 ) in
C    call to CNAMES.
C    This fix avoids zero-length array difficulties on the VAX.
      MM = MAX( M, 1 )
      CALL CNAMES(N, MM, PNAME, VNAME, CNAME)
      WRITE ( IOUT, 2080 )  PNAME, N, NCLIN, NCNLN
      IF ( DEBUG ) THEN
         WRITE( IOUT, 2030 ) ( I, X( I ), BLOWER( I ),
     *     BUPPER( I ), I = 1, N )
         IF ( NCLIN .GT. 0 ) WRITE( IOUT, 2060 ) ( I, CLAMDA( N + I ),
     *     BLOWER( N + I ), BUPPER( N + I ), EQUATN( NCNLN + I ),
     *     I = 1, NCLIN )
         IF ( NCNLN .GT. 0 ) WRITE( IOUT, 2070 ) ( I, CLAMDA( N + NCLIN
     *     + I ), BLOWER( N + NCLIN + I ), BUPPER( N + NCLIN + I ),
     *     EQUATN( I ), I = 1, NCNLN )
      END IF
C
C  Solve the problem.
C
      TIMSET = CPUTIM( DUM ) - TIME
      TIME   = CPUTIM( DUM )
      CALL NPOPT ( N, NCLIN, NCNLN, LDA, LDCJ, LDR,
     *             A, BLOWER, BUPPER,
     *             CONFUN, OBJFUN,
     *             INFORM, ITER, ISTATE,
     *             C, CJAC, CLAMDA, F, G, R, X,
     *             IWORK, LIWORK, WORK, LWORK )
      TIMSOL = CPUTIM( DUM ) - TIME
      TIMTOT = TIMSET + TIMSOL
C
C  Output final objective function value and timing information.
C
      IF ( IPRINT .GT. 0 )
     *  WRITE ( IPRINT, 2020 ) F, TIMSET, TIMSOL, TIMTOT
      IF ( IOUT   .GT. 0 )
     *  WRITE ( IOUT  , 2020 ) F, TIMSET, TIMSOL, TIMTOT
C
      STOP
C
C  Non-executable statements.
C
 2020 FORMAT( /, ' Final objective function value ', 1P, D22.14,
     *        /, ' Set up time = ', 0P, F12.2,
     *        /, '  Solve time = ', 0P, F12.2,
     *        /, '  Total time = ', 0P, F12.2, ' seconds' )
 2030 FORMAT( /, ' The starting point:',
     *        /, '     I      X        BLOWER      BUPPER',
     *        /, ( I6, 1P, 3D12.4 ) )
 2060 FORMAT( /, ' The linear constraints:',
     *        /, '     I  MULTIPLIER   BLOWER      BUPPER    EQUALITY?',
     *        /, ( I6, 1P, 3D12.4, 5X, L1 ) )
 2070 FORMAT( /, ' The nonlinear constraints:',
     *        /, '     I  MULTIPLIER   BLOWER      BUPPER    EQUALITY?',
     *        /, ( I6, 1P, 3D12.4, 5X, L1 ) )
 2080 FORMAT( /, ' Run NPOPT on Problem ', A10,
     *        /, ' N = ', I5, ' NCLIN = ', I5, ' NCNLN = ', I5 )
 3000 FORMAT( /, ' NPFILE terminated with  INFORM =', I3 )
 3001 FORMAT(    ' IOPTNS .LT. 0 or IOPTNS .GT. 99 ' )
 3002 FORMAT(    ' BEGIN was found, but end-of-file occurred before',
     *           ' END was found.' )
 3003 FORMAT(    ' End-of-file occurred before BEGIN or ENDRUN were',
     *           ' found.' )
 3004 FORMAT(    ' ENDRUN was found before BEGIN.' )
*     end of driver for NPOPT
      END
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      SUBROUTINE NPSSE ( INPUT , IOUT  , NMAX  , MMAX  , MAXBND,
     *                   N     , NCLIN , NCNLN , X     , BL    , BU    ,
     *                   EQUATN, LINEAR, V     , CL    , CU    ,
     *                   BLOWER, BUPPER, CLAMDA, LDA   , AA    ,
     *                   LDCJ  , CJAC )
      INTEGER            INPUT , IOUT  , NMAX  , MMAX  , MAXBND,
     *                   N     , NCLIN , NCNLN , LDA   , LDCJ
CS    REAL               X ( NMAX   ), BL( NMAX   ), BU( NMAX   )
CD    DOUBLE PRECISION   X ( NMAX   ), BL( NMAX   ), BU( NMAX   )
CS    REAL               V ( MMAX   ), CL( MMAX   ), CU( MMAX   )
CD    DOUBLE PRECISION   V ( MMAX   ), CL( MMAX   ), CU( MMAX   )
CS    REAL               BLOWER( MAXBND ), BUPPER( MAXBND ),
CD    DOUBLE PRECISION   BLOWER( MAXBND ), BUPPER( MAXBND ),
     *                   CLAMDA( MAXBND )
CS    REAL               AA( LDA , NMAX ), CJAC( LDCJ, NMAX )
CD    DOUBLE PRECISION   AA( LDA , NMAX ), CJAC( LDCJ, NMAX )
      LOGICAL            EQUATN( MMAX   ), LINEAR( MMAX   )
C
C  Set up the input data for NPOPT.
C
      INTEGER            LIWK  , LWK   , LFUVAL, LLOGIC, LCHARA
C
C  ---------------------------------------------------------------------
C
C  Parameters whose value might be changed by the user:
C
C  The following parameters define the sizes of problem
C  dependent arrays. These may be changed by the user to
C  suit a particular problem or system configuration.
C
C  The TOOLS will issue error messages if any of these sizes
C  is too small, telling which parameter to increase.
C
C  ---------------------------------------------------------------------
C
C  Integer workspace
C
CBIG  PARAMETER       ( LIWK   =  3000000 )
CMED  PARAMETER       ( LIWK   =  300000  )
CTOY  PARAMETER       ( LIWK   =  10000   )
C ** Correction 5a. 21/02/94: Replaced sized declarations of IWK with
C                             one declaration using parameter LIWK.
      INTEGER                IWK( LIWK    )
C ** End of Correction 5a.
C
C  Real/double precision workspace
C
CBIG  PARAMETER       ( LWK    =  3000000 )
CMED  PARAMETER       ( LWK    =  300000  )
CTOY  PARAMETER       ( LWK    =  10000   )
C ** Correction 5b. 21/02/94: Replaced sized declarations of WK with
C                             declaration using parameter LWK.
CS    REAL                   WK ( LWK     )
CD    DOUBLE PRECISION       WK ( LWK     )
C ** End of Correction 5b.
C
C  Logical workspace
C
CBIG  PARAMETER       ( LLOGIC =  350000  )
CMED  PARAMETER       ( LLOGIC =  15000   )
CTOY  PARAMETER       ( LLOGIC =  1500    )
C ** Correction 5c. 21/02/94: Replaced sized declarations of LOGI with
C                             one declaration using parameter LLOGIC.
      LOGICAL              LOGI ( LLOGIC  )
C ** End of Correction 5c.
C
C  Character workspace
C
CBIG  PARAMETER       ( LCHARA =  300000  )
CMED  PARAMETER       ( LCHARA =  30000   )
CTOY  PARAMETER       ( LCHARA =  3000    )
C ** Correction 5d. 21/02/94: Replaced sized declarations of CHA with
C                             one declaration using parameter LCHARA.
      CHARACTER * 10       CHA  ( LCHARA  )
C ** End of Correction 5d.
C
C  Workspace to store the problem's function and derivatives values
C
CBIG  PARAMETER       ( LFUVAL =  960000  )
CMED  PARAMETER       ( LFUVAL =  50000   )
CTOY  PARAMETER       ( LFUVAL =  5000    )
C ** Correction 5e. 21/02/94: Replaced sized declarations of FUVALS with
C                             declaration using parameter LFUVAL.
CS    REAL              FUVALS  ( LFUVAL  )
CD    DOUBLE PRECISION  FUVALS  ( LFUVAL  )
C ** End of Correction 5e.
C
C  ---------------------------------------------------------------------
C
C  End of parameters which might be changed by the user.
C
C  ---------------------------------------------------------------------
C
C  integer variables from the GLOBAL common block.
C
      INTEGER            NG    , NELNUM, NGEL  , NVARS , NNZA  , NGPVLU
      INTEGER            NEPVLU, NG1   , NEL1  , ISTADG, ISTGP , ISTADA
      INTEGER            ISTAEV, ISTEP , ITYPEG, KNDOFC, ITYPEE
      INTEGER            IELING, IELVAR, ICNA  , ISTADH, INTVAR, IVAR
      INTEGER            ICALCF, IWRK  , A     , B
      INTEGER            U     , GPVALU, EPVALU
      INTEGER            ESCALE, GSCALE, VSCALE, GVALS , XT    , DGRAD
      INTEGER            Q     , WRK   , INTREP, GXEQX , GNAMES, VNAMES
      INTEGER            LO    , CH    , LIWORK, LWORK , NGNG  , FT
      INTEGER            LA, LB, NOBJGR, LU, LELVAR
      INTEGER            LSTAEV, LSTADH, LNTVAR, LCALCF
      INTEGER            LELING, LINTRE, LFT, LGXEQX, LSTADG, LGVALS
      INTEGER            LICNA , LSTADA, LKNDOF
      INTEGER            LGSCAL, LESCAL, LVSCAL, LCALCG
C
C  integer variables from the LOCAL common block.
C
      INTEGER            LFXI  , LGXI  , LHXI  , LGGFX , LDX   , LGRJAC
      INTEGER            LQGRAD, LBREAK, LP    , LXCP  , LX0   , LGX0
      INTEGER            LDELTX, LBND  , LWKSTR, LSPTRS, LSELTS, LINDEX
      INTEGER            LSWKSP, LSTAGV, LSTAJC, LIUSED, LFREEC
      INTEGER            LNNONZ, LNONZ2, LSYMMD, LSYMMH
      INTEGER            LSLGRP, LSVGRP, LGCOLJ, LVALJR, LSEND
      INTEGER            LNPTRS, LNELTS, LNNDEX, LNWKSP, LNSTGV
      INTEGER            LNSTJC, LNIUSE, LNFREC, LNNNON, LNNNO2, LNSYMD
      INTEGER            LNSYMH, LNLGRP, LNVGRP, LNGCLJ, LNVLJR, LNQGRD
      INTEGER            LNBRAK, LNP   , LNBND , LNFXI , LNGXI , LNGUVL
      INTEGER            LNHXI , LNHUVL, LNGGFX, LNDX  , LNGRJC, LIWK2
      INTEGER            LWK2  , MAXSIN, NINVAR, MAXSEL
      INTEGER            NTYPE , NSETS , LSTYPE, LSSWTR, LSSIWT, LSIWTR
      INTEGER            LSWTRA, LNTYPE, LNSWTR, LNSIWT, LNIWTR
      INTEGER            LNWTRA, LSISET, LSSVSE, LNISET, LNSVSE
      LOGICAL            ALTRIV, FIRSTG
      COMMON / GLOBAL /  IWK   , WK    , FUVALS, LOGI,
     *                   NG    , NELNUM, NGEL  , NVARS , NNZA  , NGPVLU,
     *                   NEPVLU, NG1   , NEL1  , ISTADG, ISTGP , ISTADA,
     *                   ISTAEV, ISTEP , ITYPEG, KNDOFC, ITYPEE,
     *                   IELING, IELVAR, ICNA  , ISTADH, INTVAR, IVAR  ,
     *                   ICALCF, IWRK  , A     , B     ,
     *                   U     , GPVALU, EPVALU,
     *                   ESCALE, GSCALE, VSCALE, GVALS , XT    , DGRAD ,
     *                   Q     , WRK   , INTREP, GXEQX , GNAMES, VNAMES,
     *                   LO    , CH    , LIWORK, LWORK , NGNG  , FT    ,
     *                   ALTRIV, FIRSTG,
     *                   LA, LB, NOBJGR, LU, LELVAR,
     *                   LSTAEV, LSTADH, LNTVAR, LCALCF,
     *                   LELING, LINTRE, LFT, LGXEQX, LSTADG, LGVALS,
     *                   LICNA , LSTADA, LKNDOF,
     *                   LGSCAL, LESCAL, LVSCAL, LCALCG
      COMMON / CHARA /   CHA
      COMMON / LOCAL /   LFXI  , LGXI  , LHXI  , LGGFX , LDX   , LGRJAC,
     *                   LQGRAD, LBREAK, LP    , LXCP  , LX0   , LGX0  ,
     *                   LDELTX, LBND  , LWKSTR, LSPTRS, LSELTS, LINDEX,
     *                   LSWKSP, LSTAGV, LSTAJC, LIUSED, LFREEC,
     *                   LNNONZ, LNONZ2, LSYMMD, LSYMMH,
     *                   LSLGRP, LSVGRP, LGCOLJ, LVALJR, LSEND ,
     *                   LNPTRS, LNELTS, LNNDEX, LNWKSP, LNSTGV,
     *                   LNSTJC, LNIUSE, LNFREC, LNNNON, LNNNO2, LNSYMD,
     *                   LNSYMH, LNLGRP, LNVGRP, LNGCLJ, LNVLJR, LNQGRD,
     *                   LNBRAK, LNP   , LNBND , LNFXI , LNGXI , LNGUVL,
     *                   LNHXI , LNHUVL, LNGGFX, LNDX  , LNGRJC, LIWK2 ,
     *                   LWK2  , MAXSIN, NINVAR, MAXSEL, NTYPE ,
     *                   NSETS , LSTYPE, LSSWTR, LSSIWT, LSIWTR,
     *                   LSWTRA, LNTYPE, LNSWTR, LNSIWT, LNIWTR,
     *                   LNWTRA, LSISET, LSSVSE, LNISET, LNSVSE
      INTEGER            NNOV  , NNJV
      COMMON / NNVARS /  NNOV  , NNJV
      SAVE             / GLOBAL /, / LOCAL /, / CHARA /, / NNVARS /
C
C  Local variable declarations.
C
      INTEGER            I , IB, IC, II, IG, J , JG, M , MEND
      LOGICAL            EFIRST, LFIRST, NVFRST, LTEMP
CS    REAL               ATEMP
CD    DOUBLE PRECISION   ATEMP
CS    REAL               ZERO
CD    DOUBLE PRECISION   ZERO
CS    PARAMETER        ( ZERO = 0.0E+0 )
CD    PARAMETER        ( ZERO = 0.0D+0 )
C
C  Input problem data using CSETUP.
C
      EFIRST = .FALSE.
      LFIRST = .FALSE.
      NVFRST = .FALSE.
      CALL CSETUP ( INPUT , IOUT  , N , M , X , BL , BU , NMAX,
     *              EQUATN, LINEAR, V , CL , CU , MMAX,
     *              EFIRST, LFIRST, NVFRST )
      CLOSE( INPUT )
C
C  Determine the number of linear and nonlinear constraints.
C
      NCLIN = 0
      NCNLN = 0
      DO 100 IG = 1, NG
         I = IWK( KNDOFC + IG )
         IF ( I .GT. 0 ) THEN
            IWK( LSEND + I ) = IG
            IF ( LINEAR( I ) ) THEN
               NCLIN = NCLIN + 1
            ELSE
               NCNLN = NCNLN + 1
            END IF
         END IF
  100 CONTINUE
      IF ( NCLIN .EQ. 0 .OR. NCNLN .EQ. 0 ) GO TO 130
C
C  Reorder the constraints so that the nonlinear constraints occur before
C  the linear ones.  The constraints are ordered in this way so that CCFG
C  need evaluate the Jacobian for only the first NCNLN constraints.
C
      MEND = M
C
C  Run forward through the constraints until a linear constraint
C  is encountered.
C
      DO 120 I = 1, M
         IF ( I .GT. MEND ) GO TO 130
         IG = IWK( LSEND + I )
         IF ( LINEAR( I ) ) THEN
C
C  Constraint I is linear. Now, run backwards through the
C  constraints until a nonlinear one is encountered.
C
            DO 110 J = MEND, I, - 1
               JG    = IWK( LSEND + J )
               IF ( .NOT. LINEAR( J ) ) THEN
                  MEND = J - 1
C
C  Interchange the data for constraints I and J.
C
                  IWK ( LSEND  +  I ) = JG
                  IWK ( LSEND  +  J ) = IG
                  IWK ( KNDOFC + IG ) = J
                  IWK ( KNDOFC + JG ) = I
                  LTEMP               = LINEAR( I )
                  LINEAR( I )         = LINEAR( J )
                  LINEAR( J )         = LTEMP
C ** Correction 13. 04/03/98: Added 3 lines to reorder EQUATN entries.
                  LTEMP               = EQUATN( I )
                  EQUATN( I )         = EQUATN( J )
                  EQUATN( J )         = LTEMP
C ** End of Correction 13.
                  ATEMP               = V     ( I )
                  V     ( I )         = V     ( J )
                  V     ( J )         = ATEMP
                  ATEMP               = CL    ( I )
                  CL    ( I )         = CL    ( J )
                  CL    ( J )         = ATEMP
                  ATEMP               = CU    ( I )
                  CU    ( I )         = CU    ( J )
                  CU    ( J )         = ATEMP
                  ATEMP               = BL    ( N + I )
                  BL    ( N + I )     = BL    ( N + J )
                  BL    ( N + J )     = ATEMP
                  ATEMP               = BU    ( N + I )
                  BU    ( N + I )     = BU    ( N + J )
                  BU    ( N + J )     = ATEMP
                  GO TO 120
               END IF
  110       CONTINUE
            GO TO 130
         END IF
  120 CONTINUE
  130 CONTINUE
C
C  Set up the lower bound vector BLOWER and upper bound vector BUPPER
C  in the order required by NPOPT.
C  For i=1 to n, set BLOWER (BUPPER) to the lower (upper) bound
C  on the variables.  (CSETUP put these bounds in BL and BU.)
C  For i=n+1 to n+nclin, set BLOWER (BUPPER) to the lower (upper)
C  bounds on the linear constraints.
C  For i=n+nclin+1 to n+nclin+ncnln, set BLOWER (BUPPER) to the lower
C  (upper) bounds on the nonlinear constraints.
C  At the same time, copy the multiplier estimates from V to CLAMDA.
C  CLAMDA has the same ordering as BLOWER and BUPPER.
C
      DO 150 I = 1, N
         BLOWER( I ) = BL( I )
         BUPPER( I ) = BU( I )
         CLAMDA( I ) = ZERO
  150 CONTINUE
      DO 160 I = 1, NCLIN
         IB = N + I
         IC = NCNLN + I
         BLOWER( IB ) = CL( IC )
         BUPPER( IB ) = CU( IC )
         CLAMDA( IB ) = V ( IC )
  160 CONTINUE
      DO 170 I = 1, NCNLN
         IB = N + NCLIN + I
         IC = I
         BLOWER( IB ) = CL( IC )
         BUPPER( IB ) = CU( IC )
         CLAMDA( IB ) = V ( IC )
  170 CONTINUE
C
C  Initialize AA and CJAC to zero.
C
      DO 230 J = 1, N
         DO 210 I = 1, NCLIN
            AA( I, J ) = ZERO
  210    CONTINUE
         DO 220 I = 1, NCNLN
            CJAC( I, J ) = ZERO
  220    CONTINUE
  230 CONTINUE
C
C  Set up the matrix AA, which contains the coefficients of the linear
C  constraints.  Also incorporate nonzero RHS constants of linear
C  constraints into the lower and upper bounds.
C
      DO 250 I = 1, NCLIN
         II = NCNLN + I
         IG = IWK( LSEND + II )
         DO 240 IC = IWK( ISTADA + IG ), IWK( ISTADA + IG + 1 ) - 1
            J = IWK( ICNA + IC )
C ** Correction 9. 18/01/98: modified 1 line to account for group scalings
            AA( I, J ) = WK( A + IC ) * WK( GSCALE + IG )
  240    CONTINUE
         IF ( WK( B + IG ) .NE. ZERO ) THEN
            IB = N + I
            IC = B + IG
            BLOWER( IB ) = BLOWER( IB ) + WK( IC )
C ** Correction 11. 18/01/98: added 1 line to account for group scalings
     *                           * WK( GSCALE + IG )
            BUPPER( IB ) = BUPPER( IB ) + WK( IC )
C ** Correction 12. 18/01/98: added 1 line to account for group scalings
     *                           * WK( GSCALE + IG )
            WK    ( IC ) = ZERO
         END IF
  250 CONTINUE
C
C  Incorporate nonzero RHS constants of nonlinear constraints into
C  the lower and upper bounds.
C
      DO 260 I = 1, NCNLN
         IG = IWK( LSEND + I )
         IF ( WK( B + IG ) .NE. ZERO ) THEN
            IB = N + NCLIN + I
            IC = B + IG
            BLOWER( IB ) = BLOWER( IB ) + WK( IC )
C ** Correction 10. 18/01/98: added 1 line to account for group scalings
     *                           * WK( GSCALE + IG  )
            BUPPER( IB ) = BUPPER( IB ) + WK( IC )
C ** Correction 8. 18/01/98: added 1 line to account for group scalings
     *                           * WK( GSCALE + IG  )
            WK    ( IC ) = ZERO
         END IF
  260 CONTINUE
C
      RETURN
      END
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  THIS VERSION: 03/06/1994 AT 11:38:26 AM.
      SUBROUTINE OBJFUN( MODE, N, X, F, G, NSTATE )
      INTEGER           MODE, N, NSTATE
CS    REAL              F
CD    DOUBLE PRECISION  F
CS    REAL              X( N ), G( N )
CD    DOUBLE PRECISION  X( N ), G( N )
C
C  Local variables
C
      INTEGER           J
C ** Correction 3. 08/10/93: Allow finite-difference gradients.
      LOGICAL           GRAD, FDGRAD
      COMMON / FDG /    FDGRAD
C
      IF ( MODE .EQ. 0 ) THEN
         GRAD = .FALSE.
      ELSE
         GRAD = .TRUE.
      END IF
      CALL COFG ( N, X, F, G, GRAD )
C ** Correction 3. 08/10/93: Ensure that finite-difference
C    gradients are used if requested by setting the gradient to
C    appropriate NPOPT values.
      IF ( GRAD .AND. FDGRAD ) THEN
         DO 20 J = 1, N
            G( J ) = -11111.0D+0
   20    CONTINUE
      END IF
      RETURN
C     END OF OBJFUN
      END
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
C  THIS VERSION: 03/06/1994 AT 11:38:26 AM.
      SUBROUTINE CONFUN( MODE, NCNLN, N, LDCJ,
     *                   NEEDC, X, C, CJAC, NSTATE )
      INTEGER            MODE, NCNLN, N, LDCJ, NSTATE
      INTEGER            NEEDC(*)
CS    REAL               X( N ), C( LDCJ ), CJAC( LDCJ, N )
CD    DOUBLE PRECISION   X( N ), C( LDCJ ), CJAC( LDCJ, N )
C
C  Local variables
C
      INTEGER           I, J
      LOGICAL           GRAD, FDGRAD
C ** Correction 3. 08/10/93: Allow finite-difference gradients.
      COMMON / FDG /    FDGRAD
C
      IF ( MODE .EQ. 0 ) THEN
         GRAD = .FALSE.
      ELSE
         GRAD = .TRUE.
      END IF
      CALL CCFG ( N, NCNLN, X, LDCJ, C, .FALSE., LDCJ, N, CJAC, GRAD )
C ** Correction 3. 08/10/93: Ensure that finite-difference
C    gradients are used if requested by setting the Jacobian to
C    appropriate NPOPT values.
      IF ( GRAD .AND. FDGRAD ) THEN
         DO 20 J = 1, N
            DO 10 I = 1, NCNLN
               CJAC( I, J ) = -11111.0D+0
   10       CONTINUE
   20    CONTINUE
      END IF
      RETURN
C     END OF CONFUN
      END

