************************************************************************
*                                                                      *
*     File  sn01main.f                                                 *
*                                                                      *
*     Generic main program for stand-alone SQOPT.                      *
*                                                                      *
************************************************************************
*                                                                      *
*                               S Q O P T                              *
*                                                                      *
*    Sparse Quadratic Optimization                                     * 
*                                                                      *
*                      Version 5.4-1                  Nov 30, 2000     *
*                                                                      *
*    Philip E. Gill    Walter  Murray          Michael A. Saunders     *
*    UC San Diego      Stanford University     Stanford University     *
*                                                                      *
*                                                                      *
*    (C) 1992--2000  Regents of the University of California           *
*                    and the Trustees of Stanford University           *
*                                                                      *
*     This software is NOT in the public domain. Its use is governed   *
*     by a license agreement with either the University of California  *
*     or Stanford University.  It is a breach of copyright to make     *
*     copies except as authorized by the license agreement.            *
*                                                                      *
*     This material is based upon work partially supported by the      *
*     National Science Foundation under Grants DMI-9204208 and         *
*     DMI-9204547; and the Office of Naval Research Grant              *
*     N00014-90-J-1242.                                                *
************************************************************************
*
*  SQOPT Fortran source files:
*
*  1. sn01main   Main program
*  2. sq02lib    SQOPT routines and auxiliaries
*  3. sn02lib    SNOPT routines and auxiliaries
*  4. sn10mach   Machine-dependent routines
*  5. sn15blas   Level-1 Basic Linear Algebra Subprograms (a subset)
*  6. sn17util   linear algebra subprograms
*  7. sn20amat   Core allocation and manipulation of the ( A -I )
*  8. sn25bfac   Basis factorization routines
*  9. sn27LU     LU factorization routines
* 10. sn30spec   SPECS file routines
* 11. sn35mps    MPS file routines
* 12. sn40bfil   Basis file and solution output routines
* 13. sn50lp     Routines for the primal simplex method
* 14. sn55qp     Routines for quadratic programming
* 15. sn57qopt   QP and Memory allocation routines called by SQOPT 
* 16. sn65rmod   For maintaining R, the approximate reduced Hessian
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      program            sqmps

*     ------------------------------------------------------------------
*     This is the default main program for SQOPT
*     It provides all of the necessary workspace.
*     ------------------------------------------------------------------
      integer            lencw,          leniw,          lenrw
      parameter         (lencw = 150000, leniw = 400000, lenrw = 600000)
      character*8        cw(lencw)
      integer            iw(leniw)
      double precision   rw(lenrw)

      call sqmps1( cw, lencw, iw, leniw, rw, lenrw )

      end ! of main program for stand-alone SQOPT.

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqmps1( cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     lencw, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     sqmps1 is used for the stand-alone version of the optimizer.
*     It is called by the main program (or equivalent driver).
*     It repeatedly looks for a new problem in the SPECS file
*     and asks for it to be solved, until s3file returns inform gt 1,
*     which means an ENDRUN card was found in the SPECS file,
*     or end-of-file was encountered.
*
*     15 Nov 1991: First version based on Minos 5.4 routine minos1.
*     11 Nov 2000: Current version.
*     ==================================================================
      character*30
     &     title
      integer
     &     calls, iError, inform, iObj, iPrint, iSpecs, iSumm, lAcol, 
     &     lbl, lbu, lenH, lenR, lenrhs, lenx0, lGobj, lHelas, lhs,
     &     lindA, llocA, lNames, loop, lpi, lrc, lvlSrt, lvlTim, lx,
     &     maxn, mincw, miniw, minrw, n, ne, nnCon, nnJac, nnH, nnL,
     &     nnObj, nb, neH, nGobj, nGobj0, ngQP, nInf, nlocA, nName,
     &     nnH0, nrhs, nS, nx0, m, maxm, maxR, maxS, maxne, maxru,
     &     maxiu, maxcu, maxrw, maxiw, maxcw, plInfy, Start, iHvar(1),
     &     jHvar(1)
      double precision
     &     H(1), ObjAdd, ObjQP, ObjTru, rhs(1), sInf, x0(1)
      external
     &     s3opt, qpHx, sqHx, sqprnt
*     ------------------------------------------------------------------
      integer            PrintO
      parameter         (PrintO = 1 ) 
      integer            DefltF,     OpenF
      parameter         (DefltF = 0, OpenF  = 1)

      parameter         (plInfy    =  70) ! definition of plus infinity.
      parameter         (maxru     =   2) ! maxru+1  starts SNOPT  rw
      parameter         (maxiu     =   4) ! maxiu+1  starts SNOPT  iw
      parameter         (maxcu     =   6) ! maxcu+1  starts SNOPT  cw

      parameter         (maxrw     =   3) ! end of SNOPT part of rw
      parameter         (maxiw     =   5) ! end of SNOPT part of iw
      parameter         (maxcw     =   7) ! end of SNOPT part of cw
      parameter         (iSpecs    =  11) ! Specs (options) file
      parameter         (iPrint    =  12) ! Print file
      parameter         (iSumm     =  13) ! Summary file
      parameter         (nnJac     =  21) ! # nonlinear Jacobian vars
      parameter         (nnObj     =  22) ! # variables in Gobj
      parameter         (nnCon     =  23) ! # of nonlinear constraints
      parameter         (nnL       =  24) !   max( nnObj, nnJac )
      parameter         (nGobj     =  26) ! length of QP constant vector
      parameter         (nnH       =  27) ! # QP Hessian columns
      parameter         (lvlSrt    =  69) ! = 0(1) => cold(warm) start
      parameter         (lvlTim    =  77) ! Timing level

      parameter         (maxm      = 133) ! Est. number of rows
      parameter         (maxn      = 134) ! Est. number of columns
      parameter         (maxne     = 135) ! Est. number of elements
*     -------------------------------------------------------------------

      if (lencw .lt. 500 .or. leniw .lt. 500 .or. lenrw .lt. 500) then 
*        ---------------------------------------------------------------
*        Not enough workspace to do ANYTHING!
*        ---------------------------------------------------------------
         inform = 41
         write(*, 9000)
         go to 999
      end if

*     ------------------------------------------------------------------
*     Define global files (reader, printer, etc.)
*     ------------------------------------------------------------------
      iw(iSpecs) = 4
      iw(iPrint) = 15
      iw(iSumm ) = 6
      call s1file( DefltF, iw, leniw )

*     ==================================================================
*     Loop through each problem in the SPECS file.
*     ==================================================================
      do 100, loop  = 1, 100000
         calls = loop

         call s3undf( cw, lencw, iw, leniw, rw, lenrw )

*        ---------------------------------------------------------------
*        Initialize some global values.
*        ---------------------------------------------------------------
         rw(plInfy) = 1.0d+20
         iw(lvlTim) = 3
 
         iw(maxru) = 500        ! rw(1:500) contains sqopt variables 
         iw(maxrw) = lenrw
         iw(maxiu) = 500        ! iw(1:500) contains sqopt variables   
         iw(maxiw) = leniw
         iw(maxcu) = 500        ! cw(1:500) contains sqopt variables   
         iw(maxcw) = lencw

*        Initialize timers.
      
         iw(lvlTim) = 1
         call s1time( 0, 0, iw, leniw, rw, lenrw )
      
*        Initialize dimensions that can be set in the specs file.

         iw(nnCon )  =   0
         iw(nnJac )  =   0
         iw(nnObj )  =   0
         iw(nGobj )  =   0
         iw(nnL   )  =   0
         iw(nnH   )  =   0
      
         iw(maxm  )  =   0
         iw(maxn  )  =   0
         iw(maxne )  =   0

*        ---------------------------------------------------------------
*        Define the SQOPT title and read the Specs file.
*        ---------------------------------------------------------------
         call sqtitl( title )
         call s1init( title, iw, leniw, rw, lenrw )
         call s3fils( calls, iw(iSpecs), s3opt,
     &        title, iw(iPrint), iw(iSumm), inform,
     &        cw, lencw, iw, leniw, rw, lenrw )
         if (inform .ge. 2) then
            inform = 100 + inform 
            go to 999
         end if
      
         call s1file( OpenF, iw, leniw  )

*        Set undefined MPS options to their default values.

         call s3dflt( cw, lencw, iw, leniw, rw, lenrw )

*        Define the start of the character, integer and real workspace.

         call s2Mem ( iError, lencw, leniw, lenrw, iw,
     &        mincw, miniw, minrw, iw(maxcw), iw(maxiw), iw(maxrw) )
         if (iError .ne. 0) return

*        ---------------------------------------------------------------
*        Get values of the problem dimensions:
*        following variables:
*           maxm , maxn , maxne
*           lenR , maxS 
*           nGobj
*        Initialize  locA, indA, Acol, 
*                    bl, bu, iObj, and  ObjAdd. 
*        Compute the array pointers accordingly.
*        ---------------------------------------------------------------
         call s1time( 1, 0, iw, leniw, rw, lenrw )
         call s3inpt( iError,
     &        iw(maxm), iw(maxn), iw(maxne),
     &        iw(nnCon), iw(nnJac), iw(nnObj), 
     &        m, n, ne, iObj, ObjAdd,
     &        mincw, miniw, minrw,
     &        cw, lencw, iw, leniw, rw, lenrw )
         call s1time(-1, 0, iw, leniw, rw, lenrw )
         if (iError .ne. 0) return

*        Record n, m, ne and iObj for s5dflt.

         iw( 15)    = n    ! copy of the number of columns
         iw( 16)    = m    ! copy of the number of rows
         iw( 17)    = ne   ! copy of the number of nonzeros in Acol
         iw(204)    = iObj ! position of the objective row in A

*        ---------------------------------------------------------------
*        Check options.
*        Open any files needed for this problem.
*        ---------------------------------------------------------------
         call s5dflt( PrintO, cw, lencw, iw, leniw, rw, lenrw )
         call s1file( OpenF , iw, leniw  )
      
*        ---------------------------------------------------------------
*        Compute the storage requirements for SQOPT  from the following
*        variables:
*           m    ,  n   , ne
*           lenR , maxS ,  maxR 
*           nGobj, nnH
*        All are now known.
*        ---------------------------------------------------------------
         maxR    = iw( 52) ! max columns of R.
         maxS    = iw( 53) ! max # of superbasics

         lenR    = maxR*(maxR + 1)/2
         iw( 28) = lenR         ! R(lenR) is the reduced Hessian factor

         call s5Mem ( iError, iw(iPrint), iw(iSumm),
     &        m, n, ne, iw(nGobj), iw(nnH), lenR, maxS, 
     &        mincw, miniw, minrw, ! In/Out
     &        iw(maxcw), iw(maxiw), iw(maxrw), ! Out
     &        lencw, leniw, lenrw, iw )
         if (iError .gt. 0) go to 100

*        Fetch the addresses of the problem arrays (set in s3inpt).

         lAcol   = iw(256) ! Jcol(ne)    = Constraint Jacobian by columns
         llocA   = iw(257) ! locJ(n+1)   = column pointers for indJ
         lindA   = iw(258) ! indJ(ne) holds the row indices for Jij
         lbl     = iw(271) ! bl(nb)      = lower bounds
         lbu     = iw(272) ! bu(nb)      = upper bounds
         lx      = iw(299) ! x(nb)       = the solution (x,s)
         lpi     = iw(279) ! pi(m)       = the pi-vector
         lhs     = iw(282) ! the column state vector
         lhElas  = iw(283) ! hElast(nb) definition of elastic vars
         lNames  = iw(353) ! Names(nName)

         call iload ( n , 0, iw(lhElas)  , 1 )
         call iload ( m , 3, iw(lhElas+n), 1 )  

         nb      = n   + m
         nlocA   = n   + 1 
         nName   = nb
         lrc     = lpi + m ! ???
         lGobj   = lbl

         nnH0    = max( iw(nnH)  , 1 )
         ngQP    = max( iw(nnH)  , iw(nGObj) )
         nGobj0  = max( iw(nGobj), 1   )

         neH     = 0
         lenH    = max( neH  , 1   )
         nrhs    = 0
         lenrhs  = max( nrhs , 1   )
         nx0     = 0
         lenx0   = max( nx0  , 1   )

         Start   = iw(lvlSrt)

*        ------------------------------------------------------------------
*        Solve the problem.
*        ------------------------------------------------------------------
         call s5solv( Start, sqHx, qpHx, sqprnt,
     &        m, n, nb, nnH0, iw(nnH), nName, ngQP, nGobj0, iw(nGobj),
     &        iObj, ObjAdd, ObjQP, ObjTru, nInf, sInf,
     &        ne, nlocA, iw(llocA), iw(lindA), rw(lAcol),
     &        iHvar, jHvar, lenH, neH, H,
     &        rw(lbl), rw(lbu), rw(lGobj), cw(lNames), 
     &        lenrhs, nrhs, rhs, lenx0, nx0, x0,
     &        iw(lhElas), iw(lhs), rw(lx), rw(lpi), rw(lrc), inform, nS, 
     &        cw, lencw, iw, leniw, rw, lenrw,
     &        cw, lencw, iw, leniw, rw, lenrw )

*        Print times for all clocks (if lvlTim > 0).

         call s1time( 0, 2, iw, leniw, rw, lenrw )

  100 continue
*     ==================================================================
*     End of loop through SPECS file.
*     ==================================================================

  999 return

 9000 format(  ' EXIT -- SQOPT character, integer and real work arrays',
     &         ' must each have at least 500 elements')

      end ! of sqmps1

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine qpHx  ( nnH, x, Hx, Status,
     &     cu, lencu, iu, leniu, ru, lenru )

      implicit
     &     none
      integer
     &     lencu, leniu, lenru, nnH, Status, iu(leniu)
      double precision
     &     Hx(nnH), x(nnH), ru(lenru)
      character*8
     &     cu(lencu)

*     ==================================================================
*     This version of qpHx is a dummy routine used for solving
*     LP's with the stand-alone version of sqopt.
*     It should never be called by SQOPT.
*     
*     Warn the user (via the standard output) that it has been called.
*     ==================================================================
      integer
     &     nOut
*     ------------------------------------------------------------------
      nOut = 6
      if (nOut .gt. 0) write(nOut, 9000)
      return

 9000 format(/ ' XXX dummy qpHx has been called in error.')
     
      end ! of qpHx
