*     ------------------------------------------------------------------
*     File sntoy.f  (Unix version)
*
*     This is a main program to illustrate the use of subroutine SNOPT,
*     which is part of the SNOPT 5.3 package.
*
*     31 Jul 1996: First   version.
*     07 Feb 1998: Current version.
*     ------------------------------------------------------------------
      program            sntoy
      implicit           double precision (a-h,o-z)

      parameter        ( maxm   = 100,
     $                   maxn   = 100,
     $                   maxne  = 300,
     $                   nName  = 1 )

      character*8        Prob
      character*8        Names(nName)
      integer*4          ha(maxne) , hs(maxn+maxm)
      integer            ka(maxn+1)
      double precision   a(maxne)  , bl(maxn+maxm), bu(maxn+maxm),
     $                   x(maxn+maxm), pi(maxm)   , rc(maxn+maxm)

*     SNOPT workspace

      parameter          (  lenrw = 20000)
      double precision   rw(lenrw)
      parameter          (  leniw = 10000) 
      integer            iw(leniw)
      parameter          (  lencw =   500) 
      character*8        cw(lencw)

      external           funcon, funobj

      logical            byname
      character*20       lfile
*     ------------------------------------------------------------------
*     Give a name to the Problem.

      Prob = 'Toy NLP '

*     Specify some of the SNOPT files.
*     iSpecs  is the Specs file   (0 if none).
*     iPrint  is the Print file   (0 if none).
*     iSumm   is the Summary file (0 if none).
*
*     nout    is an output file used here by sntoy.

      iSpecs = 4
      iPrint = 15
      iSumm  = 6

      nout   = 6

      byname = .true.
 
      if ( byname ) then

*        Unix and DOS systems.  Open the Specs and print files.

         lfile = 'sntoy.spc'
         open( iSpecs, file=lfile, status='OLD',     err=800 )

         lfile = 'sntoy.out'
         open( iPrint, file=lfile, status='UNKNOWN', err=800 )
      end if

*     ------------------------------------------------------------------
*     First,  snInit MUST be called to initialize optional parameters 
*     to their default values.
*     ------------------------------------------------------------------
      call snInit( iPrint, iSumm,
     $             cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Read a Specs file (optional). 
*     ------------------------------------------------------------------
      call snSpec( iSpecs, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .ge. 2) then
         write(nout, *) 'iSpecs > 0 but no Specs file found'
         go to 990
      end if

*     ------------------------------------------------------------------
*     Define what we mean by an infinite bound.
*     ------------------------------------------------------------------
      BigBnd  =  1.0d+18
      call snsetr( 'Infinite Bound', BigBnd, iPrint, iSumm, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Set up the problem constraints and bounds.
*     Assign dummy values for the nonlinear Jacobian elements. 
*     ------------------------------------------------------------------
      call ToyDat( Prob, maxm, maxn, maxne, inform,
     $             m, n, ne, nnCon, nnObj, nnJac, iObj,
     $             ObjAdd, BigBnd,
     $             a, ha, ka, bl, bu, hs, x, pi )

*     ------------------------------------------------------------------
*     Specify options that were not set in the Specs file.
*     i1 and i2 may refer to the Print and Summary file respectively.
*     Setting them to 0 suppresses printing.
*     ------------------------------------------------------------------
      itnlim = 250
      i1     =   0
      i2     =   0
      call snseti( 'Iterations        ', itnlim, i1, i2, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Go for it, using a Cold start.
*     hs     need not be set if a basis file is to be input.
*            Otherwise, each hs(1:n) should be 0, 1, 2, 3, 4, or 5.
*            The values are used by the Crash procedure m2crsh
*            to choose an initial basis B.
*            If hs(j) = 0 or 1, column j is eligible for B.
*            If hs(j) = 2, column j is initially superbasic (not in B).
*            If hs(j) = 3, column j is eligible for B and is given
*                          preference over columns with hs(j) = 0 or 1.
*            If hs(j) = 4 or 5, column j is initially nonbasic.
*     ------------------------------------------------------------------
      call snopt ( 'Cold', m, n, ne, nName,
     $             nnCon, nnObj, nnJac,
     $             iObj, ObjAdd, Prob,
     $             funcon, funobj, 
     $             a, ha, ka, bl, bu, Names,
     $             hs, x, pi, rc, 
     $             inform, mincw, miniw, minrw,
     $             nS, nInf, sInf, Obj,
     $             cw, lencw, iw, leniw, rw, lenrw, 
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .eq. 42 .or. inform .eq. 43 .or. inform .eq. 44) then
         write(nout, *) ' '
         write(nout, *) 'Estimate of required lencw:', mincw
         write(nout, *) 'Estimate of required leniw:', miniw
         write(nout, *) 'Estimate of required lenrw:', minrw
         go to 910
      end if

      write(nout, *) ' '
      write(nout, *) 'snopt finished.'
      write(nout, *) 'inform =', inform
      write(nout, *) 'nInf   =', nInf
      write(nout, *) 'sInf   =', sInf
      write(nout, *) 'obj    =', obj
      if (inform .ge. 20) go to 910
      stop

*     ------------------------------------------------------------------
*     Error exit.
*     ------------------------------------------------------------------
  800 write(nout, 4000) 'Error while opening file', lfile
      stop

  910 write(nout, *) ' '
      write(nout, *) 'STOPPING because of error condition'

  990 stop

 4000 format(/  a, 2x, a  )

*     end of main program to test subroutine snopt
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine funcon( mode, nnCon, nnJac, neJac,
     $                   x, fCon, gCon, nState,
     $                   cu, lencu, iu, leniu, ru, lenru )

      integer            mode, nnCon, nnJac, neJac, nState
      double precision   x(nnJac), fCon(nnCon), gCon(nnCon,nnJac)

      integer            lencu, leniu, lenru
      character*8        cu(lencu)
      integer            iu(leniu)
      double precision   ru(lenru)

*     ==================================================================
*     Toy NLP problem from the SNOPT User's Guide.
*     ==================================================================
      integer            nout

      nout   = 15

*     ---------------------------------------
*     First entry.  Print something.
*     ---------------------------------------
      if (nState .eq. 1) then
         if (nout .gt. 0) write(nout, '(/a)') ' This is problem  Toy'
      end if

      if (mode .eq. 0  .or.  mode .eq. 2) then
         fCon( 1)  = x(1)**2 +  x(2)**2
         fCon( 2)  = x(1)**4 +  x(2)**4
      end if

      if (mode .ge. 1) then

*        Jacobian elements for column 1.

         gCon(1,1) = 2.0d+0*x(1)
         gCon(2,1) = 4.0d+0*x(1)**3

*        Jacobian elements for column 2.

         gCon(1,2) = 2.0d+0*x(2)
         gCon(2,2) = 4.0d+0*x(2)**3
      end if

*     ------------
*     Last entry.
*     ------------
      if (nState .ge. 2) then
         if (nout .gt. 0) write(nout, '(/a)') ' Finished problem  Toy'
      end if

*     end of funcon for toy NLP
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine funobj( mode, nnObj,
     $                   x, fObj, gObj, nState,
     $                   cu, lencu, iu, leniu, ru, lenru )

      integer            mode, nnObj, nState
      double precision   fObj
      double precision   x(nnObj), gObj(nnObj)

      integer            lencu, leniu, lenru
      character*8        cu(lencu)
      integer            iu(leniu)
      double precision   ru(lenru)

*     ==================================================================
*     Toy NLP problem from the SNOPT User's Guide.
*     ==================================================================
      double precision   sum

      sum    = x(1) + x(2) + x(3)

      if (mode .eq. 0  .or.  mode .eq. 2) then
         fObj    = sum*sum
      end if

      if (mode .eq. 1  .or.  mode .eq. 2) then
         sum     = 2.0d+0*sum
         gObj(1) = sum
         gObj(2) = sum
         gObj(3) = sum
      end if

*     end of funobj for toy NLP.
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine ToyDat( Prob, maxm, maxn, maxne, inform,
     $                   m, n, ne, nnCon, nnObj, nnJac, iObj,
     $                   ObjAdd, BigBnd,
     $                   a, ha, ka, bl, bu, hs, x, pi )

      character*8        Prob
      integer            maxm, maxn, maxne, inform
      integer            m, n, ne, nnCon, nnObj, nnJac, iObj

      integer            ha(maxne)   , hs(maxn+maxm)
      integer            ka(maxn+1)
      double precision   ObjAdd, BigBnd
      double precision   a(maxne)    , bl(maxn+maxm), bu(maxn+maxm),
     $                   x(maxn+maxm), pi(maxm)

*     ------------------------------------------------------------------
*     ToyDat generates data for the Toyagon problem.
*     The constraints take the form
*              c(x) + A*x - s = 0,
*     where the Jacobian for c(x) + Ax is stored in a(*), and any
*     terms coming from c(x) are in the TOP LEFT-HAND CORNER of a(*),
*     with dimensions  nnCon x nnJac.
*     Note that the right-hand side is zero.
*     s is a set of slack variables whose bounds contain any constants
*     that might have formed a right-hand side.
*
*     The objective function is
*             f(x) + d'x
*     where d would be row iobj of A (but there is no such row in
*     this example).  f(x) involves only the FIRST nnObj variables.
*   
*     On entry,
*     maxm, maxn, maxne are upper limits on m, n, ne.
*
*     On exit,
*     inform  is 0 if there is enough storage, 1 otherwise.
*     m       is the number of nonlinear and linear constraints.
*     n       is the number of variables.
*     ne      is the number of nonzeros in a(*).
*     nnCon   is the number of nonlinear constraints (they come first).
*     nnObj   is the number of nonlinear objective variables.
*     nnJac   is the number of nonlinear Jacobian variables.
*     a       is the constraint matrix (Jacobian), stored column-wise.
*     ha      is the list of row indices for each nonzero in a(*).
*     ka      is a set of pointers to the beginning of each column of a.
*     bl      is the lower bounds on x and s.
*     bu      is the upper bounds on x and s.
*     hs(1:n) is a set of initial states for each x  (0,1,2,3,4,5).
*     x (1:n) is a set of initial values for x.
*     pi(1:m) is a set of initial values for the dual variables pi.
*
*     24 Dec 1997: First version of ToyDat.
*     ------------------------------------------------------------------

*     Give a name to the Problem.

      Prob   = ' Toy NLP'

      ne     = 10
      n      =  4
      m      =  4

      nnCon  =  2
      nnJac  =  2
      nnObj  =  3

*     Check if there is enough storage.

      inform = 0
      if (m      .gt. maxm ) inform = 1
      if (n      .gt. maxn ) inform = 1
      if (ne     .gt. maxne) inform = 1
      if (inform .gt.   0  ) return

*     -------------------------------------
*     Set up the list of row indices in ha.
*     -------------------------------------
*     Column  1
*     Nonlinear elements in rows (1, 2)  first.

      ka( 1) =  1

      ha( 1) =  1
      a ( 1) =  0.0d+0

      ha( 2) =  2 
      a ( 2) =  0.0d+0

*     Linear element in row 3 next.

      ha( 3) =  3
      a ( 3) =  2.0d+0

*     Column 2.
*     Nonlinear elements in rows (1, 2).

      ka( 2) =  4

      ha( 4) =  1
      a ( 4) =  0.0d+0

      ha( 5) =  2
      a ( 5) =  0.0d+0

*     Linear element in row 3.

      ha( 6) =  3
      a ( 6) =  4.0d+0

*     Column 3.
*     Linear element in row 1.

      ka( 3) =  7

      ha( 7) =  1
      a ( 7) =  1.0d+0

*     Objective row element in row 4.

      ha( 8) =  4
      a ( 8) =  3.0d+0

*     Column 4.
*     Linear element in row 2

      ka( 4) =  9

      ha( 9) =  2
      a ( 9) =  1.0d+0

*     Objective row element in row 4

      ha(10) =  4
      a (10) =  5.0d+0

*     Don't forget to finish off  ka.
*     This is crucial.

      ka(5) =  ne + 1

*     ------------------------------------------------------------------
*     Constraint ranges
*     ------------------------------------------------------------------
*     Nonlinear constraints first.

      bl(n+1) =  2.0d+0
      bu(n+1) =  2.0d+0

      bl(n+2) =  4.0d+0
      bu(n+2) =  4.0d+0

*     Followed by the linear constraints.

      bl(n+3) =  0.0d+0
      bu(n+3) =  BigBnd

*     The linear objective term is row 4.

      iObj    = 4

*     The objective row is a free row.

      bl(n+4) = -BigBnd
      bu(n+4) =  BigBnd

      ObjAdd  = 0.0d+0

*     ------------------------------------------------------------------
*     Variable ranges
*     ------------------------------------------------------------------
      do 100, j = 1, n
         bl(j) = -BigBnd
         bu(j) =  BigBnd
  100 continue

      bl(3) =  0.0d+0
      bl(4) =  0.0d+0

*     ------------------------------------------------------------------
*     Initialize x, hs and pi.
*     Set the initial value and status of each variable.
*     For want of something better to do, make the variables x(1:n)
*     temporarily fixed at their current values. 
*     The crash can set the rest.
*     ------------------------------------------------------------------
      do 200, j = 1, n
         x(j)   = 1.0d+0
  200 continue

      do 300, j = 1, n
         hs(j)  = 0
  300 continue

      do 400, i = 1, m
         pi(i)  = 0.0d+0
  400 continue

*     end of ToyDat
      end
