*     ------------------------------------------------------------------
*     File sqmainMPS.f (Unix version)
*     SQOPT solves a QP with constraints input from an MPS file.
*     The problem is HS 118.
*
*     04 Oct 1994: First   version.
*     16 Aug 1998: Current version.
*     ------------------------------------------------------------------
      program            main
      implicit           double precision (a-h,o-z)

      parameter        ( maxm   = 1000,
     $                   maxn   = 1500,
     $                   maxne  = 3000 )

      character*8        PrbNms(5)
      character*8        Names(maxm+maxn)
      integer*4          ha(maxne) , hElast(maxn+maxm), hs(maxn+maxm)
      integer            ka(maxn+1)
      double precision   a(maxne)  , bl(maxn+maxm)    , bu(maxn+maxm) , 
     $                   c(maxn)   , xs(maxn+maxm)    ,
     $                   pi(maxm)  , rc(maxn+maxm)

*     SQOPT workspace

      parameter          (  lenrw = 10000)
      double precision   rw(lenrw)
      parameter          (  leniw =  5000) 
      integer            iw(leniw)
      parameter          (  lencw =   500) 
      character*8        cw(lencw)

      logical            byname
      character*20       lfile
      external           hs118
*     ------------------------------------------------------------------
*     Specify some of the SNOPT files.
*     iSpecs  is the Specs file   (0 if none).
*     iPrint  is the Print file   (0 if none).
*     iSumm   is the Summary file (0 if none).
*
*     nout    is an output file used here by main.

      iSpecs =  4
      iPrint =  15
      iSumm  =  6
      nout   =  6

      byname = .true.
 
      if ( byname ) then

*        Unix and DOS systems.  Open the Specs and print files.

         lfile = 'sqmainMPS.spc'
         open( iSpecs, file=lfile, status='OLD',     err=800 )

         lfile = 'sqmainMPS.out'
         open( iPrint, file=lfile, status='UNKNOWN', err=800 )
      end if

*     ------------------------------------------------------------------
*     First,  snInit MUST be called to initialize optional parameters 
*     to their default values.
*     ------------------------------------------------------------------
      call sqInit( iPrint, iSumm,
     $             cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Read a Specs file (Optional).
*     ------------------------------------------------------------------
      call sqSpec( iSpecs, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .ge. 2) then
         write(nout, *) 'iSpecs > 0 but no Specs file found'
         go to 990
      end if

*     ------------------------------------------------------------------
*     Set up the data structure for the constraints.
*     MPSinp needs to know the values of nnCon, nnJac, and nnObj
*     (all zero for linear constraints). 
*     The calls to sqget fetch values or defaults set in the SPECS file.
*     Optionally, these values can be set in-line.
*     ------------------------------------------------------------------
      call sqgeti( 'Nonlinear constraints        ', nnCon,
     $             inform, cw, lencw, iw, leniw, rw, lenrw )
      call sqgeti( 'Nonlinear Jacobian  variables', nnJac,
     $             inform, cw, lencw, iw, leniw, rw, lenrw )
      call sqgeti( 'Nonlinear Objective variables', nnObj,
     $             inform, cw, lencw, iw, leniw, rw, lenrw )
      call sqgeti( 'MPS file                     ',  iMPS,
     $             inform, cw, lencw, iw, leniw, rw, lenrw )

*     The problem name is not needed---it is set by MPSinp. 
*     Specify the OBJECTIVE, RHS, RANGES and BOUNDS to be selected 
*     from the MPS file.  Blank names mean "select the first one".

*     PrbNms(1) = '        '    ! PROBLEM   name
      PrbNms(2) = '        '    ! OBJECTIVE name
      PrbNms(3) = '        '    ! RHS       name
      PrbNms(4) = '        '    ! RANGES    name    
      PrbNms(5) = '        '    ! BOUNDS    name

      if ( byname ) then

*        Unix and DOS systems.  Open the MPS file.

         lfile = 'sqmainMPS.mps'
         open( iMPS, file=lfile, status='OLD', err=800 )
      end if

      call MPSinp( iMPS,
     $             maxm, maxn, maxne,
     $             nnCon, nnJac, nnObj, 
     $             m, n, ne,
     $             iObj, ObjAdd, PrbNms,
     $             a, ha, ka, bl, bu, Names,
     $             hs, xs, pi,
     $             inform, nS,
     $             cw, lencw, iw, leniw, rw, lenrw )

      close( iMPS )
      if (inform .gt. 0) go to 990

      nName = m + n

*     ------------------------------------------------------------------
*     Fix the column variables to be non-elastic and the row  variables 
*     to be elastic.
*     ------------------------------------------------------------------
      ncolH = 15
      lenc  = 0

      do 100, j = 1, n
         hElast(j) = 0
  100 continue

      do 110, j = n+1, n+m
         hElast(j) = 3
  110 continue

*     ------------------------------------------------------------------
*     Specify options that were not set in the Specs file.
*     i1 and i2 may refer to the Print and Summary file respectively.
*     Setting them to 0 suppresses printing.
*     ------------------------------------------------------------------
      itnlim = 40
      i1     =  0
      i2     =  0
      call sqseti( 'Iterations        ', itnlim, i1, i2, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Go for it, using a Cold start.
*     hs     need not be set if a basis file is to be input.
*            Otherwise, each hs(1:n) should be 0, 1, 2, 3, 4, or 5.
*            The values are used by the Crash procedure s2crsh
*            to choose an initial basis B.
*            If hs(j) = 0 or 1, column j is eligible for B.
*            If hs(j) = 2, column j is initially superbasic (not in B).
*            If hs(j) = 3, column j is eligible for B and is given
*                          preference over columns with hs(j) = 0 or 1.
*            If hs(j) = 4 or 5, column j is initially nonbasic.
*
*     No user-workspace, so we use cw, iw, rw.
*     ------------------------------------------------------------------
      call sqopt ( 'Cold', hs118, m, 
     $             n, ne, nName, lenc, ncolH,
     $             iObj, ObjAdd, PrbNms(1),
     $             a, ha, ka, bl, bu, c, Names,
     $             hElast, hs, xs, pi, rc, 
     $             inform, mincw, miniw, minrw,
     $             nS, nInf, sInf, Obj,
     $             cw, lencw, iw, leniw, rw, lenrw,
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .eq. 42) then
         write(nout, *) ' '
         write(nout, *) 'Estimate of required lenrw:', minrw
         go to 990
      end if

      write(nout, *) ' '
      write(nout, *) 'sqopt finished.'
      write(nout, *) 'inform =', inform
      write(nout, *) 'nInf   =', nInf
      write(nout, *) 'sInf   =', sInf
      write(nout, *) 'obj    =', obj
      if (inform .ge. 20) go to 910

*     ------------------------------------------------------------------
*     Alter some options and call sqopt again, testing the Warm start.
*     The following illustrates the use of snset, snseti and snsetr
*     to set specific options.  If necessary, we could ensure that
*     all unspecified options take default values
*     by first calling snset ( 'Defaults', ... ).
*     Beware that certain parameters would then need to be redefined.
*     ------------------------------------------------------------------
      write(nout, *) ' '
      write(nout, *) 'Alter options and test Warm start:'

      inform = 0
      itnlim = 500
      call sqset ( '                  ',         iPrint, iSumm, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )
      call sqset ( 'Print  level     0',         iPrint, iSumm, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )
      call sqset ( 'Scale option     0',         iPrint, iSumm, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )
      call sqseti( 'Iterations        ', itnlim, iPrint, iSumm, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .gt. 0) then
         write(nout, *) 'NOTE: Some of the options were not recognized'
      end if
*     ------------------------------------------------------------------
*     Test the Warm start.
*     hs(*) specifies a complete basis from the previous call.
*     A Warm start uses hs(*) directly, without calling Crash.
*     
*     Warm starts are normally used after sqopt has solved a
*     problem with the SAME DIMENSIONS but perhaps altered data.
*     Here we have not altered the data, so very few iterations
*     should be required.
*     ------------------------------------------------------------------
      call sqopt ( 'Warm', hs118, m, 
     $             n, ne, nName, lenc, ncolH,
     $             iObj, ObjAdd, PrbNms(1),
     $             a, ha, ka, bl, bu, c, Names, 
     $             hElast, hs, xs, pi, rc, 
     $             inform, mincw, miniw, minrw,
     $             nS, nInf, sInf, Obj,
     $             cw, lencw, iw, leniw, rw, lenrw,
     $             cw, lencw, iw, leniw, rw, lenrw )

      write(nout, *) ' '
      write(nout, *) 'sqopt finished again.'
      write(nout, *) 'inform =', inform
      write(nout, *) 'obj    =', obj
      if (inform .ge. 20) go to 910
      stop

*     ------------------------------------------------------------------
*     Error exit.
*     ------------------------------------------------------------------
  800 write(nout, 4000) 'Error while opening file', lfile
      stop

  910 write(nout, *) ' '
      write(nout, *) 'STOPPING because of error condition'

  990 stop

 4000 format(/  a, 2x, a  )

*     end of main program to test subroutine sqopt
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine hs118 ( ncolH, x, Hx, nState, 
     $                   cu, lencu, iu, leniu, ru, lenru )

      implicit           double precision (a-h,o-z)
      double precision   x(ncolH), Hx(ncolH)

      character*8        cu(lencu)
      integer            iu(leniu)
      double precision   ru(lenru)

*     ==================================================================
*     This is hs118, for problem Hock-Schittkowski 118.
*     ==================================================================

      iPrint = 15

*     ---------------------------------------
*     First entry.  Print something.
*     ---------------------------------------
      if (nState .eq. 1) then
         if (iPrint .gt. 0) write(iPrint, 1000) ncolH
      end if

*     -------------
*     Normal entry.
*     -------------
      do 150, i = 1, 5
         Hx(3*i-2) =  2.0d-4 * x(3*i-2)
         Hx(3*i-1) =  2.0d-4 * x(3*i-1)
         Hx(3*i)   =  3.0d-4 * x(3*i)
  150 continue

*     ------------
*     Last entry.
*     ------------
      if (nState .ge. 2) then
         if (iPrint .gt. 0) write(iPrint, 2000)
      end if
      return

 1000 format(// ' This is problem  HS 118.   ncolH =', i4)
 2000 format(// ' Finished         HS 118.')

*     end of hs118
      end

