*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
*     File  sn02lib.f
*
*     sntitl   snInit   snSpec   snMem    snprnt   
*     snset    snseti   snsetr   sngetc   sngeti   sngetr
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sntitl( title )

      character*30
     &     title

*     ==================================================================
*     sntitl sets the title for snopt.
*     ==================================================================

      title  = 'S N O P T  5.4-1(1) (Nov 2000)'
*---------------123456789|123456789|123456789|--------------------------

      end ! end of sntitl

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine snInit( iPrint, iSumm,
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     iPrint, iSumm, lencw, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     snInit  is called by the user to do the following:
*     1. Open default files (Print, Summary).
*     2. Initialize title.
*     3. Set options to default values.
*
*     15 Nov 1991: First version.
*     14 Jul 1997: Thread-safe version.
*     02 Oct 1997: Character workspace added.
*     01 Nov 2000: Current version of snInit.
*     ==================================================================
      integer
     &     iSpecs, maxru, maxrw, maxiu, maxiw, maxcu, maxcw,
     &     nnCon, nnJac, nnL, nnObj, lvlTim
      character*30
     &     title
      character*30
     &     dashes
      data
     &     dashes /'=============================='/
*     ------------------------------------------------------------------
      parameter         (maxru     =   2) ! start of SNOPT part of rw
      parameter         (maxrw     =   3) ! end   of SNOPT part of rw
      parameter         (maxiu     =   4) ! start of SNOPT part of iw
      parameter         (maxiw     =   5) ! end   of SNOPT part of iw
      parameter         (maxcu     =   6) ! start of SNOPT part of cw
      parameter         (maxcw     =   7) ! end   of SNOPT part of cw
      parameter         (nnJac     =  21) ! # nonlinear Jac, variables
      parameter         (nnObj     =  22) ! # variables in Gobj
      parameter         (nnCon     =  23) ! # of nonlinear constraints
      parameter         (nnL       =  24) ! nonlinear vars
      parameter         (lvlTim    =  77) ! Timing level
*     ------------------------------------------------------------------

      if (lencw .lt. 500 .or. leniw .lt. 500 .or. lenrw .lt. 500) then 
*        ---------------------------------------------------------------
*        Not enough workspace to do ANYTHING!
*        ---------------------------------------------------------------
         if (iPrint .gt. 0) write(iPrint, 9000) 
         if (iSumm  .gt. 0) write(iSumm , 9000) 
         if (iPrint .le. 0  .and.  iSumm  .le. 0) then
            write(*, 9000)
         end if
         go to 999
      end if

      iSpecs    = 0

      iw( 11)   = iSpecs  ! Specs file (default)
      iw( 12)   = iPrint  ! Print file
      iw( 13)   = iSumm   ! Summary file

      iw(maxcu) = 500
      iw(maxiu) = 500
      iw(maxru) = 500
      iw(maxcw) = lencw
      iw(maxiw) = leniw
      iw(maxrw) = lenrw

*     These dimensions need to be initialized for an MPS run.

      iw(nnCon) = 0
      iw(nnJac) = 0
      iw(nnObj) = 0
      iw(nnL  ) = 0

      call sntitl( title )
      call s1init( title, iw, leniw, rw, lenrw )

      if (iPrint .gt. 0) then
         write (iPrint, '(  9x, a )') ' ', dashes, title, dashes
      end if
      if (iSumm .gt. 0) then
         write (iSumm , '(  1x, a )') ' ', dashes, title, dashes
      end if

*     ------------------------------------------------------------------
*     Set the options to default values.
*     snopt  will check the options later and maybe print them.
*     ------------------------------------------------------------------
      call s3undf( cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Initialize some global values.
*     ------------------------------------------------------------------
      iw(lvlTim) = 3

  999 return

 9000 format(  ' EXIT from snInit --',
     &         ' character, integer and real work arrays',
     &         ' must each have at least 500 elements')

      end ! of snInit

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine snSpec( iSpecs, inform,
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     iSpecs, inform, lencw, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     snSpec  is called by the user to read the Specs file.
*
*     07 Feb 1998: First version.
*     03 Nov 2000: Current version of snSpec.
*     ==================================================================
      integer
     &     iPrint, iSumm, Calls
      external
     &     s3opt
*     ------------------------------------------------------------------
      iw( 11)   = iSpecs  ! Specs (options) file

      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file

      inform    = 0
      Calls     = 1

*     ------------------------------------------------------------------
*     Read the Specs file.
*     snopt  will check the options later and maybe print them.
*     ------------------------------------------------------------------
      if (iSpecs .gt. 0) then
         call s3file( Calls, iSpecs, s3opt,
     &        iPrint, iSumm, inform,
     &        cw, lencw, iw, leniw, rw, lenrw )
      end if

      end ! of snSpec

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine snMem ( m, n, ne, neG,
     &     nnCon, nnJac, nnObj,
     &     mincw, miniw, minrw,
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     m, n, ne, neG, nnCon, nnJac, nnObj, mincw, miniw, minrw,
     &     lencw, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     snMem   estimates the memory requirements for snopt,
*     using the values:
*        m    , n    , ne    neG,
*        nnObj, nnCon, nnJac     
*
*     These values are used to compute the minimum required storage:
*     mincw, miniw, minrw.
*
*     Note: 
*     1. All default parameters must be set before calling snMem,
*        since some values affect the amount of memory required.
*
*     2. The arrays rw and iw hold  constants and work-space addresses.
*        They must have dimension at least 500.
*
*     3. This version of snMem does not allow user accessible
*        partitions of cw, iw and rw.
*
*     29 Mar 1998: First version.
*     06 Nov 2000: Current version of snMem.
*     ==================================================================
      integer
     &     iError, iPrint, iPrinx, iSumm, iSummx, lenR, llenrw, lleniw, 
     &     llencw, lvlHes, maxcw, maxiw, maxrw, maxR, maxS, mQNmod 
*     ------------------------------------------------------------------
      integer            CheckO
      parameter         (CheckO = 0) 
*     ------------------------------------------------------------------
      iPrint  = iw( 12) ! Print file
      iSumm   = iw( 13) ! Summary file

      if (lencw .lt. 500 .or. leniw .lt. 500 .or. lenrw .lt. 500) then 
*        ---------------------------------------------------------------
*        Not enough workspace to do ANYTHING!
*        ---------------------------------------------------------------
         if (iPrint .gt. 0) write(iPrint, 9000) 
         if (iSumm  .gt. 0) write(iSumm , 9000) 
         if (iPrint .le. 0  .and.  iSumm  .le. 0) then
            write(*, 9000)
         end if
         go to 999
      end if

*     Error messages from s8Mem are suppressed.

      iPrinx  = 0
      iSummx  = 0

*     Assign fake values for lencw, leniw, lenrw.
*     This will force s8Mem to estimate the memory requirements.

      llenrw  = 500
      lleniw  = 500
      llencw  = 500

*     An obligatory call to snInit has `undefined' all options.
*     Check the user-defined values and assign undefined values.
*     s8dflt needs various problem dimensions in iw.

      iw( 15) = n     ! copy of the number of columns
      iw( 16) = m     ! copy of the number of rows
      iw( 17) = ne    ! copy of the number of nonzeros in Jcol
      iw( 21) = nnJac ! # nonlinear Jacobian variables
      iw( 22) = nnObj ! # variables in Gobj
      iw( 23) = nnCon ! # of nonlinear constraints

      call s8dflt( CheckO, cw, llencw, iw, lleniw, rw, llenrw )

      mincw   = 501
      miniw   = 501
      minrw   = 501

      maxcw   = lencw
      maxiw   = leniw
      maxrw   = lenrw

      maxR    = iw( 52) ! max columns of R.
      maxS    = iw( 53) ! max # of superbasics
      mQNmod  = iw( 54) ! (ge 0) max # of BFGS updates
      lvlHes  = iw( 72) ! 0,1,2  => LM, FM, Exact Hessian

      lenR    = maxR*(maxR + 1)/2

      call s8Mem ( iError, iPrinx, iSummx, 
     &     m, n, ne, neG, nnCon, nnJac, nnObj,
     &     lenR, maxS, mQNmod, lvlHes, 
     &     maxcw, maxiw, maxrw, llencw, lleniw, llenrw,
     &     mincw, miniw, minrw, iw )

  999 return

 9000 format(  ' EXIT from snMem --',
     &         ' character, integer and real work arrays',
     &         ' must each have at least 500 elements')

      end ! of snMem

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine snprnt( iAbort, info, Htype, KTcond, MjrPrt,
     &     minimz, n, nb, nnCon0, nS, nMajor, nMinor, nSwap,
     &     condHz, iObj, sclObj, ObjAdd, fMrt, PenNrm, step,
     &     prInf, duInf, vimax, virel, hs,
     &     ne, nlocJ, locJ, indJ, Jcol,
     &     Ascale, bl, bu, Fcon, Lmul, x,
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      logical
     &     KTcond(2)
      integer
     &     iAbort, info(6), iObj, Htype, MjrPrt, minimz, n, ne, nb,
     &     nlocJ, nnCon0, nS, nMajor, nMinor, nSwap, lencu, lencw,
     &     leniu, leniw, lenru, lenrw, hs(nb), locJ(nlocJ), indJ(ne),
     &     iu(leniu), iw(leniw)
      double precision
     &     condHz, sclObj, ObjAdd, fMrt, PenNrm, virel, vimax, step,
     &     prInf, duInf, Ascale(nb), bl(nb), bu(nb), Fcon(nnCon0),
     &     Jcol(ne), Lmul(nnCon0), x(nb), ru(lenru), rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     snprnt  prints the major iteration log.
*
*     The end-of-line summary is as follows:
*
*     Position   | Possible Entries
*     -----------|-------------------
*     1 = Update | n     s   -
*     2 = Modify |    M  m   - 
*     3 = Htype  |    R  r   - 
*     4 = Steps  |    d  l   -
*     5 = QPfea  |    i  -   -
*     6 = QPerr  |    t  T   u   w  z
*     7 = FDiff  |    c  -   -   -  -
*
*     15 Nov 1991: First version.
*     19 Jul 1997: Thread-safe version.
*     06 Nov 2000: Current version of snprnt.
*     ==================================================================
      logical
     &     Prnt1, PrntC, Summ1, nlnCon, prtHdg, Major0, pHead,
     &     prtx, prtl, prtf, prtj, scaled
      integer
     &     iPrint, iSumm, i, ir, j, k, k1, k2,lenL, lenU, LU, l,
     &     lvlScl, Mjr, Mnr, nLine, mjrhdg, mjrsum, mline, nnCon,
     &     nnJac, nnObj, nFcon(4), nFobj(4)
      double precision
     &     merit, plInfy, sgnObj
      character*7
     &     MjrMsg
      character*1
     &     flag(0:1), cflag
      character*2
     &     key(-1:4)
      data
     &     flag /' ', ' '/
      data
     &     key  /'fr', 'lo', 'up', 'sb', 'bs', 'fx'/
*     ------------------------------------------------------------------
      integer            HDiag,      HUnit 
      parameter         (HDiag  = 1, HUnit  = 2)
      integer            iQNtyp,     iModfy,     iStep
      parameter         (iQNtyp = 1, iModfy = 2, iStep  = 3)
      integer            iQPfea,     iQPerr,     iFDiff
      parameter         (iQPfea = 4, iQPerr = 5, iFDiff = 6)
      integer            Scale,     UnScal
      parameter         (Scale = 0, UnScal = 1)
      parameter         (mLine     =  20)
      parameter         (MjrHdg    = 224)
      parameter         (MjrSum    = 225)
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      nnCon     = iw( 23) ! # of nonlinear constraints
      nnJac     = iw( 21) ! # nonlinear Jacobian variables
      nnObj     = iw( 22) ! # variables in Gobj
      lvlScl    = iw( 75) ! scale option
      lenL      = iw(173) ! size of current  L
      lenU      = iw(174) ! size of current  U

      nFcon(1)  = iw(189) ! number of calls of Fcon
      nFcon(2)  = iw(190) ! number of calls of Fcon
      nFcon(3)  = iw(191) ! number of calls of Fcon
      nFcon(4)  = iw(192) ! number of calls of Fcon

      nFobj(1)  = iw(194) ! number of calls of Fobj
      nFobj(2)  = iw(195) ! number of calls of Fobj
      nFobj(3)  = iw(196) ! number of calls of Fobj
      nFobj(4)  = iw(197) ! number of calls of Fobj

      plInfy    = rw( 70) ! definition of plus infinity.

      iAbort    = 0

      nlnCon    = nnCon  .gt. 0
      Prnt1     = iPrint .gt. 0  .and.  MjrPrt .ge. 1
      PrntC     = iPrint .gt. 0  .and.  MjrPrt .ge. 100
      Summ1     = iSumm  .gt. 0  .and.  MjrPrt .ge. 1
      Major0    = nMajor .eq. 0  

      if (Major0  .and.  Prnt1) then
         write(iPrint, 1000)
      end if

      Mjr       = nMajor
      Mnr       = nMinor

      MjrMsg = '       '

      if (     info(iQNtyp) .eq. 0) then
         MjrMsg(1:1) = 'n'      ! No update could be made
      else if (info(iQNtyp) .eq. 2) then
         MjrMsg(1:1) = 's'      ! Scaled BFGS
      end if

      if (     info(iModfy) .eq. 1) then
         MjrMsg(2:2) = 'M'      ! BFGS + qN Hessian mod. 1
      else if (info(iModfy) .eq. 2) then
         MjrMsg(2:2) = 'm'      ! BFGS + qN Hessian mods. 1 + 2 
      end if

      if (     Htype .eq. HDiag) then
         MjrMsg(3:3) = 'R'      ! H set to a diagonal
      else if (Htype .eq. HUnit) then
         MjrMsg(3:3) = 'r'      ! H set to the identity
      end if

      if (     info(iStep)  .eq. 1) then
         MjrMsg(4:4) = 'd'      ! Violation limited via step
      else if (info(iStep)  .eq. 2) then
         MjrMsg(4:4) = 'l'      ! Vars limited via step
      end if

      if (     info(iQPfea) .eq. 1) then
         MjrMsg(5:5) = 'i'      ! QP infeasible
      end if

      if (     info(iQPerr) .eq. 1) then
         MjrMsg(6:6) = 'T'      ! terminated by WSlimit
      else if (info(iQPerr) .eq. 2) then
         MjrMsg(6:6) = 't'      ! terminated by itMax
      else if (info(iQPerr) .eq. 3) then
         MjrMsg(6:6) = 'u'      ! QP unbounded
      else if (info(iQPerr) .eq. 4) then
         MjrMsg(6:6) = 'w'      ! Weak QP solutions
      else if (info(iQPerr) .eq. 5) then
         MjrMsg(6:6) = 'z'      ! superbasic limit reached
      end if

      if (     info(iFDiff) .eq. 1) then
         MjrMsg(7:7) = 'c'      ! Central differences
      end if

      sgnObj    = minimz
      merit     = sgnObj*(ObjAdd + fmrt)

      if ( Prnt1 ) then
*        ------------------------------
*        Terse line for the Print file.
*        ------------------------------
         prtHdg = iw(MjrHdg) .gt. 0
         nLine  = mod( Mjr, mLine )
         pHead  = nLine  .eq. 0  .or.  prtHdg

         if (pHead) then
            cflag  = flag(min( nLine, 1 ))

            if (nlnCon) then
               write(iPrint, 2000) cflag
             else if (nnObj .gt. 0) then
               write(iPrint, 3000) cflag         
            else
               write(iPrint, 3010) cflag         
            end if
            iw(MjrHdg) = 0
         end if

         LU     = lenL + lenU
         if (nlnCon) then
            write(iPrint, 2100) Mjr, Mnr, step, nFobj(2), nFcon(2),
     &                          merit, prInf, duInf, nS,  
     &                          PenNrm, LU, nSwap, condHz,
     &                          KTcond, flag(0), MjrMsg
         else
            if (nnObj .gt. 0) then
               write(iPrint, 3100) Mjr, Mnr, step, nFobj(2),
     &                             merit,        duInf, nS, 
     &                                  LU,        condHz,
     &                             KTcond, flag(0), MjrMsg
            else
               write(iPrint, 3110) Mjr, Mnr, step, nFobj(2),
     &                             merit,        duInf, nS, 
     &                                  LU,
     &                             KTcond, flag(0), MjrMsg
            end if
         end if
      end if

      if ( Summ1 ) then
*        --------------------------------
*        Terse line for the Summary file.
*        --------------------------------
         prtHdg = iw(MjrSum)       .gt. 0
         pHead  = mod(Mjr, 10) .eq. 0  .or.  prtHdg
     &                                 .or.  Major0

         if (pHead) then
            iw(MjrSum) = 0
            if (nlnCon) then
               write(iSumm , 4000)
            else
               write(iSumm , 5000)               
            end if
         end if

         if (nlnCon) then
            write(iSumm , 4100) Mjr, Mnr, step, nFcon(2), 
     &                          merit, prInf, duInf, nS, PenNrm,
     &                          KTcond, MjrMsg
         else
            write(iSumm , 5100) Mjr, Mnr, step, nFobj(2), 
     &                          merit,        duInf, nS, 
     &                          KTcond, MjrMsg
         end if
      end if

      if (PrntC  .and.  nnCon .gt. 0) then
*        ---------------------------------------------------------------
*        Output heading for detailed log.
*        ---------------------------------------------------------------
         call s1page( 0, iw, leniw )
         if (Major0) write(iPrint, 1000)

*        Unscale everything if necessary.

         scaled = lvlScl .ge. 2
         if ( scaled ) then 
            call s2scla( UnScal, nnCon, n, nb, iObj, plInfy, sclObj, 
     &           ne, nlocJ, locJ, indJ, Jcol, 
     &           Ascale, bl, bu, Lmul, x )
            call ddscl ( nnCon, Ascale(n+1), 1, Fcon, 1 )
         end if

         l      = MjrPrt/100
         prtx   = mod( l,10 ) .gt. 0
         l      = l/10
         prtl   = mod( l,10 ) .gt. 0  .and.  Mjr .gt. 0
         l      = l/10
         prtf   = mod( l,10 ) .gt. 0
         l      = l/10
         prtj   = mod( l,10 ) .gt. 0

         if ( prtx ) write(iPrint, 7100) (x(j)   , j=1,nnJac)
         if ( prtl ) write(iPrint, 7200) (Lmul(i), i=1,nnCon)
         if ( prtf ) write(iPrint, 7300) (Fcon(i), i=1,nnCon)
         if ( prtf ) write(iPrint, 7600) vimax, virel
         if ( prtj ) then
            write(iPrint, 7400)
            do j  = 1, nnJac
               k1 = locJ(j)
               k2 = locJ(j+1) - 1
               do k  = k1, k2
                  ir = indJ(k)
                  if (ir .gt. nnCon) go to 60
               end do
               k    = k2 + 1
   60          k2   = k  - 1
               l    = hs(j)
               write(iPrint, 7410)
     &              j, x(j), key(l), (indJ(k), Jcol(k), k=k1, k2)
            end do
         end if
   
*        Scale again if necessary.
         
         if (scaled) then
            call s2scla( Scale, nnCon, n, nb, iObj, plInfy, sclObj,
     &           ne, nlocJ, locJ, indJ, Jcol, 
     &           Ascale, bl, bu, Lmul, x )
            call dddiv ( nnCon, Ascale(n+1), 1, Fcon, 1 )
         end if
      end if
      return

 1000 format(' ')

*     Print file

 2000 format(/   ' Major Minor   Step   nObj  nCon',
     &           '      Merit      Feasibl Optimal   nS', 
     &           ' Penalty     LU Swp Cond Hz', ' PD', a1)
 2100 format(    i6, i6, 1p, e8.1, 2i6, e16.8, 2e8.1, i5, 
     &           e8.1, i7, i4, e8.1, 
     &           1x, 2l1, a1, a7 )
 3000 format(/   ' Major Minor   Step   nObj', 
     &           '     Objective   Optimal   nS', 
     &           '     LU Cond Hz', ' PD', a1)
 3010 format(/   ' Major Minor   Step   nObj', 
     &           '     Objective   Optimal   nS', 
     &           '     LU', ' PD', a1)
 3100 format(    i6, i6, 1p, e8.1, i6, e16.8, e8.1, i5,
     &                   i7, e8.1, 
     &           1x, 2l1, a1, a7 )
 3110 format(    i6, i6, 1p, e8.1, i6, e16.8, e8.1, i5,
     &                   i7,
     &           1x, 2l1, a1, a7 )

*     Summary file

 4000 format(/   ' Major Minor   Step   nCon',
     &           '    Merit      Feasibl Optimal   nS', 
     &           ' Penalty',
     &           ' PD' )
 4100 format(    i6, i6, 1p, e8.1, i6, e14.6, 2e8.1, i5, e8.1, 
     &           1x, 2l1, 1x, a7 )

 5000 format(/   ' Major Minor   Step   nObj', 
     &           '   Objective   Optimal   nS', 
     &           ' PD' )
 5100 format(    i6, i6, 1p, e8.1, i6, e14.6, e8.1, i5,
     &           1x, 2l1, 1x, a7 )

 7100 format(/ ' Jacobian variables'
     &       / ' ------------------'   / 1p, (5e16.7))
 7200 format(/ ' Multiplier estimates'
     &       / ' --------------------' / 1p, (5e16.7))
 7300 format(/ ' Constraint functions'
     &       / ' --------------------' / 1p, (5e16.7))
 7400 format(/ ' x  and  Jacobian' / ' ----------------')
 7410 format(i6, 1p, e13.5, 1x, a2, 1x, 4(i9, e13.5)
     &       / (22x, 4(i9, e13.5)))

 7600 format(  ' Maximum constraint violation    =', 1p, e12.4,
     &     4x,  ' ( =', e11.4, ' normalized)' )

      end ! of snprnt

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine snset ( buffer, iPrint, iSumm, inform,
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     iPrint, iSumm, inform, lencw, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     snset  decodes the option contained in  buffer.
*
*     The buffer is output to file iPrint, minus trailing blanks.
*     Error messages are output to files iPrint and iSumm.
*     Buffer is echoed to iPrint but normally not to iSumm.
*     It is echoed to iSumm before any error msg.
*
*     On entry,
*     iPrint is the print   file.  no output occurs if iPrint .le 0.
*     iSumm  is the Summary file.  no output occurs if iSumm  .le 0.
*     inform is the number of errors so far.
*
*     On exit,
*     inform is the number of errors so far.
*
*     27 Nov 1991: first version of snset.
*     03 Nov 2000: current version.
*     ==================================================================
      integer
     &     ivalue
      double precision
     &     rvalue
      character*8
     &     cvalue
      character*16
     &     key
*     ------------------------------------------------------------------
      call s3opt ( .true., buffer, key, cvalue, ivalue, rvalue, 
     &     iPrint, iSumm, inform, cw, lencw, iw, leniw, rw, lenrw )

      end ! of snset

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine snseti( buffer, ivalue, iPrint, iSumm, inform,
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     ivalue, iPrint, iSumm, inform, lencw, leniw, lenrw,
     &     iw(leniw)
      double precision
     &     rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     snseti decodes the option contained in  buffer // ivalue.
*     The parameters other than ivalue are as in snset.
*
*     27 Nov 1991: first version of snseti.
*     03 Nov 2000: current version.
*     ==================================================================
      integer
     &     ivalxx, lenbuf
      double precision
     &     rvalue
      character*8
     &     cvalue
      character*16
     &     key
      character*72
     &     buff72
*     ------------------------------------------------------------------
      write(key, '(i16)') ivalue
      lenbuf = len(buffer)
      buff72 = buffer
      buff72(lenbuf+1:lenbuf+16) = key
      ivalxx = ivalue
      call s3opt ( .true., buff72, key, cvalue, ivalxx, rvalue, 
     &     iPrint, iSumm, inform, cw, lencw, iw, leniw, rw, lenrw )

      end ! of snseti

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine snsetr( buffer, rvalue, iPrint, iSumm, inform,
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     iPrint, iSumm, inform, lencw, leniw, lenrw, iw(leniw)
      double precision
     &     rvalue, rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     snsetr decodes the option contained in  buffer // rvalue.
*     The parameters other than rvalue are as in snset.
*
*     27 Nov 1991: first version of snsetr.
*     03 Nov 2000: current version.
*     ==================================================================
      integer
     &     ivalue, lenbuf
      character*8
     &     cvalue
      double precision
     &     rvalxx
      character*16
     &     key
      character*72
     &     buff72
*     ------------------------------------------------------------------
      write(key, '(1p, e16.8)') rvalue
      lenbuf = len(buffer)
      buff72 = buffer
      buff72(lenbuf+1:lenbuf+16) = key
      rvalxx = rvalue
      call s3opt ( .true., buff72, key, cvalue, ivalue, rvalxx,
     &     iPrint, iSumm, inform, cw, lencw, iw, leniw, rw, lenrw )

      end ! of snsetr

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sngetc( buffer, cvalue, inform,
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     inform, lencw, leniw, lenrw, iw(leniw)
      character*8
     &     cvalue, cw(lencw)
      double precision
     &     rw(lenrw)

*     ==================================================================
*     sngetc gets the value of the option contained in  buffer.
*     The parameters other than cvalue are as in snset.
*
*     17 May 1998: first version of sngetc.
*     03 Nov 2000: current version.
*     ==================================================================
      integer
     &     ivalue
      double precision
     &     rvalue
      character*16
     &     key
*     ------------------------------------------------------------------
      call s3opt ( .false., buffer, key, cvalue, ivalue, rvalue,
     &     0, 0, inform, cw, lencw, iw, leniw, rw, lenrw )

      end ! of sngetc

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sngeti( buffer, ivalue, inform, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     ivalue, inform, lencw, leniw, lenrw, iw(leniw)
      character*8
     &     cw(lencw)
      double precision
     &     rw(lenrw)

*     ==================================================================
*     sngeti gets the value of the option contained in  buffer.
*     The parameters other than ivalue are as in snset.
*
*     17 May 1998: first version of sngeti.
*     03 Nov 2000: current version.
*     ==================================================================
      double precision
     &     rvalue
      character*16
     &     key
      character*8
     &     cvalue
*     ------------------------------------------------------------------
      call s3opt ( .false., buffer, key, cvalue, ivalue, rvalue,
     &     0, 0, inform, cw, lencw, iw, leniw, rw, lenrw )

      end ! of sngeti

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sngetr( buffer, rvalue, inform,
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     inform, lencw, leniw, lenrw, iw(leniw)
      double precision
     &     rvalue, rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     sngetr gets the value of the option contained in  buffer.
*     The parameters other than rvalue are as in snset.
*
*     17 May 1998: first version of sngetr.
*     03 Nov 2000: current version.
*     ==================================================================
      integer
     &     ivalue
      character*16
     &     key
      character*8
     &     cvalue
*     ------------------------------------------------------------------
      call s3opt ( .false., buffer, key, cvalue, ivalue, rvalue,
     &     0, 0, inform, cw, lencw, iw, leniw, rw, lenrw )

      end ! of sngetr

