*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
*     File  sn25bfac.f
*
*     s2Bfac   s2Bmap   s2newB   s2BLU    s2Bmod   s2Bsol   s2sing
*     s2tols
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s2Bfac( typeLU, needLU, newLU, newB,
     &     iError, iObj, itn, lPrint, LUreq,
     &     m, mBS, n, nb, nnL, nS, nSwap,
     &     ne, nlocA, locA, indA, Acol,
     &     kBS, hs, bl, bu, blBS, buBS,
     &     nrhs0, nrhs, rhs, x, xBS,
     &     iy, iy1, y, y1, iw, leniw, rw, lenrw )

      implicit
     &     none
      logical
     &     needLU, newLU, newB
      integer
     &     typeLU, iError, iObj, itn, nrhs0, nrhs, lPrint, LUreq, nnL,
     &     m, mBS, n, nb, ne, nlocA, nS, nSwap, leniw, lenrw,
     &     locA(nlocA), indA(ne), hs(nb), kBS(mBS), iy(nb), iy1(nb),
     &     iw(leniw)
      double precision
     &     Acol(ne), rhs(nrhs0), bl(nb), bu(nb), x(nb),
     &     blBS(mBS), buBS(mBS), xBS(mBS), y(nb), y1(nb), rw(lenrw)

*     =================================================================
*     s2Bfac  computes an acceptable x such that  ( A  -I )*x = b.
*     The LU factorization of the basis is computed if necessary.
*
*     If typeLU = B , the usual B = LU is computed.
*     If typeLU = BS, there are some superbasics and we want to
*                     choose a good basis from the columns of (B S).
*                     We first factorize (B S)' to obtain a new B.
*                     Then B = LU is computed as usual.
*     If typeLU = BT, we should TRY 'B ' first and go back to 'BS'
*                       only if B seems ill-conditioned.
*
*     15 Nov 1991: First version based on Minos routine m2bfac.
*     29 Oct 1993: typeLU options implemented.
*                  nSwap returns the number of (B S) changes.
*     22 Apr 1994: Retry with reduced LU Factor tol
*                  if s2BLU says there was large growth in U.
*     22 Apr 1994: 'BT' option implemented to save R more often each
*                  major iteration.
*     02 Apr 1996: kObj added to mark position of Obj slack in B.
*     14 Jul 1997: Thread-safe version.
*     16 Oct 2000: Current version of s2Bfac.
*     =================================================================
      logical
     &     BSfac, BTfac, needx, NewTol, prnt10
      integer
     &     inform, iPrint, iSumm, j, jObj, jq, k, kObj, maxrw, maxiw,
     &     lprDbg, lenaLU, maxLUi, maxLUr, iP, iQ, locr, LUa, indc,
     &     indr, lin, ntry, nBS, nBSslk, nBasic, nBelem, nslack,
     &     nonlin, more, newi, newr, dUmin, Umin, nSing, minlen, nFac,
     &     nBfac, LUitn, LUmod, TPivot
      double precision
     &     eps2, rowerr, Utol
*     ------------------------------------------------------------------
      integer            TPP,        TCP
      parameter         (TPP    = 0, TCP    = 1)
      integer            DefTol,     RedTol
      parameter         (DefTol = 0, RedTol = 1)
      integer            Reset
      parameter         (Reset  = 0)
      integer            B,          BS,         BT   
      parameter         (B      = 0, BS     = 1, BT = 2)
      integer            mtry
      parameter         (mtry      = 15)
*     LUSOL arguments.
      parameter         (dUmin     = 164) ! minimum diagonal in  U.
*
      parameter         (TPivot    = 156) ! 0(1) LU TPP(TCP)
      parameter         (nSing     = 161) ! # of singularities in w(*)
      parameter         (minlen    = 163) ! minimum recommended lenaLU
*    
      parameter         (Umin      = 190) ! saved smallest U diagonal
      parameter         (kObj      = 205) ! xBS(kObj) is the obj. slack
      parameter         (nFac      = 210) ! # of LU factorizations
      parameter         (nBFac     = 211) ! # consecutive `B' facts
      parameter         (LUitn     = 215) ! itns since last factorize
      parameter         (LUmod     = 216) ! number of LU mods

      double precision   zero
      parameter         (zero      = 0.0d+0)
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file

      eps2      = rw(  4) ! eps**(1/2)
      maxrw     = iw(  3) ! end of SNOPT part of rw
      maxiw     = iw(  5) ! end of SNOPT part of iw
      lprDbg    = iw( 85) ! > 0    => private debug print
      lenaLU    = iw(213) ! space allotted for LU factors
      maxLUi    = iw(361) ! max LU nonzeros in iw(*)
      maxLUr    = iw(362) ! max LU nonzeros in rw(*)
      iP        = iw(363) !
      iQ        = iw(364) !
      locr      = iw(368) !
      LUa       = iw(371) !
      indc      = iw(373) !
      indr      = iw(374) !

      newB      = .false.
      BSfac     = .false.
      BTfac     = .false.

      nSwap     = 0
      nBS       = m + nS
      prnt10    = iPrint .gt. 0  .and.  lPrint .ge. 10

*     Initialize Umin and nBFac on first entry.
*     nBFac  counts consecutive B factorizations (reset if BS is done).
*     Umin   is the smallest diagonal of U after last BS factor.

      if (iw(nFac) .eq. 0) then
         rw(Umin)  = zero
         iw(nBFac) = 0
      end if

      if (needLU) then
         iw(nFac)  = iw(nFac)  + 1
         iw(nBFac) = iw(nBFac) + 1
         if (LUreq .eq. 8  .or.  LUreq .eq. 9) then
            call s2tols( RedTol, NewTol, itn, iw, leniw, rw, lenrw )
         end if
         if ( prnt10 ) write(iPrint, 1005) iw(nFac), LUreq, itn
         iw(LUitn) = 0
         iw(LUmod) = 0
         LUreq     = 0

*        ---------------------------------------------------------------
*        Set local logicals to select the required type of LU.
*        We come back to 100 if a BT factorize looks doubtful.
*        If BT was requested but we haven't done BS yet,
*        might as well do BS now.
*        ---------------------------------------------------------------
         BTfac  =  typeLU .eq. BT     .and.  nS       .gt. 0
         BSfac  = (typeLU .eq. BS     .and.  nS       .gt. 0   )  .or.
     &            (            BTfac  .and.  rw(Umin) .eq. zero)
      end if

  100 iError    = 0
      iw(nSing) = 0

      if ( BSfac ) then
*        ---------------------------------------------------------------
*        Repartition (B S) to get a better B.
*        ---------------------------------------------------------------
         BTfac     = .false.
         iw(nBFac) = 1

*        Load the basics into kBS.
   
         k     = 0
         do j  = 1, nb
            if (hs(j) .eq. 3) then
               k      = k + 1
               kBS(k) = j
            end if
         end do

         if (k .eq. m) then
*           ------------------------------------------------------------
*           We have the right number of basics.
*           1. Factorize (B S)'.
*           2. Apply the resulting row permutation to the columns
*              of (B S).
*           ------------------------------------------------------------
*
*           s2BLU  returns the following values:
*           inform = 0  if the LU factors were computed.
*                  = 1  if there are singularities (nSing gt 0).
*                  = 2  if there was large growth in U.
*                  = 3  if the matrix B has an illegal row or 
*                       column index.
*                  = 4  if an entry of B has the same indices as
*                       an earlier entry.
*                  = 5  Not used.
*                  = 6  Not used.
*                  = 7  if insufficient storage for the LU.
*                       minlen is an estimate of the necessary
*                       value of  lenaLU.
*                  = 8  if there is a fatal error in lu1fac.

            call s2BLU ( BS, inform, itn, lPrint, m, n, nb, nBS,
     &           ne, nlocA, locA, indA, Acol,
     &           kBS, iw(iP), rw(LUa), iw(indc),iw(indr), lenaLU, 
     &           iy, iy1, y, iw, leniw, rw, lenrw )

            if (inform .ge. 7) then
               iError = 20 ! insufficient storage for the LU.
               go to 400
            else if (inform  .ge. 3) then
               iError = 21 ! this should never happen
               go to 400
            end if

            call s2newB( nBSslk, m, mBS, n, nb, nS,
     &           hs, iw(iP), kBS, iy, iw(locr), nSwap )
            if (nBSslk .gt. 0) then
               iError = 33
               go to 400
            end if

            if (nSwap .gt. 0) newB = .true.
            if ( prnt10 ) then
               write(iPrint, 1000) nSwap
            end if
         end if
      end if ! BS

      NewTol = .true.
      needx  = .true.

*+    while (needx  .and.  NewTol) do
  150 if    (needx  .and.  NewTol) then

*        ===============================================================
*        Main loop to obtain a successful LU factorization.
*        typeLU is not used.  (We are always factoring just B.)
*        ===============================================================
         ntry      = 0

*+       while (needLU  .and.  ntry .le. mtry  .and. iError .eq. 0) do
  200    if    (needLU  .and.  ntry .le. mtry  .and. iError .eq. 0) then
*           ------------------------------------------------------------
*           Normal B = LU.
*           Load the basic variables into  kBS,  slacks first.
*           Set  kObj  to tell us where the linear objective is.
*           ------------------------------------------------------------
            jObj     = n + iObj
            iw(kObj) = 0
            k        = 0
            do j = n+1, nb
               if (hs(j) .eq. 3) then 
                  k      = k + 1
                  kBS(k) = j
                  if (j .eq. jObj) iw(kObj) = k
               end if
            end do

            nBelem  = k
            nslack  = k
            nonlin  = 0

            do j = 1, n
               if (hs(j) .eq. 3) then
                  k = k + 1
                  if (k .le. m) then
                     kBS(k) = j
                     nBelem = nBelem + locA(j+1) - locA(j)
                     if (j .le. nnL) nonlin = nonlin + 1
                  end if
               end if
            end do

*           ------------------------------------------------------------
*           Break if the number of basics is inconsistent.
*           ------------------------------------------------------------
            nBasic = k
            if (nBasic .gt. m) then
               iError = 32
               go to 200
            end if

            if (nBasic .lt. m) then

*              Not enough basics.
*              Set the remaining kBS(k) = 0 for s2BLU and s2sing.

               call iload ( m-nBasic, 0, kBS(nBasic+1), 1 )
            end if

            lin    = nBasic - nSlack - nonlin
            if (lin .lt. 0) lin = 0
            if ( prnt10 ) then
               write(iPrint, 1010) nonlin, lin, nSlack
            end if

*           ------------------------------------------------------------
*           Load the basis matrix into the LU arrays and factorize it.
*           ------------------------------------------------------------
            call s2BLU ( B, inform, itn, lPrint, m, n, nb, nBS,
     &           ne, nlocA, locA, indA, Acol,
     &           kBS, iw(iP), rw(LUa), iw(indc), iw(indr), lenaLU, 
     &           iy, iy1, y, iw, leniw, rw, lenrw )

            ntry      = ntry + 1
            needLU    = inform .gt. 0

            if (     inform .ge. 7) then
               iError = 20      ! insufficient storage for the LU.
            else if (inform .eq. 2) then
*              --------------------------------------------------------
*              There was large growth in U. 
*              LU Factor tol has been reduced.  Try again.
*              --------------------------------------------------------
               iError = 0
               ntry   = 0
               go to 200
            else if (inform  .ge. 3) then
               iError = 21
            else if (inform  .gt. 0  .and.  ntry .gt. mtry) then
               iError = 22      ! this should never happen
            end if

            if (iError .gt. 0) go to 200

            if ( BSfac ) then
*              --------------------------------------------------------
*              We started with a BS factorize this time.
*              Save the smallest diag of U.
*              --------------------------------------------------------
               rw(Umin) = rw(dUmin)

            else if ( BTfac ) then
*              --------------------------------------------------------
*              (We come here only once.)
*              See if we should have done a BS factorize after all.
*              In this version we do it if any of the following hold:
*              1. dUmin (the smallest diagonal of U) is noticeably
*                 smaller than Umin (its value at the last BS factor).
*              2. dUmin is pretty small anyway.
*              3. B was singular.
*              nBFac  makes BS increasingly likely the longer we
*              keep doing B and not BS.
*              --------------------------------------------------------
               BTfac  = .false.
               Utol   = rw(Umin) * 0.1d+0 * iw(nBFac)
               BSfac  = rw(dUmin) .le. Utol   .or.
     &                  rw(dUmin) .le. eps2   .or.
     &                  iw(nSing) .gt. 0
               if ( BSfac ) then
                  needLU = .true.
                  go to 100
               end if
            else if (nS .eq. 0) then
               rw(Umin) = rw(dUmin)
            end if ! BS

            if (iw(nSing) .gt. 0) then
*              ---------------------------------------------------------
*              The basis was judged to be singular during the previous
*              factorize.  Suspect columns are indicated by non-positive
*              components of y(*).  Replace them by suitable slacks and 
*              try again.
*              11-Nov-94: Superbasic slacks no longer exist, so we don't
*                         have to update kBS(m+1:nS).
*              ---------------------------------------------------------
               newB = .true.
               call s2sing( mBS, m, n, nb, iPrint, iSumm,
     &              y, iw(iP), iw(iQ), bl, bu, hs, kBS, x )
            end if

*           If a BS swap was delayed because of the need to refactorize,
*           the last superbasic will be a slack.  Check to see if s2sing
*           made the slack basic.

            if (nS .gt. 0) then
               jq  = kBS(nBS)
               if (hs(jq) .eq. 3) then
                  nS    = nS    - 1
                  nBS   = m     + nS
                  nSwap = nSwap + 1
               end if
            end if

            go to 200
         end if
*+       end while
*        ---------------------------------------------------------------
*        We have a nonsingular B such that B = LU.
*        Compute the basic variables and check that  (A -I)*x = b.
*        s5setx also loads the basic/superbasic variables in xBS.
*        If the row check fails, switch to threshold complete pivoting
*        (TCP). 
*        ---------------------------------------------------------------
         call s5setx( Reset, inform, itn,
     &        m, n, nb, nBS, rowerr,
     &        ne, nlocA, locA, indA, Acol,
     &        kBS, xBS, nrhs0, nrhs, rhs, x, y, y1,
     &        iw, leniw, rw, lenrw )
         needx = inform .gt. 0
         if (needx) then
            if (iw(TPivot) .eq. TCP) then
               call s2tols( RedTol, NewTol, itn, iw, leniw, rw, lenrw )
            else if (iw(TPivot) .eq. TPP) then
               iw(TPivot) = TCP
               call s2tols( DefTol, NewTol, itn, iw, leniw, rw, lenrw )
            end if
            needLU = .true.
         end if

         BSfac = needLU  .and.  .not. BSfac  .and.  nS .gt. 0
         if ( BSfac ) go to 100

         go to 150
      end if
*+    end while

      if (needLU) iError = 10 ! Fatal row error

*     ==================================================================
*     Tidy up
*     ------------------------------------------------------------------
  400 if (iError .eq. 0) then
*        --------------------------------------------------------------
*        Normal exit.
*        Load the basic/superbasic bounds into blBS, buBS.
*        --------------------------------------------------------------
         do k  = 1, nBS
            j       = kBS(k)
            blBS(k) = bl(j) 
            buBS(k) = bu(j)
         end do

         newLU = ntry .gt. 0

         if (lprDbg .eq. 100) then
            write(iPrint, 7000) (kBS(k), xBS(k), k=1, nBS)
         end if
      else 
*        --------------------------------------------------------------
*        Error exits.
*        --------------------------------------------------------------
         if (iError .eq. 10) then
*           ---------------------------------------------
*           Fatal row error
*           ---------------------------------------------
*           Relax
         else if (iError .eq. 20) then
*           ---------------------------------------------
*           Insufficient storage to factorize B.
*           ---------------------------------------------
            more   = iw(minlen) -   lenaLU 
            newi   = maxiw      + 2*more
            newr   = maxrw      +   more
            if (maxLUi .lt. maxLUr) then
               if (iPrint .gt. 0) write(iPrint, 9201)
               if (iSumm  .gt. 0) write(iSumm , 9201)
            else
               if (iPrint .gt. 0) write(iPrint, 9202)
               if (iSumm  .gt. 0) write(iSumm , 9202)
            end if

            if (iPrint .gt. 0) then
               write(iPrint, 9203) maxiw, newi, maxrw, newr
            end if
            if (iSumm  .gt. 0) then
               write(iSumm , 9203) maxiw, newi, maxrw, newr
            end if
         else if (iError .eq. 21) then
*           ---------------------------------------------
*           Error in the LU package.
*           ---------------------------------------------
            if (iPrint .gt. 0) write(iPrint, 9210)
            if (iSumm  .gt. 0) write(iSumm , 9210)
         else if (iError .eq. 22) then
*           ---------------------------------------------
*           The basis is singular after mtry tries.
*               Time to give up.
*           ---------------------------------------------
            if (iPrint .gt. 0) write(iPrint, 9220) mtry
            if (iSumm  .gt. 0) write(iSumm , 9220) mtry
         else if (iError .eq. 32) then
*           ---------------------------------------------
*           Wrong number of basics.
*           ---------------------------------------------
            if (iPrint .gt. 0) write(iPrint, 9320) nBasic
            if (iSumm  .gt. 0) write(iSumm , 9320) nBasic
         else if (iError .eq. 33) then
*           ---------------------------------------------
*           A superbasic slack was detected.
*           ---------------------------------------------
            if (iPrint .gt. 0) write(iPrint, 9330) nBSslk
            if (iSumm  .gt. 0) write(iSumm , 9330) nBSslk
         end if
      end if

      return

 1000 format(  ' --> BS Factorize.   nSwap = ', i6 )
 1005 format(/ ' Factor', i7, '  Demand', i7, '  Itn', i11)
 1010 format(  ' Nonlin', i7, '  Linear', i7, '  Slacks', i8)
 7000 format(/ ' BS and SB values:' // (5(i7, g17.8)))

 9201 format(  ' EXIT -- not enough integer storage',
     &         ' for the basis factors')
 9202 format(  ' EXIT -- not enough real storage',
     &         ' for the basis factors')
 9203 format(/ 24x, '        Current    Recommended'
     &       / ' Total integer workspace', 2i15
     &       / ' Total real    workspace', 2i15)
 9210 format(  ' EXIT -- error in basis package')
 9220 format(  ' EXIT -- singular basis',
     &         ' after ', i2, ' factorization attempts')
 9320 format(  ' EXIT -- system error.  Wrong no. of basic variables:',
     &           i8)
 9330 format(  ' EXIT -- system error.  Superbasic slacks detected:  ',
     &           i8)

      end ! of s2Bfac

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s2Bmap( m, n, ne,
     &     miniw, minrw, maxiw, maxrw, liwEst, lrwEst, iw, leniw )

      implicit
     &     none
      integer
     &     m, n, ne, miniw, minrw, maxiw, maxrw,
     &     liwEst, lrwEst, leniw,
     &     iw(leniw)

*     ==================================================================
*     s2Bmap sets up the core allocation for the basis factors.
*     It is called by s5Mem and s8Mem.
*
*     Normally the storage is for B = LU.
*     For nonlinear problems, we may also need to factorize (B S)' = LU,
*     where S has at most maxS columns.
*
*     On entry:
*     miniw, minrw  say where the LU arrays can start in iw(*), rw(*).
*     maxiw, maxrw  say where the LU arrays must end  in iw(*), rw(*).
*
*     On exit:
*     liwEst, lrwEst  estimate the minimum length of iw(*), rw(*).
*     The LU routines will have some room to maneuver if the arrays
*     are at least that long.  (Later LU messages may ask for more.)
*     ------------------------------------------------------------------
*
*     15 Nov 1991: First version based on Minos 5.4 routine m2bmap.
*     08 Nov 1993: Generalized to allow room for (B S)'.
*     11 Nov 1994: rw(*) replaced by iw(*) and rw(*).
*     14 Jul 1997: Thread-safe version.
*     17 Mar 1998: miniw now points to start of integer LU workspace.
*     21 Aug 2000: Current version of s2Bmap.
*     ==================================================================
      integer
     &     maxS, mBS, mLU, nLU, iP, iQ, lenc, lenri, locc, locr,
     &     iPloc, iQloc, lastiw, maxLUi, maxLUr, indc, indr, LUa,
     &     lastrw, lenaLU, necolA, minA
*     ------------------------------------------------------------------
      maxS      = iw( 53) ! max # of superbasics

*     Allocate arrays for an  mLU x nLU  matrix.

      mBS    = m + maxS
      mLU    = mBS
      nLU    = m

*     LU integer workspace is  iw(iP:maxiw).
*     miniw points to the start of indc(*), indr(*).
*     indc and indr are made as long as possible.

      iP     = miniw
      iQ     = iP     + mLU
      lenc   = iQ     + nLU
      lenri  = lenc   + nLU
      locc   = lenri  + mLU
      locr   = locc   + nLU
      iPloc  = locr   + mLU
      iQloc  = iPloc  + nLU
      lastiw = iQloc  + mLU
      miniw  = lastiw

      maxLUi = (maxiw - lastiw) / 2
      indc   = lastiw
      indr   = indc   + maxLUi

*     LU real workspace is  rw(LUa:maxrw)
*     minrw points to the start of A(*).

      LUa    = minrw
      lastrw = minrw
      maxLUr = maxrw - lastrw

*     LUSOL thinks indc(*), indr(*) and A(*) are all of length lenaLU.

      lenaLU = max( 0, min( maxLUi, maxLUr ) )

*     Estimate the number of nonzeros in the basis factorization.
*     necolA = estimate of nonzeros per column of  A.
*     We guess that the density of the basis factorization is
*     5 times as great, and then allow 1 more such lot for elbow room.

      necolA = ne / n
      necolA = max( necolA, 5 )
      minA   = 6 * min( m, n ) * necolA
      liwEst = lastiw + 2*minA
      lrwEst = lastrw +   minA

      iw(213) = lenaLU    ! space allotted for LU factors
      iw(361) = maxLUi    ! max LU nonzeros in iw(*)
      iw(362) = maxLUr    ! max LU nonzeros in rw(*)
      iw(363) = iP        !
      iw(364) = iQ        !
      iw(365) = lenc      !
      iw(366) = lenri     !
      iw(367) = locc      !
      iw(368) = locr      !
      iw(369) = iPloc     !
      iw(370) = iQloc     !
      iw(371) = LUa       !
      iw(373) = indc      !
      iw(374) = indr      !

      end ! of s2Bmap

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s2newB( inform, m, mBS, n, nb, nS,
     &     hs, iP, kBS, kBSold, locr, nSwap )

      implicit
     &     none
      integer
     &     inform, mBS, m, n, nb, nS, nSwap,
     &     hs(nb), iP(mBS), kBS(mBS), kBSold(mBS), locr(mBS)

*     ==================================================================
*     s2newB  permutes kBS(*) to reflect the permutation (B S)P,
*     where P is in iP(*).  It updates hs(*) accordingly.
*     kBSold(*) and locr(*) are needed for workspace.
*
*     On exit,  inform gives the number of superbasic slacks 
*     (there shouldn't be any)
*
*     30 Oct 1993: First version.
*     04 Nov 1993: kBSold, nSwap used to save old R if there's no
*                  change in the set of superbasics.
*     16 Sep 2000: Current version of s2newB.
*     ==================================================================
      integer
     &     m1, nBS, i, j, k
*     ------------------------------------------------------------------
      inform = 0
      nSwap  = 0
      m1     = m + 1
      nBS    = m + nS
      call icopy ( nBS, kBS    , 1, locr      , 1 )
      call icopy ( nS , kBS(m1), 1, kBSold(m1), 1 )

      do k = 1, nBS
         i = iP(k)
         j = locr(i)
         kBS(k) = j
         if (k .le. m) then
            hs(j) = 3
         else
            if (hs(j) .ne. 2) nSwap = nSwap + 1
            hs(j) = 2
            if (j .gt. n) inform = inform + 1
         end if
      end do

*     Restore the old S ordering if S contains the same variables.

      if (nSwap .eq. 0) then
         call icopy ( nS, kBSold(m1), 1, kBS(m1), 1 )
      end if

      end ! of s2newB

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s2BLU ( Task, inform, itn, lPrint, m, n, nb, nBS,
     &     ne, nlocA, locA, indA, Acol,
     &     kBS, iP, aLU, indc, indr, lenaLU, 
     &     iy, iy1, y, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     Task, inform, itn, lPrint, m, n, nb, nBS, ne, nlocA, lenaLU, 
     &     leniw, lenrw, locA(nlocA), indA(ne), kBS(nBS), iP(nBS),
     &     indc(lenaLU), indr(lenaLU), iy(nb), iy1(nb), iw(leniw)
      double precision
     &     Acol(ne), aLU(lenaLU), y(nb), rw(lenrw)

*     ==================================================================
*     s2BLU  factorizes the basis.
*
*     Task = B   Extract the basis elements from the constraint matrix,
*                and factorize  B  from scratch, so that  B = L U.
*
*     Task = BS  Factorize transpose of (B S), so that  (B') = L*U,
*                                                       (S')
*                 without saving L and U.  Get a new partition of (B S).
*
*     The following tolerances are used...
*
*     luparm(3) = maxcol   lu1fac: Maximum number of columns
*                          searched allowed in a Markowitz-type
*                          search for the next pivot element.
*     luparm(6) = TPivot   TPivot = 0 means threshold partial  pivoting.
*                                   0 means threshold complete pivoting.
*     luparm(8) = keepLU   keepLU = 1 means keep L and U,
*                                   0 means discard them.
*     parmlu(1) = eLmax1 = Maximum multiplier allowed in  L  during
*                          refactorization.
*     parmlu(2) = eLmax2 = Maximum multiplier allowed during updates.
*     parmlu(3) = small  = Minimum element kept in  B  or in
*                          transformed matrix during elimination.
*     parmlu(4) = Utol1  = Abs tol for flagging small diagonals of  U.
*     parmlu(5) = Utol2  = Rel tol for flagging small diagonals of  U.
*     parmlu(6) = Uspace = Factor allowing waste space in row/col lists.
*     parmlu(7) = dens1    The density at which the Markowitz
*                          strategy should search maxcol columns
*                          and no rows.
*     parmlu(8) = dens2    The density at which the Markowitz
*                          strategy should search only 1 column.
*                          (In one version of lu1fac, the remaining
*                          matrix is treated as dense if there is
*                          sufficient storage.)
*
*     On exit,
*     inform = 2 if the LU tolerances were tightened because there was
*                excessive growth in U.
*
*     20 Oct 1990  Initial version based on Minos routine m2bsol.
*     07 Nov 1993: Add option to factorize (B S)'
*     06 Mar 1994: Include all rows of (B S), even if B contains slacks.
*     22 Apr 1994: Test for excessive growth in U.
*     14 Jul 1997: Thread-safe version.
*     23 Sep 2000: LU statistics now printed by LUSOL.
*     23 Sep 2000: Current version of s2BLU.
*     ==================================================================
      integer
     &     iPrint, iSumm, i, ir, j, k, nz, iQ, lenc, lenri, locc, locr,
     &     LUprnt, iPloc, iQloc, eLmax1, eLmax2, keepLU, minlen, TPivot
      double precision
     &     growth, tolFac
*     ------------------------------------------------------------------
      double precision   one,          onept9,          ten
      parameter         (one = 1.0d+0, onept9 = 1.9d+0, ten = 10.0d+0)
      integer            TPP,     TCP
      parameter         (TPP = 0, TCP = 1)
      integer            B,       BS
      parameter         (B   = 0, BS  = 1)
      parameter         (eLmax1 = 151) ! max L-multiplier in factor
      parameter         (eLmax2 = 152) ! max L-multiplier in update
      parameter         (LUprnt = 152) !
      parameter         (TPivot = 156) ! 0(1) LU TPP(TCP)
      parameter         (keepLU = 158) !
      parameter         (minlen = 163) ! minimum recommended lenaLU
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      iQ        = iw(364) !
      lenc      = iw(365) !
      lenri     = iw(366) !
      locc      = iw(367) !
      locr      = iw(368) !
      iPloc     = iw(369) !
      iQloc     = iw(370) !

      inform    = 0

      if (Task .eq. B) then
*        ---------------------------------
*        Estimate the number of nozeros in B.
*        ---------------------------------
         nz   = 0
         do k = 1, m
            j = kBS(k)
            if (j .eq. 0) then
*              --------------------------
*              Relax, just a zero column.
*              --------------------------
            else if (j .le. n) then
*              ----------------------------
*              Basic column is in A.
*              Ignore the objective row.
*              ----------------------------
               nz = nz + locA(j+1) - locA(j)
            else 
*              ---------------------
*              Basic slacks.
*              ---------------------
               nz = nz + 1
            end if
         end do

         iw(minlen) = nz*5/4
         if (iw(minlen) .gt. lenaLU) go to 900

*        ---------------------------------------------------------------
*        Load B into LUSOL.
*        ---------------------------------------------------------------
         nz   = 0
         do k = 1, m
            j = kBS(k)
            if (j .eq. 0) then
*              --------------------------
*              Relax, just a zero column.
*              --------------------------
            else if (j .le. n) then
*              ---------------------
*              Basic column is in A.
*              ---------------------
               do i  = locA(j), locA(j+1)-1
                  ir = indA(i)
                  nz = nz + 1
                  aLU (nz) = Acol(i)
                  indc(nz) = ir
                  indr(nz) = k
               end do
            else 
*              ---------------------
*              Basic slacks.
*              ---------------------
               nz       =   nz + 1
               aLU (nz) = - one
               indc(nz) =   j - n
               indr(nz) =   k
            end if
         end do

!!!      We need to set iw(152) = 1  for errors,
!!!                             = 10 for statistics
!!!                             = 50 for debug info
         if (iPrint .gt. 0) then
            iw(LUprnt) = lPrint
         end if
         iw(keepLU) = 1

*        iy and iy1 are work vectors
*        y is an output parameter, used by s2sing.

         call lu1fac( m, m, nz, lenaLU, iw(151), rw(151),
     &        aLU, indc, indr, iP, iw(iQ),
     &        iw(lenc), iw(lenri), iw(locc), iw(locr),
     &        iw(iPloc), iw(iQloc), iy, iy1, y, inform )

         growth    = rw(166) ! TPP: Umax/Amax    TCP: Akmax/Amax

*        Test for excessive growth in U.
*        Reduce LU Factor tol and LU Update tol if necessary.
*        (Default values are 100.0 and 10.0)

         if (inform .eq. 0  .and.  growth .ge. 1.0d+8) then
            if (iw(Tpivot) .eq. TPP) then ! Switch from TPP to TCP
               iw(Tpivot) = TCP
               rw(eLmax1) = 100.0d+0
               if (iPrint .gt. 0) write(iPrint, 1005) itn, rw(eLmax1)
               if (iSumm  .gt. 0) write(iSumm , 1005) itn, rw(eLmax1)
               inform     = 2
            else if (rw(eLmax1) .ge. 2.0d+0) then
               rw(eLmax1) = sqrt( rw(eLmax1) )
               if (iPrint .gt. 0) write(iPrint, 1010) itn, rw(eLmax1)
               if (iSumm  .gt. 0) write(iSumm , 1010) itn, rw(eLmax1)
               inform     = 2
            end if

            if (rw(eLmax2) .gt. rw(eLmax1)) then
               rw(eLmax2) = rw(eLmax1)
               if (iPrint .gt. 0) write(iPrint, 1020) itn, rw(eLmax1)
               if (iSumm  .gt. 0) write(iSumm , 1020) itn, rw(eLmax1)
            end if
         end if

      else if (Task .eq. BS) then
*        ---------------------------------------------------------------
*        Factorize (B S)' = LU without keeping L and U.
*        ---------------------------------------------------------------
*        Extract (B S)'.
*        iP(1:m) is needed for workspace.
*        iP(i) = 0 except for rows with a basic or superbasic slack.
*        We can ignore all of these rows except for the slack itself.
*        06 Mar 1994: Keep all rows.  (Made a difference in MINOS)
*        22 Apr 1994: Make sure the objective slack remains basic!!
*        11 Nov 1994: Go back to ignoring rows with a slack in B.
*                   This means we don't have to worry about the Obj.
*        ---------------------------------------------------------------
         call iload ( m, 0, iP, 1 )
         do k = 1, nBS
            j = kBS(k)
            if (j .gt. n) iP(j-n) = 1
         end do

*        Count the number of nonzeros in ( B S ).

         nz   = 0
         do k = 1, nBS
            j = kBS(k)
            if (j .le. n) then
               do i  = locA(j), locA(j+1)-1
                  ir = indA(i)
                  if (iP(ir) .eq. 0) nz = nz + 1
               end do
            else
               nz  =  nz + 1
            end if
         end do

         iw(minlen) = nz*5/4
         if (iw(minlen) .gt. lenaLU) go to 900

         nz   = 0
         do k = 1, nBS
            j = kBS(k)
            if (j .le. n) then
               do i  = locA(j), locA(j+1)-1
                  ir = indA(i)
                  if (iP(ir) .eq. 0) then
                     nz       = nz + 1
                     aLU(nz)  = Acol(i)
                     indc(nz) = k
                     indr(nz) = ir
                  end if
               end do
            else
               nz       =   nz + 1
               aLU(nz)  = - one
               indc(nz) =   k
               indr(nz) =   j - n
            end if
         end do

!!!      We need to set iw(152) = 1  for errors,
!!!                             = 10 for statistics
!!!                             = 50 for debug info
         if (iPrint .gt. 0) then
            iw(LUprnt) = lPrint
            if (lPrint .ge. 10) write(iPrint, 1800)
         end if
         iw(keepLU) = 0

*        Save eLmax1 (the existing LU Factor tol) and set it to a small
*        value for this LU, to give a good (B S) partitioning.

         tolFac     = rw(eLmax1)
         if (iw(TPivot) .eq. TPP) then
            rw(eLmax1) = onept9
         else if (iw(TPivot) .eq. TCP) then
            rw(eLmax1) = ten
         end if

         call lu1fac( nBS, m, nz, lenaLU, iw(151), rw(151),
     &        aLU, indc, indr, iP, iw(iQ),
     &        iw(lenc ), iw(lenri), iw(locc), iw(locr),
     &        iw(iPloc), iw(iQloc), iy, iy1, y, inform )

         rw(eLmax1) = tolFac
         if (iPrint .gt. 0) then
            if (lPrint .ge. 10) write(iPrint, 1800)
         end if
       end if

      return

*     Not enough storage.

  900 inform = 7
      return

 1005 format(' Itn', i7, ' Switched to LU complete pivoting',
     &       '.  New factor tol is', f10.2)
 1010 format(' Itn', i7, ' LU Factor tol reduced to', f10.2)
 1020 format(' Itn', i7, ' LU Update tol reduced to', f10.2)
 1800 format(' ')

      end ! of s2BLU

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s2Bmod( inform, jrep, m, z, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     inform, jrep, m, leniw, lenrw, iw(leniw)
      double precision
     &     z(m), rw(lenrw)

*     ==================================================================
*     s2Bmod  updates the LU factors of B when column "jrep" is replaced
*             by a vector  v.  On entry,   z  must satisfy  L z = v. 
*             It is overwritten.
*
*     20 Oct 1990  Initial version.
*     14 Jul 1997: Thread-safe version.
*     01 Jun 1999: Current version of s2Bmod.
*     ==================================================================
      integer
     &     lenaLU, iP, iQ, lenc, lenri, locr, locc, LUa, indc, indr
      double precision
     &     diag, zNorm
*     ------------------------------------------------------------------
      lenaLU    = iw(213) ! space allotted for LU factors
      iP        = iw(363) !
      iQ        = iw(364) !
      lenc      = iw(365) !
      lenri     = iw(366) !
      locc      = iw(367) !
      locr      = iw(368) !
      LUa       = iw(371) !
      indc      = iw(373) !
      indr      = iw(374) !

      call lu8rpc( 1, 2, m, m, jrep, z, z,
     &     lenaLU, iw(151), rw(151),
     &     rw(LUa ), iw(indc), iw(indr), iw(iP), iw(iQ),
     &     iw(lenc), iw(lenri), iw(locc), iw(locr),
     &     inform, diag, zNorm )

      end ! of s2Bmod

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s2Bsol( Task, inform, m, z, y, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     Task, inform, m, leniw, lenrw, iw(leniw)
      double precision
     &     z(m), y(m), rw(lenrw)

*     ==================================================================
*     s2Bsol  solves various systems with the LU factors of B.
*     Task  selects one of the following:
*      Task          Action
*      ----          ------
*      with L    Solve  L*z = z(input).    y  is not touched.
*      with B    Solve  L*z = z(input)  and solve  B*y = z(input).
*      with Bt   Solve  B(transpose)*y = z.  Note that  z  is destroyed.
*
*     20 Oct 1990  Initial version.
*     01 Jun 1999: Current version of s2Bsol 
*     ==================================================================
      integer
     &     iP, iQ, lenc, lenri, locc, locr, indc, indr, LUa, lenaLU
      double precision
     &     small0, dnrm1s
*     ------------------------------------------------------------------
      integer            small
      parameter         (small     = 153) ! defn of small real

      integer            WithL,     WithB,     WithBt   
      parameter         (WithL = 0, WithB = 1, WithBt = 2)
*     ------------------------------------------------------------------
      lenaLU    = iw(213) ! space allotted for LU factors
      iP        = iw(363) !
      iQ        = iw(364) !
      lenc      = iw(365) !
      lenri     = iw(366) !
      locc      = iw(367) !
      locr      = iw(368) !
      LUa       = iw(371) !
      indc      = iw(373) !
      indr      = iw(374) !

      if (Task .eq. WithL  .or.  Task .eq. WithB) then
*        ---------------------------------------------------------------
*        Solve   L*z = z(input).
*        When LU*y = z is being solved in SNOPT, norm(z) will sometimes
*        be small (e.g. after periodic refactorization).  Hence for
*        solves with L we scale parmlu(3) to alter what lu6sol thinks 
*        is small.
*        ---------------------------------------------------------------
         small0    = rw(small)
         if (Task .eq. WithB) rw(small) = small0 * dnrm1s( m, z, 1 )

         call lu6sol( 1, m, m, z, y, 
     &        lenaLU,  iw(151), rw(151),
     &        rw(LUa ), iw(indc), iw(indr), iw(iP), iw(iQ),
     &        iw(lenc), iw(lenri), iw(locc), iw(locr),
     &        inform )
         rw(small) = small0

         if (Task .eq. WithB) then
*           ------------------------------------------------------------
*           Task = solve with B.   Solve  U*y = z.
*           ------------------------------------------------------------
            call lu6sol( 3, m, m, z, y, 
     &           lenaLU, iw(151), rw(151),
     &           rw(LUa ), iw(indc), iw(indr), iw(iP), iw(iQ),
     &           iw(lenc), iw(lenri), iw(locc), iw(locr),
     &           inform )
         end if

      else if (Task .eq. WithBt) then
*        ---------------------------------------------------------------
*        Task = solve with B transpose.  Solve  B'*y = z.
*        ---------------------------------------------------------------
         call lu6sol( 6, m, m, y, z, 
     &        lenaLU, iw(151), rw(151),
     &        rw(LUa ), iw(indc), iw(indr), iw(iP), iw(iQ),
     &        iw(lenc), iw(lenri), iw(locc), iw(locr),
     &        inform )
      end if

      end ! of s2Bsol

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s2sing( mBS, m, n, nb, iPrint, iSumm,
     &     z, iP, iQ, bl, bu, hs, kBS, x )

      implicit
     &     none
      integer
     &     mBS, m, n, nb, iPrint, iSumm, iP(m), iQ(m), hs(nb), kBS(mBS)
      double precision
     &     bl(nb), bu(nb), z(m), x(nb)

*     =================================================================
*     s2sing  is called if the LU factorization of the basis appears
*     to be singular.   If  z(j)  is not positive, the  jth  basic
*     variable  kBS(j)  is replaced by the appropriate slack.
*     If any kBS(j) = 0, only a partial basis was supplied.
*
*     30 Sep 1991: First version based on minos routine m2sing.
*     29 May 1995: Optional swapping of slack and basic.
*     12 Jul 1997: Thread-safe version.
*     14 Jul 1997: Current version of s2sing.
*     =================================================================
      integer
     &     i, j, k, nSing
*     -----------------------------------------------------------------
      integer            nPrint
      parameter         (nPrint = 5)

      double precision   zero
      parameter         (zero = 0.0d+0)
*     -----------------------------------------------------------------
      nSing  = 0
      do k = 1, m
         j = iQ(k)
         if (z(j) .le. zero) then
            j = kBS(j)

            if (j .gt. 0) then

*              Make variable  j  nonbasic (and feasible).
*              hs(j) = -1 means x(j) is strictly between its bounds.

               if      (x(j) .le. bl(j)) then
                  x(j)  =  bl(j)
                  hs(j) =  0
               else if (x(j) .ge. bu(j)) then
                  x(j)  =  bu(j)
                  hs(j) =  1
               else
                  hs(j) = -1
               end if
               if (bl(j) .eq. bu(j)) hs(j) = 4
            end if

*           Make the appropriate slack basic.
         
            i       = iP(k)
            hs(n+i) = 3
            nSing   = nSing + 1
            if (nSing .le. nPrint) then
               if (iPrint .gt. 0) write(iPrint, 1000) j, i
               if (iSumm  .gt. 0) write(iSumm , 1000) j, i
            end if
         end if
      end do

      if (nSing .gt. nPrint) then
         if (iPrint .gt. 0) write(iPrint, 1100) nSing
         if (iSumm  .gt. 0) write(iSumm , 1100) nSing
      end if
      return

 1000 format(' Column', i7, '  replaced by slack', i7)
 1100 format(' and so on.  Total slacks inserted =', i6)

      end ! of s2sing

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s2tols( mode, NewTol, itn, iw, leniw, rw, lenrw )

      implicit
     &     none
      logical
     &     NewTol
      integer
     &     mode, itn, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)

*     =================================================================
*     s2tols  sets the LU Factor and Update tolerances.
*
*     30 Aug 2000: First version of s2tols.
*     12 Nov 2000: Current version of s2tols.
*     =================================================================
      logical
     &     NewFac, NewUpd
      integer
     &     iPrint, iSumm, TPivot
      double precision
     &     eLmax1, eLmax2
*     ------------------------------------------------------------------
      integer            TPP,        TCP
      parameter         (TPP    = 0, TCP    = 1)
      integer            DefTol,     RedTol,     MinTol
      parameter         (DefTol = 0, RedTol = 1, MinTol = 2)
      double precision   tolTPP,          tolTCP
      parameter         (tolTPP = 1.1d+0, tolTCP = 4.0d+0)
      double precision   tolUpd
      parameter         (tolUpd = 1.1d+0)
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      TPivot    = iw(156) ! 0(1) LU threshold partial(complete) pivoting

      eLmax1    = rw(151) ! max allowable L-multiplier in factor
      eLmax2    = rw(152) ! max allowable L-multiplier in update

      NewTol    = .false.
      NewFac    = .false.
      NewUpd    = .false.

      if (mode .eq. DefTol) then
*        ---------------------------------------------------------------
*        Set the default LU Factor tol and LU Update tol.
*        ---------------------------------------------------------------
         if (     TPivot .eq. TPP) then
            eLmax1 =   5.0d+0
            eLmax2 =   4.0d+0
         else if (TPivot .eq. TCP) then
            eLmax1 = 100.0d+0
            eLmax2 =   4.0d+0
         end if
         NewFac = .true.
         NewUpd = .true.

      else if (mode .eq. RedTol) then
*        ---------------------------------------------------------------
*        Reduce LU Factor tol and LU Update tol if necessary.
*        (Default values are 100.0 and 10.0 for  LP)
*                              5.0 and  5.0 for NLP)
*        ---------------------------------------------------------------
         if (TPivot .eq. TPP) then
            if (eLmax1 .ne. tolTPP) then
               eLmax1 = max( tolTPP, sqrt( eLmax1 ) )
               NewFac = .true.
            end if
         else if (TPivot .eq. TCP) then
            if (eLmax1 .ne. tolTCP) then
               eLmax1 = max( tolTCP, sqrt( eLmax1 ) )
               NewFac = .true.
            end if
         end if

         if (eLmax2 .ne. tolUpd) then
            eLmax2 = max( tolUpd, sqrt( eLmax2 ) )
            NewUpd = .true.
         end if
      else if (mode .eq. MinTol) then
*        ---------------------------------------------------------------
*        Set  LU Factor tol and LU Update tol to stringent values.
*        ---------------------------------------------------------------
         if (TPivot .eq. TPP) then
            if (eLmax1 .ne. tolTPP) then
               eLmax1 = tolTPP
               NewFac = .true.
            end if
         else if (TPivot .eq. TCP) then
            if (eLmax1 .ne. tolTCP) then
               eLmax1 = tolTCP
               NewFac = .true.
            end if
         end if

         if (eLmax2 .ne. tolUpd) then
            eLmax2 = tolUpd
            NewUpd = .true.
         end if
      end if


      if ( NewFac ) then
         NewTol = .true.
         if (mode .eq. DefTol  .or.  mode .eq. MinTol) then
            if (TPivot .eq. TPP) then
               if (iPrint .gt. 0) write(iPrint, 1000) itn, eLmax1
               if (iSumm  .gt. 0) write(iSumm , 1000) itn, eLmax1
            else if (TPivot .eq. TCP) then
               if (iPrint .gt. 0) write(iPrint, 1010) itn, eLmax1
               if (iSumm  .gt. 0) write(iSumm , 1010) itn, eLmax1
            end if
         else
            if (TPivot .eq. TPP) then
               if (iPrint .gt. 0) write(iPrint, 1100) itn, eLmax1
               if (iSumm  .gt. 0) write(iSumm , 1100) itn, eLmax1
            else if (TPivot .eq. TCP) then
               if (iPrint .gt. 0) write(iPrint, 1110) itn, eLmax1
               if (iSumm  .gt. 0) write(iSumm , 1110) itn, eLmax1
            end if
         end if
      end if

      if ( NewUpd ) then
         NewTol = .true.
         if (mode .eq. DefTol  .or.  mode .eq. MinTol) then
            if (TPivot .eq. TPP) then
               if (iPrint .gt. 0) write(iPrint, 2000) itn, eLmax2
               if (iSumm  .gt. 0) write(iSumm , 2000) itn, eLmax2
            else if (TPivot .eq. TCP) then
               if (iPrint .gt. 0) write(iPrint, 2010) itn, eLmax2
               if (iSumm  .gt. 0) write(iSumm , 2010) itn, eLmax2
            end if
         else
            if (TPivot .eq. TPP) then
               if (iPrint .gt. 0) write(iPrint, 2100) itn, eLmax2
               if (iSumm  .gt. 0) write(iSumm , 2100) itn, eLmax2
            else if (TPivot .eq. TCP) then
               if (iPrint .gt. 0) write(iPrint, 2110) itn, eLmax2
               if (iSumm  .gt. 0) write(iSumm , 2110) itn, eLmax2
            end if
         end if
      end if

      rw(151) = eLmax1
      rw(152) = eLmax2

      return

 1000 format(' Itn', i7,
     &       ' LU partial  pivoting factor tol    ', f10.2)
 1010 format(' Itn', i7,
     &       ' LU complete pivoting factor tol    ', f10.2)
 1100 format(' Itn', i7,
     &       ' LU partial  pivoting factor tol now', f10.2)
 1110 format(' Itn', i7,
     &       ' LU complete pivoting factor tol now', f10.2)
 2000 format(' Itn', i7,
     &       ' LU partial  pivoting update tol    ', f10.2)
 2010 format(' Itn', i7,
     &       ' LU complete pivoting update tol    ', f10.2)
 2100 format(' Itn', i7,
     &       ' LU partial  pivoting update tol now', f10.2)
 2110 format(' Itn', i7,
     &       ' LU complete pivoting update tol now', f10.2)

      end ! of s2tols

