*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
*     file  sn55qp.f
*
*     s5Bswp   s5chkp   s5chzq   s5fixS   s5getp   s5Hfac   s5Hx
*     s5Hx1    s5HZ     s5QP     s5QPfg   s5QPit   s5Rcol   s5rg
*     s5Rsng
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5Bswp( gotR, lenR, m, mBS, n, nb, nS,
     &     jBSr, LUreq, pivot, 
     &     ne, nlocA, locA, indA, Acol,
     &     hs, kBS, blBS, buBS, R, xBS, 
     &     y, y1, y2, iw, leniw, rw, lenrw )

      implicit
     &     none
      logical
     &     gotR
      integer
     &     lenR, m, mBS, n, nb, ne, nlocA, nS, jBSr, LUreq, leniw,
     &     lenrw, hs(nb), kBS(mBS), locA(nlocA), indA(ne), iw(leniw)
      double precision
     &     pivot, Acol(ne), R(lenR), blBS(mBS), buBS(mBS), xBS(mBS),
     &     y(nb), y1(nb), y2(nb), rw(lenrw)

*     ==================================================================
*     s5Bswp is called if the last superbasic is a slack.
*     The slack is swapped with some nonslack in the basis. 
*     This preserves the property that slacks are never superbasic.
*
*     08 Nov 1996: First version of s5Bswp.
*     15 Sep 2000: Current version.
*     ==================================================================
      integer
     &     inform, iq, jq, k, kp, m1, nBS
      double precision
     &     eps0, yk, ymax, tmp
*     ------------------------------------------------------------------
      integer            WithB,      WithBt   
      parameter         (WithB  = 1, WithBt = 2)
      integer            Transp
      parameter         (Transp = 1)
      double precision   zero,            one
      parameter         (zero   = 0.0d+0, one = 1.0d+0)
      integer            LUmod
      parameter         (LUmod  = 216) ! number of LU mods
*     ------------------------------------------------------------------
      eps0      = rw(  2) ! eps**(4/5)

      LUreq     = 0
      nBS       = m  + nS
      jq        = kBS(nBS)
      iq        = jq - n

*     Solve  B*y = eq.
*     The altered  y1  satisfies  L*y1 = eq. 
*     It is used later to modify L and U.

      call dload ( m, zero, y1, 1 )
      y1(iq) = - one
      call s2Bsol( WithB, inform, m, y1, y, iw, leniw, rw, lenrw )

*     Find the largest pivot.
*     Beware -- we must not choose any slacks!

      kp     = 0
      ymax   = zero
      do k = 1, m
         if (kBS(k) .le. n) then
            yk  = abs( y(k) )
            if (ymax .lt. yk) then
               ymax = yk
               kp   = k
            end if
         end if
      end do

      if (kp .eq. 0) then       ! This can never happen!
         write (*, 1100)        ! More famous last words.
         stop
      end if

*     Solve  B'*y = ep.

      call dload ( m, zero, y2, 1 )
      y2(kp) = one
      call s2Bsol( WithBt, inform, m, y2, y, iw, leniw, rw, lenrw )

      if ( gotR ) then

*        Set yS = S'*y.

         m1     = m  + 1
         call s2Bprd( Transp, eps0, n, nS, kBS(m1),
     &        ne, nlocA, locA, indA, Acol,
     &        one, y, m, zero, y(m1), nS ) 
         pivot  = y(nBS)
         y(nBS) = one + pivot
         call dscal ( nS, (-one/pivot), y(m+1), 1 )
         call s6Rswp( nS, lenR, R, y2, y(m+1), nS )
      end if

      jBSr       = kBS(kp)
      hs(jBSr)   = 2
      hs(jq)     = 3
      kBS (nBS)  = jBSr
      kBS (kp)   = jq

      tmp        = blBS(kp)
      blBS(kp)   = blBS(nBS)
      blBS(nBS)  = tmp 

      tmp        = buBS(kp)
      buBS(kp)   = buBS(nBS)
      buBS(nBS)  = tmp 

      tmp        = xBS(kp)
      xBS(kp)    = xBS(nBS)
      xBS(nBS)   = tmp 

*     Update the LU factors.

      iw(LUmod)  = iw(LUmod) + 1
      call s2Bmod( inform, kp, m, y1, iw, leniw, rw, lenrw )

      if (inform .eq. -1) LUreq = 9 ! Singular U.
      if (inform .eq.  2) LUreq = 8 ! Growth in U.
      if (inform .eq.  7) LUreq = 7 ! Insufficient free memory.

      return

 1100 format(' XXX  s5Bswp:  No maximum pivot!!')

      end ! of s5Bswp 

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5chkp( inform, nBS, jqSave, kBS, gtp, pBS, iw, leniw )

      implicit
     &     none
      integer
     &     inform, nBS, jqSave, leniw, kBS(nBS), iw(leniw)
      double precision
     &     gtp, pBS(nBS)

*     ==================================================================
*     s5chkp  makes  pBS  a feasible direction.
*
*     16 Jun 1995: First version of s5chkp written by PEG.
*     21 Apr 1999: Current version.
*     ==================================================================
      integer
     &     iPrint, iSumm, kSave, j, jq, k
      double precision
     &     pSave   
*     ------------------------------------------------------------------
      double precision   zero,          one
      parameter         (zero = 0.0d+0, one = 1.0d+0)
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file

      inform    = 0

*     ------------------------------------------------------------------
*     Find the element of  pBS  corresponding to the most recently freed
*     variable. Usually, it will be pBS(nBS).
*     ------------------------------------------------------------------
      jq    = abs(jqSave)

      kSave = 0
      do k =  nBS, 1, -1
         j = kBS(k)
         if (j .eq. jq) then
            kSave = k
            go to 100
         end if
      end do

*     ------------------------------------------------------------------
*     Choose the sign of  pBS  so that the most recently freed
*     variable continues to increase or decrease.
*     ------------------------------------------------------------------
  100 if (kSave .gt. 0) then
         pSave = pBS(kSave)

         if (jqSave .lt. 0  .and.  pSave .gt. zero  .or.
     &       jqSave .gt. 0  .and.  pSave .lt. zero      ) then
            call dscal ( nBS, (-one), pBS, 1 )
            gtp  = - gtp
         end if

         if (gtp .gt. zero) then
*           ------------------------------------------------------------
*           Looks as though the sign of gtp cannot be relied upon.
*           In later versions we'll fix this variable.
*           For now, we just print a warning and stop.
*           ------------------------------------------------------------
            if (iSumm  .gt. 0) write(iSumm , 1000) gtp
            if (iPrint .gt. 0) write(iPrint, 1000) gtp
            inform = 1
         end if
      else
*        ---------------------------------------------------------------
*        Couldn't find the index of the most recently freed variable.
*        This should never happen!
*        ---------------------------------------------------------------
         if (iSumm  .gt. 0) write(iSumm , 9000) jqSave
         if (iPrint .gt. 0) write(iPrint, 9000) jqSave
      end if

      return

 1000 format(' XXX  Small directional derivative ', 1p, e9.1 )
 9000 format(' XXX  s5chkp.  kSave not found. jqSave = ', i5 )

      end ! of s5chkp

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5chzq( m, mBS, n, nb, nS, kBSq, pivot,
     &     ne, nlocA, locA, indA, Acol,
     &     kBS, bl, bu, xBS, y, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     m, mBS, n, nb, ne, nlocA, nS, kBSq, leniw, lenrw,
     &     locA(nlocA), indA(ne), kBS(mBS), iw(leniw)
      double precision
     &     pivot, Acol(ne), bl(nb), bu(nb), xBS(mBS), y(mBS), rw(lenrw)

*     ==================================================================
*     s5chzq  selects a superbasic to replace the kp-th basic variable.
*     On entry,  y  contains the kp-th row of B(inverse).
*     On exit, pivot and  y(m+1), ..., y(m+nS) define the S-part of
*     the modifying vector w.
*
*     01 Dec 1991: First version based on Minos routine m7chzq.
*     21 Apr 1999: Current version of s5chzq.
*     ==================================================================
      integer
     &     iPrint, j, k, m1, idamax
      double precision
     &     d1, d2, dpiv, eps0, tol, tolpiv, xj 
*     ------------------------------------------------------------------
      double precision   zero,          point1,          one
      parameter         (zero = 0.0d+0, point1 = 0.1d+0, one = 1.0d+0)
      integer            Transp
      parameter         (Transp = 1)
*     ------------------------------------------------------------------
      eps0      = rw(  2) ! eps**(4/5)
      tolpiv    = rw( 60) ! excludes small elements of y.
      iPrint    = iw( 12) ! Print file

*     Set yS = 0 -  S'*y.

      m1        = m  + 1
      call s2Bprd( Transp, eps0, n, nS, kBS(m1),
     &     ne, nlocA, locA, indA, Acol,
     &     (-one), y, m, zero, y(m1), nS ) 

      kBSq   = m  +  idamax( nS, y(m1), 1 )
      pivot  = abs( y(kBSq) )

*     Exit if the pivot is too small.

      if (pivot .lt. tolpiv) then
         if (iPrint .gt. 0) then
            write(iPrint, '(/ a, 1p, e11.1)')
     &         ' XXX  s5chzq.  Max pivot is too small:', pivot
         end if
         kBSq   = - (m + nS)
      else

*        Choose one away from its bounds if possible.

         tol    =   point1*pivot
         dpiv   = - one

         do k = m1, m+nS
            if (abs( y(k) ) .ge. tol) then
               j     = kBS(k)
               xj    = xBS(k)
               d1    = xj    - bl(j)
               d2    = bu(j) - xj
               d1    = min( abs( d1 ), abs( d2 ) )
               if (dpiv .le. d1) then
                  dpiv  = d1
                  kBSq  = k
               end if
            end if
         end do

         pivot   = - y(kBSq)

      end if ! pivot .ge. tolpiv

      end ! of s5chzq

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5fixS( Task,
     &     m, maxS, mBS, n, nb, nS, hs, kBS,
     &     bl, bu, blBS, buBS, x, xBS )

      implicit
     &     none
      integer
     &     Task, m, maxS, mBS, n, nb, nS, hs(nb), kBS(mBS)
      double precision
     &     bl(nb), bu(nb), x(nb), blBS(mBS), buBS(mBS), xBS(mBS)

*     ==================================================================
*     s5fixS   concerns temporary bounds on superbasic variables.
*     If Task = Fix,  s5fixS sets hs(j) = -1, 0, 1 or 4 for certain
*     superbasic variables.
*
*     If Task = Free, s5fixS changes -1 values to hs(j) = 2.
*
*     30 May 1995: First version of s5fixS.
*     Sep 17 2000: Current version.
*     ==================================================================
      integer
     &     j, k
*     ------------------------------------------------------------------
      integer            Fix,     Free
      parameter         (Fix = 0, Free = 1)
*     ------------------------------------------------------------------
      nS = 0

      if (Task .eq. Fix) then
*        ---------------------------------------------------------------
*        Change superbasic hs(j) to be temporarily fixed.
*        ---------------------------------------------------------------
         do j = 1, nb
            if (hs(j) .eq. 2) then
               if (bl(j) .eq. bu(j)) then
                  hs(j) =  4
               else if (x(j) .le. bl(j)) then
                  hs(j) =  0
               else if (x(j) .ge. bu(j)) then
                  hs(j) =  1
               else
                  hs(j) = -1
               end if
            end if
         end do

      else if (Task .eq. Free) then
*        ---------------------------------------------------------------
*        Free the temporarily fixed structurals.
*        Load the superbasic variables/bounds into xBS, blBS, buBS.
*        ---------------------------------------------------------------
         j = 1
*+       while (j .le. n  .and.  nS .lt. maxS) do
  100    if    (j .le. n  .and.  nS .lt. maxS) then
            if (hs(j) .eq. -1) then
               nS      = nS + 1
               k       = m  + nS
               hs(j)   = 2
               xBS (k) = x(j) 
               blBS(k) = bl(j) 
               buBS(k) = bu(j)
               kBS (k) = j
            end if
            j  = j + 1
            go to 100
*+       end while
         end if
      end if

      end ! of s5fixS

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5getp( ObjPhs, gotR, PosDef,
     &     lenR, n, R, g, p, gp, pHp )

      implicit
     &     none
      logical
     &     ObjPhs, gotR, PosDef
      integer
     &     lenR, n
      double precision
     &     gp, pHp, R(lenR), g(n), p(n)

*     ==================================================================
*     s5getp  computes a search direction  p  for the superbasic
*     variables, using the current reduced gradient  g.
*
*     27 Jul 2000: Current version.
*     ==================================================================
      integer
     &     lR1, lR
      double precision
     &     ddot
*     ------------------------------------------------------------------
      integer            WithR,      WithRt
      parameter         (WithR  = 0, WithRt = 1)
      double precision   zero,          one
      parameter         (zero = 0.0d+0, one = 1.0d+0)
*     ------------------------------------------------------------------

      if (ObjPhs  .and.  gotR) then
*        ---------------------------------------------------------------
*        Compute either the Newton direction of a direction of zero
*        or negative curvature.
*        ---------------------------------------------------------------
         if ( PosDef ) then
            call dcopy ( n,         g, 1, p, 1 )
            call s6Rsol( WithRt, lenR, n, R, p )
            pHp  = ddot  ( n, p, 1, p, 1 )
            call s6Rsol( WithR , lenR, n, R, p )
         else
            lR1  = n*(n-1)/2
            lR   = lR1 + n
            pHp  = R(lR)**2
            call dcopy ( n-1, R(lR1+1), 1, p, 1 )
            if (n .gt. 1) then
               call s6Rsol( WithR ,  lenR, n-1, R, p )
            end if
            p(n) = - one
         end if
      else 
*        ---------------------------------------------------------------
*        Direction of steepest-descent.
*        ---------------------------------------------------------------
         call dcopy ( n, g, 1, p, 1 )
         pHp = zero
      end if ! ObjPhs and gotR

*     ------------------------------------------------------------------
*     Fix the sign of p.
*     ------------------------------------------------------------------
      call dscal ( n, (-one), p, 1 )
      gp  = ddot  ( n, g, 1, p, 1 )

      end ! of s5getp

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5Hfac( eigH, itn, iError, lenR, m,
     &     maxR, mBS, nb, nS, Hdmax, hs, kBS, perm, 
     &     bl, bu, blBS, buBS, x, xBS, R, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     eigH, iError, itn, leniw, lenrw, lenR, m, maxR, mBS, nb, nS,
     &     hs(nb), kBS(mBS), perm(maxR), iw(leniw)
      double precision
     &     Hdmax, blBS(mBS), buBS(mBS), xBS(mBS), bl(nb), bu(nb), x(nb),
     &     R(lenR), rw(lenrw)

*     ==================================================================
*     s5Hfac  factorizes the reduced Hessian Z'HZ.
*
*     13 Oct 1992: First version based on Qpsol routine Qpcrsh.
*     15 Oct 1994: Dependent columns fixed at their current value.
*     15 Oct 2000: Current version of s5Hfac.
*     ==================================================================
      integer
     &     inform, iPrint, j, jmax, jS, k, kmax, ksave, nSsave,
     &     pivot, rankHz
      double precision
     &     dpiv, eps, Hcndbd, Hdmin, s
*     ------------------------------------------------------------------
      integer            INDEF,      SEMDEF,     POSDEF
      parameter         (INDEF = -1, SEMDEF = 0, POSDEF  = 1)
      integer            NoPiv,     Piv
      parameter         (NoPiv = 0, Piv    = 1)
      double precision   one
      parameter         (one   = 1.0d+0)
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      Hcndbd    = rw( 85) ! bound on the condition of Hz

*     ==================================================================
*     Compute the Cholesky factor of the reduced Hessian.
*     ==================================================================
      eps   = max ( Hdmax, one )/Hcndbd
      Hdmin = max ( Hdmax/Hcndbd, eps )

      if (eigH .eq. POSDEF) then
         pivot = NoPiv
      else if (eigH .eq. INDEF  .or.  eigH .eq. SEMDEF) then
         pivot =   Piv
      end if

      call s6chol( pivot,
     &     inform, nS, Hdmin, dpiv, rankHz, perm, lenR, R )

      if (pivot .eq. Piv) then
*        -----------------------
*        Apply any interchanges.
*        -----------------------
         do j = 1, min(rankHz,nS)
            jmax = perm(j)
            if (jmax .gt. j) then
               kmax       = m + jmax
               k          = m + j

               ksave      = kBS(kmax)
               kBS(kmax)  = kBS(k)
               kBS(k)     = ksave

               s          = xBS(kmax)
               xBS(kmax)  = xBS(k)
               xBS(k)     = s

               s          = blBS(kmax)
               blBS(kmax) = blBS(k)
               blBS(k)    = s

               s          = buBS(kmax)
               buBS(kmax) = buBS(k)
               buBS(k)    = s
            end if
         end do
      end if 

      if (dpiv .ge. Hdmin) then
*        ---------------------------------------
*        H  is positive definite.
*        ---------------------------------------
         iError = 0

      else if (dpiv .lt. (-Hdmin)) then
*        ---------------------------------------
*        H  appears to be indefinite.
*        ---------------------------------------
         iError = 6

      else 
*        ---------------------------------------
*        H  appears to be positive semidefinite.
*        rankHz < nS
*        ---------------------------------------
         if (eigH .eq. POSDEF) then
            iError = 6
         else
            iError = 0

            if (iPrint .gt. 0)
     &         write(iPrint, 9000) itn, nS-rankHz, Hdmin

            nSsave = nS
            do jS = rankHz+1, nSsave
               k  = m + jS
               j  = kBS(k)

*              Make variable  j  nonbasic (it is already feasible).
*              hs(j) = -1 means x(j) is strictly between its bounds.

               if      (x(j) .le. bl(j)) then
                  x(j) =  bl(j)
                  hs(j) =  0
               else if (x(j) .ge. bu(j)) then
                  x(j) =  bu(j)
                  hs(j) =  1
               else
                  hs(j) = -1
               end if
               if (bl(j) .eq. bu(j)) hs(j) = 4
            
               nS = nS - 1
            end do
            nS = min( nS, rankHz )
         end if ! rankHz < nS
      end if

      return

 9000 format(' Itn', i7, ' Reduced Hessian appears to have ',
     &         i6, ' small eigenvalues.  PD  tol = ', e14.2 )

      end ! of s5Hfac

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5Hx  ( Hprod, Hcalls, nnH,
     &     iHvar, jHvar, lenH, neH, H,
     &     x, Hx, Status, 
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      external
     &     Hprod
      integer
     &     Status, neH, Hcalls, lenH, nnH,
     &     lencu, leniu, lenru, lencw, leniw, lenrw,
     &     iHvar(lenH), jHvar(lenH), iu(leniu), iw(leniw)
      double precision
     &     H(lenH), Hx(nnH), x(nnH), ru(lenru), rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     s5Hx  computes the product  Hx  and scales it. 
*
*     15 Mar 1999: First   version of s5Hx
*     27 Feb 2000: Current version
*     ==================================================================
      call s5Hx1 ( nnH, iHvar, jHvar, lenH, neH, H, x, Hx ) 

      Hcalls = Hcalls + 1

      end ! of s5Hx

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5Hx1 ( nnH, iHvar, jHvar, lenH, neH, H, x, Hx )

      implicit
     &     none
      integer
     &     nnH, lenH, neH, iHvar(lenH), jHvar(lenH)
      double precision
     &     H(neH), Hx(nnH), x(nnH)

*     ==================================================================
*     s5Hx1  computes the product  Hx.
*
*     15 Mar 1999: First   version of s5Hx1
*     27 Feb 2000: Current version
*     ==================================================================
      integer
     &     i, j, k
*     ------------------------------------------------------------------
      double precision   zero
      parameter         (zero = 0.0d+0)
*     ------------------------------------------------------------------
      if (neH .eq. 0) return

      call dload ( nnH, zero, Hx, 1 ) 

      do k = 1, neH
         i = iHvar(k)
         j = jHvar(k)

         Hx(i) = Hx(i) + H(k)*x(j)

         if (i .ne. j) then
            Hx(j) = Hx(j) + H(k)*x(i)
         end if
      end do

      end ! of s5Hx1

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5HZ  ( Hprod, Hprod1, lenR, minimz,
     &     m, mBS, n, nb, nnH, nS, Hcalls,
     &     ne, nlocA, locA, indA, Acol,
     &     iHvar, jHvar, lenH, neH, H,
     &     Hdmax, kBS, R, v, w, y, 
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      external
     &     Hprod, Hprod1
      integer
     &     minimz, Hcalls, nS, lenH, lenR, m, mBS, n, nb, ne,
     &     neH, nlocA, nnH, lencu, leniu, lenru,
     &     lencw, leniw, lenrw, locA(nlocA), indA(ne), iHvar(lenH),
     &     jHvar(lenH), kBS(mBS), iu(leniu), iw(leniw)
      double precision
     &     Hdmax, Acol(ne), H(lenH), R(lenR), y(nb), v(nb),
     &     w(nb), ru(lenru), rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     s5HZ    computes the reduced Hessian and loads it by columns into
*     the upper triangle  R.
*
*     On entry, nnH > 0.
*
*     13 Oct 1992: First version based on Qpsol routine Qpcrsh.
*     15 Oct 1994: Dependent columns fixed at their current value.
*     21 Oct 2000: Current version.
*     ==================================================================
      integer
     &     i, inform, j, jc, jq, jS, k, l, nBS, Status
      double precision
     &     eps0, sgnObj
*     ------------------------------------------------------------------
      integer            Transp
      parameter         (Transp = 1)
      integer            WithB,      WithBt   
      parameter         (WithB  = 1, WithBt = 2)
      integer            Gather,     Scattr
      parameter         (Gather = 0, Scattr = 1)
      double precision   zero,           half,          one
      parameter         (zero  = 0.0d+0, half = 0.5d+0, one = 1.0d+0)
*     ------------------------------------------------------------------
      eps0      = rw(  2)

      if (nS .eq. 0) return

      Status    = 0
      nBS       = m + nS
      Hdmax     = zero
      sgnObj    = minimz

      l         = 1
*     ------------------------------------------------------------------
*     Main loop to find a column of Z'HZ.
*     ------------------------------------------------------------------
      do jS = 1, nS
*        ---------------------------------------------------------------
*        Get the nonlinear elements of the column of Z. Store them in w.
*        ---------------------------------------------------------------
*        Find y such that B y = column jq.
*        Expand the nonlinear part of y into w.

         jq  = kBS(m+jS)
         call s2unpk( jq, m, n, ne, nlocA, locA, indA, Acol, w )
         call s2Bsol( WithB, inform, m, w, y, iw, leniw, rw, lenrw )
         call s2copy( Scattr, nnH, m, kBS, (-one), w, y )
         if (jq .le. nnH) w(jq) = one

*        Multiply the column  w  by  H.

         if (nnH .gt. 0) then
            call Hprod ( Hprod1, Hcalls, nnH,
     &           iHvar, jHvar, lenH, neH, H,
     &           w, v, Status,
     &           cu, lencu, iu, leniu, ru, lenru, 
     &           cw, lencw, iw, leniw, rw, lenrw )
         end if

         if (minimz .lt. 0) then
            call dscal ( nnH, sgnObj, v, 1 )
         end if

*        ------------------------------------------------------------
*        Gather v ( = Hx) into w =vBS.
*        Compute  v = Z' w.
*        ------------------------------------------------------------
         call s2copy( Gather, nnH, nBS, kBS, one, v, w )

*        Solve  B' vB = wB  and  form  wS = wS - S' vB.

         call s2Bsol( WithBt, inform, m, w, v, iw, leniw, rw, lenrw )
         call dcopy ( m, v, 1, w, 1 )

         call s2Bprd( Transp, eps0, n, nS, kBS(m+1),
     &        ne, nlocA, locA, indA, Acol,
     &        (-one), w, m, one, w(m+1), nS ) 

*        ------------------------------------------------------
*        Store w in the jS-th row and column of r. 
*        The column elements are symmetrized. 
*        ------------------------------------------------------
         do i = 1, jS-1
            k    = m + i
            R(l) = half*(R(l) + w(k))
            l    = l + 1
         end do

         jc = l 
         do j  = jS, nS
            k  = m + j
            R(jc) = w(k)
            jc = jc + j
         end do
         Hdmax = max( Hdmax, abs(R(l)) )
         l     = l + 1
      end do

      end ! of s5HZ

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5QP  ( Prob, contyp, Elastc, iError, subopt,
     &     Hprod, Hprod1, QPlog, gotR, needLU, typeLU, needx,
     &     lenR, m, maxS, mBS, n, nb, nDegen, Hcalls,
     &     ngQP0, ngQP, nGobj0, nGobj, nnH0, nnH,
     &     nS, mxitQP, itQP, itn, lEmode, lvlInf, lPrint, 
     &     minimz, iObj, sclObj, ObjAdd, ObjQP,
     &     tolFP, tolQP, tolx, nInf, sInf, wtInf,
     &     piNorm, rgNorm, ne, nlocA, locA, indA, Acol,
     &     iHvar, jHvar, lenH, neH, H,
     &     hElast, hEstat, hfeas, hs, kBS,
     &     Ascale, bl, bu, blBS, buBS,
     &     gBS, Gobj, gQP, Hdx, pBS, pi, R, rc, rg,
     &     nrhs0, nrhs, rhs, lenx0, nx0, x0, x, xBS, xFix,
     &     iy, iy1, y, y1, y2,
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      logical
     &     Elastc, gotR, needLU, needx
      character*20
     &     contyp
      external
     &     Hprod, Hprod1, QPlog
      integer
     &     Hcalls, iError, itQP, itn, iObj, lenH, lencu, leniu, lenru,
     &     lencw, leniw, lenrw, lenR, lenx0, lEmode, lvlInf, lPrint,
     &     m, maxS, mBS, minimz, mxitQP, nrhs0, nrhs, ngQP0, ngQP,
     &     nGobj0, nGobj, n, nb, ne, neH, nlocA, nInf, nnH0, nnH, nS, 
     &     nDegen, nx0, Prob, subopt, typeLU, locA(nlocA), indA(ne),
     &     iHvar(lenH), jHvar(lenH), hElast(nb), hEstat(nb), hs(nb),
     &     kBS(mBS), hfeas(mBS), iy(nb), iy1(nb), iu(leniu), iw(leniw)
      double precision
     &     sclObj, ObjAdd, ObjQP, tolFP, tolQP, tolx,
     &     sInf, wtInf, piNorm, rgNorm, Acol(ne), Ascale(nb),
     &     bl(nb), bu(nb), rc(nb), blBS(mBS), buBS(mBS),
     &     gBS(mBS), Gobj(*), gQP(ngQP0), Hdx(nnH0), H(lenH), pBS(mBS),
     &     pi(m), rhs(nrhs0), R(lenR), rg(maxS), x0(lenx0), x(nb),
     &     xBS(mBS), xFix(nb), y(nb), y1(nb), y2(nb),
     &     ru(lenru), rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     s5QP   solves a linear or quadratic program.
*     The problem type can be:
*       Prob = 0 FP   feasible point only
*       Prob = 1 LP   LP problem
*       Prob = 2 QP   QP problem
*       Prob = 3 FPE  feasible point for equalities only
*       Prob = 4 FPS  feasible point for QP subProblem
*       Prob = 5 QPS  QP subproblem
*       Prob = 6 QPP  FP subproblem with proximal point objective
*
*     ngQP = max( nnH, nGobj )
*
*     The optimization can pass through the following phases:
*
*       Phase 1               find a feasible point for all variables
*
*       Elastic Phase 1       make the non-elastic variables feasible
*                             while allowing infeasible elastics
*
*       Phase 2               minimize the objective
*
*       Elastic Phase 2       minimize a composite objective while
*                             keeping the non-elastics feasible
*
*                             In this phase, lvlInf means the following:
*
*                 lvlInf = 0  zero     weight on the infeasibilities
*                                      (infeasibillities are ignored)
*                          1  finite   weight on the infeasibilities
*                          2  infinite weight on the infeasibilities
*                                      (the objective is ignored)
*
*     The array kBS is a permutation on the column indices. 
*     kBS(1  :m )    holds the col. indices of the basic variables.
*     kBS(m+1:m+nS)  holds the col. indices of the superbasic variables.
*                    These nS columns indices must have hs(j) = 2.
*
*     On exit:
*        iError       Status
*        ------       ------
*           0         QP solution found
*           1         QP is infeasible
*           2         QP is unbounded
*           3         Too many iterations
*           4         Weak QP minimizer 
*           5         Too many superbasics
*           6         QP Hessian not positive semidefinite
*          11         Z'g could not be made sufficiently small
*
*     30 Sep 1991: First version of s5qp  based on Qpsol routine qpcore.
*     29 Oct 1993: QP objective computed separately.
*     19 May 1995: Bordered Hessian updated.
*     30 Jul 1995: Border updates removed.
*     04 Jan 1996: Positive semi-definite H treated correctly.
*     20 Jul 1996: Slacks changed to be the row value.
*     09 Aug 1996: First Min Sum version.
*     15 Jul 1997: Thread-safe version.
*     02 Feb 1998: Piecewise linear line search added.
*     07 Nov 1998: Explicit Hessian option added.
*     24 Dec 1999: Sub-optimization option added.
*     11 Nov 2000: Current version of s5QP.
*     ==================================================================
      logical
     &     bndswp, checkx, deadpt, optiml, statpt,
     &     feasbl, getFP, giveup, gotE, gotgQP, gotH, incres, needLM,
     &     needpi, newSB, NewTol, chkFea, jstFea, prtFea, rgfail,
     &     newB, newLU, ObjPhs, usegQP, Unbndd, weak, QPdone,
     &     PosDef, Singlr, solvLP, solvQP, Prnt1, Prnt10
      integer
     &     eigH, iPrint, iSumm, inform, itnfix, itnlim, jq, jBq, jBr,
     &     jBSr, jSq, jSr, jqSave, kchk, kfac, ksav, kDegen, kObj, kp,
     &     kPrc, kPrPrt, lRs, lines1, lines2, lenL0, lenL, lenU0, lenU,
     &     LUitn, LUmod, LUsiz0, LUmax, LUreq, maxR, MnrHdg,
     &     mWSmod, nBS, nElast, nFac, nfmove, nFreez, nInfE,
     &     nonOpt, nSmax, nSwap, nUncon, Status, toldj1, toldj2,
     &     toldj3, nfix(2)
      double precision
     &     Bgrwth, Bold, dnrm1s, eps0, factor, featol, condHz, djq,
     &     djqPrt, dRmax, dRmin, dRsq, hdmax, normdx, Obj, ObjPrt,
     &     ObjSlk, plInfy, pivot, Rmax, rowerr, sgnObj, sInfE, step,
     &     tolx0, tolinc, weight
*     ------------------------------------------------------------------
      double precision   zero,            one
      parameter         (zero   = 0.0d+0, one   = 1.0d+0)
      integer            Intern,     Extern
      parameter         (Intern = 0, Extern = 1)
      integer            mUncon,     Check        
      parameter         (mUncon = 1, Check  = 1)
      integer            WithB
      parameter         (WithB  = 1)
      integer            FP,    LP,    QP,    FPE,    FPS,    QPS
      parameter         (FP =0, LP =1, QP =2, FPE =3, FPS =4, QPS =5)
      integer            QPP
      parameter         (QPP=6)
      integer            BS,     BT   
      parameter         (BS = 1, BT = 2)
      integer            Init,     Optml,     Cycle
      parameter         (Init = 0, Optml = 1, Cycle = 2)
      integer            Gather
      parameter         (Gather = 0)
      integer            PSDEF,      PDEF
      parameter         (PSDEF  = 0, PDEF  = 1)
      integer            RedTol,     MinTol
      parameter         (RedTol = 1, MinTol = 2)

      parameter         (lenL0  = 171) ! size of L0
      parameter         (lenU0  = 172) ! size of initial  U
      parameter         (lenL   = 173) ! size of current  L
      parameter         (lenU   = 174) ! size of current  U
      parameter         (toldj1 = 184) ! phase 1 dj tol for p.p.
      parameter         (toldj2 = 185) ! phase 2 dj tol for p.p.
      parameter         (toldj3 = 186) ! current optimality tol
      parameter         (kObj   = 205) ! xBS(kObj) is the obj. slack
      parameter         (LUitn  = 215) ! itns since last factorize
      parameter         (LUmod  = 216) ! number of LU mods
      parameter         (MnrHdg = 223) ! >0 Mnr heading for iPrint
*     ------------------------------------------------------------------
      eps0      = rw(  2) ! eps**(4/5)
      plInfy    = rw( 70) ! definition of plus infinity.

      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file

      maxR      = iw( 52) ! max columns of R.
      kchk      = iw( 58) ! check (row) frequency
      kfac      = iw( 59) ! factorization frequency
      ksav      = iw( 60) ! save basis map
      kDegen    = iw( 63) ! max. expansions of featol
      itnlim    = iw( 89) ! limit on total iterations
      mWSmod    = iw( 95) ! # of working set changes
      eigH      = iw(200) ! -1,0,1 for indef, psd and pdef H
      nFac      = iw(210) ! # of LU factorizations

      if (nFac .gt. 0) then
         LUsiz0    = iw(lenL0) + iw(lenU0)
         LUmax     = 2*LUsiz0
      end if

      gotH   = nnH    .gt. 0 
      gotgQP = ngQP   .gt. 0 

      Prnt1  = iPrint .gt. 0  .and.  lPrint .ge.  1
      Prnt10 = iPrint .gt. 0  .and.  lPrint .ge. 10

*     ------------------------------------------------------------------
*     s5QP operates in either ``Normal'' or ``Elastic'' mode.
*     Everything is normal unless a weighted sum is being minimized or
*     the constraints are infeasible.
*     The logical feasbl refers to the non-elastic variables.
*     Note that feasbl can be false while in elastic mode. 
*     wtInf  is the optional parameter Infeasibility Weight.
*     ------------------------------------------------------------------
      kPrc       = 0            ! last sec scanned in part. prc
      iError     = 0
      LUreq      = 0
      lines1     = 0
      lines2     = 0
      iw(MnrHdg) = 0

      chkFea = .true.
      jstFea = .false.
      prtFea = .true.
      feasbl = .false.
      gotE   = .false.

      getFP  = Prob .eq. FP  .or.  Prob .eq. FPE  .or.   Prob  .eq. FPS
      solvQP = Prob .eq. QP  .or.  Prob .eq. QPP  .or.   Prob  .eq. QPS
      solvLP = Prob .eq. LP  .or.         solvQP  .and.  nnH   .eq. 0

      QPdone = .false.

      bndswp = .false.
      needpi = .true.
      newLU  = .true.
      Unbndd = .false.
      weak   = .false.
      ObjPhs = .false.
      PosDef = .false.

      pivot  = zero
      step   = zero
      ObjSlk = zero
      ObjQP  = zero
      Obj    = zero
      nInfE  = 0
      jq     = 0
      djq    = zero
      jBq    = 0                ! x(jBq) is the incoming   BS        
      jBr    = 0                ! x(jBr) is the outgoing   BS        
      jBSr   = 0                ! x(jBSr) leaves B in special BS swap
      jSq    = 0                ! x(jSq) is the incoming SBS         
      jSr    = 0                ! x(jSr) is the outgoing SBS         
      jqSave = 0
      kPrPrt = 0
      sgnObj = minimz

      rw(toldj1) = 100.0d+0
      rw(toldj2) = 100.0d+0

*     nUncon  counts the number of unconstrained (i.e., Newton) steps.
*             If the test for a minimizer were scale-independent, 
*             Uncon would never be larger than 1.
*     nfmove  counts the number of times that the QP obj is decreased,

      Status = 1
      nfmove = 0
      nUncon = 0 

*     subopt nonzero implies that optimization occurs with a subset of
*     the variables frozen at their initial values.
*     During suboptimization, nFreez is the number of frozen variables.
 
      nFreez = 0
      nSmax  = nS + mWSmod
      if (subopt .ge. 0) then
         call dcopy ( nb, x, 1, xFix, 1 )
      end if
      call s5hs  ( Intern, nb, bl, bu, hs, x )
      call s5dgen( Init, inform, lPrint, nb, nInf, itn,
     &     featol, tolx, tolinc, hs, bl, bu, x,
     &     itnfix, nfix, tolx0, iw, leniw, rw, lenrw )

**    ======================Start of main loop==========================
*+    do while (.not. QPdone  .and.  iError .eq. 0)
  100 if       (.not. QPdone  .and.  iError .eq. 0) then
*        ===============================================================
*        Check the initial  x  and move it onto  ( A  -I )*x = b.
*        If needLU is true, this will require a basis factorization.
*        ===============================================================
*        If necessary,  factorize the basis  ( B = LU ) and set x.
*        If needLU is false on entry to s5QP, the first call to s2Bfac
*        will try to use existing factors.
*        If needLU is true on entry to s5QP, an LU factorization of 
*        type typeLU is computed.
*
*        LUreq
*        -----
*         0        first factorize
*         1        factorize frequency 
*         2        LU update frequency
*
*         7        no free memory for LU updates
*         9        singular U
*        10        row check error
*        11        refresh reduced Hessian
*        ---------------------------------------------------------------
         if (LUreq .gt. 0) needLU = .true.

         if (needx  .or.  needLU) then
            call s2Bfac( typeLU, needLU, newLU, newB, 
     &           iError, iObj, itn, lPrint, LUreq,
     &           m, mBS, n, nb, nnH, nS, nSwap,
     &           ne, nlocA, locA, indA, Acol,
     &           kBS, hs, bl, bu, blBS, buBS,
     &           nrhs0, nrhs, rhs, x, xBS,
     &           iy, iy1, y, y1,
     &           iw, leniw, rw, lenrw )

            LUsiz0 = iw(lenL0) + iw(lenU0)
            LUmax  = 2*LUsiz0

            if (iError .ne. 0) go to 100

            if ( newLU )
     &      gotR   = .false.    ! Reset R.
            gotE   = .false.    ! Check hEstat in elastic mode.
            needpi = .true.     ! Recalculate the pi's.
            needx  = .false.
            chkFea = .true.

            djq    = zero
            pivot  = zero
            jqSave = 0
            nUncon = 0
            if (lPrint .ge. 10) iw(MnrHdg) = 1
         end if

         nBS    = m + nS
         newSB  = .false.

*        If the last superbasic is a slack, swap it into the basis.

         if (nS .gt. 0  .and.  kBS(nBS) .gt. n) then
            call s5Bswp( gotR, lenR, m, mBS, n, nb, nS,
     &           jBSr, LUreq, pivot, 
     &           ne, nlocA, locA, indA, Acol,
     &           hs, kBS, blBS, buBS, R, xBS, 
     &           y, y1, y2, iw, leniw, rw, lenrw )
            if (LUreq .gt. 0) go to 100
         end if

         nInf   = 0
         sInf   = zero
         optiml = .false.

         call dload ( nBS, zero, gBS, 1 )
            
         if (Elastc  .and.  .not. gotE) then
*           ------------------------------------------------------------
*           Reset blBS and buBS for any violated elastics.
*           These values are used in s5step.
*           Strictly feasible elastics are returned to normality.
*           ------------------------------------------------------------
            call s5SetE( nb, nBS, nElast, featol, plInfy,
     &           hElast, hEstat, kBS, 
     &           bl, bu, blBS, buBS, xBS )
            gotE  = .true.
         end if

         if ( chkFea ) then

*           In Phase 1 or just after a factorize, check the feasibility 
*           of the basic and superbasic non-elastics.
*           jstFea  indicates that we have just become feasible.
*           jstFea is turned off once a step is taken.

            call s5Inf ( nBS, featol, 
     &           nInf, sInf, hfeas, blBS, buBS, gBS, xBS )

            if (nInf .gt. 0) then

*              Non-elastics are infeasible.
*              Print something if the basis has just been refactorized.

               if (Prnt10  .and.  iw(LUitn) .eq. 0) then
                  write(iPrint, 1030) itn, nInf, sInf
               end if
            end if

*           Feasbl = true means that the non-elastics are feasible.
*                    This defines the start of Phase 2.

            if (.not. feasbl) 
     &      jstFea = nInf .eq. 0
            feasbl = nInf .eq. 0
            chkFea = nInf .gt. 0
         end if ! if chkFea

         if ( Elastc ) then
*           ------------------------------------------------------------
*           Compute the sum of infeasibilities of the elastic variables.
*           ------------------------------------------------------------
            call s5InfE( nb, nBS, hEstat, kBS, nInfE, sInfE, bl, bu, x )
            nInf = nInf + nInfE
            sInf = sInf + sInfE
         end if

         if (jstFea  .and.(getFP .or.(Elastc .and. lvlInf .eq. 0))) then
*           ------------------------------------------------------------
*           The non-elastic variables just became feasible. Exit.
*           ------------------------------------------------------------
            condHz = zero
            djqPrt = zero
            rgNorm = zero
            piNorm = zero
            call dload ( m, zero, pi, 1 )
            deadpt = .false.
            optiml = .true.

         else
*           ------------------------------------------------------------
*           If (x,s) is feasible or a composite objective is being
*           minimized, use the LP/QP gradient.
*           Otherwise, use the gradient of the sum of infeasibilities. 
*           ------------------------------------------------------------
            ObjPhs = feasbl  .and.  (nInf .eq. 0  .or.  lvlInf .ne. 2)

            if ( feasbl ) then
*              ---------------------------------------------------------
*              Feasible with respect to the non-elastic variables.
*              We are in  phase 2 (in either normal or elastic mode).
*              ---------------------------------------------------------
*              If just feasible, compute the QP objective (and gradient)
*              and R.

               ObjSlk = zero

               if ( ObjPhs ) then
                  if (iObj .ne. 0) then
                     ObjSlk = xBS(iw(kObj))*sclObj
                  end if
                  Obj = sgnObj*ObjSlk
               end if

               if (jstFea  .or.  newLU) then

                  if ( ObjPhs ) then
*                    ===================================================
*                    Initialize the QP objective and gradient.
*                    ObjQP is the linear plus quadratic term of the
*                    objective (not scaled by sgnObj).   It is updated
*                    after each QP step. 
*                    ===================================================
                     if ( gotgQP ) then
                        call s5QPfg( Hprod, Hprod1,
     &                       ngQP, nGobj0, nGobj, nnH,
     &                       Status, Hcalls, ObjQP,
     &                       iHvar, jHvar, lenH, neH, H,
     &                       Gobj, gQP, lenx0, nx0, x0, x, y, 
     &                       cu, lencu, iu, leniu, ru, lenru, 
     &                       cw, lencw, iw, leniw, rw, lenrw )
                        Obj    = Obj + sgnObj*ObjQP
                        Status = 0
                     end if

                     if ( gotH  .and. .not. gotR) then
*                       ------------------------------------------------
*                       Load and factor the reduced Hessian.
*                       This happens after every LU factorize.
*                       If the reduced Hessian is not positive definite,
*                       reduce the LU factor tolerances to get a better
*                       conditioned Z.
*                       ------------------------------------------------
                        if (nS .gt. 0) then
                           call s5HZ  ( Hprod, Hprod1, lenR, minimz,
     &                          m, mBS, n, nb, nnH, nS, Hcalls,
     &                          ne, nlocA, locA, indA, Acol,
     &                          iHvar, jHvar, lenH, neH, H,
     &                          Hdmax, kBS, R, y, y1, y2, 
     &                          cu, lencu, iu, leniu, ru, lenru,
     &                          cw, lencw, iw, leniw, rw, lenrw )
                           call s5Hfac( PDEF, itn, iError, lenR, m, 
     &                          maxR, mBS, nb, nS, Hdmax, hs, kBS, iy, 
     &                          bl, bu, blBS, buBS, x, xBS, R,
     &                          iw, leniw, rw, lenrw )
                           if (iError .ne. 0) go to 100
                        end if ! nS > 0
                        gotR = .true.
                     end if ! gotH and not gotR

                     nBS    = m + nS
                     PosDef = gotR  .or.  nS .eq. 0

                  end if ! ObjPhs
               end if ! jstFea .or. newLU

*              ---------------------------------------------------------
*              Gather the QP gradient in BS order.
*              Assign the nonzero components of gBS.
*              ---------------------------------------------------------
               if ( ObjPhs ) then
                  if ( gotgQP ) then
                     call s2copy( Gather, 
     &                    ngQP, nBS, kBS, sgnObj, gQP, gBS )
                  end if
                  if (iObj .gt. 0) gBS(iw(kObj)) = sgnObj*sclObj
               end if

               if ( Elastc ) then
                  call s5grdE( nb, nBS, wtInf, hEstat, kBS, gBS )
               end if

*              ---------------------------------------------------------
*              See if it's time to suboptimize.
*              NOTE: We must not suboptimize if all steps have been
*              degenerate.
*              ---------------------------------------------------------
               if (subopt .ne. 0  .or.  nfmove .eq. 0) then
*                 Relax
               else
                  call dcopy ( nnH,         x , 1, y, 1 )
                  call daxpy ( nnH, (-one), x0, 1, y, 1 )
                  factor = zero
                  normdx = dnrm1s( nnH, y, 1 )
                  if (normdx .ge. factor*abs(djq)) then
                     if (nS   .ge. nSmax ) then
                        subopt = 1
                     else if (itQP .ge. mxitQP) then
                        subopt = 2
                     end if
                  end if
               end if
            end if ! feasible

            if ( needpi ) then
               call dcopy ( m, gBS, 1, y, 1 )
               call s5setp( m, piNorm, y, pi, iw, leniw, rw, lenrw )
               needpi = .false.
            end if

            rgNorm = zero
            if (nS .gt. 0) then
               call s5rg  ( m, nBS, n, nS, eps0, 
     &              ne, nlocA, locA, indA, Acol,
     &              gBS, pi, rg, rgNorm, kBS )
            end if

*           ============================================================
*           Determine if the reduced Hessian is positive definite.
*           ============================================================
            condHz = zero
            if ( gotR ) then
               call s6Rcnd( nS, lenR, R, dRmax, dRmin, Rmax, condHz )
            end if

            if (.not. PosDef) then
               if (ObjPhs  .and.  gotR) then
                  if (nS .gt. 0) then
                     lRs  = nS*(nS + 1)/2
                     dRsq = R(lRs)**2
                  end if
                  call s5Rsng( eigH, PosDef, Singlr,
     &                 itn, lenR, nS, dRsq, R, iw, leniw, rw, lenrw )
               else
                  PosDef = nS .eq. 0
               end if
            end if

*           ============================================================
*           Check for optimality. 
*           If x is a minimizer,  reduced costs are calculated.
*           In theory, the reduced gradient is zero after a bound swap.
*           ============================================================
            if ( feasbl ) then
               rw(toldj3) = tolQP
            else
               rw(toldj3) = tolFP
            end if

            statpt = rgNorm .le. eps0*piNorm
            deadpt = .false.
            needLM = statpt

            if ( bndswp ) then
               if (solvQP  .and.  ObjPhs) nUncon = nUncon + 1
               jqSave = 0
               bndswp = .false.
            end if

            if (ObjPhs  .and.  solvQP) then

*              Iterative refinement could not reduce rgNorm/piNorm
*              below 1.0d-4.  This is pretty unusual. We try and 
*              continue with (very) stringent LU factor tolerances.

               giveup = nUncon  .gt. mUncon
               rgfail = giveup  .and.  (rgNorm .gt. 1.0d-4*piNorm)

               if ( rgfail ) then
                  call s2tols( MinTol, NewTol, itn, iw, leniw, rw,lenrw)

                  if (iw(LUitn) .gt. 0  .or.  NewTol) then
                     LUreq  = 11
                     typeLU = BS
                     nUncon = 0
                  else 
                     iError = 11
                  end if
                  go to 100
               end if

               deadpt = statpt  .and. .not. PosDef
               needLM = statpt  .or.  giveup  .or.  Unbndd  .or.  weak
            end if

            kPrPrt = kPrc
            jq     = 0
            djqPrt = djq
            djq    = zero

            if ( needLM ) then
*              ---------------------------------------------------------
*              Compute Lagrange multipliers.
*              ---------------------------------------------------------
               nUncon = 0
               usegQP = ObjPhs  .and.  gotgQP
               weight = zero
               if (Elastc  .and.  feasbl) then
                  weight = wtInf
               end if

               call s5pric( Elastc, feasbl, incres, usegQP, subopt,
     &              itn, m, n, nb, ngQP0, ngQP, nnH,
     &              nS, nFreez, nonOpt, weight, sgnObj, piNorm,
     &              jq, djq, kPrc, rw(toldj1),
     &              ne, nlocA, locA, indA, Acol,
     &              hElast, hs, bl, bu, gQP, pi, rc, x, xFix,
     &              iw, leniw, rw, lenrw )

               optiml = nonOpt .eq. 0
               newSB  = nonOpt .gt. 0
            end if ! needLM
         end if ! jstFea

         QPdone = optiml  .or.  deadpt  .or.  Unbndd  .or.  weak

         if ( QPdone ) then 
*           ------------------------------------------------------------
*           We are apparently finished.
*           See if any nonbasics have to be set back on their bounds.
*           ------------------------------------------------------------
            call s5dgen( Optml, inform, lPrint, nb, nInf, itn,
     &           featol, tolx, tolinc, hs, bl, bu, x,
     &           itnfix, nfix, tolx0,
     &           iw, leniw, rw, lenrw )

            QPdone = inform .eq. 0

            if ( QPdone ) then
*              ---------------------------------------------------------
*              So far so good.  Now check the row residuals.
*              ---------------------------------------------------------
               if (iw(LUitn) .gt. 0) then
                  call s5setx( Check, inform, itn,
     &                 m, n, nb, nBS, rowerr,
     &                 ne, nlocA, locA, indA, Acol,
     &                 kBS, xBS, nrhs0, nrhs, rhs, x, y, y2,
     &                 iw, leniw, rw, lenrw )
                  
                  QPdone = inform .eq. 0
                  LUreq  = inform
                  if (LUreq .gt. 0) typeLU = BT
               end if
            end if

            if ( QPdone ) then
               if (Unbndd            ) iError = 2
               if (deadpt  .or.  weak) iError = 4
            else
               needx  = .true.
               feasbl = .false.
               Unbndd = .false.
               weak   = .false.
               needpi = .true.
               go to 100
            end if
         end if ! done

*        ===============================================================
*        Print the details of this iteration.
*        ===============================================================
         if ( ObjPhs ) ObjPrt = ObjAdd + ObjSlk + ObjQP

         call QPlog ( Prob, contyp, 
     &        Elastc, gotR, prtFea, jstFea, ObjPhs,
     &        m, mBS, nS, jSq, jBr, jSr, jBSr,
     &        lines1, lines2, itn, kPrPrt, lvlInf, lPrint, 
     &        sgnObj, pivot, step, nInf, sInf, wtInf,
     &        ObjPrt, condHz, djqPrt, rgNorm, kBS, xBS,
     &        iw, leniw )

         jBq    = 0
         jBr    = 0
         jBSr   = 0
         jSq    = 0
         jSr    = 0
         kPrPrt = 0

         if ( QPdone ) then

            if (nInf .gt. 0) then
*              ---------------------------------------------------------
*              Convergence, but no feasible point.
*              Stop or continue in elastic mode, depending on the
*              specified level of infeasibility.
*              ---------------------------------------------------------
               if (lEmode .gt. 0) then
                  if (.not. Elastc) then

*                    The constraints are infeasible in Normal mode.
*                    Print a message and start Elastic Phase 1.

                     if (lPrint .gt. 0) then
                        if (iPrint .gt. 0) then
                           write(iPrint, 8050) itn, contyp
                           write(iPrint, 8060) itn
                        end if
                        if (iSumm  .gt. 0) then
                           write(iSumm , 8050) itn, contyp 
                           write(iSumm , 8060) itn
                        end if
                     end if
                     Elastc = .true.
                     needpi = .true.
                     QPdone = .false.
                     djq    = zero
                     step   = zero
                     call s5IniE( nb, nBS, nElast, featol, plInfy,
     &                    hElast, hEstat, kBS, 
     &                    bl, bu, blBS, buBS, xBS )
                  else if (.not. feasbl) then

*                    The non-elastic bounds cannot be satisfied 
*                    by relaxing the elastic variables.

                     iError = 1
                  end if
                  go to 100
               end if
            end if

            if (solvLP  .or.  solvQP) then
               If (jq .ne. 0) then
                  djq    = sgnObj*djq
                  if (Prnt1) write(iPrint, 1010) djq, jq, rgNorm, piNorm
               else
                  if (Prnt1) write(iPrint, 1020)          rgNorm, piNorm
               end if
            end if
         else 
*           ------------------------------------------------------------
*           A nonbasic has been selected to become superbasic.
*           Compute the vector y such that B y = column jq.
*           ------------------------------------------------------------
            if ( newSB ) then
*              ---------------------------------------------------------
*              The price has selected a nonbasic to become superbasic.
*              ---------------------------------------------------------
               if (nS+1 .gt. maxS) then 
                  iError = 5
                  go to 100
               end if

*              ---------------------------------------------------------
*              Compute the vector pBS such that B pB = column jq.
*              pBS is a multiple of part of the new column of  Z  and
*              is used to define the QP search direction and update R.
*              ---------------------------------------------------------
*              Unpack column jq into  y1  and solve  B*pB = y1.
*              The altered  y1  satisfies  L*y1 = ajq. 
*              It is used later in s5QPit to modify L and U.

               call s2unpk( jq, m, n, ne, nlocA, locA, indA, Acol, y1 )
               call s2Bsol( WithB, inform, m,
     &              y1, pBS, iw, leniw, rw, lenrw )
            end if

*           ============================================================
*           Take a step.
*           ============================================================
            if (itn  .ge. itnlim) then 
               iError = 3
               go to 100
            end if

            itQP      = itQP   + 1
            itn       = itn    + 1
            jstFea    = .false.

*           ------------------------------------------------------------
*           Take a ``reduced gradient'' step.
*           The new  x  will either minimize the objective on the
*           working set or lie on the boundary of a new constraint.
*           ------------------------------------------------------------
            call s5QPit( Hprod, Hprod1, bndswp, Elastc, feasbl,
     &           gotgQP, gotH, gotR, incres, ObjPhs, 
     &           needpi, newSB, PosDef, iError, itn, lenR,
     &           m, mBS, maxS, n, nb, Hcalls, nnH0, nnH, nS,
     &           ngQP0, ngQP, nDegen, LUreq, kp, jBq, jSq, jBr, jSr,
     &           jq, jqSave, nfmove, nUncon, djq, minimz, Obj, ObjQP,
     &           featol, pivot, step, tolinc, wtInf,
     &           ne, nlocA, locA, indA, Acol,
     &           iHvar, jHvar, lenH, neH, H,
     &           hElast, hEstat, hfeas, hs, kBS, 
     &           bl, bu, blBS, buBS, gBS,
     &           gQP, Hdx, pBS, rg, R, x, xBS, y, y1, y2,
     &           cu, lencu, iu, leniu, ru, lenru, 
     &           cw, lencw, iw, leniw, rw, lenrw )

*           ------------------------------------------------------------
*           If there are errors, try to factorize with more stringent
*           LU factor tolerances.
*           ------------------------------------------------------------
            if (iError .ne. 0) then
               call s2tols( RedTol, NewTol, itn, iw, leniw, rw, lenrw )

               if (iw(LUitn) .gt. 0  .or.  NewTol) then
                  LUreq  = 11
                  typeLU = BS
                  nUncon = 0

                  if (iError .eq.  6) then
                     if (eigH .eq. PSDEF  .or.  eigH .eq. PDEF) then
                        if (iPrint .gt. 0) write(iPrint, 1500) itn
                        if (iSumm  .gt. 0) write(iSumm , 1500) itn
                     end if
                  end if
                  iError = 0
               end if
            end if

            if (iError .ne. 0) then
               go to 100
            end if

            iw(LUitn) = iw(LUitn)  + 1
            newLU     = .false.

*           Increment featol every iteration.

            featol = featol + tolinc

*           ============================================================
*           Test for error condition and/or frequency interrupts.
*           ============================================================
*           (1) Save a basis map (frequency controlled).
*           (2) Every kdegen iterations, reset featol and move nonbasic 
*               variables onto their bounds if they are very close.
*           (3) Refactorize the basis if it has been modified too many
*               times.
*           (4) Update the LU factors of the basis if requested.
*           (5) Check row error (frequency controlled).

            if (mod(itn,ksav) .eq. 0) then
               call s5hs  ( Extern, nb, bl, bu, hs, x )
               call s4ksav( minimz, m, n, nb, nS, mBS,
     &              itn, nInf, sInf, ObjQP, kBS, hs, 
     &              Ascale, bl, bu, x, xBS, cw, lencw, iw, leniw )
               call s5hs  ( Intern, nb, bl, bu, hs, x )
            end if

            if (mod( itn, kdegen ) .eq. 0) then
               call s5dgen( Cycle, inform, lPrint, nb, nInf, itn,
     &              featol, tolx, tolinc, hs, bl, bu, x,
     &              itnfix, nfix, tolx0,
     &              iw, leniw, rw, lenrw )
               needx  = inform .gt. 0
            end if

            if (LUreq .eq. 0) then

               if (     iw(LUmod) .ge. kfac-1) then
                  LUreq  = 1
               else if (iw(LUmod) .ge. 20  .and. 
     &                                iw(lenL)+iw(lenU) .gt. LUmax) then
                  Bgrwth = iw(lenL) + iw(lenU)
                  Bold   = LUsiz0
                  Bgrwth = Bgrwth/Bold
                  if ( Prnt10 ) write(iPrint, 1000) Bgrwth
                  LUreq  = 2
               else 
                  checkx = mod(iw(LUitn),kchk) .eq. 0
                  if (checkx  .and.  .not. needx) then
                     call s5setx( Check, inform, itn,
     &                    m, n, nb, nBS, rowerr,
     &                    ne, nlocA, locA, indA, Acol,
     &                    kBS, xBS, nrhs0, nrhs, rhs, x, y, y2,
     &                    iw, leniw, rw, lenrw )
                     LUreq  = inform
                  end if
               end if
               if (LUreq .gt. 0) typeLU = BT
            end if
         end if ! not optiml

         go to 100
*+    end while
      end if
*     ======================end of main loop============================
*
      call s5hs  ( Extern, nb, bl, bu, hs, x )

      if (subopt .gt. 0) then
         if (nFreez .gt. 0) then
*           write(*,*) ' nFreez =', nFreez
         else
            subopt = 0
         end if
      end if

      return

 1000 format(  ' ==> LU file has increased by a factor of', f6.1)
 1010 format(/ ' Biggest dj =', 1p, e11.3, ' (variable', i7, ')',
     &         '    norm rg =',     e11.3, '   norm pi =', e11.3)
 1020 format(/    ' Norm rg =', 1p, e11.3, '   norm pi =', e11.3)
 1030 Format(' Itn', i7, ': Infeasible nonelastics.  Num =', i5, 1p,
     &                   '  Sum of Infeasibilities =', e8.1 )
 1500 format(' Itn', i7, ': Expanded reduced Hessian',
     &                   '  is indefinite:  Hessian refactorized' )
 8050 format(' Itn', i7, ': Infeasible ', a)
 8060 format(' Itn', i7, ': Elastic Phase 1 -- making',
     &                   '  non-elastic variables feasible')

      end ! of s5QP

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5QPfg( Hprod, Hprod1,
     &     ngQP, nGobj0, nGobj, nnH,
     &     Status, Hcalls, ObjQP,
     &     iHvar, jHvar, lenH, neH, H,
     &     Gobj, gQP, lenx0, nx0, x0, x, dx, 
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      external
     &     Hprod, Hprod1
      integer
     &     Hcalls, lenH, lenx0, lencu, lencw, leniu, leniw, lenru,
     &     lenrw, neH, ngQP, nGobj0, nGobj, nnH, nx0, Status,
     &     iHvar(lenH), jHvar(lenH), iu(leniu), iw(leniw)
      double precision
     &     ObjQP, Gobj(nGobj0), gQP(ngQP), 
     &     H(lenH), x0(lenx0), x(ngQP), dx(ngQP), ru(lenru), rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     s5qpfg  computes various quantities associated with the LP/QP.
*
*       1.  ObjQP =  Gobj'*(x-x0)  + half*(x - x0)'*H*(x - x0)
*       2.  gQP   =  gradient of ObjQP
*
*     On entry, 
*     ngQP         is max( nGobj, nnH )
*     x(ngQP)      are the nonlinear variables
*     x0(ngQP)     is the base point x0
*     Gobj(nGobj)  defines the explicit QP linear term
*
*     On exit,
*     ObjQP        is the QP quadratic term (1) above
*     gQP(ngQP)    is the gradient of ObjQP
*     dx(ngQP)     is  x-x0
*
*     02 May 1992: First version of s5qpfg.
*     23 Oct 1993: Hx added as an argument.
*     29 Oct 1993: Modified to compute only the QP objective.
*     07 Oct 1994: gQP added as an argument.
*     05 Nov 2000: Current version.
*     ==================================================================
      integer
     &     nzero
      double precision
     &     ddot
*     ------------------------------------------------------------------
      double precision   zero,          half,          one
      parameter         (zero = 0.0d+0, half = 0.5d+0, one = 1.0d+0)
*     ------------------------------------------------------------------
      if (ngQP .le. 0) return

      call dcopy ( ngQP,         x , 1, dx, 1 )
      if (nx0 .gt. 0)
     &call daxpy ( ngQP, (-one), x0, 1, dx, 1 )
               
      ObjQP  = zero

      if (nnH .gt. 0) then
         call Hprod ( Hprod1, Hcalls, nnH,
     &        iHvar, jHvar, lenH, neH, H,
     &        dx, gQP, Status, 
     &        cu, lencu, iu, leniu, ru, lenru, 
     &        cw, lencw, iw, leniw, rw, lenrw )
         Hcalls   = Hcalls + 1
         ObjQP = half*ddot( nnH, dx, 1, gQP, 1 )
      end if

      nzero = ngQP - nnH
      if (nzero .gt. 0) call dload ( nzero, zero, gQP(nnH+1), 1 )

      if (nGobj .gt. 0) then
         ObjQP = ObjQP + ddot( nGobj, Gobj, 1, dx, 1 )
         call daxpy ( nGobj, one, Gobj, 1, gQP, 1 )
      end if

      end ! of s5QPfg

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5QPit( Hprod, Hprod1, bndswp, Elastc, feasbl, 
     &     gotgQP, gotH, gotR, incres, ObjPhs,
     &     needpi, newSB, PosDef, iError, itn, lenR,
     &     m, mBS, maxS, n, nb, Hcalls, nnH0, nnH, nS,
     &     ngQP0, ngQP, nDegen, LUreq, kp, jBq, jSq, jBr, jSr,
     &     jq, jqSave, nfmove, nUncon, djq, minimz, Obj, ObjQP, 
     &     featol, pivot, step, tolinc, wtInf,
     &     ne, nlocA, locA, indA, Acol,
     &     iHvar, jHvar, lenH, neH, H,
     &     hElast, hEstat, hfeas, hs, kBS,
     &     bl, bu, blBS, buBS, gBS,
     &     gQP, Hdx, pBS, rg, R, x, xBS, y, y1, y2, 
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      external
     &     Hprod, Hprod1
      logical
     &     bndswp, Elastc, feasbl, gotgQP, gotH, gotR, incres, ObjPhs,
     &     needpi, newSB, PosDef
      integer
     &     iError, itn, lenH, lenR, m, maxS, mBS, minimz,
     &     n, nb, ne, neH, nlocA, nDegen, Hcalls, nnH0, nnH,
     &     ngQP0, ngQP, nS, LUreq, kp, jBq, jBr, jq, jqSave, nfmove, 
     &     nUncon, lencu, lencw, leniu, leniw, lenru, lenrw,
     &     locA(nlocA), indA(ne), iHvar(lenH), jHvar(lenH), 
     &     hElast(nb), hEstat(nb), hs(nb), hfeas(mBS), kBS(mBS),
     &     iu(leniu), iw(leniw)
      double precision
     &     djq, Obj, ObjQP, featol, pivot, step, tolinc, wtInf,
     &     Acol(ne), bl(nb), bu(nb), blBS(mBS), buBS(mBS),
     &     gBS(mBS), gQP(ngQP0), H(lenH), Hdx(nnH0), pBS(mBS),
     &     R(lenR), rg(maxS), x(nb), xBS(mBS), y(nb), y1(nb), y2(nb),
     &     ru(lenru), rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     s5QPit performs a QP step.
*
*     On entry, 
*        newSB = true implies that variable jq just went superbasic. 
*                In this case:
*                pBS  satisfies B pBS = a(jq).
*                y1   satisfies L  y1 = a(jq).
*
*     On exit,
*        pBS contains the most recent QP search direction. 
*
*
*     25 Nov 1991: First version of s5QPit.
*     05 Jan 1996: Positive semidefinite R treated correctly.
*     29 Aug 1996: First min sum version added.
*     27 Jul 1997: Thread-safe version.
*     02 Feb 1998: Piecewise linear line search added.
*     03 Apr 1999: Objective stored in Acol.
*     23 Mar 2000: gQP  and  H  scaled.
*     16 Oct 2000: Current version of s5QPit.
*     ==================================================================
      logical
     &     hitcon, hitlow, move, onbnd, Unbndd, Uncon, vertex, Hposdf,
     &     Hsingr, Singlr
      integer
     &     eigH, iPrint, nBS, nBS1, nS1, Status, inform, j, jes, jr,
     &     jrStat, js, jsq, jsr, k, kBSq, ksq, lRnew, LUmod
      double precision
     &     bound, eps, eps0, tolpiv, plInfy, bigdx, drsq, exact, gp,
     &     gpQP, ObjChg, sgnObj, StepB, stepmx, stepP, tolP, pBS1, pHp, 
     &     pHpQP, pNorm, dasum, ddot
*     ------------------------------------------------------------------
      integer            Normal
      parameter         (Normal = 0)
      integer            xBStox
      parameter         (xBStox = 1)
      integer            Scattr
      parameter         (Scattr = 1)
      integer            WithL,      WithB,      WithBt   
      parameter         (WithL  = 0, WithB  = 1, WithBt = 2)
      parameter         (LUmod  = 216) ! number of LU mods
      double precision   zero,            half,          one
      parameter         (zero   = 0.0d+0, half = 0.5d+0, one = 1.0d+0)
*     ------------------------------------------------------------------
      eps       = rw(  1) ! unit round-off.
      eps0      = rw(  2) ! eps**(4/5)
      tolpiv    = rw( 60) ! excludes small elements of pBS.
      plInfy    = rw( 70) ! definition of plus infinity.
      bigdx     = rw( 72) ! unbounded step.

      iPrint    = iw( 12) ! Print file
      eigH      = iw(200) ! -1,0,1 for indef, psd and pdef QP Hessian

      inform    = 0
      Status    = 0
      iError    = 0

      Unbndd    = .false.
      vertex    = nS .eq. 0
      sgnObj    = minimz

      nBS       = m + nS

      if ( newSB ) then
*        ---------------------------------------------------------------
*        New superbasic. 
*        PosDef must be true if there is a new superbasic.
*        ---------------------------------------------------------------
         nS1    = nS   + 1
         nBS1   = nBS  + 1

         kBS  (nBS1) =    jq
         xBS  (nBS1) = x (jq)
         blBS (nBS1) = bl(jq)
         buBS (nBS1) = bu(jq)

         bndswp = .false.
         PosDef = .false.

         if ( gotR ) then 
*           ------------------------------------------------------------
*           Add the new column to R at position nS+1.
*           Check for a singular or indefinite reduced Hessian.
*           ------------------------------------------------------------
            kBS(nBS1) = jq
            call s5Rcol( Hprod, Hprod1, inform, minimz, jq, nS1,
     &           lenR, m, mBS, n, nb, Hcalls, nnH, nS1,
     &           ne, nlocA, locA, indA, Acol,
     &           iHvar, jHvar, lenH, neH, H, kBS, R, y, y2, pBS, 
     &           cu, lencu, iu, leniu, ru, lenru, 
     &           cw, lencw, iw, leniw, rw, lenrw )

            lRnew = nS1*(nS1 + 1)/2
            dRsq  = R(lRnew)
            call s5Rsng( eigH, Hposdf, Hsingr,
     &           itn, lenR, nS1, dRsq, R, iw, leniw, rw, lenrw )

            if ( ObjPhs ) then
               PosDef = Hposdf
               Singlr = Hsingr
               if (.not. (PosDef  .or.  Singlr)) then
                  iError = 6
                  go to 900
               end if
            else
               gotR   = Hposdf 
            end if

            if ( gotR ) R(lRnew) = sqrt( dRsq )  

         end if ! ObjPhs and gotR

*-->     R could be checked here.

         if ( incres ) then
            jqSave =   jq
         else
            jqSave = - jq               
         end if

         nS     =  nS1
         nBS    = nBS1

         hfeas(nBS) = 0

         if (ObjPhs  .and.  gotgQP   .and.  jq .le. ngQP) then
            gBS(nBS) = sgnObj*gQP(jq)
         else
            gBS(nBS) = zero
         end if

*        ===============================================================
*        Set hEstat(jq) and the elastic parts of blBS and buBS.
*        ===============================================================
         if ( Elastc ) then

*           If the new superbasic is an elastic variable
*           and it wants to move infeasible, set its elastic state.

            if (hElast(jq) .gt. 0) then 
               js  = hs(jq)
               if ( incres ) then
                  if (js .eq. 1  .or.  js .eq. 4) then
                     hEstat(jq) =   2
                     buBS(nBS)  =   plInfy
                     if ( feasbl ) then
                        gBS (nBS) = gBS(nBS) + wtInf
                        blBS(nBS) = bu(jq)
                     end if
                  end if
               else
                  if (js .eq. 0  .or.  js .eq. 4) then
                     hEstat(jq) =   1 
                     blBS(nBS)  = - plInfy
                     if ( feasbl ) then
                        gBS (nBS) = gBS(nBS) - wtInf
                        buBS(nBS) = bl(jq)
                     end if
                  end if
               end if
            end if
         end if ! Elastc

*        ---------------------------------------------------------------
*        In phase 1, or in phase 2 for an LP, price can select nonbasics
*        floating free between their bounds with zero reduced cost. 
*        We have to check that dqj is not zero.
*        ---------------------------------------------------------------
         rg(nS) = djq
         if (.not. feasbl  .or.  nnH .eq. 0) then
            if (hs(jq) .eq. -1) then
               if (incres) then
                  rg(nS) = - one
               else
                  rg(nS) =   one
               end if
            end if
         end if
         jSq    = jq
         hs(jq) = 2

      end if ! newSB

      Singlr = .not. PosDef

*     ------------------------------------------------------------------
*     Store the free components of the search direction in pBS(1:nBS).
*     First, find the search direction pS for the superbasics, store it
*     in  pBS(m+1:nBS), and find its norm.  Put the search direction for 
*     the basic variables in pBS(1)  ,...,pBS(m).
*     ------------------------------------------------------------------
      call s5getp( ObjPhs, gotR, PosDef,
     &     lenR, nS, R, rg, pBS(m+1), gp, pHp )

      pBS1   = pBS(m+1)
      pNorm  = dasum( nS, pBS(m+1), 1 )

*     Compute  y2 = - S*pS and prepare to solve  B*pB = y2
*     to get pB, the search direction for the basic variables.
*     We first normalize y2 so the LU solver won't ignore
*     too many "small" elements while computing pB.

      call dscal ( nS, (one/pNorm), pBS(m+1), 1 )
      call s2Bprd( Normal, eps0, n, nS, kBS(m+1),
     &     ne, nlocA, locA, indA, Acol,
     &     (-one), pBS(m+1), nS, zero, y2, m ) 

*     Solve  B*pBS = y2  and then unnormalize all of pBS.

      call s2Bsol( WithB, inform, m, y2, pBS, iw, leniw, rw, lenrw  )
      call dscal ( nBS , pNorm, pBS, 1 )
      pNorm  = pNorm + dasum( m, pBS, 1 )

      if ( ObjPhs ) then
*        ---------------------------------------------------------------
*        If R is singular, ensure that pBS is a feasible direction.
*        A nonzero inform on exit implies that the directional
*        derivative is too small to be relied upon.
*        ---------------------------------------------------------------
         if (gotR  .and.  Singlr) then
            call s5chkp( inform, nBS, jqSave, kBS, gp, pBS, iw, leniw )

            if (inform .gt. 0) then
               iError = 4
               go to 900
            end if
         end if

*        ---------------------------------------------------------------
*        Compute y = pBS(scattered) and Hdx(scattered).
*        The vector Hdx is used to update the objective and gradient of
*        the QP.  Form g'p and p'Hp.
*        ---------------------------------------------------------------
         if (gotgQP  .or.  gotH) then
            call s2copy( Scattr, ngQP, nBS, kBS, one, y, pBS )

            if ( gotgQP ) then 
               gpQP  = ddot ( ngQP, gQP, 1, y, 1 )
            end if

            if ( gotH ) then
               pHpQP = zero

               call Hprod ( Hprod1, Hcalls, nnH,
     &              iHvar, jHvar, lenH, neH, H,
     &              y, Hdx, Status, 
     &              cu, lencu, iu, leniu, ru, lenru, 
     &              cw, lencw, iw, leniw, rw, lenrw )
               pHpQP = pHpQP + ddot( nnH, y, 1, Hdx, 1 )
            end if
         end if
      end if ! ObjPhs

*     ------------------------------------------------------------------
*     Find the nearest constraint in direction  x + step*pBS (step > 0).
*     Exact  is the step that takes xBS(kp) exactly onto bound.
*     It may be positive or slightly negative. (Not defined if Unbndd.)
*
*     If exact isn't positive and we are not at a vertex, we change
*     step and stepmx to zero and don't move.
*
*     If onbnd  is true, step is a step that reaches a bound exactly.
*     xBS(kp) reaches the value bound.  If we take a constrained step,
*     bound is used to put the new nonbasic variable x(jr) exactly on
*     its bound.
*
*     If Unbndd is true, step = stepmx.
*     ------------------------------------------------------------------
      stepmx = bigdx /pNorm
      tolP   = tolpiv*pNorm

      call s5step( nBS, nDegen,
     &     featol, plInfy, stepmx, tolinc, tolP,
     &     hfeas, blBS, buBS, xBS, pBS,
     &     hitlow, move, onbnd, Unbndd,
     &     kp, bound, exact, stepB, stepP )

*     Find if the step is constrained or unconstrained.
*     If R has been flagged as singular, we double check by trying
*     to compute the QP minimizer along pBS.  If the minimizer exists, 
*     the singularity tolerance must be too large.

      if ( ObjPhs ) then
         if ( PosDef ) then
            Uncon = stepP .gt. one
         else
            Uncon = stepP*pHp .gt. (- gp)
         end if
         Unbndd = (Unbndd  .and.  .not. Uncon)  .or.  stepmx .le. one
      else
         Uncon = .false.
      end if

      if ( Unbndd ) then 
         iError = 2
         go to 900
      end if

      hitcon = .not. Uncon
      needpi = .true.

      if ( hitcon ) then
         nUncon = 0
         if (vertex  .or.  exact .gt. zero) then
            step  = stepB
         else
            step  = zero
            onbnd = .false.
         end if
      else
         nUncon = nUncon + 1
         pivot  = zero
         if ( PosDef ) then
            step   = one
         else
            step   = (- gp)/pHp
            PosDef = .true.
         end if
      end if

*     ------------------------------------------------------------------
*     Compute ObjChg, the predicted change in ObjQP.
*     Note: pHpQP and pHp are defined before and after scaling by
*     sgnObj.
*     ------------------------------------------------------------------
      if ( ObjPhs ) then
         ObjChg = step*gp + half*pHp*step**2
         Obj    = Obj     + ObjChg

         if (gotgQP)
     &        ObjQP = ObjQP + step*gpQP
         if (gotH) then
            ObjQP = ObjQP + half*pHpQP*step**2
            if (step .gt. zero) then
               call daxpy ( nnH, step, Hdx, 1, gQP, 1 )
            end if
         end if
      end if

      if (feasbl  .and.  move) nfmove = nfmove + 1

*     ------------------------------------------------------------------
*     Update the basic variables xBS.
*     ------------------------------------------------------------------
      call daxpy ( nBS, step, pBS, 1, xBS, 1 )
      call s5BSx ( xBStox, nBS, nb, kBS, x, xBS )

      if ( hitcon ) then
*        ===============================================================
*        There is a blocking variable.
*        It could be a fixed variable, whose new state must be 4.
*        ===============================================================
         pivot  = - pBS(kp)
         jr     =   kBS(kp)

         bndswp = jr .eq. abs(jqSave)

         if (onbnd) x(jr) = bound

         jEs    = hEstat(jr)
         hEstat(jr) = 0

         if      (jEs .eq. 0) then 
            if (blBS(kp) .eq. buBS(kp)) then
               jrstat = 4
            else if (hitlow) then
               jrstat = 0
            else
               jrstat = 1
            end if

         else if (jEs .eq. 1) then
            if (bl(jr) .eq. bu(jr)) then
               jrstat =   4
            else if (onbnd) then
               jrstat =   0
            else if (x(jr) .lt. bu(jr)) then
               jrstat = - 1
            else
               jrstat =   1
            end if

         else !   jEs .eq. 2
            if (bl(jr) .eq. bu(jr)) then
               jrstat =   4
            else if (onbnd) then
               jrstat =   1
            else if (x(jr) .gt. bl(jr)) then
               jrstat = - 1
            else
               jrstat =   0
            end if
         end if

         if (kp .le. m) then
*           ============================================================
*           A variable in B hit a bound.
*           Find column kSq = kBSq-m  of S to replace column kp of B.
*           If nS = 1, it must be the entering SB column.
*           ============================================================
            if (nS .eq. 1) then
               kBSq  = nBS
               pivot = pivot/pBS1
            else
               call dload ( m, zero, y2, 1 )
               y2(kp) = one
               call s2Bsol( WithBt,
     &              inform, m, y2, y, iw, leniw, rw, lenrw )
               call s5chzq( m, mBS, n, nb, nS, kBSq, pivot,
     &              ne, nlocA, locA, indA, Acol,
     &              kBS, bl, bu, xBS, y, iw, leniw, rw, lenrw )
               if (kBSq .le. 0) then
                  write (iPrint, 1000) 
                  kBSq   = nBS
               end if
            end if

            kSq        = kBSq - m

            hs(jr)     = jrStat
            jBr        = jr                     ! Outgoing basic
            jSr        = kBS(kBSq)              ! Outgoing superbasic
            kBS (kBSq) = jBr
            jBq        = jSr                    ! Incoming basic
            kBS (kp)   = jSr
            blBS(kp)   = blBS(kBSq)
            buBS(kp)   = buBS(kBSq)
            xBS (kp)   = xBS (kBSq)
            hs(jBq)    = 3

            if ( gotR ) then

*              Finish computing y(m+1), ..., y(m+nS).

               y(kBSq) = - (one + pivot)
               call dscal ( nS, (one/pivot), y(m+1), 1 )
               call s6Rswp( nS, lenR, R, y2, y(m+1), kSq )
            end if

*           ------------------------------------------------------------
*           Get a new  y1, used to modify L and U.  If the outgoing
*           superbasic just came in, we already have it.
*           ------------------------------------------------------------
            if (jSr .ne. jq) then
               call s2unpk( jBq, m, n, ne, nlocA, locA, indA, Acol, y1 )
               call s2Bsol( WithL,
     &              inform, m, y1, y, iw, leniw, rw, lenrw )
            end if

*           Update the LU factors.

            iw(LUmod)  = iw(LUmod) + 1
            call s2Bmod( inform, kp, m, y1, iw, leniw, rw, lenrw )

            if (inform .eq. -1) LUreq = 9 ! Singular U.
            if (inform .eq.  2) LUreq = 8 ! Growth in U.
            if (inform .eq.  7) LUreq = 7 ! Insufficient free memory.

*-->        R can be checked here.

         else
*           ============================================================
*           A variable in S hit a bound.
*           ============================================================
            hs(jr) = jrStat
            jSr    = jr
            kBSq   = kp
            kSq    = kBSq - m
         end if

*        Cyclically demote the kSq-th superbasic to position nS
*        and adjust all arrays that reflect the BS order. 

         do j = kSq, nS-1
            k = m + j
            kBS (k) = kBS (k+1)
            blBS(k) = blBS(k+1)
            buBS(k) = buBS(k+1)
            xBS (k) = xBS (k+1)
         end do

         if ( gotR ) then
*           ------------------------------------------------------------
*           Cyclically demote column kSq of R to position nS.
*           ------------------------------------------------------------
            if (kSq .lt. nS) then
               call s6Rcyc( kSq, nS, eps, lenR, nS, R, y )
            end if
         end if ! ObjPhs and gotH

         nS  = nS  - 1
         nBS = nBS - 1

*-->     R can be checked here.

      end if ! hitcon

  900 return

 1000 format(' XXX  s5QPit:  chzq failed!!')

      end ! of s5QPit

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5Rcol( Hprod, Hprod1, inform, minimz, jq, jRadd,
     &     lenR, m, mBS, n, nb, Hcalls, nnH, nS,
     &     ne, nlocA, locA, indA, Acol, 
     &     iHvar, jHvar, lenH, neH, H, kBS, R, v, w, y,
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      external
     &     Hprod, Hprod1
      integer
     &     inform, minimz, Hcalls, jRadd, jq, nS, lenH, lenR,
     &     m, mBS, n, nb, ne, neH, nlocA, nnH,
     &     lencu, leniu, lenru, lencw, leniw, lenrw,
     &     locA(nlocA), indA(ne), iHvar(lenH), jHvar(lenH),
     &     kBS(mBS), iu(leniu), iw(leniw)
      double precision
     &     Acol(ne), H(lenH), R(lenR), v(nb), w(nb), y(mBS),
     &     ru(lenru), rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     s5Rcol  computes column jRadd of the Cholesky factor R such that 
*     R'R = Z'HZ.  The update corresponds to the addition of a new 
*     column to Z.
*
*     On entry, 
*        R     holds the columns of the factor associated with the 
*              first jRadd-1 columns of Q.
*
*        y     is the vector such that B y = a(jq).
*
*        nS    is the number of columns in R.
*
*     11 Dec 1991: First version based on Qpsol routine Qpcolr.
*     24 Apr 1994: Columns of Nx no longer in Q.
*     27 Oct 2000: Current version of s5Rcol.
*     ==================================================================
      integer
     &     nBS, lencol, lcR, ldR, Status
      double precision
     &     eps0, Rnrmsq, sgnObj, wHw, ddot
*     ------------------------------------------------------------------
      integer            Transp
      parameter         (Transp = 1)
      integer            WithRt
      parameter         (WithRt = 1)
      integer            WithBt   
      parameter         (WithBt = 2)
      integer            Gather,     Scattr
      parameter         (Gather = 0, Scattr = 1)

      double precision   zero,          one
      parameter         (zero = 0.0d+0, one = 1.0d+0)
*     ------------------------------------------------------------------
      eps0      = rw(  2)

      nBS       = m   + nS
      sgnObj    = minimz

      lencol    = min( jRadd-1, nnH )
      lcR       = 1   + (jRadd - 1)*jRadd/2
      ldR       = lcR +  jRadd - 1

*     ------------------------------------------------------------------
*     Get w, the vector of nonlinear components of the new column of Z.
*     ------------------------------------------------------------------
*     The input vector y satisfies B y = column jq.
*     Scatter the nonlinear components of y into w.

      call s2copy( Scattr, nnH, m, kBS, (-one), w, y )
      if (jq .le. nnH) w(jq) = one

*     ------------------------------------------------------------------
*     Compute  H*w  and  w'*H*w.
*     ------------------------------------------------------------------
      wHw = zero
      
      if (nnH .gt. 0) then
         Status = 0
         call Hprod ( Hprod1, Hcalls, nnH,
     &        iHvar, jHvar, lenH, neH, H,
     &        w, v, Status, 
     &        cu, lencu, iu, leniu, ru, lenru, 
     &        cw, lencw, iw, leniw, rw, lenrw )
         wHw = wHw + ddot ( nnH, w, 1, v, 1 ) 
      end if

      if (minimz .lt. 0) then
         call dscal ( nnH, sgnObj, v, 1 )
         wHw = sgnObj*wHw
      end if

      Rnrmsq = zero

      if (jRadd .gt. 1) then
*        ---------------------------------------------------------------
*        Gather the nonlinear elements of v  in w (= vBS)  
*        Compute Z'w (i.e., solve  B' vB = wB and form  wS = wS - S' vB)
*        and store it in column jRadd of R. 
*        ---------------------------------------------------------------
         call s2copy( Gather, nnH, nBS, kBS, one, v, w )
         call s2Bsol( WithBt, inform, m, w, v, iw, leniw, rw, lenrw  )

         if (nS .gt. 0) then
            call s2Bprd( Transp, eps0, n, nS, kBS(m+1),
     &           ne, nlocA, locA, indA, Acol,
     &           (-one), v, m, one, w(m+1), nS ) 
         end if

*        -----------------------------------------------------
*        Solve  R' v = Z(j)'Hw.  Store v in column jRadd of R.
*        -----------------------------------------------------
         call dcopy ( lencol, w(m+1), 1, R(lcR), 1 )
         call s6Rsol( WithRt, lenR, lencol, R, R(lcR) )
         Rnrmsq = ddot  ( lencol, R(lcR), 1, R(lcR), 1 )
      end if

      if (jRadd .le. nnH) then
         R(ldR) = wHw - Rnrmsq
      else
         R(ldR) = zero
      end if

      end ! of s5Rcol

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5rg  ( m, nBS, n, nS, tolz,
     &     ne, nlocA, locA, indA, Acol,
     &     gBS, pi, rg, rgNorm, kBS )

      implicit
     &     none
      integer
     &     m, nBS, n, ne, nlocA, nS, locA(nlocA), indA(ne), kBS(nBS)
      double precision
     &     tolz, rgNorm, Acol(ne), gBS(nBS), pi(m), rg(nS)

*     ==================================================================
*     s5rg    calculates the reduced gradient  rg = gS - S'*pi.
*
*     23 Nov 1991: First version based on Minos routine m7rg.
*     21 Apr 1999: Current version.
*     ==================================================================
      integer
     &     kmax, idamax
*     ------------------------------------------------------------------
      integer            Transp
      parameter         (Transp = 1)
      double precision   one
      parameter         (one = 1.0d+0)
*     ------------------------------------------------------------------
      call dcopy ( nS, gBS(m+1), 1, rg, 1 )

      call s2Bprd( Transp, tolz, n, nS, kBS(m+1),
     &     ne, nlocA, locA, indA, Acol,
     &     (-one), pi, m, one, rg, nS ) 

      kmax   = idamax( nS, rg, 1 )
      rgNorm = abs( rg(kmax) )

      end ! of s5rg

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5Rsng( eigH, PosDef, Singlr, itn,
     &     lenR, nS, dRsq, R, iw, leniw, rw, lenrw )

      implicit
     &     none
      logical
     &     PosDef, Singlr
      integer
     &     eigH, itn, lenR, nS, leniw, lenrw, iw(leniw)
      double precision
     &     dRsq, R(lenR), rw(lenrw)

*     ==================================================================
*     s5Rsng  estimates the inertia of the current reduced Hessian.
*
*     15 Jul 1995: First version of s5Rsng.
*     04 Sep 2000: Current version.
*     ==================================================================
      integer
     &     iPrint, iSumm, j, l
      double precision
     &     Hcndbd, Rsize, dRsqmn, dRmax
*     ------------------------------------------------------------------
      integer            PSDEF,     PDEF
      parameter         (PSDEF = 0, PDEF  = 1)
      double precision   zero,           one
      parameter         (zero  = 0.0d+0, one = 1.0d+0)
*     ------------------------------------------------------------------
      Hcndbd    = rw( 85) ! bound on the condition of Hz
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file

      Rsize     = one

      if (nS .eq. 0) then
*        ---------------------------------------------------------------
*        Vertices are positive definite by definition.
*        ---------------------------------------------------------------
         PosDef = .true.
         Singlr = .false.

      else
*        ---------------------------------------------------------------
*        Compute dRsqmn, the square of the smallest possible diagonal
*        of a positve-definite reduced Hessian.
*        ---------------------------------------------------------------
         if (nS .eq. 1) then
            dRsqmn = Rsize*(Rsize/Hcndbd)
         else 
            dRmax  = abs( R(1) )
            l      = 1
            do j     = 2, nS-1
               l     = l + j
               dRmax = max( dRmax, abs(R(l)) )
            end do
            dRsqmn = dRmax*(dRmax/Hcndbd)
         end if

         PosDef =      dRsq  .ge. dRsqmn
         Singlr =  abs(dRsq) .lt. dRsqmn

         if (Singlr  .or.  PosDef) then
            if (dRsq .lt. zero) then
               if (eigH .eq. PDEF  .and.  iPrint .gt. 0) then
                  write(iPrint, 1000) itn, dRsq, dRsqmn
               end if
               dRsq = max( zero, dRsq )
            end if
         else if (eigH .eq. PSDEF  .or.  eigH .eq. PDEF) then
            if (iSumm  .gt. 0) write(iSumm , 9000) itn
            if (iPrint .gt. 0) write(iPrint, 9010) itn, dRsq, dRsqmn
         end if
      end if

      return

 1000 format(' Itn', i7, ' Hessian numerically indefinite.',
     &                   ' Square of diag, min diag = ', 1p, 2e9.1 )
 9000 format(' Itn', i7, ' Indefinite reduced Hessian.' )
 9010 format(' Itn', i7, ' Indefinite reduced Hessian.',
     &                   ' Square of diag, min diag = ', 1p, 2e9.1 )
            
      end ! of s5Rsng

