*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
*     File  sn87sopt.f
*
*     s8dflt   s8Mem    s8solv   s8SQP
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8dflt( Task, cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     Task, lencw, leniw, lenrw, iw(leniw)
      character*8
     &     cw(lencw)
      double precision
     &     rw(lenrw)

*     ==================================================================
*     Task                   Action
*     ----                   ------
*     CheckO      the optional parameter values are checked and possibly
*                 changed to reasonable values. 
*     PrintO      If iPrint > 0 and lprPrm > 0, the parameters are
*                 printed.  (In the specs file,  Suppress parameters
*                 sets iw(3) = 0.)
* 
*     Note that checking occurs before the amount of working storage has
*     been defined. 
*
*     See  snworkspace.f  for full documentation of cw, iw and rw.
*
*     15 Nov 1991: first version.
*     11 Nov 2000: Current version of s8dflt.
*     ==================================================================
      logical
     &     linCon, linear, nlnCon, nonlin
      integer
     &     iCrash, iBack, iDump, iLoadB, iInsrt, iNewB, iOldB, iPnch,
     &     iPrint, iRead, iReprt, iSoln, iSpecs, iSumm, itnlim,
     &     jverf1, jverf2, jverf3, jverf4,
     &     kchk, kdegen, kFac, klog, kreset, ksav, ksumm, lEmode,
     &     lprDbg, lprPrm, lprSch, lprScl, lprSol, LUprnt,
     &     lvlDer, lvlExi, lvlHes, lvlInf, lvlPiv, lvlPrt, lvlPPm,
     &     lvlSch, lvlScl, lvlSrt, lvlTim, lvlVer, m, maxmn, maxCol,
     &     maxR, maxS, mflush, minimz, minmax, minPrc, MjrPrt, mMajor,
     &     mMinor, MnrPrt, mQNmod, mskip, n, never, nnCon, nnL, nnJac,
     &     nnObj, nout, nParPr, nPr1, nPr2, mWSmod, TPivot
      double precision
     &     bigdx, bigFx, c4, c6, chzbnd, Dens1, Dens2, eLmax1, eLmax2,
     &     eps, eps0, eps1, eps2, eps3, eps4, epsrf, eta,
     &     fdint1, fdint2, Hcndbd, plInfy, rmaxS, scltol, small,
     &     tCrash, tolCon, toldj3, tolFac, tolFP, tolNLP, tolpiv, tolQP,
     &     tolRow, tolSwp, tolUpd, tolx, Uspace, Utol1, Utol2, viLim,
     &     wtInf0, xdlim, xPen0 
*     ------------------------------------------------------------------
      integer            LM    , FM
      parameter         (LM = 0, FM = 1) 
      integer            PrintO
      parameter         (PrintO = 1 ) 
      integer            idummy
      parameter         (idummy = -11111)
      double precision   zero,             one
      parameter         (zero   =  0.0d+0, one    = 1.0d+0)
      double precision   four
      parameter         (four   =  4.0d+0)
      double precision   five,             ten
      parameter         (five   =  5.0d+0, ten    = 10.0d+0)
      double precision   tenp6,            hundrd
      parameter         (tenp6  = 1.0d+6,  hundrd = 100.0d+0)

      character*24       Hestyp(3), prbtyp(3), lsrch(0:1), pivtyp(0:1)
      data               Hestyp /' Limited-Memory Hessian.',
     &                           ' Full-Memory Hessian....',
     &                           ' Exact Hessian..........'/
      data               prbtyp /' Maximize...............',
     &                           ' Feasible point only....',
     &                           ' Minimize...............'/
      data               lsrch  /' Nonderiv.  linesearch..',
     &                           ' Derivative linesearch..'/
      data               pivtyp /' LU partial  pivoting...',
     &                           ' LU complete pivoting...'/

*     ------------------------------------------------------------------
*     Set some locJl machine-dependent constants.

      eps       = rw(  1) ! unit round-off.
      eps0      = rw(  2) ! eps**(4/5)
      eps1      = rw(  3) ! eps**(2/3)
      eps2      = rw(  4) ! eps**(1/2)
      eps3      = rw(  5) ! eps**(1/3)
      eps4      = rw(  6) ! eps**(1/4)
*     ------------------------------------------------------------------
*     rw(51)--rw(150): optional parameters set via the specs file.
*     ------------------------------------------------------------------
      tolFP     = rw( 51) ! Minor Phase 1 Opt tol
      tolQP     = rw( 52) ! Minor Phase 2 Opt tol
      tolNLP    = rw( 53) ! Major Optimality tolerance

      tolx      = rw( 56) ! Minor feasibility tolerance.
      tolCon    = rw( 57) ! Major feasibility tolerance.

      tolpiv    = rw( 60) ! excludes small elements of y.
      tolrow    = rw( 61) ! tolerance for the row error.
      tCrash    = rw( 62) ! crash tolerance.

      tolswp    = rw( 65) ! LU swap tolerance.
      tolFac    = rw( 66) ! LU factor tolerance.
      tolUpd    = rw( 67) ! LU update tolerance.
      plInfy    = rw( 70) ! definition of plus infinity.
      bigFx     = rw( 71) ! unbounded objective.
      bigdx     = rw( 72) ! unbounded step.
      epsrf     = rw( 73) ! relative function precision.
      fdint1    = rw( 76) ! (1) forwrd diff. interval
      fdint2    = rw( 77) ! (2) cntrl  diff. interval
      xdlim     = rw( 80) ! Step limit
      vilim     = rw( 81) ! violation limit 
      eta       = rw( 84) ! line search tolerance.
      Hcndbd    = rw( 85) ! bound on the condition of Hz
      wtInf0    = rw( 88) ! infeasibility weight
      xPen0     = rw( 89) ! initial penalty parameter.

      scltol    = rw( 92) ! scale tolerance.
*     ------------------------------------------------------------------
*     rw(151)--rw(180) contain  parmLU  parameters for LUSOL.
*     ------------------------------------------------------------------
      small     = rw(153) ! defn of small real.
      Utol1     = rw(154) ! abs tol for small diag of U.
      Utol2     = rw(155) ! rel tol for small diag of U.
      Uspace    = rw(156) ! limit on waste space in U.
      Dens1     = rw(157) ! switch to search maxcol columns and no rows.
      Dens2     = rw(158) ! switch to dense LU.
*     ------------------------------------------------------------------
*     rw(181)--rw(199) pass parameters into various routines.
*     ------------------------------------------------------------------
      toldj3    = rw(186) ! current optimality tol
*     ------------------------------------------------------------------
*     iw(1)--iw(50): I/O file numbers and dimensions.
*     ------------------------------------------------------------------
      iRead     = iw( 10) ! Standard Input
      iSpecs    = iw( 11) ! Specs (options) file
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      n         = iw( 15) ! # of variables
      m         = iw( 16) ! # of rows of Jcol
      nnJac     = iw( 21) ! # nonlinear Jacobian variables
      nnObj     = iw( 22) ! # variables in Gobj
      nnCon     = iw( 23) ! # of nonlinear constraints
      nnL       = iw( 24) ! # of nonlinear variables
*     ------------------------------------------------------------------
*     iw(51)--iw(150): optional parameters set via the specs file.
*     ------------------------------------------------------------------
      maxR      = iw( 52) ! max columns of R.
      maxS      = iw( 53) ! max # of superbasics
      mQNmod    = iw( 54) ! (ge 0) max # of BFGS updates
      lEmode    = iw( 56) ! >0    => use elastic mode
      kchk      = iw( 58) ! check (row) frequency
      kFac      = iw( 59) ! factorization frequency
      ksav      = iw( 60) ! save basis map
      klog      = iw( 61) ! log/print frequency
      kSumm     = iw( 62) ! Summary print frequency
      kDegen    = iw( 63) ! max. expansions of featol
      kReset    = iw( 64) ! Hessian frequency
      mFlush    = iw( 66) ! Hessian flush
      mSkip     = iw( 67) ! # largest value of nSkip
      lvlSrt    = iw( 69) ! = 0(1) => cold(warm) start
      lvlDer    = iw( 70) ! = 0, 1 or 2, the derivative level
      lvlExi    = iw( 71) ! >0     => exit feasible on error
      lvlHes    = iw( 72) ! 0,1,2  => LM, FM, Exact Hessian
      lvlInf    = iw( 73) ! Elastic option
      lvlPrt    = iw( 74) ! Print Level for the minor itns
      lvlScl    = iw( 75) ! scale option
      lvlSch    = iw( 76) ! >0     => use derivatives in the line search
      lvlTim    = iw( 77) ! Timing level
      lvlVer    = iw( 78) ! Verify level
      lvlPPm    = iw( 79) ! Proximal Point method for x0
      lvlPiv    = iw( 80) ! 0(1) LU threshold partial(complete) pivoting
      lprPrm    = iw( 81) ! > 0    => parms are printed
      lprSch    = iw( 82) ! line search debug starting itn
      lprScl    = iw( 83) ! > 0    => print the scales
      lprSol    = iw( 84) ! > 0    => print the solution 
      lprDbg    = iw( 85) ! > 0    => private debug print
      minmax    = iw( 87) ! 1, 0, -1  => MIN, FP, MAX
      iCrash    = iw( 88) ! Crash option
      itnlim    = iw( 89) ! limit on total iterations
      mMajor    = iw( 90) ! limit on major iterations
      mMinor    = iw( 91) ! limit on minor iterations
      MjrPrt    = iw( 92) ! Major print level
      MnrPrt    = iw( 93) ! Minor print level
      nParPr    = iw( 94) ! # of partial pricing sections
      mWSmod    = iw( 95) ! # of working set changes
      jverf1    = iw( 98) ! col # to start derivative checking
      jverf2    = iw( 99) ! col # to stop  derivative checking
      jverf3    = iw(100) ! col # to start derivative checking
      jverf4    = iw(101) ! col # to stop  derivative checking
      iBack     = iw(120) ! backup file
      iDump     = iw(121) ! dump file
      iLoadB    = iw(122) ! load file
      iNewB     = iw(124) ! new basis file
      iInsrt    = iw(125) ! insert file
      iOldB     = iw(126) ! old basis file
      iPnch     = iw(127) ! punch file
      iReprt    = iw(130) ! report file
      iSoln     = iw(131) ! solution file
*     ------------------------------------------------------------------
*     iw(151)--iw(180) contain luparm parameters for LUSOL.
*     ------------------------------------------------------------------
      nout      = iw(151) ! unit # for printed messages
      LUprnt    = iw(152) ! print level in LU routines
      maxcol    = iw(153) ! lu1fac: max. # columns
*     ------------------------------------------------------------------

      c4         = max( 1.0d-4, eps3 )
      c6         = max( 1.0d-6, eps2 )
      never      = 99999999

*     ===============================================================
*     Check the optional parameters.
*     ===============================================================
      if (nnCon .eq. 0) nnJac = 0
      if (nnJac .eq. 0) nnCon = 0
      nnL = max( nnJac, nnObj )

      linCon     = nnCon   .eq. 0
      nlnCon     = nnCon   .gt. 0
      linear     = nnL     .eq. 0
      nonlin     = nnL     .gt. 0

      if (iBack  .eq. idummy ) iBack  =     0
      if (iDump  .eq. idummy ) iDump  =     0
      if (iLoadB .eq. idummy ) iLoadB =     0
      if (iNewB  .eq. idummy ) iNewB  =     0
      if (iInsrt .eq. idummy ) iInsrt =     0
      if (iOldB  .eq. idummy ) iOldB  =     0
      if (iPnch  .eq. idummy ) iPnch  =     0
      if (iReprt .eq. idummy ) iReprt =     0
      if (iSoln  .eq. idummy ) iSoln  =     0

*     Set unspecified frequencies or silly values to defaults.

      if (kchk   .eq. idummy ) kchk   =    60
      if (kFac   .le.    0   ) then
                               kFac   =   100
              if (nonlin     ) kFac   =    50
      end if
      if (klog  .eq. idummy  ) klog   =     1
      if (kSumm .eq. idummy  ) kSumm  =     1
      if (ksav  .eq. idummy  ) ksav   =   100
      if (kDegen.eq. idummy  ) kDegen = 10000
      if (mFlush.eq. idummy  ) mFlush =     0

*     Sometimes, frequency 0 means "almost never".

      if (kchk   .le. 0      ) kchk   = never
      if (mFlush .le. 0      ) mFlush = never
      if (klog   .le. 0      ) klog   = never
      if (ksav   .le. 0      ) ksav   = never
      if (kSumm  .le. 0      ) kSumm  = never
      if (kDegen .le. 0      ) kDegen = never
      if (kReset .le. 0      ) kReset = never

      if (iCrash .lt. 0      ) iCrash =  3
      if (minmax .eq. idummy ) minmax =  1
      if (minmax .eq. -1) then
                               minimz = -1
                         else
                               minimz =  1
                         end if
      if (MjrPrt .eq. idummy ) MjrPrt =  1
      if (MnrPrt .eq. idummy ) MnrPrt =  0

      if (mMinor .lt. 0      ) mMinor = max( 1000,5*max( n,m ) )
      if (mMajor .lt. 0      ) mMajor = max( 1000,3*max( n,m ) )
      if (mSkip  .lt. 0  .and.  lincon
     &                       ) mSkip  = never
      if (mSkip  .lt. 0  .and.  nlnCon
     &                       ) mSkip  =  2
      if (mWSmod .le. 0      ) mWSmod = 100

      if (lprDbg .lt. 0      ) lprDbg =  0
      if (lprPrm .lt. 0      ) lprPrm =  1
      if (lprSch .lt. 0      ) lprSch = never
      if (lprScl .lt. 0      ) lprScl =  0
      if (lprSol .lt. 0      ) lprSol =  2

      if (lvlSrt .lt. 0      ) lvlSrt =  0
      if (lvlDer .lt. 0  .or.  lvlDer .gt. 3
     &                       ) lvlDer =  3
      if (lvlHes .lt. 0 .and.  nnL  .gt. 75)
     &                         lvlHes = LM
      if (lvlHes .lt. 0 .and.  nnL  .le. 75)
     &                         lvlHes = FM
      if (lvlHes .eq. FM     ) mQNmod = kReset
      if (mQNmod .lt. 0      ) mQNmod = 20

      if (lvlVer .eq. idummy ) lvlVer =  0
      if (lvlVer .lt. 0      ) lvlVer = -1
      if (lvlVer .gt. 3      ) lvlVer =  0

      if (lvlPrt .lt. 0      ) lvlPrt =  0
      if (lvlPrt .gt. 0      ) MjrPrt = lvlPrt

      if (lvlExi .lt. 0  .or.  lvlExi .gt. 1
     &                       ) lvlExi = idummy
      if (lvlExi .eq. idummy ) lvlExi =  0
                               lvlInf =  2
      if (lvlSch .lt. 0      ) lvlSch =  1
      if (lvlPPm .lt. 0      ) lvlPPm =  2
                               lEmode =  1

*     Check superbasics limit and reduced Hessian size.

      if ( nonlin ) then
         if (maxR .gt. 0  .and.  maxS .lt. 0 
     &                       ) maxS   = maxR
         if (maxS .gt. 0  .and.  maxR .lt. 0
     &                       ) maxR   = maxS

         if (maxS .lt. 0     ) maxS   = min( 500, nnL+1 )
         if (maxR .lt. 0     ) maxR   = maxS
      end if
      if (maxS   .le. 0      ) maxS   = 1
      if (maxR   .lt. 0      ) maxR   = 0
      if (maxR   .lt. maxS   ) maxR   = maxS

      maxR = max( min( maxR ,n ) , 1 )
      maxS = max( min( maxS ,n ) , 1 )

*     Check other options.

      if (lvlScl .lt. 0   ) then
                               lvlScl = 2
         if ( nonlin )         lvlScl = 1
      end if
                               lvlScl = min( lvlScl, 2 )
      if (lvlScl .eq. 1  .and.  nnL .eq. n)
     &                         lvlScl = 0

      if (nParPr .le. 0   ) then
                               nParPr = 10
         if ( nonlin )         nParPr =  1
      end if
                               minPrc = 10
                               nPr1   = n / nParPr
                               nPr2   = m / nParPr
      if (max( nPr1, nPr2 ) .lt. minPrc) then
                               maxmn  = max( m, n )
                               nParPr = maxmn / min( maxmn, minPrc )
                               nPr1   = n / nParPr ! for printing only
                               nPr2   = m / nParPr ! for printing only
                                         end if
      rmaxS  = maxS
      cHzbnd = max ( one/(hundrd*eps*rmaxS), tenp6 )

      if (plInfy   .lt. zero ) plInfy = 1.0d+20
      if (epsrf    .le. zero ) epsrf  = eps0

      if (bigFx    .le. zero ) bigFx  = 1.0d+15
      if (bigdx    .le. zero ) bigdx  = plInfy
      if (Hcndbd   .le. zero ) Hcndbd = cHzbnd
      if (xdlim    .le. zero ) xdlim  = 2.0d+0
      if (vilim    .le. zero ) vilim  = ten
      if (xPen0    .lt. zero ) xPen0  = zero

      if (tCrash   .lt. zero  .or.
     &    tCrash   .ge. one  ) tCrash = 0.1d+0
      if (eta      .lt. zero  .or.
     &    eta      .gt. one  ) eta    = 0.9d+0

      if (fdint1.le. zero    ) fdint1 = sqrt(epsrf)
      if (fdint2.le. zero    ) fdint2 = epsrf**0.33333d+0

*     ---------------------------------
*     Set up the parameters for lu1fac.
*     ---------------------------------
      if (maxcol .lt.  0     ) maxcol =   5
      if (LUprnt .eq.  idummy) LUprnt =  -1
                               nout   =  iPrint
      if (MnrPrt .gt. 10     ) LUprnt =  0
      if (lprDbg .eq. 51     ) LUprnt =  1
      if (lprDbg .eq. 52     ) LUprnt =  2
      if (iPrint .lt.  0     ) LUprnt = -1
      if (lvlPiv .le.  0     ) lvlPiv =  0
      if (lvlPiv .ge.  1     ) lvlPiv =  1
                               TPivot =  lvlPiv
      if (linear) then
         if (tolFac .lt. one ) tolFac =  hundrd
         if (tolUpd .lt. one ) tolUpd =  ten
      else
         if (lvlPiv .eq.   0  .and.  tolFac .lt. one) 
     &                         tolFac =  five
         if (lvlPiv .eq.   1  .and.  tolFac .lt. one)
     &                         tolFac =  hundrd
         if (tolUpd .lt. one ) tolUpd =  four
      end if
                               eLmax1 =  tolFac
                               eLmax2 =  tolUpd
      if (Utol1    .le. zero ) Utol1  =  eps1
      if (Utol2    .le. zero ) Utol2  =  eps1
      if (Dens2    .lt. zero ) Dens2  =  0.6d+0

      if (small    .le. zero ) small  =  eps0
      if (Uspace   .le. zero ) Uspace =  3.0d+0
      if (Dens1    .le. zero ) Dens1  =  0.3d+0

*     Set some SQP tolerances.
*     Set the minor and major optimality tolerances.
*     Solve the QP subproblems fairly accurately even if the 
*     NLP Optimality Tolerance is big.

      if (tolQP    .le. zero ) tolQP  = c6
      if (tolNLP .le. zero) then
                               tolNLP = c6
         if (epsrf .gt. zero ) tolNLP = sqrt(ten*epsrf)
      end if

      if (tolFP    .lt. zero ) tolFP  =  c6
      if (tolrow   .le. zero ) tolrow =  c4
      if (tolswp   .le. zero ) tolswp =  eps4
      if (tolx     .le. zero ) tolx   =  c6
      if (tolCon   .le. eps  ) tolCon =  c6
                               toldj3 =  tolQP
      if (scltol   .le. zero ) scltol =  0.90d+0
      if (scltol   .ge. one  ) scltol =  0.99d+0
      if (tolpiv   .le. zero ) tolpiv =  eps1

      if (linCon) then
         if (wtInf0.lt. zero ) wtInf0 =  1.0d+0
      else
         if (wtInf0.lt. zero ) wtInf0 =  1.0d+4
      end if

*     Check  START and STOP  column numbers for derivative checking.

      if (jverf1 .le. 0      ) jverf1 = 1
      if (jverf2 .lt. 0      ) jverf2 = nnObj
      if (lvlVer .eq. 2  .or.
     &    lvlVer .eq. 0      ) jverf2 = 0

      if (jverf3 .le. 0      ) jverf3 = 1
      if (jverf4 .lt. 0      ) jverf4 = nnJac
      if (lvlVer .eq. 1  .or.
     &    lvlVer .eq. 0      ) jverf4 = 0

      if (iBack  .eq. iNewB  ) iBack  = 0
      if (itnlim .lt. 0      ) itnlim = max(10000, 10*max(n,m))

      if (Task .eq. PrintO  .and.  iPrint .gt. 0) then
*        ===============================================================
*        Print parameters except if PRINT LEVEL = 0
*                         or SUPPRESS PARAMETERS was specified.
*        ===============================================================
         if (MjrPrt .gt. 0  .and.  lprPrm .gt. 0) then
            linCon = nnCon .eq. 0
            nlnCon = nnCon .gt. 0
            nonlin = nnL   .gt. 0

            call s1page( 1, iw, leniw )
            write(iPrint, 1000)
*           --------------------
*           Files.
*           --------------------
            write(iPrint, 2100) iSoln , iOldB , iRead ,
     &                          iInsrt, iNewB , iPrint,
     &                          iPnch , iBack , iSpecs,
     &                                  iLoadB, iDump
*           --------------------
*           Frequencies.
*           --------------------
            write(iPrint, 2200) klog  , kchk  , ksav  ,
     &                          kSumm , kFac  , kDegen
*           --------------------
*           QP subproblems.
*           --------------------
            write(iPrint, 2300) scltol, tolx  , itnlim,
     &                          lvlScl, tolQP , MnrPrt,
     &                          tCrash, tolpiv, nParPr,
     &                          iCrash, wtInf0, nPr1  ,
     &                                  mWSmod, nPr2
*           --------------------
*           SQP method.
*           --------------------
            write(iPrint, 2400) prbtyp(2+minmax),   lvlPPm,
     &                          nnObj , tolNLP, epsrf ,
     &                          bigdx , maxS  , fdint1,
     &                          bigFx , maxR  , fdint2,
     &                          xdlim , lsrch(lvlSch)
     &                                        , lvlDer,
     &                          mMajor, eta   , lvlVer,
     &                          mMinor, xPen0 , MjrPrt

*           --------------------
*           Hessian approximation.
*           --------------------
            if ( nonlin )
     &      write(iPrint, 2500) Hestyp(lvlHes+1),
     &                                   mQNmod, kReset,
     &                                   mFlush
*           --------------------
*           Nonlinear constraints.
*           --------------------
            if ( nlnCon )
     &      write(iPrint, 2600) nnCon , tolCon, vilim,
     &                          nnJac
*           --------------------
*           Miscellaneous
*           --------------------
            write(iPrint, 2700) tolFac        ,  Utol1, lvlTim,
     &                          tolUpd        , tolswp, lprDbg,
     &                          pivtyp(lvlPiv),    eps

            if (iSumm  .gt. 0) write(iSumm, 3000) lvlScl, nParPr
         end if
      end if

*     ------------------------------------------------------------------
*     Re-assign the options to their respective work arrays.
*     ------------------------------------------------------------------
      rw( 51)  =  tolFP   
      rw( 52)  =  tolQP   
      rw( 53)  =  tolNLP  
      rw( 56)  =  tolx    
      rw( 57)  =  tolCon  
      rw( 60)  =  tolpiv  
      rw( 61)  =  tolrow  
      rw( 62)  =  tCrash  
      rw( 65)  =  tolswp  
      rw( 66)  =  tolFac  
      rw( 67)  =  tolUpd  
      rw( 70)  =  plInfy  
      rw( 71)  =  bigFx   
      rw( 72)  =  bigdx   
      rw( 73)  =  epsrf   
      rw( 76)  =  fdint1
      rw( 77)  =  fdint2
      rw( 80)  =  xdlim   
      rw( 81)  =  vilim   
      rw( 84)  =  eta     
      rw( 85)  =  Hcndbd  
      rw( 88)  =  wtInf0  
      rw( 89)  =  xPen0   
      rw( 92)  =  scltol  
      rw(151)  =  eLmax1  
      rw(152)  =  eLmax2  
      rw(153)  =  small   
      rw(154)  =  Utol1   
      rw(155)  =  Utol2   
      rw(156)  =  Uspace  
      rw(157)  =  Dens1   
      rw(158)  =  Dens2   
      rw(186)  =  toldj3

*     Addresses for integer quantities.

      iw( 15)  =  n       
      iw( 16)  =  m       
      iw( 21)  =  nnJac
      iw( 22)  =  nnObj   
      iw( 23)  =  nnCon   
      iw( 24)  =  nnL     
      iw( 52)  =  maxR    
      iw( 53)  =  maxS    
      iw( 54)  =  mQNmod  
      iw( 56)  =  lEmode  
      iw( 58)  =  kchk    
      iw( 59)  =  kFac    
      iw( 60)  =  ksav    
      iw( 61)  =  klog    
      iw( 62)  =  kSumm   
      iw( 63)  =  kDegen  
      iw( 64)  =  kReset  
      iw( 66)  =  mFlush  
      iw( 67)  =  mSkip   
      iw( 69)  =  lvlSrt  
      iw( 70)  =  lvlDer  
      iw( 71)  =  lvlExi  
      iw( 72)  =  lvlHes  
      iw( 73)  =  lvlInf  
      iw( 74)  =  lvlPrt  
      iw( 75)  =  lvlScl  
      iw( 76)  =  lvlSch  
      iw( 77)  =  lvlTim  
      iw( 78)  =  lvlVer  
      iw( 79)  =  lvlPPm
      iw( 80)  =  lvlPiv  
      iw( 81)  =  lprPrm  
      iw( 82)  =  lprSch  
      iw( 83)  =  lprScl  
      iw( 84)  =  lprSol  
      iw( 85)  =  lprDbg  
      iw( 87)  =  minmax  
      iw( 88)  =  iCrash  
      iw( 89)  =  itnlim  
      iw( 90)  =  mMajor  
      iw( 91)  =  mMinor  
      iw( 92)  =  MjrPrt  
      iw( 93)  =  MnrPrt  
      iw( 94)  =  nParPr  
      iw( 95)  =  mWSmod 
      iw( 98)  =  jverf1  
      iw( 99)  =  jverf2  
      iw(100)  =  jverf3
      iw(101)  =  jverf4
      iw(120)  =  iBack
      iw(121)  =  iDump
      iw(122)  =  iLoadB
      iw(124)  =  iNewB   
      iw(125)  =  iInsrt
      iw(126)  =  iOldB   
      iw(127)  =  iPnch
      iw(130)  =  iReprt  
      iw(131)  =  iSoln   
      iw(151)  =  nout    
      iw(152)  =  LUprnt  
      iw(153)  =  maxcol  
      iw(156)  =  TPivot
      iw(199)  =  minimz

      return

 1000 format(  ' Parameters' 
     &       / ' ==========')
 2100 format(/ ' Files'
     &       / ' -----'
     &/ ' Solution file..........', i10, 6x,
     &  ' Old basis file ........', i10, 6x,
     &  ' Standard input.........', i10
     &/ ' Insert file............', i10, 6x,
     &  ' New basis file ........', i10, 6x,
     &  ' (Printer)..............', i10
     &/ ' Punch file.............', i10, 6x,
     &  ' Backup basis file......', i10, 6x,
     &  ' (Specs file)...........', i10
     &/ 40x,
     &  ' Load file..............', i10, 6x,
     &  ' Dump file..............', i10)
 2200 format(/ ' Frequencies'
     &       / ' -----------'
     &/ ' Print frequency........', i10, 6x,
     &  ' Check frequency........', i10, 6x,
     &  ' Save new basis map.....', i10
     &/ ' Summary frequency......', i10, 6x,
     &  ' Factorization frequency', i10, 6x,
     &  ' Expand frequency.......', i10)
 2300 format(/ ' QP subproblems'
     &       / ' --------------'
     &/ ' Scale tolerance........', 0p, f10.3, 6x,
     &  ' Minor feasibility tol..', 1p, e10.2, 6x,
     &  ' Iteration limit........', i10
     &/ ' Scale option...........', i10,       6x,
     &  ' Minor optimality  tol..', 1p, e10.2, 6x,
     &  ' Minor print level......', i10
     &/ ' Crash tolerance........', 0p, f10.3, 6x,
     &  ' Pivot tolerance........', 1p, e10.2, 6x,
     &  ' Partial price..........', i10
     &/ ' Crash option...........', i10,       6x,
     &  ' Elastic weight.........', 1p, e10.2, 6x,
     &  ' Prtl price section ( A)', i10
     &/  40x,
     &  ' Working set changes....', i10,       6x,
     &  ' Prtl price section (-I)', i10)
 2400 format(/ ' The SQP Method'
     &       / ' --------------'
     &/   a24,                                16x,
     &    40x,
     &  ' Proximal Point method..', i10
     &/ ' Nonlinear objectiv vars', i10,       6x,
     &  ' Major optimality tol...', 1p, e10.2, 6x,
     &  ' Function precision.....', 1p, e10.2
     &/ ' Unbounded step size....', 1p, e10.2, 6x,
     &  ' Superbasics limit......', i10,       6x,
     &  ' Difference interval....', 1p, e10.2
     &/ ' Unbounded objective....', 1p, e10.2, 6x,
     &  ' Reduced Hessian dim....', i10,       6x,
     &  ' Central difference int.', 1p, e10.2
     &/ ' Major step limit.......', 1p, e10.2, 6x, 
     &         A11,' linesearch..',           16x,
     &  ' Derivative level.......', i10
     &/ ' Major iterations limit.', i10,       6x,
     &  ' Linesearch tolerance...', 0p, f10.5, 6x,
     &  ' Verify level...........', i10
     &/ ' Minor iterations limit.', i10,       6x,
     &  ' Penalty parameter......', 1p, e10.2, 6x,
     &  ' Major Print Level......', i10 )
 2500 format(/ ' Hessian Approximation'
     &       / ' ---------------------'
     &/  a24,                                 16x, 
     &  ' Hessian updates........', i10,       6x,
     &  ' Hessian frequency......', i10    
     &/  80x,
     &  ' Hessian flush..........', i10 )
 2600 format(/ ' Nonlinear constraints'
     &       / ' ---------------------'
     &/ ' Nonlinear constraints..', i10,       6x,
     &  ' Major feasibility tol..', 1p, e10.2, 6x,
     &  ' Violation limit........',     e10.2
     &/ ' Nonlinear Jacobian vars', i10 )
 2700 format(/ ' Miscellaneous'
     &       / ' -------------'
     &/ ' LU factor tolerance....', 0p, f10.2, 6x,
     &  ' LU singularity tol.....', 1p, e10.2, 6x,
     &  ' Timing level...........', i10
     &/ ' LU update tolerance....', 0p, f10.2, 6x,
     &  ' LU swap tolerance......', 1p, e10.2, 6x,
     &  ' Debug level............', i10
     &/  a24,                                 16x, 
     &  ' eps (machine precision)', e10.2)
 3000 format(/   ' Scale option', i3, ',    Partial price', i4)

      end ! end of s8dflt

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8Mem ( iError, iPrint, iSumm,
     &     m, n, ne, neG, nnCon, nnJac, nnObj,
     &     lenR, maxS,  mQNmod, lvlHes,
     &     maxcw, maxiw, maxrw, lencw, leniw, lenrw, 
     &     mincw, miniw, minrw, iw )
      
      implicit
     &     none
      integer
     &     iError, iPrint, iSumm, lencw, leniw, lenR, lenrw, lvlHes, m,
     &     maxS, mQNmod, maxcw, maxiw, maxrw, mincw, miniw, minrw, n,
     &     ne, neG, nnCon, nnJac, nnObj, iw(leniw)

*     ==================================================================
*     s8Mem   allocates all array storage for snopt,
*     using the values:
*        m    , n    , ne
*        maxS                    Set in s8dflt.
*        nnObj, nnCon, nnJac     Set by specs file or argument list.
*        lenR , neG              Set in calling program
*
*     These values are used to compute the minimum required storage:
*     mincw, miniw, minrw.
*
*     The SPECS file has been read and values are known for
*     maxcu, maxiu, maxru  (upper limit of user  partition 1)
*     maxcw, maxiw, maxrw  (upper limit of SNOPT partition)
*
*     The default values for the first six are
*     maxcu = 500  ,   maxiu = 500  ,   maxru = 500,
*     maxcw = lencw,   maxiw = leniw,   maxrw = lenrw,
*     but we allow the user to alter these in the SPECS file via
*     lines of the form
*     
*        User  character workspace      10000    (Sets maxcu)
*        User  integer   workspace      10000    (Sets maxiu)
*        User  real      workspace      10000    (Sets maxru)
*        Total character workspace      90000    (Sets maxcw)
*        Total integer   workspace      90000    (Sets maxiw)
*        Total real      workspace      90000    (Sets maxrw)
*
*     SNOPT will use only rw(maxru+1:maxrw).  Hence, rw(501:maxru)
*     and possibly rw(maxrw+1:lenrw) may be used as workspace by the
*     user during solution of the problem (e.g., within funobj or
*     funcon).  Similarly for iw(501:maxiu) and iw(maxiw:leniw).
*
*     Setting maxiw and maxrw less than leniw and lenrw may serve to
*     reduce paging activity on a machine with virtual memory, by
*     confining SNOPT (in particular the LU-factorization routines)
*     to an area of memory that is sensible for the current problem.
*     This often allows cw(*), iw(*) and rw(*) to be declared
*     arbitrarily large at compile time.
*
*     On exit.
*        If iError = 0,  mincw, miniw, minrw give the amounts of
*        character, integer and real workspace needed to hold
*        the problem. (The LU factorization routines may 
*        subsequently ask for more.) 
*
*        If iError > 0,  insufficient storage is provided to hold the
*        problem.  In this case, mincw, miniw and minrw give estimates
*        of reasonable lengths for cw(*), iw(*) and rw(*).
*
*     15 Nov 1991: First version based on Minos 5.4 routine m2core.
*     29 Mar 1998: First version called by snMem. This simplified 
*                  version may slightly overestimate needed memory.
*     11 Nov 2000: Current version of s8Mem.
*     ==================================================================
      integer
     &     mBS, nb, ngQP, nlocG, lAscal, lblBS, lblSav, lbuBS, lbuSav,
     &     ldLmul, ldx, ldxHdx, lenALU, lenfH, leng, lFcon,
     &     lFcon1, lFcon2, lfH, lGcon, lGcon1, lGcon2, lGconu, lGobj1,
     &     lGobj2, lGobju, lFv, lFx, lgBS, lGobj, ldg, ldgSav, lgQP,
     &     lH0, lHdSav, lHdx, lhElas, lhEsta, lhfeas, liwEst, liy, liy1,
     &     lkBS, lLmul, lLmul1, lLmul2, llocG, lR, lrg, lQPrhs, lrwEst,
     &     lx0, lx1, lxBS, lxscal, lxPen, lxQP,lxQP0, ly, ly1, ly2, ly3,
     &     lydx, maxcu1, maxiu1, maxru1, mincu1, miniu1, minru1, nnL
*     ------------------------------------------------------------------
      integer            LM   ,      FM
      parameter         (LM     = 0, FM     = 1) 
*     ------------------------------------------------------------------
      nnL     = max( nnJac, nnObj )
      iError  = 0

*     All dimensions are computed from 
*        m    , n    , ne
*        lenR , maxS , nnL  , mQMmod
*        nnObj,    
*        neG  , nnCon, nnJac

      ngQP    = nnL
      leng    = nnL            ! Allows for feasible exit.
            
      mBS     = m     + maxS
      nb      = n     + m

*     Nonlinear constraints.

      nlocG   = nnJac  + 1

*     snopt can use all of cw, iw and rw
*     except the first user workspace partitions.

      lhfeas = miniw
      lkBS   = lhfeas + mBS
      miniw  = lkBS   + mBS

*     QP subproblem.

      lhEsta = miniw
      lhElas = lhEsta + nb
      liy    = lhElas + nb 
      liy1   = liy    + nb
      miniw  = liy1   + nb

*     Addresses for the double precision arrays.

      lAscal = minrw
      ly     = lAscal + nb
      ly1    = ly     + nb
      ly2    = ly1    + nb
      ly3    = ly2    + nb
      lblBS  = ly3    + nb
      lbuBS  = lblBS  + mBS
      lxBS   = lbuBS  + mBS
      lxScal = lxBS   + mBS
      lgBS   = lxscal + nnL
      lgQP   = lgBS   + mBS
      lHdx   = lgQP   + ngQP
      lH0    = lHdx   + nnL
      ldg    = lH0    + nnL
      lR     = ldg    + nnL
      lrg    = lR     + lenR
      minrw  = lrg    + maxS

*     Nonlinear Objective.

      lGobj  = minrw
      lGobj1 = lGobj  + leng
      lGobj2 = lGobj1 + leng
      lGobju = lGobj2 + leng
      minrw  = lGobju + leng

*     Nonlinear constraints.

      llocG  = miniw
      miniw  = llocG  + nlocG

      lFcon  = minrw
      lFcon1 = lFcon  + nnCon
      lFcon2 = lFcon1 + nnCon
      lFx    = lFcon2 + nnCon
      lFv    = lFx    + nnCon
      lblSav = lFv    + nnCon
      lbuSav = lblSav + nb
      lLmul  = lbuSav + nb
      lLmul1 = lLmul  + nnCon
      lLmul2 = lLmul1 + nnCon
      ldLmul = lLmul2 + nnCon
      lxPen  = ldLmul + nnCon
      lGcon  = lxPen  + nnCon
      lGcon1 = lGcon  + neG
      lGcon2 = lGcon1 + neG
      lGconu = lGcon2 + neG
      lQPrhs = lGconu + neG
      ldx    = lQPrhs + m
      lxQP   = ldx    + nb
      lxQP0  = lxQP   + nb
      lx0    = lxQP0  + nb
      lx1    = lx0    + nnL
      minrw  = lx1    + nb

*     Store the addresses in iw.

      iw(260) = llocG

      iw(273) = lblBS
      iw(274) = lbuBS
      iw(275) = lblSav
      iw(276) = lbuSav

      iw(278) = lQPrhs

      iw(283) = lhElas
      iw(284) = lhfeas
      iw(285) = lhEsta

      iw(287) = ldx
      iw(288) = lHdx
      iw(289) = ldg
      iw(290) = lgQP
      iw(291) = lgBS
      iw(292) = lkBS
      iw(293) = lrg
      iw(294) = lR
      iw(295) = lAscal
      iw(296) = lGobj
      iw(298) = lx0

      iw(300) = lx1
      iw(301) = lxBS
      iw(302) = lxscal

      iw(304) = lxPen
      iw(305) = lxQP
      iw(306) = lxQP0

      iw(308) = liy
      iw(309) = liy1
      iw(311) = ly
      iw(312) = ly1
      iw(313) = ly2
      iw(314) = ly3

      iw(316) = lFcon
      iw(317) = lFcon1
      iw(318) = lFcon2
      iw(319) = lGconu
      iw(320) = lGcon
      iw(321) = lGcon1
      iw(322) = lGcon2
      iw(323) = lGobju
      iw(324) = lGobj1
      iw(325) = lGobj2

      iw(336) = lFx
      iw(340) = lFv
      iw(346) = lH0

      iw(348) = lLmul
      iw(349) = lLmul1
      iw(350) = lLmul2
      iw(351) = ldLmul

*     Allocate space for an approximate Hessian. 
*     The amount will depend on the method selected.

      if (lvlHes .eq. LM) then
*        ---------------------------------------------------------------
*        Compute the addresses of the limited-memory arrays.
*        These are saved and used for subsequent entries.
*        ---------------------------------------------------------------
         ldgSav    = minrw
         lHdSav    = ldgSav + nnL*mQNmod
         lydx      = lHdSav + nnL*mQNmod
         ldxHdx    = lydx   +     mQNmod
         minrw     = ldxHdx +     mQNmod

         iw(402)   = ldgSav 
         iw(403)   = lHdSav
         iw(404)   = lydx
         iw(405)   = ldxHdx

      else if (lvlHes .eq. FM) then
         lenfH   = nnL*(nnL + 1)/2
         lfH     = minrw
         minrw   = lfH    + lenfH

         iw(391) = lfH
         iw(392) = lenfH
      end if

*     ------------------------------------------------------------------
*     Allocate arrays for the basis factorization routines.
*     miniw, minrw point to the beginning of the LU factorization.
*     ------------------------------------------------------------------
      call s2Bmap( m, n, ne,
     &     miniw, minrw, maxiw, maxrw, liwEst, lrwEst,
     &     iw, leniw )

      mincw   = mincw  -  1     ! Char storage estimate is exact

      lenALU  = iw(213)

*     ------------------------------------------------------------------
*     Print details of the workspace.
*     ------------------------------------------------------------------
      mincu1  = iw( 31)         ! Start of first  user partition of cw
      miniu1  = iw( 36)         ! Start of first  user partition of iw
      minru1  = iw( 41)         ! Start of first  user partition of rw

      maxcu1  = iw( 32)         ! End   of first  user partition of cw 
      maxiu1  = iw( 37)         ! End   of first  user partition of iw 
      maxru1  = iw( 42)         ! End   of first  user partition of rw 

      if (iPrint .gt. 0) then
         write(iPrint, 1100) maxcw, maxiw, maxrw, mincw,  miniw, minrw
         if (maxcu1 .ge. mincu1) write(iPrint, 1201) mincu1, maxcu1
         if (maxiu1 .ge. miniu1) write(iPrint, 1202) miniu1, maxiu1
         if (maxru1 .ge. minru1) write(iPrint, 1203) minru1, maxru1
      end if

      if (mincw .gt. maxcw   .or.  miniw .gt. maxiw 
     &                       .or.  minrw .gt. maxrw) then 
*        ---------------------------------------------------------------
*        Not enough workspace to solve the problem.
*        ---------------------------------------------------------------
         if (iPrint .gt. 0) write(iPrint, 9400)
         if (iSumm  .gt. 0) write(iSumm , 9400)

         if (mincw  .gt. lencw ) then
*           ------------------------------------------------------------
*           Not enough character workspace.
*           ------------------------------------------------------------
            iError = 42
            if (iPrint .gt. 0) write(iPrint, 9420) mincw
            if (iSumm  .gt. 0) write(iSumm , 9420) mincw
         end if

         if (     miniw .gt. leniw) then
*           ------------------------------------------------------------
*           Not enough integer workspace.
*           ------------------------------------------------------------
            miniw  = liwEst
            iError = 43
            if (iPrint .gt. 0) write(iPrint, 9430) miniw
            if (iSumm  .gt. 0) write(iSumm , 9430) miniw
         end if

         if (minrw  .gt. lenrw ) then
*           ------------------------------------------------------------
*           Not enough real    workspace.
*           ------------------------------------------------------------
            minrw  = lrwEst
            iError = 44
            if (iPrint .gt. 0) write(iPrint, 9440) minrw
            if (iSumm  .gt. 0) write(iSumm , 9440) minrw
         end if
      end if

      if (iError .eq. 0  .and.  lenALU .eq. 0) then
*        -------------------------------------------
*        Insufficient storage to factorize B.
*        -------------------------------------------
         iError = 20
         if (iPrint .gt. 0) write(iPrint, 9500)
         if (iSumm  .gt. 0) write(iSumm , 9500)
         if (iPrint .gt. 0)
     &      write(iPrint, 9501) maxiw, liwEst, maxrw, lrwEst
         if (iSumm  .gt. 0)
     &      write(iSumm , 9501) maxiw, liwEst, maxrw, lrwEst
         miniw  = liwEst
         minrw  = lrwEst

      end if

      return

 1100 format(/ ' Total char*8  workspace', i10, 6x,
     &         ' Total integer workspace', i10, 6x,
     &         ' Total real    workspace', i10
     &       / ' Total char*8  (minimum)', i10, 6x,
     &         ' Total integer (minimum)', i10, 6x,
     &         ' Total real    (minimum)', i10/)
 1201 format(  ' Elements cw(', i10, ':',i10, ')', 6x, 'are free',
     &         ' for USER CHAR*8  WORKSPACE')
 1202 format(  ' Elements iw(', i10, ':',i10, ')', 6x, 'are free',
     &         ' for USER INTEGER WORKSPACE')
 1203 format(  ' Elements rw(', i10, ':',i10, ')', 6x, 'are free',
     &         ' for USER REAL    WORKSPACE')

 9400 format(  ' EXIT -- not enough storage to start solving',
     &         ' the problem...' )
 9420 format(/ ' Total character workspace should be significantly',
     &         ' more than', i8)
 9430 format(/ ' Total integer   workspace  should be significantly',
     &         ' more than', i8)
 9440 format(/ ' Total real      workspace  should be significantly',
     &         ' more than', i8)
 9500 format(  ' EXIT -- not enough storage',
     &         ' for the basis factors')
 9501 format(/ 24x, '        Current    Recommended'
     &       / ' Total integer workspace', 2i15
     &       / ' Total real    workspace', 2i15)

      end ! of s8Mem

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8solv( Start, fgwrap, fgcon, fgobj, MjrLog, MnrLog,
     &     m, n, nb, nName, iObj, ObjAdd, Fobj, ObjTru, nInf, sInf,
     &     ne, nlocJ, locJ, indJ, Jcol, bl, bu, Names, 
     &     hs, x, pi, rc, inform, nMajor, nS,
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      external
     &     fgwrap, fgcon, fgobj, MjrLog, MnrLog
      integer
     &     Start, inform, iObj, m, n, nb, ne, nlocJ, nInf, nName, nS,
     &     lencu, lencw, leniu, leniw, lenru, lenrw, locJ(nlocJ),
     &     indJ(ne), hs(nb), iu(leniu), iw(leniw)
      double precision
     &     ObjAdd, Fobj, sInf, Jcol(ne), bl(nb), bu(nb), x(nb), pi(m),
     &     rc(nb), ru(lenru), rw(lenrw)
      character*8
     &     Names(nName), cu(lencu), cw(lencw)

*     ==================================================================
*     s8solv solves the current problem.
*
*     On entry,
*     the specs file has been read,
*     all data items have been loaded (including locJ, indJ, Jcol, ...),
*     and workspace has been allocated within z.
*
*     On exit,
*     inform  =  0 if an optimal solution was found,
*             =  1 if the problem was infeasible,
*             =  2 if the problem was unbounded,
*             =  3 if the Iteration limit was exceeded,
*            ge  4 if iterations were terminated by some other
*                  error condition (see the SNOPT user's guide).
*
*     15 Nov 1991: First version based on Minos 5.4 routine misolv.
*     13 Feb 1994: Eliminated "Cycle" options.
*                Simplified s4getb.
*     12 Nov 1994: Integer workspace added.
*     25 Jul 1996: Sign of the slacks changed. 
*     28 Sep 1997: Character workspace added.
*     11 Nov 1997: Backtracking for undefined functions.
*     26 Dec 1997: Dummy Jacobian scaled in feasibility phase.
*     27 Aug 1998: Constant Jacobian elements handled correctly.
*     10 Oct 1998: Objective and constraint gradient checking merged.
*     11 Oct 1998: Facility to combine funobj and funcon added.
*     23 Dec 1999: Suboptimize option added.
*     11 Nov 2000: Current version of s8solv.
*     ==================================================================
      logical
     &     done, FPonly, linInf, nlnInf, needB, nlnCon, nlnObj, nonlin
      integer
     &     eigH, itn, iCrash, iError, inewB, iPrint, iSumm, itnlim, j,
     &     k, lenR, lenx0, lCrash, lsSave, lvlDer, lvlDif, lvlExi,
     &     lvlHes, lvlScl, lvlSch, lAscal, lblBS, lbuBS, lblSav,
     &     lbuSav, ldlmul, ldx, lFv, lFx, lFcon, lFcon1, lFcon2, lGcon,
     &     lGcon1, lGcon2, lGconu, lGobj1, lGobj2, lGobju, lgBS, lGobj,
     &     lgQP, ldg, lHdx, lhElas, lhEsta, lhfeas, liy, liy1, lkBS,
     &     lLmul, lLmul1, lLmul2, llocG, lQPrhs, lR, lrg, lx0, lx1,
     &     lxBS, lxPen, lxQP, lxQP0, ly, ly1, ly2, ly3, maxS, maxvi,
     &     mBS, minimz, minmax, minSav, MjrPrt, MnrPrt, modefg,
     &     mProb, mtry, nDegen, nFac, nFcon1, nFcon2, nFcon3, nFcon4,
     &     nFobj1, nFobj2, nFobj3, nFobj4, neG, nlocG, nMajor, nMinor,
     &     nnb, nnL0, nnL, nnJac, nnObj, nnObj1, nnCon0, nnCon1, nnCon,
     &     numLC, nrhs0, nrhs, numLIQ, ntry, nx0, Status
      double precision
     &     bigFx, Degen, dnrm1s, duInf, eps0, fLin, fMrt, ObjTru,
     &     PenNrm, plInfy, piNorm, pNorm1, pNorm2, rgNorm, sclObj,
     &     sgnObj, xNorm, tolFP, tolQP, tolx, tCrash, viLim, viMax,
     &     viRel, viSup, wtInf, wtInf0
      character*4
     &     istate(3)
*     ------------------------------------------------------------------
      double precision   zero,            one,          ten
      parameter         (zero   = 0.0d+0, one = 1.0d+0, ten = 10.0d+0)
      parameter         (mtry   = 1)
      integer            SEMDEF,     POSDEF
      parameter         (SEMDEF = 0, POSDEF = 1)
      integer            Scale,      UnScal
      parameter         (Scale  = 0, UnScal = 1)
      integer            RowTyp,          Stats
      parameter        ( Rowtyp = 0,      Stats  = 1 )
      integer            Wrap
      parameter         (Wrap   = 1)
      integer            SaveB,      PrintS
      parameter         (SaveB  = 0, PrintS = 1)
      integer            LM        , FM
      parameter         (LM     = 0, FM     = 1) 
      integer            xBound,     xMove
      parameter         (xBound = 0, xMove  = 1)
      integer            SetxSQ,     SetxFG
      parameter         (SetxSQ = 0, SetxFG = 1)

      parameter         (lvlDer =  70) ! = 0,1,2 or 3, deriv level
      parameter         (lvlHes =  72) ! 0,1,2  => LM, FM, Newton
      parameter         (lvlScl =  75) ! scale option
      parameter         (minmax =  87) ! 1, 0, -1  => MIN, FP, MAX
      parameter         (eigH   = 200) ! =1(0) for pd  QP Hessian
      parameter         (lvlDif = 182) ! =1(2) for forwd(cntrl) diffs
      parameter         (nFcon1 = 189) ! number of calls of Fcon
      parameter         (nFcon2 = 190) ! number of calls of Fcon
      parameter         (nFcon3 = 191) ! number of calls of Fcon
      parameter         (nFcon4 = 192) ! number of calls of Fcon
      parameter         (nFobj1 = 194) ! number of calls of Fobj
      parameter         (nFobj2 = 195) ! number of calls of Fobj
      parameter         (nFobj3 = 196) ! number of calls of Fobj
      parameter         (nFobj4 = 197) ! number of calls of Fobj
      parameter         (nFac   = 210) ! # of LU factorizations
      parameter         (mProb  =  51) ! Name of the problem
*     ------------------------------------------------------------------
      iPrint = iw( 12) ! Print file
      iSumm  = iw( 13) ! Summary file
      iNewB  = iw(124) ! new basis file
             
      neG    = iw( 20) ! # of nonzero elems in J
      nnJac  = iw( 21) ! # nonlinear Jacobian variables
      nnObj  = iw( 22) ! # variables in Gobj
      nnCon  = iw( 23) ! # of nonlinear constraints
      nnL    = iw( 24) !   max( nnObj, nnJac )
             
      lenR   = iw( 28) ! R(lenR) is the reduced Hessian factor
      maxS   = iw( 53) ! max # of superbasics
             
      lvlExi = iw( 71) ! >0     => exit feasible on error
      lvlSch = iw( 76) ! >0     => use derivatives in the line search
             
      iCrash = iw( 88) ! Crash option
      itnlim = iw( 89) ! limit on total iterations
             
      MjrPrt = iw( 92) ! Major print level
      MnrPrt = iw( 93) ! Minor print level
      minimz = iw(199) ! 1 (-1)    => minimize (maximize)
             
      eps0   = rw(  2)
      tolFP  = rw( 51) ! Minor Phase 1 Opt tol
      tolQP  = rw( 52) ! Minor Phase 2 Opt tol
      tolx   = rw( 56) ! Minor feasibility tolerance.
      tCrash = rw( 62) ! crash tolerance.
      plInfy = rw( 70) ! definition of plus infinity.
      bigFx  = rw( 71) ! unbounded objective.
      vilim  = rw( 81) ! violation limit 
      wtInf0 = rw( 88) ! infeasibility weight

*     Addresses

      llocG  = iw(260) ! locG(nnJac+1) = column pointers for indG
      lhElas = iw(283) ! hElast(nb) list of elastic vars
      lhfeas = iw(284) ! hfeas(mBS), feasibility types
      lhEsta = iw(285) ! hEstat(nb), status of elastics
      lkBS   = iw(292) ! kBS(mBS), ( B  S ) list
      lblBS  = iw(273) ! blBS(mBS)   = lower bounds for xBS
      lbuBS  = iw(274) ! buBS(mBS)   = upper bounds for xBS
      lxBS   = iw(301) ! xBS(mBS)    = basics, superbasics 
      lgQP   = iw(290) ! gQP(ngQP)   = QP gradient 
      lgBS   = iw(291) ! gBS(mBS)    = BS components of g
      lAscal = iw(295) ! Ascale(nb)  = row and column scales
      lGobj  = iw(296) ! Gobj(nnObj) = Objective gradient
      lx1    = iw(300) ! x1(nb)      = new x, used to store x0
      lrg    = iw(293) ! rg(maxS)    = reduced gradient
      lR     = iw(294) ! R(lenR)     = factor of Z'HZ
      liy    = iw(308) ! iy(nb)      =  integer work vector
      liy1   = iw(309) ! iy1(nb)     =  integer work vector
      ly     = iw(311) ! y(nb)       =  real work vector
      ly1    = iw(312) ! y1(nb)      =  real work vector
      ly2    = iw(313) ! y2(nb)      =  real work vector
      ly3    = iw(314) ! y3(nb)      =  real work vector
      lQPrhs = iw(278) ! QPrhs(nnCon)=  QP constraint rhs 
      ldx    = iw(287) ! dx(nb)      = x1 - x
      lHdx   = iw(288) ! Hdx(nnL)    = product of H with  x1 - x
      ldg    = iw(289) ! dg(nnL)     = gradient difference 
      lFcon  = iw(316) ! Fcon (nnCon) constraints at x
      lFcon1 = iw(317) ! Fcon1(nnCon) constraints at x1
      lFcon2 = iw(318) ! Fcon2(nnCon) work vector
      lGconu = iw(319) ! record of unknown derivatives and constants
      lGcon  = iw(320) ! Gcon (neG)   constraint gradients at x
      lGcon1 = iw(321) ! Gcon1(neG)   constraint gradients at x1
      lGcon2 = iw(322) ! Gcon2(neG)   work vector
      lGobju = iw(323) ! record of unknown derivatives
      lGobj1 = iw(324) ! Gobj1(nnObj) objective gradients at x1
      lGobj2 = iw(325) ! Gobj2(nnObj) work Gobj
             
      lFx    = iw(336) ! Fx (nnCon)  = F(x) + A(linear)x 
      lFv    = iw(340) ! Fv          = F(x) + A(linear)x - sN
      lblSav = iw(275) ! blSav(nb)   = copy of bl
      lbuSav = iw(276) ! buSav(nb)   = copy of bu
      lx0    = iw(298) ! x0(nnL)     = Feasible starting point

      lLmul  = iw(348) ! Lmul (nnCon)  = multipliers for F
      lLmul1 = iw(349) ! Lmul1(nnCon)  = Lmul at x1
      lLmul2 = iw(350) ! Lmul2(nnCon)  = work copy of Lmul
      ldLmul = iw(351) ! dLmul(nnCon)  = Lmul1 - Lmul
      lxPen  = iw(304) ! xPen(nnCon)   = penalty params
      lxQP   = iw(305) ! xQP(nb)     = QP solution
      lxQP0  = iw(306) ! xQP0(nb)    = QP feasible pt.

      FPonly = iw(minmax) .eq. 0

      nlnCon = nnCon  .gt. 0
      nlnObj = nnObj  .gt. 0
      nonlin = nnL    .gt. 0

      nnCon0 = max( nnCon, 1 )
      nnL0   = max( nnL  , 1 )
      nx0    = nnL
      lenx0  = nnL0
      mBS    = m     + maxS
      nlocG  = nnJac + 1
             
      numLC  = m - nnCon

*     Initialize Lmul from pi.
*     Zap the linear pi(i) in case they are printed without being set.

      if (nlnCon      ) call dcopy ( nnCon,       pi, 1, rw(lLmul), 1 )
      if (numLC .gt. 0) call dload ( numLC, zero, pi(nnCon+1), 1 )

*     Initialize a few things.
*     Define the Hessian type for the QP subproblem.

      if (iw(lvlHes) .eq. LM  .or.  iw(lvlHes) .eq. FM) then  
         if (nnL .lt. n) then
            iw(eigH) = SEMDEF
         else
            iw(eigH) = POSDEF
         end if
      end if

      iError     = 0
      iw(lvlDif) = 1
      iw(nFac)   = 0
      nInf       = 0
      wtInf      = one

      duInf      = zero
      fMrt       = zero
      Fobj       = zero
      ObjTru     = zero
      PenNrm     = zero
      piNorm     = zero
      sgnObj     = minimz

      call iload ( 4, 0, iw(nFcon1), 1 )
      call iload ( 4, 0, iw(nFobj1), 1 )

      itn        = 0
      nDegen     = 0
      nMajor     = 0
      nMinor     = 0

      call s1page( 1, iw, leniw )

*     ------------------------------------------------------------------
*     Print the matrix statistics before the nonlinear part of Jcol is
*     loaded with random elements.  The rowtypes are also computed ready
*     for use in s5getB.
*     ------------------------------------------------------------------
      call s2Amat( Stats, m, n, nb,
     &     nnCon, nnJac, nnObj, iObj,
     &     ne, nlocJ, locJ, indJ, Jcol,
     &     bl, bu,  iw(lhEsta),
     &     iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     s8Gloc constructs column pointers for the nonlinear Jacobian.
*     Copy J into Gcon and Gcon2.  This has the effect of loading the
*     constant Jacobian elements in Gcon and Gcon2, ready to be scaled.
*     If lvlDer is 2 or 3, make a permanent copy of J in Gconu.
*     Load the nonlinear part of J with dummy (random) elements.
*     ------------------------------------------------------------------
      if ( nlnCon ) then
         call s8Gloc( nnCon, nnJac,
     &        ne, nlocJ, locJ, indJ, neG, nlocG, iw(llocG) )
         call s8Gcpy( nnCon, nnJac, ne, nlocJ, locJ, indJ, 
     &        ne , nlocJ,     locJ,      Jcol,
     &        neG, nlocG, iw(llocG), rw(lGcon) )
         call dcopy ( neG, rw(lGcon), 1, rw(lGcon1), 1 )
         call dcopy ( neG, rw(lGcon), 1, rw(lGcon2), 1 )
         if (iw(lvlDer) .ge. 2)
     &   call dcopy ( neG, rw(lGcon), 1, rw(lGconu), 1 )

         call s8rand( neG, neG, rw(lGcon) )
         call s8Gcpy( nnCon, nnJac, ne, nlocJ, locJ, indJ, 
     &        neG, nlocG, iw(llocG), rw(lGcon), 
     &        ne , nlocJ,     locJ ,     Jcol )
         call dcopy ( neG, rw(lGcon), 1, rw(lGcon2), 1 )
      end if

      nrhs  = 0                 ! No rhs when finding the first basis
      nrhs0 = 1

      call iload ( nb, 0, iw(lhElas), 1 )
      call s5getB( Start, MnrLog, needB, iError, m, maxS, mBS,
     &     n, nb, nnCon, nnJac, nnObj, nName, nS, itnlim, nMinor, itn, 
     &     nDegen, numLC, numLIQ, tolFP, tolQP, tolx,
     &     nInf, sInf, wtInf, iObj, sclObj, piNorm, rgNorm,
     &     ne, nlocJ, locJ, indJ, Jcol,
     &     iw(lhElas), iw(lhEsta), iw(lhfeas), hs, iw(lkBS), Names,
     &     rw(lAscal), bl, bu,rw(lblBS),rw(lbuBS),rw(lblSav),rw(lbuSav), 
     &     rw(lgBS), pi, rc, nrhs0, nrhs, rw(lQPrhs),
     &     lenx0, nx0, rw(lx1), x, rw(lxBS),
     &     iw(liy), iw(liy1), rw(ly), rw(ly1), rw(ly2), rw(ly3),
     &     cw, lencw, iw, leniw, rw, lenrw )
      if (iError .ne. 0) go to 900

*     ==================================================================
*     Satisfy the linear constraints.
*     The norm of x is minimized via a proximal-point QP.
*     If no feasible point can be found, the linear rows can be elastic.
*     ==================================================================
      if (numLC .gt. 0) then
         if (iError .eq. 0) then
            call s8feas( MnrLog, iError, lenR, m, maxS, mBS,
     &           n, nb, nnCon0, nnCon, nnL0, nnL, nDegen, nS,
     &           numLC, numLIQ, itn, itnlim, nMinor, MnrPrt, sclObj,
     &           tolQP, tolx, nInf, sInf, wtInf, piNorm, rgNorm,
     &           ne, nlocJ, locJ, indJ, Jcol,
     &           iw(lhElas), iw(lhEsta), iw(lhfeas), hs, iw(lkBS),
     &           rw(lAscal), bl, bu, rw(lblSav), rw(lbuSav), rw(lblBS),
     &           rw(lbuBS), rw(lgBS), pi, rw(lR), rc, rw(lQPrhs),
     &           rw(lx1), x, rw(lxBS), rw(lxQP),
     &           iw(liy), iw(liy1), rw(ly), rw(ly1), rw(ly2), rw(ly3),
     &           cw, lencw, iw, leniw, rw, lenrw )
         end if
*        ---------------------------------------------------------------
*        Reinstate the scaled bounds on the nonlinear constraints.
*        Restore the constant Jacobian elements in Gcon and Gcon2.
*        ---------------------------------------------------------------
         if ( nlnCon ) then
            call dcopy ( nnCon, rw(lblSav+n), 1, bl(n+1), 1 )
            call dcopy ( nnCon, rw(lbuSav+n), 1, bu(n+1), 1 )
            if (iw(lvlDer) .ge. 2) then
               call dcopy ( neG, rw(lGconu), 1, rw(lGcon ), 1 )
               call dcopy ( neG, rw(lGconu), 1, rw(lGcon2), 1 )
            end if
         end if ! nlnCon

*        ---------------------------------------------------------------
*        Unscale the linear constraints.
*        ---------------------------------------------------------------
         if (iw(lvlScl) .gt. 0) then
            call s2scla( UnScal, m, n, nb, iObj, plInfy, sclObj,
     &           ne, nlocJ, locJ, indJ, Jcol,
     &           rw(lAscal), bl, bu, pi, x )
         end if
      end if ! numLC > 0

      linInf  = iError .ne. 0

*     If there is no feasible point for the linear constraints or
*     there are no nonlinear problem functions, we are done.

      if (linInf                   ) go to 900
      if (FPonly  .and.  nnL .eq. 0) go to 900

      if ( nlnCon ) then
*        ---------------------------------------------------------------
*        Reset hElast so that only nonlinear rows are elastic.
*        Make sure variables are not outside their bounds
*        (in particular, check the nonlinear slacks).
*
*        Restore the constant Jacobian elements in Gcon and Gcon2.
*        ---------------------------------------------------------------
         call iload ( nnCon, 3, iw(lhElas+n), 1 )
         if (iw(lvlDer) .ge. 2) then
            call dcopy ( neG, rw(lGconu), 1, rw(lGcon ), 1 )
            call dcopy ( neG, rw(lGconu), 1, rw(lGcon2), 1 )
         end if
      end if ! nlnCon

      call s5FixX( xBound, 1, nb, tolx, hs, bl, bu, x )

*     ==================================================================
*     ==================================================================
*     The linear constraints have been satisfied!
*     Compute the problem functions at this all-important point.
*     No scaling yet.
*     If a feasible point is needed, SNOPT uses its own objective. 
*     ==================================================================
*     ==================================================================
      if (nnL .gt. 0) then
         lsSave     = iw(lvlScl)
         iw(lvlScl) = 0
      
         minSav     =  iw(minmax) ! Make sure we compute the real obj.
         iw(minmax) =  1

         call s6Init( iError, n, nnL,
     &        nnCon0, nnCon, nnJac, neG, nnObj,
     &        fgwrap, fgcon, fgobj,
     &        ne, nlocJ, locJ, indJ,
     &        rw(lFcon), Fobj, rw(lGcon), rw(lGobj), x,
     &        cu, lencu, iu, leniu, ru, lenru, 
     &        cw, lencw, iw, leniw, rw, lenrw )
         if (iError .ne. 0) go to 900

*        ---------------------------------------------------------------
*        Check derivatives.
*        (One day, we should do this on the SCALED problem.)
*        ---------------------------------------------------------------
         call s7chkg( iError, m, n, nnL,
     &        nnCon0, nnCon, nnJac, nnObj,
     &        fgwrap, fgcon, fgobj,
     &        ne, nlocJ, locJ, indJ, neG, nlocG, iw(llocG),
     &        bl, bu, Fobj, rw(lGobj), rw(lFcon), rw(lGcon), 
     &        rw(lGobj2), rw(lFcon2), rw(lGcon2),
     &        x, rw(ly), rw(ly1), rw(ly2),
     &        cu, lencu, iu, leniu, ru, lenru, 
     &        cw, lencw, iw, leniw, rw, lenrw )
         if (iError .ne. 0) go to 900

*        ---------------------------------------------------------------
*        Compute any missing derivatives.
*        Load the Jacobian Gcon in  J.
*        ---------------------------------------------------------------
         call s6fd  ( iError, n, neG, nnL,
     &        nnCon0, nnCon, nnJac, nnObj,
     &        fgwrap, fgcon, fgobj,
     &        ne, nlocJ, locJ, indJ,
     &        rw(lFcon), Fobj, rw(lGcon), rw(lGobj),
     &        x, rw(ly3),
     &        cu, lencu, iu, leniu, ru, lenru, 
     &        cw, lencw, iw, leniw, rw, lenrw )
         if (iError .ne. 0) go to 900

         if ( nlnCon ) then
            call s8Gcpy( nnCon, nnJac, ne, nlocJ, locJ, indJ, 
     &           neG, nlocG, iw(llocG), rw(lGcon), 
     &           ne, nlocJ, locJ, Jcol )
         end if
 
         iw(minmax) = minSav
         iw(lvlScl) = lsSave
      end if

*     ==================================================================
*     Scale the problem.
*     ==================================================================
      if (iw(lvlScl) .gt. 0) then
*        ---------------------------------------------------------------
*        Reset the vector of row types.
*        ---------------------------------------------------------------
         call s2amat( RowTyp, m, n, nb, nnCon, nnJac, nnObj, iObj,
     &        ne, nlocJ, locJ, indJ, Jcol,
     &        bl, bu, iw(lhfeas),
     &        iw, leniw, rw, lenrw )
         call s2scal( MjrPrt, m, n, nb, nnL, nnCon, nnJac, iw(lhfeas), 
     &        ne, nlocJ, locJ, indJ, Jcol,
     &        rw(lAscal), bl, bu, rw(ly), rw(ly2),
     &        iw, leniw, rw, lenrw )
         call s2scla( Scale, m, n, nb, iObj, plInfy, sclObj,
     &        ne, nlocJ, locJ, indJ, Jcol, 
     &        rw(lAscal), bl, bu, pi, x )

*        ---------------------------------------------------------------
*        The objective and constraint functions haven't been scaled yet.
*        Scale any constant elements in Gcon1 and Gcon2.
*        Don't forget the initial pi.
*        ---------------------------------------------------------------
         if ( nlnCon ) then
            call dddiv ( nnCon, rw(lAscal+n), 1, rw(lFcon), 1 )
            call s8sclJ( nnCon, nnJac, neG, n, rw(lAscal), 
     &           ne, nlocJ, locJ, indJ, rw(lGcon ),
     &           iw, leniw, rw, lenrw )
            call s8sclJ( nnCon, nnJac, neG, n, rw(lAscal), 
     &           ne, nlocJ, locJ, indJ, rw(lGcon1),
     &           iw, leniw, rw, lenrw )
            call s8sclJ( nnCon, nnJac, neG, n, rw(lAscal), 
     &           ne, nlocJ, locJ, indJ, rw(lGcon2),
     &           iw, leniw, rw, lenrw )
            call ddscl ( nnCon, rw(lAscal+n), 1, rw(lLmul), 1 )
         end if

         if (nnObj .gt. 0) then
            call s8sclg( nnObj, rw(lAscal), rw(lGobj), 
     &           iw, leniw, rw, lenrw )
         end if
      end if ! iw(lvlScl) > 0

*     ==================================================================
*     s8Fx computes the nonlinear constraint values Fx.
*     Copy these into the slacks x(n+i) and make sure they are feasible.
*     Crash uses them to decide which slacks to grab for the basis
*     If any nonbasic nonlinear slacks are close to a bound,
*     move them exactly onto the bound to avoid very small steps.
*     ==================================================================
      if ( nlnCon ) then
         call s8Fx  ( n, nnCon, nnJac, eps0,
     &        ne, nlocJ, locJ, indJ, Jcol, rw(lFcon), x, rw(lFx) )
         call s2vmax( n, nnCon, maxvi, vimax, bl, bu, rw(lFx) )
         viSup = max( ten*vimax, vilim )
         call dcopy ( nnCon, rw(lFx), 1, x(n+1), 1 )

         linInf = .false. 

         call s5FixX( xMove, n+1, n+nnCon, tolx, hs, bl, bu, x )

*        ===============================================================
*        Crash on the nonlinear rows.
*        hs(*) already defines a basis for the full problem,  but we
*        want to do better by not including all of the slacks.
*        ===============================================================
         if ( needB ) then

*           Load  hfeas  with the row types.
*           s2crsh uses kBS as workspace.  It may alter x(n+i) for
*           nonlinear slacks.

            call s2amat( RowTyp, m, n, nb,
     &           nnCon, nnJac, nnObj, iObj,
     &           ne, nlocJ, locJ, indJ, Jcol,
     &           bl, bu, iw(lhfeas),
     &           iw, leniw, rw, lenrw )
            lcrash = 5
            call s2crsh( lcrash, MjrPrt, m, n, nb,
     &           iCrash, tCrash,
     &           ne, nlocJ, locJ, indJ, Jcol,
     &           iw(lkBS), hs, iw(lhfeas), bl, bu, x,
     &           iw, leniw, rw, lenrw )
            needB = .false.
         end if ! needB
      end if ! nlnCon

      call s1time( 2, 0, iw, leniw, rw, lenrw )

      iError = 0
      nTry   = 0
      done   = .false.

*     ==================================================================
*+    while (.not. done  .and.  ntry .le. mtry) do                    
  200 if    (.not. done  .and.  ntry .le. mtry) then
         nMajor = 0
         if (ntry .gt. 0) nMinor = 0 

         FPonly = FPonly .or. (iError .gt. 0  .and.  lvlExi .gt. 0)

         if ( FPonly ) then
            call s6FPx0( SetxSQ, iError, itn, n, nnL, 
     &           nnCon0, nnCon, nnJac, neG, nnObj,
     &           fgwrap, fgcon, fgobj,
     &           ne, nlocJ, locJ, indJ,
     &           rw(lFcon), Fobj, rw(lGcon), rw(lGobj),
     &           rw(lGobju), rw(lx0), x,
     &           cu, lencu, iu, leniu, ru, lenru, 
     &           cw, lencw, iw, leniw, rw, lenrw )
         end if

*        ---------------------------------------------------------------
*        Solve the problem.
*        ---------------------------------------------------------------
         call s1page( 1, iw, leniw )
         call s8SQP ( fgwrap, fgcon, fgobj, MjrLog, MnrLog,
     &        iError, itn, lenR, m, maxS, mBS, n, nb, nS, 
     &        nnCon0, nnCon, nnObj, nnL0, nnL,
     &        nMajor, nMinor, nDegen, duInf,
     &        minimz, iObj, sclObj, zero, Fobj, fMrt,
     &        vimax, virel, viSup, nInf, sInf,
     &        wtInf0, wtInf, PenNrm, piNorm, xNorm,
     &        ne, nlocJ, locJ, indJ, Jcol, neG, nlocG, iw(llocG), 
     &        iw(lhElas), iw(lhEsta), iw(lhfeas), hs, iw(lkBS),
     &        rw(lAscal), bl, bu, rw(lblBS), rw(lbuBS), rw(lFv),rw(lFx),
     &        rw(lFcon), rw(lGcon), rw(lGobj),
     &        rw(lFcon1), rw(lGcon1), rw(lGobj1),
     &        rw(lFcon2), rw(lGcon2), rw(lGobj2),
     &        rw(lgBS), rw(lgQP), rw(ldLmul), rw(ldx), rw(ldg),rw(lHdx),
     &        rw(lLmul), rw(lLmul1), rw(lLmul2), pi, rw(lQPrhs),
     &        rw(lR), rc, rw(lrg), x, rw(lx1), rw(lxBS),
     &        rw(lxQP0), rw(lxQP), rw(lxPen),
     &        iw(liy), iw(liy1), rw(ly), rw(ly1), rw(ly2), rw(ly3),
     &        cu, lencu, iu, leniu, ru, lenru, 
     &        cw, lencw, iw, leniw, rw, lenrw )

         if (iError .eq.  9  .and.  sgnObj*Fobj .le. -bigFx) iError = 2
         if (iError .ge. 30                                ) go to 900
         if (iError .ge. 20  .and.  itn         .eq.  0    ) go to 900

         done   =  FPonly                                  ! been there
     &       .or. (lvlExi .eq. 0                         ) ! No repeats
     &       .or. (iError .eq. 0  .and.  nInf .eq. 0     ) ! feasible
     &       .or. (iError .eq. 3  .and.  itn  .ge. itnlim) ! iterations
     &       .or.  iError .eq. 6                           ! User abort

         nTry = nTry + 1
         go to 200
      end if
*+    end while

      if ( FPonly ) then
         call s6FPx0( SetxFG, iError, itn, n, nnL, 
     &        nnCon0, nnCon, nnJac, neG, nnObj,
     &        fgwrap, fgcon, fgobj,
     &        ne, nlocJ, locJ, indJ,
     &        rw(lFcon), Fobj, rw(lGcon), rw(lGobj),
     &        rw(lGobju), rw(lx0), x,
     &        cu, lencu, iu, leniu, ru, lenru, 
     &        cw, lencw, iw, leniw, rw, lenrw )
      end if

      call s1time(-2, 0, iw, leniw, rw, lenrw )
 
*     ==================================================================
*     Exit.
*     Set output variables and print a summary of the final solution.
*     ==================================================================
  900 if (iError .lt. 0) then
         iError = 6
         if (nnCon .lt. m) then
            if (iPrint .gt. 0) write(iPrint, 8060)
            if (iSumm  .gt. 0) write(iSumm , 8060)
         else
            if (iPrint .gt. 0) write(iPrint, 8065)
            if (iSumm  .gt. 0) write(iSumm , 8065)
         end if
      end if
         
      inform  = iError
      degen   = 100.0d+0 * nDegen / max( itn, 1 )

      if (iObj .eq. 0) then
         flin = ObjAdd
      else
         flin = ObjAdd + x(n+iObj)*sclObj
      end if
      ObjTru  = flin + Fobj

      nlnInf  = nInf .gt. 0
      xNorm   = dnrm1s( n , x, 1 )
      
*     Count basic nonlinear variables (used only for printing).

      nnb    = 0
      do j = 1, nnL
         if (hs(j) .eq. 3) nnb = nnb + 1
      end do

      if (inewB .gt. 0  .and.  iError .lt. 20) then
         k      = 1 + iError
         call s4stat( k, istate )
         call s4newB( Wrap, iNewB, minimz, m, n, nb,
     &        nS, mBS, itn, nInf, sInf, FObj, iw(lkBS), hs, 
     &        rw(lAscal), bl, bu, x, rw(lxBS), istate,
     &        cw, lencw, iw, leniw )
      end if

*     Print statistics.

      if (iPrint .gt. 0) then
                     write(iPrint, 1900) cw(mProb), itn, ObjTru
         if ( nlnInf ) then
                     write(iPrint, 1910) nInf, sInf
            if (.not. linInf) 
     &               write(iPrint, 1915) wtInf, fMrt/wtInf
         end if
         if (.not. linInf) then
            if (nonlin) write(iPrint, 1920) nMajor, flin, PenNrm, Fobj
            if (nonlin) write(iPrint, 1950) iw(nFobj1), iw(nFcon1)
            if (iw(lvlDer) .lt. 3  .or.  (nonlin  .and.  lvlSch .eq. 0))
     &                  write(iPrint, 1955) iw(nFobj2), iw(nFcon2)
            if (iw(lvlDer) .lt. 3)
     &                  write(iPrint, 1960) iw(nFobj3), iw(nFcon3),
     &                                      iw(nFobj4), iw(nFcon4)
            if (nS .gt. 0)
     &                  write(iPrint, 1970) nS, nnb
                        write(iPrint, 1975) nDegen, degen
         end if
      end if

      if (iSumm  .gt. 0) then
                     write(iSumm , 1900) cw(mProb), itn, ObjTru
         if ( nlnInf ) then
                     write(iSumm , 1910) nInf, sInf
            if (.not. linInf) 
     &               write(iSumm , 1915) wtInf, fMrt/wtInf
         end if
         if (.not. linInf) then
            if (nonlin) write(iSumm , 1920) nMajor, flin, PenNrm, Fobj
            if (nonlin) write(iSumm , 1950) iw(nFobj1), iw(nFcon1)
            if (iw(lvlDer) .lt. 3  .or.  (nonlin  .and.  lvlSch .eq. 0))
     &                  write(iSumm , 1955) iw(nFobj2), iw(nFcon2)
            if (iw(lvlDer) .lt. 3)
     &                  write(iSumm , 1960) iw(nFobj3), iw(nFcon3),
     &                                      iw(nFobj4), iw(nFcon4)
         end if
         if (nS .gt. 0)
     &               write(iSumm , 1970) nS, nnb
                     write(iSumm , 1975) nDegen, degen
      end if

*     ------------------------------------------------------------------
*     Unscale, compute nonlinear constraint violations,
*     save basis files and prepare to print the solution.
*     Clock 3 is "Output time".
*     ------------------------------------------------------------------
      call s1time( 3, 0, iw, leniw, rw, lenrw )

*     Skip the functions if the linear constraints are infeasible.
*     Skip unscaling everything too, since infeasible linear constraints
*     have already been unscaled.

      lsSave  = iw(lvlScl)

      if (linInf .or. FPonly) then
         nnCon1 = 0
         nnObj1 = 0
         iw(lvlScl) = 0
      else
         nnCon1 = nnCon
         nnObj1 = nnObj
      end if

      call s4savB( SaveB, iError, minimz, m, n, nb,
     &     nnCon0, nnCon1, nnL0, nnObj1, nName, nS,
     &     itn, nInf, sInf, wtInf, vimax, iObj, sclObj, ObjTru,
     &     pNorm1, pNorm2, piNorm, xNorm,
     &     ne, nlocJ, locJ, indJ, Jcol,
     &     iw(lhEsta), hs, rw(lAscal), bl, bu, rw(lFx), rw(lGobj),
     &     Names, pi, rc, x,
     &     cw, lencw, iw, leniw, rw, lenrw )

*     If task = 'Print', s4savB prints the solution under the control
*     of lprSol (set by the  Solution  keyword in the SPECS file).
*     The printed solution may or may not be wanted, as follows:
*     
*     lprSol = 0   means      No
*            = 2   means      Yes

      call s4savB( PrintS, iError, minimz, m, n, nb,
     &     nnCon0, nnCon1, nnL0, nnObj, nName, nS,
     &     itn, nInf, sInf, wtInf, vimax, iObj, sclObj, ObjTru,
     &     pNorm1, pNorm2, piNorm, xNorm,
     &     ne, nlocJ, locJ, indJ, Jcol,
     &     iw(lhEsta), hs, rw(lAscal), bl, bu, rw(lFx), rw(lGobj),
     &     Names, pi, rc, x,
     &     cw, lencw, iw, leniw, rw, lenrw )
      iw(lvlScl) = lsSave
      call s1time(-3, 0, iw, leniw, rw, lenrw )

*     Save some things needed by various interfaces.

      rw(400) = ObjTru          ! AMPL, the true objective
      iw(400) = itn             ! AMPL

      rw(401) = piNorm          ! Gams
      rw(402) = xNorm           ! Gams

*     ------------------------------------------------------------------
*     If the user hasn't already pulled the plug,
*     call the functions one last time with  Status .ge. 2.
*     Everything has been  unscaled, so we have to disable scaling.
*     modefg = 0  tells the functions that gradients are not required.
*     ------------------------------------------------------------------
      if (.not. linInf  .and.  inform .ne. 6) then
         lsSave = iw(lvlScl)
         iw(lvlScl) = 0
         Status = 2 + iError
         modefg = 0
         call fgwrap( modefg, iError, Status, nlnCon, nlnObj,
     &        n, neG, nnL, nnCon0, nnCon, nnJac, nnObj, 
     &        fgcon, fgobj,
     &        ne, nlocJ, locJ, indJ, 
     &        rw(lFcon), Fobj, rw(lGcon2), rw(lGobj2), x, 
     &        cu, lencu, iu, leniu, ru, lenru, 
     &        cw, lencw, iw, leniw, rw, lenrw )
         iw(lvlScl) = lsSave
         if (modefg .ge. 0) then
            Status = 0
         end if
      end if

      return

 1100 format(/   ' Scale option', i3, ',      Partial price', i8
     &       /   ' Partial price section size ( A)', i12
     &       /   ' Partial price section size (-I)', i12)
 1110 format(/   ' Scale option', i3, ',    Partial price', i4)
 1200 format(    ' Initial basis' / ' -------------')
 1205 format(/   ' No basis file supplied')
 1210 format(    ' Warm Start' / ' ----------')
 1900 format(/   ' Problem name', 17x, a8
     &       /   ' No. of iterations', i20,
     &        2x,' Objective value', 1p, e22.10)
 1910 format(    ' No. of infeasibilities', i15,
     &        2x,' Sum of infeas', 1p, e24.10)
 1915 format(    ' Elastic weight            ', 1p, e11.1,
     &        2x,' Scaled Merit ', 1p, e24.10)
 1920 format(    ' No. of major iterations', i14,
     &        2x,' Linear objective', 1p, e21.10
     &       /   ' Penalty parameter', 1p, e20.3,
     &        2x,' Nonlinear objective', 1p, e18.10)
 1950 format(    ' No. of calls to funobj', i15,
     &        2x,' No. of calls to funcon', i15)
 1955 format(    ' Calls with modes 1,2 (known g)', i7,
     &        2x,' Calls with modes 1,2 (known g)', i7)
 1960 format(    ' Calls for forward differencing', i7,
     &        2x,' Calls for forward differencing', i7
     &       /   ' Calls for central differencing', i7,
     &        2x,' Calls for central differencing', i7)
 1970 format(    ' No. of superbasics', i19,
     &        2x,' No. of basic nonlinears', i14)
 1975 format(    ' No. of degenerate steps', i14,
     &        2x,' Percentage', f27.2)
 8060 format(  ' EXIT -- undefined functions in funcon and funobj',
     &         ' at the first LC feasible point.')
 8065 format(  ' EXIT -- undefined functions in funcon and funobj',
     &         ' at the initial point.')

      end ! of s8solv

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8SQP ( fgwrap, fgcon, fgobj, MjrLog, MnrLog,
     &     iError, itn, lenR, m, maxS, mBS, n, nb, nS, 
     &     nnCon0, nnCon, nnObj, nnL0, nnL,
     &     nMajor, nMinor, nDegen, duInf, 
     &     minimz, iObj, sclObj, ObjAdd, Fobj, fMrt,
     &     vimax, virel, viSup, nInf, sInf,
     &     wtInf0, wtInf, PenNrm, piNorm, xNorm,
     &     ne, nlocJ, locJ, indJ, Jcol, neG, nlocG, locG, 
     &     hElast, hEstat, hfeas, hs, kBS,
     &     Ascale, bl, bu, blBS, buBS, Fv, Fx,
     &     Fcon, Gcon, Gobj,
     &     Fcon1, Gcon1, Gobj1, Fcon2, Gcon2, Gobj2,
     &     gBS, gQP, dLmul, dx, dg, Hdx, 
     &     Lmul, Lmul1, Lmul2, pi, QPrhs,
     &     R, rc, rg, x, x1, xBS,
     &     xQP0, xQP, xPen,
     &     iy, iy1, y, y1, y2, y3,
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      external
     &     fgwrap, fgcon, fgobj, MjrLog, MnrLog
      integer
     &     iError, iObj, itn, minimz, lenR, maxS, mBS, m, n, nb, ne,
     &     neG, nlocG, nS, nlocJ, nnCon0, nnCon, nnL0, nnL,
     &     nnObj, nMajor, nMinor, nDegen, nInf, lencu, lencw, leniu,
     &     leniw, lenru, lenrw,locJ(nlocJ), indJ(ne), hElast(nb),
     &     hs(nb), hEstat(nb),hfeas(mBS), locG(nlocG), kBS(mBS),
     &     iy(nb), iy1(nb),iu(leniu), iw(leniw)
      double precision
     &     duInf, ObjAdd, fMrt, Fobj, vimax, virel, viSup, sclObj, sInf,
     &     wtInf0, wtInf, PenNrm, piNorm, Ascale(nb), bl(nb), bu(nb),
     &     blBS(mBS), buBS(mBS), dg(nnL0), dx(nb), dLmul(nnCon0),
     &     Hdx(nnL0), Jcol(ne), Fv(nnCon0), Fx(nnCon0), gBS(mBS),
     &     gQP(nnL0), Fcon(nnCon0) , Gcon(neG) , Gobj(nnL0),
     &     Fcon1(nnCon0), Gcon1(neG), Gobj1(nnL0),
     &     Fcon2(nnCon0), Gcon2(neG), Gobj2(nnL0),
     &     Lmul(nnCon0), Lmul1(nnCon0), Lmul2(nnCon0),
     &     rc(nb), rg(maxS), x(nb), x1(nb), xBS(mBS), xQP(nb), xQP0(nb),
     &     xPen(nnCon0), pi(m), QPrhs(m), R(lenR), 
     &     y(nb), y1(nb), y2(nb), y3(nb), ru(lenru), rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     s8SQP  solves a nonlinear programming problem.
*     A basis is assumed to be specified by nS, hs, x and the
*     superbasic parts of kBS.
*     In particular, there must be nS values hs(j) = 2, and the
*     corresponding j's must be listed in kBS(m+1) thru kBS(m+ns).
*     The ordering in kBS(m+1:m+nS) matches the reduced Hessian R.
*
*     On entry, if there are nonlinear constraints, Fx contains
*     the true nonlinear slacks (i.e., constraint values)
*     Fx  =  Fcon + (linear A)*x,   excluding slacks.
*
*     On exit, if  iError .lt. 30  it is safe to save the final
*     basis files and print the solution.  Otherwise, a fatal error
*     condition exists and numerous items will be undefined.
*     The last basis map saved (if any) retains the only useful
*     information.
*
*     30 Dec 1991: First version based on npsol routine npcore.
*     23 Oct 1993: Proximal point FP added.
*     29 Oct 1993: Crash on LG rows moved outside s5QP.
*     24 Apr 1994: Nx columns no longer in Q.
*     26 May 1995: Column order of R defined by kBS.
*     04 Aug 1995: Limited memory update
*     11 Aug 1995: tolg changed from 0.1 to 1.0d-4.
*     09 Nov 1995: Updated multipliers used to define Lagrangian.
*     19 Dec 1995: Finite-differences added.
*     09 Oct 1996: First Min Sum version.
*     16 Jul 1997: First thread-safe version.
*     09 Jul 1998: Quasi-Newton updates implemented correctly.
*     24 Aug 1998: Fixed bug in s8x1 found by Alan Brown at Nag.
*     06 Sep 1998: Pre- and post-QP diagonal Hessian scaling added.
*     16 Jan 1999: Name changed from s8core.
*     11 Nov 2000: Current version of s8SQP.
*     ==================================================================
      logical
     &     KTcond(2), backtr, boostd, centrl, debug, done, duFeas,
     &     Elastc, FDObj , FDCon, feaSlk, FPonly, frstQP, goodG, gotR,
     &     incRun, maxItn, maxMjr, maxnS, needLU, newB, newG, newLU,
     &     nlnCon, nlnObj, optiml, prFeas, QPpi0, rowFea, restrt,
     &     useFD, usefLS
      integer
     &     cdItns, Hcalls, Htype, iAbort, info(6), idamax, inform,
     &     itnlim, itQP, iPrint, iSumm, j, jObj, jprInf, jduInf, jrviol,
     &     lvlDif, LUreq, lprSch, lvlDer, lvlHes, lvlSch, maxvi, minmax, 
     &     mMajor, modefg, mStart, MjrPrt, MnrPrt, MjrHdg, MnrHdg,
     &     MjrSum, mMinor, nInfQP, nnJac, nSwap, nSkip, nStart, RtRmod,
     &     Status, typeLU, Utol1, Utol2
      double precision
     &     back, bigFx, condHz, dxHdx, Emax, eps, eps0, eps1, eps5,
     &     eta, Fobj1, Fobj2, FobjQP, fMrt1, gMrt, gMrt1, gNorm0,
     &     gNorm, H0ii, tolFP, tolQP, tolNLP, tolCon, tolx, dRzmax,
     &     dRzmin, Rzmax, rviol, weight, wtFac, wtScal, PenDmp, PenMax,
     &     prInf, pHpMrt, sInfQP, sInf1, sInf2, sgnObj, step, steplm,
     &     stepmn, stepmx, Utol1s, Utol2s, xdNorm, xNorm, xPen0,
     &     ddot, dnrm1s
      character*4
     &     line
      data
     &     line /'----'/
      character*19
     &     msg(4:8)
      data 
     &     msg/'max step too small.',
     &         'step too small.    ',
     &         'no minimizer.      ',
     &         'too many functions.',
     &         'uphill direction.  '/
*     ------------------------------------------------------------------
      integer            HUnset,     HNorml,     HUnit 
      parameter         (HUnset =-1, HNorml = 0, HUnit  = 2)
      integer            iQNtyp,     iModfy,     iStep
      parameter         (iQNtyp = 1, iModfy = 2, iStep  = 3)
      integer            iQPfea,     iQPerr,     iFDiff
      parameter         (iQPfea = 4, iQPerr = 5, iFDiff = 6)
      integer            Normal
      parameter         (Normal = 0)
      integer            SetWt,      IncWt
      parameter         (SetWt  = 0, IncWt  = 1)
      integer            LM   ,      FM
      parameter         (LM     = 0, FM     = 1) 
      integer            BS,         BT   
      parameter         (BS     = 1, BT     = 2)

      double precision   zero,         half,          one
      parameter         (zero =0.0d+0, half =0.5d+0,  one    =  1.0d+0)
      double precision   ten,           hundrd
      parameter         (ten  =10.0d+0, hundrd =100.0d+0)

      parameter         (Utol1     = 154) ! abs tol for small diag of U.
      parameter         (Utol2     = 155) ! rel tol for small diag of U.

      parameter         (lvlDif    = 182) ! =1(2) forwd (cntrl) diffs
      parameter         (Htype     = 202) ! Approximate Hessian type
      parameter         (MnrHdg    = 223) ! >0 => Mnr heading for iPrint
      parameter         (MjrHdg    = 224) ! >0 => Mjr heading for iPrint
      parameter         (MjrSum    = 225) ! >0 => Mjr heading for iSumm
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file

      nnJac     = iw( 21) ! # nonlinear Jacobian variables
      lvlHes    = iw( 72) ! 0,1,2  => LM, FM, Exact Hessian
      lvlSch    = iw( 76) ! >0     => use derivatives in the line search
      lprSch    = iw( 82) ! line search debug starting itn

      minmax    = iw( 87) ! 1, 0, -1  => MIN, FP, MAX
      itnlim    = iw( 89) ! limit on total iterations
      mMajor    = iw( 90) ! limit on major iterations
      mMinor    = iw( 91) ! limit on minor iterations
      MjrPrt    = iw( 92) ! Major print level
      MnrPrt    = iw( 93) ! Minor print level
      lvlDer    = iw( 70) ! = 0, 1, 2 or 3, the derivative level

*     Constants

      eps       = rw(  1) ! unit round-off.
      eps0      = rw(  2) ! eps**(4/5)
      eps1      = rw(  3) ! eps**(2/3)
      eps5      = rw(  7) ! eps**(1/5)

      tolFP     = rw( 51) ! Minor Phase 1 Opt tol
      tolQP     = rw( 52) ! Minor Phase 2 Opt tol
      tolNLP    = rw( 53) ! Major Optimality tolerance
      tolx      = rw( 56) ! Minor feasibility tolerance.
      tolCon    = rw( 57) ! Major feasibility tolerance.
      bigFx     = rw( 71) ! unbounded objective.
      eta       = rw( 84) ! line search tolerance.
      xPen0     = rw( 89) ! initial penalty parameter.

      nlnCon    = nnCon  .gt. 0
      nlnObj    = nnObj  .gt. 0
      FPonly    = minmax .eq. 0

      iw(MnrHdg) = 0
      iw(MjrHdg) = 0
      iw(MjrSum) = 0

*     ------------------------------------------------------------------
*     s8SQP  operates in either ``Normal'' or ``Elastic'' mode.
*     In elastic mode, the nonlinear slacks are allowed to be infeasible
*     while a weighted sum of the slack infeasibilities is minimized.
*     ------------------------------------------------------------------
      feaSlk = .true.
*     Elastc =       FP  .and.  nlnCon
      Elastc = .false.
      call iload ( nb, 0, hEstat, 1 )

      nInf   = 0
      sInf   = zero
      sInf1  = zero
      sInf2  = zero

      iError = 0
      LUreq  = 0
      Status = 0
      nSkip  = 0
      Hcalls = 0
      nStart = 0
      if (nnL .gt. 0) then
         mStart = 2
      else
         mStart = 0
      end if
      RtRmod = 0

      call iload ( 6, 0, info, 1 )
      info(iQNtyp) = 1          ! Suppresses first printing of 'n'

      sgnObj = minimz
      H0ii   = sgnObj
      Emax   = zero             ! Not used in this version
      rviol  = zero
      prInf  = zero
      duInf  = zero
      wtInf  = wtInf0
 
      gMrt   = zero
      step   = zero

      KTcond(1) =  .false.
      KTcond(2) =  .false.

      done   = .false.
      frstQP = .true.
      QPpi0  = .false.      ! Use zero initial multipliers
*     QPpi0  = .true.       ! Use QP initial multipliers

      condHz = one

      FDObj  = (lvlDer .eq. 0  .or.  lvlDer .eq. 2) .and. (nnObj .gt. 0)
      FDCon  = (lvlDer .eq. 0  .or.  lvlDer .eq. 1) .and. (nnJac .gt. 0)
      useFD  =  FDObj  .or.  FDCon
      usefLS =  useFD          .or.  lvlSch .eq. 0

      if (MjrPrt .ge. 10  .or.  MnrPrt .ge. 1) then
         if (iPrint .gt. 0) then
            write(iPrint, 1010) (line, j=1,29), nMajor
         end if
         if (iSumm  .gt. 0  .and.  MnrPrt .ge. 1) then
            write(iSumm , 1020) (line, j=1,19), nMajor
         end if
      end if

      jObj   = n + iObj

      if ( nlnCon ) then
*        ---------------------------------------------
*        Initialize the penalty parameters.
*        Set an initial elastic weight.
*        ---------------------------------------------
         incRun = .true.
         PenDmp = one
         PenMax = one / eps
         PenNrm = xPen0
         call dload ( nnCon, xPen0, xPen, 1 )
      end if

      if (nnL .gt. 0  .and.  iw(Htype) .eq. HUnset) then
*        ---------------------------------------------------------------
*        The approximate Hessian needs to be initialized.
*        Use the identity matrix until something better comes along.
*        ---------------------------------------------------------------
         call s8H0  ( iw(Htype), nnL, H0ii, iw, leniw, rw, lenrw )
      else
         iw(Htype) = HNorml
      end if

      call dcopy ( nb, x, 1, xQP, 1 )
      cdItns = -1
      newG   = .false.

**    ======================Start of main loop==========================
*     Start of a Major Iteration.
*     ==================================================================
*+    do while (.not. done  .and.  iError .eq. 0)
  100 if       (.not. done  .and.  iError .eq. 0) then

         nMinor = 0

*        ===============================================================
*        Repeat                    (until an accurate gradient is found)

  110       centrl = iw(lvlDif) .eq. 2

            if ( newG ) then 
               if ( useFD ) then
*                 ------------------------------------------------------
*                 Compute any missing derivatives.
*                 ------------------------------------------------------
                  call s6fd  ( iError, n, neG, nnL,
     &                 nnCon0, nnCon, nnJac, nnObj,
     &                 fgwrap, fgcon, fgobj,
     &                 ne, nlocJ, locJ, indJ,
     &                 Fcon, Fobj, Gcon, Gobj, x, y,
     &                 cu, lencu, iu, leniu, ru, lenru, 
     &                 cw, lencw, iw, leniw, rw, lenrw )
                  if (iError  .ne. 0) go to 100 ! Break
               end if ! useFD
               newG = .false.
            end if

            if ( nlnCon ) then
*              ---------------------------------------------------------
*              Load the scaled Jacobian in J.
*              Compute the QP right-hand side   QPrhs  =  Jx - Fcon.
*              Find Fx the nonlinear constraint values.
*              ---------------------------------------------------------
               call s8Gcpy( nnCon, nnJac, ne, nlocJ, locJ, indJ, 
     &              neG, nlocG, locG, Gcon, 
     &              ne, nlocJ, locJ, Jcol )
               call dcopy ( nnCon, Fcon, 1, QPrhs, 1 )
               call s2Aprd( Normal, eps0,
     &              ne, nlocJ, locJ, indJ, Jcol, 
     &              one, x, nnJac, (-one), QPrhs, nnCon )
*              ---------------------------------------------------------
*              s8sOpt  finds the nonlinear slacks  sN  that minimize the
*              merit function with  x(1:n)  and  Lmul  held fixed.
*              The optimal slacks are loaded into  x(n+1:nb)  and the
*              violations are calculated: 
*                    Fv = Fcon  + A(linear)x - nonlinear slacks
*                       = Fx                 - sN
*              ---------------------------------------------------------
               gNorm  = one
               if (iObj   .gt. 0) gNorm  = gNorm + sclObj
               gNorm0 = zero
               if (nlnObj       ) gNorm0 = dnrm1s( nnObj, Gobj, 1 )

               if (.not. Elastc) then
                  call s8wInf( SetWt,
     &                 boostd, itn, (gNorm+gNorm0), wtInf, wtInf0,
     &                 weight, wtFac, wtScal, iw, leniw )
               end if

               call s8sOpt( Elastc, n, nnCon, eps0, wtInf,
     &              bl, bu, Fv, x, Lmul, xPen, Fx )
            end if

*           ------------------------------------------------------------
*           Prepare to (re-)solve the QP subproblem (possibly after the
*           elastic weight has been increased).
*           ------------------------------------------------------------
*           Factorize the basis at x.
*           Compute xQP such that (J -I)*xQP = rhs.

  300       if ( frstQP ) then
*              ---------------------------------------------------------
*              First QP subproblem.
*              ---------------------------------------------------------
*              To avoid an unnecessarily ill-conditioned starting basis
*              for the first QP, use the BS factorization with big
*              singularity tols.

               needLU  = .true.
               gotR    = .false.
               nSwap   = 0

               Utol1s     = rw(Utol1)
               Utol2s     = rw(Utol2)
               rw(Utol1)  = max( Utol1s, eps5 )
               rw(Utol2)  = max( Utol2s, eps5 )
               typeLU     = BS 
            else
*              ---------------------------------------------------------
*              Subsequent factorizations.
*              ---------------------------------------------------------
*              For linearly constrained problems, the factors L, U and R
*              can be saved as long as a poor x does not force a
*              new factorization. (Even in this case, R can be saved if
*              there are no swaps.)

               needLU = nlnCon      
               typeLU = BT
            end if

            call s2Bfac( typeLU, needLU, newLU, newB,
     &           iError, iObj, itn, MjrPrt, LUreq,
     &           m, mBS, n, nb, nnL, nS, nSwap,
     &           ne, nlocJ, locJ, indJ, Jcol,
     &           kBS, hs, bl, bu, blBS, buBS,
     &           nnCon0, nnCon, QPrhs, xQP, xBS,
     &           iy, iy1, y, y2, iw, leniw, rw, lenrw )
            if (iError .ne. 0) go to 100 ! Break

            gotR    = gotR  .and.  .not. newB
            needLU  = .false.
            if (MjrPrt .ge. 10) iw(MjrHdg) = 1

            if ( frstQP ) then
               rw(Utol1) = Utol1s 
               rw(Utol2) = Utol2s
            end if

*           ------------------------------------------------------------
*           Solve the QP subproblem to obtain kBS, xQP and pi.
*           The search direction will be dx = xQP - x.
*           Use x1 to store the first feasible point.
*           ------------------------------------------------------------
            call s8iqp ( info, iw(Htype), Mnrlog, Hcalls, Elastc,
     &           gotR, iError, itn, itQP, lenR, m, maxS, mBS, n, nb,
     &           nnCon0, nnCon, nnObj, nnL0, nnL, nS, nDegen,
     &           MjrPrt, MnrPrt, minimz, iObj, sclObj, (ObjAdd+Fobj),
     &           FobjQP, tolFP, tolQP, tolx, nInfQP, sInfQP, wtInf,
     &           H0ii, piNorm,
     &           ne, nlocJ, locJ, indJ, Jcol,
     &           hElast, hEstat, hfeas, hs, kBS, 
     &           Ascale, bl, bu, blBS, buBS, gBS, gQP, Gobj, Hdx,
     &           y3, pi, R, rc, rg, QPrhs, x,
     &           xQP, xBS, x1, xQP0, iy, iy1, y, y1, y2,
     &           cu, lencu, iu, leniu, ru, lenru, 
     &           cw, lencw, iw, leniw, rw, lenrw )

            nMinor = nMinor + itQP
            if (iError .ge. 10) go to 100

            if ( frstQP ) then
               frstQP = .false.
            end if

            if ( nlnCon ) then
               if ( QPpi0 ) then
                  call dcopy ( nnCon,            pi, 1,  Lmul, 1 )
                  call dload ( nnCon, (zero), dLmul, 1 )
               else
                  call dcopy ( nnCon,            pi, 1, dLmul, 1 )
                  call daxpy ( nnCon, (-one),  Lmul, 1, dLmul, 1 )
               end if

               if (Elastc  .and.  feaSlk) then
                  call dcopy ( nnCon, Fx, 1, x(n+1), 1 )
               end if

*              If Lmul or x  changed, recompute Fv.

               if (QPpi0  .or.  (Elastc  .and.  feaSlk)) then
                  call s8sOpt( Elastc, n, nnCon, eps0, wtInf,
     &                 bl, bu, Fv, x, Lmul, xPen, Fx )

                  if (Elastc  .and.  feaSlk) feaSlk = .false.
                  if (QPpi0                ) QPpi0  = .false.
              end if

*              Find the sum of infeasibilities of the nonlinear slacks.

               call s8sInf( n, nb, nnCon, tolx, nInf, sInf, bl, bu, x )
            end if

            maxItn = iError .eq. 3  .and.  itn .ge. itnlim
            maxMjr = nMajor .ge. mMajor
            maxnS  = iError .eq. 5

            if ( maxnS  ) iError = 0
            if ( maxMjr ) iError = 3

*           Compute the search direction dx. 

            call dcopy ( nb,         xQP, 1, dx, 1 )
            call daxpy ( nb, (-one), x  , 1, dx, 1 )

            xNorm  = dnrm1s( n, x  , 1 )
            xdNorm = dnrm1s( n, dx, 1 )

*           Compute all the QP reduced costs.
*           (We could use Lmul for the nonlinear pi's).
*           Compute the maximum dual infeasibility.

            call s8rc  ( sclObj, minimz, iObj, m, n, nb, 
     &           nnL0, nnObj, nnCon, nnJac, neG,
     &           ne, nlocJ, locJ, indJ, Jcol,
     &           Gobj, Gcon, pi, rc )
            call s8Infs( Elastc, n, nb, nnCon0, nnCon, wtInf,
     &           prInf, duInf, jprInf, jduInf, bl, bu, Fx, rc, x )

*           Compute the largest nonlinear row violation.

            if ( nlnCon ) then
               jrviol = idamax( nnCon, Fv, 1 ) 
               rviol  = abs( Fv(jrviol) )
            end if

*           ------------------------------------------------------------
*           Test for convergence.
*           ------------------------------------------------------------
            if ( gotR ) then
               call s6Rcnd( nS, lenR, R, dRzmax, dRzmin, Rzmax, condHz )
            end if
            rviol     = rviol /(one + xNorm )
            prInf     = prInf /(one + xNorm )
            duInf     = duInf /(one + piNorm)

            rowFea    = rviol  .lt. tolCon  .and.  nInf .gt. 0
            prFeas    = prInf  .le. tolCon
            duFeas    = duInf  .le. tolNLP
            KTcond(1) = prFeas
            KTcond(2) = duFeas

            optiml    = duFeas  .and.  (prFeas  .or.  rowFea)

            if (nlnCon  .and.  optiml  .and.  nInf .gt. 0) then
               call s8wInf( IncWt,
     &              boostd, itn, (gNorm+gNorm0), wtInf, wtInf0,
     &              weight, wtFac, wtScal, iw, leniw )

               if ( boostd ) then
                  Elastc = .true.
                  go to 300
               end if
            end if

*           ------------------------------------------------------------
*           Test for unbounded problem.
*           ------------------------------------------------------------
            if (prFeas  .and.  info(iQPerr) .eq. 3) then
               iError = 2
            end if

*           ------------------------------------------------------------
*           Compute the current augmented Lagrangian merit function.
*           ------------------------------------------------------------
            if (iObj .eq. 0) then
               fMrt = zero
            else
               fMrt = sgnObj*x(jObj)*sclObj
            end if

            if ( nlnObj ) then
               fMrt =  fMrt + sgnObj*Fobj
            end if

            if ( nlnCon ) then 
               call dcopy ( nnCon, Fv  , 1, y, 1 )
               call ddscl ( nnCon, xPen, 1, y, 1 )
               fMrt = fMrt -      ddot  ( nnCon, Lmul, 1, Fv, 1 )
     &                     + half*ddot  ( nnCon,    y, 1, Fv, 1 )

               if ( Elastc ) then
                  fMrt = fMrt + wtInf*sInf
               end if
            end if

*           ------------------------------------------------------------
*           If the forward-difference estimate of the reduced gradient
*           of the Lagrangian is small,  prepare to: (i) switch to
*           central differences; (ii)  recompute the derivatives,  and
*           (iii) solve the QP again. 
*           
*           On the other hand, if central differences give a large
*           reduced-gradient norm, switch back to forward differences.
*           ------------------------------------------------------------
            call s8FD  ( nnCon0, nnCon, nnObj, itn, cdItns,
     &           centrl, goodG, newG, useFD, info, duInf,
     &           Fcon, Fobj, iw, leniw, rw, lenrw )

*           ------------------------------------------------------------
*           Print the details of this iteration.
*           Call user-supplied monitor s8User.
*           ------------------------------------------------------------
            call MjrLog( iAbort, info, iw(Htype), KTcond, MjrPrt,
     &           minimz, n, nb, nnCon0, nS, nMajor, nMinor, nSwap,
     &           condHz, iObj, sclObj, ObjAdd, fMrt, PenNrm, step,
     &           prInf, duInf, vimax, virel, hs,
     &           ne, nlocJ, locJ, indJ, Jcol,
     &           Ascale, bl, bu, Fcon, Lmul, x,
     &           cu, lencu, iu, leniu, ru, lenru, 
     &           cw, lencw, iw, leniw, rw, lenrw )
            call s1User( iAbort, info(iQNtyp), info(iModfy),
     &           info(iStep), info(iFDiff), info(iQPerr), info(iQPfea),
     &           iw(Htype), KTcond, 
     &           m, n, nb, nS, nS, nMajor, nMinor, nSwap,
     &           condHz, duInf, Emax, Fobj, 
     &           fMrt, gMrt, PenNrm, prInf, step, vimax, 
     &           ne, nlocJ, Jcol, indJ, locJ,
     &           hs, bl, bu, pi, rc, x, 
     &           cu, lencu, iu, leniu, ru, lenru, 
     &           cw, lencw, iw, leniw, rw, lenrw )

            if (iAbort .ne. 0) then
               iError = 12
               go to 100 
            end if

            info(iStep ) = 0

*+       until (.not. (useFD  .and.  .not.goodg))
         if (          useFD  .and.  .not.goodg ) go to 110
*        ===============================================================
         done = optiml  .or.  maxItn  .or.  maxMjr 
         if (done  .or.  iError .ne. 0) go to 100

         iError = 0
         step   = zero
         nSwap  = 0

*        ===============================================================
*        Take a step in the right direction.
*        ===============================================================
*        Compute  dxHdx = s'Hs  and other directional derivatives.
*        Be prepared to fix up pHpMrt if there are linear variables.
*        ---------------------------------------------------------------
         dxHdx = zero
         if (nnL .gt. 0) then
            call s8Hx( Hcalls, nnL, dx, Hdx, 
     &           cw, lencw, iw, leniw, rw, lenrw )
            dxHdx = sgnObj*ddot ( nnL, dx, 1, Hdx, 1 )
         end if

         if (nnL .eq. n) then
            dxHdx   = max( zero, dxHdx )

            if (dxHdx .le. zero  .and.  iw(Htype) .ne. HUnit) then
               call s8H0  ( iw(Htype), nnL, H0ii, iw, leniw, rw, lenrw )
               go to 100
            end if
            pHpMrt = dxHdx
         else
            pHpMrt = max( eps1*xdNorm*xdNorm, abs(dxHdx) )
         end if

*        ---------------------------------------------------------------
*        Compute the contributions to the merit function and its
*        directional derivative from the nonlinear constraints.
*        The penalty parameters  xPen(j)  are increased if the
*        directional derivative is not sufficiently negative.
*        ---------------------------------------------------------------
*        First, compute the value and directional derivative of the
*        Lagrangian with respect to x and the multipliers.

         if (iObj .eq. 0) then
            fMrt = zero
            gMrt = zero
         else
            fMrt = sgnObj*x (jObj)*sclObj
            gMrt = sgnObj*dx(jObj)*sclObj
         end if
            
         if ( nlnObj ) then
            fMrt = fMrt + sgnObj*Fobj
            gMrt = gMrt + sgnObj*ddot  ( nnObj, Gobj, 1, dx, 1 )
         end if

         if ( Elastc ) then
            fMrt = fMrt +           sInf *wtInf
            gMrt = gMrt + (sInfQP - sInf)*wtInf
         end if

*        ---------------------------------------------------------------
*        Compute the search direction for the multipliers and nonlinear
*        slacks, and the contributions to the merit function and its
*        directional derivative from the nonlinear constraints.
*        The penalty parameters  xPen(j)  are increased if the
*        directional derivative is not sufficiently negative.
*        ---------------------------------------------------------------
         if ( nlnCon ) then
            fMrt = fMrt  - ddot  ( nnCon,  Lmul, 1, Fv, 1 )
            gMrt = gMrt  + ddot  ( nnCon,  Lmul, 1, Fv, 1 )
            gMrt = gMrt  - ddot  ( nnCon, dLmul, 1, Fv, 1 )

            call s8mrt ( nnCon, fMrt, gMrt, pHpMrt, incRun,
     &           penDmp, penMax, PenNrm, Fv, xPen, y, rw, lenrw )
         end if

*        ===============================================================
*        Find  stepmn,  stepmx  and  step,  the maximum, minimum and
*        initial values for the linesearch step.
*        ===============================================================
         call s8step( centrl, usefLS, nb, neG, nnCon, nnObj, nSkip,
     &        step, stepmn, steplm, stepmx, eps0, xdNorm, xNorm, 
     &        bl, bu, x, dx, iw, leniw, rw, lenrw )

         debug  = nMajor .ge. lprSch
         back   = 0.1d+0        ! Backtracking factor

*        ===============================================================
*        Prepare for the linesearch to find a better point
*           x1 = x + step*dx  and  Lmul1 = Lmul + step*dLmul.
*        where, on entry,  x1 = xQP and  Lmul1 = pi.
*
*        Fcon , Gcon , Gobj  and Lmul  are defined at the current    x.
*        Fcon1, Gcon1, Gobj1 and Lmul1 are defined at the new point x1.
*        Fcon2, Gcon2, Gobj2 and Lmul2 are temporary work arrays.  
*
*        s6srch returns the following values:
*
*        inform =-1 (and iError = 6) if the user wants to stop.
*        inform = 0 if the search needs to be redone.
*        inform = 1 if the search is successful and  step < stepmx.
*               = 2 if the search is successful and  step = stepmx.
*               = 3 if a better point was found but the strong Wolfe 
*                   conditions were not satisfied (i.e., no sufficient
*                   decrease).  The merit function is either decreasing
*                   at  stpmax  or the maximum number of function
*                   evaluations has been exceeded.
*               = 4 if stepmx < tolabs (too small to do a search).
*               = 5 if step   < alfsml (srchq only -- maybe switch
*                   to central differences to get a better direction).
*               = 6 if the search found that there is no useful step.
*                   The interval of uncertainty is less than 2*tolabs.
*                   The minimizer is very close to step = zero
*                   or the gradients are not sufficiently accurate.
*               = 7 if there were too many function calls.
*               = 8 if the input parameters were bad
*                   (stepmx le toltny  or  uphill).
*               = 9 if the objective is unbounded below.
*               =10 if the user wants to stop.
*        ===============================================================
*        x and sInf are saved in case we have to restart the search.
*        y  is used as x2 in s6srch.

  500    call dcopy ( nb   , xQP, 1,     y, 1 )
         if ( nlnCon )
     &   call dcopy ( nnCon,  pi, 1, Lmul2, 1 )
         if ( Elastc ) sInf2 = sInfQP 

         call s6srch( fgwrap, fgcon, fgobj,
     &        inform, debug, Elastc, usefLS, prFeas, iObj, sclObj, 
     &        n, nb, nnCon0, nnCon, nnJac, nnObj, nnL0,
     &        itn, eta, sgnObj, step, stepmn, stepmx, xdNorm, xNorm,
     &        fMrt, fMrt1, gMrt, gMrt1, sInf, sInf1, sInf2, wtInf, 
     &        ne, nlocJ, locJ, indJ, Jcol, neG, nlocG, locG, 
     &        Fobj1, Fcon1, Gcon1, Gobj1, Fobj2, Fcon2, Gcon2, Gobj2,
     &        dx, dLmul, x, x1, y, Lmul, Lmul1, Lmul2, xPen,
     &        y1, y2, y3, cu, lencu, iu, leniu, ru, lenru, 
     &        cw, lencw, iw, leniw, rw, lenrw )

         restrt = nStart .lt. mStart

         if (inform .le. 3) then
*           ------------------------------------------------------------
*           See if the search needs to be redone with a smaller stepmx.
*           ------------------------------------------------------------
            backtr = .false.

            if (inform .eq. 0) then

*              The problem functions were undefined during the search.

               backtr = .true.

            else if ( nlnCon ) then

*              See if the max violation is bigger than viSup.

               call s8Fx  ( n, nnCon, nnJac, eps0,
     &              ne, nlocJ, locJ, indJ, Jcol, Fcon1, x1, Fx )
               call s2vmax( n, nnCon, maxvi, vimax, bl, bu, Fx )
               virel  = vimax / (one + xNorm)
               backtr = vimax .gt. viSup
            end if

            if ( backtr ) then
               info(iStep) = 1
               stepmx      = back * step
               step        = stepmx
               go to 500
            end if

         else if (useFD  .and.  .not. centrl  .and.  inform .le. 6) then
*           ------------------------------------------------------------
*           The line search failed.  Switch to central differences and
*           resolve the QP subproblem.
*           ------------------------------------------------------------
            cdItns       = 0
            info(iFDiff) = 1
            if (iPrint .gt. 0) write(iPrint, 3020) itn
            if (iSumm  .gt. 0) write(iSumm , 3020) itn
            iw(lvlDif)  = 2
            newG        = .true.
            go to 110
         end if

         if (inform .ge. 4) then
*           ============================================================
*           The line search failed to find a sufficiently better point.
*           What happens next is determined by the value of inform. 
*           ============================================================
            if (maxnS) then
*              ---------------------------------------------------------
*              Superbasic limit exceeded.
*              ---------------------------------------------------------
               iError = 5

            else if (inform .eq. 9) then
*              ---------------------------------------------------------
*              Objective is unbounded or badly scaled.
*              ---------------------------------------------------------
               iError = 2

            else if (inform .eq. 10) then
*              ---------------------------------------------------------
*              User wants to stop.
*              ---------------------------------------------------------
               iError = 6

            else if (KTcond(1)  .and.  duInf .lt. hundrd*tolNLP) then
*              ---------------------------------------------------------
*              Feasible, but not quite optimal.
*              ---------------------------------------------------------
               iError = 4

            else if (inform .le. 6) then
*              ---------------------------------------------------------
*              The line search wants to take a tiny step.
*              ---------------------------------------------------------
               if (info(iStep) .eq. 1) then
*                 ------------------------------------------------------
*                 The line search is backing away from a violation limit.
*                 Try elastic mode with a bigger infeasibility weight.
*                 ------------------------------------------------------
                  if ( nlnCon ) then
                     call s8wInf( IncWt,
     &                    boostd, itn, (gNorm+gNorm0), wtInf, wtInf0,
     &                    weight, wtFac, wtScal, iw, leniw )
                     if ( boostd ) then
                        iError = 0
                        Elastc = .true.
                        go to 300
                     else
                        iError = 9
                     end if
                  end if
               end if
            end if

*           ------------------------------------------------------------
*           If possible, reset the Hessian and solve the QP again.
*           ------------------------------------------------------------
            if (iError .eq. 0) then
               if (iw(Htype) .ne. HUnit  .and.  restrt) then
                  nStart = nStart + 1
                  call s8H0  ( iw(Htype), nnL, H0ii, iw, leniw,rw,lenrw)

*                 We'll try (almost) anything on the last reset.

                  if (nlnCon  .and.  iw(Htype) .eq. HUnit) then
                     incRun     = .true.
                     PenDmp     = one
                     PenMax     = one / eps
                     PenNrm     = xPen0
                     call dload ( nnCon, xPen0, xPen, 1 )
                  end if
                  go to 300

               else
*                 ------------------------------------------------------
*                 We have run out of things to try.
*                 ------------------------------------------------------
                  iError = 9
                  if (iPrint .gt. 0) then
                     write(iPrint, 1050) inform, msg(inform),
     &                                   nMajor, duInf
                  end if
                  if (iSumm  .gt. 0) then   
                     write(iSumm , 1050) inform, msg(inform),
     &                                   nMajor, duInf
                  end if
               end if
            end if
            go to 100 
         end if

*        ===============================================================
*        The new point  x1  has been computed.
*        ===============================================================
         if (step .ge. steplm) then
            info(iStep) = 2
         end if

         inform = 0
         centrl = iw(lvlDif) .eq. 2

*        ---------------------------------------------------------------
*        Some unknown derivatives may need to be calculated at x1.
*        ---------------------------------------------------------------
         if (usefLS  .and.  nnL .gt. 0)  then
            modefg = 1
            call fgwrap( modefg, iError, Status, nlnCon, nlnObj,
     &           n, neG, nnL, nnCon0, nnCon, nnJac, nnObj, 
     &           fgcon, fgobj,
     &           ne, nlocJ, locJ, indJ, 
     &           Fcon1, Fobj1, Gcon1, Gobj1, x1, 
     &           cu, lencu, iu, leniu, ru, lenru, 
     &           cw, lencw, iw, leniw, rw, lenrw )
            if (iError  .ne. 0) go to 100 ! Break

            if ( useFD ) then
               call s6fd  ( iError, n, neG, nnL,
     &              nnCon0, nnCon, nnJac, nnObj,
     &              fgwrap, fgcon, fgobj,
     &              ne, nlocJ, locJ, indJ,
     &              Fcon1, Fobj1, Gcon1, Gobj1, x1, y3,
     &              cu, lencu, iu, leniu, ru, lenru, 
     &              cw, lencw, iw, leniw, rw, lenrw )
               if (iError  .ne. 0) go to 100 ! Break
            end if
         end if

         inform = 0
         nMajor = nMajor + 1
         if ( centrl )
     &   cdItns = cdItns + 1

         if (MjrPrt .ge. 10  .or.  MnrPrt .ge. 1) then
            if (iPrint .gt. 0) then
               call s1page( 0, iw, leniw )
               write(iPrint, 1010) (line, j=1,29), nMajor
            end if
            if (iSumm  .gt. 0  .and.  MnrPrt .ge. 1) then
               write(iSumm , 1020) (line, j=1,19), nMajor
            end if
         end if

*        ===============================================================
*        The problem functions have been defined at the new x.
*        ===============================================================
         if (nnL .gt. 0 .and. (lvlHes .eq. LM .or. lvlHes .eq. FM)) then
*           ------------------------------------------------------------
*           Update an approximate Hessian of the Lagrangian.
*           ------------------------------------------------------------
            call s8HQN ( fgwrap, fgcon, fgobj, Mnrlog, Elastc, useFD,
     &           Hcalls, iw(Htype), iError, info, itn, itQP,
     &           lenR, m, maxS, mBS, MnrPrt, n, nb,
     &           nnCon0, nnCon, nnJac, nnObj, nnL,
     &           nS, nDegen, nMajor, nSkip, sclObj, tolFP, tolx,
     &           nInf, sInf, wtInf, step, minimz, dxHdx,
     &           RtRmod, gotR, incRun, PenDmp, PenMax,
     &           Fobj, Fcon, Gcon, Gobj, Fcon1, Gcon1, Gobj1,
     &           ne, nlocJ, locJ, indJ, Jcol, neG, nlocG, locG, 
     &           hElast, hEstat, hfeas, hs, kBS, 
     &           Ascale, bl, bu, blBS, buBS, gBS, dx, dg, Hdx, Lmul1,
     &           pi, R, rc, rg, QPrhs, x, x1, xBS,  
     &           xQP0, xQP, xPen, iy, iy1, y, y1, y2, y3,
     &           cu, lencu, iu, leniu, ru, lenru, 
     &           cw, lencw, iw, leniw, rw, lenrw )
         end if

*        ---------------------------------------------------------------
*        Update the variables.
*        The QP solution, saved in xQP, is used to start the next QP.
*        (If a unit step was not taken last iteration, some more
*        nonbasics may be between their bounds.
*        Nov 10, 1994. Tried leaving the nonbasics between their
*        bounds after short step. In some cases, the number of minor
*        iterations increased dramatically with a very short step.)
*        ---------------------------------------------------------------
         call dcopy ( nb, x1, 1, x, 1 )

         if ( nlnCon ) then
            call dcopy ( neG  , Gcon1, 1, Gcon, 1 )
            call dcopy ( nnCon, Lmul1, 1, Lmul, 1 )
            call dcopy ( nnCon, Fcon1, 1, Fcon, 1 )
         end if

         if ( nlnObj ) then
            Fobj  = Fobj1
            call dcopy ( nnObj, Gobj1, 1, Gobj, 1 )
         end if

         sInf = sInf1
         nInf = nInfQP      ! Not updated by the line search

         go to 100
*+    end while
      end if
*     ======================end of main loop============================
*     Exit.

      if (iError .eq. 0) then
*        ===============================================================
*        Optimal.
*        ===============================================================
         call s1page( 1, iw, leniw )

         if (nInf .eq. 0) then
*           ----------------------------------------
*           Optimal and feasible.
*           ----------------------------------------
            if ( FPonly ) then
               if (iPrint .gt. 0) write(iPrint, 9001)
               if (iSumm  .gt. 0) write(iSumm , 9001)
            else
               if (iPrint .gt. 0) write(iPrint, 9000)
               if (iSumm  .gt. 0) write(iSumm , 9000)
            end if
         else
*           ----------------------------------------
*           Optimal but Infeasible.
*           ----------------------------------------
            iError = 1

            if (iPrint .gt. 0) write(iPrint, 9010)
            if (iSumm  .gt. 0) write(iSumm , 9010)
         end if

         if (duInf .gt. 0.1d+0) then 
            if (iPrint .gt. 0) write(iPrint, 9005)
            if (iSumm  .gt. 0) write(iSumm , 9005)
         end if

      else
*        ===============================================================
*        An error flag was set.
*        ===============================================================
         call s1page( 2, iw, leniw )

         if (iError .lt. 0) then
*           -------------------------------------------------
*           Undefined functions (same as iError = 6).
*           -------------------------------------------------
            iError = 6
            if (iPrint .gt. 0) write(iPrint, 9060)
            if (iSumm  .gt. 0) write(iSumm , 9060)

         else if (iError .eq. 2) then
*           -------------------------------------------------
*           Unbounded.
*           -------------------------------------------------
            if (abs(Fobj) .gt. bigFx/ten  .or.  KTcond(1)) then
               if (iPrint .gt. 0) write(iPrint, 9020)
               if (iSumm  .gt. 0) write(iSumm , 9020)
            else
               if (iPrint .gt. 0) write(iPrint, 9021)
               if (iSumm  .gt. 0) write(iSumm , 9021)
            end if
        
         else if (iError .eq. 3) then
*           -------------------------------------------------
*           Too many iterations.
*           -------------------------------------------------
            if      (nMajor .ge. mMajor) then 
               if (iPrint .gt. 0) write(iPrint, 9031)
               if (iSumm  .gt. 0) write(iSumm , 9031)

            else if (nMinor .ge. mMinor) then
               if (iPrint .gt. 0) write(iPrint, 9032)
               if (iSumm  .gt. 0) write(iSumm , 9032)

            else if (itn    .ge. itnlim) then
               if (iPrint .gt. 0) write(iPrint, 9033)
               if (iSumm  .gt. 0) write(iSumm , 9033)
            end if

         else if (iError .eq. 4) then
*           -------------------------------------------------
*           Requested accuracy could not be achieved.
*           -------------------------------------------------
            if (iPrint .gt. 0) write(iPrint, 9040)
            if (iSumm  .gt. 0) write(iSumm , 9040)

         else if (iError .eq. 5) then
*           -------------------------------------------------
*           Superbasic limit too small.
*           -------------------------------------------------
            if (iPrint .gt. 0) write(iPrint, 9050) maxS
            if (iSumm  .gt. 0) write(iSumm , 9050) maxS

         else if (iError .eq. 9) then
*           -------------------------------------------------
*           Line search failure.
*           -------------------------------------------------
            if (iPrint .gt. 0) write(iPrint, 9090)
            if (iSumm  .gt. 0) write(iSumm , 9090)

         else if (iError .eq. 12) then
*           -------------------------------------------------
*           User termination via s1User.
*           -------------------------------------------------
            if (iPrint .gt. 0) write(iPrint, 9120)
            if (iSumm  .gt. 0) write(iSumm , 9120)
         end if
      end if

      return

 1010 format(  1x, 29a4 / ' Start of major itn', i6)
 1020 format(/ 1x, 19a4 / ' Start of major itn', i6)
 1050 format(  ' Search exit', i3, ' -- ', a,
     &         '   Itn =', i7, '  Dual Inf =', 1p, e11.3)
 3020 format( ' Itn', i7, ' -- Central differences invoked.',
     &       '  Small step length.' )

 9000 format(  ' EXIT -- optimal solution found')
 9001 format(  ' EXIT -- feasible point found')
 9005 format(/ ' XXX  WARNING -- reduced gradient is large --',
     &         ' solution is not really optimal.')
 9010 format(  ' EXIT -- infeasible problem, nonlinear infeasibilities',
     &         ' minimized')
 9020 format(  ' EXIT -- the problem is unbounded',
     &         ' (or badly scaled)')
 9021 format(  ' EXIT -- violation limit exceeded --',
     &         ' the problem may be unbounded')
 9031 format(  ' EXIT -- major iteration limit exceeded')
 9032 format(  ' EXIT -- minor iteration limit exceeded')
 9033 format(  ' EXIT -- iteration limit exceeded')
 9040 format(  ' EXIT -- requested accuracy could not be achieved')
 9060 format(  ' EXIT -- constraint and objective values',
     &         ' could not be calculated')
 9050 format(  ' EXIT -- the superbasics limit is too small:', i7)
 9090 format(  ' EXIT -- the current point cannot be improved')
 9120 format(  ' EXIT -- terminated from subroutine s1User')

      end ! of s8SQP

