*     ==================================================================
*     rw(1)--rw(29) contain machine-dependent parameters.
*     ------------------------------------------------------------------
      eps       = rw(  1) ! unit round-off.
      eps0      = rw(  2) ! eps**(4/5)
      eps1      = rw(  3) ! eps**(2/3)
      eps2      = rw(  4) ! eps**(1/2)
      eps3      = rw(  5) ! eps**(1/3)
      eps4      = rw(  6) ! eps**(1/4)
      eps5      = rw(  7) ! eps**(1/5)
      flmax     = rw(  8) ! est. of the largest pos. real.
      flmin     = rw(  9) ! smallest positive real.
      rtundf    = rw( 10) ! sqrt of flmin.
*     ------------------------------------------------------------------
*     rw(51)--rw(150): optional parameters set via the specs file.
*     ------------------------------------------------------------------
      tolFP     = rw( 51) ! Minor Phase 1 Opt tol
      tolQP     = rw( 52) ! Minor Phase 2 Opt tol
      tolNLP    = rw( 53) ! Major Optimality tolerance
*-->            = rw( 54) !
*-->            = rw( 55) !
      tolx      = rw( 56) ! Minor feasibility tolerance.
      tolCon    = rw( 57) ! Major feasibility tolerance.
*-->            = rw( 58) !
*-->            = rw( 59) !
      tolpiv    = rw( 60) ! excludes small elements of y.
      tolrow    = rw( 61) ! tolerance for the row error.
      tCrash    = rw( 62) ! crash tolerance.
*-->            = rw( 63) !
*-->            = rw( 64) !
      tolswp    = rw( 65) ! LU swap tolerance.
      tolfac    = rw( 66) ! LU factor tolerance.
      tolupd    = rw( 67) ! LU update tolerance.
*-->            = rw( 68) !
      rdummy    = rw( 69) ! definition of an 'unset' value
      plInfy    = rw( 70) ! definition of plus infinity.
      bigFx     = rw( 71) ! unbounded objective.
      bigdx     = rw( 72) ! unbounded step.
      epsrf     = rw( 73) ! relative function precision.
*-->            = rw( 74) !
*-->            = rw( 75) !
      fdint(1)  = rw( 76) ! (1) forwrd diff. interval
      fdint(2)  = rw( 77) ! (2) cntrl  diff. interval
*-->            = rw( 78) !
*-->            = rw( 79) !
      xdlim     = rw( 80) ! Step limit
      vilim     = rw( 81) ! violation limit 
*-->            = rw( 82) !
*-->            = rw( 83) !
      eta       = rw( 84) ! line search tolerance.
      Hcndbd    = rw( 85) ! bound on the condition of Hz
*-->            = rw( 86) !
*-->            = rw( 87) !
      wtInf0    = rw( 88) ! infeasibility weight
      xPen0     = rw( 89) ! initial penalty parameter.
*-->            = rw( 90) !
*-->            = rw( 91) !
      scltol    = rw( 92) ! scale tolerance.
*-->            = rw( 93) !
*-->            = rw( 94) !
      Aijtol    = rw( 95) ! zero Aij tolerance.
      bStruc(1) = rw( 96) ! default lower bound on x
      bStruc(2) = rw( 97) ! default upper bound on x
*     ------------------------------------------------------------------
*     rw(151)--z(180) contain  parmLU  parameters for LUSOL.
*     This could be part of an f90 or c structure.
*     ------------------------------------------------------------------
      eLmax1    = rw(151) ! max L-multiplier in factor.
      eLmax2    = rw(152) ! max L-multiplier in update.
      small     = rw(153) ! defn of small real.
      Utol1     = rw(154) ! abs tol for small diag of U.
      Utol2     = rw(155) ! rel tol for small diag of U.
      Uspace    = rw(156) ! limit on waste space in U.
      Dens1     = rw(157) ! switch to search maxcol columns and no rows.
      Dens2     = rw(158) ! switch to dense LU.
*-->            = rw(159) !
      amax      = rw(160) ! maximum element in  A.
      eLmax     = rw(161) ! maximum multiplier in L.
      Umax      = rw(162) ! maximum element in U.
      dUmax     = rw(163) ! maximum diagonal in  U.
      dUmin     = rw(164) ! minimum diagonal in  U.
*-->            = rw(165) !
*-->            = rw(166) !
*-->            = rw(167) !
*-->            = rw(168) !
*-->            = rw(169) !
      resid     = rw(170) ! lu6sol: residual.
*     ------------------------------------------------------------------
*     rw(181)--rw(199) pass parameters into various routines.
*     ------------------------------------------------------------------
*-->            = rw(181) !
*-->            = rw(182) !
*-->            = rw(183) !
      toldj(1)  = rw(184) ! phase 1 dj tol for p.p.
      toldj(2)  = rw(185) ! phase 2 dj tol for p.p.
      toldj(3)  = rw(186) ! current optimality tol
*-->            = rw(187) !
*-->            = rw(188) !
*-->            = rw(189) !
      Umin      = rw(190) ! saved smallest U diagonal
*     ------------------------------------------------------------------
*     rw(400)--rw(450) information for solvers calling SNOPT
*     ------------------------------------------------------------------
      ObjTru    = rw(400) ! AMPL: true objective
      piNorm    = rw(401) ! Used by Gams
      xNorm     = rw(402) ! Used by Gams
*     -----------------------------------------------------------------
*     rw(451)--rw(500) timing information
*     -----------------------------------------------------------------
      tlast( 1) = rw(451) !
      tlast( 2) = rw(452) !
      tlast( 3) = rw(453) !
      tlast( 4) = rw(454) !
      tlast( 5) = rw(455) !
      tlast( 6) = rw(456) ! not in use
      tlast( 7) = rw(457) ! not in use
      tlast( 8) = rw(458) ! not in use
      tlast( 9) = rw(459) ! not in use
      tlast(10) = rw(460) ! not in use
      tsum( 1)  = rw(461) ! Input time          
      tsum( 2)  = rw(462) ! Solve time          
      tsum( 3)  = rw(463) ! Output time         
      tsum( 4)  = rw(464) ! Constraint functions
      tsum( 5)  = rw(465) ! Nonlinear objective 
      tsum( 6)  = rw(466) ! not in use
      tsum( 7)  = rw(467) ! not in use
      tsum( 8)  = rw(468) ! not in use
      tsum( 9)  = rw(469) ! not in use
      tsum(10)  = rw(470) ! not in use
*     ==================================================================
*     Integer workspace.
*     iw(1)--iw(50): machine-dependent parameters or dimensions.
*     ==================================================================
*-->            = iw(  1) !
      maxru     = iw(  2) ! maxru+1 is the start of SNOPT part of rw
      maxrw     = iw(  3) ! end of SNOPT part of rw
      maxiu     = iw(  4) ! maxiu+1 is the start of SNOPT part of iw
      maxiw     = iw(  5) ! end of SNOPT part of iw
      maxcu     = iw(  6) ! maxcu+1 is the start of SNOPT part of cw
      maxcw     = iw(  7) ! end of SNOPT part of cw
*-->            = iw(  8) !
*-->            = iw(  9) !
      iRead     = iw( 10) ! Standard Input
      iSpecs    = iw( 11) ! Specs (options) file
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
*-->            = iw( 14) !
*     ------------------------------------------------------------------
*     Dimensions
*     ------------------------------------------------------------------
      n         = iw( 15) ! copy of the number of columns
      m         = iw( 16) ! copy of the number of rows
      ne        = iw( 17) ! copy of the number of nonzeros in Jcol
*-->            = iw( 18) !
*-->            = iw( 19) !
      neG       = iw( 20) ! # of nonzero elems in J
      nnJac     = iw( 21) ! # nonlinear Jacobian variables
      nnObj     = iw( 22) ! # of objective variables (usually nGobj)
      nnCon     = iw( 23) ! # of nonlinear constraints
      nnL       = iw( 24) !   max( nnObj, nnJac )
*-->            = iw( 25) !
      nGobj     = iw( 26) ! # elements of  gObj
      nnH       = iw( 27) ! # QP Hessian columns
      lenR      = iw( 28) ! R(lenR) is the reduced Hessian factor
*-->            = iw( 29) !
*-->            = iw( 30) !
      mincu1    = iw( 31) ! Start of first  user partition of cw
      maxcu1    = iw( 32) ! End   of first  user partition of cw 
      mincu2    = iw( 33) ! Start of second user partition of cw 
      maxcu2    = iw( 34) ! End   of second user partition of cw
*-->            = iw( 35) !
      miniu1    = iw( 36) ! Start of first  user partition of iw
      maxiu1    = iw( 37) ! End   of first  user partition of iw 
      miniu2    = iw( 38) ! Start of second user partition of iw 
      maxiu2    = iw( 39) ! End   of second user partition of iw
*-->            = iw( 40) !
      minru1    = iw( 41) ! Start of first  user partition of rw
      maxru1    = iw( 42) ! End   of first  user partition of rw 
      minru2    = iw( 43) ! Start of second user partition of rw 
      maxru2    = iw( 44) ! End   of second user partition of rw
*     ------------------------------------------------------------------
*     iw(51)--iw(150): optional parameters set via the specs file.
*     ------------------------------------------------------------------
      nColH     = iw( 51) ! Leading # of nonzeros in user Hx
      maxR      = iw( 52) ! max columns of R.
      maxS      = iw( 53) ! max # of superbasics
      mQNmod    = iw( 54) ! (ge 0) max # of BFGS updates
*-->            = iw( 55) !
      lEmode    = iw( 56) ! >0    => use elastic mode
*-->            = iw( 57) !
      kchk      = iw( 58) ! check (row) frequency
      kfac      = iw( 59) ! factorization frequency
      ksav      = iw( 60) ! save basis map
      klog      = iw( 61) ! log/print frequency
      kSumm     = iw( 62) ! Summary print frequency
      kDegen    = iw( 63) ! max. expansions of featol
      kReset    = iw( 64) ! Hessian frequency
*-->            = iw( 65) !
      mFlush    = iw( 66) ! Hessian flush
      mSkip     = iw( 67) ! # largest value of nSkip
*-->            = iw( 68) !
      lvlSrt    = iw( 69) ! = 0(1) => cold(warm) start
      lvlDer    = iw( 70) ! = 0, 1, 2 or 3, the derivative level
      lvlExi    = iw( 71) ! >0     => exit feasible on error
      lvlHes    = iw( 72) ! 0,1,2  => LM, FM, Exact Hessian
      lvlInf    = iw( 73) ! Elastic option
      lvlPrt    = iw( 74) ! Print Level for the minor itns
      lvlScl    = iw( 75) ! scale option
      lvlSch    = iw( 76) ! >0     => use derivatives in the line search
      lvlTim    = iw( 77) ! Timing level
      lvlVer    = iw( 78) ! Verify level
      lvlPPm    = iw( 79) ! Proximal Point method for x0
      lvlPiv    = iw( 80) ! 0(1) LU threshold partial(complete) pivoting
      lprPrm    = iw( 81) ! > 0    => parms are printed
      lprSch    = iw( 82) ! line search debug starting itn
      lprScl    = iw( 83) ! > 0    => print the scales
      lprSol    = iw( 84) ! > 0    => print the solution 
      lprDbg    = iw( 85) ! > 0    => private debug print
*-->            = iw( 86) !
      minmax    = iw( 87) ! 1, 0, -1  => MIN, FP, MAX
      iCrash    = iw( 88) ! Crash option
      itnlim    = iw( 89) ! limit on total iterations
      mMajor    = iw( 90) ! limit on major iterations
      mMinor    = iw( 91) ! limit on minor iterations
      MjrPrt    = iw( 92) ! Major print level
      MnrPrt    = iw( 93) ! Minor print level
      nParPr    = iw( 94) ! # of partial pricing sections
      mWSmod    = iw( 95) ! # of working set changes
*-->            = iw( 96) !
*-->            = iw( 97) !
      jverif(1) = iw( 98) ! (1) stop and start columns
      jverif(2) = iw( 99) ! (2) stop and start columns
      jverif(3) = iw(100) ! (3) stop and start columns
      jverif(4) = iw(101) ! (4) stop and start columns
*-->            = iw(102) !
*-->            = iw(103) !
*-->            = iw(104) !
      lDenJ     = iw(105) ! 1(2)    => CUTE dense(sparse) Jacobian
      MPSerr    = iw(106) ! maximum # errors in MPS data
      mLst      = iw(107) ! maximum # lines  of MPS data
      nProb     = iw(108) ! problem number
*-->            = iw(109) !
*-->            = iw(110) !
*-->            = iw(111) !
*-->            = iw(112) !
*-->            = iw(113) !
*-->            = iw(114) !
*-->            = iw(115) !
*-->            = iw(116) !
*-->            = iw(117) !
*-->            = iw(118) !
*-->            = iw(119) !
      iBack     = iw(120) ! backup file
      iDump     = iw(121) ! dump file
      iLoadB    = iw(122) ! load file
      iMPS      = iw(123) ! MPS file
      iNewB     = iw(124) ! new basis file
      iInsrt    = iw(125) ! insert file
      iOldB     = iw(126) ! old basis file
      iPnch     = iw(127) ! punch file
*-->            = iw(128) !
*-->            = iw(129) !
      iReprt    = iw(130) ! report file
      iSoln     = iw(131) ! solution file
*-->            = iw(132) !
      maxm      = iw(133) ! Estimate of the number of rows
      maxn      = iw(134) ! Estimate of the number of columns
      maxne     = iw(135) ! Estimate of the number of elements
*     ------------------------------------------------------------------
*     iw(151)--iw(180) contain luparm parameters for LUSOL.
*     ------------------------------------------------------------------
      nout      = iw(151) ! unit # for printed messages
      LUprnt    = iw(152) ! print level in LU routines
      maxcol    = iw(153) ! lu1fac: max. # columns
*-->            = iw(154) !
*-->            = iw(155) !
      TPivot    = iw(156) ! 0(1) LU threshold partial(complete) pivoting
*-->            = iw(157) !
      keepLU    = iw(158) !
*-->            = iw(159) !
      iErr      = iw(160) ! LU error flag
      nSing     = iw(161) ! # of singularities in w(*)
      jsing     = iw(162) ! col. no. of last singularity
      minlen    = iw(163) ! minimum recommended lenaLU
      maxlen    = iw(164) !
      nupdat    = iw(165) ! # of updates by lu8
      nrank     = iw(166) ! # of nonempty rows of U
      nDens1    = iw(167) ! # cols undone when dnsty>   =Dens1
      nDens2    = iw(168) ! # cols undone when dnsty>   =Dens2
      jUmin     = iw(169) ! col of B corres. to dUmin
      numL0     = iw(170) ! # columns in initial  L
      lenL0     = iw(171) ! size of L0
      lenU0     = iw(172) ! size of initial  U
      lenL      = iw(173) ! size of current  L
      lenU      = iw(174) ! size of current  U
      lrow      = iw(175) ! length of row file
      ncp       = iw(176) ! no. of compressions
      mersum    = iw(177) ! tot. of Markowitz merit counts
      nUtri     = iw(178) ! lu1fac: # of tri. rows in U
      nLtri     = iw(179) ! lu1fac: # of tri. rows in L
*-->            = iw(180) !
*     ------------------------------------------------------------------
*     iw(181)--iw(199) pass parameters into various routines.
*     ------------------------------------------------------------------
*-->            = iw(181) !
      lvlDif    = iw(182) !  1(2) for forwd (cntrl) diffs
      nConfd    = iw(183) ! # of unknown elements of Gcon 
      nObjfd    = iw(184) ! # of unknown elements of Gobj
*-->            = iw(185) !
      Gotg(1)   = iw(186) ! number of Gobj elements set
      Gotg(2)   = iw(187) ! number of Gcon elements set
*-->            = iw(188) !
      nFcon(1)  = iw(189) ! calls to Fcon: mode = 0
      nFcon(2)  = iw(190) ! calls to Fcon  mode > 0
      nFcon(3)  = iw(191) ! calls to Fcon
      nFcon(4)  = iw(192) ! calls to Fcon
*-->            = iw(193) !
      nFobj(1)  = iw(194) ! calls to Fobj: mode = 0
      nFobj(2)  = iw(195) ! calls to Fobj: mode > 0
      nFobj(3)  = iw(196) ! calls to Fobj
      nFobj(4)  = iw(197) ! calls to Fobj
*-->            = iw(198) !
      minimz    = iw(199) ! (-1)(+1)    => (max)(min)
      eigH      = iw(200) !   1 (0)  for definite (semidef) QP Hessian
      nQNmod    = iw(201) ! # of BFGS updates since last reset
      Htype     = iw(202) ! Current approximate Hessian type
*-->            = iw(203) !
      iObj      = iw(204) ! position of the objective row in J
      kObj      = iw(205) ! xBS(kObj) is the obj. slack
*-->            = iw(206) !
      maxvi     = iw(207) ! index of maximum violation
*-->            = iw(208) !
*-->            = iw(209) !
      nFac      = iw(210) ! # of LU factorizations
      nBfac     = iw(211) ! # consecutive  `B' factorizes
*-->            = iw(212) !
      lenaLU    = iw(213) ! space allotted for LU factors
      LUreq     = iw(214) ! Reason for refactorization
      LUitn     = iw(215) ! itns since last factorize
      LUmod     = iw(216) ! number of LU mods
*-->            = iw(217) !
*-->            = iw(218) !
*-->            = iw(219) !
*-->            = iw(220) !
*-->            = iw(221) !
*-->            = iw(222) !
      MnrHdg    = iw(223) ! >0 => Mnr heading for iPrint
      MjrHdg    = iw(224) ! >0 => Mjr heading for iPrint
      MjrSum    = iw(225) ! >0 => Mjr heading for iSumm
*-->            = iw(226) !
*-->            = iw(227) !
      iPrintx   = iw(228) ! Global value of iPrint
      iSummx    = iw(229) ! Global value of iSumm
*-->            = iw(230) !
*-->            = iw(231) !
*-->            = iw(232) !
      nName     = iw(233) ! # of row and col. names
*-->            = iw(234) !
      iwSav1    = iw(235) ! iw scratch space
      iwSav2    = iw(236) ! iw scratch space
      iwSav3    = iw(237) ! iw scratch space
      iALONE    = iw(238) ! > 0     =  stand-alone
*-->            = iw(239) !
*-->            = iw(240) !
      ipage1    = iw(241) ! > 0 
      ipage2    = iw(242) ! > 0 
*-->            = iw(243) ! > 0 
*-->            = iw(244) ! > 0 
      itn       = iw(245) ! Iteration count. Used by the AMPL interface
*     ------------------------------------------------------------------
*     iw(251)--iw(360) hold array addresses.
*     ------------------------------------------------------------------
*-->            = iw(251) ! used
*-->            = iw(252) ! used
*-->            = iw(253) !
*-->            = iw(254) !
*-->            = iw(255) !
      lJcol     = iw(256) ! Jcol(ne)    = Constraint Jacobian by columns
      llocJ     = iw(257) ! locJ(n+1)   = column pointers for indJ
      lindJ     = iw(258) ! indJ(ne) holds the row indices for Jij
*-->            = iw(259) !
      llocG     = iw(260) ! locG(nlocG) = column pointers for indG
*-->            = iw(261) ! used
*-->            = iw(262) ! used
*-->            = iw(263) !
*-->            = iw(264) ! used
*-->            = iw(265) ! used
*-->            = iw(266) ! 
      liHvar    = iw(267) ! iHvar(neH) row list of reordered H nonzeros
      ljHvar    = iw(268) ! jHvar(neH) col list of reordered H nonzeros
*-->            = iw(269) !
*-->            = iw(270) !
      lbl       = iw(271) ! bl(nb)      = lower bounds
      lbu       = iw(272) ! bu(nb)      = upper bounds
      lblBS     = iw(273) ! blBS(mBS)   = lower bounds for xBS
      lbuBS     = iw(274) ! buBS(mBS)   = upper bounds for xBS
      lblSav    = iw(275) ! blSav(nb)   = copy of bl
      lbuSav    = iw(276) ! buSav(nb)   = copy of bu
*-->            = iw(277) !
      lQPrhs    = iw(278) ! QPrhs(nrhs) rhs of QP constraints 
      lpi       = iw(279) ! pi(m)       = the pi-vector
      lrc       = iw(280) ! rc(nb)      = the reduced costs
*-->            = iw(281) !
      lhs       = iw(282) ! the column state vector
      lhElas    = iw(283) ! hElast(nb) definition of elastic vars
      lhfeas    = iw(284) ! hfeas(mBS), feasibility types
      lhEsta    = iw(285) ! hEstat(nb), status of elastics
*-->            = iw(286) !
      ldx       = iw(287) ! dx(nb)      = x1 - x
      lHdx      = iw(288) ! Hdx(nnQP)   = product of H with  x1 - x
      lgd       = iw(289) ! gd(nnL)     = gradient difference 
      lgQP      = iw(290) ! gQP(ngQP)   = QP gradient 
      lgBS      = iw(291) ! gBS(mBS)    = BS components of g
      lkBS      = iw(292) ! kBS(mBS)    = ( B  S ) list
      lrg       = iw(293) ! rg (maxS)   = reduced gradient
      lR        = iw(294) ! R(lenR)     = factor of Z'HZ
      lAscal    = iw(295) ! Ascale(nb)  = row and column scales
      lGobj     = iw(296) ! Gobj(nnObj) = Objective gradient
*-->            = iw(297) !
      lx0       = iw(298) ! x0(nnL)     = Feasible starting point
      lx        = iw(299) ! x(nb)       = the solution (x,s)
      lx1       = iw(300) ! x1(nb)      = new x.
      lxBS      = iw(301) ! xBS(mBS)    = basics, superbasics 
      lxscal    = iw(302) ! xscal(n)    = copy of the scaled x
*-->            = iw(303) !
      lxPen     = iw(304) ! xPen(nnCon) = penalty params
      lxQP      = iw(305) ! xQP(nb)     = QP solution
      lxQP0     = iw(306) ! xQP0(nb)    = QP feasible pt.
*-->            = iw(307) !
      liy       = iw(308) ! iy (nb)     =  integer work vector
      liy1      = iw(309) ! iy1(nb)     =  integer work vector
*-->            = iw(310) !
      ly        = iw(311) ! y (nb)      =  real work vector
      ly1       = iw(312) ! y1(nb)      =  real work vector
      ly2       = iw(313) ! y2(nb)      =  real work vector
      ly3       = iw(314) ! y3(nb)      =  real work vector
*-->            = iw(315) !
      lFcon     = iw(316) ! Fcon (nnCon) constraints at x
      lFcon1    = iw(317) ! Fcon1(nnCon) constraints at x1
      lFcon2    = iw(318) ! Fcon2(nnCon) work vector
      lGconu    = iw(319) ! record of unknown derivatives and constants
      lGcon     = iw(320) ! Gcon (neG)   constraint gradients at x
      lGcon1    = iw(321) ! Gcon1(neG)   constraint gradients at x1
      lGcon2    = iw(322) ! Gcon2(neG)   work vector
      lGobju    = iw(323) ! record of unknown derivatives
      lGobj1    = iw(324) ! Gobj1(nnObj) objective gradients at x1
      lGobj2    = iw(325) ! Gobj2(nnObj) work Gobj
*-->            = iw(326) !
      lH        = iw(327) ! H (lenH)    = second derivatives
*-->  lH2       = iw(328) ! used
*-->            = iw(329) !
*-->            = iw(330) !
*-->  lAx       = iw(331) ! used
*-->  lAdx      = iw(332) ! used
*-->            = iw(333) !
*-->  lD        = iw(334) ! used
*-->            = iw(335) !
      lFx       = iw(336) ! Fx (nnCon)   = F(x) + A(linear)x 
*-->  lFx1      = iw(337) ! used
*-->  lFx2      = iw(338) ! used
*-->            = iw(339) !
      lFv       = iw(340) ! Fv (nnCon )  = F(x) + A(linear)x - sN
*-->            = iw(341) !
*-->            = iw(342) !
*-->  lGdx      = iw(343) ! used
*-->  lG1dx     = iw(344) ! used
*-->  lG2dx     = iw(345) ! used
      lH0       = iw(346) ! Initial diagonal Hessian
*-->            = iw(347) !
      lLmul     = iw(348) ! Lmul (nnCon) = multipliers for F
      lLmul1    = iw(349) ! Lmul1(nnCon) = Lmul at x1
      lLmul2    = iw(350) ! Lmul2(nnCon) = work copy of Lmul
      ldLmul    = iw(351) ! dLmul(nnCon) = Lmul1 - Lmul
*-->            = iw(352) !
      lNames    = iw(353) ! Names(nName)
      lkeynm    = iw(354) ! keynm(lenh) = hash table keys
*-->            = iw(355) !
*-->            = iw(356) !
*-->            = iw(357) !
*-->            = iw(358) !
*-->            = iw(359) !
*-->            = iw(360) !
*     ------------------------------------------------------------------
*     iw(361)--iw(380) contain array addresses for LUsol.
*     ------------------------------------------------------------------
      maxLUi    = iw(361) ! max LU nonzeros in iw(*)
      maxLUr    = iw(362) ! max LU nonzeros in rw(*)
      ip        = iw(363) !
      iq        = iw(364) !
      lenc      = iw(365) !
      lenri     = iw(366) !
      locc      = iw(367) !
      locr      = iw(368) !
      iploc     = iw(369) !
      iqloc     = iw(370) !
      LUa       = iw(371) !
*-->            = iw(372) !
      indc      = iw(373) !
      indr      = iw(374) !
*     ------------------------------------------------------------------
*     iw(381)--iw(390) contain variables associated with the QN update.
*     ------------------------------------------------------------------
      nQNmod    = iw(381) ! # of BFGS updates since last reset
      nSkip     = iw(382) ! # of consecutive skipped updates
*-->            = iw(383) !
      nFlush    = iw(384) ! Iterations since last Hessian flush
*-->            = iw(385) !
*-->            = iw(386) !
*-->            = iw(387) !
*-->            = iw(388) !
*-->            = iw(389) !
*-->            = iw(390) !
*     ------------------------------------------------------------------
*     iw(391)--iw(400) contain array addresses for FM QN updates.
*     ------------------------------------------------------------------
      lfH       = iw(391) ! H(lenfH), full-memory BFGS Hessian
      lenfH     = iw(392) ! 
*     ------------------------------------------------------------------
*     iw(401)--iw(410) contain array addresses for LM QN updates.
*     ------------------------------------------------------------------
*-->            = iw(401) !
      lgdSav    = iw(402) !
      lHdSav    = iw(403) !
      lydx      = iw(404) !
      ldxHdx    = iw(405) !
*-->            = iw(406) !
*-->            = iw(407) !
*-->            = iw(408) !
*-->            = iw(409) !
*-->            = iw(410) !
*     ------------------------------------------------------------------
*     iw(411)--iw(420) contain array addresses for exact Hessian.
*     ------------------------------------------------------------------
*-->            = iw(411) !
*-->            = iw(412) !
*     ------------------------------------------------------------------
*     iw(421)--iw(450) information for solvers calling SNOPT
*     ------------------------------------------------------------------
      itn       = iw(421) ! AMPL: iteration count.
*-->            = iw(422) !
*-->            = iw(423) !
*-->            = iw(424) !
*-->            = iw(425) !
*-->            = iw(426) !
*-->            = iw(427) !
*-->            = iw(428) !
*-->            = iw(429) !
*-->            = iw(430) !
*     ------------------------------------------------------------------
*     iw(451)--iw(500) timing information
*     ------------------------------------------------------------------
      numt( 1)  = iw(451) ! Input time                          
      numt( 2)  = iw(452) ! Solve time          
      numt( 3)  = iw(453) ! Output time         
      numt( 4)  = iw(454) ! Constraint functions
      numt( 5)  = iw(455) ! Nonlinear objective 
      numt( 6)  = iw(456) ! not used
      numy( 7)  = iw(457) ! not used
      numt( 8)  = iw(458) ! not used
      numt( 9)  = iw(459) ! not used
      numt(10)  = iw(460) ! not used
*     ==================================================================
*     Character*8  workspace.
*     cw(51)--cw(150): optional parameters set via the specs file.
*     ==================================================================
      mProb     = cw( 51) ! Problem name
      mObj      = cw( 52) ! Objective name
      mRhs      = cw( 53) ! rhs name
      mRng      = cw( 54) ! range name
      mBnd      = cw( 55) ! bounds name
*-->            = cw( 56) !
*-->            = cw( 57) !
*-->            = cw( 58) !
*-->            = cw( 59) !
*-->            = cw( 60) !
*     ==================================================================
