*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
*     File  sqopt.f
*
*     sqopt
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqopt ( Start, qpHx, m,
     &     n, ne, nName, lenc, ncolH,
     &     iObj, ObjAdd, Prob,
     &     Acol, indA, locA, bl, bu, c, Names,
     &     hElast, hs, x, pi, rc,
     &     inform, mincw, miniw, minrw,
     &     nS, nInf, sInf, Obj,
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      external
     &     qpHx
      integer
     &     m, n, ne, nName, lenc, ncolH, iObj, inform, mincw, miniw,
     &     minrw,  nS, nInf, lencu, leniu, lenru, lencw,
     &     leniw, lenrw, indA(ne), hElast(n+m), hs(n+m), locA(n+1),
     &     iu(leniu), iw(leniw)
      double precision
     &     ObjAdd, sInf, Obj, Acol(ne), bl(n+m), bu(n+m), c(*), pi(m),
     &     rc(n+m), x(n+m), ru(lenru), rw(lenrw)
      character*(*)
     &     Start
      character*8
     &     Prob, Names(nName), cu(lencu), cw(lencw)

*     ------------------------------------------------------------------
*     sqopt    solves the linear/quadratic programming problem
*
*     Min/max     ObjAdd + <a(iObj),x> + <c,x> + half <x,H*x>
*        x
*     subject to linear constraints, and upper and lower bounds on x
*     (see below).
*
*     ObjAdd  is a constant scalar.
*     a(iObj) is the iObj-th row of the constraint matrix A (see below).
*     c       is a constant vector.
*     H       is a constant symmetric matrix, defined implicitly in the 
*             user-supplied subroutine qpHx.
*             o Subroutine qpHx must evaluate products of H with a given
*               vector x. This implies that H is defined as an operator,
*               and need never be defined explicitly.
*             o If H has zero rows and columns, it is most efficient to
*               order the variables so that
*                      Hx = ( H1  0 )( X1 ) = ( H1 x1 ),
*                           ( 0   0 )( X2)    (   0   )
*               where the nonlinear variables x1 appear first as shown.
*
*     The constraints take the form
*
*                            (  x )
*                      bl <= (    ) <= bu,
*                            ( Ax )
*
*     where bl and bu are constant lower and upper bounds. 
*
*     Internally, the constraints are rewritten as
*
*                                         ( x )
*                   Ax - s = 0,     bl <= (   ) <= bu,
*                                         ( s )
*
*     where s is an m-vector of slack variables.
*     components of (x,s) are the variables and slacks respectively.
*     The sparse matrix A is entered column-wise in the arrays
*     Acol, indA, locA (below).
*
*     ------------------------------------------------------------------
*     NOTE: Before calling sqopt, the calling program must call:
*     call sqInit( iPrint, iSumm,
*    &             cw, lencw, iw, leniw, rw, lenrw )
*     This sets the default values of the optional parameters. You can
*     also alter the default values of iPrint and iSumm before sqopt 
*     is used.  iPrint = 0, etc, is OK.
*     ------------------------------------------------------------------
*
*     ON ENTRY:
*
*     Start   specifies how a starting basis (and certain other items)
*             are to be obtained.
*             Start = 'Cold' means that Crash should be used to choose
*                      an initial basis, unless a basis file is given
*                      via Old basis, Insert or Load in the Specs file.
*             Start = 'Basis file' means the same (but is more
*                      meaningful in the latter case).
*             Start = 'Warm' means that a basis is already defined in hs
*                      (probably from an earlier call).
*
*     m       is the number of rows in the constraint matrix A.
*             m > 0.
*
*     n       is the number of variables, excluding slacks.
*             For LP problems, this is the number of columns in A.
*             n > 0.
*
*     ne      is the number of nonzero entries in A.
*             ne > 0.
*
*     nName   is the number of column and row names provided in the
*             array  Names.  If nName = 1, there are NO names.
*             Generic names will be used in the printed solution.
*             Otherwise, nName = n+m and all names must be provided.
*
*     lenc    is the number of elements in the constant objective c.
*             lenc ge 0.
*
*     ncolH   is the number of leading nonzero columns of the
*             QP Hessian.  
*             If ncolH > 0, the subroutine qpHx must provide the
*             matrix-product Hx.
*             ncolH ge 0.
*
*     iObj    says which row of A is a free row containing a linear
*             objective vector  c  (iObj = 0 if none).
*             iObj = 0  or  iObj le m.
*
*     ObjAdd  is a constant that will be added to the objective before
*             printing.  Typically,  ObjAdd = 0.0d+0.
*
*     Prob    is an 8-character name for the problem, used in the
*             output.  A blank name can be assigned if necessary.
*
*     Acol(ne) is the constraint matrix, stored column-wise.
*
*     indA(ne) is the list of row indices for each nonzero in a(*).
*
*     locA(n+1) is a set of pointers to the beginning of each column of
*             the constraint matrix within Acol(*) and indA(*).
*             MUST HAVE locA(1) = 1 AND locA(n+1) = ne+1.
*
*  NOTES:  1. If lenc > 0, the first lenc columns of Acol and indA belong
*             to variables corresponding to the constant
*             objective term c.
*          
*          2. If the problem has a quadratic objective,
*             The first ncolH columns of Acol and indA belong to variables
*             corresponding to the nonzero block of the QP Hessian.
*             Subroutine qpHx deals with these variables.
*             
*          3. If lenc > 0 and ncolH > 0, the two sets of
*             objective variables overlap.  The total number of
*             objective variables is nQP = max( lenc, ncolH ).
*          
*          4. The row indices indA(k) for a column may be in any order.
*          
*     bl(n+m) is the lower bounds on the variables and slacks (x, s).
*
*     bu(n+m) is the upper bounds on (x, s).
*
*     Names(nName) is an character*8 array.
*             If nName =  1, Names is not used.  The printed solution
*             will use generic names for the columns and row.
*             If nName = n+m, Names(j) should contain an 8 character
*             name of the jth variable (j = 1, n+m).
*             If j = n+i, the jth variable is the ith row.
*
*     hElast(n+m) indicate if the variable can violate its bound in 
*             Elastic mode.
*             if hElast(j) = 0, variable j is non-elastic and must not
*                               be violated.
*             if hElast(j) = 1, variable j can violate its lower bound.
*             if hElast(j) = 2, variable j can violate its upper bound.
*             if hElast(j) = 3, variable j can violate either its 
*                                          lower or upper bound.
*
*     hs(n+m) sometimes contains a set of initial states for each
*             variable (x, s).  See the following NOTES.
*
*     x(n+m)  is a set of initial values for each variable (x, s).
*
*  NOTES:  1. If Start = 'Cold' or 'Basis file' and a BASIS file
*             of some sort is to be input
*             (an OLD BASIS file, INSERT file or LOAD file),
*             hs and x need not be set at all.
*
*          2. Otherwise, hs(1:n) must be defined for a cold start.
*             If nothing special is known about the problem, or if
*             there is no wish to provide special information,
*             you may set hs(j) = 0, x(j) = 0.0d+0 for all j=1:n.
*             All variables will be eligible for the initial basis.
*        
*             Less trivially, to say that variable j will probably
*             be equal to one of its bounds,
*             set hs(j) = 4 and x(j) = bl(j)
*             or  hs(j) = 5 and x(j) = bu(j) as appropriate.
*        
*          3. For Cold starts with no basis file, a Crash procedure
*             is used to select an initial basis.  The initial basis
*             matrix will be triangular (ignoring certain small
*             entries in each column).
*             The values hs(j) = 0, 1, 2, 3, 4, 5 have the following
*             meaning:
*                
*             hs(j)    State of variable j during Crash
*        
*             0, 1, 3  Eligible for the basis.  3 is given preference.
*             2, 4, 5  Ignored.
*        
*             After Crash, hs(j) = 2 entries are made superbasic.
*             Other entries not selected for the basis are made
*             nonbasic at the value x(j) if bl(j) <= x(j) <= bu(j),
*             or at the value bl(j) or bu(j) closest to x(j).
*
*          4. For Warm starts, all of hs(1:n+m) is assumed to be
*             set to the values 0, 1, 2 or 3 from some previous call.
*        
*     nS      need not be specified for Cold starts,
*             but should retain its value from a previous call
*             when a Warm start is used.
*
*
*     ON EXIT:
*
*     hs(n+m) is the final state vector:
*
*                hs(j)    State of variable j    Normal value of x(j)
*
*                  0      nonbasic               bl(j)
*                  1      nonbasic               bu(j)
*                  2      superbasic             Between bl(j) and bu(j)
*                  3      basic                  ditto
*
*             Very occasionally there may be nonbasic variables for
*             which x(j) lies strictly between its bounds.
*             If nInf = 0, basic and superbasic variables may be outside
*             their bounds by as much as the Feasibility tolerance.
*             Note that if Scale is specified, the Feasibility tolerance
*             applies to the variables of the SCALED problem. 
*             In this case, the variables of the original problem may be
*             as much as 0.1 outside their bounds, but this is unlikely
*             unless the problem is very badly scaled.
*
*     x(n+m)  is the final variables and slacks (x, s).
*
*     pi(m)   is the vector of Lagrange multipliers (shadow prices)
*             for the general constraints.
*
*     rc(n+m) is a vector of reduced costs: rc = g - (A -I)'*pi, where g
*             is the gradient of the objective if x is feasible
*             (or the gradient of the Phase 1 objective otherwise).
*             If nInf = 0, the last m entries are pi.
*
*     inform  says what happened; see the User's Guide.
*             A summary of possible values follows:
*
*             inform   Meaning
*
*                0     Optimal solution found
*                1     The problem is infeasible
*                2     The problem is unbounded (or badly scaled)
*                3     Too many iterations
*                4     Weak solution
*                5     The superbasics limit is too small.
*                6     H not positive semi-definite
*
*               10     Numerical error in trying to satisfy the linear
*                      constraints.  The basis is very ill-conditioned.
*
*               20     Not enough storage for the basis factorization.
*               21     Error in basis package.
*               22     The basis is singular after several attempts to
*                      factorize it (and add slacks where necessary).
*
*               30     An OLD BASIS file had dimensions that did not
*                      match the current problem.
*               32     System error.  Wrong number of basic variables.
*
*               41     Not enough storage to hold SQOPT local variables.
*               42     Not enough char    storage to solve the problem.
*               43     Not enough integer storage to solve the problem.
*               44     Not enough real    storage to solve the problem.
*
*     mincw   says how much character storage is needed to solve the
*             problem.  If inform = 42, the work array cw(lencw) was 
*             too small.  SQOPT may be called again with lencw suitably 
*             larger than mincw.
*
*     miniw   says how much integer storage is needed to solve the
*             problem.  If inform = 43, the work array iw(leniw) was too
*             small.  SQOPT  may be called again with leniw suitably 
*             larger than miniw.  (The bigger the better, since it is
*             not certain how much storage the basis factors need.)
*
*     minrw   says how much real storage is needed to solve the problem.
*             If inform = 44, the work array rw(lenrw) was too small.
*             (See the comments above for miniw.)
*
*     nS      is the final number of superbasics.
*
*     nInf    is the number of infeasibilities.
*
*     sInf    is the sum    of infeasibilities.
*
*     Obj     is the value of the QP objective function.
*             Obj does NOT include ObjAdd or the objective row.
*             If nInf = 0, Obj includes the quadratic objective if any.
*             If nInf > 0, Obj is just the linear objective if any.
*
*     cu(lencu), iu(leniu), ru(lenru)  are character, integer and real
*             arrays of USER workspace.  These arrays are available to
*             pass data to the user-defined routine qpHx.
*             If no workspace is required, you can either use dummy
*             arrays for cu, iu and ru, or use cw, iw and rw
*             (see below).
*
*     cw(lencw), iw(leniw), rw(lenrw)  are character*8, integer and real
*             arrays of workspace used by SQOPT.
*             lencw  should be about at least 500.
*             leniw  should be about max( 500, 10(m+n) ) or larger.
*             lenrw  should be about max( 500, 20(m+n) ) or larger.
*
*     SQOPT is maintained by Philip E. Gill, 
*     Dept of Mathematics, University of California, San Diego.
*     
*     LUSOL is maintained by Michael A. Saunders,
*     Systems Optimization Laboratory,
*     Dept of Management Science & Engineering, Stanford University.
*
*     12 Nov 1994: Workspace separated into iw(*) and rw(*).
*     20 Jul 1996: Slacks changed to be the row value.
*     09 Aug 1996: First Min Sum version.
*     17 Jul 1997: Thread-safe version.
*     26 Jul 1997: User workspace added.
*     02 Oct 1997: Character workspace added.
*     06 Nov 2000: Current version of sqopt.
*     ==================================================================
      character*1
     &     ch1
      integer
     &     iPrint, iSumm, lenH, lenR, lenx0, maxcw, maxiw, maxrw, maxR,
     &     maxS, mProb, nb, neH, nnH0, ngQP, nGobj0, nGobj, nlocA,
     &     nnCon, nnObj, nnJac, nnH, nrhs0, nrhs, nx0, iError, iStart,
     &     iHvar(1), jHvar(1)
      double precision
     &     ObjQP, ObjTru, H(1), rhs(1), x0(1)
      external
     &     sqHx, sqprnt
*     ------------------------------------------------------------------
      integer            Cold,       Basis,      Warm 
      parameter         (Cold   = 0, Basis  = 1, Warm  = 2)
      parameter         (iPrint    =  12) ! Print file
      parameter         (iSumm     =  13) ! Summary file
      parameter         (mProb     =  51) ! Problem name 
      integer            StdIn
      parameter         (StdIn  = 2)
      integer            PrintO
      parameter         (PrintO = 1) 
*     ------------------------------------------------------------------

      iError = 0

*     ------------------------------------------------------------------
*     Check memory limits and fetch the workspace starting positions.
*     ------------------------------------------------------------------
      call s2Mem ( iError, lencw, leniw, lenrw, iw,
     &     mincw, miniw, minrw, maxcw, maxiw, maxrw )

      if (iError .ne. 0) then
         inform = iError
         go to 999
      end if

*     Initialize timers and the standard input file.

      call s1time( 0, 0, iw, leniw, rw, lenrw  )
      call s1file( StdIn, iw, leniw )

      iError  = 0

*     Load the iw array with various problem dimensions.
*     First record problem dimensions for smart users to access in iw.

      nnCon   = 0
      nnObj   = 0
      nnJac   = 0
      nnH     = min(max(0, ncolH), n)
      nnH0    = max( nnH  , 1   )
      nGobj   = lenc
      ngQP    = max( nGobj, nnH )
              
      iw( 15) = n               ! copy of the number of columns
      iw( 16) = m               ! copy of the number of rows
      iw( 17) = ne              ! copy of the number of nonzeros in Acol
      iw( 21) = nnJac           ! # nonlinear Jacobian variables
      iw( 22) = nnObj           ! # variables in Gobj
      iw( 23) = nnCon           ! # of nonlinear constraints
      iw( 26) = lenc            ! length of QP constant vector
      iw( 27) = nnH             ! # QP Hessian columns
      iw(204) = iObj            ! position of the objective row in A

*     ------------------------------------------------------------------
*     The obligatory call to sqInit has already set the defaults.
*     Check that the optional parameters have sensible values.
*     Print the options if iPrint > 0, Print level > 0 and lvlPrm > 0.
*     ------------------------------------------------------------------
      call s5dflt( PrintO, cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Compute the storage requirements for SQOPT  from the following
*     variables:
*         m   , n   , ne
*         maxR, maxS, lenc (nGobj),  ncolH (nnH)
*     ------------------------------------------------------------------
      maxR    = iw( 52) ! max columns of R.
      maxS    = iw( 53) ! max # of superbasics

      lenR    = maxR*(maxR + 1)/2
      iw( 28) = lenR    ! R(lenR) is the reduced Hessian factor

      call s5Mem ( iError, iw(iPrint), iw(iSumm),
     &     m, n, ne, nGobj, nnH, lenR, maxS,
     &     mincw , miniw , minrw , ! In/Out
     &     maxcw , maxiw , maxrw , ! Out
     &     lencw , leniw , lenrw , iw )
      if (iError .ne. 0) then
         inform = iError
         go to 999
      end if

*     ------------------------------------------------------------------
*     Copy the problem name into the work array.
*     ------------------------------------------------------------------
      cw(mProb) = Prob

*     ==================================================================
*     Decode 'Start'.
*     ==================================================================
      ch1    = Start(1:1)

      if      (ch1 .eq. 'C'  .or.  ch1 .eq. 'c') then
         iStart = COLD
      else if (ch1 .eq. 'B'  .or.  ch1 .eq. 'b') then
         iStart = BASIS
      else if (ch1 .eq. 'W'  .or.  ch1 .eq. 'w') then
         iStart = WARM
      else
         iStart = COLD
         if (iPrint .gt. 0) write(iPrint, 1030) Start
         if (iSumm  .gt. 0) write(iSumm , 1030) Start
      end if

*     ------------------------------------------------------------------
*     Set default values for the unused features in sqopt.
*     ------------------------------------------------------------------
      neH    = 0                ! No explicit Hessian.
      lenH   = 1
      nrhs   = 0                ! No constraint rhs vector.
      nrhs0  = 1
      nx0    = 0                ! No constant shift for x.
      lenx0  = 1
      nGobj0 = max( nGobj, 1 )

*     ------------------------------------------------------------------
*     Solve the problem.
*     ------------------------------------------------------------------
      nlocA = n + 1
      nb    = n + m
      call s5solv( iStart, sqHx, qpHx, sqprnt,
     &     m, n, nb, nnH0, nnH, nName, ngQP, nGobj0, nGobj,
     &     iObj, ObjAdd, ObjQP, ObjTru, nInf, sInf,
     &     ne, nlocA, locA, indA, Acol,
     &     iHvar, jHvar, lenH, neH, H,
     &     bl, bu, c, Names, 
     &     nrhs0, nrhs, rhs, lenx0, nx0, x0,
     &     hElast, hs, x, pi, rc, inform, nS, 
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      Obj    = ObjTru

*     Print times for all clocks (if lvlTim > 0).

      call s1time( 0, 2, iw, leniw, rw, lenrw )

  999 return

 1030 format(/ ' XXX Start parameter not recognized:  ', a)
 9000 format(  ' EXIT -- SQOPT character, integer and real work arrays',
     &         ' each must have at least 500 elements')

      end ! of sqopt

