*     ------------------------------------------------------------------
*     File hs118.f (Unix version)
*     This is a main program to test subroutine SQOPT, which is
*     part of SNOPT 5.3
*
*     04 Oct 1994: First   version.
*     20 Feb 1998: Current version.
*     ------------------------------------------------------------------
      program            HSmain
      implicit           double precision (a-h,o-z)

      parameter        ( maxm   = 10000,
     $                   maxn   = 15000,
     $                   maxne  = 30000 )

      character*8        Prob
      character*8        Names(maxn+maxm)
      integer*4          ha(maxne) , hElast(maxn+maxm), hs(maxn+maxm)
      integer            ka(maxn+1)
      double precision   a(maxne)  , bl(maxn+maxm)    , bu(maxn+maxm) , 
     $                   c(maxn)   , xs(maxn+maxm)    ,
     $                   pi(maxm)  , rc(maxn+maxm)

*     SQOPT workspace

      parameter          (  lenrw = 1000000)
      double precision   rw(lenrw)
      parameter          (  leniw =  500000) 
      integer            iw(leniw)
      parameter          (  lencw =   500) 
      character*8        cw(lencw)

      logical            byname
      character*20       lfile
      external           myHx

*     ------------------------------------------------------------------
*     Specify some of the SQOPT files.
*     iSpecs  is the Specs file   (0 if none).
*     iPrint  is the Print file   (0 if none).
*     iSumm   is the Summary file (0 if none).
*
*     nout    is an output file used here by main.

      iSpecs = 4
      iPrint = 15
      iSumm  = 6
      nout   = 6

      byname = .true.
 
      if ( byname ) then

*        Unix and DOS systems.  Open the Specs and print files.

         lfile = 'hs118.spc'
         open( iSpecs, file=lfile, status='OLD',     err=800 )

         lfile = 'hs118.out'
         open( iPrint, file=lfile, status='UNKNOWN', err=800 )
      end if

*     ------------------------------------------------------------------
*     First,  sqInit MUST be called to initialize optional parameters 
*     to their default values.
*     ------------------------------------------------------------------
      call sqInit( iPrint, iSumm,
     $             cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Read a Specs file (Optional).
*     ------------------------------------------------------------------
      call sqSpec( iSpecs, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )
      if (inform .ge. 2) then
         write(nout, *) 'iSpecs > 0 but no Specs file found'
         go to 990
      end if

*     ------------------------------------------------------------------
*     Define the problem.
*     (1) Compute l, u, and A so that the constraints are ranges of the
*         form  l <= Ax <= u.
*         Store l and u in bl(n+1:n+m) and bu(n+1:n+m).
*
*     (2) Set up the constants ObjAdd and c so that the explicit
*         objective is 
*             ObjAdd + c'*x + half x'*H*x
*         If necessary, include an additional linear objective terms
*         as row iObj of A. 
*     ------------------------------------------------------------------
      call hs118 ( maxm, maxn, maxne, 
     $             m, n, ne, nName, lenc, ncolH, 
     $             iObj, ObjAdd, Prob,
     $             a, ha, ka, bl, bu, c,
     $             Names, xs )

*     ------------------------------------------------------------------
*     Fix the column variables to be non-elastic and the row  variables 
*     to be elastic.
*     ------------------------------------------------------------------
      do 200, j = 1, n
         helast(j) = 0
  200 continue

      do 210, j = n+1, n+m
         helast(j) = 3
  210 continue

*     ------------------------------------------------------------------
*     Set the initial value and status of each variable.
*     For want of something better to do, make the variables xs(1:n)
*     temporarily fixed at their current values. 
*     The crash can set the rest.
*     ------------------------------------------------------------------
      do 220, j = 1, n
         hs(j) = 0
  220 continue

*     ------------------------------------------------------------------
*     Specify options that were not set in the Specs file.
*     i1 and i2 may refer to the Print and Summary file respectively.
*     Setting them to 0 suppresses printing.
*     ------------------------------------------------------------------
      maxS   = 10
      itnlim = 40
      i1     =  0
      i2     =  0
      call sqseti( 'Superbasics Limit ', maxS  , i1, i2, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )
      call sqseti( 'Iterations        ', itnlim, i1, i2, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Go for it, using a Cold start.
*     hs     need not be set if a basis file is to be input.
*            Otherwise, each hs(1:n) should be 0, 1, 2, 3, 4, or 5.
*            The values are used by the Crash procedure m2crsh
*            to choose an initial basis B.
*            If hs(j) = 0 or 1, column j is eligible for B.
*            If hs(j) = 2, column j is initially superbasic (not in B).
*            If hs(j) = 3, column j is eligible for B and is given
*                          preference over columns with hs(j) = 0 or 1.
*            If hs(j) = 4 or 5, column j is initially nonbasic.
*     ------------------------------------------------------------------
      call sqopt ( 'Cold', myHx, m, 
     $             n, ne, nName, lenc, ncolH,
     $             iObj, ObjAdd, Prob,
     $             a, ha, ka, bl, bu, c, Names,
     $             helast, hs, xs, pi, rc, 
     $             inform, mincw, miniw, minrw,
     $             nS, nInf, sInf, Obj,
     $             cw, lencw, iw, leniw, rw, lenrw, 
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .eq. 42 .or. inform .eq. 43 .or. inform .eq. 44) then
         write(nout, *) ' '
         write(nout, *) 'Estimate of required lencw:', mincw
         write(nout, *) 'Estimate of required leniw:', miniw
         write(nout, *) 'Estimate of required lenrw:', minrw
         go to 990
      end if

      write(nout, *) ' '
      write(nout, *) 'sqopt finished.'
      write(nout, *) 'inform =', inform
      write(nout, *) 'nInf   =', nInf
      write(nout, *) 'sInf   =', sInf
      write(nout, *) 'obj    =', obj
      if (inform .ge. 20) go to 910

*     ------------------------------------------------------------------
*     Alter some options and call sqopt again, testing the Warm start.
*     The following illustrates the use of sqset, sqseti and sqsetr
*     to set specific options.  We can ensure that all unspecified
*     options take default values by first calling
*     sqset ( 'Defaults', ... ).
*     Beware that certain parameters would then need to be redefined.
*     ------------------------------------------------------------------
      write(nout, *) ' '
      write(nout, *) 'Alter options and test Warm start:'

      inform  = 0
      itnlim  = 500
      BigBnd  =  1.0d+21
      call sqset ( '                  ',         iPrint, iSumm, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )
      call sqset ( 'Defaults          ',         iPrint, iSumm, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )
      call sqseti( 'Scale option      ',      0, iPrint, iSumm, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )
      call sqseti( 'Iterations        ', itnlim, iPrint, iSumm, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )
      call sqseti( 'Print level       ',     10, iPrint, iSumm, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )
      call sqsetr( 'Infinite Bound    ', BigBnd, iPrint, iSumm, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .gt. 0) then
         write(nout, *) 'NOTE: Some of the options were not recognized'
      end if

*     Test the Warm start.
*     hs(*) specifies a complete basis from the previous call.
*     A Warm start uses hs(*) directly, without calling Crash.
*     
*     Warm  starts are normally used after sqopt has solved a
*     problem with the SAME DIMENSIONS but perhaps altered data.
*     Here we have not altered the data, so very few iterations
*     should be required.

      call sqopt ( 'Warm', myHx, m, 
     $             n, ne, nName, lenc, ncolH,
     $             iObj, ObjAdd, Prob,
     $             a, ha, ka, bl, bu, c, Names, 
     $             helast, hs, xs, pi, rc, 
     $             inform, mincw, miniw, minrw,
     $             nS, nInf, sInf, Obj,
     $             cw, lencw, iw, leniw, rw, lenrw, 
     $             cw, lencw, iw, leniw, rw, lenrw )

      write(nout, *) ' '
      write(nout, *) 'sqopt finished again.'
      write(nout, *) 'inform =', inform
      write(nout, *) 'obj    =', obj
      if (inform .ge. 20) go to 910
      stop

*     ------------------------------------------------------------------
*     Error exit.
*     ------------------------------------------------------------------
  800 write(nout, 4000) 'Error while opening file', lfile
      stop

  910 write(nout, *) ' '
      write(nout, *) 'STOPPING because of error condition'
  990 stop

 4000 format(/  a, 2x, a  )

*     end of main program to test subroutine sqopt
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine myHx  ( ncolH, x, Hx, nState, 
     $                   cu, lencu, iu, leniu, ru, lenru )

      implicit           double precision (a-h,o-z)
      double precision   x(ncolH), Hx(ncolH)

      character*8        cu(lencu)
      integer            iu(leniu)
      double precision   ru(lenru)

*     ==================================================================
*     This is myHx   for problem Hock-Schittkowski 118.
*     ==================================================================

      iPrint = 15

*     ---------------------------------------
*     First entry.  Print something.
*     ---------------------------------------
      if (nState .eq. 1) then
         if (iPrint .gt. 0) write(iPrint, 1000) ncolH
      end if

*     -------------
*     Normal entry.
*     -------------
      do 150, i = 1, 5
         Hx(3*i-2) =  2.0d-4 * x(3*i-2)
         Hx(3*i-1) =  2.0d-4 * x(3*i-1)
         Hx(3*i)   =  3.0d-4 * x(3*i)
  150 continue

*     ------------
*     Last entry.
*     ------------
      if (nState .ge. 2) then
         if (iPrint .gt. 0) write(iPrint, 2000)
      end if
      return

 1000 format(// ' This is problem  HS 118.   ncolH =', i4)
 2000 format(// ' Finished         HS 118.')

*     end of myHx
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine hs118 ( maxm, maxn, maxne, 
     $                   m, n, ne, nName, lenc, ncolH,
     $                   iObj, ObjAdd, Prob,
     $                   a, ha, ka, bl, bu, c,
     $                   Names, xs )

      implicit           double precision (a-h,o-z)
      character*8        Prob
      character*8        Names(maxn+maxm)
      integer            ha(maxne)
      integer            ka(maxn+1)

      double precision   a(maxne)
      double precision   bl(maxn+maxm), bu(maxn+maxm), xs(maxn+maxm)
      double precision   c(maxn)

*     ==================================================================
*     hs118   sets the constraints and bounds for the 
*     quadratic program (Problem number 118 of Hock and Schittkowski).
*     Note that the linear objective term is the last row of A. 
*     ==================================================================
*     Give a name to the problem.

      Prob   = 'HS 118..'

      n      = 15
      m      = 18      ! Includes the objective row
      ne     = 54

      lenc   = 0
      ncolH  = 15
      nName  = 1

      BigBnd =  1.0d+20

*     ------------------------------------------------------------------
*     Assign the constraint nonzeros to a, column by column.
*     ha(i) gives the row index of element a(i).
*     ka(j) gives the index in a of the start of column j.
*     ------------------------------------------------------------------
*     Column 1.

      ka( 1) =  1

      ha( 1) =  1
      ha( 2) = 13 
      ha( 3) = 18 

      a( 1)  = -1.0d+0
      a( 2)  =  1.0d+0
      a( 3)  =  2.3d+0

*     Column 2.

      ka( 2) =  4

      ha( 4) =  5
      ha( 5) = 13
      ha( 6) = 18

      a( 4)  = -1.0d+0
      a( 5)  =  1.0d+0
      a( 6)  =  1.7d+0

*     Column 3.

      ka( 3) =  7

      ha( 7) =  9
      ha( 8) = 13
      ha( 9) = 18

      a( 7)  = -1.0d+0
      a( 8)  =  1.0d+0
      a( 9)  =  2.2D+0

*     Column 4.

      ka( 4) = 10

      ha(10) =  1
      ha(11) =  2
      ha(12) = 14
      ha(13) = 18

      a(10)  =  1.0d+0
      a(11)  = -1.0d+0
      a(12)  =  1.0d+0
      a(13)  =  2.3d+0

*     Column 5.

      ka( 5) = 14

      ha(14) =  5
      ha(15) =  6
      ha(16) = 14
      ha(17) = 18

      a(14)  =  1.0d+0
      a(15)  = -1.0d+0
      a(16)  =  1.0d+0
      a(17)  =  1.7d+0

*     Column 6.

      ka(6)  = 18

      ha(18) =  9
      ha(19) = 10
      ha(20) = 14
      ha(21) = 18

      a(18)  =  1.0d+0
      a(19)  = -1.0d+0
      a(20)  =  1.0d+0
      a(21)  =  2.2D+0

*     Column 7. 

      ka(7)  = 22

      ha(22) =  2
      ha(23) =  3
      ha(24) = 15
      ha(25) = 18

      a(22)  =  1.0d+0
      a(23)  = -1.0d+0
      a(24)  =  1.0d+0
      a(25)  =  2.3d+0

*     Column 8.

      ka(8)  = 26

      ha(26) =  6
      ha(27) =  7
      ha(28) = 15
      ha(29) = 18

      a(26)  =  1.0d+0
      a(27)  = -1.0d+0
      a(28)  =  1.0d+0
      a(29)  =  1.7d+0

*     Column 9.

      ka(9)  = 30

      ha(30) = 10
      ha(31) = 11
      ha(32) = 15
      ha(33) = 18

      a(30)  =  1.0d+0
      a(31)  = -1.0d+0
      a(32)  =  1.0d+0
      a(33)  =  2.2D+0

*     Column 10.

      ka(10) = 34

      ha(34) =  3
      ha(35) =  4
      ha(36) = 16
      ha(37) = 18

      a(34)  =  1.0d+0
      a(35)  = -1.0d+0
      a(36)  =  1.0d+0
      a(37)  =  2.3d+0

*     Column 11.

      ka(11) = 38

      ha(38) =  7
      ha(39) =  8
      ha(40) = 16
      ha(41) = 18

      a(38)  =  1.0d+0
      a(39)  = -1.0d+0
      a(40)  =  1.0d+0
      a(41)  =  1.7d+0

*     Column 12.

      ka(12) = 42

      ha(42) = 11
      ha(43) = 12
      ha(44) = 16
      ha(45) = 18

      a(42)  =  1.0d+0
      a(43)  = -1.0d+0
      a(44)  =  1.0d+0
      a(45)  =  2.2D+0

*     Column 13.

      ka(13) = 46

      ha(46) =  4
      ha(47) = 17
      ha(48) = 18

      a(46)  =  1.0d+0
      a(47)  =  1.0d+0
      a(48)  =  2.3d+0

*     Column 14.

      ka(14) = 49

      ha(49) =  8
      ha(50) = 17
      ha(51) = 18

      a(49)  =  1.0d+0
      a(50)  =  1.0d+0
      a(51)  =  1.7d+0

*     Column 15.

      ka(15) = 52

      ha(52) = 12
      ha(53) = 17
      ha(54) = 18

      a(52)  =  1.0d+0
      a(53)  =  1.0d+0
      a(54)  =  2.2D+0

*     ka(n+1)-1 points to the last nonzero of the nth column.

      ka(16) = 55

*     ------------------------------------------------------------------
*     Define l and u such that l <=  Ax  <= u.
*     Temporarily store  l  and  u  in  bl(n+1:n+m)  and  bu(n+1:n+m).
*     Set the default l and u.
*     ------------------------------------------------------------------
      do 100, i = 1, m
         j      = n + i
         bl(j)  = 0.0d+0
         bu(j)  = BigBnd
 100  continue

*     iObj   = 18  means the linear objective is row 18 in a(*).
*     The objective row is free.

      iObj   = 18
      bl(n+iObj) = -BigBnd

      bl(n+1)  =  -7.0d+0 
      bu(n+1)  =   6.0d+0 

      bl(n+2)  =  -7.0d+0
      bu(n+2)  =   6.0d+0 

      bl(n+3)  =  -7.0d+0
      bu(n+3)  =   6.0d+0 

      bl(n+4)  =  -7.0d+0
      bu(n+4)  =   6.0d+0 

      bl(n+5)  =  -7.0d+0    
      bu(n+5)  =   7.0d+0 

      bl(n+6)  =  -7.0d+0
      bu(n+6)  =   7.0d+0 

      bl(n+7)  =  -7.0d+0   
      bu(n+7)  =   7.0d+0 

      bl(n+8)  =  -7.0d+0
      bu(n+8)  =   7.0d+0 

      bl(n+9)  =  -7.0d+0
      bu(n+9)  =   6.0d+0 

      bl(n+10) =  -7.0d+0
      bu(n+10) =   6.0d+0

      bl(n+11) =  -7.0d+0
      bu(n+11) =   6.0d+0

      bl(n+12) =  -7.0d+0
      bu(n+12) =   6.0d+0

      bl(n+13) =  60.0d+0
      bl(n+14) =  50.0d+0
      bl(n+15) =  70.0d+0
      bl(n+16) =  85.0d+0
      bl(n+17) = 100.0d+0

*     ----------------------------------------------------------------
*     Set the default upper and lower bounds on the variables xs(1:n).
*     ----------------------------------------------------------------
      do 300, j = 1, n
         bl(j) = 0.0d+0
         bu(j) = BigBnd
  300 continue

      bl( 1) =   8.0d+0
      bu( 1) =  21.0d+0

      bl( 2) =  43.0d+0
      bu( 2) =  57.0d+0

      bl( 3) =   3.0d+0
      bu( 3) =  16.0d+0

      bu( 4) =  90.0d+0
      bu( 5) = 120.0d+0
      bu( 6) =  60.0d+0
      bu( 7) =  90.0d+0
      bu( 8) = 120.0d+0
      bu( 9) =  60.0d+0
      bu(10) =  90.0d+0
      bu(11) = 120.0d+0
      bu(12) =  60.0d+0
      bu(13) =  90.0d+0
      bu(14) = 120.0d+0
      bu(15) =  60.0d+0

*     ObjAdd = 0.0 means there is no constant to be added to the QP
*                  objective.

      ObjAdd =   0.0d+0

*     ------------------------------------------------------------------
*     Set the initial estimate of the solution.
*     ------------------------------------------------------------------
      xs( 1)  =  20.0d+0
      xs( 2)  =  55.0d+0
      xs( 3)  =  15.0d+0
      xs( 4)  =  20.0d+0
      xs( 5)  =  60.0d+0
      xs( 6)  =  20.0d+0
      xs( 7)  =  20.0d+0
      xs( 8)  =  60.0d+0
      xs( 9)  =  20.0d+0
      xs(10)  =  20.0d+0
      xs(11)  =  60.0d+0
      xs(12)  =  20.0d+0
      xs(13)  =  20.0d+0
      xs(14)  =  60.0d+0
      xs(15)  =  20.0d+0

*     end of hs118
      end

