*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
*     File npmain.f
*
*     Sample program for NPOPT Version 5.3-2  May 1998.
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
      program            npmain
      implicit           double precision (a-h,o-z)

*     ==================================================================
*     Set the declared array dimensions.
*     ldA    = the declared row dimension of  a.
*     ldcJ   = the declared row dimension of  cJac.
*     ldH    = the declared row dimension of  Hess.
*     maxn   = maximum no. of variables allowed for.
*     maxbnd = maximum no. of variables + linear & nonlinear constrnts.
*     liwork = the length of the integer work array.
*     lwork  = the length of the double precision work array.
*     ==================================================================
      parameter         (ldA    =  5, ldcJ   =   20, ldH   =   10,
     &                   maxn   =  9, liwork = 2500, lwork = 2500,
     &                   maxbnd =  maxn + ldA + ldcJ)

      integer            istate(maxbnd)
      integer            iwork(liwork)

      double precision   bigbnd
      character*20       lFile
      logical            byname, byunit

      double precision   A(ldA,maxn)
      double precision   bl(maxbnd), bu(maxbnd)
      double precision   c(ldcJ), cJac(ldcJ,maxn), clamda(maxbnd)
      double precision   objgrd(maxn), Hess(ldH,maxn), x(maxn)
      double precision   work(lwork)
      external           fnobj1, fnobj2, fncon1, fncon2

      parameter         (zero = 0.0d+0, one = 1.0d+0)

*     ------------------------------------------------------------------
*     Assign file numbers and open files by various means.
*     (Some systems don't need explicit open statements.)
*     iOptns = unit number for the Options file.
*     iPrint = unit number for the Print file.
*     iSumm  = unit number for the Summary file.
*     ------------------------------------------------------------------
      iOptns = 4
      iPrint = 15
      iSumm  = 6
      byname = .true.
      byunit = .false.
 
      if ( byname ) then
         lFile = 'npmain.spc'
         open( iOptns, file=lFile, status='OLD',     err=800 )

         lFile = 'npmain.out'
         open( iPrint, file=lFile, status='UNKNOWN', err=800 )

      else if ( byunit ) then
         lUnit = iOptns
         open( lUnit, status='OLD',     err=900 )

         lUnit = iPrint
         open( lUnit, status='UNKNOWN', err=900 )
      end if

*     =============================================================
*     Set the actual problem dimensions.
*     n      = the number of variables.
*     nclin  = the number of general linear constraints (may be 0).
*     ncnln  = the number of nonlinear constraints (may be 0).
*     =============================================================
      n      = 9
      nclin  = 4
      ncnln  = 14
      nbnd   = n + nclin + ncnln

*     ------------------------------------------------------------------
*     Assign the data arrays.
*     iPrint = the unit number for printing.
*     iOptns = the unit number for reading the options file.
*     bounds  .ge.    bigbnd  will be treated as plus  infinity.
*     bounds  .le.  - bigbnd  will be treated as minus infinity.
*     A      = the linear constraint matrix.
*     bl     = the lower bounds on  x,  A'x  and  c(x).
*     bu     = the upper bounds on  x,  A'x  and  c(x).
*     x      = the initial estimate of the solution.
*     ------------------------------------------------------------------

*     Set the matrix  A.

      do 40, j = 1, n
         do 30,  i = 1, nclin
            A(i,j) = zero
   30    continue
   40 continue
      A(1,1) = -one
      A(1,2) =  one
      A(2,2) = -one
      A(2,3) =  one
      A(3,3) =  one
      A(3,4) = -one
      A(4,4) =  one                      
      A(4,5) = -one

*     Set the bounds.

      bigbnd =  1.0d+21

      do 50, j =  1, nbnd
         bl(j) = -bigbnd
         bu(j) =  bigbnd
   50 continue
      bl(1)  =  zero
      bl(3)  = -one
      bl(5)  =  zero
      bl(6)  =  zero
      bl(7)  =  zero

      bu(3)  =  one
      bu(8)  =  zero
      bu(9)  =  zero

*     Set lower bounds of zero for all four linear constraints.

      do 60, j =  n+1, n+nclin
         bl(j) =  zero
   60 continue

*     Set upper bounds of one for all 14 nonlinear constraints.

      do 70, j =  n+nclin+1, nbnd
         bu(j) =  one
   70 continue

*     Set the initial estimate of  x.

      x(1)   =  .1d+0
      x(2)   =  .125d+0
      x(3)   =  .666666d+0
      x(4)   =  .142857d+0
      x(5)   =  .111111d+0
      x(6)   =  .2d+0
      x(7)   =  .25d+0
      x(8)   = -.2d+0
      x(9)   = -.25d+0

*     ------------------------------------------------------------------
*     First,  npInit MUST be called to initialize optional parameters 
*     to their default values.
*     The Print file   will be on unit iPrint.
*     The Summary file will be on unit iSumm (typically the screen).
*     ------------------------------------------------------------------
      call npInit( iPrint, iSumm, iwork, liwork, work, lwork )

*     ------------------------------------------------------------------
*     Read a Specs file (Optional).
*     ------------------------------------------------------------------
      call npSpec( iOptns, inform, iwork, liwork, work, lwork )

      if (inform .ne. 0) then
         write(iPrint, 3000) inform
         stop
      end if

*     ------------------------------------------------------------------
*     Set a few options in-line.
*     iP and iS may refer to the Print and Summary file respectively.
*     Setting them to 0 suppresses printing.
*     ------------------------------------------------------------------
      iP     =  0
      iS     =  0
      call npsetr( 'Infinite Bound =', bigbnd, iP, iS, inform,
     &             iwork, liwork, work, lwork )

*     ------------------------------------------------------------------
*     Solve the problem.
*     ------------------------------------------------------------------
      call npopt ( n, nclin, ncnln, ldA, ldcJ, ldH,
     &             A, bl, bu,
     &             fncon1, fnobj1,
     &             inform, iter, istate,
     &             c, cJac, clamda, objf, objgrd, Hess, x,
     &             iwork, liwork, work, lwork )

      if (inform .gt. 0) go to 999

*     ------------------------------------------------------------------
*     The following is for illustrative purposes only.
*     A second run solves the same problem,  but defines the objective
*     and constraints via the subroutines fnobj2 and fncon2.  Some
*     objective derivatives and the constant Jacobian elements are not
*     supplied.
*     We do a warm start using
*              istate    (the working set)
*              clamda    (the Lagrange multipliers)
*              Hess      (the Hessian approximation)
*     from the previous run, but with a slightly perturbed starting
*     point.  
*     ------------------------------------------------------------------
      do 100, j = 1, n
         x(j)   = x(j) + 0.01d+0
  100 continue

      call npset ( '                     ',     iP    , iS   , inform,
     &                                      iwork, liwork, work, lwork )
      call npset ( 'Defaults             ',     iP    , iS   , inform,
     &                                      iwork, liwork, work, lwork )
      call npseti( 'Derivative Level     ',  0, iP    , iS   , inform,
     &                                      iwork, liwork, work, lwork )
      call npset ( 'Verify             no',     iP    , iS   , inform,
     &                                      iwork, liwork, work, lwork )
      call npset ( 'Warm Start           ',     iP    , iS   , inform,
     &                                      iwork, liwork, work, lwork )
      call npseti( 'Major Iterations     ', 20, iP    , iS   , inform,
     &                                      iwork, liwork, work, lwork )

*     ------------------------------------------------------------------
*     Go for it...
*     ------------------------------------------------------------------
      call npopt ( n, nclin, ncnln, ldA, ldcJ, ldH,
     &             A, bl, bu,
     &             fncon2, fnobj2,
     &             inform, iter, istate,
     &             c, cJac, clamda, objf, objgrd, Hess, x,
     &             iwork, liwork, work, lwork )

      if (inform .gt. 0) go to 999
      stop

*     Error conditions.

  800 write(iSumm , 4000) 'Error while opening file', lfile
      stop

  900 write(iSumm , 4010) 'Error while opening unit', lunit
      stop
 
  999 write(iPrint, 3010) inform
      stop

 3000 format(/ ' npSpec terminated with  inform =', i3)
 3010 format(/ ' npopt  terminated with  inform =', i3)
 4000 format(/  a, 2x, a  )
 4010 format(/  a, 2x, i6 )

*     end of the example program for npopt
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine fnobj1( mode, n, x, objf, objgrd, nState )

      implicit           double precision (a-h,o-z)
      double precision   x(n), objgrd(n)

*     ==================================================================
*     fnobj1  computes the value and first derivatives of the nonlinear
*     objective function.
*     ==================================================================
      objf   = - x(2)*x(6) + x(1)*x(7) - x(3)*x(7) - x(5)*x(8)
     &         + x(4)*x(9) + x(3)*x(8)

      objgrd(1) =   x(7)
      objgrd(2) = - x(6)
      objgrd(3) = - x(7) + x(8)
      objgrd(4) =   x(9)
      objgrd(5) = - x(8)
      objgrd(6) = - x(2)
      objgrd(7) = - x(3) + x(1)
      objgrd(8) = - x(5) + x(3)
      objgrd(9) =   x(4)

*     end of fnobj1
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine fncon1( mode, ncnln, n, ldcJ,
     &                   needc, x, c, cJac, nState )

      implicit           double precision (a-h,o-z)
      integer            needc(*)
      double precision   x(n), c(*), cJac(ldcJ,*)

*     ==================================================================
*     fncon1  computes the values and first derivatives of the nonlinear
*     constraints.
*
*     The zero elements of Jacobian matrix are set only once.  This
*     occurs during the first call to fncon1  (nState = 1).
*     ==================================================================
      parameter         (zero = 0.0d+0, two = 2.0d+0)
          
      if (nState .eq. 1) then

*        First call to fncon1.  set all jacobian elements to zero.
*        Note: this will only work with `derivative level = 3'.

         do 120, j = 1, n
            do 110, i = 1, ncnln
               cJac(i,j) = zero
  110       continue
  120    continue
      end if

      if (needc(1) .gt. 0) then
         c(1)       =   x(1)**2  +  x(6)**2
         cJac(1,1)  =   two*x(1)
         cJac(1,6)  =   two*x(6)
      end if

      if (needc(2) .gt. 0) then
         c(2)       =   (x(2) - x(1))**2  +  (x(7) - x(6))**2
         cJac(2,1)  = - two*(x(2) - x(1))
         cJac(2,2)  =   two*(x(2) - x(1))
         cJac(2,6)  = - two*(x(7) - x(6))
         cJac(2,7)  =   two*(x(7) - x(6))
      end if

      if (needc(3) .gt. 0) then
         c(3)       =   (x(3) - x(1))**2  +  x(6)**2
         cJac(3,1)  = - two*(x(3) - x(1))
         cJac(3,3)  =   two*(x(3) - x(1))
         cJac(3,6)  =   two*x(6)
      end if

      if (needc(4) .gt. 0) then
         c(4)       =   (x(1) - x(4))**2  +  (x(6) - x(8))**2
         cJac(4,1)  =   two*(x(1) - x(4))
         cJac(4,4)  = - two*(x(1) - x(4))
         cJac(4,6)  =   two*(x(6) - x(8))
         cJac(4,8)  = - two*(x(6) - x(8))
      end if

      if (needc(5) .gt. 0) then
         c(5)       =   (x(1) - x(5))**2  +  (x(6) - x(9))**2
         cJac(5,1)  =   two*(x(1) - x(5))
         cJac(5,5)  = - two*(x(1) - x(5))
         cJac(5,6)  =   two*(x(6) - x(9))
         cJac(5,9)  = - two*(x(6) - x(9))
      end if

      if (needc(6) .gt. 0) then
         c(6)       =   x(2)**2  +  x(7)**2
         cJac(6,2)  =   two*x(2)
         cJac(6,7)  =   two*x(7)
      end if

      if (needc(7) .gt. 0) then
         c(7)       =   (x(3) - x(2))**2  +  x(7)**2
         cJac(7,2)  = - two*(x(3) - x(2))
         cJac(7,3)  =   two*(x(3) - x(2))
         cJac(7,7)  =   two*x(7)
      end if

      if (needc(8) .gt. 0) then
         c(8)       =   (x(4) - x(2))**2  +  (x(8) - x(7))**2
         cJac(8,2)  = - two*(x(4) - x(2))
         cJac(8,4)  =   two*(x(4) - x(2))
         cJac(8,7)  = - two*(x(8) - x(7))
         cJac(8,8)  =   two*(x(8) - x(7))
      end if

      if (needc(9) .gt. 0) then
         c(9)       =   (x(2) - x(5))**2  +  (x(7) - x(9))**2
         cJac(9,2)  =   two*(x(2) - x(5))
         cJac(9,5)  = - two*(x(2) - x(5))
         cJac(9,7)  =   two*(x(7) - x(9))
         cJac(9,9)  = - two*(x(7) - x(9))
      end if

      if (needc(10) .gt. 0) then
         c(10)      =   (x(4) - x(3))**2  +  x(8)**2
         cJac(10,3) = - two*(x(4) - x(3))
         cJac(10,4) =   two*(x(4) - x(3))
         cJac(10,8) =   two*x(8)
      end if

      if (needc(11) .gt. 0) then
         c(11)      =   (x(5) - x(3))**2  +  x(9)**2
         cJac(11,3) = - two*(x(5) - x(3))
         cJac(11,5) =   two*(x(5) - x(3))
         cJac(11,9) =   two*x(9)
      end if

      if (needc(12) .gt. 0) then
         c(12)      =   x(4)**2  +  x(8)**2
         cJac(12,4) =   two*x(4)
         cJac(12,8) =   two*x(8)
      end if

      if (needc(13) .gt. 0) then
         c(13)      =   (x(4) - x(5))**2  +  (x(9) - x(8))**2
         cJac(13,4) =   two*(x(4) - x(5))
         cJac(13,5) = - two*(x(4) - x(5))
         cJac(13,8) = - two*(x(9) - x(8))
         cJac(13,9) =   two*(x(9) - x(8))
      end if

      if (needc(14) .gt. 0) then
         c(14)      =   x(5)**2  +  x(9)**2
         cJac(14,5) =   two*x(5)
         cJac(14,9) =   two*x(9)
      end if

*     end of fncon1
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine fnobj2( mode, n, x, objf, objgrd, nState )
      implicit           double precision (a-h,o-z)
      double precision   x(n), objgrd(n)

*     ==================================================================
*     fnobj2  computes the value and some first derivatives of the
*     nonlinear objective function.
*     ==================================================================
      objf   = - x(2)*x(6) + x(1)*x(7) - x(3)*x(7) - x(5)*x(8)
     &         + x(4)*x(9) + x(3)*x(8)

      objgrd(3) = - x(7) + x(8)
      objgrd(7) = - x(3) + x(1)
      objgrd(8) = - x(5) + x(3)

*     end of fnobj2
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine fncon2( mode, ncnln, n, ldcJ,
     &                   needc, x, c, cJac, nState )

      implicit           double precision (a-h,o-z)
      integer            needc(*)
      double precision   x(n), c(*), cJac(ldcJ,*)

*     ==================================================================
*     fncon2  computes the values and the non-constant derivatives of
*     the nonlinear constraints.
*     ==================================================================
      parameter         (two = 2.0d+0)

      if (needc(1) .gt. 0) then
         c(1)       =   x(1)**2  +  x(6)**2
         cJac(1,1)  =   two*x(1)
         cJac(1,6)  =   two*x(6)
      end if

      if (needc(2) .gt. 0) then
         c(2)       =   (x(2) - x(1))**2  +  (x(7) - x(6))**2
         cJac(2,1)  = - two*(x(2) - x(1))
         cJac(2,2)  =   two*(x(2) - x(1))
         cJac(2,6)  = - two*(x(7) - x(6))
         cJac(2,7)  =   two*(x(7) - x(6))
      end if

      if (needc(3) .gt. 0) then
         c(3)       =   (x(3) - x(1))**2  +  x(6)**2
         cJac(3,1)  = - two*(x(3) - x(1))
         cJac(3,3)  =   two*(x(3) - x(1))
         cJac(3,6)  =   two*x(6)
      end if

      if (needc(4) .gt. 0) then
         c(4)       =   (x(1) - x(4))**2  +  (x(6) - x(8))**2
         cJac(4,1)  =   two*(x(1) - x(4))
         cJac(4,4)  = - two*(x(1) - x(4))
         cJac(4,6)  =   two*(x(6) - x(8))
         cJac(4,8)  = - two*(x(6) - x(8))
      end if

      if (needc(5) .gt. 0) then
         c(5)       =   (x(1) - x(5))**2  +  (x(6) - x(9))**2
         cJac(5,1)  =   two*(x(1) - x(5))
         cJac(5,5)  = - two*(x(1) - x(5))
         cJac(5,6)  =   two*(x(6) - x(9))
         cJac(5,9)  = - two*(x(6) - x(9))
      end if

      if (needc(6) .gt. 0) then
         c(6)       =   x(2)**2  +  x(7)**2
         cJac(6,2)  =   two*x(2)
         cJac(6,7)  =   two*x(7)
      end if

      if (needc(7) .gt. 0) then
         c(7)       =   (x(3) - x(2))**2  +  x(7)**2
         cJac(7,2)  = - two*(x(3) - x(2))
         cJac(7,3)  =   two*(x(3) - x(2))
         cJac(7,7)  =   two*x(7)
      end if

      if (needc(8) .gt. 0) then
         c(8)       =   (x(4) - x(2))**2  +  (x(8) - x(7))**2
         cJac(8,2)  = - two*(x(4) - x(2))
         cJac(8,4)  =   two*(x(4) - x(2))
         cJac(8,7)  = - two*(x(8) - x(7))
         cJac(8,8)  =   two*(x(8) - x(7))
      end if

      if (needc(9) .gt. 0) then
         c(9)       =   (x(2) - x(5))**2  +  (x(7) - x(9))**2
         cJac(9,2)  =   two*(x(2) - x(5))
         cJac(9,5)  = - two*(x(2) - x(5))
         cJac(9,7)  =   two*(x(7) - x(9))
         cJac(9,9)  = - two*(x(7) - x(9))
      end if

      if (needc(10) .gt. 0) then
         c(10)      =   (x(4) - x(3))**2  +  x(8)**2
         cJac(10,3) = - two*(x(4) - x(3))
         cJac(10,4) =   two*(x(4) - x(3))
         cJac(10,8) =   two*x(8)
      end if

      if (needc(11) .gt. 0) then
         c(11)      =   (x(5) - x(3))**2  +  x(9)**2
         cJac(11,3) = - two*(x(5) - x(3))
         cJac(11,5) =   two*(x(5) - x(3))
         cJac(11,9) =   two*x(9)
      end if

      if (needc(12) .gt. 0) then
         c(12)      =   x(4)**2  +  x(8)**2
         cJac(12,4) =   two*x(4)
         cJac(12,8) =   two*x(8)
      end if
                   
      if (needc(13) .gt. 0) then
         c(13)      =   (x(4) - x(5))**2  +  (x(9) - x(8))**2
         cJac(13,4) =   two*(x(4) - x(5))
         cJac(13,5) = - two*(x(4) - x(5))
         cJac(13,8) = - two*(x(9) - x(8))
         cJac(13,9) =   two*(x(9) - x(8))
      end if

      if (needc(14) .gt. 0) then
         c(14)      =   x(5)**2  +  x(9)**2
         cJac(14,5) =   two*x(5)
         cJac(14,9) =   two*x(9)
      end if

*     end of fncon2
      end
