*     ------------------------------------------------------------------
*     File slmain.f (Unix version)
*     This is a simple example of a call to subroutine SQOPT, which is
*     part of the SNOPT package.
*
*     04 Oct 1994: First   version.
*     12 Feb 1998: Current version.
*     ------------------------------------------------------------------
      program            slmain
      implicit           double precision (a-h,o-z)

      parameter        ( maxm   = 1000,
     $                   maxn   = 1500,
     $                   maxne  = 3000 )

      character*8        Prob
      character*8        Names(maxm+maxn)
      integer*4          ha(maxne) , hElast(maxn+maxm), hs(maxn+maxm)
      integer            ka(maxn+1)
      double precision   a(maxne)  , bl(maxn+maxm)    , bu(maxn+maxm) , 
     $                   c(maxn)   , xs(maxn+maxm)    ,
     $                   pi(maxm)  , rc(maxn+maxm)

*     SQOPT workspace

      parameter          (  lenrw = 10000)
      double precision   rw(lenrw)
      parameter          (  leniw =  5000) 
      integer            iw(leniw)
      parameter          (  lencw =   500) 
      character*8        cw(lencw)

      logical            byname
      character*20       lfile
      external           nullHx
*     ------------------------------------------------------------------
*     Specify some of the SNOPT files.
*     iSpecs  is the Specs file   (0 if none).
*     iPrint  is the Print file   (0 if none).
*     iSumm   is the Summary file (0 if none).
*
*     nout    is an output file used here by main.

      iSpecs = 4
      iPrint = 15
      iSumm  = 6
      nout   = 6

      byname = .true.
 
      if ( byname ) then

*        Unix and DOS systems.  Open the Specs and print files.

         lfile = 'slmain.spc'
         open( iSpecs, file=lfile, status='OLD',     err=800 )

         lfile = 'slmain.out'
         open( iPrint, file=lfile, status='UNKNOWN', err=800 )
      end if

*     ------------------------------------------------------------------
*     First,  snInit MUST be called to initialize optional parameters 
*     to their default values.
*     ------------------------------------------------------------------
      call sqInit( iPrint, iSumm,
     $             cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Read a Specs file (Optional).
*     ------------------------------------------------------------------
      call sqSpec( iSpecs, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .ge. 2) then
         write(nout, *) 'iSpecs > 0 but no Specs file found'
         go to 990
      end if

      call sqdat1( maxm, maxn, maxne, 
     $             m, n, ne, nName, lenc, ncolH,
     $             iObj, ObjAdd, Prob,
     $             a, ha, ka, bl, bu, c,
     $             Names, xs )

*     ------------------------------------------------------------------
*     Fix the column variables to be non-elastic and the row  variables 
*     to be elastic.
*     ------------------------------------------------------------------
      do 100, j = 1, n
         hElast(j) = 0
  100 continue

      do 110, j = n+1, n+m
         hElast(j) = 3
  110 continue

*     ------------------------------------------------------------------
*     Set the initial value and status of each variable.
*     For want of something better to do, make the variables xs(1:n)
*     temporarily fixed at their current values. 
*     The crash can set the rest.
*     ------------------------------------------------------------------
      do 120, j = 1, n
         hs(j) = 0
  120 continue

*     ------------------------------------------------------------------
*     Specify options that were not set in the Specs file.
*     i1 and i2 may refer to the Print and Summary file respectively.
*     Setting them to 0 suppresses printing.
*     ------------------------------------------------------------------
      itnlim = 40
      i1     =  0
      i2     =  0
      call sqseti( 'Iterations        ', itnlim, i1, i2, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Go for it, using a Cold start.
*     hs     need not be set if a basis file is to be input.
*            Otherwise, each hs(1:n) should be 0, 1, 2, 3, 4, or 5.
*            The values are used by the Crash procedure s2crsh
*            to choose an initial basis B.
*            If hs(j) = 0 or 1, column j is eligible for B.
*            If hs(j) = 2, column j is initially superbasic (not in B).
*            If hs(j) = 3, column j is eligible for B and is given
*                          preference over columns with hs(j) = 0 or 1.
*            If hs(j) = 4 or 5, column j is initially nonbasic.
*
*     No user-workspace, so we use cw, iw, rw.
*     ------------------------------------------------------------------
      call sqopt ( 'Cold', nullHx, m, 
     $             n, ne, nName, lenc, ncolH,
     $             iObj, ObjAdd, Prob,
     $             a, ha, ka, bl, bu, c, Names,
     $             hElast, hs, xs, pi, rc, 
     $             inform, mincw, miniw, minrw,
     $             nS, nInf, sInf, Obj,
     $             cw, lencw, iw, leniw, rw, lenrw,
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .eq. 42) then
         write(nout, *) ' '
         write(nout, *) 'Estimate of required lenrw:', minrw
         go to 990
      end if

      write(nout, *) ' '
      write(nout, *) 'sqopt finished.'
      write(nout, *) 'inform =', inform
      write(nout, *) 'nInf   =', nInf
      write(nout, *) 'sInf   =', sInf
      write(nout, *) 'obj    =', obj
      if (inform .ge. 20) go to 910

*     ------------------------------------------------------------------
*     Solve the same problem defined with different data.
*     Since the dimensions are slightly different, use a Cold start.
*     ------------------------------------------------------------------
      call sqdat2( maxm, maxn, maxne, 
     $             m, n, ne, nName, lenc, ncolH,
     $             iObj, ObjAdd, Prob,
     $             a, ha, ka, bl, bu, c,
     $             Names, xs )

*     ------------------------------------------------------------------
*     Set the initial status of each variable.
*     For fun, we use the hs values from the previous run.
*     The crash can set the rest.
*     ------------------------------------------------------------------
      call sqopt ( 'Cold', nullHx, m, 
     $             n, ne, nName, lenc, ncolH,
     $             iObj, ObjAdd, Prob,
     $             a, ha, ka, bl, bu, c, Names,
     $             hElast, hs, xs, pi, rc, 
     $             inform, mincw, miniw, minrw,
     $             nS, nInf, sInf, Obj,
     $             cw, lencw, iw, leniw, rw, lenrw,
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .eq. 42 .or. inform .eq. 43 .or. inform .eq. 44) then
         write(nout, *) ' '
         write(nout, *) 'Estimate of required lencw:', mincw
         write(nout, *) 'Estimate of required leniw:', miniw
         write(nout, *) 'Estimate of required lenrw:', minrw
         go to 990
      end if

      write(nout, *) ' '
      write(nout, *) 'sqopt finished.'
      write(nout, *) 'inform =', inform
      write(nout, *) 'nInf   =', nInf
      write(nout, *) 'sInf   =', sInf
      write(nout, *) 'obj    =', obj
      if (inform .ge. 20) go to 910

*     ------------------------------------------------------------------
*     Alter some options and call sqopt again, testing the Warm start.
*     The following illustrates the use of snset, snseti and snsetr
*     to set specific options.  If necessary, we could ensure that
*     all unspecified options take default values
*     by first calling snset ( 'Defaults', ... ).
*     Beware that certain parameters would then need to be redefined.
*     ------------------------------------------------------------------
      write(nout, *) ' '
      write(nout, *) 'Alter options and test Warm start:'

      inform = 0
      itnlim = 500
      call sqset ( '                  ',         iPrint, iSumm, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )
      call sqset ( 'Print  level     0',         iPrint, iSumm, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )
      call sqset ( 'Scale option     0',         iPrint, iSumm, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )
      call sqseti( 'Iterations        ', itnlim, iPrint, iSumm, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .gt. 0) then
         write(nout, *) 'NOTE: Some of the options were not recognized'
      end if

*     Test the Warm start.
*     hs(*) specifies a complete basis from the previous call.
*     A Warm start uses hs(*) directly, without calling Crash.
*     
*     Warm starts are normally used after sqopt has solved a
*     problem with the SAME DIMENSIONS but perhaps altered data.
*     Here we have not altered the data, so very few iterations
*     should be required.

      call sqopt ( 'Warm', nullHx, m, 
     $             n, ne, nName, lenc, ncolH,
     $             iObj, ObjAdd, Prob,
     $             a, ha, ka, bl, bu, c, Names, 
     $             hElast, hs, xs, pi, rc, 
     $             inform, mincw, miniw, minrw,
     $             nS, nInf, sInf, Obj,
     $             cw, lencw, iw, leniw, rw, lenrw,
     $             cw, lencw, iw, leniw, rw, lenrw )

      write(nout, *) ' '
      write(nout, *) 'sqopt finished again.'
      write(nout, *) 'inform =', inform
      write(nout, *) 'obj    =', obj
      if (inform .ge. 20) go to 910
      stop

*     ------------------------------------------------------------------
*     Error exit.
*     ------------------------------------------------------------------
  800 write(nout, 4000) 'Error while opening file', lfile
      stop

  910 write(nout, *) ' '
      write(nout, *) 'STOPPING because of error condition'

  990 stop

 4000 format(/  a, 2x, a  )

*     end of main program to test subroutine sqopt
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqdat1( maxm, maxn, maxne, 
     $                   m, n, ne, nName, lenc, ncolH,
     $                   iObj, ObjAdd, Prob,
     $                   a, ha, ka, bl, bu, c,
     $                   Names, xs )

      implicit           double precision (a-h,o-z)
      character*8        Prob
      character*8        Names(maxn+maxm)
      integer            ha(maxne)
      integer            ka(maxn+1)

      double precision   a(maxne)
      double precision   bl(maxn+maxm), bu(maxn+maxm), xs(maxn+maxm)
      double precision   c(maxn)

*     ------------------------------------------------------------------
*     Define the problem.
*     (1) Compute l, u, and A so that the constraints are ranges of the
*         form  l <= Ax <= u.
*         Store l and u in bl(n+1:n+m) and bu(n+1:n+m).
*
*     (2) Set up the constants ObjAdd and c so that the explicit
*         objective is 
*             ObjAdd + c'*x + half*x'*H*x
*         If necessary, include an additional linear objective terms
*         as row iObj of A. 
*     ------------------------------------------------------------------
      parameter         (zero   =0.0d+0)

*     Name the Problem.

      Prob = 'Diet 1..'

*     ------------------------------------------------------------------
*     This is the Diet problem of Chvatal, 1983.
*     Assign the constraint nonzeros to a, column by column.
*     ha(i) gives the row index of element a(i).
*     ka(j) gives the index in a of the start of column j.
*     ------------------------------------------------------------------
*           ( 110  205  160  160  420  260 )
*     A  =  (   4   32   13    8    4   14 )
*           (   2   12   54  285   22   80 )
*           (   3   24   13    9   20   19 )
*

      n     =  6
      m     =  4     ! Includes the objective row
      ne    = 24     ! n*m for a dense A.

      nName =  1

      lenc  =  0
      ncolH =  0

*     Column 1.

      ka( 1) =  1

      ha( 1) =  1
      ha( 2) =  2 
      ha( 3) =  3 
      ha( 4) =  4 

      a( 1)  =   110.0d+0
      a( 2)  =     4.0d+0
      a( 3)  =     2.0d+0
      a( 4)  =     3.0d+0

*     Column 2.

      ka( 2) =  5

      ha( 5) =  1
      ha( 6) =  2
      ha( 7) =  3
      ha( 8) =  4 

      a( 5)  =   205.0d+0
      a( 6)  =    32.0d+0
      a( 7)  =    12.0d+0
      a( 8)  =    24.0d+0

*     Column 3.

      ka( 3) =  9

      ha( 9) =  1
      ha(10) =  2
      ha(11) =  3
      ha(12) =  4 

      a( 9)  =   160.0d+0
      a(10)  =    13.0d+0
      a(11)  =    54.0d+0
      a(12)  =    13.0d+0

*     Column 4.

      ka( 4) = 13

      ha(13) =  1
      ha(14) =  2
      ha(15) =  3
      ha(16) =  4 

      a(13)  =   160.0d+0
      a(14)  =     8.0d+0
      a(15)  =   285.0d+0
      a(16)  =     9.0d+0

*     Column 5.

      ka( 5) = 17

      ha(17) =  1
      ha(18) =  2
      ha(19) =  3
      ha(20) =  4 

      a(17)  =   420.0d+0
      a(18)  =     4.0d+0
      a(19)  =    22.0d+0
      a(20)  =    20.0d+0

*     Column 6.

      ka(6)  = 21

      ha(21) =  1
      ha(22) =  2
      ha(23) =  3
      ha(24) =  4 

      a(21)  =   260.0d+0
      a(22)  =    14.0d+0
      a(23)  =    80.0d+0
      a(24)  =    19.0d+0

*     Don't forget to finish off  ka(n+1) = ne+1
*     This is crucial.

      ka( 7) = 25

*     ------------------------------------------------------------------
*     Set the upper and lower bounds on the variables
*     ------------------------------------------------------------------
      do 100, j = 1, n
         bl(j)  = zero
  100 continue

      bu(1)  =     4.0d+0
      bu(2)  =     3.0d+0
      bu(3)  =     2.0d+0
      bu(4)  =     8.0d+0
      bu(5)  =     2.0d+0
      bu(6)  =     2.0d+0

*     ------------------------------------------------------------------
*     Set the upper and lower bounds on  Ax.
*     The last row is free (i.e., infinite upper and lower bounds).
*     ------------------------------------------------------------------
      plInfy =  1.0d+20

      bl( 7) =  2000.0d+0
      bl( 8) =    55.0d+0
      bl( 9) =   800.0d+0

      do 110, i = 1, m
         j      = n + i
         bu(j)  = plInfy
  110 continue

      bl(10) = - plInfy
      bu(10) =   plInfy

      iObj   = 4
      ObjAdd = zero

*     ------------------------------------------------------------------
*     Set the initial estimate of the solution.
*     ------------------------------------------------------------------
      xs(1) = 0.0d+0
      xs(2) = 0.0d+0
      xs(3) = 0.0d+0
      xs(4) = 0.0d+0
      xs(5) = 0.0d+0
      xs(6) = 0.0d+0

*     end of sqdat1
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqdat2( maxm, maxn, maxne, 
     $                   m, n, ne, nName, lenc, ncolH,
     $                   iObj, ObjAdd, Prob,
     $                   a, ha, ka, bl, bu, c,
     $                   Names, xs )

      implicit           double precision (a-h,o-z)
      character*8        Prob
      character*8        Names(maxn+maxm)
      integer            ha(maxne)
      integer            ka(maxn+1)

      double precision   a(maxne)
      double precision   bl(maxn+maxm), bu(maxn+maxm), xs(maxn+maxm)
      double precision   c(maxn)

*     ------------------------------------------------------------------
*     Diet problem with explicit linear objective.
*
*     Define the problem.
*     (1) Compute l, u, and A so that the constraints are ranges of the
*         form  l <= Ax <= u.
*         Store l and u in bl(n+1:n+m) and bu(n+1:n+m).
*
*     (2) Set up the constants ObjAdd and c so that the explicit
*         objective is 
*             ObjAdd + c'*x + half*x'*H*x
*         If necessary, include an additional linear objective terms
*         as row iObj of A. 
*     ------------------------------------------------------------------
      parameter         (zero   =0.0d+0)

*     Name the Problem.

      Prob = 'Diet 2..'

*     ------------------------------------------------------------------
*     This is the Diet problem of Chvatal, 1983.
*     Assign the constraint nonzeros to a, column by column.
*     ha(i) gives the row index of element a(i).
*     ka(j) gives the index in a of the start of column j.
*     ------------------------------------------------------------------
*           ( 110  205  160  160  420  260 )
*     A  =  (   4   32   13    8    4   14 )
*           (   2   12   54  285   22   80 )
*           (   3   24   13    9   20   19 )
*
*     c' =  (   3   24   13    9   20   19 )
*

      n     =  6
      m     =  4     ! Includes the objective row
      ne    = 24     ! n*m for a dense A.

      nName =  1

      lenc  =  6 
      ncolH =  0

*     Column 1.

      ka( 1) =  1

      ha( 1) =  1
      ha( 2) =  2 
      ha( 3) =  3 
      ha( 4) =  4 

      a( 1)  =   110.0d+0
      a( 2)  =     4.0d+0
      a( 3)  =     2.0d+0
      a( 4)  =     3.0d+0

*     Column 2.

      ka( 2) =  5

      ha( 5) =  1
      ha( 6) =  2
      ha( 7) =  3
      ha( 8) =  4 

      a( 5)  =   205.0d+0
      a( 6)  =    32.0d+0
      a( 7)  =    12.0d+0
      a( 8)  =    24.0d+0

*     Column 3.

      ka( 3) =  9

      ha( 9) =  1
      ha(10) =  2
      ha(11) =  3
      ha(12) =  4 

      a( 9)  =   160.0d+0
      a(10)  =    13.0d+0
      a(11)  =    54.0d+0
      a(12)  =    13.0d+0

*     Column 4.

      ka( 4) = 13

      ha(13) =  1
      ha(14) =  2
      ha(15) =  3
      ha(16) =  4 

      a(13)  =   160.0d+0
      a(14)  =     8.0d+0
      a(15)  =   285.0d+0
      a(16)  =     9.0d+0

*     Column 5.

      ka( 5) = 17

      ha(17) =  1
      ha(18) =  2
      ha(19) =  3
      ha(20) =  4 

      a(17)  =   420.0d+0
      a(18)  =     4.0d+0
      a(19)  =    22.0d+0
      a(20)  =    20.0d+0

*     Column 6.

      ka(6)  = 21

      ha(21) =  1
      ha(22) =  2
      ha(23) =  3
      ha(24) =  4 

      a(21)  =   260.0d+0
      a(22)  =    14.0d+0
      a(23)  =    80.0d+0
      a(24)  =    19.0d+0

*     Don't forget to finish off  ka(n+1) = ne+1
*     This is crucial.

      ka( 7) = 25

*     ------------------------------------------------------------------
*     Set the upper and lower bounds on the variables
*     ------------------------------------------------------------------
      do 100, j = 1, n
         bl(j)  = zero
  100 continue

      bu(1)  =     4.0d+0
      bu(2)  =     3.0d+0
      bu(3)  =     2.0d+0
      bu(4)  =     8.0d+0
      bu(5)  =     2.0d+0
      bu(6)  =     2.0d+0

*     ------------------------------------------------------------------
*     Set the upper and lower bounds on  Ax.
*     The last row is free (i.e., infinite upper and lower bounds).
*     ------------------------------------------------------------------
      plInfy =  1.0d+20

      bl( 7) =  2000.0d+0
      bl( 8) =    55.0d+0
      bl( 9) =   800.0d+0
      bl(10) = - plInfy

      do 110, i = 1, m
         j      = n + i
         bu(j)  = plInfy
  110 continue

      c(1)   =   3.0d+0
      c(2)   =  24.0d+0
      c(3)   =  13.0d+0
      c(4)   =   9.0d+0
      c(5)   =  20.0d+0
      c(6)   =  19.0d+0
      iObj   =   0
      ObjAdd = zero

*     ------------------------------------------------------------------
*     Set the initial estimate of the solution.
*     ------------------------------------------------------------------
      xs(1) = 1.0d+0
      xs(2) = 1.0d+0
      xs(3) = 1.0d+0
      xs(4) = 1.0d+0
      xs(5) = 1.0d+0
      xs(6) = 1.0d+0

*     end of sqdat2
      end
