*     ------------------------------------------------------------------
*     File snmain.f  (Unix version)
*     This is a main program to illustrate the use of subroutine SNOPT,
*     which is part of the SNOPT package.
*
*     31 Jul 1996: First   version.
*     12 Feb 1998: Current version.
*     ------------------------------------------------------------------
      program            snmain
      implicit           double precision (a-h,o-z)

      parameter        ( maxm   = 1000,
     $                   maxn   = 1000,
     $                   maxne  = 3000,
     $                   nName  = 1 )

      character*8        Prob, Names(nName)
      integer*4          ha(maxne) , hs(maxn+maxm)
      integer            ka(maxn+1)
      double precision   a(maxne)  , bl(maxn+maxm), bu(maxn+maxm),
     $                   x(maxn+maxm), pi(maxm)   , rc(maxn+maxm)

*     SNOPT workspace

      parameter          (  lenrw = 20000)
      double precision   rw(lenrw)
      parameter          (  leniw = 10000) 
      integer            iw(leniw)
      parameter          (  lencw =   500) 
      character*8        cw(lencw)

      logical            byname
      character*20       lfile
      external           HexCon, HexObj

*     ------------------------------------------------------------------
*     Specify some of the SNOPT files.
*     iSpecs  is the Specs file   (0 if none).
*     iPrint  is the Print file   (0 if none).
*     iSumm   is the Summary file (0 if none).
*
*     nout    is an output file used here by snmain.

      iSpecs = 4
      iPrint = 15
      iSumm  = 6
      nout   = 6

      byname = .true.
 
      if ( byname ) then

*        Unix and DOS systems.  Open the Specs and print files.

         lfile = 'snmain.spc'
         open( iSpecs, file=lfile, status='OLD',     err=800 )

         lfile = 'snmain.out'
         open( iPrint, file=lfile, status='UNKNOWN', err=800 )
      end if

*     ------------------------------------------------------------------
*     First,  snInit MUST be called to initialize optional parameters 
*     to their default values.
*     ------------------------------------------------------------------
      call snInit( iPrint, iSumm,
     $             cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Read a Specs file (Optional).
*     ------------------------------------------------------------------
      call snSpec( iSpecs, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .ge. 2) then
         write(nout, *) 'iSpecs > 0 but no Specs file found'
         go to 990
      end if

*     Set up the data structure for the sparse Jacobian.
*     Assign dummy values for the nonlinear elements. 

      call HexDat( Prob, maxm, maxn, maxne, inform,
     $             m, n, ne, nnCon, nnObj, nnJac, iObj, ObjAdd,
     $             a, ha, ka, bl, bu, hs, x, pi )

*     ------------------------------------------------------------------
*     Specify any options not set in the Specs file.
*     i1 and i2 may refer to the Print and Summary file respectively.
*     Setting them to 0 suppresses printing.
*     ------------------------------------------------------------------
      itnlim = 250
      i1     =   0
      i2     =   0
      call snseti( 'Iterations        ', itnlim, i1, i2, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Go for it, using a Cold start.
*     hs     need not be set if a basis file is to be input.
*            Otherwise, each hs(1:n) should be 0, 1, 2, 3, 4, or 5.
*            The values are used by the Crash procedure m2crsh
*            to choose an initial basis B.
*            If hs(j) = 0 or 1, column j is eligible for B.
*            If hs(j) = 2, column j is initially superbasic (not in B).
*            If hs(j) = 3, column j is eligible for B and is given
*                          preference over columns with hs(j) = 0 or 1.
*            If hs(j) = 4 or 5, column j is initially nonbasic.
*     ------------------------------------------------------------------
      call snopt ( 'Cold', m, n, ne, nName,
     $             nnCon, nnObj, nnJac,
     $             iObj, ObjAdd, Prob,
     $             HexCon, HexObj,
     $             a, ha, ka, bl, bu, Names,
     $             hs, x, pi, rc, 
     $             inform, mincw, miniw, minrw,
     $             nS, nInf, sInf, Obj,
     $             cw, lencw, iw, leniw, rw, lenrw,
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .eq. 42 .or. inform .eq. 43 .or. inform .eq. 44) then
         write(nout, *) ' '
         write(nout, *) 'Estimate of required lencw:', mincw
         write(nout, *) 'Estimate of required leniw:', miniw
         write(nout, *) 'Estimate of required lenrw:', minrw
         go to 910
      end if

      write(nout, *) ' '
      write(nout, *) 'snopt finished.'
      write(nout, *) 'inform =', inform
      write(nout, *) 'nInf   =', nInf
      write(nout, *) 'sInf   =', sInf
      write(nout, *) 'Obj    =', Obj
      if (inform .ge. 20) go to 910
      stop

*     ------------------------------------------------------------------
*     Error exit.
*     ------------------------------------------------------------------
  800 write(nout, 4000) 'Error while opening file', lfile
      stop

  910 write(nout, *) ' '
      write(nout, *) 'STOPPING because of error condition'

  990 stop

 4000 format(/  a, 2x, a  )

*     end of main program to test subroutine snopt
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine HexObj( mode, nnObj, x, fObj, gObj, nState, 
     $                   cu, lencu, iu, leniu, ru, lenru )

      implicit           double precision(a-h,o-z)
      double precision   x(nnObj), gObj(nnObj)

      character*8        cu(lencu)
      integer            iu(leniu)
      double precision   ru(lenru)

*     ==================================================================
*     Problem Hexagon.
*     No user-defined storage is used.
*     ==================================================================

      fObj    = - x(2)*x(6) + x(1)*x(7) - x(3)*x(7) - x(5)*x(8)
     $          + x(4)*x(9) + x(3)*x(8)

      gObj(1) =   x(7)
      gObj(2) = - x(6)
      gObj(3) = - x(7) + x(8)
      gObj(4) =   x(9)
      gObj(5) = - x(8)
      gObj(6) = - x(2)
      gObj(7) = - x(3) + x(1)
      gObj(8) = - x(5) + x(3)
      gObj(9) =   x(4)

*     end of objective for snmain.
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine HexCon( mode, nnCon, nnJac, neJac, x, fCon, gCon,
     $                   nState, cu, lencu, iu, leniu, ru, lenru )

      implicit           double precision(a-h,o-z)
      double precision   x(nnJac), fCon(nnCon), gCon(neJac)

      character*8        cu(lencu)
      integer            iu(leniu)
      double precision   ru(lenru)

*     ==================================================================
*     Problem Hexagon. 
*
*     No user-defined storage is used.
*     ==================================================================
      parameter         (two   = 2.0d+0)

      fCon( 1) =    x(1)**2          +  x(6)**2
      fCon( 2) =   (x(2) - x(1))**2  +  (x(7) - x(6))**2
      fCon( 3) =   (x(3) - x(1))**2  +  x(6)**2
      fCon( 4) =   (x(1) - x(4))**2  +  (x(6) - x(8))**2
      fCon( 5) =   (x(1) - x(5))**2  +  (x(6) - x(9))**2
      fCon( 6) =    x(2)**2          +  x(7)**2
      fCon( 7) =   (x(3) - x(2))**2  +  x(7)**2
      fCon( 8) =   (x(4) - x(2))**2  +  (x(8) - x(7))**2
      fCon( 9) =   (x(2) - x(5))**2  +  (x(7) - x(9))**2
      fCon(10) =   (x(4) - x(3))**2  +  x(8)**2
      fCon(11) =   (x(5) - x(3))**2  +  x(9)**2
      fCon(12) =    x(4)**2          +  x(8)**2
      fCon(13) =   (x(4) - x(5))**2  +  (x(9) - x(8))**2
      fCon(14) =    x(5)**2          +  x(9)**2

*     Nonlinear Jacobian elements for column 1.
*     rows = (1,2,3,4,5).

      gCon( 1) =   two*x(1)
      gCon( 2) = - two*(x(2) - x(1))
      gCon( 3) = - two*(x(3) - x(1))
      gCon( 4) =   two*(x(1) - x(4))
      gCon( 5) =   two*(x(1) - x(5))

*     Nonlinear Jacobian elements for column 2.
*     Rows = (2,6,7,8,9).

      gCon( 6) =   two*(x(2) - x(1))
      gCon( 7) =   two*x(2)
      gCon( 8) = - two*(x(3) - x(2))
      gCon( 9) = - two*(x(4) - x(2))
      gCon(10) =   two*(x(2) - x(5))

*     Nonlinear Jacobian elements for column 3.
*     Rows = (3,7,10,11).

      gCon(11) =   two*(x(3) - x(1))
      gCon(12) =   two*(x(3) - x(2))
      gCon(13) = - two*(x(4) - x(3))
      gCon(14) = - two*(x(5) - x(3))
             
*     Nonlinear Jacobian elements for column 4.
*     Rows = (4,8,10,12,13).

      gCon(15) = - two*(x(1) - x(4))
      gCon(16) =   two*(x(4) - x(2))
      gCon(17) =   two*(x(4) - x(3))
      gCon(18) =   two*x(4)
      gCon(19) =   two*(x(4) - x(5))

*     Nonlinear Jacobian elements for column 5.
*     Rows = (5,9,11,13,14).

      gCon(20) = - two*(x(1) - x(5))
      gCon(21) = - two*(x(2) - x(5))
      gCon(22) =   two*(x(5) - x(3))
      gCon(23) = - two*(x(4) - x(5))
      gCon(24) =   two*x(5)

*     Nonlinear Jacobian elements for column 6.
*     Rows = (1,2,3,4,5).      

      gCon(25) =   two*x(6)
      gCon(26) = - two*(x(7) - x(6))
      gCon(27) =   two*x(6)
      gCon(28) =   two*(x(6) - x(8))
      gCon(29) =   two*(x(6) - x(9))

*     Nonlinear Jacobian elements for column 7.
*     Rows = (2,6,7,8,9).

      gCon(30) =   two*(x(7) - x(6))
      gCon(31) =   two*x(7)
      gCon(32) =   two*x(7)
      gCon(33) = - two*(x(8) - x(7))
      gCon(34) =   two*(x(7) - x(9))

*     Nonlinear Jacobian elements for column 8.
*     Rows = (4,8,10,12,13).

      gCon(35) = - two*(x(6) - x(8))
      gCon(36) =   two*(x(8) - x(7))
      gCon(37) =   two*x(8)
      gCon(38) =   two*x(8)
      gCon(39) = - two*(x(9) - x(8))

*     Nonlinear Jacobian elements for column 9.
*     Rows = (5,9,11,13,14).

      gCon(40) = - two*(x(6) - x(9))
      gCon(41) = - two*(x(7) - x(9))
      gCon(42) =   two*x(9)
      gCon(43) =   two*(x(9) - x(8))
      gCon(44) =   two*x(9)

*     end of constraints for Hexagon.
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine HexDat( Prob, maxm, maxn, maxne, inform,
     $                   m, n, ne, nnCon, nnObj, nnJac, iObj, ObjAdd,
     $                   a, ha, ka, bl, bu, hs, x, pi )

      implicit           double precision (a-h,o-z)
      character*8        Prob
      integer            ha(maxne)   , hs(maxn+maxm)
      integer            ka(maxn+1)
      double precision   a(maxne)    , bl(maxn+maxm), bu(maxn+maxm),
     $                   x(maxn+maxm), pi(maxm)

*     ------------------------------------------------------------------
*     HexDat generates data for the Hexagon problem.
*     The constraints take the form
*              c(x) + A*x - s = 0,
*     where the Jacobian for c(x) + Ax is stored in a(*), and any
*     terms coming from c(x) are in the TOP LEFT-HAND CORNER of a(*),
*     with dimensions  nnCon x nnJac.
*     Note that the right-hand side is zero.
*     s is a set of slack variables whose bounds contain any constants
*     that might have formed a right-hand side.
*
*     The objective function is
*             f(x) + d'x
*     where d would be row iobj of A (but there is no such row in
*     this example).  f(x) involves only the FIRST nnObj variables.
*   
*     On entry,
*     maxm, maxn, maxne are upper limits on m, n, ne.
*
*     On exit,
*     inform  is 0 if there is enough storage, 1 otherwise.
*     m       is the number of nonlinear and linear constraints.
*     n       is the number of variables.
*     ne      is the number of nonzeros in a(*).
*     nnCon   is the number of nonlinear constraints (they come first).
*     nnObj   is the number of nonlinear objective variables.
*     nnJac   is the number of nonlinear Jacobian variables.
*     a       is the constraint matrix (Jacobian), stored column-wise.
*     ha      is the list of row indices for each nonzero in a(*).
*     ka      is a set of pointers to the beginning of each column of a.
*     bl      is the lower bounds on x and s.
*     bu      is the upper bounds on x and s.
*     hs(1:n) is a set of initial states for each x  (0,1,2,3,4,5).
*     x (1:n) is a set of initial values for x.
*     pi(1:m) is a set of initial values for the dual variables pi.
*
*     24 Dec 1997: First version of HexDat.
*     ------------------------------------------------------------------
      parameter      (bplus   = 1.0d+20)
      parameter      (zero    = 0.0d+0,   one    = 1.0d+0)

*     Give a name to the Problem.

      Prob   = 'Hexagon '

      ne     = 52
      n      =  9
      m      = 18

      nnCon  = 14
      nnJac  =  n
      nnObj  =  n

*     Check if there is enough storage.

      inform = 0
      if (m      .gt. maxm ) inform = 1
      if (n      .gt. maxn ) inform = 1
      if (ne     .gt. maxne) inform = 1
      if (inform .gt.   0  ) return

*     -------------------------------------
*     Set up the list of row indices in ha.
*     -------------------------------------
*     Column  1
*     Nonlinear elements in rows (1, 2, 3, 4, 5)  first.

      ka( 1) =  1

      ha( 1) =  1
      ha( 2) =  2 
      ha( 3) =  3 
      ha( 4) =  4 
      ha( 5) =  5

      a( 1)  =  zero
      a( 2)  =  zero
      a( 3)  =  zero
      a( 4)  =  zero
      a( 5)  =  zero

*     Column 1.
*     Linear element in row 6 next.

      ha( 6) = 15

      a( 6)  = -one

*     Column 2.
*     Nonlinear elements in rows (2, 6, 7, 8, 9).

      ka( 2) =  7

      ha( 7) =  2
      ha( 8) =  6
      ha( 9) =  7
      ha(10) =  8 
      ha(11) =  9

      a( 7)  =  zero
      a( 8)  =  zero
      a( 9)  =  zero
      a(10)  =  zero
      a(11)  =  zero

*     Column 2.
*     Linear elements in rows (15,16).

      ha(12) = 15
      ha(13) = 16

      a(12)  =  one
      a(13)  = -one

*     Column 3.
*     Nonlinear elements in rows (3, 7, 10, 11).

      ka( 3) =  14

      ha(14) =  3
      ha(15) =  7
      ha(16) = 10 
      ha(17) = 11

      a(14)  =  zero
      a(15)  =  zero
      a(16)  =  zero
      a(17)  =  zero 

*     Column 3.
*     Linear elements in rows (16, 17).

      ha(18) = 16
      ha(19) = 17

      a(18)  =  one
      a(19)  =  one

*     Column 4.
*     Nonlinear elements in rows (20, 21, 22, 23, 24).

      ka( 4) = 20

      ha(20) =  4
      ha(21) =  8
      ha(22) = 10 
      ha(23) = 12
      ha(24) = 13

      a(20)  =  zero
      a(21)  =  zero
      a(22)  =  zero
      a(23)  =  zero
      a(24)  =  zero

*     Column 4.
*     Linear elements in rows (17, 18).

      ha(25) = 17
      ha(26) = 18

      a(25)  = -one
      a(26)  =  one

*     Column 5.
*     Nonlinear elements in rows (5, 9, 11, 13, 14).

      ka( 5) = 27

      ha(27) =  5
      ha(28) =  9 
      ha(29) = 11
      ha(30) = 13
      ha(31) = 14

      a(27)  =  zero
      a(28)  =  zero
      a(29)  =  zero
      a(30)  =  zero
      a(31)  =  zero

*     Column 5.
*     Linear element in row 18.

      ha(32) = 18

      a(32)  = -one

*     Column 6.
*     Nonlinear elements in rows (1, 2, 3, 4, 5, 6).

      ka(6)  = 33

      ha(33) =  1
      ha(34) =  2 
      ha(35) =  3
      ha(36) =  4
      ha(37) =  5

      a(33)  =  zero
      a(34)  =  zero
      a(35)  =  zero
      a(36)  =  zero
      a(37)  =  zero

*     Column 7. 
*     Nonlinear elements in rows (2, 6, 7, 8, 9).

      ka(7)  =  38

      ha(38) =  2
      ha(39) =  6
      ha(40) =  7 
      ha(41) =  8
      ha(42) =  9

      a(38)  =  zero
      a(39)  =  zero
      a(40)  =  zero
      a(41)  =  zero
      a(42)  =  zero

*     Column 8. 
*     Nonlinear elements in rows (4, 8, 10, 12, 13).

      ka(8)  =  43

      ha(43) =  4
      ha(44) =  8
      ha(45) = 10 
      ha(46) = 12
      ha(47) = 13

      a(43)  =  zero
      a(44)  =  zero
      a(45)  =  zero
      a(46)  =  zero
      a(47)  =  zero

*     Column 9. 
*     Nonlinear elements in rows (5, 9, 11, 13, 14).

      ka(9)  =  48

      ha(48) =  5
      ha(49) =  9
      ha(50) = 11 
      ha(51) = 13
      ha(52) = 14

      a(48)  =  zero
      a(49)  =  zero
      a(50)  =  zero
      a(51)  =  zero
      a(52)  =  zero

*     Don't forget to finish off  ka.
*     This is crucial.

      ka(10) =  ne + 1

*     ------------------------------------------------------------------
*     Constraint ranges
*     ------------------------------------------------------------------
*     Nonlinear constraints first.

      do 200,  i = 1, nnCon
         bl(i+n) = -bplus
         bu(i+n) =  one
  200 continue

*     Followed by the linear constraints.

      do 210,  i = nnCon+1, m
         bl(i+n) =  zero
         bu(i+n) =  bplus
  210 continue

*     No linear objective term for this problem.

      iObj    = 0
      ObjAdd  = zero

*     ------------------------------------------------------------------
*     Variable ranges
*     ------------------------------------------------------------------
      do 300, j = 1, n
         bl(j) = -bplus
         bu(j) =  bplus
  300 continue

      bl(1) =  zero
      bl(3) = -one
      bl(5) =  zero
      bl(6) =  zero
      bl(7) =  zero

      bu(3) =  one
      bu(8) =  zero
      bu(9) =  zero

*     ------------------------------------------------------------------
*     Initialize x, hs and pi.
*     Set the initial value and status of each variable.
*     For want of something better to do, make the variables x(1:n)
*     temporarily fixed at their current values. 
*     The crash can set the rest.
*     ------------------------------------------------------------------
      do 400, j = 1, n
         x(j)   = one
  400 continue

      do 500, j = 1, n
         hs(j)  = 0
  500 continue

      do 600, i = 1, m
         pi(i)  = zero
  600 continue

*     end of HexDat
      end
