*     ------------------------------------------------------------------
*     File t1diet.f  (Unix version)
*     Illustrates the use of subroutine SNOPT on a linear program,
*
*     15 May 1998: First   version.
*     27 Feb 1999: Current version.
*     ------------------------------------------------------------------
      program            t1main
      implicit           double precision (a-h,o-z)

      parameter        ( maxm   = 1000,
     $                   maxn   = 1000,
     $                   maxne  = 3000,
     $                   nName  = 1 )

      character*8        Prob
      character*8        Names(nName)
      integer*4          ha(maxne) , hs(maxn+maxm)
      integer            ka(maxn+1)
      double precision   a(maxne)  , bl(maxn+maxm), bu(maxn+maxm),
     $                   x(maxn+maxm), pi(maxm)   , rc(maxn+maxm)

*     SNOPT workspace

      parameter          (  lenrw = 20000)
      double precision   rw(lenrw)
      parameter          (  leniw = 10000) 
      integer            iw(leniw)
      parameter          (  lencw =   500) 
      character*8        cw(lencw)

      logical            byname
      character*20       lfile
      external           funcon, funobj !dummy subroutines
*     ------------------------------------------------------------------
*     Specify some of the SNOPT files.
*     iSpecs  is the Specs file   (0 if none).
*     iPrint  is the Print file   (0 if none).
*     iSumm   is the Summary file (0 if none).
*
*     nout    is an output file used here by t1diet.

      iSpecs = 4
      iPrint = 15
      iSumm  = 6
      nout   = 6

      byname = .true.
 
      if ( byname ) then

*        Unix and DOS systems.  Open the Specs and print files.

         lfile = 't1diet.spc'
         open( iSpecs, file=lfile, status='OLD',     err=900 )

         lfile = 't1diet.out'
         open( iPrint, file=lfile, status='UNKNOWN', err=900 )
      end if

*     ------------------------------------------------------------------
*     First,  snInit MUST be called to initialize optional parameters 
*     to their default values.
*     ------------------------------------------------------------------
      call snInit( iPrint, iSumm,
     $             cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Read a Specs file (Optional).
*     ------------------------------------------------------------------
      call snSpec( iSpecs, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .ge. 2) then
         write(nout, *) 'iSpecs > 0 but no Specs file found'
         go to 800
      end if

*     Set up the data structure for the sparse Jacobian.
*     Assign dummy values for the nonlinear elements. 

      call t1data( maxm, maxn, maxne, inform, 
     $             m, n, ne, nnCon, nnObj, nnJac,
     $             iObj, ObjAdd, Prob,
     $             a, ha, ka, bl, bu, hs, x, pi )

*     ------------------------------------------------------------------
*     Specify any options not set in the Specs file.
*     i1 and i2 may refer to the Print and Summary file respectively.
*     Setting them to 0 suppresses printing.
*     ------------------------------------------------------------------
      itnlim = 250
      i1     =   0
      i2     =   0
      call snseti( 'Iterations        ', itnlim, i1, i2, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Go for it, using a Cold start.
*     hs     need not be set if a basis file is to be input.
*            Otherwise, each hs(1:n) should be 0, 1, 2, 3, 4, or 5.
*            The values are used by the Crash procedure m2crsh
*            to choose an initial basis B.
*            If hs(j) = 0 or 1, column j is eligible for B.
*            If hs(j) = 2, column j is initially superbasic (not in B).
*            If hs(j) = 3, column j is eligible for B and is given
*                          preference over columns with hs(j) = 0 or 1.
*            If hs(j) = 4 or 5, column j is initially nonbasic.
*     ------------------------------------------------------------------
      call snopt ( 'Cold', m, n, ne, nName,
     $             nnCon, nnObj, nnJac,
     $             iObj, ObjAdd, Prob,
     $             funcon, funobj,
     $             a, ha, ka, bl, bu, Names,
     $             hs, x, pi, rc, 
     $             inform, mincw, miniw, minrw,
     $             nS, nInf, sInf, Obj,
     $             cw, lencw, iw, leniw, rw, lenrw,
     $             cw, lencw, iw, leniw, rw, lenrw )

      write(nout, *) ' '

      if (inform .eq. 42 .or. inform .eq. 43 .or. inform .eq. 44) then
         write(nout, *) 'Estimate of required lencw:', mincw
         write(nout, *) 'Estimate of required leniw:', miniw
         write(nout, *) 'Estimate of required lenrw:', minrw
      else
         write(nout, *) 'snopt finished.'
         write(nout, *) 'inform =', inform
         write(nout, *) 'nInf   =', nInf
         write(nout, *) 'sInf   =', sInf
         write(nout, *) 'Obj    =', Obj
      end if

      if (inform .ge. 20) then
         write(nout, *) ' '
         write(nout, *) 'STOPPING because of error condition'
      end if

  800 if ( byname ) then
         close(iSpecs)
         close(iPrint)
      end if

      stop

*     ------------------------------------------------------------------
*     File Error.
*     ------------------------------------------------------------------
  900 write(nout, 4000) 'Error while opening file', lfile
      stop

 4000 format(/  a, 2x, a  )

*     end of t1diet.
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine funobj( mode, nnObj, x, fObj, gObj, nState, 
     $                   cu, lencu, iu, leniu, ru, lenru )

      implicit           double precision(a-h,o-z)
      double precision   x(nnObj), gObj(nnObj)

      character*8        cu(lencu)
      integer            iu(leniu)
      double precision   ru(lenru)

*     ==================================================================
*     Problem t1diet.
*     No nonlinear objective
*     ==================================================================

*     Relax

*     end of dummy objective for t1diet
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine funcon( mode, nnCon, nnJac, neJac, x, fCon, gCon,
     $                   nState, cu, lencu, iu, leniu, ru, lenru )

      implicit           double precision(a-h,o-z)
      double precision   x(nnJac), fCon(nnCon), gCon(neJac)

      character*8        cu(lencu)
      integer            iu(leniu)
      double precision   ru(lenru)

*     ==================================================================
*     Problem t1diet.
*     No nonlinear constraints.
*     ==================================================================

*     Relax

*     end of dummy constraints for t1diet
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine t1data( maxm, maxn, maxne, inform, 
     $                   m, n, ne, nnCon, nnObj, nnJac,
     $                   iObj, ObjAdd, Prob,
     $                   a, ha, ka, bl, bu, hs, x, pi )

      implicit           double precision (a-h,o-z)
      character*8        Prob
      integer            ha(maxne)   , hs(maxn+maxm)
      integer            ka(maxn+1)
      double precision   a(maxne)    , bl(maxn+maxm), bu(maxn+maxm),
     $                   x(maxn+maxm), pi(maxm)

*     ------------------------------------------------------------------
*     Define the problem.
*     (1) Compute l, u, and A so that the constraints are ranges of the
*         form  l <= Ax <= u.
*         Store l and u in bl(n+1:n+m) and bu(n+1:n+m).
*
*     (2) Set up the constants ObjAdd and iObj so that the explicit
*         objective is 
*             ObjAdd + (row iObj of A)'*x 
*
*     On entry,
*     maxm, maxn, maxne are upper limits on m, n, ne.
*
*     On exit,
*     inform  is 0 if there is enough storage, 1 otherwise.
*     m       is the number of nonlinear and linear constraints.
*     n       is the number of variables.
*     ne      is the number of nonzeros in a(*).
*     nnCon   is the number of nonlinear constraints (they come first).
*     nnObj   is the number of nonlinear objective variables.
*     nnJac   is the number of nonlinear Jacobian variables.
*     a       is the constraint matrix (Jacobian), stored column-wise.
*     ha      is the list of row indices for each nonzero in a(*).
*     ka      is a set of pointers to the beginning of each column of a.
*     bl      is the lower bounds on x and s.
*     bu      is the upper bounds on x and s.
*     hs(1:n) is a set of initial states for each x  (0,1,2,3,4,5).
*     x (1:n) is a set of initial values for x.
*     pi(1:m) is a set of initial values for the dual variables pi.
*     ------------------------------------------------------------------
      parameter         (bplus   = 1.0d+21)
      parameter         (zero    = 0.0d+0,   one    = 1.0d+0)

*     Name the Problem.

      Prob = 'Diet LP.'

*     ------------------------------------------------------------------
*     This is the Diet problem of Chvatal, 1983.
*     Assign the constraint nonzeros to a, column by column.
*     ha(i) gives the row index of element a(i).
*     ka(j) gives the index in a of the start of column j.
*     ------------------------------------------------------------------
*           ( 110  205  160  160  420  260 )
*     A  =  (   4   32   13    8    4   14 )
*           (   2   12   54  285   22   80 )
*           (   3   24   13    9   20   19 ) ( = objective row c') 

      n      =  6
      m      =  4               ! Includes the objective row
      ne     = 24               ! n*m for a dense A.

*     Check if there is enough storage.

      inform = 0
      if (m      .gt. maxm ) inform = 1
      if (n      .gt. maxn ) inform = 1
      if (ne     .gt. maxne) inform = 1
      if (inform .gt.   0  ) return

      nnCon  =  0
      nnObj  =  0
      nnJac  =  0

*     Column 1.

      ka( 1) =  1

      ha( 1) =  1
      ha( 2) =  2 
      ha( 3) =  3 
      ha( 4) =  4 

      a( 1)  =   110.0d+0
      a( 2)  =     4.0d+0
      a( 3)  =     2.0d+0
      a( 4)  =     3.0d+0

*     Column 2.

      ka( 2) =  5

      ha( 5) =  1
      ha( 6) =  2
      ha( 7) =  3
      ha( 8) =  4 

      a( 5)  =   205.0d+0
      a( 6)  =    32.0d+0
      a( 7)  =    12.0d+0
      a( 8)  =    24.0d+0

*     Column 3.

      ka( 3) =  9

      ha( 9) =  1
      ha(10) =  2
      ha(11) =  3
      ha(12) =  4 

      a( 9)  =   160.0d+0
      a(10)  =    13.0d+0
      a(11)  =    54.0d+0
      a(12)  =    13.0d+0

*     Column 4.

      ka( 4) = 13

      ha(13) =  1
      ha(14) =  2
      ha(15) =  3
      ha(16) =  4 

      a(13)  =   160.0d+0
      a(14)  =     8.0d+0
      a(15)  =   285.0d+0
      a(16)  =     9.0d+0

*     Column 5.

      ka( 5) = 17

      ha(17) =  1
      ha(18) =  2
      ha(19) =  3
      ha(20) =  4 

      a(17)  =   420.0d+0
      a(18)  =     4.0d+0
      a(19)  =    22.0d+0
      a(20)  =    20.0d+0

*     Column 6.

      ka(6)  = 21

      ha(21) =  1
      ha(22) =  2
      ha(23) =  3
      ha(24) =  4 

      a(21)  =   260.0d+0
      a(22)  =    14.0d+0
      a(23)  =    80.0d+0
      a(24)  =    19.0d+0

*     Don't forget to finish off  ka(n+1) = ne+1
*     This is crucial.

      ka( 7) = 25

*     ------------------------------------------------------------------
*     Set the upper and lower bounds on the variables
*     ------------------------------------------------------------------
      do 100, j = 1, n
         bl(j)  = zero
  100 continue

      bu(1)  =     4.0d+0
      bu(2)  =     3.0d+0
      bu(3)  =     2.0d+0
      bu(4)  =     8.0d+0
      bu(5)  =     2.0d+0
      bu(6)  =     2.0d+0

*     ------------------------------------------------------------------
*     Set the upper and lower bounds on  Ax.
*     The last row is free (i.e., infinite upper and lower bounds).
*     ------------------------------------------------------------------
      bl( 7) =  2000.0d+0
      bl( 8) =    55.0d+0
      bl( 9) =   800.0d+0
      bl(10) = - bplus

      do 110, i = 1, m
         j      = n + i
         bu(j)  = bplus
  110 continue

      iObj   = 4
      ObjAdd = zero

*     ------------------------------------------------------------------
*     Initialize x, hs and pi.
*     Set the initial value and status of each variable.
*     For want of something better to do, make the variables x(1:n)
*     temporarily fixed at their current values. 
*     The crash can set the rest.
*     ------------------------------------------------------------------
      do 200, j = 1, n
         x(j)   = one
  200 continue

      do 300, j = 1, n
         hs(j)  = 0
  300 continue

      do 400, i = 1, m
         pi(i)  = zero
  400 continue

*     end of t1diet
      end

