*     ------------------------------------------------------------------
*     File t5weapon.f  (Unix version)
*     Illustrates using SNOPT on a linearly constrained problem.
*
*     15 May 1998: First   version.
*     22 Oct 1998: Current version.
*     ------------------------------------------------------------------
      program            t5main
      implicit           double precision (a-h,o-z)

      parameter        ( maxm   = 1000,
     $                   maxn   = 1000,
     $                   maxne  = 3000 )

      character*8        PrbNms(5) , Names(maxm+maxn)
      integer*4          ha(maxne) , hs(maxn+maxm)
      integer            ka(maxn+1)
      double precision   a(maxne)  , bl(maxn+maxm), bu(maxn+maxm),
     $                   xs(maxn+maxm), pi(maxm)   , rc(maxn+maxm)

*     SNOPT workspace

      parameter          (  lenrw = 20000)
      double precision   rw(lenrw)
      parameter          (  leniw = 10000) 
      integer            iw(leniw)
      parameter          (  lencw =   500) 
      character*8        cw(lencw)

      logical            byname
      character*20       lfile
      external           dummy, t5obj

*     ------------------------------------------------------------------
*     Specify some of the SNOPT files.
*     iSpecs  is the Specs file   (0 if none).
*     iPrint  is the Print file   (0 if none).
*     iSumm   is the Summary file (0 if none).
*
*     nout    is an output file used here by t5weapon.

      iSpecs =  4
      iPrint = 15
      iNewB  = 11
      iSumm  =  6
      nout   =  6

      byname = .true.
 
      if ( byname ) then

*        Unix and DOS systems.  Open the Specs and print files.

         lfile = 't5weapon.spc'
         open( iSpecs, file=lfile, status='OLD',     err=800 )

         lfile = 't5weapon.out'
         open( iPrint, file=lfile, status='UNKNOWN', err=800 )

         lfile = 't5weapon.newbasis'
         open( iNewB, file=lfile, status='UNKNOWN', err=800 )
      end if

*     ------------------------------------------------------------------
*     First,  snInit MUST be called to initialize optional parameters 
*     to their default values.
*     ------------------------------------------------------------------
      call snInit( iPrint, iSumm,
     $             cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Read a Specs file (Optional).
*     ------------------------------------------------------------------
      call snSpec( iSpecs, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .ge. 2) then
         write(nout, *) 'iSpecs > 0 but no Specs file found'
         go to 990
      end if

*     ------------------------------------------------------------------
*     Set up the data structure for the linear constraints.
*     MPSinp needs to know the number of nonlinear variables, etc.
*     The following calls fetch values set in the SPECS file.
*     Optionally, these values can be set in-line.
*     ------------------------------------------------------------------
      call sngeti( 'Nonlinear constraints        ', nnCon,
     $             inform, cw, lencw, iw, leniw, rw, lenrw )
      call sngeti( 'Nonlinear Jacobian  variables', nnJac,
     $             inform, cw, lencw, iw, leniw, rw, lenrw )
      call sngeti( 'Nonlinear Objective variables', nnObj,
     $             inform, cw, lencw, iw, leniw, rw, lenrw )
      call sngeti( 'MPS file                     ',  iMPS,
     $             inform, cw, lencw, iw, leniw, rw, lenrw )

*     The problem name is not needed---it is set by MPSinp. 
*     Specify the OBJECTIVE, RHS, RANGES and BOUNDS to be selected 
*     from the MPS file.  Blank names mean "select the first one".

*     PrbNms(1) = '        '    ! PROBLEM   name
      PrbNms(2) = '        '    ! OBJECTIVE name
      PrbNms(3) = '        '    ! RHS       name
      PrbNms(4) = '        '    ! RANGES    name    
      PrbNms(5) = '        '    ! BOUNDS    name

      if ( byname ) then

*        Unix and DOS systems.  Open the MPS file.

         lfile = 't5weapon.mps'
         open( iMPS, file=lfile, status='OLD', err=800 )
      end if

      call MPSinp( iMPS,
     $             maxm, maxn, maxne,
     $             nnCon, nnJac, nnObj, 
     $             m, n, ne,
     $             iObj, ObjAdd, PrbNms,
     $             a, ha, ka, bl, bu, Names,
     $             hs, xs, pi,
     $             inform, nS,
     $             cw, lencw, iw, leniw, rw, lenrw )

      close( iMPS )
      if (inform .gt. 0) go to 990
      nName = m + n

*     ------------------------------------------------------------------
*     Specify any options not set in the Specs file.
*     i1 and i2 may refer to the Print and Summary file respectively.
*     Setting them to 0 suppresses printing.
*     ------------------------------------------------------------------
      itnlim = 500
      i1     =   0
      i2     =   0
      call snseti( 'Iterations        ', itnlim, i1, i2, inform,
     $             cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Go for it, using a Cold start.
*     hs     need not be set if a basis file is to be input.
*            Otherwise, each hs(1:n) should be 0, 1, 2, 3, 4, or 5.
*            The values are used by the Crash procedure m2crsh
*            to choose an initial basis B.
*            If hs(j) = 0 or 1, column j is eligible for B.
*            If hs(j) = 2, column j is initially superbasic (not in B).
*            If hs(j) = 3, column j is eligible for B and is given
*                          preference over columns with hs(j) = 0 or 1.
*            If hs(j) = 4 or 5, column j is initially nonbasic.
*     ------------------------------------------------------------------
      call snopt ( 'Cold', m, n, ne, nName,
     $             nnCon, nnObj, nnJac,
     $             iObj, ObjAdd, PrbNms(1),
     $             dummy, t5obj,
     $             a, ha, ka, bl, bu, Names,
     $             hs, xs, pi, rc, 
     $             inform, mincw, miniw, minrw,
     $             nS, nInf, sInf, Obj,
     $             cw, lencw, iw, leniw, rw, lenrw,
     $             cw, lencw, iw, leniw, rw, lenrw )

      if (inform .eq. 42 .or. inform .eq. 43 .or. inform .eq. 44) then
         write(nout, *) ' '
         write(nout, *) 'Estimate of required lencw:', mincw
         write(nout, *) 'Estimate of required leniw:', miniw
         write(nout, *) 'Estimate of required lenrw:', minrw
         go to 910
      end if

      write(nout, *) ' '
      write(nout, *) 'snopt finished.'
      write(nout, *) 'inform =', inform
      write(nout, *) 'nInf   =', nInf
      write(nout, *) 'sInf   =', sInf
      write(nout, *) 'Obj    =', Obj
      if (inform .ge. 20) go to 910
      stop

*     ------------------------------------------------------------------
*     Error exit.
*     ------------------------------------------------------------------
  800 write(nout, 4000) 'Error while opening file', lfile
      stop

  910 write(nout, *) ' '
      write(nout, *) 'STOPPING because of error condition'

  990 stop

 4000 format(/  a, 2x, a  )

*     end of t5main.
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine t5obj ( mode, n, x, f, g, nState,
     $                   cw, lencw, iw, leniw, rw, lenrw )

      implicit           double precision (a-h,o-z)
      double precision   x(n), g(n)

      character*8        cw(lencw)
      integer            iw(leniw)
      double precision   rw(lenrw)

*     ------------------------------------------------------------------
*     t5obj  is funobj for the Weapon Assignment problem t5weapon.
*     It assumes the Specs file contains input data after the End card.
*     ------------------------------------------------------------------
      intrinsic          log
      parameter        ( nweapn = 5,  ntargt = 20,  zero   = 0.0d+0 )
      double precision   q(nweapn,ntargt), ql(nweapn,ntargt), u(ntargt)
      save               q               , ql               , u
*     ------------------------------------------------------------------

      if (nState .eq. 1) then
*        ----------------------------------------------------
*        First entry.  Read some data defining the objective.
*        ----------------------------------------------------
*        Weapon data follows the SPECS data.
*        The SPECS file unit number is defined by the call to snInit
*        and saved in SNOPT workspace.

         iSpecs    = iw( 11) ! Specs (options) file

         do 20, i = 1, nweapn
            read (iSpecs, '(18f4.2)') (q(i,j), j = 1, ntargt)
            do 10, j = 1, ntargt
               ql(i,j) = log( q(i,j) )
   10       continue
   20    continue
      
         read (iSpecs, '(18f4.0)') u
      end if

*     -------------
*     Normal entry.
*     -------------
      k      = 0
      f      = zero
      
      do 990 j = 1, ntargt
         t     = u(j)
         do 960 i = 1, nweapn
            xk    = x(k+i)
            if (xk .gt. zero) t = t * q(i,j)**xk
  960    continue
      
         if (mode .eq. 2) then
            do 970  i = 1, nweapn
               g(k+i) = t * ql(i,j)
  970       continue
         end if
      
         k     = k + nweapn
         f     = f + (t - u(j))
  990 continue

*     end of t5obj  (funobj for t5weapon)
      end

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine dummy ( mode, nnCon, nnJac, neJac, x, fCon, gCon,
     $                   nState, cu, lencu, iu, leniu, ru, lenru )

      implicit           double precision(a-h,o-z)
      double precision   x(nnJac), fCon(nnCon), gCon(neJac)

      character*8        cu(lencu)
      integer            iu(leniu)
      double precision   ru(lenru)

*     ==================================================================
*     Problem t5weapon.
*     No nonlinear constraints.
*     ==================================================================

*     Relax

*     end of dummy constraints for t5weapon
      end

