*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
*     File  np02lib.f
*
*     nptitl   npInit   npSpec   npMem
*     npset    npseti   npsetr   npgetc   npgeti   npgetr
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine nptitl( title )

      character*30
     &     title

*     ==================================================================
*     npinit sets the title.
*     ==================================================================

      title  = 'N P O P T  5.4-1(1) (Nov 2000)'
*---------------123456789|123456789|123456789|--------------------------

      end ! of nptitl

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine npInit( iPrint, iSumm,
     &     iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     iPrint, iSumm, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)

*     ==================================================================
*     npInit  is called by the user to do the following:
*     1. Open default files (Print, Summary).
*     2. Initialize title.
*     3. Set options to default values.
*
*     15 Nov 1991: First version.
*     14 Jul 1997: Thread-safe version.
*     21 Mar 1997: First version based on snopt routine snInit
*     14 Jul 1997: Thread-safe version.
*     02 Oct 1997: Character workspace added.
*     03 Nov 2000: Current version of npInit.
*     ==================================================================
      integer
     &     lencw, lvlTim, maxru, maxrw, maxiu, maxiw, maxcu, maxcw
      character*30
     &     title
      character*30
     &     dashes
      data
     &     dashes /'=============================='/
*     ------------------------------------------------------------------
      parameter         (maxru     =   2) ! start of SNOPT part of rw
      parameter         (maxrw     =   3) ! end   of SNOPT part of rw
      parameter         (maxiu     =   4) ! start of SNOPT part of iw
      parameter         (maxiw     =   5) ! end   of SNOPT part of iw
      parameter         (maxcu     =   6) ! start of SNOPT part of cw
      parameter         (maxcw     =   7) ! end   of SNOPT part of cw
      parameter         (lvlTim    =  77) ! Timing level

      parameter         (lencw     = 500)
      character*8     cw(lencw)
*     ------------------------------------------------------------------
      if (leniw .lt. 500 .or. lenrw .lt. 500) then 
*        ---------------------------------------------------------------
*        Not enough workspace to do ANYTHING!
*        ---------------------------------------------------------------
         if (iPrint .gt. 0) write(iPrint, 9000) 
         if (iSumm  .gt. 0) write(iSumm , 9000) 
         if (iPrint .le. 0  .and.  iSumm  .le. 0) then
            write(*, 9000)
         end if
         go to 999
      end if

      iw( 12)   = iPrint  ! Print file
      iw( 13)   = iSumm   ! Summary file

      iw(maxcu) = 500
      iw(maxiu) = 500
      iw(maxru) = 500
      iw(maxcw) = lencw
      iw(maxiw) = leniw
      iw(maxrw) = lenrw

      call nptitl( title )
      call s1init( title, iw, leniw, rw, lenrw )

      if (iPrint .gt. 0) then
         write (iPrint, '(  9x, a )') ' ', dashes, title, dashes
      end if
      if (iSumm .gt. 0) then
         write (iSumm , '(  1x, a )') ' ', dashes, title, dashes
      end if

*     ------------------------------------------------------------------
*     Set the options to default values.
*     npopt  will check the options later and maybe print them.
*     ------------------------------------------------------------------
      call s3undf( cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Initialize some global values.
*     ------------------------------------------------------------------
      iw(lvlTim) = 3

  999 return

 9000 format(  ' EXIT from npInit --',
     &         ' integer and real work arrays',
     &         ' must each have at least 500 elements')

      end ! of npInit

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine npSpec( iSpecs, inform, 
     &     iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     iSpecs, inform, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)

*     ==================================================================
*     npSpec  is called by the user to read the Specs file.
*
*     07 Feb 1998: First version.
*     12 Feb 1998: Current version of npSpec.
*     ==================================================================
      integer
     &     Calls, iPrint, iSumm, lencw
      external
     &     s3opt
*     ------------------------------------------------------------------
      parameter            (lencw     = 500)
      character*8        cw(lencw)
*     ------------------------------------------------------------------
      iw( 11)   = iSpecs  ! Specs (options) file

      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file

      inform    = 0
      Calls     = 1

*     ------------------------------------------------------------------
*     Read the Specs file.
*     npopt  will check the options later and maybe print them.
*     ------------------------------------------------------------------
      if (iSpecs .gt. 0) then
         call s3file( Calls, iSpecs, s3opt,
     &        iPrint, iSumm, inform,
     &        cw, lencw, iw, leniw, rw, lenrw )
      end if

      end ! of npSpec

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine npMem ( n, nclin, ncnln,
     &     mincw, miniw, minrw,
     &     iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     n, nclin, ncnln, mincw, miniw, minrw, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)

*     ==================================================================
*     npMem   estimates the memory requirements for npopt,
*     using the values:
*     n      the number of variables (dimension of  x),
*
*     nclin  the number of linear constraints (rows of the matrix  A),
*
*     ncnln  the number of nonlinear constraints (dimension of  c(x)),
*
*     These values are used to compute the minimum required storage:
*     miniw, minrw.
*
*     Note: 
*     1. All default parameters must be set before calling npMem,
*        since some values affect the amount of memory required.
*
*     2. The arrays rw and iw hold  constants and work-space addresses.
*        They must have dimension at least 500.
*
*     3. This version of npMem does not allow user accessible
*        partitions of iw and rw.
*
*     01 May 1998: First version.
*     02 Nov 2000: Current version of npMem.
*     ==================================================================
      integer
     &     iError, iPrint, iPrinx, iSumm, iSummx, lencw, llenrw, lleniw, 
     &     llencw, lvlHes, m, maxcw, maxiw, maxrw, maxR, maxS, mQNmod,
     &     nCon, ne, neG, nnCon, nnJac, nnObj, nnCol
*     ------------------------------------------------------------------
      integer            CheckO
      parameter         (CheckO = 0) 
      parameter         (lencw     = 500)
      character*8     cw(lencw)
*     ------------------------------------------------------------------
      iPrint  = iw( 12) ! Print file
      iSumm   = iw( 13) ! Summary file

      if (lencw .lt. 500 .or. leniw .lt. 500 .or. lenrw .lt. 500) then 
*        ---------------------------------------------------------------
*        Not enough workspace to do ANYTHING!
*        ---------------------------------------------------------------
         if (iPrint .gt. 0) write(iPrint, 9000) 
         if (iSumm  .gt. 0) write(iSumm , 9000) 
         if (iPrint .le. 0  .and.  iSumm  .le. 0) then
            write(*, 9000)
         end if
         go to 999
      end if

*     Error messages from s8Mem are suppressed.

      iPrinx  = 0
      iSummx  = 0

*     Assign fake values for lencw, leniw, lenrw.
*     This will force s8Mem to estimate the memory requirements.

      llenrw  = 500
      lleniw  = 500
      llencw  = 500

*     Compute the problem dimensions.

      nCon       = nclin + ncnln

      if (nCon .eq. 0) then

*        The problem is unconstrained.
*        A dummy row of zeros will be included.

         nnCol = 0
         m     = 1
         ne    = 1
      else
         nnCol = n
         m     = nCon
         ne    = m*n 
      end if

      neG        = ncnln*n
      nnCon      = ncnln
      nnJac      = nnCol
      nnObj      = n

*     An obligatory call to snInit has `undefined' all options.
*     Check the user-defined values and assign undefined values.
*     s8dflt needs various problem dimensions in iw.

      iw( 15) = n     ! copy of the number of columns
      iw( 16) = m     ! copy of the number of rows
      iw( 17) = ne    ! copy of the number of nonzeros in Jcol
      iw( 21) = nnJac ! # nonlinear Jacobian variables
      iw( 22) = nnObj ! # variables in Gobj
      iw( 23) = nnCon ! # of nonlinear constraints

      call s8dflt( CheckO, cw, llencw, iw, lleniw, rw, llenrw )

      mincw   = 501
      miniw   = 501
      minrw   = 501

      maxcw   = lencw
      maxiw   = leniw
      maxrw   = lenrw

      maxR    = iw( 52) ! max columns of R.
      maxS    = iw( 53) ! max # of superbasics
      mQNmod  = iw( 54) ! (ge 0) max # of BFGS updates
      lvlHes  = iw( 72) ! 0,1,2  => LM, FM, Exact Hessian

      call s8Mem ( iError, iPrinx, iSummx, 
     &     m, n, ne, neG, nnCon, nnJac, nnObj,
     &     maxR, maxS, mQNmod, lvlHes, 
     &     maxcw, maxiw, maxrw, llencw, lleniw, llenrw,
     &     mincw, miniw, minrw, iw )

  999 return

 9000 format(  ' EXIT from npMem --',
     &         ' character, integer and real work arrays',
     &         ' must each have at least 500 elements')

      end ! of npMem.

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine npset ( buffer, iPrint, iSumm, inform,
     &     iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     iPrint, iSumm, inform, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)

*     ==================================================================
*     npset  decodes the option contained in  buffer.
*
*     The buffer is output to file iPrint, minus trailing blanks.
*     Error messages are output to files iPrint and iSumm.
*     Buffer is echoed to iPrint but normally not to iSumm.
*     It is echoed to iSumm before any error msg.
*
*     On entry,
*     iPrint is the print   file.  no output occurs if iPrint .le 0.
*     iSumm  is the Summary file.  no output occurs if iSumm  .le 0.
*     inform is the number of errors so far.
*
*     On exit,
*     inform is the number of errors so far.
*
*     27 Nov 1991: first version of npset.
*     03 Nov 2000: current version.
*     ==================================================================
      integer
     &     ivalue, lencw
      double precision
     &     rvalue
      character*8
     &     cvalue
      character*16
     &     key
*     ------------------------------------------------------------------
      parameter            (lencw     = 500)
      character*8        cw(lencw)
*     ------------------------------------------------------------------
      call s3opt ( .true., buffer, key, cvalue, ivalue, rvalue, 
     &     iPrint, iSumm, inform, cw, lencw, iw, leniw, rw, lenrw )

      end ! of npset

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine npseti( buffer, ivalue, iPrint, iSumm, inform,
     &     iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     ivalue, iPrint, iSumm, inform, leniw, lenrw,
     &     iw(leniw)
      double precision
     &     rw(lenrw)

*     ==================================================================
*     npseti decodes the option contained in  buffer // ivalue.
*     The parameters other than ivalue are as in npset.
*
*     27 Nov 1991: first version of npseti.
*     03 Nov 2000: current version.
*     ==================================================================
      integer
     &     ivalxx, lenbuf, lencw
      double precision
     &     rvalue
      character*8
     &     cvalue
      character*16
     &     key
      character*72
     &     buff72
*     ------------------------------------------------------------------
      parameter         (lencw     = 500)
      character*8     cw(lencw)
*     ------------------------------------------------------------------
      write(key, '(i16)') ivalue
      lenbuf = len(buffer)
      buff72 = buffer
      buff72(lenbuf+1:lenbuf+16) = key
      ivalxx = ivalue
      call s3opt ( .true., buff72, key, cvalue, ivalxx, rvalue, 
     &     iPrint, iSumm, inform, cw, lencw, iw, leniw, rw, lenrw )

      end ! of npseti

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine npsetr( buffer, rvalue, iPrint, iSumm, inform,
     &     iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     iPrint, iSumm, inform, leniw, lenrw, iw(leniw)
      double precision
     &     rvalue, rw(lenrw)

*     ==================================================================
*     npsetr decodes the option contained in  buffer // rvalue.
*     The parameters other than rvalue are as in npset.
*
*     27 Nov 1991: first version of npsetr.
*     03 Nov 2000: current version.
*     ==================================================================
      integer
     &     ivalue, lenbuf, lencw
      character*8
     &     cvalue
      double precision
     &     rvalxx
      character*16
     &     key
      character*72
     &     buff72
*     ------------------------------------------------------------------
      parameter            (lencw     = 500)
      character*8        cw(lencw)
*     ------------------------------------------------------------------
      write(key, '(1p, e16.8)') rvalue
      lenbuf = len(buffer)
      buff72 = buffer
      buff72(lenbuf+1:lenbuf+16) = key
      rvalxx = rvalue
      call s3opt ( .true., buff72, key, cvalue, ivalue, rvalxx,
     &     iPrint, iSumm, inform, cw, lencw, iw, leniw, rw, lenrw )

      end ! of npsetr

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine npgeti( buffer, ivalue,
     &     inform, iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     ivalue, inform, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)

*     ==================================================================
*     npgeti gets the value of the option contained in  buffer.
*     The parameters other than ivalue are as in npset.
*
*     17 May 1998: first version of npgeti.
*     03 Nov 2000: current version.
*     ==================================================================
      integer
     &     lencw
      double precision
     &     rvalue
      character*16
     &     key
      character*8
     &     cvalue
*     ------------------------------------------------------------------
      parameter            (lencw     = 500)
      character*8        cw(lencw)
*     ------------------------------------------------------------------
      call s3opt ( .false., buffer, key, cvalue, ivalue, rvalue,
     &     0, 0, inform, cw, lencw, iw, leniw, rw, lenrw )

      end ! of npgeti

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine npgetr( buffer, rvalue,
     &     inform, iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     inform, leniw, lenrw, iw(leniw)
      double precision
     &     rvalue, rw(lenrw)

*     ==================================================================
*     npgetr gets the value of the option contained in  buffer.
*     The parameters other than rvalue are as in npset.
*
*     17 May 1998: first version of npgetr.
*     03 Nov 2000: current version.
*     ==================================================================
      integer
     &     ivalue, lencw
      character*16
     &     key
      character*8
     &     cvalue
*     ------------------------------------------------------------------
      parameter            (lencw     = 500)
      character*8        cw(lencw)
*     ------------------------------------------------------------------
      call s3opt ( .false., buffer, key, cvalue, ivalue, rvalue,
     &     0, 0, inform, cw, lencw, iw, leniw, rw, lenrw )

      end ! of npgetr

