*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
*     File  sn40bfil.f
*
*     s4getB   s4id     s4ksav   s4name   s4inst   s4load   s4oldB
*     s4chek   s4dump   s4newB   s4pnch   s4rept   s4savB   s4soln
*     s4solp   s4stat   
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4getB( iError, m, n, nb, nName, nS, iObj,
     &     hs, bl, bu, x, Names, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     iError, iObj, m, n, nb, nName, nS, leniw, lenrw, hs(nb),
     &     iw(leniw)
      double precision
     &     bl(nb), bu(nb), x(nb), rw(lenrw)
      character*8
     &     Names(nName)

*     ==================================================================
*     s4getb loads one of the basis files.
*
*     15 Nov 1991: First version based on Minos routine m4getb.
*     20 Apr 1999: Current version of s4getb.
*     ==================================================================
      integer
     &     iLoadB, iInsrt, iOldB
*     ------------------------------------------------------------------
      iLoadB    = iw(122) ! load file
      iInsrt    = iw(125) ! insert file
      iOldB     = iw(126) ! old basis file

*     Load a basis file if one exists and istart = 0 (Cold start).

      if (iOldB .gt. 0) then
         call s4oldB( iError, m, n, nb, nS, hs, bl, bu, x,
     &        iw, leniw, rw, lenrw )

      else if (iInsrt .gt. 0) then
         call s4inst( n, nb, nS, iObj,
     &        hs, bl, bu, x, Names,
     &        iw, leniw, rw, lenrw )

      else if (iLoadB .gt. 0) then
         call s4load( n, nb, nS, iObj, 
     &        hs, x, Names,
     &        iw, leniw, rw, lenrw )
      end if

      end ! of s4getB

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4id  ( j, n, nb, nName, Names, id )

      implicit
     &     none
      integer
     &     j, n, nb, nName
      character*8
     &     id, Names(nName)

*     ==================================================================
*     s4id   returns a name id for the j-th variable.
*     If nName = nb, the name is already in Names.
*     Otherwise nName = 1. Some generic column or row name is cooked up
*
*     15 Nov 1991: First version based on Minos 5.4 routine m4id.
*     16 Sep 1997: Current version.
*     ==================================================================
      integer
     &     i
*     ------------------------------------------------------------------
      character*1        ColNm, RowNm
      data               ColNm /'x'/,     
     &                   RowNm /'r'/
*     ------------------------------------------------------------------
      if (nName .eq. nb) then
         id  = Names(j)
      else if (j .le. n) then
         write(id, '(a1,i7)') ColNm, j
      else
         i   = j - n
         write(id, '(a1,i7)') RowNm, i
      end if         

      end ! of s4id

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4ksav( minimz, m, n, nb, nS, mBS,
     &     itn, nInf, sInf, f, kBS, hs, 
     &     Ascale, bl, bu, x, xBS, cw, lencw, iw, leniw )

      implicit
     &     none
      integer
     &     minimz, m, n, nb, nS, mBS, itn, nInf, lencw, leniw,
     &     hs(nb), kBS(mBS), iw(leniw)
      double precision
     &     sInf, f, Ascale(nb), bl(nb), bu(nb), xBS(mBS), x(nb)
      character*8
     &     cw(lencw)

*     ==================================================================
*     s4ksav  saves various quantities as determined by the frequency 
*     control ksav.
*
*     15 Nov 1991: First version.
*     20 Apr 1999: Current version.
*     ==================================================================
      character*4
     &     istate(3)
      integer
     &     iBack, iNewB, itnlim, k
*     ------------------------------------------------------------------
      integer            Freq
      parameter         (Freq = 0)
*     ------------------------------------------------------------------
      iBack     = iw(120) ! backup file
      iNewB     = iw(124) ! new basis file
      itnlim    = iw( 89) ! limit on total iterations

      if (iNewB .gt. 0  .and.  itn .lt. itnlim) then
         k = 0
         call s4stat( k, istate )
         call s4newB( Freq, iNewB, minimz, m, n, nb,
     &        nS, mBS, itn, nInf, sInf, f, kBS, hs,
     &        Ascale, bl, bu, x, xBS, istate, 
     &        cw, lencw, iw, leniw )

         if (iBack .gt. 0)
     &   call s4newB( Freq, iBack, minimz, m, n, nb,
     &        nS, mBS, itn, nInf, sInf, f, kBS, hs,
     &        Ascale, bl, bu, x, xBS, istate,
     &        cw, lencw, iw, leniw )
      end if

      end ! of s4ksav

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4name( n, iPrint, Names, id,
     &     ncard, notfnd, maxmsg, j1, j2, jmark, jfound )

      implicit
     &     none
      integer
     &     iPrint, j1, j2, jmark, jfound, maxmsg, n, ncard, notfnd
      character*8
     &     Names(n), id
           
*     ==================================================================
*     s4name searches for names in the array  Names(j), j = j1, j2.
*     jmark  will probably speed the search on the next entry.
*     Used by subroutines s3mpsc, s4inst, s4load.
*
*     Left-justified alphanumeric data is being tested for a match.
*
*     15 Nov 1991: First version based on Minos 5.4 routine m4name.
*     04 Feb 1992: Current version.
*     ==================================================================
      integer
     &     j 

      do j = jmark, j2
         if (id .eq. Names(j)) go to 100
      end do

      do j = j1, jmark
         if (id .eq. Names(j)) go to 100
      end do

*     Not found.

      jfound = 0
      jmark  = j1
      notfnd = notfnd + 1
      if (notfnd .le. maxmsg) then
         if (iPrint .gt. 0) write(iPrint, 1000) ncard, id
      end if

      return

*     Got it.

  100 jfound = j
      jmark  = j
      return

 1000 format(' XXX  Line', i6, '  --  name not found:', 8x, a8)

      end ! of s4name

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4inst( n, nb, nS, iObj,
     &     hs, bl, bu, x, Names, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     iObj, leniw, lenrw, n, nb, nS, hs(nb), iw(leniw)
      double precision
     &     bl(nb), bu(nb), x(nb), rw(lenrw)
      character*8
     &     Names(nb)

*     ==================================================================
*     This impression of INSERT reads a file produced by  s4pnch.
*     It is intended to read files similar to those produced by
*     standard MPS systems.  It recognizes SB as an additional key.
*     Also, values are extracted from columns 25--36.
*
*     15 Nov 1991: First version based on Minos 5.4 routine m4inst.
*     04 Feb 1992: Current version.
*     ==================================================================
      character*8
     &     Name1, Name2
      character*4
     &     id(5)
      character*4
     &     key
      character*4
     &     lLL  , lUL  , lXL  , lXU  , lSB  , lEND
      data
     &     lLL  , lUL  , lXL  , lXU  , lSB  , lEND
     &   /' LL ',' UL ',' XL ',' XU ',' SB ', 'ENDA'/
      integer
     &     ignord, iInsrt, iPrint, iRead, iSumm, j, jmark, jObj,
     &     l, l1, lmark, MPSerr, nBS, ncard, ndum, nloop, notfnd
      double precision
     &     bplus, xj, plInfy
*     ------------------------------------------------------------------
      plInfy    = rw( 70) ! definition of plus infinity.

      iRead     = iw( 10) ! Standard Input
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      iInsrt    = iw(125) ! insert file

      MPSerr    = iw(106) ! maximum # errors in MPS data

      bplus  = 0.9d+0*plInfy
      if (iPrint .gt. 0) write(iPrint, 1999) iInsrt
      if (iSumm  .gt. 0) write(iSumm , 1999) iInsrt

                         read (iInsrt, 1000) id
      if (iPrint .gt. 0) write(iPrint, 2000) id
      l1    = n + 1

*     Make logicals basic.

      do j  = l1, nb
         hs(j) = 3
      end do

      ignord = 0
      nBS    = 0
      nS     = 0
      notfnd = 0
      ncard  = 0
      jmark  = 1
      lmark  = l1
      ndum   = n + 100000

      if (iObj .eq. 0) then
         jObj = 0
      else
         jObj = n + iObj
      end if

*     Read names until ENDATA

      do 300, nloop = 1, ndum
         read(iInsrt, 1020) key, Name1, Name2, xj
         if (key .eq. lEND) go to 310

*        Look for  Name1.  It may be a column or a row,
*        since a superbasic variable could be either.

         ncard  = nloop
         call s4name( nb, iPrint, Names, Name1,
     &        ncard, notfnd, MPSerr, 1, nb, jmark, j )
         if (   j  .le. 0) go to 300
         if (hs(j) .gt. 1) go to 290
         if (key .ne. lXL  .and.  key .ne. lXU) go to 70

*        Look for  Name2.  It has to be a row.

         call s4name( nb, iPrint, Names, Name2,
     &        ncard, notfnd, MPSerr, l1, nb, lmark, l )
         if (l .le. 0) go to 300

*        XL, XU (exchange card)  --  make col j basic,  row l nonbasic.

         if (l  .eq. jObj) go to 290
         if (hs(l) .ne. 3) go to 290
         nBS    = nBS + 1
         hs(j)  = 3
         if (key .eq. lXU) go to 50
         hs(l)  = 0
         if (bl(l) .gt. -bplus) x(l) = bl(l)
         go to 250

   50    hs(l)  = 1
         if (bu(l) .lt.  bplus) x(l) = bu(l)
         go to 250

*        LL, UL, SB  --  only  j  and  xj  are relevant.

   70    if (key .eq. lLL) go to 100
         if (key .eq. lUL) go to 150
         if (key .eq. lSB) go to 200
         go to 290

*        LO or UP

  100    hs(j)  = 0
         go to 250

  150    hs(j)  = 1
         go to 250

*        Make superbasic.

  200    hs(j)  = 2
         nS     = nS + 1

*        Save  x  values.

  250    if (abs(xj) .lt. bplus) x(j) = xj
         go to 300

*        Card ignored.

  290    ignord = ignord + 1
         if (iPrint .gt. 0  .and.  ignord .le. MPSerr) then
            write(iPrint, 2010) ncard, key, Name1, Name2
         end if
  300 continue

  310 ignord = ignord + notfnd
      if (iPrint .gt. 0) write(iPrint, 2050) ncard, ignord, nBS, nS
      if (iSumm  .gt. 0) write(iSumm , 2050) ncard, ignord, nBS, nS
      if (iInsrt  .ne. iRead) rewind iInsrt
      return

 1000 format(14x, 2a4, 2x, 3a4)
 1020 format(a4, a8, 2x, a8, 2x, e12.5)
 1999 format(/ ' INSERT file to be input from file', i4)
 2000 format(/ ' NAME', 10x, 2a4, 2x, 3a4)
 2010 format(' XXX  Line', i6, '  ignored:', 8x, a4, a8, 2x, a8)
 2050 format(/ ' No. of lines read      ', i6, '  Lines ignored', i6
     &       / ' No. of basics specified', i6, '  Superbasics  ', i6)

      end ! of s4inst

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4load( n, nb, nS, iObj,
     &     hs, x, Names, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     n, nb, nS, iObj, leniw, lenrw, hs(nb), iw(leniw)
      double precision
     &     x(nb), rw(lenrw)
      character*8
     &     Names(nb)

*     ==================================================================
*     s4load  inputs a load file, which may contain a full or partial
*     list of row and column names and their states and values.
*     Valid keys are   BS, LL, UL, SB.
*
*     15 Nov 1991: First version based on Minos 5.4 routine m4load.
*     04 Feb 1992: Current version.
*     ==================================================================
      character*8
     &     Name
      character*4
     &     lBS  , lLL  , lUL  , lSB  , lEND, key, id(5)
      data
     &     lBS  , lLL  , lUL  , lSB  , lEND
     &   /' BS ',' LL ',' UL ',' SB ','ENDA'/
      integer
     &     ignord, iLoadB, iPrint, iRead, iSumm, j, jmark, jObj, MPSerr,
     &     nBS, ncard, ndum, nloop, notfnd
      double precision
     &     bplus, xj, plInfy
*     ------------------------------------------------------------------
      plInfy    = rw( 70) ! definition of plus infinity.
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      iRead     = iw( 10) ! Standard Input
      iLoadB    = iw(122) ! load file
      MPSerr    = iw(106) ! maximum # errors in MPS data

      bplus  = 0.9d+0*plInfy
      if (iPrint .gt. 0) write(iPrint, 1999) iLoadB
      if (iSumm  .gt. 0) write(iSumm , 1999) iLoadB
                         read (iLoadB, 1000) id
      if (iPrint .gt. 0) write(iPrint, 2000) id
      ignord = 0
      nBS    = 0
      nS     = 0
      notfnd = 0
      ncard  = 0
      jmark  = 1
      ndum   = n + 100000

      if (iObj .eq. 0) then
         jObj = 0
      else
         jObj = n + iObj
      end if

*     Read names until ENDATA is found.

      do 300, nloop = 1, ndum
         read (iLoadB, 1020) key, Name, xj
         if (key .eq. lEND) go to 310

         ncard  = nloop
         call s4name( nb, iPrint, Names, Name,
     &        ncard, notfnd, MPSerr, 1, nb, jmark, j )
         if (j .le. 0) go to 300

*        The name Name belongs to the j-th variable.

         if (hs(j) .gt. 1) go to 290
         if (j   .eq.jObj) go to  90
         if (key .eq. lBS) go to  90
         if (key .eq. lLL) go to 100
         if (key .eq. lUL) go to 150
         if (key .eq. lSB) go to 200
         go to 290

*        Make basic.

   90    nBS    = nBS + 1
         hs(j)  = 3
         go to 250

*        LO or UP.

  100    hs(j)  = 0
         go to 250

  150    hs(j)  = 1
         go to 250

*        Make superbasic.

  200    nS     = nS + 1
         hs(j)  = 2

*        Save  x  values.

  250    if (abs(xj) .lt. bplus) x(j) = xj
         go to 300

*        Card ignored.

  290    ignord = ignord + 1
         if (ignord .le. MPSerr) then
            if (iPrint .gt. 0) write(iPrint, 2010) ncard, key, Name
         end if
  300 continue

  310 ignord = ignord + notfnd
      if (iPrint .gt. 0) write(iPrint, 2050) ncard, ignord, nBS, nS
      if (iSumm  .gt. 0) write(iSumm , 2050) ncard, ignord, nBS, nS

*     Make sure the linear Objective is basic.

      if (iObj  .gt. 0) then
         if (hs(jObj) .ne. 3) then
            hs(jObj) = 3

*           Swap Obj with last basic variable.

            do j = nb, 1, -1
               if (hs(j) .eq. 3) go to 860
            end do

  860       hs(j)  = 0
         end if
      end if

      if (iLoadB .ne. iRead) rewind iLoadB
      return

 1000 format(14x, 2a4, 2x, 3a4)
 1020 format(a4, a8, 12x, e12.5)
 1999 format(/ ' LOAD file to be input from file', i4)
 2000 format(/ ' NAME', 10x, 2a4, 2x, 3a4)
 2010 format(' XXX  Line', i6, '  ignored:', 8x, a4, a8, 2x, a8)
 2050 format(/ ' No. of lines read      ', i6, '  Lines ignored', i6
     &       / ' No. of basics specified', i6, '  Superbasics  ', i6)

      end ! of s4load

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4oldB( iError, m, n, nb, nS, hs, bl, bu, x,
     &     iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     iError, leniw, lenrw, m, n, nb, nS, hs(nb), iw(leniw)
      double precision
     &     bl(nb), bu(nb), x(nb), rw(lenrw)

*     ==================================================================
*     s4oldB  inputs a compact basis file from file  iOldB.
*
*     15 Nov 1991: First version based on Minos 5.4 routine m4OldB.
*     20 Apr 1999: Current version.
*     ==================================================================
      integer
     &     i, j, js, newm, newn, idummy, ndummy, iRead, iPrint, iSumm,
     &     iOldB, id(20)
      double precision
     &     plInfy, bplus, xj 
*     ------------------------------------------------------------------
      plInfy    = rw( 70) ! definition of plus infinity.

      iRead     = iw( 10) ! Standard Input
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      iOldB     = iw(126) ! old basis file

      bplus  = 0.9d+0*plInfy
      if (iPrint .gt. 0) write(iPrint, 1999) iOldB
      if (iSumm  .gt. 0) write(iSumm , 1999) iOldB
         read (iOldB , 1000) id
      if (iPrint .gt. 0) then
         write(iPrint, 2000) id
      end if

         read (iOldB , 1005) (id(i), i=1,13), newm, newn, nS
      if (iPrint .gt. 0) then
         write(iPrint, 2005) (id(i), i=1,13), newm, newn, nS
      end if

      if (newm .ne. m  .or.  newn .ne. n) go to 900
      read (iOldB , 1010) hs

*     Set values for nonbasic variables.

      do j = 1, nb
         js = hs(j)
         if (js .le. 1) then
            if (js .eq. 0) xj = bl(j)
            if (js .eq. 1) xj = bu(j)
            if (abs(xj) .lt. bplus) x(j) = xj
         end if
      end do

*     Load superbasics.

      nS     = 0
      ndummy = m + n + 10000

      do idummy = 1, ndummy
         read(iOldB, 1020) j, xj
         if (j .le.  0) go to 310
         if (j .le. nb) then
            x(j)  = xj
            if (hs(j) .eq. 2) nS = nS + 1
         end if
      end do

  310 if (nS .gt. 0) then
         if (iPrint .gt. 0) write(iPrint, 2010) nS
         if (iSumm  .gt. 0) write(iSumm , 2010) nS
      end if
      go to 990

*     Error exits.

*     -------------------------------------------
*     Incompatible basis file dimensions.
*     -------------------------------------------
  900 iError = 30
      call s1page( 1, iw, leniw )
      if (iPrint .gt. 0) write(iPrint, 9300)
      if (iSumm  .gt. 0) write(iSumm , 9300)

  990 if (iOldB .ne. iRead) rewind iOldB
      return

 1000 format(20a4)
 1005 format(13a4, 2x, i7, 3x, i7, 4x, i5)
 1010 format(80i1)
 1020 format(i8, e24.14)
 1999 format(/ ' OLD BASIS file to be input from file', i4)
 2000 format(1x, 20a4)
 2005 format(1x, 13a4,
     &       'm=', i7, ' n=', i7, ' sb=', i5)
 2010 format(' No. of superbasics loaded', i7)

 9300 format(  ' EXIT -- the basis file dimensions do not match',
     &         ' this problem')

      end ! of s4oldB

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4chek( m, maxS, mBS, n, nb,
     &     nS, iObj, hs, kBS, bl, bu, x, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     m, maxS, mBS, n, nb, nS, iObj, leniw, lenrw,
     &     hs(nb), kBS(mBS), iw(leniw)
      double precision
     &     bl(nb), bu(nb), x(nb), rw(lenrw)

*     ==================================================================
*     s4chek  takes hs and x and checks they contain reasonable values.
*     The entries hs(j) = 2 are used to set  nS  and possibly
*     the list of superbasic variables kBS(m+1) thru kBS(m+nS).
*     Scaling, if any, has taken place by this stage.
*
*     15 Nov 1991: First version based on Minos routine m4chek.
*     29 Jul 1999: Current version of s4chek.
*     ==================================================================
      integer
     &     iPrint, iSumm, j, jj, js, nBasic
      double precision
     &     b1, b2, bigBnd, plInfy, xj
*     ------------------------------------------------------------------
      double precision   zero,           tolb   
      parameter        ( zero = 0.0d+0,  tolb = 1.0d-4 )
*     ------------------------------------------------------------------
      plInfy    = rw( 70) ! definition of plus infinity.
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file

*     Make sure hs(j) = 0, 1, 2 or 3 only.

      do j = 1, nb
         js   = hs(j)
         if (js .lt. 0) hs(j) = 0
         if (js .ge. 4) hs(j) = js - 4
      end do

*     ------------------------------------------------------------------
*     Make sure the Objective is basic and free.
*     Then count the basics and superbasics, making sure they don't
*     exceed m and maxS respectively.  Also, set nS and possibly
*     kBS(m+1) thru kBS(m+ns) to define the list of superbasics.
*     Mar 1988: Loop 100 now goes backwards to make sure we grab Obj.
*     ------------------------------------------------------------------
      nBasic = 0
      nS     = 0

      if (iObj .gt. 0) then
         hs(n+iObj) =   3
         bl(n+iObj) = - plInfy
         bu(n+iObj) =   plInfy
      end if

*     If too many basics or superbasics, make them nonbasic.

      j = n

      do jj = 1, nb
         j       = j + 1
         if (j .gt. nb) j = 1
         js      = hs(j)
         if (js .eq. 2) then
            nS   = nS + 1
            if (nS .le. maxS) then
               kBS(m+nS) = j
            else
               hs(j)     = 0
            end if

         else if (js .eq. 3) then
            nBasic = nBasic + 1
            if (nBasic .gt. m) hs(j) = 0
         end if
      end do

*     Check the number of basics.

      nS     = min( nS, maxS )
      if (nBasic .ne. m ) then
         if (iPrint .gt. 0) write(iPrint, 1000) nBasic, m
         if (iSumm  .gt. 0) write(iSumm , 1000) nBasic, m
      end if

*     ------------------------------------------------------------------
*     Set each nonbasic x(j) to be exactly on its
*     nearest bound if it is within tolb of that bound.
*     ------------------------------------------------------------------
      bigBnd = 0.1d+0 * plInfy
      do j = 1, nb
         xj     = x(j)
         if (abs( xj ) .ge.  bigBnd) xj = zero
         if (hs(j)     .le.  1     ) then
            b1  = bl(j)
            b2  = bu(j)
            xj  = max( xj, b1 )
            xj  = min( xj, b2 )
            if (   (xj - b1) .gt. (b2 - xj)) b1 = b2
            if (abs(xj - b1) .le.  tolb    ) xj = b1
            hs(j) = 0
            if (xj .gt. bl(j)) hs(j) = 1
         end if
         x(j) = xj
      end do

      return

 1000 format(/ ' WARNING:', i7, ' basics specified;',
     &         ' preferably should have been', i7)

      end ! of s4chek

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4dump( iDump, nb, hs, x, Names, 
     &                   cw, lencw, iw, leniw )

      implicit
     &     none
      integer
     &     iDump, nb, lencw, leniw, hs(nb), iw(leniw)
      double precision
     &     x(nb)
      character*8
     &     Names(nb), cw(lencw)

*     ==================================================================
*     s4dump outputs basis names in a format compatible with s4load.
*     This file is normally easier to modify than a punch file.
*
*     15 Nov 1991: First version based on Minos 5.4 routine m4dump.
*     04 Feb 1992: Current version.
*     ==================================================================
      integer
     &     iPrint, iSumm, j, k
      character*8
     &     mProb
      character*4
     &     key(4)
      data
     &     key/' LL ', ' UL ', ' SB ', ' BS '/
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      mProb     = cw( 51) ! Problem name

      write(iDump, 2000) mProb

      do j = 1, nb
         k = hs(j) + 1
         write(iDump, 2100) key(k), Names(j), x(j)
      end do

      write(iDump , 2200)
      if (iPrint .gt. 0) write(iPrint, 3000) iDump
      if (iSumm  .gt. 0) write(iSumm , 3000) iDump
      if (iDump .ne. iPrint) rewind iDump
      return

 2000 format('NAME', 10x, a8, 2x, '   DUMP/LOAD')
 2100 format(a4, a8, 12x, 1p, e12.5)
 2200 format('ENDATA')
 3000 format(/ ' DUMP file saved on file', i4)

      end ! of s4dump

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4newB( job, iNewB, minimz, m, n, nb,
     &     nS, mBS, itn, nInf, sInf, f, kBS, hs, 
     &     Ascale, bl, bu, x, xBS, istate,
     &     cw, lencw, iw, leniw )

      implicit
     &     none
      integer
     &     job, iNewB, minimz, m, n, nb, nS, mBS, itn, nInf,
     &     lencw, leniw, hs(nb), kBS(mBS), iw(leniw)
      double precision
     &     sInf, f, Ascale(nb), bl(nb), bu(nb), xBS(mBS), x(nb)
      character*4
     &     istate(3)
      character*8
     &     cw(lencw)

*     ==================================================================
*     s4newB  saves a compact basis on file iNewB.  Called from S5QP.
*     job = Freq, the save is a periodic one due to the save frequency.
*     job = Wrap, S5solv has just finished the current problem.
*
*     15 Nov 1991: First version based on Minos 5.4 routine m4newb.
*     29 Jul 1999: Current version.
*     ==================================================================
      character*8
     &     mProb, mObj, mRhs, mRng, mBnd 
      logical
     &     scaled
      integer
     &     iPrint, iSumm, lvlScl, j, k, nnJac
      double precision
     &     Obj, xj
*     ------------------------------------------------------------------
      integer            Freq,     Wrap
      parameter         (Freq = 0, Wrap = 1)
*     ------------------------------------------------------------------
      if (job .ne. Freq  .or.  job .ne. Wrap) return

      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      nnJac     = iw( 21) ! # nonlinear Jacobian variables
      lvlScl    = iw( 75) ! scale option

      mProb     = cw( 51) ! Problem name 
      mObj      = cw( 52) ! Objective name
      mRhs      = cw( 53) ! Right-hand side name
      mRng      = cw( 54) ! Range name
      mBnd      = cw( 55) ! Bnd section name

      scaled    = lvlScl .gt. 0

      if (nInf .eq. 0) then
         Obj = minimz * f
      else
         Obj = sInf
      end if

*     Output header cards and the state vector.

      write(iNewB, 1000) mProb, itn , istate, nInf, Obj
      write(iNewB, 1005) mObj , mRhs, mRng  , mBnd, m, n, nS
      write(iNewB, 1010) hs

*     Output the superbasic variables.

      do k  = m+1, m+nS
         j  = kBS(k)
         xj = xBS(k)
         if (scaled) xj = xj * Ascale(j)
         write(iNewB, 1020) j, xj
      end do

*     Output the values of all other (non-SB) nonlinear variables.

      do j = 1, nnJac
         if (hs(j) .ne. 2) then
            xj    = x(j)
            if (scaled) xj = xj * Ascale(j)
            write(iNewB, 1020) j, xj
         end if
      end do

*     Output nonbasic variables that are not at a bound.

      do j = nnJac+1, nb
         if (hs(j) .le. 1 ) then
            xj    = x(j)
            if (xj .ne. bl(j)) then
               if (xj .ne. bu(j)) then
                  if (scaled) xj = xj * Ascale(j)
                  write(iNewB, 1020) j, xj
               end if
            end if
         end if
      end do

*     Terminate the list with a zero.

      j     = 0
      write(iNewB, 1020) j
      if (iNewB .ne. iPrint) rewind iNewB
      if (iPrint .gt. 0) write(iPrint, 1030) iNewB, itn
      if (iSumm  .gt. 0) write(iSumm , 1030) iNewB, itn
      return

 1000 format(a8, '  ITN', i8, 4x, 3a4, '  NINF', i7,
     &       '      OBJ', 1p, e21.12)
 1005 format('OBJ=',a8, ' RHS=',a8, ' RNG=',a8, ' BND=',a8,
     &       ' M=', i7,  ' N=', i7, ' SB=', i5)
 1010 format(80i1)
 1020 format(i8, 1p, e24.14)
 1030 format(/ ' NEW BASIS file saved on file', i4, '    itn =', i7)

      end ! of s4newB

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4pnch( iPnch, n, nb, hs, bl, x, Names,
     &     cw, lencw, iw, leniw )

      implicit
     &     none
      integer
     &     iPnch, n, nb, lencw, leniw, hs(nb), iw(leniw)
      double precision
     &     bl(nb), x(nb)
      character*8
     &     Names(nb), cw(lencw)

*     ==================================================================
*     s4pnch  outputs a PUNCH file (list of basis names, states and
*     values) in a format that is compatible with MPS/360.
*
*     15 Nov 1991: First version based on Minos 5.4 routine m4pnch.
*     04 Feb 1992: Current version.
*     ==================================================================
      integer
     &     iPrint, iSumm, irow, j, k
      character*8
     &     lblank, ColNm, mProb, Name
      character*4
     &     key(5)
      data
     &     key  /' LL ', ' UL ', ' SB ', ' XL ', ' XU '/
      data
     &     lblank  /'        '/
*     ------------------------------------------------------------------
      double precision   zero
      parameter         (zero = 0.0d+0)
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      mProb     = cw( 51) ! Problem name

      write(iPnch, 2000) mProb
      irow      = n

      do 500,  j = 1, n
         ColNm   = Names(j)
         k       = hs(j)

         if (k .eq. 3) then

*           Basics -- find the next row that isn't basic.

  300       irow   = irow + 1
            if (irow .le. nb) then
               k      = hs(irow)
               if (k .eq. 3) go to 300

               if (k .eq. 2) k = 0
               Name = Names(j)
               write(iPnch, 2100) key(k+4), ColNm, Name, x(j)
            end if
         else

*           Skip nonbasic variables with zero lower bounds.

            if (k .le. 1) then
               if (bl(j) .eq. zero  .and.  x(j) .eq. zero) go to 500
            end if
            write(iPnch, 2100) key(k+1), ColNm, lblank, x(j)
         end if
  500 continue

*     Output superbasic slacks.

      do j = n+1, nb
         if (hs(j) .eq. 2) then
            Name = Names(j)
            write(iPnch, 2100) key(3), Name, lblank, x(j)
         end if
      end do

      write(iPnch , 2200)
      if (iPrint .gt. 0) write(iPrint, 3000) iPnch
      if (iSumm  .gt. 0) write(iSumm , 3000) iPnch
      if (iPnch .ne. iPrint) rewind iPnch
      return

 2000 format('NAME', 10x, a8, 2x, 'PUNCH/INSERT')
 2100 format(a4, a8, 2x, a8, 2x, 1p, e12.5)
 2200 format('ENDATA')
 3000 format(/ ' PUNCH file saved on file', i4)

      end ! of s4pnch

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4rept( ondisk, m, n, nb, nName,
     &     nnCon, nnObj, nS,
     &     ne, nlocA, locA, indA, Acol,
     &     hs, Ascale, bl, bu, Gobj, pi, x, Fx,
     &     Names, istate, iw, leniw )

      implicit
     &     none
      logical
     &     ondisk
      integer
     &     nName, m, n, nb, ne, nlocA, nnCon, nnObj, nS, leniw,
     &     indA(ne), hs(nb), locA(nlocA), iw(leniw)
      double precision
     &     Acol(ne), Ascale(nb), bl(nb), bu(nb), Gobj(*), pi(m),
     &     x(nb), Fx(*)
      character*8
     &     Names(nName)
      character*4
     &     istate(3)

*     ==================================================================
*     s4rept  has the same parameter list as s4soln, the routine that
*     prints the solution.  It will be called if the SPECS file
*     specifies  REPORT file  n  for some positive value of  n.
*
*     pi contains the unscaled dual solution.
*     x contains the unscaled primal solution.  There are n + m = nb
*        values (n structural variables and m slacks, in that order).
*     y  contains the true slack values for nonlinear constraints
*        in its first nnCon components (computed by s8nslk).
*
*     This version of s4rept does nothing.    Added for PILOT, Oct 1985.
*
*     15 Nov 1991: First version based on Minos 5.4 routine m4rept.
*     26 Mar 2000: Updated for SNOPT 6.1.
*     07 Jul 2000: Current version of s4rept.
*     ==================================================================
      integer
     &     iPrint, iSumm
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file

      if (iPrint .gt. 0) write(iPrint, 1000)
      if (iSumm  .gt. 0) write(iSumm , 1000)
      return

 1000 format(/ ' XXX Report file requested.  s4rept does nothing.')

      end ! of s4rept

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4savB( Task, iError, minimz, m, n, nb,
     &     nnCon0, nnCon, nGobj0, nGobj, nName, nS,
     &     itn, nInf, sInf, wtInf, vimax, iObj, sclObj, ObjTru,
     &     pNorm1, pNorm2, piNorm, xNorm,
     &     ne, nlocJ, locJ, indJ, Jcol,
     &     hEstat, hs, Ascale, bl, bu, Fx, Gobj,
     &     Names, pi, rc, x, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     Task, iError, minimz, itn, iObj, nInf, m, n,
     &     nb, ne, nlocJ, nnCon0, nnCon, nGobj0, nGobj, nName, nS,
     &     lencw, leniw, lenrw, locJ(nlocJ), indJ(ne), hEstat(nb),
     &     hs(nb), iw(leniw)
      double precision
     &     ObjTru, pNorm1, pNorm2, piNorm, sInf, sclObj, vimax, wtInf,
     &     xNorm, Jcol(ne), Ascale(nb), bl(nb), bu(nb), Fx(nnCon0),
     &     Gobj(nGobj0), rc(nb), x(nb), pi(m), rw(lenrw)
      character*8
     &     Names(nName), cw(lencw)

*     ==================================================================
*     s4savB  saves basis files  and/or  prints the solution.
*
*     If Task = SaveB, the problem is first unscaled, then from 0 to 4 
*     files are saved (Punch file, Dump file, Solution file, 
*     Report file, in that order).
*     A new BASIS file, if any, will already have been saved by s8SQP.
*
*     A call with Task = Save  must precede a call with Task = Print.
*
*     If Task = PrintS, the solution is printed under the control of 
*     lprSol (which is set by the solution keyword in the specs file).
*
*     15 Nov 1991: First version based on Minos 5.4 routine m4savb.
*     19 Feb 1994: Use s4rc to compute reduced costs.
*     05 Apr 1996: s2rcA called to get the reduced costs (as in
*                  Minos 5.5). Maximum primal and dual infeasibilities 
*                  computed and printed here. 
*     14 Jul 1997: Thread-safe version.
*     26 Mar 2000: Updated for SNOPT 6.1.
*     30 Oct 2000: Current version of s4savB.
*     ==================================================================
      character*4
     &     istate(3)
      logical
     &     feasbl, prnt
      integer
     &     iPrint, iSumm, iReprt, iSoln, lvlScl,
     &     lprSol, jbInf, jbInf1, jdInf, jdInf1, k, maxvi
      double precision
     &     bInf, bInf1, dInf, dInf1, tolx, plInfy, xNorm1, dnrm1s
*     ------------------------------------------------------------------
      integer            UnScal
      parameter         (UnScal = 1)
      integer            SaveB,     PrintS
      parameter         (SaveB = 0, PrintS = 1)
      double precision   one
      parameter         (one = 1.0d+0)
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      iReprt    = iw(130) ! Report file
      iSoln     = iw(131) ! Solution file

      lvlScl    = iw( 75) ! scale option
      lprSol    = iw( 84) ! > 0    =>  print the solution 

      tolx      = rw( 56) ! Minor feasibility tolerance.
      plInfy    = rw( 70) ! definition of plus infinity.

      feasbl    = nInf .eq. 0
      k         = 1 + iError
      call s4stat( k, istate )

      if (Task .eq. SaveB) then
*        ---------------------------------------------------------------
*        Compute rc and unscale Jcol, bl, bu, g, pi, x, xNorm
*        and piNorm (but s4soln uses scaled piNorm, so save it).
*        Then save basis files.
*        ---------------------------------------------------------------
*        Compute reduced costs rc(*) for all columns and rows.

         call s2rcA ( feasbl, tolx, iObj, minimz, wtInf,
     &        m, n, nb, nGobj0, nGobj, ne, nlocJ, locJ, indJ, Jcol,
     &        hEstat, hs, bl, bu, Gobj, pi, rc, x )
         call s2bInf( nb, bl, bu, x, bInf, jbInf )
         call s2dInf( n, nb, iObj, bl, bu, rc, x, dInf, jdInf )

         jbInf1 = jbInf
         jdInf1 = jdInf
          bInf1 =  bInf
          dInf1 =  dInf

         pNorm1 = piNorm
         xNorm1 = xNorm

         if (lvlScl .gt. 0) then
            call s2scla( UnScal, m, n, nb, iObj, plInfy, sclObj, 
     &           ne, nlocJ, locJ, indJ, Jcol,
     &           Ascale, bl, bu, pi, x )

            call dddiv ( nb , Ascale, 1, rc, 1 )

            if (lvlScl .eq. 2) then
               if (nnCon .gt. 0) 
     &         call ddscl ( nnCon, Ascale(n+1), 1, Fx  , 1 )
               if (nGobj .gt. 0) 
     &         call dddiv ( nGobj, Ascale     , 1, Gobj, 1 )
            end if

            xNorm  =      dnrm1s( n,  x, 1 )
            piNorm = max( dnrm1s( m, pi, 1 ), one )
            call s2bInf( nb, bl, bu, x, bInf, jbInf )
            call s2dInf( n, nb, iObj, bl, bu, rc, x, dInf, jdInf )
         end if
         pNorm2 = piNorm

*        ---------------------------------------------------------------
*        Print various scaled and unscaled norms.
*        ---------------------------------------------------------------
         if (lvlScl .gt. 0) then
            if (iPrint .gt. 0) write(iPrint, 1010) xNorm1, pNorm1
            if (iSumm  .gt. 0) write(iSumm , 1010) xNorm1, pNorm1
         end if
            if (iPrint .gt. 0) write(iPrint, 1020) xNorm , piNorm
            if (iSumm  .gt. 0) write(iSumm , 1020) xNorm , piNorm
         if (lvlScl .gt. 0) then
            if (iPrint .gt. 0) write(iPrint, 1030) jbInf1, bInf1 ,
     &                                             jdInf1, dInf1
            if (iSumm  .gt. 0) write(iSumm , 1030) jbInf1, bInf1 ,
     &                                             jdInf1, dInf1
         end if
            if (iPrint .gt. 0) write(iPrint, 1040) jbInf , bInf  ,
     &                                             jdInf , dInf
            if (iSumm  .gt. 0) write(iSumm , 1040) jbInf , bInf  ,
     &                                             jdInf , dInf 

*        Change the sign of pi and rc if feasible and maximizing.

         if (nInf .eq. 0  .and.  minimz .lt. 0) then
            call dscal ( m , (-one), pi, 1 )
            call dscal ( nb, (-one), rc, 1 )
         end if

*        Compute nonlinear constraint infeasibilities (violations).

         if (nnCon .gt. 0) then
            call s2vmax( n, nnCon, maxvi, vimax, bl, bu, Fx )
            if (iPrint .gt. 0) write(iPrint, 1080) vimax
            if (iSumm  .gt. 0) write(iSumm , 1080) vimax
         end if

*        Output Solution and/or Report files.

         piNorm = pNorm1
         if (iSoln .gt. 0) then
            call s4soln( .true., minimz, m, n, nb, nName,
     &           nnCon, nGobj, nS, iObj, 
     &           itn, nInf, sInf, ObjTru, piNorm, Names,
     &           ne, nlocJ, locJ, indJ, Jcol,
     &           hs, Ascale, bl, bu,
     &           Gobj, pi, rc, x, Fx, istate, 
     &           cw, lencw, iw, leniw, rw, lenrw )
         end if

         if (iReprt .ge. 91  .and.  iReprt .le. 93) then
            call s2xmat( iReprt, n, nb,
     &           ne, nlocJ, locJ, indJ, Jcol, hs )
         else if (iReprt .gt. 0) then
            call s4rept( .true., m, n, nb, nName,
     &           nnCon, nGobj, nS,
     &           ne, nlocJ, locJ, indJ, Jcol,
     &           hs, Ascale, bl, bu, Gobj, pi, x, Fx,
     &           Names, istate, iw, leniw )
         end if
         piNorm = pNorm2

      else if (Task .eq. PrintS) then
*        ---------------------------------------------------------------
*        Print solution if requested.
*
*        lprSol = 0   means   no
*               = 1   means   if optimal, infeasible or unbounded
*               = 2   means   yes
*               = 3   means   if error condition
*        ---------------------------------------------------------------
         prnt   = iPrint .gt. 0  .and.  lprSol .gt. 0
         if ((lprSol .eq. 1  .and.  iError .gt. 2)  .or.
     &       (lprSol .eq. 3  .and.  iError .le. 2)) prnt = .false.

         if ( prnt ) then
            piNorm = pNorm1
            call s4soln( .false., minimz, m, n, nb, nName,
     &           nnCon, nGobj, nS, iObj, 
     &           itn, nInf, sInf, ObjTru, piNorm, Names,
     &           ne, nlocJ, locJ, indJ, Jcol,
     &           hs, Ascale, bl, bu,
     &           Gobj, pi, rc, x, Fx, istate, 
     &           cw, lencw, iw, leniw, rw, lenrw )
            piNorm = pNorm2
            if (iSumm  .gt. 0) write(iSumm, 1200) iPrint
         else
            if (iSumm  .gt. 0) write(iSumm, 1300)
         end if
      end if

      return

 1010 format(  ' Norm of x   (scaled)', 1p, e17.1,
     &     2x, ' Norm of pi  (scaled)',     e17.1)
 1020 format(  ' Norm of x ', 1p, e27.1,
     &     2x, ' Norm of pi',     e27.1)
 1030 format(  ' Max Prim inf(scaled)', i9, 1p, e8.1,
     &     2x, ' Max Dual inf(scaled)', i9,     e8.1)
 1040 format(  ' Max Primal infeas   ', i9, 1p, e8.1,
     &     2x, ' Max Dual infeas     ', i9,     e8.1)
 1080 format(  ' Nonlinear constraint violn', 1p, e11.1)

 1200 format(/ ' Solution printed on file', i4)
 1300 format(/ ' Solution not printed')

      end ! of s4savB

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4soln( ondisk, minimz, m, n, nb, nName,
     &     nnCon, nGobj, nS, iObj,
     &     itn, nInf, sInf, Objtru, piNorm, Names,
     &     ne, nlocA, locA, indA, Acol,
     &     hs, Ascale, bl, bu,
     &     Gobj, pi, rc, x, Fx, istate, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      logical
     &     ondisk
      integer
     &     minimz, nInf, itn, m, n, nb, ne, nlocA, nName,
     &     nnCon, nGobj, nS, iObj, lencw, leniw, lenrw,
     &     indA(ne), hs(nb), locA(nlocA), iw(leniw)
      double precision
     &     Objtru, piNorm, sInf,
     &     Acol(ne), Ascale(nb), bl(nb), bu(nb), x(nb), Gobj(*),
     &     rc(nb), pi(m), Fx(*), rw(lenrw)
      character*4
     &     istate(3)
      character*8
     &     Names(nName), cw(lencw)

*     ==================================================================
*     s4soln  is the standard output routine for printing the solution.
*
*     On entry,
*     pi    contains the dual solution.
*     x     contains the primal solution.  There are n + m = nb values
*           (n structural variables and m slacks, in that order).
*     Fx    contains the true slack values for nonlinear constraints.
*
*     All quantities a, bl, bu, pi, x, Fx, g are unscaled,
*     but certain quantities are rescaled before tests are
*     applied.   (f is not used here.)
*
*     If ondisk is true, the solution is output to the solution file.
*     Otherwise, it is output to the printer.
*
*     15 Nov 1991: First version based on Minos 5.4 routine m4soln.
*     26 Jul 1996: Slacks modified.
*     26 Mar 2000: Updated for SNOPT 6.1.
*     21 Jul 2000: Current version of s4soln.
*     ==================================================================
      character*8
     &     mProb, mObj, mRhs, mRng, mBnd, Objtyp(3), id
      logical
     &     feasbl, infsbl, maximz, scaled
      integer
     &     iPrint, iSumm, iSoln, lvlScl, i, iloop, ir, j, jloop, js,
     &     k, lpr             
      double precision
     &     tolNLP, tolOpt, tolx, tolCon, plInfy, b1, b2, bplus, cj,
     &     d1, d2, dj, djtest, scale, slk, tolFea, py, row, xj
*     ------------------------------------------------------------------
      double precision   zero,          one   
      parameter         (zero = 0.0d+0, one = 1.0d+0)
      character*8        cdummy
      parameter         (cdummy = '-1111111')
      data               Objtyp /'Max     ', 'Feas    ', 'Min     '/
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      iSoln     = iw(131) ! Solution file

      tolNLP    = rw( 53) ! Major Optimality tolerance
      tolx      = rw( 56) ! Minor feasibility tolerance.
      tolCon    = rw( 57) ! Major feasibility tolerance.
      plInfy    = rw( 70) ! definition of plus infinity.

      lvlScl    = iw( 75) ! scale option

      mProb     = cw( 51) ! Problem name 
      mObj      = cw( 52) ! Objective name
      mRhs      = cw( 53) ! Right-hand side name
      mRng      = cw( 54) ! Range name
      mBnd      = cw( 55) ! Bnd section name

      bplus     = 0.1d+0*plInfy
      scale     = one
      feasbl    = nInf   .eq. 0
      infsbl    = .not. feasbl
      maximz    = minimz .lt. 0
      scaled    = lvlScl .gt. 0
      lpr       = iPrint
      if ( ondisk ) lpr = iSoln

      call s1page( 1, iw, leniw )
      if (infsbl) write(lpr, 1000) mProb, nInf, sInf
      if (feasbl) write(lpr, 1002) mProb, Objtru
      write(lpr, 1004) istate, itn, nS
      if (mObj .ne. cdummy) 
     &     write(lpr, 1005) mObj, Objtyp(minimz+2)(1:3),
     &                      mRhs, mRng, mBnd
      write(lpr, 1010)
      tolOpt = tolNLP * pinorm

*     ------------------------------------------------------------------
*     Output the ROWS section.
*     ------------------------------------------------------------------
      do iloop = 1, m
         i      = iloop
         j      = n + i
         if (scaled) scale = Ascale(j)
         js     = hs(j)
         b1     = bl(j)
         b2     = bu(j)
         xj     = x (j)
         py     = pi(i)
         dj     = rc(j)

*        Define the row value and slack activities.
*        The slack activity is the distance of the row value to its
*        nearest bound. (For a free row, it is just the row value).

         if (i .le. nnCon) then
            xj     = Fx(i)
            tolFea = tolCon
         else
            tolFea = tolx
         end if

         row    =      xj
         d1     = b1 - xj
         d2     = xj - b2

         slk    =    - d1
         if (abs( d1  )  .gt.  abs( d2 )) slk =  d2
         if (abs( slk )  .ge.  bplus    ) slk = row
         d1     =   d1 / scale
         d2     =   d2 / scale
         djtest = - dj * scale
         if (feasbl) then
            if (   maximz   ) djtest =  - djtest
         end if

         call s4id  ( j, n, nb, nName, Names, id )
         call s4solp( ondisk, iPrint, bplus, tolFea, tolOpt,
     &        js, d1, d2, djtest, j, id, row, slk, b1, b2, py, i )
      end do

*     ------------------------------------------------------------------
*     Output the COLUMNS section.
*     ------------------------------------------------------------------
      call s1page( 1, iw, leniw )
      write(lpr, 1020)
      tolFea = tolx

      do jloop = 1, n
         j     = jloop
         if (scaled) scale = Ascale(j)
         js     = hs(j)
         b1     = bl(j)
         b2     = bu(j)
         xj     = x(j)
         cj     = zero
         dj     = rc(j)

         do k = locA(j), locA(j+1)-1
            ir = indA(k)
            if (ir .eq. iObj) cj = Acol(k)
         end do

         d1     =   (b1 - xj) / scale
         d2     =   (xj - b2) / scale
         djtest = - dj * scale
         if (feasbl) then
            if (j .le. nGobj) cj     =   cj + Gobj(j)
            if (   maximz   ) djtest = - djtest
         end if

         call s4id  ( j, n, nb, nName, Names, id )
         call s4solp( ondisk, iPrint, bplus, tolFea, tolOpt,
     &        js, d1, d2, djtest, j, id, xj, cj, b1, b2, dj, m+j )
      end do

      if (ondisk) then
         if (iSoln  .ne. iPrint) rewind iSoln
         if (iPrint .gt. 0     ) write(iPrint, 1400) iSoln
         if (iSumm  .gt. 0     ) write(iSumm , 1400) iSoln
      end if
      return

 1000 format(' Name', 11x, a8, 16x,
     &   ' Infeasibilities', i7, 1p, e16.4)
 1002 format(' Name', 11x, a8, 16x,
     &   ' Objective Value', 1p, e22.10)
 1004 format(/ ' Status', 9x, 3a4, 12x,
     &   ' Iteration', i7, '    Superbasics', i6)
 1005 format(/
     &   ' Objective', 6x, a8, ' (', a3, ')' /
     &   ' RHS      ', 6x, a8 /
     &   ' Ranges   ', 6x, a8 /
     &   ' Bounds   ', 6x, a8)
 1010 format(/ ' Section 1 - Rows' //
     &   '  Number  ...Row.. State  ...Activity...  Slack Activity',
     &   '  ..Lower Limit.  ..Upper Limit.  .Dual Activity    ..i' /)
 1020 format(  ' Section 2 - Columns' //
     &   '  Number  .Column. State  ...Activity...  .Obj Gradient.',
     &   '  ..Lower Limit.  ..Upper Limit.  Reduced Gradnt    m+j' /)
 1400 format(/ ' SOLUTION file saved on file', i4)

      end ! of s4soln

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4solp( ondisk, iPrint, bplus, tolFea, tolOpt,
     &     js,  d1,  d2, djtest, j, id, xj, cj, b1, b2, dj, k )

      implicit
     &     none
      character*8
     &     id
      logical
     &     ondisk
      integer
     &     iPrint, js, j, k
      double precision
     &     bplus, tolFea, tolOpt, d1, d2, djtest, xj, cj, b1, b2, dj

*     ==================================================================
*     s4solp  prints one line of the Solution file.
*
*     The following conditions are marked by key:
*
*        D  degenerate basic or superbasic variable.
*        I  infeasible basic or superbasic variable.
*        A  alternative optimum      (degenerate nonbasic dual).
*        N  nonoptimal superbasic or nonbasic (infeasible dual).
*
*     Tests for these conditions are performed on scaled quantities
*     d1, d2, djtest,
*     since the correct indication is then more likely to be given.
*     On badly scaled problems, the unscaled solution may then appear
*     to be flagged incorrectly, but this is just an illusion.
*
*     15 Nov 1991: First version based on Minos 5.4 routine m4solp.
*     18 Oct 1993: Replaced by modified Minos 5.4 routine m4solp.
*                  Infinite bounds and certain other values treated
*                  specially.
*     20 Apr 1999: Current version.
*     ==================================================================
      character*111
     &     line
      character*4
     &     jstat, jstate(0:5)
      character*1
     &     key, lblank, laltop, ldegen, linfea, lnotop
      character*16
     &     lzero, lone, lmone
*     ------------------------------------------------------------------
      double precision   zero,           one
      parameter        ( zero = 0.0d+0,  one = 1.0d+0 )
      data               jstate /' LL ', ' UL ', 'SBS ',
     &                           ' BS' , ' EQ' , ' FR '/
      data               lblank /' '/, lAltOp /'A'/, ldegen /'D'/,
     &                   linfea /'I'/, lNotOp /'N'/
      data               lzero  /'          .     '/
      data               lone   /'         1.0    '/
      data               lmone  /'        -1.0    '/
*     ------------------------------------------------------------------
      key    = lblank
      if (js .eq. -1) js = 2

      if (js .le.  1) then

*        Set key for nonbasic variables.

         if (b1 .eq. b2) js = 4
         if (- d1 .gt. tolFea  .and.  - d2 .gt. tolFea) js = 5
         if (js .eq. 1 ) djtest = - djtest
         if (js .ge. 4 ) djtest =   abs( djtest )
         if (             abs( djtest ) .le. tolOpt) key = lAltOp
         if (js .ne. 4  .and.  djtest   .gt. tolOpt) key = lNotOp
      else

*        Set key for basic and superbasic variables.

         if (abs(   d1   ) .le. tolFea  .or.
     &       abs(   d2   ) .le. tolFea) key = ldegen
         if (           js .eq. 2       .and.
     &       abs( djtest ) .gt. tolOpt) key = lNotOp
         if (           d1 .gt. tolFea  .or.
     &                  d2 .gt. tolFea) key = linfea
      end if

*     Select format for printing.

      jstat   = jstate(js)
      if (ondisk) then
         write(line, 1000) j, id, key, jstat, xj,cj, b1,b2, dj,k
      else
         if (b2 .lt. bplus) then
            if (b1 .gt. - bplus) then
               write(line, 1200) j,id,key,jstat,xj,cj,b1,b2,dj,k
            else
               write(line, 1300) j,id,key,jstat,xj,cj,   b2,dj,k
            end if
         else
            if (b1 .gt. - bplus) then
               write(line, 1400) j,id,key,jstat,xj,cj,b1,   dj,k
            else
               write(line, 1500) j,id,key,jstat,xj,cj,      dj,k
            end if
         end if
      end if

*     Test for 0.0, 1.0 and -1.0

      if (xj .eq. zero) line(25:40) = lzero
      if (xj .eq.  one) line(25:40) = lone
      if (xj .eq. -one) line(25:40) = lmone
      if (cj .eq. zero) line(41:56) = lzero
      if (cj .eq.  one) line(41:56) = lone
      if (cj .eq. -one) line(41:56) = lmone
      if (b1 .eq. zero) line(57:72) = lzero
      if (b1 .eq.  one) line(57:72) = lone
      if (b1 .eq. -one) line(57:72) = lmone
      if (b2 .eq. zero) line(73:88) = lzero
      if (b2 .eq.  one) line(73:88) = lone
      if (b2 .eq. -one) line(73:88) = lmone
      if (dj .eq. zero) line(89:104)= lzero
      if (dj .eq.  one) line(89:104)= lone
      if (dj .eq. -one) line(89:104)= lmone

      write(iPrint, 2000) line
      return

 1000 format(i8, 2x, a8, 1x, a1, 1x, a3, 1p, 5e16.6, i7)
 1200 format(i8, 2x, a8, 1x, a1, 1x, a3, 5f16.5, i7)
 1300 format(i8, 2x, a8, 1x, a1, 1x, a3, 2f16.5,
     &   '           None ', f16.5, f16.5, i7)
 1400 format(i8, 2x, a8, 1x, a1, 1x, a3, 2f16.5,
     &   f16.5, '           None ', f16.5, i7)
 1500 format(i8, 2x, a8, 1x, a1, 1x, a3, 2f16.5,
     &   '           None ', '           None ', f16.5, i7)
 2000 format(a)

      end !of s4solp

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s4stat( k, istate )

      implicit
     &     none
      integer
     &     k
      character*4
     &     istate(3)

*     ==================================================================
*     s4stat loads istate(*) with words describing the current state.
*
*     15 Nov 1991: First version based on Minos 5.4 routine m4stat.
*     20 Apr 1999: Current version.
*     ==================================================================
      integer
     &     i, j
      character*4
     &     c(18)
      data 
     &     c /'Proc', 'eedi', 'ng  ',
     &        'Opti', 'mal ', 'Soln',
     &        'Infe', 'asib', 'le  ',
     &        'Unbo', 'unde', 'd   ',
     &        'Exce', 'ss i', 'tns ',
     &        'Erro', 'r co', 'ndn '/
*     ------------------------------------------------------------------
      j    = 3*min( k, 5 )
      do i = 1, 3
         istate(i) = c(j+i)
      end do

      end ! of s4stat
