*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
*     File  sn57qopt.f
*
*     s5dflt   s5Mem   s5solv   s5SQP
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5dflt( Task, cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     Task, lencw, leniw, lenrw,
     &     iw(leniw)
      character*8
     &     cw(lencw)
      double precision
     &     rw(lenrw)

*     ==================================================================
*     s5dflt checks and possibly prints the optional parameter values
*     for sqopt. 
*
*     Optional parameters are checked and, if necessary,  changed to
*     reasonable values.  If  task = PrintO, and if iPrint > 0 and
*     lprPrm > 0, the parameters are printed.  (In the specs file,
*     Suppress parameters sets iw(3) = 0.)
* 
*     Note that checking occurs before the amount of working storage has
*     been defined. 
*
*     See  snworkspace.f  for full documentation of cw, iw and rw.
*
*     15 Nov 1991: first version.
*     31 Oct 2000: Current version of s5dflt.
*     ==================================================================
      logical
     &     QP
      integer
     &     iCrash, iBack, iDump, iLoadB, iMPS, iNewB, iInsrt, iOldB,
     &     iPnch, iPrint, iRead, iReprt, iSoln, iSpecs, itnlim, kchk,
     &     kDegen, kFac, klog, kReset, ksav, kSumm, lEmode, lprDbg,
     &     lprPrm, lprScl, lprSol, LUprnt, lvlInf, lvlPiv, lvlPrt,
     &     lvlScl, lvlSrt, lvlTim, m, maxmn, maxCol, maxR, maxS, mflush,
     &     minimz, minmax, minPrc, mMinor, MjrPrt, MnrPrt, mSkip,
     &     mWSmod, n, nColH, nGobj, never, nnH, nout, nParPr, nPr1,
     &     nPr2, nQP
      double precision
     &     bigdx, bigFx, c4, c6, chzbnd, Dens1, Dens2, eLmax1, eLmax2,
     &     eps, eps0, eps1, eps2, eps3, eps4, Hcndbd, plInfy, rmaxS,
     &     scltol, small, tCrash, toldj3, tolFac, tolFP, tolpiv, tolQP,
     &     tolRow, tolSwp, tolUpd, tolx, Uspace, Utol1, Utol2,
     &     wtInf0, xdlim
      character*24
     &     prbtyp(3)
      data 
     &     prbtyp /' Maximize...............',
     &             ' Feasible point only....',
     &             ' Minimize...............'/
*     ------------------------------------------------------------------
      integer            PrintO
      parameter         (PrintO = 1 ) 
      integer            idummy
      parameter         (idummy = -11111)
      double precision   zero,             one
      parameter         (zero   =  0.0d+0, one    = 1.0d+0)
      double precision   tenp6,            hundrd 
      parameter         (tenp6  = 1.0d+6,  hundrd = 100.0d+0)
*     ------------------------------------------------------------------
*     Set some local machine-dependent constants.

      eps       = rw(  1) ! unit round-off.
      eps0      = rw(  2) ! eps**(4/5)
      eps1      = rw(  3) ! eps**(2/3)
      eps2      = rw(  4) ! eps**(1/2)
      eps3      = rw(  5) ! eps**(1/3)
      eps4      = rw(  6) ! eps**(1/4)

*     ------------------------------------------------------------------
*     rw(51)--rw(150): optional parameters set via the specs file.
*     ------------------------------------------------------------------
      tolFP     = rw( 51) ! Minor Phase 1 Opt tol
      tolQP     = rw( 52) ! Minor Phase 2 Opt tol

      tolx      = rw( 56) ! Minor feasibility tolerance.

      tolpiv    = rw( 60) ! excludes small elements of y.
      tolrow    = rw( 61) ! tolerance for the row error.
      tCrash    = rw( 62) ! crash tolerance.

      tolswp    = rw( 65) ! LU swap tolerance.
      tolfac    = rw( 66) ! LU factor tolerance.
      tolupd    = rw( 67) ! LU update tolerance.
      plInfy    = rw( 70) ! definition of plus infinity.
      bigFx     = rw( 71) ! unbounded objective.
      bigdx     = rw( 72) ! unbounded step.
      xdlim     = rw( 80) ! Step limit
      Hcndbd    = rw( 85) ! bound on the condition of Hz
      wtInf0    = rw( 88) ! infeasibility weight

      scltol    = rw( 92) ! scale tolerance.
*     ------------------------------------------------------------------
*     rw(151)--rw(180) contain  parmLU  parameters for LUSOL.
*     ------------------------------------------------------------------
      eLmax1    = rw(151) ! max L-multiplier in factor
      eLmax2    = rw(152) ! max L-multiplier in update
      small     = rw(153) ! defn of small real
      Utol1     = rw(154) ! abs tol for small diag of U
      Utol2     = rw(155) ! rel tol for small diag of U
      Uspace    = rw(156) ! limit on waste space in U
      Dens1     = rw(157) ! switch to search maxcol columns and no rows
      Dens2     = rw(158) ! switch to dense LU
*     ------------------------------------------------------------------
*     rw(181)--rw(199) pass parameters into various routines.
*     ------------------------------------------------------------------
      toldj3    = rw(186) ! current optimality tol
*     ------------------------------------------------------------------
*     iw(1)--iw(50): I/O file numbers and dimensions.
*     ------------------------------------------------------------------
      iRead     = iw( 10) ! Standard Input
      iSpecs    = iw( 11) ! Specs (options) file
      iPrint    = iw( 12) ! Print file
      n         = iw( 15) ! # of variables
      m         = iw( 16) ! # of rows of Acol
      nGobj     = iw( 26) ! length of QP constant vector
      nnH       = iw( 27) ! # of nonlinear variables (= # Hessian cols)
*     ------------------------------------------------------------------
*     iw(51)--iw(150): optional parameters set via the specs file.
*     ------------------------------------------------------------------
      nColH     = iw( 51) ! Leading # of nonzeros in user Hx
      maxR      = iw( 52) ! max columns of R.
      maxS      = iw( 53) ! max # of superbasics
      lEmode    = iw( 56) ! >0    => use elastic mode
      kchk      = iw( 58) ! check (row) frequency
      kFac      = iw( 59) ! factorization frequency
      ksav      = iw( 60) ! save basis map
      klog      = iw( 61) ! log/print frequency
      kSumm     = iw( 62) ! Summary print frequency
      kDegen    = iw( 63) ! max. expansions of featol
      kReset    = iw( 64) ! Hessian frequency
      mFlush    = iw( 66) ! Hessian flush
      mSkip     = iw( 67) ! # largest value of nSkip
      lvlSrt    = iw( 69) ! = 0(1) => cold(warm) start
      lvlInf    = iw( 73) ! Elastic option
      lvlPrt    = iw( 74) ! Print Level for the minor itns
      lvlScl    = iw( 75) ! scale option
      lvlTim    = iw( 77) ! Timing level
      lvlPiv    = iw( 80) ! 0(1) LU threshold partial(complete) pivoting
      lprPrm    = iw( 81) ! > 0    => parms are printed
      lprScl    = iw( 83) ! > 0    => print the scales
      lprSol    = iw( 84) ! > 0    => print the solution 
      lprDbg    = iw( 85) ! > 0    => private debug print
      minmax    = iw( 87) ! 1, 0, -1  => MIN, FP, MAX
      iCrash    = iw( 88) ! Crash option
      itnlim    = iw( 89) ! limit on total iterations
      mMinor    = iw( 91) ! limit on minor iterations
      MnrPrt    = iw( 93) ! Minor print level
      nParPr    = iw( 94) ! # of partial pricing sections
      mWSmod    = iw( 95) ! # of working set changes
      iBack     = iw(120) ! backup file
      iDump     = iw(121) ! dump file
      iLoadB    = iw(122) ! load file
      iMPS      = iw(123) ! MPS file
      iNewB     = iw(124) ! new basis file
      iInsrt    = iw(125) ! insert file
      iOldB     = iw(126) ! old basis file
      iPnch     = iw(127) ! punch file
      iReprt    = iw(130) ! Report file
      iSoln     = iw(131) ! Solution file
*     ------------------------------------------------------------------
*     iw(151)--iw(180) contain luparm parameters for LUSOL.
*     ------------------------------------------------------------------
      nout      = iw(151) ! unit # for printed messages
      LUprnt    = iw(152) ! print level in LU routines
      maxcol    = iw(153) ! lu1fac: max. # columns
*     ------------------------------------------------------------------

      c4         = max( 1.0d-4, eps3 )
      c6         = max( 1.0d-6, eps2 )
      never      = 99999999
      QP         = nnH .gt. 0

*     ==================================================================
*     Check the optional parameters.
*     ==================================================================
      if (iBack  .eq. idummy ) iBack  =     0
      if (iDump  .eq. idummy ) iDump  =     0
      if (iLoadB .eq. idummy ) iLoadB =     0
      if (iNewB  .eq. idummy ) iNewB  =     0
      if (iInsrt .eq. idummy ) iInsrt =     0
      if (iOldB  .eq. idummy ) iOldB  =     0
      if (iPnch  .eq. idummy ) iPnch  =     0
      if (iReprt .eq. idummy ) iReprt =     0
      if (iSoln  .eq. idummy ) iSoln  =     0

*     Set unspecified frequencies or silly values to defaults.

      if (kchk   .eq. idummy ) kchk   =    60
      if (kfac   .le.    0   ) then
                               kfac   =   100
                     if ( QP ) kfac   =    50
      end if
      if (klog  .eq. idummy  ) klog   =   100
      if (kSumm .eq. idummy  ) kSumm  =   100
      if (ksav  .eq. idummy  ) ksav   =   100
      if (kDegen.eq. idummy  ) kDegen = 10000

*     Sometimes, frequency 0 means "almost never".

      if (kchk   .le. 0      ) kchk   = never
      if (klog   .le. 0      ) klog   = never
      if (ksav   .le. 0      ) ksav   = never
      if (kSumm  .le. 0      ) kSumm  = never
      if (kDegen .le. 0      ) kDegen = never
      if (iCrash .lt. 0      ) iCrash =  3
      if (minmax .eq. idummy ) minmax =  1
      if (minmax .eq. -1     ) then
                               minimz = -1
      else
                               minimz =  1
      end if

      if (mMinor .lt. 0      ) mMinor = max(1000, 5*max(n,m))
      if (mWSmod .le. 0      ) mWSmod = never
      if (lprDbg .lt. 0      ) lprDbg = 0
      if (lprPrm .lt. 0      ) lprPrm = 1
      if (lprScl .lt. 0      ) lprScl = 0
      if (lprSol .lt. 0      ) lprSol = 2
      if (lvlSrt .lt. 0      ) lvlSrt = 0
      if (lvlPrt .lt. 0      ) lvlPrt = 1
                               MnrPrt = lvlPrt
                               MjrPrt = MnrPrt
      if (lvlInf .lt. 0  .or.  lvlInf .gt. 2
     &                       ) lvlInf = idummy
      if (lvlInf .eq. idummy ) lvlInf = 2
      if (lEmode .lt. 0  .or.  lEmode .gt. 2
     &                       ) lEmode = idummy
      if (lEmode .eq. idummy ) lEmode = 1

*     Check superbasics limit and reduced Hessian size.

      if (nColH  .lt. 0      ) nColH  = min(max(0, nColH), n)
      if ( QP ) then
         if (maxS .lt. 0     ) maxS   = min(500,nnH+1)
      end if
      if (maxS   .le. 0      ) maxS   = 1
      if (maxR   .lt. 0      ) maxR   = maxS
                               maxR   = max( min( maxR ,n ) , 1 )
                               maxS   = max( min( maxS ,n ) , 1 )

*     Check other options.

      if (lvlScl .lt. 0      ) lvlScl = 2
                               lvlScl = min( lvlScl, 2 )

      if (nParPr .le. 0      ) nParPr = 10
                               minPrc = 10
                               nPr1   = n / nParPr
                               nPr2   = m / nParPr
      if (max( nPr1, nPr2 ) .lt. minPrc) then
                               maxmn  = max( m, n )
                               nParPr = maxmn / min( maxmn, minPrc )
                               nPr1   = n / nParPr ! for printing only
                               nPr2   = m / nParPr ! for printing only
                                         end if
      rmaxS  = maxS
      cHzbnd = max ( one/(hundrd*eps*rmaxS), tenp6 )

      if (plInfy   .lt. zero ) plInfy = 1.0d+20
      if (bigFx    .le. zero ) bigFx  = 1.0d+15
      if (bigdx    .le. zero ) bigdx  = plInfy
      if (Hcndbd   .le. zero ) Hcndbd = cHzbnd
      if (xdlim    .le. zero ) xdlim  = 2.0d+0

      if (tCrash   .lt. zero  .or.
     &    tCrash   .ge. one  ) tCrash = 0.1d+0

*     ------------------------------------
*     Set up the parameters for lu1fac.
*     ------------------------------------
      if (maxcol .lt.  0     ) maxcol =   5
      if (LUprnt .eq.  idummy) LUprnt =  -1

                               nout   =  iPrint
      if (lvlPrt .gt. 10     ) LUprnt =  0
      if (lprDbg .eq. 51     ) LUprnt =  1
      if (lprDbg .eq. 52     ) LUprnt =  2
      if (iPrint .lt.  0     ) LUprnt = -1
      if (tolFac .lt. one    ) tolFac =  100.0d+0
      if (tolUpd .lt. one    ) tolUpd =   10.0d+0
                               eLmax1 = tolFac
                               eLmax2 = tolUpd
      if (Utol1  .le. zero   ) Utol1  =  eps1
      if (Utol2  .le. zero   ) Utol2  =  eps1
      if (Dens2  .lt. zero   ) Dens2  =  0.6d+0

      if (small  .le. zero   ) small  =  eps0
      if (Uspace .le. zero   ) Uspace =  3.0d+0
      if (Dens1  .le. zero   ) Dens1  =  0.3d+0

*     Set some tolerances.
*     Set the optimality tolerance.
*     Solve the QP subproblems fairly accurately.

      if (tolQP  .le. zero   ) tolQP  =  c6
      if (tolFP  .le. zero   ) tolFP  =  tolQP
      if (tolrow .le. zero   ) tolrow =  c4
      if (tolswp .le. zero   ) tolswp =  eps4
      if (tolx   .le. zero   ) tolx   =  c6
                               toldj3 =  tolQP
      if (scltol .le. zero   ) scltol =  0.90d+0
      if (scltol .ge. one    ) scltol =  0.99d+0
      if (tolpiv .le. zero   ) tolpiv =  eps1

      if (wtInf0 .lt. zero   ) wtInf0 =  1.0d+0

      if (iBack  .eq. iNewB  ) iBack  = 0
      if (itnlim .lt. 0      ) itnlim = max(10000, 10*max(n,m))

      if (Task .eq. PrintO  .and.  iPrint .gt. 0) then
*        ===============================================================
*        Print parameters except if PRINT LEVEL = 0
*                         or SUPPRESS PARAMETERS was specified.
*        ===============================================================
         if (lvlPrt .gt. 0  .and.  lprPrm .gt. 0) then
            nQP    = max( nGobj, nnH )
            call s1page( 1, iw, leniw )
            write(iPrint, 1000)
*           --------------------
*           Files.
*           --------------------
            write(iPrint, 2100) iSoln , iOldB , iRead ,
     &                          iInsrt, iNewB , iPrint,
     &                          iPnch , iBack , iSpecs,
     &                                  iLoadB, iDump
*           --------------------
*           Frequencies.
*           --------------------
            write(iPrint, 2200) klog  , kchk  , ksav  ,
     &                          kSumm , kfac  , kDegen
*           --------------------
*           LP/QP parameters.
*           --------------------
            write(iPrint, 2300) prbtyp(2+minmax),
     &                          scltol, tolx  , itnlim,
     &                          lvlScl, tolQP , nParPr,
     &                          tCrash, tolpiv, lvlPrt,
     &                          iCrash, wtInf0, lEmode,
     &                                          lvlInf
*           --------------------
*           QP objective
*           --------------------
            if ( QP ) 
     &      write(iPrint, 2400) nQP   , nnH   , maxS  ,
     &                          nnH   , bigdx , 
     &                          nGobj
*           --------------------
*           Miscellaneous
*           --------------------
            write(iPrint, 2700) tolFac, Utol1 , lvlTim,
     &                          tolUpd, tolswp, lprDbg,
     &                                  eps
         end if
      end if

*     ------------------------------------------------------------------
*     Re-assign the options to their respective work arrays.
*     ------------------------------------------------------------------
      rw( 51) = tolFP   
      rw( 52) = tolQP   
      rw( 56) = tolx    
      rw( 60) = tolpiv  
      rw( 61) = tolrow  
      rw( 62) = tCrash  
      rw( 65) = tolswp  
      rw( 66) = tolfac  
      rw( 67) = tolupd  
      rw( 70) = plInfy  
      rw( 71) = bigFx   
      rw( 72) = bigdx   
      rw( 80) = xdlim   
      rw( 85) = Hcndbd  
      rw( 88) = wtInf0  
      rw( 92) = scltol  

      rw(151) = eLmax1 ! max L-multiplier in factor
      rw(152) = eLmax2 ! max L-multiplier in update
      rw(153) = small  ! defn of small real
      rw(154) = Utol1  ! abs tol for small diag of U
      rw(155) = Utol2  ! rel tol for small diag of U
      rw(156) = Uspace ! limit on waste space in U
      rw(157) = Dens1  ! switch to search maxcol columns and no rows
      rw(158) = Dens2  ! switch to dense LU

      iw( 51) = nColH
      iw( 52) = maxR    
      iw( 53) = maxS    
      iw( 56) = lEmode  
      iw( 58) = kchk    
      iw( 59) = kFac    
      iw( 60) = ksav    
      iw( 61) = klog    
      iw( 62) = kSumm   
      iw( 63) = kDegen  
      iw( 64) = kReset  
      iw( 66) = mFlush  
      iw( 67) = mSkip   
      iw( 69) = lvlSrt  
      iw( 73) = lvlInf  
      iw( 74) = lvlPrt  
      iw( 75) = lvlScl  
      iw( 77) = lvlTim  
      iw( 80) = lvlPiv  
      iw( 81) = lprPrm  
      iw( 83) = lprScl  
      iw( 84) = lprSol  
      iw( 85) = lprDbg  
      iw( 87) = minmax  
      iw( 88) = iCrash  
      iw( 89) = itnlim  
      iw( 91) = mMinor  
      iw( 92) = MjrPrt  
      iw( 93) = MnrPrt  
      iw( 94) = nParPr  
      iw( 95) = mWSmod 
      iw(120) = iBack
      iw(121) = iDump
      iw(122) = iLoadB
      iw(123) = iMPS
      iw(124) = iNewB
      iw(125) = iInsrt
      iw(126) = iOldB
      iw(127) = iPnch
      iw(130) = iReprt
      iw(131) = iSoln
      iw(151) = nout    
      iw(152) = LUprnt  
      iw(153) = maxcol  
      iw(199) = minimz

*     This parameter is not optional, but set it anyway.

      rw(186) = toldj3

      return

 1000 format(  ' Parameters' 
     &       / ' ==========')
 2100 format(/ ' Files'
     &       / ' -----'
     &/ ' Solution file..........', i10, 6x,
     &  ' Old basis file ........', i10, 6x,
     &  ' Standard input.........', i10
     &/ ' Insert file............', i10, 6x,
     &  ' New basis file ........', i10, 6x,
     &  ' (Printer)..............', i10
     &/ ' Punch file.............', i10, 6x,
     &  ' Backup basis file......', i10, 6x,
     &  ' (Specs file)...........', i10
     &/ 40x,
     &  ' Load file..............', i10, 6x,
     &  ' Dump file..............', i10)
 2200 format(/ ' Frequencies'
     &       / ' -----------'
     &/ ' Print frequency........', i10, 6x,
     &  ' Check frequency........', i10, 6x,
     &  ' Save new basis map.....', i10
     &/ ' Summary frequency......', i10, 6x,
     &  ' Factorization frequency', i10, 6x,
     &  ' Expand frequency.......', i10)
 2300 format(/ ' LP/QP Parameters'
     &       / ' ----------------'
     &/   a24,                                16x
     &/ ' Scale tolerance........', 0p, f10.3, 6x,
     &  ' Feasibility tolerance..', 1p, e10.2, 6x,
     &  ' Iteration limit........', i10
     &/ ' Scale option...........', i10,       6x,
     &  ' Optimality tolerance...', 1p, e10.2, 6x,
     &  ' Partial  price.........', i10
     &/ ' Crash tolerance........', 0p, f10.3, 6x,
     &  ' Pivot tolerance........', 1p, e10.2, 6x,
     &  ' Print level............', i10
     &/ ' Crash option...........', i10,       6x,
     &  ' Elastic weight.........', 1p, e10.2, 6x,
     &  ' Elastic mode...........', i10
     &/ 80x, 
     &  ' Elastic objective......', i10)
 2400 format(/ ' QP objective'
     &       / ' ------------'
     &/ ' Objective variables....', i10,       6x,
     &  ' Hessian columns........', i10,       6x,
     &  ' Superbasics limit......', i10
     &/ ' Nonlin Objective vars..', i10,       6x,
     &  ' Unbounded step size....', 1p, e10.2
     &/ ' Linear Objective vars..', i10)
 2700 format(/ ' Miscellaneous'
     &       / ' -------------'
     &/ ' LU factor tolerance....', 0p, f10.2, 6x,
     &  ' LU singularity tol.....', 1p, e10.2, 6x,
     &  ' Timing level...........', i10
     &/ ' LU update tolerance....', 0p, f10.2, 6x,
     &  ' LU swap tolerance......', 1p, e10.2, 6x,
     &  ' Debug level............', i10
     &/ 40x,
     &  ' eps (machine precision)', e10.2)

      end ! of s5dflt

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5Mem ( iError, iPrint, iSumm,
     &     m, n, ne, nGobj, nnH, lenR, maxS,
     &     mincw , miniw , minrw,  ! In/Out
     &     maxcw , maxiw , maxrw , ! Out
     &     lencw , leniw , lenrw , iw )

      implicit
     &     none
      integer
     &     iError, iPrint, iSumm, m, n, ne, nGobj, nnH, lenR, maxS,
     &     maxcw, maxiw, maxrw, mincw, miniw, minrw, lencw, leniw,
     &     lenrw, iw(leniw)

*     ==================================================================
*     s5Mem   allocates all array storage for sqopt,
*     using the values:
*        m    , n    , ne
*        maxS                    Set in s5dflt.
*        nGobj, nnH              Set from the argument list.
*        lenR                    Set in the callin program.
*
*     These values are used to compute the minimum required storage:
*     mincw, miniw, minrw.
*
*     On exit.
*        If iError = 0,  mincw, miniw, minrw give the amounts of
*        character, integer and real workspace needed to hold
*        the problem. (The LU factorization routines may 
*        subsequently ask for more.) 
*
*        If iError > 0,  insufficient storage is provided to hold the
*        problem.  In this case, mincw, miniw and minrw give estimates
*        of reasonable lengths for cw(*), iw(*) and rw(*).
*
*     15 Nov 1991: First version based on Minos 5.4 routine m2core.
*     12 Nov 1994: Converted to integer and real storage.
*     06 Aug 1996: First min sum version.
*     14 Jul 1997: Thread-safe version.
*     01 May 1998: First version called by sqMem. This simplified 
*                  version may slightly overestimate needed memory.
*     06 Nov 2000: Current version of s5Mem.
*     ==================================================================
      integer
     &     lenALU, mBS, nb, lAscal, lblBS, lbuBS, lblSav, lbuSav, ldx,
     &     lgBS, lgQP, lHdx, lhEsta, lhfeas, liwEst, liy, liy1, lkBS,
     &     lR, lrg, lQPrhs, lrwEst, lxBS, lxscal, ly, ly1, ly2, ly3,
     &     maxcu1, maxiu1, maxru1, mincu1, mincu2, miniu1, miniu2,
     &     minru1, minru2, ngQP
*     ------------------------------------------------------------------
      iError  = 0

*     All dimensions are computed from 
*        m    , n    , ne
*        lenR , maxS , nnH
*        nGobj    

      mBS     = m     + maxS
      nb      = n     + m
      ngQP    = max( nGobj, nnH )

*     sqopt can use all of cw, iw and rw
*     except the first user workspace partitions.

      lhfeas = miniw
      lhEsta = lhfeas + mBS
      lkBS   = lhEsta + nb
      liy    = lkBS   + mBS
      liy1   = liy    + nb
      miniw  = liy1   + nb

      lAscal = minrw
      ly     = lAscal + nb
      ly1    = ly     + nb
      ly2    = ly1    + nb
      ly3    = ly2    + nb
      lxBS   = ly3    + nb
      lblBS  = lxBS   + mBS
      lbuBS  = lblBS  + mBS
      lxscal = lbuBS  + mBS
      lHdx   = lxscal + nnH
      lgQP   = lHdx   + nnH
      lgBS   = lgQP   + ngQP
      lR     = lgBS   + mBS
      lrg    = lR     + lenR
      lblSav = lrg    + maxS
      lbuSav = lblSav + nb
      lQPrhs = lbuSav + nb
      ldx    = lQPrhs + m
      minrw  = ldx    + ngQP

*     ---------------------------
*     Store the addresses in iw.
*     ---------------------------
      iw(284) = lhfeas
      iw(285) = lhEsta
      iw(292) = lkBS
      iw(273) = lblBS
      iw(274) = lbuBS
      iw(275) = lblSav
      iw(276) = lbuSav
      iw(278) = lQPrhs
      iw(287) = ldx
      iw(288) = lHdx
      iw(290) = lgQP
      iw(291) = lgBS
      iw(293) = lrg
      iw(294) = lR
      iw(295) = lAscal
      iw(301) = lxBS
      iw(302) = lxscal
      iw(308) = liy
      iw(309) = liy1
      iw(311) = ly
      iw(312) = ly1
      iw(313) = ly2
      iw(314) = ly3

*     ------------------------------------------------------------------
*     Allocate arrays for the basis factorization routines.
*     miniw, minrw point to the beginning of the LU factorization.
*     This is the beginning of free space between calls
*     if the LU factors are allowed to be overwritten.
*     ------------------------------------------------------------------
      call s2Bmap( m, n, ne,
     &     miniw, minrw, maxiw, maxrw, liwEst, lrwEst,
     &     iw, leniw )

      mincw   = mincw  -  1      ! Character storage can be exact

      lenALU  = iw(213)          ! Space allotted for LU factors

*     ------------------------------------------------------------------
*     Set the lower limits on the 2nd user workspace partitions.
*     The upper limits of the partition 1 are set in the specs file.
*     ------------------------------------------------------------------
      mincu2  = mincw + 1       ! Lower limits on partition 2 
      miniu2  = miniw + 1
      minru2  = minrw + 1
 
      iw( 33) = mincu2          ! Start of second user partition of cw 
      iw( 38) = miniu2          ! Start of second user partition of iw 
      iw( 43) = minru2          ! Start of second user partition of rw 

*     ------------------------------------------------------------------
*     Print details of the workspace.
*     ------------------------------------------------------------------
      mincu1  = iw( 31)         ! Start of first  user partition of cw
      miniu1  = iw( 36)         ! Start of first  user partition of iw
      minru1  = iw( 41)         ! Start of first  user partition of rw

      maxcu1  = iw( 32)         ! End   of first  user partition of cw 
      maxiu1  = iw( 37)         ! End   of first  user partition of iw 
      maxru1  = iw( 42)         ! End   of first  user partition of rw 

      if (iPrint .gt. 0) then
         write(iPrint, 1100) maxcw, maxiw, maxrw, mincw,  miniw, minrw
         if (maxcu1 .ge. mincu1) write(iPrint, 1201) mincu1, maxcu1
         if (maxiu1 .ge. miniu1) write(iPrint, 1202) miniu1, maxiu1
         if (maxru1 .ge. minru1) write(iPrint, 1203) minru1, maxru1
      end if

      if (mincw .gt. maxcw   .or.  miniw .gt. maxiw 
     &                       .or.  minrw .gt. maxrw) then 
*        ---------------------------------------------------------------
*        Not enough workspace to solve the problem.
*        ---------------------------------------------------------------
         if (iPrint .gt. 0) write(iPrint, 9400)
         if (iSumm  .gt. 0) write(iSumm , 9400)

         if (mincw  .gt. lencw ) then
*           ------------------------------------------------------------
*           Not enough character workspace.
*           ------------------------------------------------------------
            iError = 42
            if (iPrint .gt. 0) write(iPrint, 9420) mincw
            if (iSumm  .gt. 0) write(iSumm , 9420) mincw
         end if

         if (     miniw .gt. leniw) then
*           ------------------------------------------------------------
*           Not enough integer workspace.
*           ------------------------------------------------------------
            miniw  = liwEst
            iError = 43
            if (iPrint .gt. 0) write(iPrint, 9430) miniw
            if (iSumm  .gt. 0) write(iSumm , 9430) miniw
         end if

         if (minrw  .gt. lenrw ) then
*           ------------------------------------------------------------
*           Not enough real    workspace.
*           ------------------------------------------------------------
            minrw  = lrwEst
            iError = 44
            if (iPrint .gt. 0) write(iPrint, 9440) minrw
            if (iSumm  .gt. 0) write(iSumm , 9440) minrw
         end if
      end if

      if (iError .eq. 0  .and.  lenALU .eq. 0) then
*        -------------------------------------------
*        Insufficient storage to factorize B.
*        -------------------------------------------
         iError = 20
         if (iPrint .gt. 0) write(iPrint, 9500)
         if (iSumm  .gt. 0) write(iSumm , 9500)
         if (iPrint .gt. 0)
     &      write(iPrint, 9501) maxiw, liwEst, maxrw, lrwEst
         if (iSumm  .gt. 0)
     &      write(iSumm , 9501) maxiw, liwEst, maxrw, lrwEst
         miniw  = liwEst
         minrw  = lrwEst

      end if

      return

 1100 format(/ ' Total char*8  workspace', i10, 6x,
     &         ' Total integer workspace', i10, 6x,
     &         ' Total real    workspace', i10
     &       / ' Total char*8  (minimum)', i10, 6x,
     &         ' Total integer (minimum)', i10, 6x,
     &         ' Total real    (minimum)', i10/)
 1201 format(  ' Elements cw(', i10, ':',i10, ')', 6x, 'are free',
     &         ' for USER CHAR*8  WORKSPACE')
 1202 format(  ' Elements iw(', i10, ':',i10, ')', 6x, 'are free',
     &         ' for USER INTEGER WORKSPACE')
 1203 format(  ' Elements rw(', i10, ':',i10, ')', 6x, 'are free',
     &         ' for USER REAL    WORKSPACE')

 9400 format(  ' EXIT -- not enough storage to start solving',
     &         ' the problem...' )
 9420 format(/ ' Total character workspace should be significantly',
     &         ' more than', i8)
 9430 format(/ ' Total integer   workspace  should be significantly',
     &         ' more than', i8)
 9440 format(/ ' Total real      workspace  should be significantly',
     &         ' more than', i8)
 9500 format(  ' EXIT -- not enough storage',
     &         ' for the basis factors')
 9501 format(/ 24x, '        Current    Recommended'
     &       / ' Total integer workspace', 2i15
     &       / ' Total real    workspace', 2i15)

      end ! of s5Mem

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5solv( Start, Hprod, Hprod1, QPlog,
     &     m, n, nb, nnH0, nnH, nName, ngQP, nGobj0, nGobj,
     &     iObj, ObjAdd, ObjQP, ObjTru, nInf, sInf,
     &     ne, nlocA, locA, indA, Acol,
     &     iHvar, jHvar, lenH, neH, H,
     &     bl, bu, Gobj, Names, 
     &     nrhs0, nrhs, rhs, lenx0, nx0, x0,
     &     hElast, hs, x, pi, rc, inform, nS, 
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      external
     &     Hprod1, Hprod, QPlog
      integer
     &     inform, iObj, lenH, lencu, leniu, lenru, lencw, leniw,
     &     lenrw, m, n, nb, ne, neH, nGobj0, nGobj, ngQP, nInf,
     &     nName, nnH0, nnH, nlocA, nrhs0, nrhs, lenx0, nx0, nS, Start,
     &     locA(nlocA), indA(ne), iHvar(lenH), jHvar(lenH), hElast(nb),
     &     hs(nb), iu(leniu), iw(leniw)
      double precision
     &     ObjAdd, ObjQP, ObjTru, sInf, Acol(ne), H(lenH), rhs(nrhs0),
     &     bl(nb), bu(nb), Gobj(nGobj0), x0(lenx0), x(nb), pi(m),
     &     rc(nb), ru(lenru), rw(lenrw)
      character*8
     &     Names(nName), cu(lencu), cw(lencw)

*     ==================================================================
*     s5solv solves the current problem.
*
*     On entry,
*     the specs file has been read,
*     all data items have been loaded (including Acol, indA, locA, ...),
*     and workspace has been allocated within cw, iw and rw.
*
*     On exit,
*     inform  =  0 if an optimal solution was found,
*             =  1 if the problem was infeasible,
*             =  2 if the problem was unbounded,
*             =  3 if the Iteration limit was exceeded,
*            ge  4 if iterations were terminated by some other
*                  error condition (see the SQOPT user's guide).
*
*     01 Oct 1994: First version of s5solv.
*     06 Aug 1996: Min Sum option added.
*     14 Jul 1997: Thread-safe version.
*     06 Nov 2000: Current version of s5solv.
*     ==================================================================
      character*8
     &     mProb
      character*4
     &     istate(3)
      logical
     &     infsbl, needB
      integer
     &     iError, lEmode, Stat1, inewB, iPrint, iSumm, itn, itnlim,
     &     itQP, j, k, lAscal, lblBS, lbuBS, lblSav, lbuSav, lenR, lgBS,
     &     lgQP, lHdx, lhEsta, lhfeas, liy, liy1, lkBS, lr, lrg, lsSave,
     &     lvlInf, lvlScl, lxBS, ly, ly1, ly2, ly3, maxS, mBS, minimz,
     &     minmax, mxitQP, nDegen, ngQP0, nnb, nnCon0, nnCon,
     &     nnObj, nnJac, Hcalls, numLC, numLIQ, eigH, Prob
      double precision
     &     degen, dnrm1s, ObjLP, tolFP, tolQP, tolx, wtInf0, wtInf,
     &     piNorm, pNorm1, pNorm2, rgNorm, sclObj, vimax, xNorm, Fx(1)
*     ------------------------------------------------------------------
      double precision   zero,            one
      parameter         (zero   = 0.0d+0, one = 1.0d+0)
      integer            FP,         LP,     QP
      parameter         (FP     = 0, LP = 1, QP = 2)
      integer            SaveB,      PrintS,     Wrap    
      parameter         (SaveB  = 0, PrintS = 1, Wrap = 1)
      integer            Stats
      parameter        ( Stats  = 1 )
      parameter         (lvlScl =  75) ! scale option
      parameter         (eigH   = 200) ! type of QP Hessian
*     ------------------------------------------------------------------
      tolFP     = rw( 51) ! Minor Phase 1 Opt tol
      tolQP     = rw( 52) ! Minor Phase 2 Opt tol
      tolx      = rw( 56) ! Minor feasibility tolerance.
      wtInf0    = rw( 88) ! infeasibility weight

      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      iNewB     = iw(124) ! new basis file

      lenR      = iw( 28) ! R(lenR) is the reduced Hessian factor
      maxS      = iw( 53) ! max # of superbasics

      lEmode    = iw( 56) ! >0    => use elastic mode
      lvlInf    = iw( 73) ! Elastic option
      minmax    = iw( 87) ! 1, 0, -1  => MIN, FP, MAX
      itnlim    = iw( 89) ! limit on total iterations
      minimz    = iw(199) ! 1 (-1)    => minimize (maximize)

      mProb     = cw( 51) ! Problem name 

*     Addresses

      lhfeas    = iw(284) ! hfeas(mBS)  = feasibility types
      lhEsta    = iw(285) ! hEstat(nb)  = status of elastics
      lkBS      = iw(292) ! kBS(mBS)    = ( B  S ) list
      lblBS     = iw(273) ! blBS(mBS)   = lower bounds for xBS
      lbuBS     = iw(274) ! buBS(mBS)   = upper bounds for xBS
      lxBS      = iw(301) ! xBS(mBS)    = basics, superbasics 
      lgQP      = iw(290) ! gQP(ngQP)   = QP gradient 
      lgBS      = iw(291) ! gBS(mBS)    = BS components of g
      lrg       = iw(293) ! rg (maxS)   =  reduced gradient
      lR        = iw(294) ! R(lenR)     = factor of Z'HZ
      lAscal    = iw(295) ! Ascale(nb)  = row and column scales
      liy       = iw(308) ! iy(nb)      =  integer work vector
      liy1      = iw(309) ! iy1(nb)     =  integer work vector
      ly        = iw(311) ! y(nb)       =  real work vector
      ly1       = iw(312) ! y1(nb)      =  real work vector
      ly2       = iw(313) ! y2(nb)      =  real work vector
      ly3       = iw(314) ! y3(nb)      =  real work vector
      lHdx      = iw(288) ! Hdx(nnH)    = product of H with  x - x0
      lblSav    = iw(275) ! blSav(m)    = temp bounds
      lbuSav    = iw(276) ! buSav(m)    = temp bounds

      mBS       = m + maxS

*     Figure out what type of problem we have.

      if (minmax .eq. 0  .or.(lEmode .eq. 2  .and.  lvlInf .eq. 2)) then
         Prob = FP
      else if (ngQP .eq. 0) then ! No explicit objective. Must be an LP.
         if (iObj .eq. 0) then
            Prob = FP
         else
            Prob = LP
         end if
      else !  Explicit objective. Check for quadratic term.
         if (nnH .gt. 0) then
            Prob = QP
         else
            Prob = LP
         end if
      end if

      Hcalls    = 0
      itn       = 0
      itQP      = 0 
      mxitQP    = itnlim
      nDegen    = 0
      nnCon     = 0
      nnCon0    = 1
      nnObj     = 0
      nnJac     = 0
      numLC     = m
      ngQP0     = max( ngQP , 1 )

      iw(eigH)  = 0          ! QP Hessian may or may not be definite
      sclObj    = one

*     Zap the pi(i) in case they are printed without being set.

      call dload ( m, zero, pi, 1 )

*     ------------------------------------------------------------------
*     Print the matrix statistics.  The rowtypes are also computed ready
*     for use in s5getB.
*     ------------------------------------------------------------------
      call s2Amat( Stats, m, n, nb,
     &     nnCon, nnJac, nnObj, iObj,
     &     ne, nlocA, locA, indA, Acol,
     &     bl, bu,  iw(lhEsta),
     &     iw, leniw, rw, lenrw )

*     Scale the problem and get an initial basis.

      call s5getB( Start, QPlog, needB, iError, m, maxS, mBS,
     &     n, nb, nnCon, nnJac, nnObj, nName, nS, mxitQP, itQP, itn, 
     &     nDegen, numLC, numLIQ, tolFP, tolQP, tolx,
     &     nInf, sInf, wtInf, iObj, sclObj, piNorm, rgNorm,
     &     ne, nlocA, locA, indA, Acol,
     &     hElast, iw(lhEsta), iw(lhfeas), hs, iw(lkBS), Names,
     &     rw(lAscal), bl, bu,rw(lblBS),rw(lbuBS),rw(lblSav),rw(lbuSav),
     &     rw(lgBS), pi, rc, nrhs0, nrhs, rhs,
     &     1, 0, x0, x, rw(lxBS),
     &     iw(liy), iw(liy1), rw(ly), rw(ly1), rw(ly2), rw(ly3),
     &     cw, lencw, iw, leniw, rw, lenrw )

      if (nGobj .gt. 0  .and.  iw(lvlScl) .gt. 0)
     &     call ddscl ( nGobj, rw(lAscal), 1, Gobj, 1 )

      if (iError .ne. 0) go to 900

*     ==================================================================
*     Solve the problem.
*     ==================================================================
      call s1time( 2, 0, iw, leniw, rw, lenrw )
      call s5SQP ( Hprod, Hprod1, QPlog, Prob, iError, itn,
     &     lenR, m, maxS, mBS, n, nb, nDegen, Hcalls,
     &     ngQP0, ngQP, nGobj0, nGobj, nnH0, nnH, nS, mxitQP, itQP, 
     &     minimz, iObj, sclObj, ObjAdd, ObjQP,
     &     tolFP, tolQP, tolx, nInf, sInf, wtInf0, piNorm,
     &     ne, nlocA, locA, indA, Acol, iHvar, jHvar, lenH, neH, H,
     &     hElast, iw(lhEsta), iw(lhfeas), hs, iw(lkBS),
     &     rw(lAscal), bl, bu, rw(lblBS), rw(lbuBS),
     &     rw(lgBS), Gobj, rw(lgQP), rw(lHdx), pi, rw(lR), rc, rw(lrg),
     &     nrhs0, nrhs, rhs, lenx0, nx0, x0, x, rw(lxBS),
     &     iw(liy), iw(liy1), rw(ly), rw(ly1), rw(ly2), rw(ly3),
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )
      call s1time(-2, 0, iw, leniw, rw, lenrw )

*     ==================================================================
*     Exit.
*     Set output variables and print a summary of the final solution.
*     ObjTru is printed in s4newB
*     ==================================================================
  900 inform = iError
      degen  = 100.0d+0 * nDegen / max( itn, 1 )

      if (iObj .eq. 0) then
         ObjLP  = ObjAdd
      else
         ObjLP  = ObjAdd + x(n+iObj)*sclObj
      end if

      if (Prob .eq. LP  .or.  Prob .eq. QP) then
         ObjTru = ObjLP + ObjQP
      else
         ObjTru = zero
      end if

      infsbl = nInf .gt. 0
      xNorm  = dnrm1s( nb, x, 1 )

*     Count basic nonlinear variables (used only for printing).

      nnb  = 0
      do j = 1, nnH
         if (hs(j) .eq. 3) nnb = nnb + 1
      end do

      if (inewB .gt. 0  .and.  iError .lt. 20) then
         k      = 1 + iError
         call s4stat( k, istate )
         call s4newB( Wrap, iNewB, minimz, m, n, nb,
     &        nS, mBS, itn, nInf, sInf, ObjTru, iw(lkBS), hs,
     &        rw(lAscal), bl, bu, x, rw(lxBS), istate,
     &        cw, lencw, iw, leniw )
      end if
      
*     Print statistics.

      if (iPrint .gt. 0) then
                           write(iPrint, 1900) mProb, itn, ObjTru
         if (infsbl)       write(iPrint, 1910) nInf, sInf
         if (Prob .eq. QP) write(iPrint, 1920) Hcalls, ObjLP, ObjQP
         if (nS .gt. 0)
     &                     write(iPrint, 1970) nS, nnb
                           write(iPrint, 1975) nDegen, degen
      end if

      if (iSumm  .gt. 0) then
                           write(iSumm , 1900) mProb , itn  , ObjTru
         if (infsbl)       write(iSumm , 1910) nInf  , sInf
         if (Prob .eq. QP) write(iSumm , 1920) Hcalls, ObjLP, ObjQP
         if (nS .gt. 0)
     &                     write(iSumm , 1970) nS, nnb
                           write(iSumm , 1975) nDegen, degen
      end if

*     ------------------------------------------------------------------
*     Unscale, save basis files and prepare to print the solution.
*     Clock 3 is "Output time".
*     ------------------------------------------------------------------
      call s1time( 3, 0, iw, leniw, rw, lenrw )
      call s4savB( SaveB, iError, minimz, m, n, nb,
     &     nnCon0, nnCon, ngQP0, ngQP, nName, nS,
     &     itn, nInf, sInf, wtInf0, vimax, iObj, sclObj, ObjTru,
     &     pNorm1, pNorm2, piNorm, xNorm,
     &     ne, nlocA, locA, indA, Acol,
     &     iw(lhEsta), hs, rw(lAscal), bl, bu, Fx, rw(lgQP),
     &     Names, pi, rc, x, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      if (nGobj .gt. 0  .and.  iw(lvlScl) .gt. 0)
     &     call dddiv ( nGobj, rw(lAscal), 1, Gobj, 1 )

*     If task = PrintS, s5savB prints the solution under the control
*     of lprSol (set by the  Solution  keyword in the SPECS file).
*     The printed solution may or may not be wanted, as follows:
*     
*     lprSol = 0   means      No
*            = 1   means      If optimal, infeasible or unbounded
*            = 2   means      Yes
*            = 3   means      If error condition

      call s4savB( PrintS, iError, minimz, m, n, nb,
     &     nnCon0, nnCon, ngQP0, ngQP, nName, nS,
     &     itn, nInf, sInf, wtInf0, vimax, iObj, sclObj, ObjTru,
     &     pNorm1, pNorm2, piNorm, xNorm,
     &     ne, nlocA, locA, indA, Acol,
     &     iw(lhEsta), hs, rw(lAscal), bl, bu, Fx, rw(lgQP),
     &     Names, pi, rc, x, 
     &     cw, lencw, iw, leniw, rw, lenrw )
      call s1time(-3, 0, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Set Obj for output.
*     Call  Hx  one last time with  nState .ge. 2.
*     Everything has been  unscaled, so we have to disable scaling.
*     ------------------------------------------------------------------
      lsSave     = iw(lvlScl)
      iw(lvlScl) = 0
      Stat1      = 2 + iError

      if (Prob .eq. FP) then
         ObjTru = zero
      else
         ObjLP  = zero
         if (iObj .ne. 0) then
            ObjLP = x(n+iObj)*sclObj
         end if
         ObjTru = ObjAdd + ObjLP

         ObjQP  = zero
         if (ngQP .gt. 0) then
            call s5QPfg( Hprod, Hprod1,
     &           ngQP, nGobj0, nGobj, nnH, Stat1, Hcalls, ObjQP,
     &           iHvar, jHvar, lenH, neH, H,
     &           Gobj, rw(lgQP), lenx0, nx0, x0, x, rw(ly), 
     &           cu, lencu, iu, leniu, ru, lenru, 
     &           cw, lencw, iw, leniw, rw, lenrw )
            ObjTru = ObjTru + ObjQP
         end if
      end if

      iw(lvlScl) = lsSave

      return

 1900 format(/   ' Problem name', 17x, a8
     &       /   ' No. of iterations', i20,
     &        2x,' Objective value', 1p, e22.10)
 1910 format(    ' No. of infeasibilities', i15,
     &        2x,' Sum of infeas', 1p, e24.10)
 1920 format(    ' No. of Hessian products', i14,
     &        2x,' Linear objective', 1p, e21.10
     &      /40x,' Quadratic objective', 1p, e18.10)
 1970 format(    ' No. of superbasics', i19,
     &        2x,' No. of basic nonlinears', i14)
 1975 format(    ' No. of degenerate steps', i14,
     &        2x,' Percentage', f27.2)

      end ! of s5solv

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s5SQP ( Hprod, Hprod1, QPlog, Prob, iError, itn,
     &     lenR, m, maxS, mBS, n, nb, nDegen, Hcalls,
     &     ngQP0, ngQP, nGobj0, nGobj, nnH0, nnH, nS, mxitQP, itQP, 
     &     minimz, iObj, sclObj, ObjAdd, ObjQP,
     &     tolFP, tolQP, tolx, nInf, sInf, wtInf, piNorm,
     &     ne, nlocA, locA, indA, Acol, iHvar, jHvar, lenH, neH, H,
     &     hElast, hEstat, hfeas, hs, kBS, 
     &     Ascale, bl, bu, blBS, buBS,
     &     gBS, Gobj, gQP, Hdx, pi, R, rc, rg, 
     &     nrhs0, nrhs, rhs, lenx0, nx0, x0, x, xBS,
     &     iy, iy1, y, y1, y2, y3,
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      external
     &     Hprod, Hprod1, QPlog
      integer
     &     Hcalls, iError, iObj, itn, itQP, lenH, lenR, lenx0,
     &     lencu, leniu, lenru, lencw, leniw, lenrw, m, maxS, mBS,
     &     minimz, mxitQP, n, nb, ne, neH, nInf, ngQP0, ngQP, nnH0,
     &     nnH, nS, nDegen, nGobj0, nGobj, nlocA, nrhs0, nrhs, nx0,
     &     Prob, hfeas(mBS), kBS(mBS), hElast(nb), hEstat(nb), hs(nb),
     &     locA(nlocA), indA(ne), iHvar(lenH), jHvar(lenH),
     &     iy(nb), iy1(nb), iu(leniu), iw(leniw)
      double precision
     &     sclObj, ObjAdd, ObjQP,
     &     sInf, wtInf, piNorm, tolFP, tolQP, tolx,
     &     Acol(ne), Ascale(nb), bl(nb), bu(nb), blBS(mBS), buBS(mBS),
     &     gBS(mBS), Gobj(nGobj0), gQP(ngQP0), H(lenH), Hdx(nnH0),
     &     pi(m), R(lenR), rc(nb), rg(maxS), rhs(nrhs0),
     &     x(nb), x0(lenx0), xBS(mBS), y(nb), y1(nb), y2(nb), y3(nb),
     &     ru(lenru), rw(lenrw)
      character*8 
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     s5SQP   solves the current problem.  A basis is assumed to be
*     specified by nS, hs, x and the superbasic parts of kBS.
*     In particular, there must be nS values hs(j) = 2, and the
*     corresponding j's must be listed in kBS(m+1) thru kBS(m+nS).
*     The ordering in kBS matches the reduced Hessian R (if any).
*
*     A basis is assumed
*     to be specified by nS, hs(*), x(*) and the superbasic parts of
*     kBS(*).  In particular, there must be nS values hs(j) = 2, and
*     the corresponding j's must be listed in kBS(m+1) thru kBS(m+nS).
*     The ordering in kBS matches the reduced Hessian R (if any).
*
*     05 Oct 1994: First version of s5SQP.
*     06 Aug 1996: Min Sum option added.
*     14 Jul 1997: Thread-safe version.
*     13 Nov 2000: Current version of s5SQP.
*     ==================================================================
      logical
     &     Elastc, gotR, needLU, needx
      character*20
     &     contyp
      integer
     &     typeLU, iPrint, iSumm, lvlInf, MnrPrt, lEmode, lPrint,
     &     MnrHdg, MjrHdg, MjrSum, subopt
      double precision
     &     rgNorm, rgTest
*     ------------------------------------------------------------------
      integer            FP,     LP,     QP
      parameter         (FP = 0, LP = 1, QP = 2)
      integer            Free
      parameter         (Free = 1)
      integer            BS       
      parameter         (BS = 1)
      integer            No
      parameter         (No     =-1)
      double precision   zero
      parameter         (zero = 0.0d+0)
      parameter         (MnrHdg    = 223) ! >0 => Mnr heading for iPrint
      parameter         (MjrHdg    = 224) ! >0 => Mjr heading for iPrint
      parameter         (MjrSum    = 225) ! >0 => Mjr heading for iSumm 
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      lEmode    = iw( 56) ! >0    => use elastic mode
      lvlInf    = iw( 73) ! Elastic option
      MnrPrt    = iw( 93) ! Minor print level

      lPrint     = MnrPrt
      iw(MnrHdg) = 0
      iw(MjrHdg) = 0
      iw(MjrSum) = 0

      Elastc    = lEmode .eq. 2
      call iload ( nb, 0, hEstat, 1 )

      ObjQP     = zero
      contyp    = 'linear rows'

      needLU    = .true.
      needx     =  needLU
      subopt    =  No

      if (Prob .eq. FP) then
*        ---------------------------------------------------------------
*        Find a feasible point.
*        ---------------------------------------------------------------
         call s5LP  ( Prob, contyp, Elastc, iError, subopt,
     &        QPlog, needLU, needx,
     &        m, n, nb, nDegen, mxitQP, itQP, itn,
     &        lEmode, lvlInf, lPrint,
     &        minimz, iObj, sclObj, ObjAdd, tolFP, tolQP, tolx,
     &        nInf, sInf, wtInf, piNorm, rgNorm,
     &        ne, nlocA, locA, indA, Acol,
     &        hElast, hEstat, hfeas, hs, kBS,
     &        Ascale, bl, bu, blBS, buBS, 
     &        gBS, pi, rc, nrhs0, nrhs, rhs, x, xBS, x,
     &        iy, iy1, y, y1, y2,
     &        cw, lencw, iw, leniw, rw, lenrw )

      else if (Prob .eq. LP  .and.  nGobj .eq. 0) then
*        ---------------------------------------------------------------
*        Linear program with objective row in A.
*        ---------------------------------------------------------------
         call s5LP  ( Prob, contyp, Elastc, iError, subopt,
     &        QPlog, needLU, needx,
     &        m, n, nb, nDegen, mxitQP, itQP, itn,
     &        lEmode, lvlInf, lPrint,
     &        minimz, iObj, sclObj, ObjAdd, tolFP, tolQP, tolx,
     &        nInf, sInf, wtInf, piNorm, rgNorm, 
     &        ne, nlocA, locA, indA, Acol,
     &        hElast, hEstat, hfeas, hs, kBS,
     &        Ascale, bl, bu, blBS, buBS, 
     &        gBS, pi, rc, nrhs0, nrhs, rhs, x, xBS, x,
     &        iy, iy1, y, y1, y2,
     &        cw, lencw, iw, leniw, rw, lenrw )

      else if (Prob .eq. QP  .or.  nGobj .gt. 0) then
*        ---------------------------------------------------------------
*        Quadratic program or linear program with an explicit objective.
*        ---------------------------------------------------------------
         call s5fixS( Free, m, maxS, mBS, n, nb, nS, hs, kBS, 
     &        bl, bu, blBS, buBS, x, xBS )

         typeLU = BS
         gotR   = .false.

         call s5QP  ( Prob, contyp, Elastc, iError, subopt,
     &        Hprod, Hprod1, QPlog, gotR, needLU, typeLU, needx,
     &        lenR, m, maxS, mBS, n, nb, nDegen, Hcalls,
     &        ngQP0, ngQP, nGobj0, nGobj, nnH0, nnH,
     &        nS, mxitQP, itQP, itn, lEmode, lvlInf, lPrint, 
     &        minimz, iObj, sclObj, ObjAdd, ObjQP,
     &        tolFP, tolQP, tolx, nInf, sInf, wtInf,
     &        piNorm, rgNorm, ne, nlocA, locA, indA, Acol,
     &        iHvar, jHvar, lenH, neH, H,
     &        hElast, hEstat, hfeas, hs, kBS,
     &        Ascale, bl, bu, blBS, buBS,
     &        gBS, Gobj, gQP, Hdx, y3, pi, R, rc, rg,
     &        nrhs0, nrhs, rhs, lenx0, nx0, x0, x, xBS, x,
     &        iy, iy1, y, y1, y2, 
     &        cu, lencu, iu, leniu, ru, lenru, 
     &        cw, lencw, iw, leniw, rw, lenrw )
      end if

*     Check for fatal errors that have already been signalled.

      if (iError .ge. 30                      ) return
      if (iError .ge. 20  .and.  itn    .eq. 0) return

*     ==================================================================
*     Error exits.
*     No error messages have been printed so far.
*     ==================================================================
  800 if (iError .eq. 0  .or.  iError .eq. 1) then
*        -------------------------------------------
*        Optimal.
*        -------------------------------------------
*        call s1page( 2, iw, leniw )

         if (nInf .gt. 0) then
*           ----------------------------------------
*           Infeasible.
*           ----------------------------------------
            if (iError .eq. 1) then
               if (iPrint .gt. 0) write(iPrint, 7010) itn
               if (iSumm  .gt. 0) write(iSumm , 7010) itn
            else if (lEmode .gt. 0) then
               iError = 1
               if (     lvlInf .eq. 0) then
                  if (iPrint .gt. 0) write(iPrint, 8010) itn
                  if (iSumm  .gt. 0) write(iSumm , 8010) itn
               else if (lvlInf .eq. 1) then
                  if (iPrint .gt. 0) write(iPrint, 8011) itn
                  if (iSumm  .gt. 0) write(iSumm , 8011) itn
               else if (lvlInf .eq. 2) then
                  if (iPrint .gt. 0) write(iPrint, 8012) itn
                  if (iSumm  .gt. 0) write(iSumm , 8012) itn
               end if
            end if
            if (iPrint .gt. 0) write(iPrint, 9010)
            if (iSumm  .gt. 0) write(iSumm , 9010)

         else if (Prob .eq. FP) then
            if (iPrint .gt. 0) write(iPrint, 9015)
            if (iSumm  .gt. 0) write(iSumm , 9015)

         else if (Prob .eq. LP  .or.  Prob .eq. QP) then
            if (iPrint .gt. 0) write(iPrint, 9000)
            if (iSumm  .gt. 0) write(iSumm , 9000)

            rgTest = rgNorm / piNorm
            if (rgTest .gt. 0.1d+0) then 
               if (iPrint .gt. 0) write(iPrint, 9005)
               if (iSumm  .gt. 0) write(iSumm , 9005)
            end if

         else
            if (iPrint .gt. 0) write(iPrint, 9015)
            if (iSumm  .gt. 0) write(iSumm , 9015)
         end if

      else

         call s1page( 2, iw, leniw )

         if (iError .eq. 2) then
*           -------------------------------------------
*           Unbounded.
*           -------------------------------------------
            if (iPrint .gt. 0) write(iPrint, 9200)
            if (iSumm  .gt. 0) write(iSumm , 9200)

         else if (iError .eq. 3) then
*           -------------------------------------------
*           Too many iterations.
*           -------------------------------------------
            if (itQP .ge. mxitQP) then
               if (iPrint .gt. 0) write(iPrint, 9301)
               if (iSumm  .gt. 0) write(iSumm , 9301)
            else
               if (iPrint .gt. 0) write(iPrint, 9302)
               if (iSumm  .gt. 0) write(iSumm , 9302)
            end if

         else if (iError .eq. 4) then
*           -------------------------------
*           Weak solution
*           -------------------------------
            if (iPrint .gt. 0) write(iPrint, 9600)
            if (iSumm  .gt. 0) write(iSumm , 9600)

         else if (iError .eq. 5) then
*           -------------------------------
*           Superbasic limit too small.
*           -------------------------------
            if (iPrint .gt. 0) write(iPrint, 9500) maxS
            if (iSumm  .gt. 0) write(iSumm , 9500) maxS

         else if (iError .eq. 6) then
*           ---------------------------------
*           Hessian appears to be indefinite.
*           ---------------------------------
            if (iPrint .gt. 0) write(iPrint, 9400)
            if (iSumm  .gt. 0) write(iSumm , 9400)
         end if
      end if

      return

 7010 format(  ' Itn', i7, ': Infeasible non-elastic variables')
 8010 format(  ' Itn', i7, ': Infeasible elastic variables')
 8011 format(  ' Itn', i7, ': Obj + weighted elastics minimized')
 8012 format(  ' Itn', i7, ': Elastic variables minimized')

 9000 format(  ' EXIT -- optimal solution found')
 9005 format(/ ' XXX  WARNING -- reduced gradient is large --',
     &         ' solution is not really optimal')
 9010 format(  ' EXIT -- the problem is infeasible')
 9015 format(  ' EXIT -- feasible point found')
 9200 format(  ' EXIT -- the problem is unbounded ',
     &         ' (or badly scaled)')
 9301 format(  ' EXIT -- too many iterations')
 9302 format(  ' EXIT -- iteration limit exceeded')
 9400 format(  ' EXIT -- QP Hessian appears to be indefinite')
 9500 format(  ' EXIT -- the superbasics limit is too small:', i7)
 9600 format(  ' EXIT -- weak solution found')

      end ! of s5SQP

