*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
*     File  sn80ncon.f
*
*     s8feas   s8FD     s8Fx     s8Gcpy   s8Gloc   s8Gprd   s8Hfix
*     s8Infs   s8iqp    s8mrt    s8PPHx   s8rand   s8rc     s8sclJ
*     s8sInf   s8step   s8sOpt   s8wInf
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8feas( MnrLog, iError, lenR, m, maxS, mBS,
     &     n, nb, nnCon0, nnCon, nnL0, nnL, nDegen, nS,
     &     numLC, numLIQ, itn, itnlim, itQP, MnrPrt, sclObj,
     &     tolQP, tolx, nInf, sInf, wtInf, piNorm, rgNorm,
     &     ne, nlocJ, locJ, indJ, Jcol,
     &     hElast, hEstat, hfeas, hs, kBS, 
     &     Ascale, bl, bu, blSav, buSav, blBS, buBS,
     &     gBS, pi, R, rc, QPrhs, x0, x, xBS, xFix,
     &     iy, iy1, y, y1, y2, y3,
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      external
     &     MnrLog
      integer
     &     iError, lenR, m, maxS, mBS, n, nb, nnCon0, nnCon, ne, nlocJ,
     &     nnL0, nnL, nDegen, nS, numLC, numLIQ, nInf, itn, itnlim,
     &     itQP, MnrPrt, lencw, leniw, lenrw, locJ(nlocJ), indJ(ne),
     &     kBS(mBS), hfeas(mBS), hEstat(nb), hElast(nb), hs(nb), iy(nb),
     &     iy1(nb), iw(leniw)
      double precision
     &     sclObj, tolQP, tolx, sInf, wtInf, piNorm, rgNorm,
     &     Jcol(ne), Ascale(nb), bl(nb), bu(nb), blSav(nb), buSav(nb),
     &     blBS(mBS), buBS(mBS), gBS(mBS), xBS(mBS), R(lenR),
     &     rc(nb), QPrhs(nnCon0), x0(nnL0), x(nb), xFix(nb), pi(m),
     &     y(nb), y1(nb), y2(nb), y3(nb), rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     s8feas   finds a feasible point for a set of linear constraints.
*     A basis is assumed
*     to be specified by nS, hs(*), x(*) and the superbasic parts of
*     kBS(*).  In particular, there must be nS values hs(j) = 2, and
*     the corresponding j's must be listed in kBS(m+1) thru kBS(m+nS).
*     The ordering in kBS matches the reduced Hessian R (if any).
*
*     On entry, blSav and blSav contain copies of the true (possibly 
*     scaled) upper and bounds set in s5getB.
*
*     11 May 1994: First version of s8feas.
*     19 Aug 1996: First minsum version.
*     05 Feb 1998: Proximal point norm changed to one-norm.
*     23 Dec 1999: Optional Proximal Point methods 0 and  2 added.
*     30 Oct 2000: Current version.
*     ==================================================================
      character*20
     &     contyp
      logical
     &     Elastc, gotR, needLU, needx
      integer
     &     iPrint, iSumm, typeLU, iObjPP, j, lvlInf, lvlPPm, lEmode,
     &     lHdx, lrg, lgQP, minimz, neH, Hcalls, lenH,
     &     nviol, nObjP0, nObjPP, subopt, iDummy(1)
      double precision
     &     blj, buj, eps0, eps1, ObjA, ObjPP, x0j, tolFP, tolQPP,
     &     Dummy(1)
      external
     &     s8PPHx
*     ------------------------------------------------------------------
      integer            FP,         QPP
      parameter         (FP     = 0, QPP=6)
      integer            BT   
      parameter         (BT     = 2)
      integer            Normal
      parameter         (Normal = 0)
      integer            No,         Yes
      parameter         (No     =-1, Yes    = 0)

      double precision   zero,          one
      parameter         (zero = 0.0d+0, one = 1.0d+0)
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      lvlPPm    = iw( 79) ! Proximal Point method for x0

      eps0      = rw(  2) ! eps**(4/5)
      eps1      = rw(  3) ! eps**(2/3)

*     Pointers

      lHdx      = iw(288) ! Hdx(nnQP)   = product of H with  x1 - x
      lgQP      = iw(290) ! gQP(negQP)  = QP gradient 
      lrg       = iw(293) ! rg (maxS)   = reduced gradient

      ObjA      = zero
      iObjPP    = 0
      minimz    = 1
      lvlInf    = 2
      lEmode    = 1             !  Enter elastic mode if infeasible

      Elastc    = .false.
      needLU    = .true.
      needx     =  needLU

*     Set the LP rhs to make x satisfy the (relaxed) nonlinear rows.
*     The array  QPrhs  contains the rhs.
*     Use a fairly tight optimality tolerance for phase 1.

      if (nnCon .gt. 0) then
         call dcopy ( nnCon, x(n+1), 1, QPrhs, 1 )
         call s2Aprd( Normal, eps0,
     &        ne, nlocJ, locJ, indJ, Jcol,
     &        one, x, n, (-one), QPrhs, nnCon )
      end if

      tolFP  = eps1

      if (numLIQ .gt. 0  .or.  nInf .gt. 0) then
*        ---------------------------------------------------------------
*        Find a feasible point for the linear constraints.
*        If none exists, minimize the sum of infeasibilities of the
*        linear rows, subject to the column bounds.
*        ---------------------------------------------------------------
         call iload ( numLC, 3, hElast(n+nnCon+1), 1 )

         contyp = 'linear rows'
         subopt = No

         call s5LP  ( FP, contyp, Elastc, iError, subopt,
     &        MnrLog, needLU, needx,
     &        m, n, nb, nDegen, itnlim, itQP, itn,
     &        lEmode, lvlInf, MnrPrt,
     &        minimz, iObjPP, sclObj, ObjA, tolFP, tolQP, tolx,
     &        nInf, sInf, wtInf, piNorm, rgNorm,
     &        ne, nlocJ, locJ, indJ, Jcol,
     &        hElast, hEstat, hfeas, hs, kBS, 
     &        Ascale, bl, bu, blBS, buBS,
     &        gBS, pi, rc, nnCon0, nnCon, QPrhs, x, xBS, xFix,
     &        iy, iy1, y, y1, y2,
     &        cw, lencw, iw, leniw, rw, lenrw )

*        Stop if the linear constraints are infeasible.
*        s5LP will have minimized the sum of infeasibilities.

         if (iError .eq. 0  .and.  nInf .gt. 0) iError = 1
         if (iError .gt. 0) go to 800

*        Now the linear rows are feasible, they are never allowed
*        to be infeasible again.

         call iload ( numLC, 0, hElast(n+nnCon+1), 1 )

*        Print something brief if s5LP didn't already do so.

         if (iPrint .gt. 0) write(iPrint, 1000)

         if (MnrPrt .eq. 0) then
            if (iPrint .gt. 0) write(iPrint, 8010) itn
            if (iSumm  .gt. 0) write(iSumm , 8010) itn
         end if
      end if

      if (lvlPPm .gt. 0  .and.  nnL .gt. 0) then
*        ===============================================================
*        x  is feasible for the linear constraints.
*        Find a feasible point closest to x0.
*        Minimize norm(x - x0).
*        ===============================================================
         if (lvlPPm .eq. 1) then
*           ------------------------------------------------------------
*           Minimize the one-norm of (x-x0) by fixing the nonlinear 
*           variables so that bl = x0 = bu.  Any bl or bu that is moved 
*           to  x0  is allowed to be elastic.
*           ------------------------------------------------------------
            do j = 1, nnL
               blj = bl(j)
               buj = bu(j)

               if (blj .eq. buj) then
*                 Relax
               else
                  x0j       = x0(j)
                  bl(j)     = x0j
                  bu(j)     = x0j
                  hElast(j) = 3

                  if (hs(j) .le. 1) then
                     x(j) = x0j
                  end if
               end if
            end do

            contyp = 'norm(x-x0) problem  '
            needx  = .true.
            subopt = No

            call s5LP  ( FP, contyp, Elastc, iError, subopt,
     &           MnrLog, needLU, needx,
     &           m, n, nb, nDegen, itnlim, itQP, itn,
     &           lEmode, lvlInf, MnrPrt,
     &           minimz, iObjPP, sclObj, ObjA, tolFP, tolQP, tolx,
     &           nInf, sInf, wtInf, piNorm, rgNorm,
     &           ne, nlocJ, locJ, indJ, Jcol,
     &           hElast, hEstat, hfeas, hs, kBS, 
     &           Ascale, bl, bu, blBS, buBS,
     &           gBS, pi, rc, nnCon0, nnCon, QPrhs, x, xBS, xFix,
     &           iy, iy1, y, y1, y2,
     &           cw, lencw, iw, leniw, rw, lenrw )
 
*           Some elastic variables may have moved outside their bounds. 
*           Count them.  Reset the true bounds.

            nviol = 0
            do j = 1, nnL
               bl(j) = blSav(j)
               bu(j) = buSav(j)
            
               if (x(j) .lt. bl(j) - tolx  .or.
     &             x(j) .gt. bu(j) + tolx      ) then
                  nviol = nviol + 1
               end if
            end do

            if (iError .gt. 0) go to 800

            if (iPrint .gt. 0) write(iPrint, 8020) itn, sInf
            if (iSumm  .gt. 0) write(iSumm , 8020) itn, sInf

            if (nviol .gt. 0) then
               contyp = 'linear rows again   '
               Elastc = .false.
               needx  = .true.
               subopt = No

               call s5LP  ( FP, contyp, Elastc, iError, subopt,
     &              MnrLog, needLU, needx,
     &              m, n, nb, nDegen, itnlim, itQP, itn,
     &              lEmode, lvlInf, MnrPrt,
     &              minimz, iObjPP, sclObj, ObjA, tolFP, tolQP, tolx,
     &              nInf, sInf, wtInf, piNorm, rgNorm,
     &              ne, nlocJ, locJ, indJ, Jcol,
     &              hElast, hEstat, hfeas, hs, kBS, 
     &              Ascale, bl, bu, blBS, buBS,
     &              gBS, pi, rc, nnCon0, nnCon, QPrhs, x, xBS, xFix,
     &              iy, iy1, y, y1, y2,
     &              cw, lencw, iw, leniw, rw, lenrw )
               if (iError .eq. 0) then
                  if (iPrint .gt. 0) write(iPrint, 8030) itn, nviol
                  if (iSumm  .gt. 0) write(iSumm , 8030) itn, nviol
               end if
            end if

            nInf = 0
            sInf = zero

*           Now the nonlinear variables are feasible, they are never 
*           allowed to be infeasible again.

            call iload ( nnL, 0, hElast, 1 )

         else if (lvlPPm .eq. 2) then
*           ------------------------------------------------------------
*           Minimize the two-norm of (x-x0).
*           ------------------------------------------------------------
            nObjPP = 0          ! No explicit gradient in proximal point
            nObjP0 = 1
            tolQPP = 1.0d-3     ! Sloppy optimality tolerance for QPP.
            gotR   = .false.
            needLU = .false.
            typeLU = BT
            Hcalls = 0
            lenH   = 1
            neH    = 0

            contyp = 'norm(x-x0) problem  '
            needx  = .false.
            subopt = Yes

            call s5QP  ( QPP, contyp, Elastc, iError, subopt,
     &           s8PPHx, s8PPHx, Mnrlog, gotR, needLU, typeLU, needx,
     &           lenR, m, maxS, mBS, n, nb, nDegen, Hcalls,
     &           nnL0, nnL, nObjP0, nObjPP, nnL0, nnL,
     &           nS, itnlim, itQP, itn, lEmode, lvlInf, MnrPrt,
     &           minimz, iObjPP, sclObj, ObjA, ObjPP, 
     &           tolFP, tolQPP, tolx, nInf, sInf, wtInf, 
     &           piNorm, rgNorm, ne, nlocJ, locJ, indJ, Jcol,
     &           iDummy, iDummy, lenH, neH, Dummy,
     &           hElast, hEstat, hfeas, hs, kBS,
     &           Ascale, bl, bu, blBS, buBS,
     &           gBS, rw(lgQP), rw(lgQP), rw(lHdx), y3, pi,R,rc,rw(lrg),
     &           nnCon0, nnCon, QPrhs, nnL0, nnL, x0, x, xBS, xFix,
     &           iy, iy1, y, y1, y2,
     &           cw, lencw, iw, leniw, rw, lenrw,
     &           cw, lencw, iw, leniw, rw, lenrw )

*           Stop if the linear constraints are infeasible.
*           This shouldn't happen!

            if (iError .eq. 0  .and.  nInf .gt. 0) iError = 1
            if (iError .gt. 0) go to 800

*           Now the linear rows are feasible, they are never allowed
*           to be infeasible again.

            call iload ( numLC, 0, hElast(n+nnCon+1), 1 )

*           Print something brief if s5LP didn't already do so.

            if (iPrint .gt. 0) then
               write(iPrint, 1000)
               write(iPrint, 8100) itn, ObjPP
            end if
            if (iSumm  .gt. 0)
     &         write(iSumm , 8100) itn, ObjPP

         end if ! Proximal Point method 1 

      end if ! nnL > 0

  800 if (iError .eq. 0 ) then
*        --------------------------------------------------
*        Relax, a feasible point for the linear constraints
*        has been found.
*        --------------------------------------------------
      else
         call s1page( 2, iw, leniw )

         if (iError .eq.  1) then
*           -------------------------------------------
*           Infeasible.
*           -------------------------------------------
            if (iPrint .gt. 0) write(iPrint, 9010)
            if (iSumm  .gt. 0) write(iSumm , 9010)

         else if (iError .eq.  3) then
*           -------------------------------------------
*           Too many iterations.
*           -------------------------------------------
            if (iPrint .gt. 0) write(iPrint, 9031)
            if (iSumm  .gt. 0) write(iSumm , 9031)
         end if
      end if

      return

 1000 format(' ')
 8010 format(  ' Itn', i7, ': Feasible linear rows')
 8020 format(  ' Itn', i7, ': PP1: Norm(x-x0) minimized  (',
     &                 1p, e8.2, ')')
 8030 format(  ' Itn', i7, ': PP1: ',
     &                 i7, ' nonlinear variables made feasible')
 8100 format(  ' Itn', i7, ': PP2: Norm(x-x0) minimized  (',
     &                 1p, e8.2, ')')
 9010 format(  ' EXIT -- the linear constraints are infeasible')
 9031 format(  ' EXIT -- iteration limit exceeded')

      end ! of s8feas

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8FD  ( nnCon0, nnCon, nnObj, itn, cdItns,
     &     centrl, goodG, newG, useFD, info, duInf,
     &     Fcon, Fobj, iw, leniw, rw, lenrw )

      implicit
     &     none
      logical
     &     centrl, goodG, newG, useFD
      integer
     &     nnCon0, nnCon, nnObj, itn, cdItns, leniw, lenrw,
     &     info(6), iw(leniw)
      double precision
     &     duInf, Fcon(nnCon0), Fobj, rw(lenrw)

*     ==================================================================
*     s8FD   controls the switch from forward to central differences and
*     vice versa.
*
*     If the forward-difference estimate of the reduced gradient of the
*     Lagrangian is small,  a switch is made to central differences. 
*     In this case, the derivatives are recomputed and the QP is solved 
*     again. 
*
*     On the other hand, if central differences have produced a large
*     reduced-gradient norm, switch back to forward differences.
*
*     31 Mar 2000: First version of s8FD written for SNOPT 6.1.
*     21 Oct 2000: Current version.
*     ==================================================================
      integer
     &     iPrint, iSumm, lvlDif
      double precision
     &     epsrf, cNorm, fdint1, Objsiz, rgNorm, rgTest, dnrm1s
*     ------------------------------------------------------------------
      integer            iFDiff
      parameter         (iFDiff    = 6)
      parameter         (lvlDif    = 182) ! forwd diffs or cntrl diffs
      double precision   zero,          one,          ten
      parameter         (zero = 0.0d+0, one = 1.0d+0, ten = 10.0d+0)
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file

      epsrf     = rw( 73) ! relative function precision.
      fdint1    = rw( 76) ! (1) forwrd diff. interval

      cNorm  = zero
      if (nnCon .gt. 0) cNorm  = dnrm1s( nnCon, Fcon, 1 )
      ObjSiz = zero
      if (nnObj .gt. 0) ObjSiz = abs(Fobj)

      goodG  = .true.
      rgTest = (one + ObjSiz + cNorm)*epsrf/fdint1
      rgNorm = duInf

      if ( centrl ) then
         if (rgNorm .gt. ten*rgTest  .and.  cdItns .gt. 0) then
            iw(lvlDif) =  1
            centrl     = .false.
            if ( useFD ) then
               info(iFDiff) = 0
            end if
         end if
      else
         if (rgNorm .le.     rgTest) then
            cdItns     = 0
            iw(lvlDif) = 2
            if ( useFD ) then
               goodG   = .false.
               newG    = .true.
               info(iFDiff) = 1
               if (iPrint .gt. 0) write(iPrint, 1000) itn
               if (iSumm  .gt. 0) write(iSumm , 1000) itn
            end if
         end if
      end if

 1000 format( ' Itn', i7, ' -- Central differences invoked.',
     &       '  Small reduced gradient.' )

      end ! of s8FD

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8Fx  ( n, nnCon, nnJac, tolz,
     &     ne, nlocJ, locJ, indJ, Jcol, Fcon, x, Fx )

      implicit
     &     none
      integer
     &     n, nnCon, nnJac, ne, nlocJ, indJ(ne), locJ(nlocJ)
      double precision
     &     tolz, Jcol(ne), x(n+nnCon), Fcon(nnCon), Fx(nnCon)

*     ==================================================================
*     s8Fx  defines the nonlinear constraint values
*       Fx  =  true nonlinear slack = Fcon + A(linear)*x,
*
*     09 Jan 1992: First version based on Minos routine m8viol.
*     16 Nov 1998: Norm x changed to include only columns.
*     21 Oct 2000: Made compatible with SNOPT 6.1
*     21 Oct 2000: Current version of s8Fx
*     ==================================================================
      integer
     &     nlin
*     ------------------------------------------------------------------
      integer            Normal
      parameter         (Normal = 0)
      double precision   one
      parameter         (one = 1.0d+0)
*     ------------------------------------------------------------------
*     Compute the nonlinear constraint value.
*     Set  Fx  =  Fcon + (linear A)*x,   excluding slacks.

      call dcopy ( nnCon, Fcon, 1, Fx, 1 )

      nlin = n - nnJac
      if (nlin .gt. 0) then
         call s2Aprd( Normal, tolz, 
     &        ne, nlin+1, locJ(nnJac+1), indJ, Jcol,
     &        one, x(nnJac+1), nlin, one, Fx, nnCon )
      end if

      end ! of s8Fx

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8Gcpy( nnCon, nnJac, ne, nlocJ, locJ, indJ, 
     &     neG1, nlocG1, locG1, G1, 
     &     neG2, nlocG2, locG2, G2 )

      implicit
     &     none
      integer
     &     nnCon, nnJac, neG1, neG2, nlocG1, nlocG2, ne, nlocJ,
     &     indJ(ne), locJ(nlocJ), locG1(nlocG1), locG2(nlocG2)
      double precision
     &     G1(neG1), G2(neG2)

*     ==================================================================
*     s8Gcpy  copies G1 into G2 when either  G1 or  G2 
*     is stored in the upper-left hand corner of J.
*
*     16 Sep 1993: First version.
*     26 Oct 2000: Current version.
*     ==================================================================
      integer
     &     ir, j, k, l1, l2
*     ------------------------------------------------------------------
      do j  = 1, nnJac
         l1 = locG1(j)
         l2 = locG2(j)
         do k  = locJ(j), locJ(j+1)-1
            ir = indJ(k)
            if (ir .gt. nnCon) go to 100
            G2(l2) = G1(l1)
            l1  = l1 + 1
            l2  = l2 + 1
         end do
  100    continue
      end do

      end ! of s8Gcpy

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8Gloc( nnCon, nnJac,
     &     ne, nlocJ, locJ, indJ, neG, nlocG, locG )

      implicit
     &     none
      integer
     &     ne, neG, nlocG, nlocJ, nnCon, nnJac, indJ(ne)
      integer
     &     locJ(nlocJ), locG(nlocG)

*     ==================================================================
*     s8Gloc  counts the number of nonlinear Jacobian elements and 
*     assembles their column pointers in locG.
*
*     29 Oct 2000: First version of s8Gloc.
*     29 Oct 2000: Current version.
*     ==================================================================
      integer
     &     ir, j, k
*     ------------------------------------------------------------------
      neG     = 0
      locG(1) = 1
      do j = 1, nnJac
         do  k = locJ(j), locJ(j+1)-1
            ir = indJ(k)
            if (ir .gt. nnCon) go to 100
            neG = neG + 1
         end do
  100    locG(j+1) = neG + 1
      end do

      end ! of s8Gloc

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8Gprd( Task, tolz, 
     &     ne, nlocJ, locJ, indJ, neG, nlocG, locG, Gcon, 
     &     alpha, x, lenx, beta, y, leny )

      implicit
     &     none
      integer
     &     Task, ne, neG, nlocG, nlocJ, lenx, leny, indJ(ne),
     &     locJ(nlocJ), locG(nlocG)
      double precision
     &     tolz, alpha, beta, Gcon(neG), x(lenx), y(leny)

*     ==================================================================
*     s8Gprd computes matrix-vector products involving J and x.  The 
*     variable task specifies the operation to be performed as follows:
*       task = 'N' (normal)          y := alpha*J *x + beta*y,
*       task = 'T' (transpose)       y := alpha*J'*x + beta*y,
*     where alpha and beta are scalars, x and y are vectors and J is a
*     sparse matrix whose columns are in natural order.
*
*     26 Oct 2000: Current version.
*     ==================================================================
      integer
     &     i, ig, iJ, ir, j
      double precision
     &     alphxj, sum, xj
*     ------------------------------------------------------------------
      integer            Normal,        Transp
      parameter         (Normal = 0,    Transp = 1)
      double precision   zero,          one
      parameter         (zero = 0.0d+0, one = 1.0d+0)
*     ------------------------------------------------------------------
      if (alpha .eq. zero  .and.  beta .eq. one)
     &   return

*     First form  y := beta*y.

      if (beta .ne. one) then
         if (beta .eq. zero) then
            do i = 1, leny
               y(i) = zero
            end do
         else
            do i = 1, leny
               y(i) = beta*y(i)
            end do
         end if
      end if

      if (alpha .eq. zero) then

*        Relax

      else if (alpha .eq. (-one)) then

         if (Task .eq. Normal) then
            do  j = 1, lenx
               xj = x(j)
               if (abs( xj ) .gt. tolz) then
                  ig = locG(j)
                  do iJ = locJ(j), locJ(j+1)-1
                     ir = indJ(iJ)
                     if (ir .gt. leny) go to 100
                     y(ir) = y(ir) - Gcon(ig)*xj
                     ig    = ig + 1
                  end do
               end if
  100          continue
            end do

         else if (Task .eq. Transp) then

            do j   = 1, leny
               sum = y(j)
               ig  = locG(j)
               do iJ = locJ(j), locJ(j+1)-1
                  ir = indJ(iJ)
                  if (ir .gt. lenx) go to 200
                  sum = sum - Gcon(ig)*x(ir)
                  ig  = ig + 1
               end do
  200          y(j) = sum
            end do
         end if                          

      else ! General alpha

         if (Task .eq. Normal) then
            do j = 1, lenx
               alphxj = alpha*x(j)
               if (abs( alphxj ) .gt. tolz) then
                  ig  = locG(j)
                  do iJ = locJ(j), locJ(j+1)-1
                     ir = indJ(iJ)
                     if (ir .gt. leny) go to 300
                     y(ir) = y(ir) + Gcon(ig)*alphxj
                     ig    = ig + 1
                  end do
               end if
  300          continue
            end do
         else if (Task .eq. Transp) then
            do j   = 1, leny
               sum = zero
               ig  = locG(j)
               do iJ = locJ(j), locJ(j+1)-1
                  ir = indJ(iJ)
                  if (ir .gt. lenx) go to 400
                  sum = sum + Gcon(ig)*x(ir)
                  ig  = ig + 1
               end do
  400          y(j) = y(j) + alpha*sum
            end do
         end if ! task .eq. Normal
      end if ! general alpha

      end ! of s8Gprd

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8Gsiz( m, nnCon, nnJac,
     &     ne, nlocJ, locJ, indJ, neG )

      implicit
     &     none
      integer
     &     m, ne, neG, nlocJ, nnCon, nnJac, indJ(ne)
      integer
     &     locJ(nlocJ)

*     ==================================================================
*     s8Gsiz  counts the number of nonlinear Jacobian elements.
*
*     04 Nov 2000: First version of s8Gsiz
*     04 Nov 2000: Current version.
*     ==================================================================
      integer
     &     ir, k, last, nlocG
*     ------------------------------------------------------------------
      neG   = 0
      nlocG = nnJac + 1

      if (nnCon .gt. 0) then
         last = locJ(nlocG) - 1
         if (nnCon .eq. m) then
            neG = last
         else
            do  k = 1, last
               ir = indJ(k)
               if (ir .le. nnCon) neG = neG + 1
            end do
         end if
      end if
      neG = max( 1, neG )

      end ! of s8Gsiz

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8Hfix( nnCon, nnJac, tolz,
     &     ne, nlocJ, locJ, indJ, neG, nlocG, locG, 
     &     ydx, ydxmin, PenUnm, Fcon, Fcon1, Gcon, Gcon1,
     &     dx, gd, PenU, v, w )

      implicit
     &     none
      integer
     &     nnCon, nnJac, ne, neG, nlocG, nlocJ, indJ(ne), locJ(nlocJ),
     &     locG(nlocG)
      double precision
     &     ydx, ydxmin, PenUnm, tolz, Gcon(neG), Gcon1(neG),
     &     Fcon(nnCon), Fcon1(nnCon), PenU(nnCon), v(nnCon), w(nnCon),
     &     dx(nnJac), gd(nnJac)

*     ==================================================================
*     s8Hfix  attempts to find the a vector xPen  of minimum two-norm
*     such that there exists a BFGS update for the modified Lagrangian
*       La   = f(x) - lambda'(Fcon1 - LFcon)
*                   + 1/2 (Fcon1 - LFcon)'*diag(PenU)*(Fcon1 - LFcon),
*
*     where  LFcon = Fcon + J(x1)*dx.
* 
*     On entry,
*     dx     is the nonlinear part of the search direction x2 - x1.
*     gd     is the Lagrangian gradient difference.
*     Gcon    is the Jacobian at the old x.
*     Gcon1    is the Jacobian at the new x. 
*     ydx    is the approximate curvature of the Lagrangian.
*     ydxmin   (ydx < ydxmin) is the smallest acceptable approximate
*              curvature.
*
*     On exit,
*     gd     is the augmented Lagrangian gradient difference.
*     PenU     are the penalty parameters.
*     ydx    is unchanged unless gotPen is true, in which case
*              ydx = ydxmin.
*
*     08 Dec 1991: First version based on  Npsol  routine npupdt.
*     26 Oct 2000: Current version of s8Hfix.
*     ==================================================================
      logical
     &     gotPen, overfl
      integer
     &     i
      double precision
     &    beta, ddiv, diff, dnrm2, Peni, wi, wmax, wnorm 
*     ------------------------------------------------------------------
      integer            Normal,     Transp
      parameter         (Normal = 0, Transp = 1)
      double precision   PenMax 
*-->  parameter         (PenMax = 1.0d+5)
*-->  parameter         (PenMax = 1.0d+16)
      parameter         (PenMax = 1.0d+5)
      double precision   zero,            one
      parameter         (zero   = 0.0d+0, one = 1.0d+0)
*     ------------------------------------------------------------------
      overfl    = .false.

*     Try an augmented Lagrangian term to increase ydx. 

      PenUnm = zero

*     Compute  v = J1*dx and w = (J2 - J1)*dx = J2*dx - v.

      call s8Gprd( Normal, tolz,
     &     ne, nlocJ, locJ, indJ,
     &     neG, nlocG, locG, Gcon, 
     &     one, dx, nnJac, zero, v, nnCon )
      call s8Gprd( Normal, tolz,
     &     ne, nlocJ, locJ, indJ,
     &     neG, nlocG, locG, Gcon1, 
     &     one, dx, nnJac, zero, w, nnCon )

      call daxpy ( nnCon, (-one), v, 1, w, 1 )

*     Compute the difference between c and its linearization.
*     v  =  c - cL = Fcon1 - (Fcon + J1*s) = Fcon1 - Fcon - J1*s.

      call daxpy ( nnCon, (-one), Fcon1, 1, v, 1 )
      call daxpy ( nnCon,   one , Fcon , 1, v, 1 )
      call dscal ( nnCon, (-one),     v, 1 )

*     ---------------------------------------------------------
*     Compute the minimum-length vector of penalty parameters
*     that makes the approximate curvature equal to  ydxmin.
*     ---------------------------------------------------------
*     Use w to hold the constraint on PenU.
*     Minimize            norm(PenU)  
*     subject to   ( Sum( w(i)*PenU(i) )  =   const,
*                  (           PenU(i)   .ge. 0.

      wmax = zero
      do i    = 1, nnCon
         wi   = w(i)*v(i)
         wmax = max( wmax, wi )
         w(i) = max( zero, wi )
      end do

      wnorm  = dnrm2 ( nnCon, w, 1 )
      diff   = ydxmin - ydx
      beta   = ddiv  ( wmax*diff, wnorm**2, overfl )
      gotPen = .not. overfl  .and.  wmax .gt. zero  
     &                       .and.  beta .lt. PenMax

      if ( gotPen ) then
         beta   = diff/wnorm**2

         do    i = 1, nnCon
            wi   = w(i)
            Peni = beta*wi
            v(i) =       Peni*v(i)
            ydx  = ydx + Peni*wi
            PenU(i) = Peni
         end do
         ydx    = max   ( ydx, ydxmin )
         PenUnm = dnrm2 ( nnCon, PenU, 1 )

*        Update  gd  by the term  (J2' - J1')*v,
*        with v = diag(PenU)*(Fcon1 - Fcon - J1*s) from above.

         call s8Gprd( Transp, tolz,
     &        ne, nlocJ, locJ, indJ,
     &        neG, nlocG, locG, Gcon1, 
     &          one , v, nnCon, one, gd, nnJac )
         call s8Gprd( Transp, tolz,
     &        ne, nlocJ, locJ, indJ,
     &        neG, nlocG, locG, Gcon, 
     &        (-one), v, nnCon, one, gd, nnJac )
      end if ! gotPen

      end ! of s8Hfix

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8Infs( Elastc, n, nb, nnCon0, nnCon, wtInf,
     &     prInf, duInf, jprInf, jduInf, bl, bu, Fx, rc, x )

      implicit
     &     none
      logical
     &     Elastc
      integer
     &     n, nb, nnCon0, nnCon, jprInf, jduInf
      double precision
     &     wtInf, duInf, prInf, bl(nb), bu(nb), rc(nb), x(nb),
     &     Fx(nnCon0)

*     ==================================================================
*     s8Infs computes the maximum primal and dual infeasibilities,
*     using bl, bu, rc, x and the true nonlinear slacks Fxslk.
*     The linear constraints and bounds are assumed to be satisfied.
*     The primal infeasibility is therefore the maximum violation of
*     the nonlinear constraints.
*     The dual infeasibility is the maximum complementarity gap
*     for the bound constraints (with bounds assumed to be no further
*     than 1.0 from each x(j)).
*
*     prInf, duInf   return the max primal and dual infeas.
*
*     20 Feb 1994: First version based on Minos 5.5 routine m8infs.
*     25 Oct 1996: Elastic mode added.
*     30 Oct 2000: Current version.
*     ==================================================================
      integer
     &     i, j
      double precision
     &     dj, slack, viol, v, w
*     ------------------------------------------------------------------
      double precision   zero,           one
      parameter        ( zero = 0.0d+0,  one = 1.0d+0 )
*     ------------------------------------------------------------------

      jprInf = 0
      prInf  = zero

*     See how much  Fx  violates the bounds on the nonlinear slacks.
*     prInf is the maximum violation.

      do i = 1, nnCon
         j     = n + i
         slack = Fx(i)
         viol  = max( zero, bl(j) - slack, slack - bu(j) )
         if (prInf .lt. viol) then
            prInf  = viol
            jprInf = j
         end if
      end do

*     ------------------------------------------------------------------
*     + rc(j)  is the multiplier for lower bound constraints.
*     - rc(j)  is the multiplier for upper bound constraints.
*     duInf is the maximum complementarity gap.
*     ------------------------------------------------------------------
      jduInf = 0
      duInf  = zero
      do j = 1, nb
         if (bl(j) .lt. bu(j)) then
            dj     = rc(j)
            if (dj .ne. zero) then
               if (dj .gt. zero) then
                  dj =   dj * min( x(j) - bl(j), one )
               else
                  dj = - dj * min( bu(j) - x(j), one )
               end if
               
               if (duInf .lt. dj) then
                  duInf   =  dj
                  jduInf  =  j
               end if
            end if ! dj nonzero
         end if
      end do

*     ------------------------------------------------------------------
*     Include contributions from the elastic variables.
*     ------------------------------------------------------------------
      if ( Elastc ) then
         do j  = n+1, n+nnCon
            dj = rc(j)
            v  = bl(j) - x (j)
            w  = x (j) - bu(j)

            if      (v .gt. zero) then
               dj = abs(wtInf - dj) * min( v, one )
            else if (w .gt. zero) then
               dj = abs(wtInf + dj) * min( w, one )
            else
               dj = zero
            end if
               
            if (duInf .lt. dj) then
               duInf   =  dj
               jduInf  =  j
            end if
         end do
      end if

      end ! of s8Infs

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8iqp ( info, Htype, Mnrlog, Hcalls, Elastc,
     &     gotR, iError, itn, itQP, lenR, m, maxS, mBS, n, nb,
     &     nnCon0, nnCon, nnObj, nnL0, nnL, nS, nDegen,
     &     MjrPrt, MnrPrt, minimz, iObj, sclObj, ObjAdd, ObjQP,
     &     tolFP, tolQP, tolx, nInf, sInf, wtInf, H0ii, piNorm,
     &     ne, nlocJ, locJ, indJ, Jcol,
     &     hElast, hEstat, hfeas, hs, kBS, 
     &     Ascale, bl, bu, blBS, buBS, gBS, gQP, Gobj, Hdx,
     &     pBS, pi, R, rc, rg, QPrhs, x,
     &     xQP, xBS, xFix, xQP0, iy, iy1, y, y1, y2, 
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      external
     &     Mnrlog
      logical
     &     Elastc, gotR
      integer
     &     Hcalls, Htype, iError, info(6), iObj, itn, itQP, lenR, lencu,
     &     leniu, lenru, lencw, leniw, lenrw, m, maxS, mBS, nnCon0,
     &     nnCon, n, nb, nDegen, ne, nlocJ, nnObj, nnL0, nnL, nInf, nS,
     &     MjrPrt, MnrPrt, minimz, locJ(nlocJ), indJ(ne), hElast(nb),
     &     hEstat(nb), hs(nb), hfeas(mBS), kBS(mBS), iy(nb), iy1(nb),
     &     iu(leniu), iw(leniw)
      double precision
     &     sclObj, ObjAdd, ObjQP, tolFP, tolQP, tolx, sInf, wtInf,
     &     H0ii, piNorm, Jcol(ne), Ascale(nb), bl(nb), bu(nb),
     &     blBS(mBS), buBS(mBS), gBS(mBS), gQP(nnL0), Gobj(nnL0),
     &     Hdx(nnL0), pBS(mBS), pi(m), QPrhs(nnCon0),
     &     R(lenR), rc(nb), rg(maxS), x(nnL0), xQP(nb), xBS(mBS),
     &     xFix(nb), xQP0(nb), y(nb), y1(nb), y2(nb), ru(lenru),
     &     rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     s8iqp   computes  xQP, the solution of the QP subproblem.  
*     By construction, the problem has  nnL  nonlinear variables, 
*
*     The SQP base point  x  is not altered.
*
*     On entry, the LU factorization is assumed to be known.
*     The arrays  xBS, blBS and buBS are defined. 
*
*     On output, 
*     QPerr points to ' ', 't', 'u' or 'w'.
*     QPfea points to ' '  or 'i'.
*
*     30 Dec 1991: First version.
*     19 Jul 1997: Thread-safe version.
*     05 Nov 2000: Current version of s8iqp.
*     ==================================================================
      character*20
     &     contyp
      logical
     &     needLU, needx, newB, newLU, NewTol, NormIn, solved
      integer
     &     eigH, i, iPrint, iSumm, itnlim, lenH, lEmode, LUreq,
     &     lvlInf, maxR, minmFP, mMinor, mxitQP, mtry, MnrHdg, ngQP0,
     &     ngQP, nBigpi, neH, nnFP, nnFP0, nnH0, nnH, nSwap, nTry,
     &     subopt, typeLU, iHvar(1), jHvar(1)
      double precision
     &     Hdmax, ObjFP, rgNorm, H(1)
      external
     &     s8Hwrp, s8Hx
*     ------------------------------------------------------------------
      parameter         (MnrHdg = 223) ! >0  => Mnr heading for iPrint

      integer            iQPfea,     iQPerr
      parameter         (iQPfea = 4, iQPerr = 5)
      integer            BS,         BT
      parameter         (BS     = 1, BT     = 2) 
      integer            FPS,        QPS
      parameter         (FPS    = 4, QPS    = 5)
      integer            No,         Yes
      parameter         (No     =-1, Yes    = 0)
      integer            HUnit 
      parameter         (HUnit  = 2)
      parameter         (mtry   = 2)
      integer            RedTol
      parameter         (RedTol = 1)
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file

      maxR      = iw( 52) ! max columns of R.
      itnlim    = iw( 89) ! limit on total iterations
      mMinor    = iw( 91) ! limit on minor iterations
      eigH      = iw(200) ! =1(0) for definite QP Hessian

      needLU    = .false.
      needx     =  needLU
      NormIn    = .not. Elastc

      typeLU    = BT
      contyp    = 'QP subproblem'

      itQP       = 0
      iw(MnrHdg) = 0

      info(iQPerr) = 0
      info(iQPfea) = 0

      nnH        = nnL 
      nnH0       = nnL0
      ngQP       = nnL
      ngQP0      = max( ngQP, 1 )

      lenH       = 1
      neH        = 0

*     Enable a switch to Elastic mode on infeasibility.
*     In theory, this should never happen for linear constraints.

      lEmode    = 1

*     ==================================================================
*     Find a feasible point for this linearization.
*     If the constraints are linear, x is already feasible.
*     ==================================================================
      if (nnCon .gt. 0) then
*        ---------------------------------------------------------------
*        Find a feasible point. 
*        If the constraints are infeasible, minimize the sum of the
*        elastic variables, subject to keeping the non-elastic variables
*        feasible.  Elastic variables can move outside their bounds.
*        ---------------------------------------------------------------
         gotR   = .false.
         mxitQP = itnlim
         lvlInf = 2
         nnFP   = 0
         nnFP0  = 1
         minmFP = 1
         subopt = No

         call s5QP  ( FPS, contyp, Elastc, iError, subopt,
     &        s8Hwrp, s8Hx, Mnrlog, gotR, needLU, typeLU, needx,
     &        lenR, m, maxS, mBS, n, nb, nDegen, Hcalls,
     &        nnFP0, nnFP, nnL0, nnObj, nnFP0, nnFP, nS,
     &        mxitQP, itQP, itn, lEmode, lvlInf, MnrPrt,
     &        minmFP, iObj, sclObj, ObjAdd, ObjFP, 
     &        tolFP, tolQP, tolx, nInf, sInf, wtInf,
     &        piNorm, rgNorm, ne, nlocJ, locJ, indJ, Jcol,
     &        iHvar, jHvar, lenH, neH, H,
     &        hElast, hEstat, hfeas, hs, kBS,
     &        Ascale, bl, bu, blBS, buBS,
     &        gBS, Gobj, gQP, Hdx, pBS, pi, R, rc, rg,
     &        nnCon0, nnCon, QPrhs, nnL0, nnL, x, xQP, xBS, xFix,
     &        iy, iy1, y, y1, y2,
     &        cu, lencu, iu, leniu, ru, lenru, 
     &        cw, lencw, iw, leniw, rw, lenrw )

*        Check for fatal errors that have already been signaled.

         if (iError .ge. 20) return
         if (iError .eq.  3) go to 900

*        Set Elastc here if the phase 1 was unbounded.  This can only
*        happen if a bad basis gave an enormous search direction.
*        If phase 1 stopped before the non-elastics were feasible,  a
*        feasibility phase will be needed before solving the QP.
*        In this case,  xQP0 may not satisfy the linear constraints. 

         if (iError .eq. 2  .and.  nInf .gt. 0) Elastc = .true.  

         if (Elastc  .and.  NormIn) then 
*           ------------------------------------------------------------
*           The QP switched to elastic mode.  
*           The linearized constraints are infeasible.
*           ------------------------------------------------------------
            if (MjrPrt .ge. 1  .or.  MnrPrt .ge. 1) then
               if (iPrint .gt. 0) write(iPrint, 1100) itn, wtInf
               if (iSumm  .gt. 0) write(iSumm , 1100) itn, wtInf
            end if

            gotR   = .false.
            Htype  = HUnit
            call s8H0  ( Htype, nnH, H0ii, iw, leniw, rw, lenrw )

         else if (MnrPrt .ge. 1) then

*           No change in mode.

            if ( Elastc ) then 
               if (iPrint .gt. 0) write(iPrint, 1200) itn
               if (iSumm  .gt. 0) write(iSumm , 1200) itn
            else
               if (iPrint .gt. 0) write(iPrint, 1300) itn
               if (iSumm  .gt. 0) write(iSumm , 1300) itn
            end if
         end if
      end if ! nlnCon

*     ------------------------------------------------------------------
*     The x's and linear slacks are now feasible.
*     Save them in xQP0 for use with the BFGS update.
*
*     Solve the QP subproblem.
*     Loop back sometimes if we need a BS factorize.
*     ------------------------------------------------------------------
      call dcopy ( nb, xQP, 1, xQP0, 1 )

      nTry   = 1
      solved = .false.

*     ==================================================================
*+    while (.not. solved  .and.  ntry .le. mtry) do                    
  600 if    (.not. solved  .and.  ntry .le. mtry) then
*        ---------------------------------------------------------------
*        Solve the QP.
*        The problem has  ngQP  nonlinear variables.
*        Possible exits are:
*           0         QP solution found
*           1         QP is infeasible
*           2         QP is unbounded
*           3         Too many iterations
*           4         Weak QP minimizer 
*           5         Too many superbasics
*           6         QP Hessian not positive semidefinite
*          11         Z'g could not be made sufficiently small
*        ---------------------------------------------------------------
         if ( Elastc ) then
            lvlInf = 1
         end if

         iError = 0

         if (nS .gt. 0  .and. .not. gotR) then
*           ------------------------------------------------------------
*           Compute and factorize Z'HZ.
*           ------------------------------------------------------------
            call s5HZ  ( s8Hwrp, s8Hx, lenR, minimz,
     &           m, mBS, n, nb, nnH, nS, Hcalls,
     &           ne, nlocJ, locJ, indJ, Jcol,
     &           iHvar, jHvar, lenH, neH, H,
     &           Hdmax, kBS, R, y, y1, y2, 
     &           cu, lencu, iu, leniu, ru, lenru,
     &           cw, lencw, iw, leniw, rw, lenrw )
            call s5Hfac( eigH, itn, iError,
     &           lenR, m, maxR, mBS, nb, nS, 
     &           Hdmax, hs, kBS, iy, 
     &           bl, bu, blBS, buBS, xQP, xBS, R,
     &           iw, leniw, rw, lenrw )
         end if

         if (iError .eq. 0) then 
            gotR   = .true.
            typeLU = BT
            mxitQP = itQP + mMinor
            subopt = Yes

            call s5QP  ( QPS, contyp, Elastc, iError, subopt,
     &           s8Hwrp, s8Hx, Mnrlog, gotR, needLU, typeLU, needx,
     &           lenR, m, maxS, mBS, n, nb, nDegen, Hcalls,
     &           ngQP0, ngQP, nnL0, nnObj, nnH0, nnH,
     &           nS, mxitQP, itQP, itn, lEmode, lvlInf, MnrPrt,
     &           minimz, iObj, sclObj, ObjAdd, ObjQP, 
     &           tolFP, tolQP, tolx, nInf, sInf, wtInf,
     &           piNorm, rgNorm, ne, nlocJ, locJ, indJ, Jcol,
     &           iHvar, jHvar, lenH, neH, H,
     &           hElast, hEstat, hfeas, hs, kBS,
     &           Ascale, bl, bu, blBS, buBS,
     &           gBS, Gobj, gQP, Hdx, pBS, pi, R, rc, rg, 
     &           nnCon0, nnCon, QPrhs, nnL0, nnL, x, xQP, xBS, xFix,
     &           iy, iy1, y, y1, y2,
     &           cu, lencu, iu, leniu, ru, lenru, 
     &           cw, lencw, iw, leniw, rw, lenrw )
         end if

         if (iError .ge. 20                           ) return
         if (iError .eq.  3  .or.   iError .ge.     12) go to 900 

         solved = iError .eq. 0 .or. iError .eq. 4 .or. iError .eq. 5

         if (ntry .lt. mtry) then
            if ( solved ) then
               if (.not. Elastc) then
*                 ------------------------------------------------------
*                 If there are big nonlinear pi's, set elastic mode.
*                 ------------------------------------------------------
                  nBigpi = 0
                  do i = 1, nnCon
                     if (abs(pi(i)) .gt. wtInf) then
                        nBigpi = nBigpi + 1
                     end if
                  end do
                  
                  if (nBigpi .gt. 0) then
                     Elastc = .true.
                     solved = .false.
                     if (iPrint .gt. 0) write(iPrint, 1400) itn, wtInf
                     if (iSumm  .gt. 0) write(iSumm , 1400) itn, wtInf
                   end if
               end if
            else
*              ---------------------------------------------------------
*              Trouble.
*              iError =  1  means that the QP was infeasible.
*              iError =  6  means that Z'HZ was indefinite.
*              iError = 11  means that Z'g couldn't be reduced.
*
*              If possible, use tighter LU tolerances. 
*              ---------------------------------------------------------
               call s2tols( RedTol, NewTol, itn, iw, leniw, rw, lenrw )

               if (iError .eq. 1) then
*                 ------------------------------------------------------
*                 This shouldn't happen since phase 1 has already found 
*                 a feasible point.   Reduce LU factor tolerances,
*                 refactorize and start elastic mode.
*                 ------------------------------------------------------
                  Elastc = .true.

               else if (iError .eq. 6  .or.  iError .eq. 11) then
*                 ------------------------------------------------------
*                 If the tolerance are already tight. Set unit Hessian.
*                 ------------------------------------------------------
                  if (.not. NewTol  .and.  Htype .ne. HUnit) then
                     if (iPrint .gt. 0) write(iPrint, 1500) itn
                     if (iSumm  .gt. 0) write(iSumm , 1500) itn
                     call s8H0  ( Htype, nnH, H0ii, iw, leniw, rw,lenrw)
                  end if
               end if

               typeLU = BS
               LUreq  = 11
               needLU = .true.
               call s2Bfac( typeLU, needLU, newLU, newB,
     &              iError, iObj, itn, MjrPrt, LUreq,
     &              m, mBS, n, nb, nnL, nS, nSwap,
     &              ne, nlocJ, locJ, indJ, Jcol,
     &              kBS, hs, bl, bu, blBS, buBS,
     &              nnCon0, nnCon, QPrhs, xQP, xBS,
     &              iy, iy1, y, y2, iw, leniw, rw, lenrw )
               if (iError .gt. 0) return
            end if
         end if
         nTry   = nTry + 1

         go to 600
      end if
*+    end while

*     ------------------------------------------------------------------
  900 if (nInf .gt.      0                       ) info(iQPfea) = 1
      if (itQP .ge. mxitQP  .or.  itn .ge. itnlim) info(iQPerr) = 2

      if (iError .ne. 3) then

*        Non-fatal exits.
*        Set the QP result code for printing.

         info(iQPerr) = subopt

         if (iError .eq. 2) then
            info(iQPerr) = 3    ! unbounded subproblem

         else if (iError .eq. 4) then
            info(iQPerr) = 4    ! weak QP solution

         else if (iError .eq. 5) then
            info(iQPerr) = 5    ! superbasic limit
         end if
         iError = 0
      end if

      return

 1100 format(' Itn', i7, ': Infeasible subproblem.',
     &       ' Elastic mode started with weight = ', 1p, e8.1 )
 1200 format(' Itn', i7, ': Feasible QP non-elastics' )
 1300 format(' Itn', i7, ': Feasible QP subproblem ' )
 1400 format(' Itn', i7, ': Large multipliers.',
     &       ' Elastic mode started with weight = ', 1p, e8.1 )
 1500 format(' Itn', i7, ': Expanded reduced Hessian',
     &       ' is indefinite:  Hessian reset ' )

      end ! of s8iqp

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8mrt ( nnCon, fMrt, gMrt, HMrt, incRun,
     &     penDmp, penMax, PenNrm, Fv, xPen, y, rw, lenrw )

      implicit
     &     none
      logical
     &     incRun
      integer
     &     nnCon, lenrw
      double precision
     &     fMrt, gMrt, HMrt, penDmp, penMax, PenNrm, 
     &     Fv(nnCon), xPen(nnCon), y(nnCon), rw(lenrw)

*     ==================================================================
*     s8mrt  computes the contributions to the merit function and its
*     directional derivative from the nonlinear constraints.
*     The penalty parameters  xPen(j)  are increased if 
*     the directional derivative is not sufficiently negative.
*
*     On entry:
*         pi     is the vector of  QP  multipliers.
*         Fv     is the violation c(x) + A(linear)x - s,  where
*                s  minimizes the merit function with respect to the 
*                nonlinear slacks only.
*
*     30 Dec 1991: First version based on Npsol 4.0 routine npmrt.
*     02 Nov 1996: Multipliers no longer updated here.
*     19 Jul 1997: Thread-safe version.
*     21 Oct 2000: Made compatible with SNOPT 6.1
*     21 Oct 2000: Current version of s8mrt.
*     ==================================================================
      logical
     &     boost, overfl
      integer
     &     i
      double precision
     &     ddiv, ddot, dnrm2, eps0, ppscl, penlty, penMin, penNew,
     &     penOld, rtUndf, xPen0, xPeni, ynorm
*     ------------------------------------------------------------------
      double precision   zero,          half,          two
      parameter         (zero = 0.0d+0, half = 0.5d+0, two = 2.0d+0)
*     ------------------------------------------------------------------
      eps0      = rw(  2)
      rtUndf    = rw( 10)
      xPen0     = rw( 89)

      overfl    = .false.

*     Find the quantities that define  penMin, the vector of minimum
*     two-norm such that the directional derivative is one half of
*     approximate curvature   - (p)'H(p).
*     The factor  rtUndf  tends to keep  xPen  sparse.

      do i = 1, nnCon
         if (abs( Fv(i) ) .le. rtUndf) then
            y(i) = zero
         else
            y(i) = Fv(i)**2
         end if
      end do

      ynorm  = dnrm2 ( nnCon, y, 1 )
      ppscl  = ddiv  ( gMrt + half*HMrt, ynorm, overfl )
      if (abs( ppscl ) .le. penMax  .and.  .not. overfl) then
*        ---------------------------------------------------------------
*        Bounded  penMin  found.  The final value of  xPen(i)  will
*        never be less than  penMin(i).  A trial value  penNew  is
*        computed that is equal to the geometric mean of the previous
*        xPen  and a damped value of penMin.  The new  xPen  is defined
*        as  penNew  if it is less than half the previous  xPen  and
*        greater than  penMin.
*        ---------------------------------------------------------------
         do i = 1, nnCon
            penMin = max( (y(i)/ynorm)*ppscl, zero )
            xPeni  = xPen(i)

            penNew = sqrt( xPeni*(PenDmp + penMin) )
            if (penNew .lt. half*xPeni ) xPeni = penNew
            xPeni   = max (xPeni, penMin)
            xPen(i) = max (xPeni, xPen0 )
         end do

         PenOld  = PenNrm
         PenNrm = dnrm2( nnCon, xPen, 1 )

*        ---------------------------------------------------------------
*        If  IncRun = true,  there has been a run of iterations in
*        which the norm of  xPen  has not decreased.  Conversely,
*        IncRun = false  implies that there has been a run of
*        iterations in which the norm of xPen has not increased.  If
*        IncRun changes during this iteration the damping parameter
*        PenDmp is increased by a factor of two.  This ensures that
*        xPen(j) will oscillate only a finite number of times.
*        ---------------------------------------------------------------
         boost  = .false.
         if (      IncRun  .and.  PenNrm .lt. PenOld) boost = .true.
         if (.not. IncRun  .and.  PenNrm .gt. PenOld) boost = .true.
         if (boost) then
            PenDmp = min( 1/eps0, two*PenDmp )
            IncRun = .not. IncRun
         end if
      end if

*     ------------------------------------------------------------------
*     Compute the new value and directional derivative of the
*     merit function.
*     ------------------------------------------------------------------
      call dcopy ( nnCon, Fv  , 1, y, 1 )
      call ddscl ( nnCon, xPen, 1, y, 1 )

      penlty = ddot  ( nnCon, y, 1, Fv, 1 )
      fMrt   = fMrt  + half*penlty
      gMrt   = gMrt  -      penlty

      end ! of  s8mrt

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8PPHx( Hprod, Hcalls, nnH,
     &     iHvar, jHvar, lenH, neH, H,
     &     x, Hx, Status, 
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      external
     &     Hprod
      integer
     &     Status, neH, Hcalls, nnH, lenH,
     &     lencu, leniu, lenru, lencw, leniw, lenrw,
     &     iHvar(lenH), jHvar(lenH), iu(leniu), iw(leniw)
      double precision
     &     H(neH), Hx(nnH), x(nnH), ru(lenru), rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     s8PPHx  defines the product  H*x  for the proximal-point QP
*     subproblem of snopt.
*
*     On exit,    Hx   = x.
*
*     23 Oct 1993: First version of s8PPHx.
*     02 Aug 2000: Current version.
*     ==================================================================
      call dcopy ( nnH, x, 1, Hx, 1 )

      end ! of s8PPHx

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8rand( leng, neg, g )

      implicit
     &     none
      integer
     &     leng, neg
      double precision
     &     g(leng)

*     ==================================================================
*     s8rand  fills the array g with random numbers.
*
*     15 Nov 1991: First version of s8rand in s8aux.
*     30 Jun 1999: Current version.
*     ==================================================================
      integer
     &     seeds(3)
*     ------------------------------------------------------------------
      if (neg .le. 0) return

      seeds(1) = 1547
      seeds(2) = 2671
      seeds(3) = 3770

      call ddrand( neg, g, 1, seeds )

      end ! of s8rand

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8rc  ( sclObj, minimz, iObj, m, n, nb, 
     &     nnL0, nnObj, nnCon, nnJac, neG,
     &     ne, nlocJ, locJ, indJ, Jcol,
     &     Gobj, Gcon, pi, rc )

      implicit
     &     none
      integer
     &     minimz, iObj, m, n, nb, nnL0, nnObj, nnCon, nnJac, neG,
     &     ne, nlocJ, indJ(ne), locJ(nlocJ)
      double precision
     &     sclObj, Jcol(ne), Gobj(nnL0), Gcon(neG), pi(m), rc(nb)

*     ==================================================================
*     s8rc   computes reduced costs rc = Gobj - ( A  -I )'*pi,
*     using  Gcon  as the top left-hand corner of A.
*     Gcon, Gobj and pi are assumed to exist.
*
*     s8rc   is called by s8SQP.
*
*     28 Sep 1993: First version, derived from m4rc.
*     31 Oct 1996: Min sum option added.
*     30 Oct 2000: Current version of s8rc.
*     ==================================================================
      integer
     &     ir, j, k, l
      double precision
     &     dj, sgnObj
*     ------------------------------------------------------------------
      double precision   zero
      parameter        ( zero = 0.0d+0 )
*     ------------------------------------------------------------------
      l     = 0

      do j  = 1, nnJac
         dj = zero
         do k  = locJ(j), locJ(j+1) - 1
            ir = indJ(k)
            if (ir .le. nnCon) then
               l  = l  + 1
               dj = dj + pi(ir)*Gcon(l)
            else
               dj = dj + pi(ir)*Jcol(k)
            end if
         end do
         rc(j) = -dj
      end do

      do j  = nnJac+1, n
         dj = zero
         do k  = locJ(j), locJ(j+1) - 1
            ir = indJ(k)
            dj = dj  +  pi(ir) * Jcol(k)
         end do
         rc(j) = -dj
      end do

      call dcopy ( m, pi, 1, rc(n+1), 1 )

*     Include the nonlinear objective gradient.

      sgnObj = minimz
      if (nnObj .gt. 0) then
         call daxpy ( nnObj, sgnObj, Gobj, 1, rc, 1 )
      end if

      if (iObj .gt. 0) rc(n+iObj) =  rc(n+iObj) + sgnObj*sclObj

      end ! of s8rc

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8sclg( nnObj, Ascale, Gobj, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     nnObj, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)
      double precision
     &     Ascale(nnObj), Gobj(nnObj)

*     ==================================================================
*     s8sclg  scales the objective gradient.
*     s8sclg is called by fgwrap only if modefg = 2.
*     Hence, it is used to scale known gradient elements (if any),
*     but is not called when missing gradients are being estimated
*     by s6dobj.
*
*     17 Feb 1992: First version.
*     16 Jul 1997: Thread-safe version.
*     02 Nov 2000: Current version of s8sclg.
*     ==================================================================
      integer
     &    Gotg1, j  
      double precision
     &     gdummy, grad
*     ------------------------------------------------------------------
      gdummy = rw( 69) ! definition of 'unset' value
      Gotg1  = iw(186) ! number of Gobj elements set

      if (Gotg1 .gt. 0) then
*        ---------------------------------------------------------------
*        Scale known objective gradients.
*        ---------------------------------------------------------------
         do j = 1, nnObj
            grad = Gobj(j)
            if (grad .ne. gdummy) Gobj(j) = grad*Ascale(j)
         end do
      end if

      end ! of s8sclg

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8sclJ( nnCon, nnJac, neG, n, Ascale,
     &     ne, nlocJ, locJ, indJ, Gcon,
     &     iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     n, ne, neG, nnCon, nnJac, nlocJ, leniw, lenrw,
     &     indJ(ne), locJ(nlocJ), iw(leniw)
      double precision
     &     Ascale(n+nnCon), Gcon(neG), rw(lenrw)

*     ==================================================================
*     s8sclJ  scales the Jacobian.
*     s8sclJ is called by fgwrap only if modefg = 2.
*     Hence, it is used to scale known gradient elements (if any),
*     but is not called when missing gradients are being estimated
*     by s6dcon.
*
*     17 Feb 1992: First version based on Minos routine m8sclj.
*     16 Jul 1997: Thread-safe version.
*     03 Nov 2000: Current version of s8sclJ.
*     ==================================================================
      integer
     &    Gotg2, ir, j, k, l  
      double precision
     &     Cscale, gdummy, grad
*     ------------------------------------------------------------------
      gdummy = rw( 69) ! definition of 'unset' value
      Gotg2  = iw(187) ! number of Gcon elements set

      if (Gotg2 .gt. 0) then
*        ---------------------------------------------------------------
*        Scale known Jacobian elements.
*        ---------------------------------------------------------------
         l    = 0
         do j = 1, nnJac
            Cscale = Ascale(j)

            do k = locJ(j), locJ(j+1)-1
               ir     = indJ(k)
               if (ir .gt. nnCon) go to 300
               l      = l + 1
               grad   = Gcon(l)
               if (grad .ne. gdummy)
     &              Gcon(l)   = grad*cscale/Ascale(n+ir)
            end do
  300       continue
         end do
      end if

      end ! of s8sclJ

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8sInf( n, nb, nnCon, tolx, nInf, sInf, bl, bu, x )

      implicit
     &     none
      integer
     &      n, nb, nnCon, nInf
      double precision
     &     tolx, sInf, bl(nb), bu(nb), x(nb)

*     ==================================================================
*     s8sInf computes the sum of infeasibilities of the nonlinear slacks
*     using bl, bu and x.
*
*     10 Jan 1997: First version of s8sInf.
*     30 Oct 2000: Current version.
*     ==================================================================
      integer
     &     i, j
       double precision
     &     slack, tol, violL, violU
*     ------------------------------------------------------------------
      double precision   zero
      parameter        ( zero = 0.0d+0 )
*     ------------------------------------------------------------------
      nInf   = 0
      sInf   = zero
      tol    = tolx

*     See how much  x(n+1:n+nnCon) violates its bounds.

      do i = 1, nnCon
         j     = n + i
         slack = x(j)
         violL = bl(j) - slack
         violU = slack - bu(j)
         if (violL .gt. tol  .or.  violU .gt. tol) then
            nInf = nInf + 1
            sInf = sInf + max (violL, violU )
         end if
      end do

      end ! of s8sInf

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8step( centrl, usefLS, nb, neG, nnCon, nnObj, nSkip,
     &     step, stepmn, steplm, stepmx, tolz, xdNorm, xNorm, 
     &     bl, bu, x, dx, iw, leniw, rw, lenrw )

      implicit
     &     none
      logical
     &     centrl, usefLS
      integer
     &     nb, neG, nnCon, nnObj, nSkip, leniw, lenrw, iw(leniw)
      double precision
     &     step, stepmn, steplm, stepmx, tolz, xdNorm, xNorm,
     &     bl(nb), bu(nb), x(nb), dx(nb), rw(lenrw)

*     ==================================================================
*     s8step  finds the maximum, minimum and initial value for the
*     linesearch step.
*
*     For problems with nonlinear constraints, the maximum step stepmx
*     is one.  If there are only linear constraints the maximum step is
*     the largest step such that x + step*dx  reaches one of its bounds.
*     
*     All step sizes are subject to the user-specified limit  steplm.
*
*     04 Dec 1992: First version of s8step based on npsol routine npalf.
*     31 Mar 2000: Updated for SNOPT 6.1.
*     21 Oct 2000: Current version.
*     ==================================================================
      logical
     &     switch, overfl
      integer
     &     Htype, j, nConfd, nObjfd, Gotg(2)
      double precision
     &     bigdx, fdint1, pivot, pivabs, res, stepQP, tolpiv,
     &     tolp, xdlim, ddiv
*     ------------------------------------------------------------------
      integer            HUnit 
      parameter         (HUnit = 2)
      double precision   zero,          one
      parameter         (zero = 0.0d+0, one = 1.0d+0)
*     ------------------------------------------------------------------
      tolpiv    = rw( 60) ! excludes small elements of y.
      bigdx     = rw( 72) ! unbounded step.
      fdint1    = rw( 76) ! (1) forwrd diff. interval
      xdlim     = rw( 80) ! Step limit

      nConfd    = iw(183) ! # of unknown elements of Gcon 
      nObjfd    = iw(184) ! # of unknown elements of Gobj
      Gotg(1)   = iw(186) ! number of g    elements set
      Gotg(2)   = iw(187) ! number of Gcon elements set
      Htype     = iw(202) ! Current approximate Hessian type

      overfl    = .false.

*     ==================================================================
*     switch  indicates if there is an option to switch to
*             central differences to get a better search direction.
*     stepQP  is the step predicted by the QP subproblem (usually 1).
*     stepmx  is the largest feasible steplength subject to a
*             user-defined limit, bigdx, on the change in  x.
*     step    is initialized subject to a user-defined limit, xdlim.
*     ==================================================================
      switch = .not. centrl     .and.
     &         ((nObjfd .gt. 0  .and.  Gotg(1) .lt. nnObj)  .or.
     &          (nConfd .gt. 0  .and.  Gotg(2) .lt. neG  )      )

      stepmn = zero
      if (usefLS  .and.  switch) then
         stepmn = fdint1*(one + xNorm) / xdNorm
      end if

      stepQP = one
      if (nnCon .gt. 0 .and. (nSkip .eq. 0 .or. Htype .ne. HUnit)) then
         stepmx = one
      else
         tolp   = tolpiv*xdNorm
         stepmx = ddiv  ( bigdx, xdNorm, overfl )
         step   = stepmx
         j      = 1

*+       while (j .le. nb  .and.  step .gt. stepQP) do
  100    if    (j .le. nb  .and.  step .gt. stepQP) then
            pivot   = dx(j)
            pivabs  = abs( pivot )
            if (pivabs .gt. tolp) then
               if (pivot  .le. zero  ) then
                  res    = x(j) - bl(j)
                  if (step*pivabs .gt. res) step = res / pivabs
               else 
                  res    = bu(j) - x(j)
                  if (step*pivabs .gt. res) step = res / pivabs
               end if
            end if
            j = j + 1
            go to 100
*+       end while
         end if

         step   = max( step, stepQP )
         if (step .lt. stepQP + tolz) step = stepQP

         stepmx = step
      end if

      steplm = ddiv( (one+xNorm)*xdlim, xdNorm, overfl )
      stepmx = min (            steplm, stepmx)
      step   = min (            steplm, one )

      end ! of s8step

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8sOpt( Elastc, n, nnCon, tolz, wtInf, 
     &     bl, bu, Fv, x, Lmul, xPen, Fx )

      implicit
     &     none
      logical
     &     Elastc
      integer
     &     n, nnCon
      double precision
     &     tolz, wtInf, bl(n+nnCon), bu(n+nnCon), x(n+nnCon),
     &     xPen(nnCon), Fx(nnCon), Fv(nnCon), Lmul(nnCon)

*     ==================================================================
*     s8sOpt computes the vector of nonlinear constraint violations:
*        Fv = Fcon + A(linear)*x - (optimal nonlinear slacks)
*
*     The optimal nonlinear slacks are computed as follows:
*     (1) Feasible  nonlinear slacks are adjusted so that they minimize
*         the merit function subject to  x  and  Lmul  being held
*         constant.
*     (2) Infeasible slacks are compared with the true nonlinear slacks,
*         and, if necessary, they are adjusted so that the sum of 
*         infeasibilities is reduced.
* 
*     If Lmul is zero, the violation can be set to any value without
*     changing the merit function.  In this case we choose the slack to
*     so that  the violation is zero (subject to the constraints above).
*
*     On entry,
*        x   =  the current x.
*        Fx  =  Fcon + A(linear)*x,   defined in s8Fx.
*
*     On exit, 
*        x   =  x containing the optimal slacks.
*        Fv  =  Fcon + A(linear)*x - optimal slacks.
*        Fx  =  unaltered.
*
*     09 Jan 1992: First version based on Npsol routine npslk.
*     09 Oct 1996: First infeasible slack version.
*     05 Mar 2000: Current version.
*     ==================================================================
      integer
     &     i, j
      double precision
     &     blj, buj, con, vi, vL, vU, xj, Lmuli, xPeni,
     &     dvMax, vLow, vUpp
*     ------------------------------------------------------------------
      double precision   zero,          one,          factor
      parameter         (zero = 0.0d+0, one = 1.0d+0, factor = 10.0d+0)
*     ------------------------------------------------------------------
      do i = 1, nnCon
         j     = n + i
         con   = Fx(i)
         xj    = x(j)
         vi    = con - xj

         xPeni = xPen(i)
         Lmuli = Lmul(i)

         blj   = bl(j)
         buj   = bu(j)

         vU    = con - buj
         vL    = con - blj

*        ---------------------------------------------------------------
*        Redefine  xj  so that it minimizes the merit function 
*        subject to upper and lower bounds determined by the current
*        multipliers.  For computational convenience (but not clarity),
*        instead of checking that  xj  is within these bounds, the
*        violation  vi = c - xj  is checked against  vLow  and  vUpp,
*        the violations at the upper and lower bounds on xj. 
*        ---------------------------------------------------------------
*        First, impose artificial bounds (tbl, tbu).

         dvMax = factor*(one + abs( vi )) 
         vLow  = vi - dvMax
         vUpp  = vi + dvMax

         if      (Elastc  .and.  xj .le. blj) then
*           ------------------------------------------------------------
*           This slack is at or below its lower bound in elastic mode.
*           ------------------------------------------------------------
            if (     Lmuli .lt. zero) then

*              xj is eligible to increase.
*              Require                  bl <=  xj <= min( bu,tbu ).

               vLow  = max( vU, vLow )
               vUpp  = vL
                 
            else if (Lmuli .gt. zero) then

*              xj is eligible to decrease and violate its lower bound.
*              Require              -infty <=  xj <= bl

               Lmuli = Lmuli - wtInf
               vLow  = vL

            else

*              xj can either increase or decrease.
*              Require              -infty <=  xj <= min( bu,tbu ).

               vLow  = max( vU, vLow )
            end if

         else if (Elastc  .and.  xj .ge. buj) then
*           ------------------------------------------------------------
*           This slack is at or above its upper bound in elastic mode.
*           ------------------------------------------------------------
            if (     Lmuli .gt. zero) then

*              xj is eligible to decrease.
*              Require      max( bl, tbl ) <=  xj <= bu.

               vLow  = vU
               vUpp  = min( vL, vUpp )
                
            else if (Lmuli .lt. zero) then

*              xj is eligible to increase and violate its upper bound.
*              Require                  bu <=  xj <= +infty

               Lmuli = Lmuli + wtInf
               vUpp  = vU
            else

*              xj can either increase or decrease.
*              Require      max( bl, tbl ) <=  xj <= +infty

               vUpp  = min( vL, vUpp )
            end if

         else
*           ------------------------------------------------------------
*           Feasible slack.  xj can move either way.
*           ------------------------------------------------------------
*              Require      max( bl, tbl ) <=  xj <= min( bu,tbu ).

            vLow  = max( vU, vLow )
            vUpp  = min( vL, vUpp )
         end if

         if (abs( Lmuli ) .le. tolz) then
            vi = min( max( zero, vLow ), vUpp )
            
         else if (xPeni .ge. tolz) then
            if (Lmuli .ge. xPeni*vUpp) then
               vi = vUpp
            else if (Lmuli .le. xPeni*vLow) then
               vi = vLow
            else
               vi = Lmuli / xPeni
            end if
         end if

         xj    = con - vi
         Fv(i) = vi
         x(j)  = xj
      end do

      end ! of s8sOpt

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8wInf( job,
     &     boostd, itn, gNorm, wtInf, wtInf0,
     &     weight, wtFac, wtScal, iw, leniw )

      implicit
     &     none
      logical
     &     boostd
      integer
     &     job, itn, leniw, iw(leniw)
      double precision
     &     gNorm, wtInf, wtInf0, weight, wtFac, wtScal

*     ==================================================================
*     s8wInf  initializes or updates the elastic weight  wtInf.
*     The elastic weight is given by  wtInf = wtScal*weight,
*     where wtScal is some scale-dependent quantity (Fobj here).
*     wtInf is increased by redefining weight as weight*wtFac, where
*     wtFac is a constant factor.
*
*     weight, wtFac and wtScal are 'saved' local variables.
*
*     20 Feb 1997: First version written by PEG.
*     30 Oct 2000: Current version.
*     ==================================================================
      integer
     &     iPrint, iSumm
      double precision
     &     newWt
*     ------------------------------------------------------------------
      double precision   ten, wtMax
      parameter         (ten   = 10.0d+0)
      parameter         (wtMax = 1.0d+10)
      integer            SetWt,     Boost
      parameter         (SetWt = 0, Boost = 1)
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file

      if (job .eq. SetWt) then

*        Set the weight.
*        weight is the ``unscaled'' weight on the infeasibilities.
*        wtScal is a scale factor based on the current gradient.

         wtScal = gNorm
         wtFac  = ten
         weight = wtInf0
         wtInf  = wtScal*weight

      else if (job .eq. Boost) then

*        If possible, boost the weight.

         newWt  = min( wtFac*weight, wtMax )
         boostd = newWt .gt. weight

         if ( boostd ) then
            weight = newWt
            wtInf  = weight*wtScal
            wtFac  = ten*wtFac
            if (iPrint .gt. 0) write(iPrint, 1000) itn, wtInf
            if (iSumm  .gt. 0) write(iSumm , 1000) itn, wtInf
         end if
      end if

      return

 1000 format(' Itn', i7, ': Elastic weight increased to ', 1p, e11.3)

      end ! of s8wInf

