*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
*     File  sn85Hess.f
*
*     s8H0     s8HQN    s8Hwrp   s8Hx     s8Hupd   s8x1
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8H0  ( Htype, nnH, H0pre, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     Htype, nnH, leniw, lenrw, iw(leniw)
      double precision
     &     H0pre, rw(lenrw)

*     ==================================================================
*     s8H0    initializes the BFGS approximate Hessian.
*
*     s8H0   calls one of the Hessian routines s9LMH0, s9FMH0, s9SDH0
*     according to the value of the option lvlHes.
*     Each of these routines defines a particular form of the Hessian.
*     At the moment the options are:
*        lvlHes = 0   Limited-Memory (LM) BFGS Hessian  (the default).
*        lvlHes = 1   Full-Memory    (FM) BFGS Hessian.
*
*     On entry, the value of Htype is as follows:
*
*       Htype 
*       -----
*        -1      H undefined.
*         0      H is an approx. Hessian of the form defined by  lvlHes.
*         1      H is a diagonal matrix.
*         2      H is an identity matrix.
*
*     19 Jul 1995: First version of s8H0   written by PEG.
*     12 Jan 1996: Full memory Hessian option added.
*     26 Oct 2000: Current version.
*     ==================================================================
      integer
     &     lvlHes, mQNmod, nQNmod, lH0, lgdSav, lHdSav, lydx, ldxHdx,
     &     lfH, lenfH
*     ------------------------------------------------------------------
      integer            LM   ,      FM
      parameter         (LM     = 0, FM     = 1) 
      integer            HUnset
      parameter         (HUnset =-1)
      parameter         (nQNmod = 201) ! # of updates since last reset
*     ------------------------------------------------------------------
      lvlHes    = iw( 72) ! LM, FM or Exact Hessian

      if (Htype .eq. HUnset) then
         iw(nQNmod) = 0
      end if

      if      (lvlHes .eq. LM) then
*        -----------------------
*        Limited memory Hessian.
*        -----------------------
         mQNmod    = iw( 54) ! (ge 0) max # of BFGS updates
         lH0       = iw(346) ! Initial diagonal Hessian
         lgdSav    = iw(402) !
         lHdSav    = iw(403) !
         lydx      = iw(404) !
         ldxHdx    = iw(405) !

         call s9LMH0( Htype, nnH, mQNmod, iw(nQNmod),
     &        H0pre, rw(lH0), rw(lgdSav), rw(lHdSav),
     &        rw(lydx), rw(ldxHdx) )

      else if (lvlHes .eq. FM) then
*        -----------------------
*        Full memory Hessian.
*        -----------------------
         lfH       = iw(391) !
         lenfH     = iw(392) !

         call s9FMH0( Htype, lenfH, nnH, iw(nQNmod), H0pre, rw(lfH) )

      end if

      end ! of s8H0

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8HQN ( fgwrap, fgcon, fgobj, Mnrlog, Elastc, useFD,
     &     Hcalls, Htype, iError, info, itn, itQP,
     &     lenR, m, maxS, mBS, MnrPrt, n, nb,
     &     nnCon0, nnCon, nnJac, nnObj, nnL,
     &     nS, nDegen, nMajor, nSkip, sclObj, tolFP, tolx,
     &     nInf, sInf, wtInf, step, minimz, dxHdx,
     &     RtRmod, gotR, incRun, PenDmp, PenMax,
     &     Fobj, Fcon, Gcon, Gobj, Fcon1, Gcon1, Gobj1,
     &     ne, nlocJ, locJ, indJ, Jcol, neG, nlocG, locG, 
     &     hElast, hEstat, hfeas, hs, kBS, 
     &     Ascale, bl, bu, blBS, buBS, gBS, dx, dg, Hdx, Lmul1,
     &     pi, R, rc, rg, QPrhs, x, x1, xBS, 
     &     xQP0, xQP, xPen, iy, iy1, y, y1, y2, y3,
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )
      
      implicit
     &     none
      external
     &     fgwrap, fgcon, fgobj, Mnrlog
      logical
     &     Elastc, gotR, incRun, useFD
      integer
     &     Hcalls, Htype, iError, info(6), itn, itQP, lenR, maxS, mBS,
     &     MnrPrt, minimz, m, n, nb, nDegen, neG, ne, nInf, nlocJ,
     &     nMajor, nnCon0, nnCon, nnJac, nnL, nnObj, nS,
     &     nSkip, nlocG, RtRmod, lencu, lencw, leniu, leniw, lenru,
     &     lenrw, hElast(nb), hEstat(nb), hs(nb), hfeas(mBS),
     &     kBS(mBS), locJ(nlocJ), indJ(ne), locG(nlocG),
     &     iy(nb), iy1(nb), iu(leniu), iw(leniw)
      double precision
     &     dxHdx, PenDmp, PenMax, piNorm, rgNorm, step, sclObj, sInf,
     &     tolFP, tolx, wtInf, 
     &     Ascale(nb), bl(nb), bu(nb), blBS(mBS), buBS(mBS), dg(nnL),
     &     dx(nnL), gBS(mBS), Hdx(nnL), Jcol(ne), Lmul1(nnCon0), 
     &     Fobj, Fcon(nnCon0), Gcon(neG), Gobj(nnL),
     &     Fcon1(nnCon0), Gcon1(neG), Gobj1(nnL),
     &     pi(m), QPrhs(nnCon0), R(lenR), rc(nb), rg(maxS),
     &     x(nnL), x1(nnL), xBS(mBS), xPen(nnCon0), xQP0(nb), xQP(nb),
     &     y(nb), y1(nb), y2(nb), y3(nb), ru(lenru), rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     s8HQN  does the quasi-Newton update with vectors
*        dx = x1 - x   and   dg = gL(x1) - gL(x).
*
*     On entry:
*      xQP is the QP solution.
*
*     23 Apr 1999: First version of s8HQN,
*     09 Nov 2000: Current version.
*     ==================================================================
      logical
     &     needLU, needx, nlnCon, overfl, updatd, minlen
      character*20
     &     contyp
      integer
     &     iObjPP, kFac, lenH, lEmode, lvlInf, minmPP, mxitPP, MnrHdg,
     &     mSkip, mWSsve, nBS, neH, nnL0, nnPP0, nnPP, nObjP0,
     &     nObjPP, nzero, subopt, typeLU, iHvar(1), jHvar(1)
      double precision
     &     ddot, ddiv, dnrm2, eps, eps0, eps1, H(1), H0ii,
     &     H0Scal, ObjAPP, ObjPP, PenUnm, sgnObj, sNorm, tolQPP,  
     &     xPen0, ydx, ydxmin
      external
     &     s8PPHx
*     ------------------------------------------------------------------
      parameter         (MnrHdg = 223) ! >0  => Mnr heading for iPrint
      integer            BT
      parameter         (BT     = 2 ) 
      integer            QPP
      parameter         (QPP    = 6)
      integer            Yes
      parameter         (Yes    = 0)
      integer            Transp
      parameter         (Transp = 1)
      integer            HNorml
      parameter         (HNorml = 0)
      integer            iQNtyp,     iModfy
      parameter         (iQNtyp = 1, iModfy = 2)
      double precision   tolg,            tolg2
      parameter         (tolg  =  1.0d-3, tolg2  = 1.0d-1)
      double precision   H0max,           H0min
      parameter         (H0max =  1.0d+6, H0min  = 1.0d-9)
      integer            mGap
      parameter         (mGap  = 2)
      double precision   zero,            one
      parameter         (zero  =  0.0d+0, one = 1.0d+0)
*     ------------------------------------------------------------------
      kFac   = iw( 59) ! factorization frequency
      mSkip  = iw( 67) ! # largest allowable  nSkip

      eps    = rw(  1) ! unit round-off.
      eps0   = rw(  2) ! eps**(4/5)
      eps1   = rw(  3) ! eps**(2/3)
      xPen0  = rw( 89) ! initial penalty parameter.

      overfl = .false.
      nlnCon = nnCon  .gt. 0

      nBS    = m + nS
      nnL0   = max(nnL, 1)
      sgnObj = minimz

      info(iQNtyp) = 0
      info(iModfy) = 0

      neH    = 0
      lenH   = 1
      ydx    = zero

*     ---------------------------------------------------------------
*     Compute  dx = x1 - x  and  dg = gL1 - gL.
*     Compute the approx. curvature ydx and new scale factor H0. 
*     ---------------------------------------------------------------
      call dcopy ( nnL,         x1, 1, dx, 1 )
      call daxpy ( nnL, (-one), x , 1, dx, 1 )
      call dscal ( nnL, step, Hdx, 1 )
      dxHdx   = dxHdx*step*step

      if (nnObj .gt. 0) then
         call dcopy ( nnObj,         Gobj1, 1, dg, 1 )
         call daxpy ( nnObj, (-one), Gobj , 1, dg, 1 )
         if (minimz .lt. 0) call dscal ( nnObj, sgnObj, dg, 1 )
      end if

      nzero = nnL - nnObj
      if (nzero .gt. 0) call dload ( nzero, zero, dg(nnObj+1), 1 )

      if (nnCon  .gt. 0) then
         call s8Gprd( Transp, eps0, 
     &        ne, nlocJ, locJ, indJ, neG, nlocG, locG, Gcon1, 
     &        (-one), Lmul1, nnCon, one, dg, nnJac )
         call s8Gprd( Transp, eps0,
     &        ne, nlocJ, locJ, indJ, neG, nlocG, locG, Gcon, 
     &          one , Lmul1, nnCon, one, dg, nnJac )
      end if
      ydx  = ddot ( nnL, dg, 1, dx, 1 )

      sNorm = dnrm2 ( nnL, dx, 1 )
      H0ii  = ddiv  ( abs(ydx), (sNorm*sNorm), overfl )
      H0ii  = sgnObj*min( max( H0ii, H0min ), H0max ) 

      if (nMajor .gt. 1) then
*        ===============================================================
*        Except on the first iteration, attempt a BFGS update.
*        Compute the smallest allowable curvature.
*        If the update cannot be done, s7Hnew attempts to find a
*        modified update using  dx = x1 - x defined with a new x.
*        Arrays Fcon, Gcon and Gobj must be redefined at the new x.
*        ===============================================================
         PenUnm = zero
         ydxmin = tolg*dxHdx
         updatd =  dxHdx .gt. zero   .and. 
     &             ( ydx .ge. ydxmin  .or.   ydx .ge. eps1)

         if (nlnCon  .and. .not. updatd) then

*           minlen = .true.
            minlen = .false.

            if ( minlen ) then
*              ---------------------------------------------------------
*              Find an approximation to the feasible point minimizing 
*              the two-norm of (xQP - x).
*              Try and limit the number new superbasics by limiting the
*              number of changes to the working set. 
*              We keep a separate count of the PP QP iterations.
*              dg(nnL) temporarily holds the PP QP gradient.
*              ---------------------------------------------------------
               lEmode     = 1   ! Allow elastic mode.
               iw(MnrHdg) = 0

               if ( Elastc ) then
                  lvlInf = 1
               else
                  lvlInf = 0
               end if

               nObjPP = 0       ! No linear term for PP problem.
               nObjP0 = 1
               iObjPP = 0
               mxitPP = 1       ! Only one iteration should be required. 
               nnPP   = nnL
               nnPP0  = max( nnL, 1 )
 
               minmPP = 1
               ObjAPP = zero
               tolQPP = 1.0d-3  ! Sloppy optimality tolerance for QPP.

               gotR   = .false.
               needLU = .false.
               typeLU = BT

*              Save the number of WS changes.

               mWSsve = iw( 95) ! # of working set changes
               iw(95) = 20

               contyp = 'norm(x-x0) problem  '
               needx  = .false.
               subopt = Yes

               call s5QP  ( QPP, contyp, Elastc, iError, subopt,
     &              s8PPHx, s8PPHx, Mnrlog, gotR, needLU, typeLU, needx,
     &              lenR, m, maxS, mBS, n, nb, nDegen, Hcalls,
     &              nnPP0, nnPP, nObjP0, nObjPP, nnPP0, nnPP, nS,
     &              mxitPP, itQP, itn, lEmode, lvlInf, MnrPrt,
     &              minmPP, iObjPP, sclObj, ObjAPP, ObjPP, 
     &              tolFP, tolQPP, tolx, nInf, sInf, wtInf,
     &              piNorm, rgNorm, ne, nlocJ, locJ, indJ, Jcol,
     &              iHvar, jHvar, lenH, neH, H,
     &              hElast, hEstat, hfeas, hs, kBS,
     &              Ascale, bl, bu, blBS, buBS,
     &              gBS, Gobj, dg, Hdx, y3, pi, R, rc, rg, 
     &              nnCon0, nnCon, QPrhs, nnL0, nnL, x, xQP, xBS, xQP0,
     &              iy, iy1, y, y1, y2,
     &              cw, lencw, iw, leniw, rw, lenrw,
     &              cw, lencw, iw, leniw, rw, lenrw )
               iw(95) = mWSsve

               if (iError .gt. 0) go to 999
               call dcopy ( nb, xQP, 1, xQP0, 1 )
            end if ! minlen

*           ------------------------------------------------------------
*           Redefine  x, dx, Hdx and dg.
*           The problem functions are recomputed at x. 
*           ------------------------------------------------------------
            call s8x1 ( fgwrap, fgcon, fgobj, useFD, Hcalls,
     &           n, nb, nnCon0, nnCon, nnJac, nnObj, nnL,
     &           minimz, step, dxHdx, ydx,
     &           Fobj, Fcon, Gcon, Gobj, Gcon1, Gobj1,
     &           ne, nlocJ, locJ, indJ, neG, nlocG, locG, 
     &           dx, dg, Hdx, Lmul1, y1, y2, x, xQP0, y,
     &           cu, lencu, iu, leniu, ru, lenru, 
     &           cw, lencw, iw, leniw, rw, lenrw )
  
            ydxmin = tolg*dxHdx

            updatd =  dxHdx .gt. zero    .and. 
     &                ( ydx .ge. ydxmin  .or.   ydx .ge. eps1)

            if ( updatd ) then
               info(iModfy) = 1
            end if

            if (.not. updatd  .and.  dxHdx .gt. zero  ) then
*              ---------------------------------------------------------
*              If all else fails, attempt to update the Hessian of
*              the augmented Lagrangian.
*              The target ydx is defined via tolg2.
*              ---------------------------------------------------------
               ydxmin = tolg2*dxHdx
               call s8Hfix( nnCon, nnJac, eps0,
     &              ne, nlocJ, locJ, indJ, neG, nlocG, locG, 
     &              ydx, ydxmin, PenUnm, Fcon, Fcon1, Gcon, Gcon1,
     &              dx, dg, y, y1, y2 )

               updatd = ydx .ge. ydxmin

               if ( updatd ) then
                  info(iModfy) = 2
               end if
            end if
         end if ! nlnCon

         if ( updatd ) then
*           ------------------------------------------------------------
*           Update the approximate Hessian using (dg,Hdx).
*           If there are no nonlinear constraints,  apply the update
*           to the reduced Hessian.
*           ------------------------------------------------------------
            nSkip = 0

            if (ydx .ge. ydxmin  .and.  Htype .eq. HNorml) then
               info(iQNtyp) = 1
            else
               info(iQNtyp) = 2
            end if

            call s8Hupd( info(iQNtyp), Htype, nnL, 
     &           H0ii, H0scal, ydx, dxHdx, sgnObj, Hdx, dg,
     &           iw, leniw, rw, lenrw )

            gotR =  nnCon .eq. 0  .and.  nS     .gt. 0
     &                            .and.  Htype  .eq. HNorml
     &                            .and.  RtRmod .lt. kfac 

            if ( gotR ) then 
               call s6Rupd( info(iQNtyp), lenR, m, n, nBS, nnL, nS,
     &              H0scal, ydx, dxHdx,
     &              ne, nlocJ, locJ, indJ, Jcol,
     &              kBS, dg, Hdx, R, y3, y, y2,
     &              iw, leniw, rw, lenrw )
               RtRmod = RtRmod + 1
            else
               RtRmod = 0
            end if
         else
*           ------------------------------------------------------------
*           No suitable update pair (dg,Hdx) could be found.
*           Skip the update.  Too many skips and we reset.
*           ------------------------------------------------------------
            nSkip  = nSkip  + 1            
               
*           Apply all updates to H and discard the off-diagonals.

            if (mod( nSkip, mSkip  ) .eq. 0) then
               call s8H0  ( Htype, nnL, H0ii, iw, leniw, rw, lenrw )

               if (mod( nSkip, mGap*mSkip ) .eq. 0) then
*                 ------------------------------------------------------
*                 Reset the multipliers and penalty parameters
*                 ------------------------------------------------------
                  incRun = .true.
                  PenDmp = one
                  PenMax = one / eps
                  call dload ( nnCon, xPen0, xPen , 1 )
                  call dload ( nnCon, zero , Lmul1, 1 )
               end if
            end if
         end if
      end if ! nMajor > 1

  999 return

      end ! of s8HQN

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8Hwrp( Hprod, Hcalls, nnH,
     &     iHvar, jHvar, lenH, neH, H, x, Hx, Status, 
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      external
     &     Hprod
      integer
     &     Status, Hcalls, neH, nnH, lenH, lencu, leniu, lenru,
     &     lencw, leniw, lenrw, iHvar(lenH), jHvar(lenH),
     &     iu(leniu), iw(leniw)
      double precision
     &     H(lenH), Hx(nnH), x(nnH), ru(lenru), rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     s8Hwrp wraps Hprod, which multiplies the QP Hessian H by the
*     vector  x.   It is called by the QP solver.
*
*     On entry:
*        Status  = 0  => a normal call for H*x.
*        Status  = 1  => the first entry for a given QP.
*        Status ge 2  => last call for a given QP. Status = 2+iError.
*
*     On exit:
*        Status lt 0   the user wants to stop.
*
*     03 Nov 2000: First version of s8Hwrp.
*     03 Nov 2000: Current version.
*     ==================================================================

      call Hprod( Hcalls, nnH, x, Hx,
     &     cw, lencw, iw, leniw, rw, lenrw )

      end ! of s8Hwrp

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8Hx( Hcalls, nnH, x, Hx, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     Hcalls, nnH, lencw, leniw, lenrw, iw(leniw)
      double precision
     &     Hx(nnH), x(nnH), rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     s8Hx  multiplies the QP Hessian  H by the vector  x.
*     It is used to define Hx for the QP subproblem.
*
*
*     s8Hx calls one of the Hessian routines s9LMH, s9FMH, s9SDH, ... 
*     according to the value of the options lvlDer and lvlHes.
*     Each of these routines defines a particular form of the Hessian.
*     At the moment the options are:
*
*        lvlHes = LM      Limited-Memory (LM) BFGS  (the default).
*        lvlHes = FM      Full-Memory    (FM) BFGS
*        lvlHes = Exact   FD or exact Hessian 
*
*     30 Dec 1991: First version of s8Hx.
*     12 Jan 1996: Full memory Hessian option added.
*     04 Apr 1999: Exact and FD Hessian option added.
*     26 Oct 2000: Current version.
*     ==================================================================
      integer
     &     lvlHes, mQNmod, lH0, lgdSav, lHdSav, lydx, ldxHdx, lfH, lenfH
*     ------------------------------------------------------------------
      integer            LM    , FM
      parameter         (LM = 0, FM = 1) 
      integer            nQNmod
      parameter         (nQNmod = 201)
*     ------------------------------------------------------------------
      lvlHes    = iw( 72) ! LM, FM or Exact Hessian

      if      (lvlHes .eq. LM) then
*        -----------------------
*        Limited memory Hessian.
*        -----------------------
         mQNmod    = iw( 54) ! (ge 0) max # of BFGS updates

         lH0       = iw(346) ! Initial diagonal Hessian
         lgdSav    = iw(402) !
         lHdSav    = iw(403) !
         lydx      = iw(404) !
         ldxHdx    = iw(405) !

         call s9LMHx( nnH, x, Hx, mQNmod, iw(nQNmod),
     &        rw(lH0), rw(lgdSav), rw(lHdSav), rw(lydx), rw(ldxHdx) )

      else if (lvlHes .eq. FM) then
*        -----------------------
*        Full memory Hessian.
*        -----------------------
         lfH       = iw(391) !
         lenfH     = iw(392) !

         call s9FMHx( nnH, lenfH, rw(lfH), x, Hx )
      end if

      Hcalls = Hcalls + 1

      end ! of s8Hx

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8Hupd( Update, Htype, nnH,
     &     H0pre, H0scal, ydx, dxHdx, sgnObj, Hdx, y,
     &     iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     Update, Htype, nnH, leniw, lenrw, iw(leniw)
      double precision
     &     H0pre, H0scal, ydx, dxHdx, sgnObj, Hdx(nnH), y(nnH),
     &     rw(lenrw)

*     ==================================================================
*     s8Hupd  applies the pair of vectors that define the BFGS update
*     or self-scaled BFGS update.
*
*     On entry:
*
*     Hdx   contains H times the difference x2 - x1.
*
*     y     contains the gradient difference g2 - g.
*
*     s8Hupd calls one of the Hessian routines s9LMH, s9FMH, s9SDH, ... 
*     according to the value of the option lvlHes.
*     At the moment the options are:
*
*        lvlHes = LM      Limited-Memory (LM) BFGS  (the default).
*        lvlHes = FM      Full-Memory    (FM) BFGS
*        lvlHes = Exact   FD or exact Hessian 
*
*     19 Jul 1995: First version of s8Hupd written by PEG.
*     12 Jan 1996: Full-memory Hessian option added.
*     01 Jun 1999: Current version.
*     ==================================================================
      integer
     &     lvlHes, lenfH, mQNmod, lH0, lfH, lgdSav, lHdSav, lydx, ldxHdx
*     ------------------------------------------------------------------
      integer            LM    , FM
      parameter         (LM = 0, FM = 1)
      integer            nQNmod
      parameter         (nQNmod = 201) ! # of updates since last reset
*     ------------------------------------------------------------------
      lvlHes    = iw( 72) ! LM, FM or Exact Hessian

      if      (lvlHes .eq. LM) then
         mQNmod    = iw( 54) ! (ge 0) max # of BFGS updates
         lH0       = iw(346) ! Initial diagonal Hessian
         lgdSav    = iw(402) !
         lHdSav    = iw(403) !
         lydx      = iw(404) !
         ldxHdx    = iw(405) !

         call s9LMup( Update, Htype, nnH, mQNmod, iw(nQNmod),
     &        H0pre, H0scal, ydx, dxHdx, sgnObj, Hdx, y,
     &        rw(lH0), rw(lgdSav), rw(lHdSav), rw(lydx), rw(ldxHdx) )

      else if (lvlHes .eq. FM) then
         mQNmod    = iw( 54) ! (ge 0) max # of BFGS updates
         lfH       = iw(391) !
         lenfH     = iw(392) !

         call s9FMup( Update, Htype, lenfH, nnH, mQNmod, iw(nQNmod),
     &        H0pre, H0scal, ydx, dxHdx, sgnObj, Hdx, y, rw(lfH) )

      end if

      end ! of s8Hupd

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s8x1 ( fgwrap, fgcon, fgobj, useFD, Hcalls,
     &     n, nb, nnCon0, nnCon, nnJac, nnObj, nnL,
     &     minimz, step, dxHdx, ydx,
     &     Fobj, Fcon, Gcon, Gobj, Gcon1, Gobj1,
     &     ne, nlocJ, locJ, indJ, neG, nlocG, locG, 
     &     dx, dg, Hdx, Lmul1, tdx, tHdx, x, xQP0, y,
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )
      
      implicit
     &     none
      external
     &     fgwrap, fgcon, fgobj
      logical
     &     useFD
      integer
     &     Hcalls, minimz, n, nb, neG, ne, nlocJ, nnCon0, nnCon, nnJac,
     &     nnL, nnObj, nlocG, lencu, lencw, leniu, leniw, lenru,
     &     lenrw, locJ(nlocJ), indJ(ne), locG(nlocG),
     &     iu(leniu), iw(leniw)
      double precision
     &     dxHdx, step, ydx, dg(nnL), dx(nnL), Hdx(nnL), Lmul1(nnCon0), 
     &     Fobj, Fcon(nnCon0), Gcon(neG), Gobj(nnL), Gcon1(neG),
     &     Gobj1(nnL), tdx(nnL), tHdx(nnL), x(nnL), xQP0(nnL), y(nb),
     &     ru(lenru), rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     s8x1   redefines the quantities x and dx, Hdx and dg  used for the
*     quasi-Newton update.  The problem functions are recomputed at x. 
*     
*     The new  x1  is  x1 + step*(xQP0 - x1),  where xQP0 is a 
*     (nonelastic) feasible point from the QP subproblem.
*     
*     02 Dec 1994: First version of s8x1.
*     20 Jul 1998: s8x1 made self-contained
*     24 Aug 1998: Fixed bug found by Alan Brown at Nag.
*                  FD derivatives now computed correctly. 
*                  Parameter useFD added.
*     11 Oct 1998: Facility to combine funobj and funcon added.
*     09 Nov 2000: Current version of s8x1.
*     ==================================================================
      logical
     &     nlnCon, nlnObj
      integer
     &     iError, modefg, nzero, Status
      double precision
     &     ddot, dxHdx2, eps, eps0, sgnObj
*     ------------------------------------------------------------------
      integer            Transp
      parameter         (Transp = 1)
      double precision   zero,            one
      parameter         (zero  =  0.0d+0, one = 1.0d+0)
*     ------------------------------------------------------------------
      eps    = rw(  1) ! unit round-off.
      eps0   = rw(  2) ! eps**(4/5)

      nlnCon = nnCon  .gt. 0
      nlnObj = nnObj  .gt. 0

      sgnObj = minimz
      modefg = 2

      call dcopy ( nnL,  dx, 1,  tdx, 1 )
      call dcopy ( nnL, Hdx, 1, tHdx, 1 )

*     ------------------------------------------------------------
*     dx =  dx - step*y,  with  y = xQP0 - x
*     ------------------------------------------------------------
      call daxpy ( nnL, (-one ), x   , 1, xQP0, 1 )
      call daxpy ( nnL, (-step), xQP0, 1, tdx , 1 )

*     ------------------------------------------------------------
*     Compute the minimum curvature.
*     If nnL < n, dxHdx may be zero (or negative fuzz).
*     ------------------------------------------------------------
      call s8Hx( Hcalls, nnL, tdx, tHdx, 
     &     cw, lencw, iw, leniw, rw, lenrw )
      dxHdx2 = sgnObj*ddot  ( nnL, tdx, 1, tHdx, 1 )

      if (dxHdx2 .ge. eps) then
*        ---------------------------------------------------------
*        Redefine  x  as   x + step*(xQP0 - x).
*        Evaluate the functions at the new x.
*        ---------------------------------------------------------
         call daxpy ( nnL, step, xQP0, 1, x, 1 )

         Status = 0
         call fgwrap( modefg, iError, Status, nlnCon, nlnObj,
     &        n, neG, nnL, nnCon0, nnCon, nnJac, nnObj, 
     &        fgcon, fgobj,
     &        ne, nlocJ, locJ, indJ, 
     &        Fcon, Fobj, Gcon, Gobj, x, 
     &        cu, lencu, iu, leniu, ru, lenru, 
     &        cw, lencw, iw, leniw, rw, lenrw )

         if (iError .eq. 0  .and.  useFD) then
            call s6fd  ( iError, n, neG, nnL,
     &           nnCon0, nnCon, nnJac, nnObj,
     &           fgwrap, fgcon, fgobj,
     &           ne, nlocJ, locJ, indJ,
     &           Fcon, Fobj, Gcon, Gobj, x, y,
     &           cu, lencu, iu, leniu, ru, lenru, 
     &           cw, lencw, iw, leniw, rw, lenrw )
         end if

         if (ierror .eq. 0) then
*           ------------------------------------------------------------
*           The functions have been computed at x. 
*           ------------------------------------------------------------
            if (nnObj .gt. 0) then
               call dcopy ( nnObj,         Gobj1, 1, dg, 1 )
               call daxpy ( nnObj, (-one), Gobj , 1, dg, 1 )
               if (minimz .lt. 0) call dscal ( nnObj, sgnObj, dg, 1 )
            end if

            nzero = nnL - nnObj
            if (nzero .gt. 0) call dload ( nzero, zero, dg(nnObj+1), 1 )

            if (nnCon  .gt. 0) then
               call s8Gprd( Transp, eps0, 
     &              ne, nlocJ, locJ, indJ, neG, nlocG, locG, Gcon1, 
     &              (-one), Lmul1, nnCon, one, dg, nnJac )
               call s8Gprd( Transp, eps0,
     &              ne, nlocJ, locJ, indJ, neG, nlocG, locG, Gcon, 
     &              one , Lmul1, nnCon, one, dg, nnJac )
            end if

            dxHdx = dxHdx2
            call dcopy (  nnL, tdx , 1,  dx, 1 )
            call dcopy (  nnL, tHdx, 1, Hdx, 1 )
            ydx   = ddot ( nnL, dg, 1, dx, 1 )
         end if
      end if

      end ! of s8x1
