*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
*     File  sn95fmqn.f.   Full memory BFGS routines.
*
*     s9FMH0   s9FMup   s9FMHx
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s9FMH0( Htype, lenH, nnH, nQNmod, H0pre, H )

      implicit
     &     none
      integer
     &     Htype, lenH, nnH, nQNmod
      double precision
     &     H0pre, H(lenH)

*     ==================================================================
*     s9FMH0 resets the approximate Hessian H to a diagonal matrix.
*     If H is already diagonal it is set to the identity.
*     On entry, the value of Htype is as follows:
*
*       Htype 
*       -----
*       HUnset (-1)      H not set.
*       HNorml ( 0)      H is a Hessian of the form defined by  lvlHes.
*       HDiag  ( 1)      H is a diagonal matrix.
*       HUnit  ( 2)      H is an identity matrix.
*
*     19 Jul 1995: First version of s9FMH0 written by PEG.
*     06 Sep 1998: Pre- and post-QP diagonal Hessian scaling added.
*     07 Nov 2000: Current version.
*     ==================================================================
      integer
     &     incr, k, l, nzero
      double precision
     &     H0min, sclObj
*     ------------------------------------------------------------------
      integer            HNorml,     HDiag,      HUnit 
      parameter         (HNorml = 0, HDiag  = 1, HUnit  = 2)
      double precision   zero,             one
      parameter         (zero   =  0.0d+0, one    = 1.0d+0)
*     ------------------------------------------------------------------
      if (H0pre .ge. zero) then
         sclObj =   one
      else
         sclObj = - one
      end if


      if (Htype .eq. HNorml) then
*        ------------------------------------------------------------
*        Zero the off-diagonal elements H.
*        If the resulting  H  is indefinite, use  H = H0pre*I
*        ------------------------------------------------------------
         H0min = one
         l     = 1
         incr  = nnH
         nzero = nnH - 1

         do k = 1, nnH-1
            call dload ( nzero, zero, H(l+1), 1 )
            H0min = min(sclObj*H(l), H0min)
            l     = l     + incr
            incr  = incr  - 1
            nzero = nzero - 1
         end do
         H0min = min(sclObj*H(l), H0min)
         if (H0min .le. zero) Htype  = HUnit
      end if

      if (Htype .eq. HNorml) then
         Htype = HDiag
      else
*        ------------------------------------------------------------
*        Set H0 to a multiple of the identity.
*        ------------------------------------------------------------
         l     = 1
         incr  = nnH
         nzero = nnH - 1

         do k = 1, nnH-1
            H(l)  = H0pre
            call dload ( nzero, zero, H(l+1), 1 )
            l     = l     + incr
            incr  = incr  - 1
            nzero = nzero - 1
         end do
         H(l)  = H0pre
         Htype = HUnit
      end if

      nQNmod = 0

      end ! of s9FMH0

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s9FMup( Update, Htype, lenH, nnH, mQNmod, nQNmod, 
     &     H0pre, H0scal, ydx, dxHdx, sgnObj, Hdx, y, H )

      implicit
     &     none
      integer
     &     Update, Htype, lenH, nnH, mQNmod, nQNmod
      double precision
     &     H0pre, H0scal, ydx, dxHdx, sgnObj, Hdx(nnH), y(nnH), H(lenH)

*     ==================================================================
*     s9FMup does almost everything associated with the full-memory 
*     quasi-Newton update.
*     If defined, the self-scaling BFGS update parameter is saved.
*     It is needed to update the reduced Hessian when there are only
*     linear constraints.
*
*     19 Jul 1995: First version of s9FMup written by PEG.
*     06 Sep 1998: Pre- and post-QP diagonal Hessian scaling added.
*     24 Sep 1999: Current version.
*     ==================================================================
      integer
     &     i, j, l, numH
      double precision
     &     ydxI, dxHdxI, c1, c2
*     ------------------------------------------------------------------
      integer            HNorml
      parameter         (HNorml = 0)
      double precision   one
      parameter         (one = 1.0d+0)
*     ------------------------------------------------------------------
      ydxI   = one / (sgnObj*ydx)
      dxHdxI = one / (sgnObj*dxHdx)

      if (Update .gt. 1) then
         H0scal = ydx / dxHdx
         dxHdx  = dxHdx  / H0scal ! Saved for the LC case
         dxHdxI = dxHdxI * H0scal
         numH   = nnH*(nnH + 1)/2
         call dscal ( numH, H0scal, H, 1 )
      end if

      l = 0
      do i  = 1, nnH
         c1 = Hdx(i)*dxHdxI
         c2 =   y(i)*  ydxI
         do j    = i, nnH
            l    = l + 1
            H(l) = H(l) - c1*Hdx(j) + c2*y(j)
         end do
      end do

      if (nQNmod .ge. mQNmod) then

*        Reset  H  to a diagonal.

         call s9FMH0( Htype, lenH, nnH, nQNmod, H0pre, H )

         nQNmod = 0
      else
         nQNmod = nQNmod + 1
         Htype  = HNorml
      end if

      end ! of s9FMup

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine s9FMHx( n, lenH, H, x, Hx )

      implicit
     &     none
      integer
     &     n, lenH
      double precision
     &     H(lenH), Hx(n), x(n)

*     ==================================================================
*     s9FMHx  computes the product Hx, where the symmetric part of H is
*     stored by rows in the one-dimensional array  H.  Note that
*     lenH is used to define the length of H,  and must
*     be at least n*(n + 1)/2. 
*
*     12 Jan 1996: First version of s9FMHx
*     11 Sep 1999: Current version.
*     ==================================================================
      integer
     &     i, j, l
      double precision
     &     s, xj
*     ------------------------------------------------------------------
      double precision   zero
      parameter         (zero = 0.0d+0)
*     ------------------------------------------------------------------
      l = 0
      do i = 1, n
         s = zero
         do j = i, n
            l = l + 1
            s = s + H(l)*x(j)
         end do
         Hx(i) = s
      end do
      
      l = 0
      do j  = 1, n-1
         xj = x(j)
         l  = l + 1
         do i = j+1, n
            l     = l + 1
            Hx(i) = Hx(i) + H(l)*xj
         end do
      end do

      end ! of s9FMHx

