*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
*
*     File  sq02lib.f
*
*     sqtitl   sqInit   sqSpec   sqHx     sqMem    sqprnt 
*     sqset    sqseti   sqsetr   sqgetc   sqgeti   sqgetr
*
*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqtitl( title )

      character*30
     &     title

*     ==================================================================
*     sqtitl sets the title.
*     ==================================================================

       title  = 'S Q O P T  5.4-1(1) (Nov 2000)'
*---------------123456789|123456789|123456789|--------------------------

      end ! of sqtitl

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqInit( iPrint, iSumm, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     iPrint, iSumm, lencw, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     sqInit  is called by the user to do the following:
*     1. Open default files (Print, Summary).
*     2. Initialize title.
*     3. Set options to default values.
*
*     15 Nov 1991: First version.
*     14 Jul 1997: Thread-safe version.
*     21 Mar 1997: First version based on snopt routine snInit
*     14 Jul 1997: Thread-safe version.
*     02 Oct 1997: Character workspace added.
*     01 Nov 2000: Current version of sqInit.
*     ==================================================================
      integer
     &     iSpecs, lvlTim, nnCon, nnJac, nnObj, nnL,
     &     maxcu, maxcw, maxiu, maxiw, maxru, maxrw
      character*30
     &     title
      character*30
     &     dashes
      data        
     &     dashes /'=============================='/
*     ------------------------------------------------------------------
      parameter         (maxru     =   2) ! start of SNOPT part of rw
      parameter         (maxrw     =   3) ! end   of SNOPT part of rw
      parameter         (maxiu     =   4) ! start of SNOPT part of iw
      parameter         (maxiw     =   5) ! end   of SNOPT part of iw
      parameter         (maxcu     =   6) ! start of SNOPT part of cw
      parameter         (maxcw     =   7) ! end   of SNOPT part of cw
      parameter         (nnJac     =  21) ! # nonlinear Jac, variables
      parameter         (nnObj     =  22) ! # variables in Gobj
      parameter         (nnCon     =  23) ! nonlinear constraints
      parameter         (nnL       =  24) ! nonlinear vars
      parameter         (lvlTim    =  77) ! Timing level
*     ------------------------------------------------------------------

      if (lencw .lt. 500 .or. leniw .lt. 500 .or. lenrw .lt. 500) then 
*        ---------------------------------------------------------------
*        Not enough workspace to do ANYTHING!
*        ---------------------------------------------------------------
         if (iPrint .gt. 0) write(iPrint, 9000) 
         if (iSumm  .gt. 0) write(iSumm , 9000) 
         if (iPrint .le. 0  .and.  iSumm  .le. 0) then
            write(*, 9000)
         end if
         go to 999
      end if

      iSpecs    = 0

      iw( 11)   = iSpecs
      iw( 12)   = iPrint   ! Print file
      iw( 13)   = iSumm    ! Summary file

      iw(maxcu) = 500
      iw(maxiu) = 500
      iw(maxru) = 500
      iw(maxcw) = lencw
      iw(maxiw) = leniw
      iw(maxrw) = lenrw

*     These dimensions need to be initialized for an MPS run.

      iw(nnCon) = 0
      iw(nnJac) = 0
      iw(nnObj) = 0
      iw(nnL  ) = 0

      call sqtitl( title )
      call s1init( title, iw, leniw, rw, lenrw )

      if (iPrint .gt. 0) then
         write (iPrint, '(  9x, a )') ' ', dashes, title, dashes
      end if
      if (iSumm .gt. 0) then
         write (iSumm , '(  1x, a )') ' ', dashes, title, dashes
      end if

*     ------------------------------------------------------------------
*     Set the options to default values.
*     sqopt  will check the options later and maybe print them.
*     ------------------------------------------------------------------
      call s3undf( cw, lencw, iw, leniw, rw, lenrw )

*     ------------------------------------------------------------------
*     Initialize some global values.
*     ------------------------------------------------------------------
      iw(lvlTim) = 3

  999 return

 9000 format(  ' EXIT from sqInit --',
     &         ' character, integer and real work arrays',
     &         ' must each have at least 500 elements')

      end ! of sqInit

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqSpec( iSpecs, inform, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     iSpecs, inform, lencw, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     sqSpec  is called by the user to read the Specs file.
*
*     07 Feb 1998: First version.
*     01 Nov 2000: Current version of sqSpec.
*     ==================================================================
      external
     &     s3opt
      integer
     &     Calls, iPrint, iSumm
*     ------------------------------------------------------------------
      iw( 11)   = iSpecs

      iPrint    = iw( 12)
      iSumm     = iw( 13)

      inform    = 0
      Calls     = 1

*     ------------------------------------------------------------------
*     Read the Specs file.
*     sqopt  will check the options later and maybe print them.
*     ------------------------------------------------------------------
      if (iSpecs .gt. 0) then
         call s3file( Calls, iSpecs, s3opt,
     &        iPrint, iSumm, inform,
     &        cw, lencw, iw, leniw, rw, lenrw )
      end if

      end ! of sqSpec

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqHx  ( usrHx, Hcalls, nnH,
     &     iHvar, jHvar, lenH, neH, H, x, Hx, Status, 
     &     cu, lencu, iu, leniu, ru, lenru, 
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      external
     &     usrHx
      integer
     &     Status, neH, lenH, Hcalls, nnH, lencu, leniu, lenru, lencw,
     &     leniw, lenrw, iHvar(lenH), jHvar(lenH), iu(leniu), iw(leniw)
      double precision
     &     H(lenH), Hx(nnH), x(nnH), ru(lenru), rw(lenrw)
      character*8
     &     cu(lencu), cw(lencw)

*     ==================================================================
*     sqHx  computes the user-defined product  Hx  and scales it. 
*
*     15 Mar 1999: First   version of sqHx
*     26 Mar 2000: Current version
*     ==================================================================
      logical
     &     scaled
      integer
     &     lvlScl, lAscal, lxscal
*     ------------------------------------------------------------------
      lvlScl    = iw( 75) ! scale option
      lAscal    = iw(295) ! Ascale(nb)  = row and column scales
      lxscal    = iw(302) ! xscal(n)    = copy of scaled x(nnL)

      scaled    = lvlScl .gt. 0

      if ( scaled ) then
         call dcopy ( nnH, x         , 1, rw(lxscal), 1 )
         call ddscl ( nnH, rw(lAscal), 1, x         , 1 )
      end if

      call usrHx( nnH, x, Hx, Status,
     &     cu, lencu, iu, leniu, ru, lenru )

      if ( scaled ) then
         call dcopy ( nnH, rw(lxscal), 1, x , 1 )
         call ddscl ( nnH, rw(lAscal), 1, Hx, 1 )
      end if

      Hcalls = Hcalls + 1

      end ! of sqHx

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqMem ( m, n, ne,
     &     lenc, ncolH,
     &     mincw, miniw, minrw,
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      integer
     &     m, n, ne, lenc, ncolH, mincw, miniw, minrw,
     &     lencw, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     sqMem   estimates the memory requirements for sqopt,
*     using the values:
*        m    , n    , ne
*        lenc , ncolH     
*
*     These values are used to compute the minimum required storage:
*     mincw, miniw, minrw.
*
*     Note: 
*     1. All default parameters must be set before calling sqMem,
*        since some values affect the amount of memory required.
*
*     2. The arrays rw and iw hold  constants and work-space addresses.
*        They must have dimension at least 500.
*
*     3. This version of sqMem does not allow user accessible
*        partitions of cw, iw and rw.
*
*     01 May 1998: First version.
*     06 Nov 2000: Current version of sqMem.
*     ==================================================================
      integer
     &     iError, iPrint, iPrinx, iSumm, iSummx, lenR, llenrw, lleniw, 
     &     llencw, maxcw, maxiw, maxrw, maxR, maxS, nnCon, nnJac, nnObj 
*     ------------------------------------------------------------------
      integer            CheckO
      parameter         (CheckO = 0) 
*     ------------------------------------------------------------------
      iPrint  = iw( 12) ! Print file
      iSumm   = iw( 13) ! Summary file

      if (lencw .lt. 500 .or. leniw .lt. 500 .or. lenrw .lt. 500) then 
*        ---------------------------------------------------------------
*        Not enough workspace to do ANYTHING!
*        ---------------------------------------------------------------
         if (iPrint .gt. 0) write(iPrint, 9000) 
         if (iSumm  .gt. 0) write(iSumm , 9000) 
         if (iPrint .le. 0  .and.  iSumm  .le. 0) then
            write(*, 9000)
         end if
         go to 999
      end if

*     Error messages from s5Mem are suppressed.

      iPrinx  = 0
      iSummx  = 0

*     Assign fake values for lencw, leniw, lenrw.
*     This will force s5Mem to estimate the memory requirements.

      llenrw  = 500
      lleniw  = 500
      llencw  = 500

*     An obligatory call to sqInit has `undefined' all options.
*     Check the user-defined values and assign undefined values.
*     s5dflt needs various problem dimensions in iw.

      nnCon   = 0               ! Not used in sqopt
      nnObj   = 0               ! ditto
      nnJac   = 0               ! ditto

      iw( 15) = n     ! copy of the number of columns
      iw( 16) = m     ! copy of the number of rows
      iw( 17) = ne    ! copy of the number of nonzeros in Acol

      iw( 21) = nnJac ! # nonlinear Jacobian variables
      iw( 22) = nnObj ! # variables in Gobj
      iw( 23) = nnCon ! # of nonlinear constraints
 
      iw( 26) = lenc  ! length of QP constant vector
      iw( 27) = ncolH ! # QP Hessian columns
 
      call s5dflt( CheckO, cw, lencw, iw, leniw, rw, lenrw )

      mincw   = 501
      miniw   = 501
      minrw   = 501

      maxcw   = lencw
      maxiw   = leniw
      maxrw   = lenrw

      maxR    = iw( 52) ! max columns of R.
      maxS    = iw( 53) ! max # of superbasics

      lenR    = maxR*(maxR + 1)/2

      call s5Mem ( iError, iPrinx, iSummx,
     &     m, n, ne, lenc, ncolH, lenR, maxS,
     &     maxcw, maxiw, maxrw,
     &     llencw, lleniw, llenrw,
     &     mincw, miniw, minrw, iw )

  999 return

 9000 format(  ' EXIT from sqMem --',
     &         ' character, integer and real work arrays',
     &         ' must each have at least 500 elements')

      end ! of sqMem

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqprnt( Prob, contyp, 
     &     Elastc, gotR, prtFea, jstFea, ObjPhs,
     &     m, mBS, nS, jSq, jBr, jSr, jBSr,
     &     lines1, lines2,
     &     itn, kPrc, lvlInf, lPrint, 
     &     sgnObj, pivot, step, nInf, sInf, wtInf, 
     &     Obj, condHz, djqPrt, rgNorm, kBS, xBS,
     &     iw, leniw )

      implicit
     &     none
      character*20
     &     contyp
      logical
     &     Elastc, gotR, jstFea, prtFea, ObjPhs
      integer
     &     Prob, m, mBS, nS,jSq, jBr, jSr, jBSr, lines1, lines2,
     &     itn, kPrc, lvlInf, lPrint, nInf, kBS(mBS), leniw, iw(leniw)
      double precision
     &     sgnObj, pivot, step, sInf, wtInf, Obj,
     &     condHz, djqPrt, rgNorm, xBS(mBS)
 
*     ==================================================================
*     sqprnt prints the LP/QP iteration log.
*     Normally the only parameters used are nnH, nS and f.
*     The others are there to allow monitoring of various items for
*     experimental purposes.
*     mBS = m + maxS  .ge.  m + nS.
*
*     The print controls are as follows:
*
*     prnt0 is true if lPrint = 0.
*     For LP and QP, a brief log is output every  k  minor iterations,
*     where  k  is the log frequency.
*     For NLP, a brief log is output by s8log every major iteration.
*
*     prnt1 is true if lPrint > 0.
*     A fuller log is output every  k  minor iterations.
*
*     summ0 and summ1 are the same as prnt0 and prnt1, but are false
*     if there is no summary file.  summary frequency defines  k.
*
*     MnrHdg is  1  if a new heading is required for some reason other
*     than frequency (e.g., after a basis factorization).
*
*     The output consists of a number of ``sections'' of one line
*     summaries, with each section preceded by a header message.
*     lines1 and lines2 count the number of lines remaining to be
*     printed in each section of the 
*     print and summary files respectively.
*     They too may force a new heading.
*
*     01 Dec 1991: First version based on Minos routine m5log.
*     18 Apr 1999: Current version.
*     ==================================================================
      logical
     &     prtHdr, newSet, pHead, pLine, prnt1, summ1, long, PrntOK
      integer
     &     iPrint, iSumm, it, k, klog, kSumm, lenL, lenU, lprDbg, LUitn,
     &     nBS, ncp, MnrHdg, MjrHdg, MjrSum
      double precision
     &     sumObj         
*     ------------------------------------------------------------------
      integer
     &     mLine1,      mLine2
      parameter
     &    (mLine1 = 40, mLine2 = 10)
      double precision
     &     zero
      parameter
     &    (zero   = 0.0d+0)
      integer
     &     QP,    FPE,    FPS,    QPS
      parameter
     &    (QP =2, FPE =3, FPS =4, QPS =5)
      parameter         (MnrHdg    = 223) ! >0 => Mnr heading for iPrint
      parameter         (MjrHdg    = 224) ! >0 => Mjr heading for iPrint
      parameter         (MjrSum    = 225) ! >0 => Mjr heading for iSumm 
*     ------------------------------------------------------------------
      iPrint    = iw( 12) ! Print file
      iSumm     = iw( 13) ! Summary file
      klog      = iw( 61) ! log/print frequency
      kSumm     = iw( 62) ! Summary print frequency
      lprDbg    = iw( 85) ! > 0    => private debug print
      ncp       = iw(176) ! no. of LU compressions
      lenL      = iw(173) ! size of current  L
      lenU      = iw(174) ! size of current  U
      LUitn     = iw(215) ! itns since last factorize

      long      = nS         .gt. 0  .or.   Prob .eq. QP
     &                               .or.   Prob .eq. QPS
      prtHdr    = iw(MnrHdg) .gt. 0
      Prnt1     = iPrint     .gt. 0  .and.  lPrint .ge. 1  
      Summ1     = iSumm      .gt. 0  .and.  lPrint .ge. 1  

      it        = mod( itn, 100000 )

      if ( Prnt1 ) then
*        --------------------------------------
*        Terse line for the Print file.
*        --------------------------------------
         newset = lines1            .eq. 0
         pLine  = mod( itn, klog  ) .eq. 0
         pHead  = pLine   .and.  (prtHdr  .or.  newSet)

         if ( ObjPhs ) then
            if (nInf .eq. 0) then
               sumObj = Obj
            else
               sumObj = Obj + sgnObj*wtInf*sInf
            end if
         else
            sumObj = sInf
         end if

         if ( pHead ) then
            iw(MnrHdg) = 0
            lines1 = mline1
            if ( long ) then
               if ( gotR ) then
                  write(iPrint, 1010)
               else
                  write(iPrint, 1011)
               end if
            else
               write(iPrint, 1000)
            end if
         end if

         if ( pline ) then
            iw(MjrHdg) = 1
            lines1 = lines1 - 1

            if ( long ) then 
               if ( gotR ) then
                  write(iPrint, 1200) it, kPrc, djqPrt, 
     &                                jSq, jSr, jBr, jBSr, step, pivot, 
     &                                nInf, sumObj, lenL, lenU, ncp,
     &                                rgnorm, nS, condHz
               else
                  write(iPrint, 1200) it, kPrc, djqPrt, 
     &                                jSq, jSr, jBr, jBSr, step, pivot, 
     &                                nInf, sumObj, lenL, lenU, ncp,
     &                                rgnorm, nS
               end if
            else
               write(iPrint, 1200) it, kPrc, djqPrt, 
     &                             jSq, jSr, jBr, jBSr, step, pivot,
     &                             nInf, sumObj, lenL, lenU, ncp
            end if
         end if
      end if

      if ( Summ1 ) then
*        --------------------------------
*        Terse line for the Summary file.
*        --------------------------------
         newset = lines2            .eq. 0
         pLine  = mod( itn, kSumm ) .eq. 0
         pHead  = pLine   .and.  newSet

         if ( ObjPhs ) then
            if (nInf .eq. 0) then
               sumObj = Obj
            else
               sumObj = Obj + sgnObj*wtInf*sInf
            end if
         else
            sumObj = zero
         end if

         if ( pHead ) then
            lines2 = mline2
            if ( long ) then
               if (lvlInf .ne. 1) then
                  write(iSumm , 2010)
               else
                  write(iSumm , 2011)
               end if
            else
               if (lvlInf .ne. 1) then
                  write(iSumm , 2000)
               else
                  write(iSumm , 2001)
               end if
            end if
         end if

         if ( pLine ) then
            iw(MjrSum) = 1
            lines2 = lines2 - 1
            if ( long ) then
               write(iSumm , 2200) it, djqPrt, step, nInf, 
     &                             sInf, sumObj, rgnorm,  nS
            else
               write(iSumm , 2200) it, djqPrt, step, nInf, 
     &                             sInf, sumObj
            end if
         end if
      end if

*     ------------------------------------------------------------------
*     If we are newly feasible, print something.
*     Suppress printing when solving one of a sequence of QP problems.
*     ------------------------------------------------------------------
      if ( jstFea ) then
         PrntOK = lPrint .ge. 1  .and. (LUitn  .gt. 0  .or.   prtFea)
     &                           .and.  Prob .ne. QPS
     &                           .and.  Prob .ne. FPS

*        contyp = 'QP problem'
*        contyp = 'LP problem'
*        contyp = 'QP subproblem'

         if ( PrntOK ) then
            if (.not. Elastc) then

*              All constraints are feasible in Normal mode.
*              Print a message if it is not done elsewhere.

               if (lPrint .ge. 1  .and.  Prob .ne. FPE) then
                  if (iPrint .gt. 0) write(iPrint, 8010) itn, contyp
                  if (iSumm  .gt. 0) write(iSumm , 8010) itn, contyp
               end if
            else

*              Elastic mode (the constraints are infeasible).
*              Elastic Phase 1 has completed.

               if (lvlInf .eq. 2) then

*                 Infinite weight on the infeasibilities.
*                 Proceed to minimize the infeasible elastics.

                  if (lPrint .ge. 1) then
                     if (iPrint .gt. 0) write(iPrint, 8030) itn
                     if (iSumm  .gt. 0) write(iSumm , 8030) itn
                  end if

               else if (lvlInf .eq. 1) then

*                 Finite nonzero weight on the infeasibilities.
*                 Proceed to minimize a weighted objective.

                  if (lPrint .ge. 1) then
                     if (iPrint .gt. 0) write(iPrint, 8040) itn
                     if (iSumm  .gt. 0) write(iSumm , 8040) itn
                  end if
               end if
            end if
         end if
      end if

*     ------------------------------------------------------------------
*     Debug output.
*     ------------------------------------------------------------------
      if (lprDbg .eq. 100) then
         nBS = m + nS
         write(iPrint, 5000) (kBS(k), xBS(k), k = 1, nBS)
      end if

      return

 1000 format(/ '   Itn', ' pp', '       dj', 
     &         '  +SBS  -SBS   -BS    -B',
     &         '    Step', '    Pivot', ' nInf',
     &         '  sInf,Objective', '     L     U ncp')
 1010 format(/ '   Itn', ' pp', '       dj',
     &         '  +SBS  -SBS   -BS    -B',
     &         '    Step', '    Pivot', ' nInf',
     &         '  sInf,Objective', '     L     U ncp',
     &         ' Norm rg   nS cond Hz'  )
 1011 format(/ '   Itn', ' pp', '       dj',
     &         '  +SBS  -SBS   -BS    -B',
     &         '    Step', '    Pivot', ' nInf',
     &         '  sInf,Objective', '     L     U ncp',
     &         ' Norm rg   nS'  )
 1200 format(1p, i6, i3, e9.1, 
     &           4i6, e8.1, e9.1, 
     &           i5, e16.8, 2i6, i4,
     &           e8.1, i5, e8.1 )

 2000 format(/ '   Itn', '       dj', '    Step', ' nInf', 
     &         '    SumInf', '       Objective' ) 
 2001 format(/ '   Itn', '       dj', '    Step', ' nInf', 
     &         '    SumInf', '   Composite Obj' ) 
 2010 format(/ '   Itn', '       dj', '    Step', ' nInf', 
     &         '    SumInf', '       Objective', ' Norm rg',
     &         '   nS' )
 2011 format(/ '   Itn', '       dj', '    Step', ' nInf', 
     &         '    SumInf', '   Composite Obj', ' Norm rg',
     &         '   nS' )
 2200 format(1p, i6, e9.1, e8.1, i5, e10.3, e16.8, e8.1, i5)

 5000 format(/ ' BS and SB values...' / (5(i7, g17.8)))

 8010 format(  ' Itn', i7, ': Feasible ', a)
 8030 format(  ' Itn', i7, ': Elastic Phase 2 -- minimizing',
     &                     ' elastic variables')
 8040 format(  ' Itn', i7, ': Elastic Phase 2 -- minimizing',
     &                     ' obj + weighted elastics')

      end ! of sqprnt

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqset ( buffer, iPrint, iSumm, inform,
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     iPrint, iSumm, inform, lencw, leniw, lenrw,
     &     iw(leniw)
      character*8
     &     cw(lencw)
      double precision
     &     rw(lenrw)

*     ==================================================================
*     sqset  decodes the option contained in  buffer.
*
*     The buffer is output to file iPrint, minus trailing blanks.
*     Error messages are output to files iPrint and iSumm.
*     Buffer is echoed to iPrint but normally not to iSumm.
*     It is echoed to iSumm before any error msg.
*
*     On entry,
*     iPrint is the print   file.  no output occurs if iPrint .le 0.
*     iSumm  is the Summary file.  no output occurs if iSumm  .le 0.
*     inform is the number of errors so far.
*
*     On exit,
*     inform is the number of errors so far.
*
*     27 Nov 1991: first version of sqset.
*     20 Sep 1998: current version.
*     ==================================================================
      integer
     &     ival
      double precision
     &     rval
      character*8
     &     cval
      character*16
     &     key
*     ------------------------------------------------------------------
      call s3opt ( .true., buffer, key, cval, ival, rval,
     &     iPrint, iSumm, inform,
     &     cw, lencw, iw, leniw, rw, lenrw )

      end ! of sqset

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqseti( buffer, ivalue, iPrint, iSumm, inform,
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     ivalue, iPrint, iSumm, inform, lencw, leniw, lenrw,
     &     iw(leniw)
      character*8
     &     cw(lencw)
      double precision
     &     rw(lenrw)

*     ==================================================================
*     sqseti decodes the option contained in  buffer // ivalue.
*     The parameters other than ivalue are as in sqset.
*
*     27 Nov 1991: first version of sqseti.
*     20 Sep 1998: current version.
*     ==================================================================
      integer
     &     ival, lenbuf
      double precision
     &     rval
      character*8
     &     cval
      character*16
     &     key
      character*72
     &     buff72
*     ------------------------------------------------------------------
      write(key, '(i16)') ivalue
      lenbuf = len(buffer)
      buff72 = buffer
      buff72(lenbuf+1:lenbuf+16) = key
      call s3opt ( .true., buff72, key, cval, ival, rval,
     &     iPrint, iSumm, inform,
     &     cw, lencw, iw, leniw, rw, lenrw )

      end ! of sqseti

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqsetr( buffer, rvalue, iPrint, iSumm, inform,
     &     cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     iPrint, iSumm, inform, lencw, leniw, lenrw,
     &     iw(leniw)
      double precision
     &     rvalue, rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     sqsetr decodes the option contained in  buffer // rvalue.
*     The parameters other than rvalue are as in sqset.
*
*     27 Nov 1991: first version of sqsetr.
*     20 Sep 1998: current version.
*     ==================================================================
      integer
     &     ival, lenbuf
      double precision
     &     rval
      character*8
     &     cval
      character*16
     &     key
      character*72
     &     buff72
*     ------------------------------------------------------------------
      write(key, '(1p, e16.8)') rvalue
      lenbuf = len(buffer)
      buff72 = buffer
      buff72(lenbuf+1:lenbuf+16) = key
      call s3opt ( .true., buff72, key, cval, ival, rval,
     &     iPrint, iSumm, inform,
     &     cw, lencw, iw, leniw, rw, lenrw )

      end ! of sqsetr

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqgetc( buffer, cvalue,
     &     inform, cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     inform, lencw, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)
      character*8
     &     cvalue, cw(lencw)

*     ==================================================================
*     sqgetc gets the value of the option contained in  buffer.
*     The parameters other than cvalue are as in sqset.
*
*     17 May 1998: first version of sqgetc.
*     20 Sep 1998: current version.
*     ==================================================================
      integer
     &     ival
      double precision
     &     rval
      character*16
     &     key
*     ------------------------------------------------------------------
      call s3opt ( .false., buffer, key, cvalue, ival, rval,
     &     0, 0, inform,
     &     cw, lencw, iw, leniw, rw, lenrw )

      end ! of sqgetc

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqgeti( buffer, ivalue,
     &     inform, cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     ivalue, inform, lencw, leniw, lenrw, iw(leniw)
      double precision
     &     rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     sqgeti gets the value of the option contained in  buffer.
*     The parameters other than ivalue are as in sqset.
*
*     17 May 1998: first version of sqgeti.
*     20 Sep 1998: current version.
*     ==================================================================
      double precision
     &     rval
      character*8
     &     cval
      character*16
     &     key
*     ------------------------------------------------------------------
      call s3opt ( .false., buffer, key, cval, ivalue, rval,
     &     0, 0, inform,
     &     cw, lencw, iw, leniw, rw, lenrw )

      end ! of sqgeti

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine sqgetr( buffer, rvalue,
     &     inform, cw, lencw, iw, leniw, rw, lenrw )

      implicit
     &     none
      character*(*)
     &     buffer
      integer
     &     inform, lencw, leniw, lenrw, iw(leniw)
      double precision
     &     rvalue, rw(lenrw)
      character*8
     &     cw(lencw)

*     ==================================================================
*     sqgetr gets the value of the option contained in  buffer.
*     The parameters other than rvalue are as in sqset.
*
*     17 May 1998: first version of sqgetr.
*     20 Sep 1998: current version.
*     ==================================================================
      integer
     &     ival
      character*8
     &     cval
      character*16
     &     key
*     ------------------------------------------------------------------
      call s3opt ( .false., buffer, key, cval, ival,
     &     rvalue, 0, 0, inform,
     &     cw, lencw, iw, leniw, rw, lenrw )

      end ! of sqgetr

*+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

      subroutine nullHx( nnH, x, Hx, Status, 
     &     cu, lencu, iu, leniu, ru, lenru )

      implicit
     &     none
      integer
     &     nnH, Status, lencu, leniu, lenru, iu(leniu)
      double precision
     &     x(nnH), Hx(nnH), ru(lenru)
      character*8
     &     cu(lencu)

*     ==================================================================
*     This is the dummy (empty) version of the routine qpHx.
*     It should never be called by SQOPT.
*     
*     Warn the user (on the standard output) that it has been called.
*     ==================================================================
      integer
     &     nOut
*     ------------------------------------------------------------------
      nOut = 6
      if (Status .eq. 1) then
         if (nOut .gt. 0) write(nOut, 1000)
      end if

      return

 1000 format(//
     &     ' XXX  The default (dummy) version of subroutine Hx',
     &     '     has been called. '
     &    /' XXX  A user-defined version is required when solving a QP')

      end ! of nullHx

